/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.ObjectArrayType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;

public final class DoubleArrayType
extends ObjectArrayType<Double> {
    DoubleArrayType() {
        super(Double[].class);
    }

    @Override
    public String stringOf(Double[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            if (x[i] == null) {
                sb.append(NULL_CHAR_ARRAY);
                continue;
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public Double[] valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        String[] strs = this.split(str);
        int len = strs.length;
        Double[] a = new Double[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = strs[i].length() == 4 && strs[i].equals(NULL_STRING) ? null : (Double)this.elementType.valueOf(strs[i]);
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, Double[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                IOUtil.write(writer, x[i]);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Double[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                writer.write(x[i]);
            }
            writer.write(']');
        }
    }
}

