/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Method;

public final class EnumType<T extends Enum<T>>
extends AbstractType<T> {
    public static final String ENUM = Enum.class.getSimpleName();
    private static final String NULL = "null";
    private final Class<T> enumType;
    private final BiMap<Number, T> numberEnum = new BiMap();
    private boolean isIntValue = false;
    private boolean isLongValue = false;
    private boolean hasNull = false;

    EnumType(String enumClassName) {
        this(enumClassName, false);
    }

    EnumType(String clsName, boolean isNumberValue) {
        super(isNumberValue ? clsName + "(true)" : clsName);
        this.enumType = ClassUtil.forClass(clsName);
        Method method = null;
        try {
            method = this.enumType.getMethod("intValue", new Class[0]);
            this.isIntValue = isNumberValue;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = this.enumType.getMethod("longValue", new Class[0]);
                this.isLongValue = isNumberValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Enum enumConstant : (Enum[])this.enumType.getEnumConstants()) {
            if (method == null) {
                this.numberEnum.put(enumConstant.ordinal(), enumConstant);
                continue;
            }
            try {
                Number intValue = (Number)method.invoke((Object)enumConstant, new Object[0]);
                this.numberEnum.put(intValue, enumConstant);
            }
            catch (Exception e) {
                throw N.toRuntimeException(e);
            }
        }
        try {
            this.hasNull = Enum.valueOf(this.enumType, NULL) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Class<T> clazz() {
        return this.enumType;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public String stringOf(T x) {
        return x == null ? null : ((Enum)x).name();
    }

    @Override
    public T valueOf(String str) {
        if (N.isNullOrEmpty(str) || !this.hasNull && NULL.equals(str)) {
            return null;
        }
        if (StringUtil.isAsciiDigtalInteger(str)) {
            if (this.isLongValue) {
                return this.valueOf(N.parseLong(str));
            }
            return this.valueOf(N.parseInt(str));
        }
        return Enum.valueOf(this.enumType, str);
    }

    public T valueOf(int value) {
        Enum result = (Enum)this.numberEnum.get(value);
        if (result == null && value != 0) {
            throw new IllegalArgumentException("No " + this.enumType.getName() + " for int value: " + value);
        }
        return (T)result;
    }

    public T valueOf(long value) {
        Enum result = (Enum)this.numberEnum.get(value);
        if (result == null && value != 0L) {
            throw new IllegalArgumentException("No " + this.enumType.getName() + " for int value: " + value);
        }
        return (T)result;
    }

    @Override
    public void writeCharacter(CharacterWriter writer, T x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else if (this.isIntValue) {
            writer.writeInt(this.numberEnum.getByValue(x).intValue());
        } else if (this.isLongValue) {
            writer.write(this.numberEnum.getByValue(x).longValue());
        } else {
            char ch;
            char c = ch = config == null ? (char)'\u0000' : config.getStringQuotation();
            if (ch == '\u0000') {
                writer.writeCharacter(((Enum)x).name());
            } else {
                writer.write(ch);
                writer.writeCharacter(((Enum)x).name());
                writer.write(ch);
            }
        }
    }
}

