/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Indexed;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class IndexedType<T>
extends AbstractType<Indexed<T>> {
    private final String declaringName;
    private final Class<Indexed<T>> typeClass = Indexed.class;
    private final Type<T> valueType;
    private final Type<?>[] parameterTypes;

    IndexedType(String valueTypeName) {
        super(IndexedType.getTypeName(valueTypeName, false));
        this.declaringName = IndexedType.getTypeName(valueTypeName, true);
        this.valueType = TypeFactory.getType(valueTypeName);
        this.parameterTypes = new Type[]{this.valueType};
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<Indexed<T>> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public String stringOf(Indexed<T> x) {
        return x == null ? null : Utils.jsonParser.serialize(N.asArray(x.index(), x.value()), Utils.jsc);
    }

    @Override
    public Indexed<T> valueOf(String str) {
        long index;
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        Object[] a = Utils.jsonParser.deserialize(Object[].class, str, Utils.jdc);
        long l = a[0] == null ? 0L : (index = a[0] instanceof Number ? ((Number)a[0]).longValue() : N.parseLong(a[0].toString()));
        Object value = a[1] == null ? null : (this.valueType.clazz().isAssignableFrom(a[1].getClass()) ? a[1] : N.convert(a[1], this.valueType));
        return Indexed.of(value, index);
    }

    @Override
    public void write(Writer writer, Indexed<T> x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            try {
                bw.write(91);
                bw.write(String.valueOf(x.longIndex()));
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.valueType.write(bw, x.value());
                bw.write(93);
                if (!isBufferedWriter) {
                    bw.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
                }
            }
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Indexed<T> x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            try {
                writer.write('[');
                writer.write(String.valueOf(x.longIndex()));
                writer.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.valueType.writeCharacter(writer, x.value(), config);
                writer.write(']');
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected static String getTypeName(String valueTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(Indexed.class) + "<" + TypeFactory.getType(valueTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(Indexed.class) + "<" + TypeFactory.getType(valueTypeName).name() + ">";
    }
}

