/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.N;
import java.util.Collection;
import java.util.Map;

public class ListMultimapType<K, E>
extends AbstractType<ListMultimap<K, E>> {
    private static final Class<?> typeClass = ListMultimap.class;
    private final String declaringName;
    private final Type<?>[] parameterTypes;
    private final JSONDeserializationConfig jdc;

    ListMultimapType(String keyTypeName, String valueTypeName) {
        super(ListMultimapType.getTypeName(typeClass, keyTypeName, valueTypeName, false));
        this.parameterTypes = new Type[]{TypeFactory.getType(keyTypeName), TypeFactory.getType(valueTypeName)};
        this.declaringName = ListMultimapType.getTypeName(typeClass, keyTypeName, valueTypeName, true);
        this.jdc = (JSONDeserializationConfig)((JSONDeserializationConfig)((JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setMapKeyType(this.parameterTypes[0])).setMapValueType(TypeFactory.getType("List<" + valueTypeName + ">"))).setElementType(this.parameterTypes[1]);
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<ListMultimap<K, E>> clazz() {
        return typeClass;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    @Override
    public String stringOf(ListMultimap<K, E> x) {
        return x == null ? null : Utils.jsonParser.serialize(x.toMap(), Utils.jsc);
    }

    @Override
    public ListMultimap<K, E> valueOf(String st) {
        if (N.isNullOrEmpty(st)) {
            return null;
        }
        Map map = Utils.jsonParser.deserialize(Map.class, st, this.jdc);
        ListMultimap multiMap = N.newListLinkedMultimap(N.initHashCapacity(map.size()));
        for (Map.Entry entry : map.entrySet()) {
            multiMap.putAll(entry.getKey(), (Collection)entry.getValue());
        }
        return multiMap;
    }

    protected static String getTypeName(Class<?> typeClass, String keyTypeName, String valueTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(typeClass) + "<" + TypeFactory.getType(keyTypeName).declaringName() + ", " + TypeFactory.getType(valueTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(typeClass) + "<" + TypeFactory.getType(keyTypeName).name() + ", " + TypeFactory.getType(valueTypeName).name() + ">";
    }
}

