/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class MapType<K, V, T extends Map<K, V>>
extends AbstractType<T> {
    private final String declaringName;
    private final Class<T> typeClass;
    private final Type<?>[] parameterTypes;
    private final JSONDeserializationConfig jdc;

    MapType(Class<T> typeClass, String keyTypeName, String valueTypeName) {
        super(MapType.getTypeName(typeClass, keyTypeName, valueTypeName, false));
        this.declaringName = MapType.getTypeName(typeClass.isInterface() ? typeClass : Map.class, keyTypeName, valueTypeName, true);
        this.typeClass = typeClass;
        this.parameterTypes = new Type[]{TypeFactory.getType(keyTypeName), TypeFactory.getType(valueTypeName)};
        this.jdc = (JSONDeserializationConfig)((JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setMapKeyType(this.parameterTypes[0])).setMapValueType(this.parameterTypes[1]);
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<T> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isSerializable() {
        return false;
    }

    @Override
    public Type.SerializationType getSerializationType() {
        return Type.SerializationType.MAP;
    }

    @Override
    public String stringOf(T x) {
        return x == null ? null : Utils.jsonParser.serialize(x, Utils.jsc);
    }

    @Override
    public T valueOf(String str) {
        return (T)(N.isNullOrEmpty(str) ? null : (Map)Utils.jsonParser.deserialize(this.typeClass, str, this.jdc));
    }

    @Override
    public void write(Writer writer, T x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            Utils.jsonParser.serialize(writer, x, Utils.jsc);
        }
    }

    protected static String getTypeName(Class<?> typeClass, String keyTypeName, String valueTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(typeClass) + "<" + TypeFactory.getType(keyTypeName).declaringName() + ", " + TypeFactory.getType(valueTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(typeClass) + "<" + TypeFactory.getType(keyTypeName).name() + ", " + TypeFactory.getType(valueTypeName).name() + ">";
    }
}

