/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.MutableType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;

public class MutableIntType
extends MutableType<MutableInt> {
    public static final String MUTABLE_INT = MutableInt.class.getSimpleName();

    protected MutableIntType() {
        super(MUTABLE_INT);
    }

    @Override
    public Class<MutableInt> clazz() {
        return MutableInt.class;
    }

    @Override
    public String stringOf(MutableInt x) {
        return x == null ? null : N.stringOf(x.intValue());
    }

    @Override
    public MutableInt valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : MutableInt.of(N.parseInt(str));
    }

    @Override
    public void write(Writer writer, MutableInt x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.intValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, MutableInt x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.writeInt(x.intValue());
        }
    }
}

