/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractArrayType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.BufferedJSONWriter;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public class ObjectArrayType<E>
extends AbstractArrayType<E[]> {
    protected final Class<E[]> typeClass;
    protected final Type<E> elementType;
    protected final JSONDeserializationConfig jdc;

    ObjectArrayType(Class<E[]> arrayClass) {
        super(ClassUtil.getCanonicalClassName(arrayClass));
        this.typeClass = arrayClass;
        this.elementType = TypeFactory.getType(arrayClass.getComponentType());
        this.jdc = (JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setElementType(this.typeClass.getComponentType());
    }

    @Override
    public Class<E[]> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<E> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isObjectArray() {
        return true;
    }

    @Override
    public boolean isSerializable() {
        return this.elementType.isSerializable();
    }

    @Override
    public String stringOf(E[] x) {
        if (x == null) {
            return null;
        }
        if (this.isSerializable()) {
            BufferedJSONWriter bw = Objectory.createBufferedJSONWriter();
            try {
                bw.write('[');
                int len = x.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    if (x[i] == null) {
                        bw.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    this.elementType.writeCharacter(bw, x[i], Utils.jsc);
                }
                bw.write(']');
                String i = bw.toString();
                return i;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                Objectory.recycle(bw);
            }
        }
        return Utils.jsonParser.serialize(x, Utils.jsc);
    }

    @Override
    public E[] valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : Utils.jsonParser.deserialize(this.typeClass, str, this.jdc);
    }

    @Override
    public void write(Writer writer, E[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            try {
                bw.write(91);
                int len = x.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    if (x[i] == null) {
                        bw.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    this.elementType.write(bw, x[i]);
                }
                bw.write(93);
                if (!isBufferedWriter) {
                    bw.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
                }
            }
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, E[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            try {
                writer.write('[');
                int len = x.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        writer.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    if (x[i] == null) {
                        writer.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    this.elementType.writeCharacter(writer, x[i], config);
                }
                writer.write(']');
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public E[] collection2Array(Collection<?> c) {
        if (c == null) {
            return null;
        }
        Object[] a = (Object[])N.newArray(this.typeClass.getComponentType(), c.size());
        int i = 0;
        for (Object e : c) {
            a[i++] = e;
        }
        return a;
    }

    @Override
    public <E2> Collection<E2> array2Collection(Collection<E2> resultCollection, E[] x) {
        if (N.isNullOrEmpty(x)) {
            return resultCollection;
        }
        Collection<E2> c = resultCollection;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            c.add(x[i]);
        }
        return resultCollection;
    }

    @Override
    public int hashCode(Object[] x) {
        return N.hashCode(x);
    }

    @Override
    public int deepHashCode(Object[] x) {
        return N.deepHashCode(x);
    }

    @Override
    public boolean equals(Object[] x, Object[] y) {
        return N.equals(x, y);
    }

    @Override
    public boolean deepEquals(Object[] x, Object[] y) {
        return N.deepEquals(x, y);
    }

    @Override
    public String toString(Object[] x) {
        if (x == null) {
            return NULL_STRING;
        }
        com.landawn.abacus.util.BufferedWriter bw = Objectory.createBufferedWriter();
        try {
            bw.write('[');
            Object[] a = x;
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    bw.write(ELEMENT_SEPARATOR);
                }
                if (a[i] == null) {
                    bw.write(NULL_CHAR_ARRAY);
                    continue;
                }
                bw.write(a[i].toString());
            }
            bw.write(']');
            String string = bw.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deepToString(Object[] x) {
        if (x == null) {
            return NULL_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append('[');
            Object[] a = x;
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                if (a[i] == null) {
                    sb.append(NULL_CHAR_ARRAY);
                    continue;
                }
                sb.append(TypeFactory.getType(a[i].getClass()).deepToString(a[i]));
            }
            sb.append(']');
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }
}

