/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.TypeAttrParser;

public final class ObjectType<T>
extends AbstractType<T> {
    public static final String OBJECT = Object.class.getSimpleName();
    private final Class<T> typeClass;
    private final boolean isGenericType;
    private final Type<?>[] parameterTypes;

    ObjectType() {
        this(Object.class);
    }

    protected ObjectType(Class<T> cls) {
        this(ClassUtil.getCanonicalClassName(cls), cls);
    }

    protected ObjectType(String typeName, Class<T> cls) {
        super(typeName);
        this.typeClass = cls;
        this.isGenericType = typeName.indexOf(60) > 0 && typeName.indexOf(62) > 0;
        TypeAttrParser attrs = TypeAttrParser.parse(typeName);
        this.parameterTypes = new Type[attrs.getTypeParameters().length];
        int len = this.parameterTypes.length;
        for (int i = 0; i < len; ++i) {
            this.parameterTypes[i] = TypeFactory.getType(attrs.getTypeParameters()[i]);
        }
    }

    @Override
    public Class<T> clazz() {
        return this.typeClass;
    }

    @Override
    public boolean isGenericType() {
        return this.isGenericType;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isSerializable() {
        return false;
    }

    @Override
    public String stringOf(T x) {
        if (x == null) {
            return null;
        }
        Type<T> realType = TypeFactory.getType(x.getClass());
        return realType instanceof ObjectType ? x.toString() : realType.stringOf(x);
    }

    @Override
    public T valueOf(String str) {
        return (T)str;
    }
}

