/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractOptionalType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.u;
import java.io.IOException;
import java.io.Writer;

public class OptionalType<T>
extends AbstractOptionalType<u.Optional<T>> {
    public static final String OPTIONAL = u.Optional.class.getSimpleName();
    private final String declaringName;
    private final Type<T>[] parameterTypes;
    private final Type<T> elementType;

    protected OptionalType(String parameterTypeName) {
        super(OPTIONAL + "<" + TypeFactory.getType(parameterTypeName).name() + ">");
        this.declaringName = OPTIONAL + "<" + TypeFactory.getType(parameterTypeName).declaringName() + ">";
        this.parameterTypes = new Type[]{TypeFactory.getType(parameterTypeName)};
        this.elementType = this.parameterTypes[0];
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<u.Optional<T>> clazz() {
        return u.Optional.class;
    }

    @Override
    public Type<T> getElementType() {
        return this.elementType;
    }

    @Override
    public Type<T>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isOptionalOrNullable() {
        return true;
    }

    @Override
    public String stringOf(u.Optional<T> x) {
        return x == null || !x.isPresent() ? null : N.stringOf(x.get());
    }

    @Override
    public u.Optional<T> valueOf(String str) {
        return str == null ? u.Optional.empty() : u.Optional.ofNullable(this.elementType.valueOf(str));
    }

    @Override
    public void write(Writer writer, u.Optional<T> x) throws IOException {
        if (x == null || !x.isPresent()) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            N.typeOf(x.get().getClass()).write(writer, x.get());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, u.Optional<T> x, SerializationConfig<?> config) throws IOException {
        if (x == null || !x.isPresent()) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            N.typeOf(x.get().getClass()).writeCharacter(writer, x.get(), config);
        }
    }
}

