/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractPrimitiveArrayType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public final class PrimitiveBooleanArrayType
extends AbstractPrimitiveArrayType<boolean[]> {
    public static final String BOOLEAN_ARRAY = boolean[].class.getSimpleName();
    private final Type<Boolean> elementType = TypeFactory.getType(Boolean.TYPE);

    PrimitiveBooleanArrayType() {
        super(BOOLEAN_ARRAY);
    }

    @Override
    public Class<boolean[]> clazz() {
        return boolean[].class;
    }

    @Override
    public Type<Boolean> getElementType() {
        return this.elementType;
    }

    @Override
    public String stringOf(boolean[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public boolean[] valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        String[] strs = this.split(str);
        int len = strs.length;
        boolean[] a = new boolean[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = this.elementType.valueOf(strs[i]);
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, boolean[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                writer.write(x[i] ? TRUE_CHAR_ARRAY : FALSE_CHAR_ARRAY);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, boolean[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                writer.write(x[i] ? TRUE_CHAR_ARRAY : FALSE_CHAR_ARRAY);
            }
            writer.write(']');
        }
    }

    @Override
    public boolean[] collection2Array(Collection<?> c) {
        if (c == null) {
            return null;
        }
        boolean[] a = new boolean[c.size()];
        int i = 0;
        for (Object e : c) {
            a[i++] = (Boolean)e;
        }
        return a;
    }

    @Override
    public <E> Collection<E> array2Collection(Collection<E> resultCollection, boolean[] x) {
        if (N.isNullOrEmpty(x)) {
            return resultCollection;
        }
        Collection<Boolean> c = resultCollection;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            c.add(x[i]);
        }
        return resultCollection;
    }

    @Override
    public int hashCode(boolean[] x) {
        return N.hashCode(x);
    }

    @Override
    public boolean equals(boolean[] x, boolean[] y) {
        return N.equals(x, y);
    }
}

