/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractPrimitiveArrayType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public final class PrimitiveByteArrayType
extends AbstractPrimitiveArrayType<byte[]> {
    public static final String BYTE_ARRAY = byte[].class.getSimpleName();
    private final Type<Byte> elementType = TypeFactory.getType(Byte.TYPE);

    PrimitiveByteArrayType() {
        super(BYTE_ARRAY);
    }

    @Override
    public Class<byte[]> clazz() {
        return byte[].class;
    }

    @Override
    public Type<Byte> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isPrimitiveByteArray() {
        return true;
    }

    @Override
    public String stringOf(byte[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public byte[] valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        String[] strs = this.split(str);
        int len = strs.length;
        byte[] a = new byte[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = this.elementType.valueOf(strs[i]);
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, byte[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                IOUtil.write(writer, x[i]);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, byte[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                writer.write(x[i]);
            }
            writer.write(']');
        }
    }

    @Override
    public byte[] collection2Array(Collection<?> c) {
        if (c == null) {
            return null;
        }
        byte[] a = new byte[c.size()];
        int i = 0;
        for (Object e : c) {
            a[i++] = (Byte)e;
        }
        return a;
    }

    @Override
    public <E> Collection<E> array2Collection(Collection<E> resultCollection, byte[] x) {
        if (N.isNullOrEmpty(x)) {
            return resultCollection;
        }
        Collection<Byte> c = resultCollection;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            c.add(x[i]);
        }
        return resultCollection;
    }

    @Override
    public int hashCode(byte[] x) {
        return N.hashCode(x);
    }

    @Override
    public boolean equals(byte[] x, byte[] y) {
        return N.equals(x, y);
    }
}

