/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractPrimitiveArrayType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public final class PrimitiveCharArrayType
extends AbstractPrimitiveArrayType<char[]> {
    public static final String CHAR_ARRAY = char[].class.getSimpleName();
    private static Type<Character> elementType;

    PrimitiveCharArrayType() {
        super(CHAR_ARRAY);
        elementType = TypeFactory.getType(Character.TYPE);
    }

    @Override
    public Class<char[]> clazz() {
        return char[].class;
    }

    @Override
    public Type<Character> getElementType() {
        return elementType;
    }

    @Override
    public String stringOf(char[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append("'");
            sb.append(x[i]);
            sb.append("'");
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public char[] valueOf(String str) {
        char[] a;
        block6: {
            if (N.isNullOrEmpty(str)) {
                return null;
            }
            String[] strs = this.split(str);
            int len = strs.length;
            a = new char[len];
            if (len <= 0) break block6;
            boolean isQuoted = false;
            if (strs[0].length() > 1 && (strs[0].charAt(0) == '\'' || strs[0].charAt(0) == '\"')) {
                isQuoted = true;
            }
            if (isQuoted) {
                for (int i = 0; i < len; ++i) {
                    a[i] = elementType.valueOf(strs[i].substring(1, strs[i].length() - 1)).charValue();
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    a[i] = elementType.valueOf(strs[i]).charValue();
                }
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, char[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                writer.write(x[i]);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, char[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            char charQuotation = config == null ? (char)'\u0000' : config.getCharQuotation();
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (charQuotation > '\u0000') {
                    writer.write(charQuotation);
                    writer.writeCharacter(x[i]);
                    writer.write(charQuotation);
                    continue;
                }
                writer.writeCharacter(x[i]);
            }
            writer.write(']');
        }
    }

    @Override
    public char[] collection2Array(Collection<?> c) {
        if (c == null) {
            return null;
        }
        char[] a = new char[c.size()];
        int i = 0;
        for (Object e : c) {
            a[i++] = ((Character)e).charValue();
        }
        return a;
    }

    @Override
    public <E> Collection<E> array2Collection(Collection<E> resultCollection, char[] x) {
        if (N.isNullOrEmpty(x)) {
            return resultCollection;
        }
        Collection<Character> c = resultCollection;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            c.add(Character.valueOf(x[i]));
        }
        return resultCollection;
    }

    @Override
    public int hashCode(char[] x) {
        return N.hashCode(x);
    }

    @Override
    public boolean equals(char[] x, char[] y) {
        return N.equals(x, y);
    }

    @Override
    public String toString(char[] x) {
        if (x == null) {
            return NULL_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }
}

