/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractPrimitiveArrayType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public final class PrimitiveDoubleArrayType
extends AbstractPrimitiveArrayType<double[]> {
    public static final String DOUBLE_ARRAY = double[].class.getSimpleName();
    private static Type<Double> elementType;

    PrimitiveDoubleArrayType() {
        super(DOUBLE_ARRAY);
        elementType = TypeFactory.getType(Double.TYPE);
    }

    @Override
    public Class<double[]> clazz() {
        return double[].class;
    }

    @Override
    public Type<Double> getElementType() {
        return elementType;
    }

    @Override
    public String stringOf(double[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public double[] valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        String[] strs = this.split(str);
        int len = strs.length;
        double[] a = new double[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = elementType.valueOf(strs[i]);
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, double[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                IOUtil.write(writer, x[i]);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, double[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                writer.write(x[i]);
            }
            writer.write(']');
        }
    }

    @Override
    public double[] collection2Array(Collection<?> c) {
        if (c == null) {
            return null;
        }
        double[] a = new double[c.size()];
        int i = 0;
        for (Object e : c) {
            a[i++] = (Double)e;
        }
        return a;
    }

    @Override
    public <E> Collection<E> array2Collection(Collection<E> resultCollection, double[] x) {
        if (N.isNullOrEmpty(x)) {
            return resultCollection;
        }
        Collection<Double> c = resultCollection;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            c.add(x[i]);
        }
        return resultCollection;
    }

    @Override
    public int hashCode(double[] x) {
        return N.hashCode(x);
    }

    @Override
    public boolean equals(double[] x, double[] y) {
        return N.equals(x, y);
    }
}

