/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractPrimitiveArrayType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public final class PrimitiveFloatArrayType
extends AbstractPrimitiveArrayType<float[]> {
    public static final String FLOAT_ARRAY = float[].class.getSimpleName();
    private static Type<Float> elementType;

    PrimitiveFloatArrayType() {
        super(FLOAT_ARRAY);
        elementType = TypeFactory.getType(Float.TYPE);
    }

    @Override
    public Class<float[]> clazz() {
        return float[].class;
    }

    @Override
    public Type<Float> getElementType() {
        return elementType;
    }

    @Override
    public String stringOf(float[] t) {
        if (t == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = t.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(t[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public float[] valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        String[] strs = this.split(str);
        int len = strs.length;
        float[] a = new float[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = elementType.valueOf(strs[i]).floatValue();
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, float[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                IOUtil.write(writer, x[i]);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, float[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                writer.write(x[i]);
            }
            writer.write(']');
        }
    }

    @Override
    public float[] collection2Array(Collection<?> c) {
        if (c == null) {
            return null;
        }
        float[] a = new float[c.size()];
        int i = 0;
        for (Object e : c) {
            a[i++] = ((Float)e).floatValue();
        }
        return a;
    }

    @Override
    public <E> Collection<E> array2Collection(Collection<E> resultCollection, float[] x) {
        if (N.isNullOrEmpty(x)) {
            return resultCollection;
        }
        Collection<Float> c = resultCollection;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            c.add(Float.valueOf(x[i]));
        }
        return resultCollection;
    }

    @Override
    public int hashCode(float[] x) {
        return N.hashCode(x);
    }

    @Override
    public boolean equals(float[] x, float[] y) {
        return N.equals(x, y);
    }
}

