/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractPrimitiveArrayType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public final class PrimitiveIntArrayType
extends AbstractPrimitiveArrayType<int[]> {
    public static final String INT_ARRAY = int[].class.getSimpleName();
    private static Type<Integer> elementType;

    PrimitiveIntArrayType() {
        super(INT_ARRAY);
        elementType = TypeFactory.getType(Integer.TYPE);
    }

    @Override
    public Class<int[]> clazz() {
        return int[].class;
    }

    @Override
    public Type<Integer> getElementType() {
        return elementType;
    }

    @Override
    public String stringOf(int[] t) {
        if (t == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = t.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(t[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public int[] valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        String[] strs = this.split(str);
        int len = strs.length;
        int[] a = new int[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = elementType.valueOf(strs[i]);
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, int[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                IOUtil.write(writer, x[i]);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, int[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                writer.writeInt(x[i]);
            }
            writer.write(']');
        }
    }

    @Override
    public int[] collection2Array(Collection<?> c) {
        if (c == null) {
            return null;
        }
        int[] a = new int[c.size()];
        int i = 0;
        for (Object e : c) {
            a[i++] = (Integer)e;
        }
        return a;
    }

    @Override
    public <E> Collection<E> array2Collection(Collection<E> resultCollection, int[] x) {
        if (N.isNullOrEmpty(x)) {
            return resultCollection;
        }
        Collection<Integer> c = resultCollection;
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            c.add(x[i]);
        }
        return resultCollection;
    }

    @Override
    public int hashCode(int[] x) {
        return N.hashCode(x);
    }

    @Override
    public boolean equals(int[] x, int[] y) {
        return N.equals(x, y);
    }
}

