/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.util.CharacterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public interface Type<T> {
    public static final String ELEMENT_SEPARATOR = ", ".intern();
    public static final char[] ELEMENT_SEPARATOR_CHAR_ARRAY = ELEMENT_SEPARATOR.toCharArray();

    public String name();

    public String declaringName();

    public String xmlName();

    public Class<T> clazz();

    public boolean isPrimitiveType();

    public boolean isPrimitiveWrapper();

    public boolean isPrimitiveList();

    public boolean isBoolean();

    public boolean isNumber();

    public boolean isString();

    public boolean isDate();

    public boolean isCalendar();

    public boolean isJodaDateTime();

    public boolean isPrimitiveArray();

    public boolean isPrimitiveByteArray();

    public boolean isObjectArray();

    public boolean isArray();

    public boolean isList();

    public boolean isSet();

    public boolean isCollection();

    public boolean isMap();

    public boolean isEntity();

    public boolean isMapEntity();

    public boolean isEntityId();

    public boolean isDataSet();

    public boolean isInputStream();

    public boolean isReader();

    public boolean isByteBuffer();

    public boolean isGenericType();

    public boolean isImmutable();

    public boolean isComparable();

    public boolean isSerializable();

    public boolean isOptionalOrNullable();

    public SerializationType getSerializationType();

    public Type<?> getElementType();

    public Type<?>[] getParameterTypes();

    public T defaultValue();

    public int compare(T var1, T var2);

    public String stringOf(T var1);

    public T valueOf(String var1);

    public T valueOf(Object var1);

    public T valueOf(char[] var1, int var2, int var3);

    public void write(Writer var1, T var2) throws IOException;

    public void writeCharacter(CharacterWriter var1, T var2, SerializationConfig<?> var3) throws IOException;

    public T collection2Array(Collection<?> var1);

    public <E> Collection<E> array2Collection(Class<?> var1, T var2);

    public <E> Collection<E> array2Collection(Collection<E> var1, T var2);

    public int hashCode(T var1);

    public int deepHashCode(T var1);

    public boolean equals(T var1, T var2);

    public boolean deepEquals(T var1, T var2);

    public String toString(T var1);

    public String deepToString(T var1);

    public static enum SerializationType {
        SERIALIZABLE,
        ENTITY,
        MAP,
        ARRAY,
        COLLECTION,
        MAP_ENTITY,
        DATA_SET,
        UNKNOWN;

    }
}

