/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import android.os.AsyncTask;
import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.IOUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

@Internal
public final class AndroidUtil {
    private static final Executor SERIAL_EXECUTOR;
    private static final Executor TP_EXECUTOR;

    private AndroidUtil() {
    }

    @Internal
    public static Executor getSerialExecutor() {
        return SERIAL_EXECUTOR;
    }

    @Internal
    public static Executor getThreadPoolExecutor() {
        return TP_EXECUTOR;
    }

    static {
        if (IOUtil.IS_PLATFORM_ANDROID) {
            SERIAL_EXECUTOR = AsyncTask.SERIAL_EXECUTOR;
            TP_EXECUTOR = AsyncTask.THREAD_POOL_EXECUTOR;
        } else {
            SERIAL_EXECUTOR = Executors.newSingleThreadExecutor();
            TP_EXECUTOR = Executors.newFixedThreadPool(IOUtil.CPU_CORES);
        }
    }
}

