/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.NullSafe;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.u;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import java.util.RandomAccess;

public final class Array {
    static volatile int CPU_CORES = IOUtil.CPU_CORES;
    static final int MIN_ARRAY_SORT_GRAN = 8192;
    static final int BINARYSEARCH_THRESHOLD = 64;

    private Array() {
    }

    public static <T> T newInstance(Class<?> componentType, int length) throws NegativeArraySizeException {
        if (length == 0) {
            Object result = N.CLASS_EMPTY_ARRAY.get(componentType);
            if (result == null) {
                result = java.lang.reflect.Array.newInstance(componentType, length);
                N.CLASS_EMPTY_ARRAY.put(componentType, result);
            }
            return (T)result;
        }
        return (T)java.lang.reflect.Array.newInstance(componentType, length);
    }

    @SafeVarargs
    public static <T> T newInstance(Class<?> componentType, int ... dimensions) throws IllegalArgumentException, NegativeArraySizeException {
        return (T)java.lang.reflect.Array.newInstance(componentType, dimensions);
    }

    public static int getLength(Object array) throws IllegalArgumentException {
        return java.lang.reflect.Array.getLength(array);
    }

    public static <T> T get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return (T)java.lang.reflect.Array.get(array, index);
    }

    public static boolean getBoolean(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getBoolean(array, index);
    }

    public static byte getByte(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getByte(array, index);
    }

    public static char getChar(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getChar(array, index);
    }

    public static short getShort(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getShort(array, index);
    }

    public static int getInt(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getInt(array, index);
    }

    public static long getLong(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getLong(array, index);
    }

    public static float getFloat(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getFloat(array, index);
    }

    public static double getDouble(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getDouble(array, index);
    }

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.set(array, index, value);
    }

    public static void setBoolean(Object array, int index, boolean z) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setBoolean(array, index, z);
    }

    public static void setByte(Object array, int index, byte b) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setByte(array, index, b);
    }

    public static void setChar(Object array, int index, char c) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setChar(array, index, c);
    }

    public static void setShort(Object array, int index, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setShort(array, index, s);
    }

    public static void setInt(Object array, int index, int i) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setInt(array, index, i);
    }

    public static void setLong(Object array, int index, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setLong(array, index, l);
    }

    public static void setFloat(Object array, int index, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setFloat(array, index, f);
    }

    public static void setDouble(Object array, int index, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setDouble(array, index, d);
    }

    @SafeVarargs
    @NullSafe
    public static <T> List<T> asList(T ... a) {
        return N.isNullOrEmpty(a) ? N.emptyList() : Arrays.asList(a);
    }

    @SafeVarargs
    public static boolean[] of(boolean ... a) {
        return a;
    }

    @SafeVarargs
    public static char[] of(char ... a) {
        return a;
    }

    @SafeVarargs
    public static byte[] of(byte ... a) {
        return a;
    }

    @SafeVarargs
    public static short[] of(short ... a) {
        return a;
    }

    @SafeVarargs
    public static int[] of(int ... a) {
        return a;
    }

    @SafeVarargs
    public static long[] of(long ... a) {
        return a;
    }

    @SafeVarargs
    public static float[] of(float ... a) {
        return a;
    }

    @SafeVarargs
    public static double[] of(double ... a) {
        return a;
    }

    @SafeVarargs
    public static String[] of(String ... a) {
        return a;
    }

    @SafeVarargs
    public static <T> T[] oF(T ... a) {
        return a;
    }

    public static char[] range(char startInclusive, char endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_CHAR_ARRAY;
        }
        char[] a = new char[endExclusive * '\u0001' - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            char c = startInclusive;
            startInclusive = (char)(startInclusive + '\u0001');
            a[i] = c;
        }
        return a;
    }

    public static byte[] range(byte startInclusive, byte endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_BYTE_ARRAY;
        }
        byte[] a = new byte[endExclusive * 1 - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            byte by = startInclusive;
            startInclusive = (byte)(startInclusive + 1);
            a[i] = by;
        }
        return a;
    }

    public static short[] range(short startInclusive, short endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_SHORT_ARRAY;
        }
        short[] a = new short[endExclusive * 1 - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            short s = startInclusive;
            startInclusive = (short)(startInclusive + 1);
            a[i] = s;
        }
        return a;
    }

    public static int[] range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_INT_ARRAY;
        }
        if ((long)endExclusive * 1L - (long)startInclusive > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[endExclusive - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive++;
        }
        return a;
    }

    public static long[] range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_LONG_ARRAY;
        }
        if (endExclusive - startInclusive < 0L || endExclusive - startInclusive > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)(endExclusive - startInclusive)];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            ++startInclusive;
        }
        return a;
    }

    public static char[] range(char startInclusive, char endExclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        int len = (endExclusive * '\u0001' - startInclusive) / by + ((endExclusive * '\u0001' - startInclusive) % by == 0 ? 0 : 1);
        char[] a = new char[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (char)(startInclusive + by);
        }
        return a;
    }

    public static byte[] range(byte startInclusive, byte endExclusive, byte by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_BYTE_ARRAY;
        }
        int len = (endExclusive * 1 - startInclusive) / by + ((endExclusive * 1 - startInclusive) % by == 0 ? 0 : 1);
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (byte)(startInclusive + by);
        }
        return a;
    }

    public static short[] range(short startInclusive, short endExclusive, short by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_SHORT_ARRAY;
        }
        int len = (endExclusive * 1 - startInclusive) / by + ((endExclusive * 1 - startInclusive) % by == 0 ? 0 : 1);
        short[] a = new short[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (short)(startInclusive + by);
        }
        return a;
    }

    public static int[] range(int startInclusive, int endExclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_INT_ARRAY;
        }
        long len = ((long)endExclusive * 1L - (long)startInclusive) / (long)by + (long)(((long)endExclusive * 1L - (long)startInclusive) % (long)by == 0L ? 0 : 1);
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static long[] range(long startInclusive, long endExclusive, long by) {
        if (by == 0L) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0L) {
            return N.EMPTY_LONG_ARRAY;
        }
        long len = 0L;
        if (by > 0L && endExclusive - startInclusive < 0L || by < 0L && startInclusive - endExclusive < 0L) {
            BigInteger m = BigInteger.valueOf(endExclusive).subtract(BigInteger.valueOf(startInclusive)).divide(BigInteger.valueOf(by));
            if (m.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new IllegalArgumentException("overflow");
            }
            len = m.multiply(BigInteger.valueOf(by)).add(BigInteger.valueOf(startInclusive)).equals(BigInteger.valueOf(endExclusive)) ? m.longValue() : m.longValue() + 1L;
        } else {
            len = (endExclusive - startInclusive) / by + (long)((endExclusive - startInclusive) % by == 0L ? 0 : 1);
        }
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static char[] rangeClosed(char startInclusive, char endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_CHAR_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        char[] a = new char[endInclusive * '\u0001' - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            char c = startInclusive;
            startInclusive = (char)(startInclusive + '\u0001');
            a[i] = c;
        }
        return a;
    }

    public static byte[] rangeClosed(byte startInclusive, byte endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_BYTE_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        byte[] a = new byte[endInclusive * 1 - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            byte by = startInclusive;
            startInclusive = (byte)(startInclusive + 1);
            a[i] = by;
        }
        return a;
    }

    public static short[] rangeClosed(short startInclusive, short endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_SHORT_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        short[] a = new short[endInclusive * 1 - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            short s = startInclusive;
            startInclusive = (short)(startInclusive + 1);
            a[i] = s;
        }
        return a;
    }

    public static int[] rangeClosed(int startInclusive, int endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_INT_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        if ((long)endInclusive * 1L - (long)startInclusive + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[endInclusive - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive++;
        }
        return a;
    }

    public static long[] rangeClosed(long startInclusive, long endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_LONG_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        if (endInclusive - startInclusive + 1L <= 0L || endInclusive - startInclusive + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)(endInclusive - startInclusive + 1L)];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            ++startInclusive;
        }
        return a;
    }

    public static char[] rangeClosed(char startInclusive, char endInclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new char[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        int len = (endInclusive * '\u0001' - startInclusive) / by + 1;
        char[] a = new char[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (char)(startInclusive + by);
        }
        return a;
    }

    public static byte[] rangeClosed(byte startInclusive, byte endInclusive, byte by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new byte[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_BYTE_ARRAY;
        }
        int len = (endInclusive * 1 - startInclusive) / by + 1;
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (byte)(startInclusive + by);
        }
        return a;
    }

    public static short[] rangeClosed(short startInclusive, short endInclusive, short by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new short[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_SHORT_ARRAY;
        }
        int len = (endInclusive * 1 - startInclusive) / by + 1;
        short[] a = new short[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (short)(startInclusive + by);
        }
        return a;
    }

    public static int[] rangeClosed(int startInclusive, int endInclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new int[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_INT_ARRAY;
        }
        long len = ((long)endInclusive * 1L - (long)startInclusive) / (long)by + 1L;
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static long[] rangeClosed(long startInclusive, long endInclusive, long by) {
        if (by == 0L) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new long[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0L) {
            return N.EMPTY_LONG_ARRAY;
        }
        long len = 0L;
        if (by > 0L && endInclusive - startInclusive < 0L || by < 0L && startInclusive - endInclusive < 0L || (endInclusive - startInclusive) / by + 1L <= 0L) {
            BigInteger m = BigInteger.valueOf(endInclusive).subtract(BigInteger.valueOf(startInclusive)).divide(BigInteger.valueOf(by));
            if (m.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new IllegalArgumentException("overflow");
            }
            len = m.longValue() + 1L;
        } else {
            len = (endInclusive - startInclusive) / by + 1L;
        }
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static boolean[] repeat(boolean element, int n) {
        boolean[] a = new boolean[n];
        N.fill(a, element);
        return a;
    }

    public static char[] repeat(char element, int n) {
        char[] a = new char[n];
        N.fill(a, element);
        return a;
    }

    public static byte[] repeat(byte element, int n) {
        byte[] a = new byte[n];
        N.fill(a, element);
        return a;
    }

    public static short[] repeat(short element, int n) {
        short[] a = new short[n];
        N.fill(a, element);
        return a;
    }

    public static int[] repeat(int element, int n) {
        int[] a = new int[n];
        N.fill(a, element);
        return a;
    }

    public static long[] repeat(long element, int n) {
        long[] a = new long[n];
        N.fill(a, element);
        return a;
    }

    public static float[] repeat(float element, int n) {
        float[] a = new float[n];
        N.fill(a, element);
        return a;
    }

    public static double[] repeat(double element, int n) {
        double[] a = new double[n];
        N.fill(a, element);
        return a;
    }

    public static <T> T[] repeat(T element, int n) throws NullPointerException {
        Object[] a = (Object[])N.newArray(element.getClass(), n);
        N.fill(a, element);
        return a;
    }

    public static boolean[][] concat(boolean[][] a, boolean[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new boolean[][]{} : (boolean[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        boolean[][] result = new boolean[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static boolean[][][] concat(boolean[][][] a, boolean[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new boolean[][][]{} : (boolean[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        boolean[][][] result = new boolean[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (boolean[][])null, i < bLen ? b[i] : (boolean[][])null);
        }
        return result;
    }

    public static char[][] concat(char[][] a, char[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new char[][]{} : (char[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        char[][] result = new char[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static char[][][] concat(char[][][] a, char[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new char[][][]{} : (char[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        char[][][] result = new char[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (char[][])null, i < bLen ? b[i] : (char[][])null);
        }
        return result;
    }

    public static byte[][] concat(byte[][] a, byte[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new byte[][]{} : (byte[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        byte[][] result = new byte[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static byte[][][] concat(byte[][][] a, byte[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new byte[][][]{} : (byte[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        byte[][][] result = new byte[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (byte[][])null, i < bLen ? b[i] : (byte[][])null);
        }
        return result;
    }

    public static short[][] concat(short[][] a, short[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new short[][]{} : (short[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        short[][] result = new short[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static short[][][] concat(short[][][] a, short[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new short[][][]{} : (short[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        short[][][] result = new short[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (short[][])null, i < bLen ? b[i] : (short[][])null);
        }
        return result;
    }

    public static int[][] concat(int[][] a, int[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new int[][]{} : (int[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        int[][] result = new int[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static int[][][] concat(int[][][] a, int[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new int[][][]{} : (int[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        int[][][] result = new int[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (int[][])null, i < bLen ? b[i] : (int[][])null);
        }
        return result;
    }

    public static long[][] concat(long[][] a, long[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new long[][]{} : (long[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        long[][] result = new long[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static long[][][] concat(long[][][] a, long[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new long[][][]{} : (long[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        long[][][] result = new long[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (long[][])null, i < bLen ? b[i] : (long[][])null);
        }
        return result;
    }

    public static float[][] concat(float[][] a, float[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new float[][]{} : (float[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        float[][] result = new float[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static float[][][] concat(float[][][] a, float[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new float[][][]{} : (float[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        float[][][] result = new float[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (float[][])null, i < bLen ? b[i] : (float[][])null);
        }
        return result;
    }

    public static double[][] concat(double[][] a, double[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new double[][]{} : (double[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        double[][] result = new double[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static double[][][] concat(double[][][] a, double[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new double[][][]{} : (double[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        double[][][] result = new double[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (double[][])null, i < bLen ? b[i] : (double[][])null);
        }
        return result;
    }

    public static <T> T[][] concatt(T[][] a, T[][] b) {
        if (N.isNullOrEmpty(a)) {
            return N.clone(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len(a), N.len(b));
        Object[][] result = (Object[][])Array.newInstance(a.getClass().getComponentType(), maxLen);
        int aLen = N.len(a);
        int bLen = N.len(b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static <T> T[][][] concatt(T[][][] a, T[][][] b) {
        if (N.isNullOrEmpty(a)) {
            return N.clone(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len(a), N.len(b));
        Object[][][] result = (Object[][][])Array.newInstance(a.getClass().getComponentType(), maxLen);
        int aLen = N.len(a);
        int bLen = N.len(b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concatt(i < aLen ? a[i] : (Object[][])null, i < bLen ? b[i] : (Object[][])null);
        }
        return result;
    }

    static void sort(boolean[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int numOfFalse = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i]) continue;
            ++numOfFalse;
        }
        N.fill(a, 0, numOfFalse, false);
        N.fill(a, numOfFalse, a.length, true);
    }

    static void reverseSort(boolean[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int numOfTrue = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (!a[i]) continue;
            ++numOfTrue;
        }
        N.fill(a, 0, numOfTrue, true);
        N.fill(a, numOfTrue, a.length, false);
    }

    static void sort(char[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Arrays.sort(a);
    }

    static void sort(char[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex);
    }

    static void sort(byte[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Arrays.sort(a);
    }

    static void sort(byte[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex);
    }

    static void sort(short[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Arrays.sort(a);
    }

    static void sort(short[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex);
    }

    static void sort(int[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Arrays.sort(a);
    }

    static void sort(int[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex);
    }

    static void sort(long[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Arrays.sort(a);
    }

    static void sort(long[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex);
    }

    static void sort(float[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Arrays.sort(a);
    }

    static void sort(float[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex);
    }

    static void sort(double[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Arrays.sort(a);
    }

    static void sort(double[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex);
    }

    static void sort(Object[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Array.sort(a, 0, a.length);
    }

    static void sort(Object[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex, Comparators.NATURAL_ORDER);
    }

    static <T> void sort(T[] a, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        Array.sort(a, 0, a.length, cmp);
    }

    static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        Arrays.sort(a, fromIndex, toIndex, cmp);
    }

    static <T extends Comparable<? super T>> void sort(List<? extends T> c) {
        if (N.isNullOrEmpty(c)) {
            return;
        }
        Array.sort(c, 0, c.size());
    }

    static <T extends Comparable<? super T>> void sort(List<? extends T> c, int fromIndex, int toIndex) {
        Array.sort(c, fromIndex, toIndex, Comparators.NATURAL_ORDER);
    }

    static <T> void sort(List<? extends T> list, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(list)) {
            return;
        }
        Array.sort(list, 0, list.size(), cmp);
    }

    static <T> void sort(List<? extends T> c, int fromIndex, int toIndex, Comparator<? super T> cmp) {
        Object[] array;
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return;
        }
        if (N.isListElementDataFieldGettable && N.listElementDataField != null && c instanceof ArrayList) {
            array = null;
            try {
                array = (Object[])N.listElementDataField.get(c);
            }
            catch (Throwable e) {
                N.isListElementDataFieldGettable = false;
            }
            if (array != null) {
                Array.sort(array, fromIndex, toIndex, cmp);
                return;
            }
        }
        array = c.toArray();
        Arrays.sort(array, fromIndex, toIndex, cmp);
        ListIterator<T> i = c.listIterator();
        for (int j = 0; j < array.length; ++j) {
            i.next();
            i.set(array[j]);
        }
    }

    static int binarySearch(boolean[] a, boolean key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        if (a[0] == key) {
            return 0;
        }
        if (a[a.length - 1] != key) {
            return -1;
        }
        int left = 0;
        int right = a.length - 1;
        while (left < right) {
            int mid = left + (right - left) / 2;
            if (a[mid] == key) {
                right = mid;
                continue;
            }
            left = mid + 1;
        }
        return left;
    }

    static int binarySearch(char[] a, char key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(char[] a, int fromIndex, int toIndex, char key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static int binarySearch(byte[] a, byte key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(byte[] a, int fromIndex, int toIndex, byte key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static int binarySearch(short[] a, short key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(short[] a, int fromIndex, int toIndex, short key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static int binarySearch(int[] a, int key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static int binarySearch(long[] a, long key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(long[] a, int fromIndex, int toIndex, long key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static int binarySearch(float[] a, float key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(float[] a, int fromIndex, int toIndex, float key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static int binarySearch(double[] a, double key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(double[] a, int fromIndex, int toIndex, double key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static int binarySearch(Object[] a, Object key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key);
    }

    static int binarySearch(Object[] a, int fromIndex, int toIndex, Object key) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, fromIndex, toIndex, key);
    }

    static <T> int binarySearch(T[] a, T key, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key, cmp == null ? Comparators.NATURAL_ORDER : cmp);
    }

    static <T> int binarySearch(T[] a, int fromIndex, int toIndex, T key, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a)) {
            return -1;
        }
        return Arrays.binarySearch(a, key, cmp == null ? Comparators.NATURAL_ORDER : cmp);
    }

    static <T extends Comparable<? super T>> int binarySearch(List<? extends T> list, T key) {
        if (N.isNullOrEmpty(list)) {
            return -1;
        }
        return Array.binarySearch(list, 0, list.size(), key);
    }

    static <T extends Comparable<? super T>> int binarySearch(List<? extends T> list, int fromIndex, int toIndex, T key) {
        if (N.isNullOrEmpty(list)) {
            return -1;
        }
        return Array.binarySearch(list, fromIndex, toIndex, key, Comparators.NATURAL_ORDER);
    }

    static <T> int binarySearch(List<? extends T> list, T key, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(list)) {
            return -1;
        }
        return Array.binarySearch(list, 0, list.size(), key, cmp);
    }

    static <T> int binarySearch(List<? extends T> list, int fromIndex, int toIndex, T key, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(list)) {
            return -1;
        }
        if (N.isListElementDataFieldGettable && N.listElementDataField != null && list instanceof ArrayList) {
            Object[] array = null;
            try {
                array = (Object[])N.listElementDataField.get(list);
            }
            catch (Throwable e) {
                N.isListElementDataFieldGettable = false;
            }
            if (array != null) {
                return Array.binarySearch(array, fromIndex, toIndex, key, cmp == null ? Comparators.NATURAL_ORDER : cmp);
            }
        }
        if (list instanceof RandomAccess || list.size() < 64) {
            return Array.indexedBinarySearch(list, fromIndex, toIndex, key, cmp == null ? Comparators.NATURAL_ORDER : cmp);
        }
        return Array.iteratorBinarySearch(list, fromIndex, toIndex, key, cmp == null ? Comparators.NATURAL_ORDER : cmp);
    }

    private static <T> int indexedBinarySearch(List<? extends T> l, int fromIndex, int toIndex, T key, Comparator<? super T> cmp) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = l.get(mid);
            int res = cmp.compare(midVal, key);
            if (res < 0) {
                low = mid + 1;
                continue;
            }
            if (res > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static <T> int iteratorBinarySearch(List<? extends T> l, int fromIndex, int toIndex, T key, Comparator<? super T> cmp) {
        int low = fromIndex;
        int high = toIndex - 1;
        ListIterator<? extends T> iterator = l.listIterator();
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = Array.get(iterator, mid);
            int res = cmp.compare(midVal, key);
            if (res < 0) {
                low = mid + 1;
                continue;
            }
            if (res > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static <T> T get(ListIterator<? extends T> iterator, int index) {
        T obj = null;
        int pos = iterator.nextIndex();
        if (pos <= index) {
            do {
                obj = iterator.next();
            } while (pos++ < index);
        } else {
            do {
                obj = iterator.previous();
            } while (--pos > index);
        }
        return obj;
    }

    static char kthLargest(char[] a, int k) {
        return Array.kthLargest(a, 0, a.length, k);
    }

    static char kthLargest(char[] a, int fromIndex, int toIndex, int k) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Character.valueOf(a[i]));
                    continue;
                }
                if (a[i] <= ((Character)queue.peek()).charValue()) continue;
                queue.remove();
                queue.add(Character.valueOf(a[i]));
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Character>(k, new Comparator<Character>(){

                @Override
                public int compare(Character o1, Character o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Character.valueOf(a[i]));
                    continue;
                }
                if (a[i] >= ((Character)queue.peek()).charValue()) continue;
                queue.remove();
                queue.add(Character.valueOf(a[i]));
            }
        }
        return ((Character)queue.peek()).charValue();
    }

    static byte kthLargest(byte[] a, int k) {
        return Array.kthLargest(a, 0, a.length, k);
    }

    static byte kthLargest(byte[] a, int fromIndex, int toIndex, int k) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Byte)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Byte>(k, new Comparator<Byte>(){

                @Override
                public int compare(Byte o1, Byte o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Byte)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Byte)queue.peek();
    }

    static short kthLargest(short[] a, int k) {
        return Array.kthLargest(a, 0, a.length, k);
    }

    static short kthLargest(short[] a, int fromIndex, int toIndex, int k) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Short)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Short>(k, new Comparator<Short>(){

                @Override
                public int compare(Short o1, Short o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Short)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Short)queue.peek();
    }

    static int kthLargest(int[] a, int k) {
        return Array.kthLargest(a, 0, a.length, k);
    }

    static int kthLargest(int[] a, int fromIndex, int toIndex, int k) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Integer)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Integer>(k, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Integer)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Integer)queue.peek();
    }

    static long kthLargest(long[] a, int k) {
        return Array.kthLargest(a, 0, a.length, k);
    }

    static long kthLargest(long[] a, int fromIndex, int toIndex, int k) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Long)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Long>(k, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Long)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Long)queue.peek();
    }

    static float kthLargest(float[] a, int k) {
        return Array.kthLargest(a, 0, a.length, k);
    }

    static float kthLargest(float[] a, int fromIndex, int toIndex, int k) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Float.valueOf(a[i]));
                    continue;
                }
                if (Float.compare(a[i], ((Float)queue.peek()).floatValue()) <= 0) continue;
                queue.remove();
                queue.add(Float.valueOf(a[i]));
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Float>(k, new Comparator<Float>(){

                @Override
                public int compare(Float o1, Float o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Float.valueOf(a[i]));
                    continue;
                }
                if (Float.compare(a[i], ((Float)queue.peek()).floatValue()) >= 0) continue;
                queue.remove();
                queue.add(Float.valueOf(a[i]));
            }
        }
        return ((Float)queue.peek()).floatValue();
    }

    static double kthLargest(double[] a, int k) {
        return Array.kthLargest(a, 0, a.length, k);
    }

    static double kthLargest(double[] a, int fromIndex, int toIndex, int k) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (Double.compare(a[i], (Double)queue.peek()) <= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Double>(k, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (Double.compare(a[i], (Double)queue.peek()) >= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Double)queue.peek();
    }

    static <T extends Comparable<T>> T kthLargest(T[] a, int k) {
        return (T)Array.kthLargest(a, (int)0, (int)a.length, (int)k);
    }

    static <T extends Comparable<T>> T kthLargest(T[] a, int fromIndex, int toIndex, int k) {
        return (T)((Comparable)Array.kthLargest(a, fromIndex, toIndex, k, Comparators.NATURAL_ORDER));
    }

    static <T> T kthLargest(T[] a, int k, Comparator<? super T> cmp) {
        return Array.kthLargest(a, 0, a.length, k, cmp);
    }

    static <T> T kthLargest(T[] a, int fromIndex, int toIndex, int k, Comparator<? super T> cmp) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        final Comparator<T> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex, comparator);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex, comparator);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue<T>(k, comparator);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (comparator.compare(a[i], queue.peek()) <= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue(k, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return comparator.compare(o2, o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (comparator.compare(a[i], queue.peek()) >= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (T)queue.peek();
    }

    static <T extends Comparable<T>> T kthLargest(Collection<? extends T> c, int k) {
        return Array.kthLargest(c, 0, c.size(), k);
    }

    static <T extends Comparable<T>> T kthLargest(Collection<? extends T> c, int fromIndex, int toIndex, int k) {
        return (T)((Comparable)Array.kthLargest(c, fromIndex, toIndex, k, Comparators.NATURAL_ORDER));
    }

    static <T> T kthLargest(Collection<? extends T> c, int k, Comparator<? super T> cmp) {
        return Array.kthLargest(c, 0, c.size(), k, cmp);
    }

    static <T> T kthLargest(Collection<? extends T> c, int fromIndex, int toIndex, int k, Comparator<? super T> cmp) {
        N.checkFromToIndex(fromIndex, toIndex, c == null ? 0 : c.size());
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        final Comparator comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(c, fromIndex, toIndex, comparator);
        }
        if (k == len) {
            return N.min(c, fromIndex, toIndex, comparator);
        }
        Iterator<T> iter = c.iterator();
        PriorityQueue queue = null;
        if (k <= len / 2) {
            int cursor;
            queue = new PriorityQueue(k);
            for (cursor = 0; cursor < fromIndex && iter.hasNext(); ++cursor) {
                iter.next();
            }
            Object e = null;
            while (cursor < toIndex && iter.hasNext()) {
                e = iter.next();
                if (queue.size() < k) {
                    queue.add(e);
                } else if (comparator.compare(e, queue.peek()) > 0) {
                    queue.remove();
                    queue.add(e);
                }
                ++cursor;
            }
        } else {
            int cursor;
            k = len - k + 1;
            queue = new PriorityQueue(k, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return comparator.compare(o2, o1);
                }
            });
            for (cursor = 0; cursor < fromIndex && iter.hasNext(); ++cursor) {
                iter.next();
            }
            Object e = null;
            while (cursor < toIndex && iter.hasNext()) {
                e = iter.next();
                if (queue.size() < k) {
                    queue.add(e);
                } else if (comparator.compare(e, queue.peek()) < 0) {
                    queue.remove();
                    queue.add(e);
                }
                ++cursor;
            }
        }
        return (T)queue.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setError(u.Holder<Throwable> errorHolder, Throwable e) {
        u.Holder<Throwable> holder = errorHolder;
        synchronized (holder) {
            if (errorHolder.value() == null) {
                errorHolder.setValue((Object)e);
            } else {
                ((Throwable)errorHolder.value()).addSuppressed(e);
            }
        }
    }
}

