/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ArrayHashSet<E>
implements Set<E> {
    private final Set<Wrapper<E>> set;

    public ArrayHashSet() {
        this.set = N.newHashSet();
    }

    public ArrayHashSet(int initialCapacity) {
        this.set = N.newHashSet(initialCapacity);
    }

    public ArrayHashSet(Class<? extends Set> setType) {
        this.set = N.newInstance(setType);
    }

    public ArrayHashSet(Collection<? extends E> coll) {
        this.set = N.isNullOrEmpty(coll) ? N.newHashSet() : N.newHashSet(N.initHashCapacity(coll.size()));
        this.addAll(coll);
    }

    ArrayHashSet(Set<Wrapper<E>> set) {
        this.set = set;
    }

    @Override
    public boolean add(E e) {
        return this.set.add(Wrapper.of(e));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        boolean result = false;
        for (E e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(Wrapper.of(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        boolean result = false;
        for (Object e : c) {
            result |= this.remove(e);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            if (this.set.isEmpty()) {
                return false;
            }
            this.set.clear();
            return true;
        }
        ArrayList list = new ArrayList(c.size());
        for (Object e : c) {
            list.add(Wrapper.of(e));
        }
        return this.set.retainAll(list);
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(Wrapper.of(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            return true;
        }
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.set.iterator());
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        if (size == 0) {
            return N.EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[size];
        int i = 0;
        for (Wrapper<E> e : this.set) {
            result[i++] = e.value();
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])N.newArray(a.getClass().getComponentType(), size);
        }
        T[] result = a;
        int i = 0;
        for (Wrapper<E> e : this.set) {
            result[i++] = e.value();
        }
        return a;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof ArrayHashSet && ((ArrayHashSet)obj).set.equals(this.set);
    }

    public String toString() {
        return this.set.toString();
    }

    static class Itr<T>
    implements Iterator<T> {
        private final Iterator<Wrapper<T>> it;

        Itr(Iterator<Wrapper<T>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next().value();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

