/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.ImmutableIterator;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.BooleanSupplier;
import com.landawn.abacus.util.function.Consumer;
import com.landawn.abacus.util.function.IndexedConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class BiIterator<A, B>
extends ImmutableIterator<Pair<A, B>> {
    private static final BiIterator EMPTY = new BiIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Try.BiConsumer action) throws Exception {
            N.checkArgNotNull(action);
        }

        public ObjIterator map(BiFunction mapper) {
            N.checkArgNotNull(mapper);
            return ObjIterator.empty();
        }
    };

    public static <A, B> BiIterator<A, B> empty() {
        return EMPTY;
    }

    public static <K, V> BiIterator<K, V> of(Map<K, V> map) {
        if (N.isNullOrEmpty(map)) {
            return BiIterator.empty();
        }
        return BiIterator.of(map.entrySet().iterator());
    }

    public static <K, V> BiIterator<K, V> of(final Iterator<Map.Entry<K, V>> iter) {
        if (iter == null) {
            return BiIterator.empty();
        }
        return new BiIterator<K, V>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Pair<K, V> next() {
                return Pair.from((Map.Entry)iter.next());
            }

            @Override
            public <E extends Exception> void forEachRemaining(Try.BiConsumer<? super K, ? super V, E> action) throws E {
                N.checkArgNotNull(action);
                Map.Entry entry = null;
                while (iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    action.accept(entry.getKey(), entry.getValue());
                }
            }

            @Override
            public <R> ObjIterator<R> map(final BiFunction<? super K, ? super V, R> mapper) {
                N.checkArgNotNull(mapper);
                return new ObjIterator<R>(){
                    private Map.Entry<K, V> entry = null;

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public R next() {
                        this.entry = (Map.Entry)iter.next();
                        return mapper.apply(this.entry.getKey(), this.entry.getValue());
                    }
                };
            }
        };
    }

    public static <A, B> BiIterator<A, B> generate(Consumer<Pair<A, B>> output) {
        return BiIterator.generate(BooleanSupplier.TRUE, output);
    }

    public static <A, B> BiIterator<A, B> generate(final BooleanSupplier hasNext, final Consumer<Pair<A, B>> output) {
        N.checkArgNotNull(hasNext);
        N.checkArgNotNull(output);
        return new BiIterator<A, B>(){
            private final Pair<A, B> tmp = new Pair();

            @Override
            public boolean hasNext() {
                return hasNext.getAsBoolean();
            }

            @Override
            public Pair<A, B> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                output.accept(this.tmp);
                return Pair.of(this.tmp.left, this.tmp.right);
            }

            @Override
            public <E extends Exception> void forEachRemaining(Try.BiConsumer<? super A, ? super B, E> action) throws E {
                N.checkArgNotNull(action);
                while (hasNext.getAsBoolean()) {
                    output.accept(this.tmp);
                    action.accept(this.tmp.left, this.tmp.right);
                }
            }

            @Override
            public <R> ObjIterator<R> map(final BiFunction<? super A, ? super B, R> mapper) {
                N.checkArgNotNull(mapper);
                return new ObjIterator<R>(){

                    @Override
                    public boolean hasNext() {
                        return hasNext.getAsBoolean();
                    }

                    @Override
                    public R next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        output.accept(tmp);
                        return mapper.apply((this).tmp.left, (this).tmp.right);
                    }
                };
            }
        };
    }

    public static <A, B> BiIterator<A, B> generate(final int fromIndex, final int toIndex, final IndexedConsumer<Pair<A, B>> output) {
        N.checkFromToIndex(fromIndex, toIndex, Integer.MAX_VALUE);
        N.checkArgNotNull(output);
        return new BiIterator<A, B>(){
            private final MutableInt cursor;
            private final Pair<A, B> tmp;
            {
                this.cursor = MutableInt.of(fromIndex);
                this.tmp = new Pair();
            }

            @Override
            public boolean hasNext() {
                return this.cursor.value() < toIndex;
            }

            @Override
            public Pair<A, B> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                output.accept(this.cursor.getAndIncrement(), this.tmp);
                return Pair.of(this.tmp.left, this.tmp.right);
            }

            @Override
            public <E extends Exception> void forEachRemaining(Try.BiConsumer<? super A, ? super B, E> action) throws E {
                N.checkArgNotNull(action);
                while (this.cursor.value() < toIndex) {
                    output.accept(this.cursor.getAndIncrement(), this.tmp);
                    action.accept(this.tmp.left, this.tmp.right);
                }
            }

            @Override
            public <R> ObjIterator<R> map(final BiFunction<? super A, ? super B, R> mapper) {
                N.checkArgNotNull(mapper);
                return new ObjIterator<R>(){

                    @Override
                    public boolean hasNext() {
                        return cursor.value() < toIndex;
                    }

                    @Override
                    public R next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        output.accept(cursor.getAndIncrement(), tmp);
                        return mapper.apply((this).tmp.left, (this).tmp.right);
                    }
                };
            }
        };
    }

    public static <A, B> BiIterator<A, B> zip(A[] a, B[] b) {
        return BiIterator.zip(Array.asList(a), Array.asList(b));
    }

    public static <A, B> BiIterator<A, B> zip(A[] a, B[] b, A valueForNoneA, B valueForNoneB) {
        return BiIterator.zip(Array.asList(a), Array.asList(b), valueForNoneA, valueForNoneB);
    }

    public static <A, B> BiIterator<A, B> zip(Collection<A> a, Collection<B> b) {
        return BiIterator.zip(a == null ? null : a.iterator(), b == null ? null : b.iterator());
    }

    public static <A, B> BiIterator<A, B> zip(Collection<A> a, Collection<B> b, A valueForNoneA, B valueForNoneB) {
        return BiIterator.zip(a == null ? null : a.iterator(), b == null ? null : b.iterator(), valueForNoneA, valueForNoneB);
    }

    public static <A, B> BiIterator<A, B> zip(final Iterator<A> iterA, final Iterator<B> iterB) {
        if (iterA == null || iterB == null) {
            return BiIterator.empty();
        }
        return new BiIterator<A, B>(){

            @Override
            public boolean hasNext() {
                return iterA.hasNext() && iterB.hasNext();
            }

            @Override
            public Pair<A, B> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Pair.of(iterA.next(), iterB.next());
            }

            @Override
            public <E extends Exception> void forEachRemaining(Try.BiConsumer<? super A, ? super B, E> action) throws E {
                N.checkArgNotNull(action);
                while (iterA.hasNext() && iterB.hasNext()) {
                    action.accept(iterA.next(), iterB.next());
                }
            }

            @Override
            public <R> ObjIterator<R> map(final BiFunction<? super A, ? super B, R> mapper) {
                N.checkArgNotNull(mapper);
                return new ObjIterator<R>(){

                    @Override
                    public boolean hasNext() {
                        return iterA.hasNext() && iterB.hasNext();
                    }

                    @Override
                    public R next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return mapper.apply(iterA.next(), iterB.next());
                    }
                };
            }
        };
    }

    public static <A, B> BiIterator<A, B> zip(Iterator<A> iterA, Iterator<B> iterB, final A valueForNoneA, final B valueForNoneB) {
        final Iterator<Object> iter1 = iterA == null ? ObjIterator.empty() : iterA;
        final Iterator<Object> iter2 = iterB == null ? ObjIterator.empty() : iterB;
        return new BiIterator<A, B>(){

            @Override
            public boolean hasNext() {
                return iter1.hasNext() || iter2.hasNext();
            }

            @Override
            public Pair<A, B> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Pair.of(iter1.hasNext() ? iter1.next() : valueForNoneA, iter2.hasNext() ? iter2.next() : valueForNoneB);
            }

            @Override
            public <E extends Exception> void forEachRemaining(Try.BiConsumer<? super A, ? super B, E> action) throws E {
                N.checkArgNotNull(action);
                while (iter1.hasNext() || iter2.hasNext()) {
                    action.accept(iter1.hasNext() ? iter1.next() : valueForNoneA, iter2.hasNext() ? iter2.next() : valueForNoneB);
                }
            }

            @Override
            public <R> ObjIterator<R> map(final BiFunction<? super A, ? super B, R> mapper) {
                N.checkArgNotNull(mapper);
                return new ObjIterator<R>(){

                    @Override
                    public boolean hasNext() {
                        return iter1.hasNext() || iter2.hasNext();
                    }

                    @Override
                    public R next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return mapper.apply(iter1.hasNext() ? iter1.next() : valueForNoneA, iter2.hasNext() ? iter2.next() : valueForNoneB);
                    }
                };
            }
        };
    }

    public static <T, L, R> BiIterator<L, R> unzip(final Iterator<? extends T> iter, final BiConsumer<? super T, Pair<L, R>> unzip) {
        if (iter == null) {
            return BiIterator.empty();
        }
        BooleanSupplier hasNext = new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return iter.hasNext();
            }
        };
        Consumer output = new Consumer<Pair<L, R>>(){

            @Override
            public void accept(Pair<L, R> out) {
                unzip.accept(iter.next(), out);
            }
        };
        return BiIterator.generate(hasNext, output);
    }

    public abstract <E extends Exception> void forEachRemaining(Try.BiConsumer<? super A, ? super B, E> var1) throws E;

    public abstract <R> ObjIterator<R> map(BiFunction<? super A, ? super B, R> var1);
}

