/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.CharacterWriter;
import java.io.OutputStream;
import java.io.Writer;

public final class BufferedJSONWriter
extends CharacterWriter {
    static final char[][] REPLACEMENT_CHARS;
    static final char[][] HTML_SAFE_REPLACEMENT_CHARS;
    static final int LENGTH_OF_REPLACEMENT_CHARS;

    BufferedJSONWriter() {
        super(REPLACEMENT_CHARS);
    }

    BufferedJSONWriter(OutputStream os) {
        super(os, REPLACEMENT_CHARS);
    }

    BufferedJSONWriter(Writer writer) {
        super(writer, REPLACEMENT_CHARS);
    }

    protected static String getCharNum(char ch) {
        return String.format("\\u%04x", ch);
    }

    static {
        int length = 10000;
        REPLACEMENT_CHARS = new char[length][];
        for (int i = 0; i < length; ++i) {
            if (i >= 32 && i != 127) continue;
            BufferedJSONWriter.REPLACEMENT_CHARS[i] = BufferedJSONWriter.getCharNum((char)i).toCharArray();
        }
        BufferedJSONWriter.REPLACEMENT_CHARS[34] = "\\\"".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[39] = "\\'".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[92] = "\\\\".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[9] = "\\t".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[8] = "\\b".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[10] = "\\n".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[13] = "\\r".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[12] = "\\f".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[8232] = "\\u2028".toCharArray();
        BufferedJSONWriter.REPLACEMENT_CHARS[8233] = "\\u2029".toCharArray();
        HTML_SAFE_REPLACEMENT_CHARS = (char[][])REPLACEMENT_CHARS.clone();
        BufferedJSONWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c".toCharArray();
        BufferedJSONWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e".toCharArray();
        BufferedJSONWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026".toCharArray();
        BufferedJSONWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d".toCharArray();
        BufferedJSONWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027".toCharArray();
        LENGTH_OF_REPLACEMENT_CHARS = REPLACEMENT_CHARS.length - 1;
    }
}

