/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DataSet;
import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.annotation.NullSafe;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.core.MapEntity;
import com.landawn.abacus.core.RowDataSet;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.Base64;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableEntry;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Internals;
import com.landawn.abacus.util.Iterators;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.SetMultimap;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Triple;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.URLEncodedUtil;
import com.landawn.abacus.util.Utils;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.function.ToDoubleFunction;
import com.landawn.abacus.util.function.ToIntFunction;
import com.landawn.abacus.util.function.ToLongFunction;
import com.landawn.abacus.util.u;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;

class CommonUtil {
    static final int POOL_SIZE = Internals.POOL_SIZE;
    static final String ELEMENT_SEPARATOR = Type.ELEMENT_SEPARATOR;
    static final char[] ELEMENT_SEPARATOR_CHAR_ARRAY = Type.ELEMENT_SEPARATOR_CHAR_ARRAY;
    static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    static final String NULL_STRING = "null".intern();
    static final char[] NULL_CHAR_ARRAY = NULL_STRING.toCharArray();
    static final String TRUE = Boolean.TRUE.toString().intern();
    static final char[] TRUE_CHAR_ARRAY = TRUE.toCharArray();
    static final String FALSE = Boolean.FALSE.toString().intern();
    static final char[] FALSE_CHAR_ARRAY = FALSE.toCharArray();
    static final char CHAR_0 = '\u0000';
    static final char CHAR_LF = '\n';
    static final char CHAR_CR = '\r';
    public static final int INDEX_NOT_FOUND = -1;
    public static final String EMPTY_STRING = "".intern();
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJ_ARRAY = new Boolean[0];
    public static final Character[] EMPTY_CHAR_OBJ_ARRAY = new Character[0];
    public static final Byte[] EMPTY_BYTE_OBJ_ARRAY = new Byte[0];
    public static final Short[] EMPTY_SHORT_OBJ_ARRAY = new Short[0];
    public static final Integer[] EMPTY_INT_OBJ_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_OBJ_ARRAY = new Long[0];
    public static final Float[] EMPTY_FLOAT_OBJ_ARRAY = new Float[0];
    public static final Double[] EMPTY_DOUBLE_OBJ_ARRAY = new Double[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static final List EMPTY_LIST = Collections.emptyList();
    static final Set EMPTY_SET = Collections.emptySet();
    static final Map EMPTY_MAP = Collections.emptyMap();
    static final Iterator EMPTY_ITERATOR = Collections.emptyIterator();
    static final ListIterator EMPTY_LIST_ITERATOR = Collections.emptyListIterator();
    static final Object NULL_MASK = new NullMask();
    static final String BACKSLASH_ASTERISK = "*";
    static final int REVERSE_THRESHOLD = 18;
    static final int FILL_THRESHOLD = 25;
    static final int REPLACEALL_THRESHOLD = 11;
    static final Random RAND = new SecureRandom();
    static final Comparator NULL_MIN_COMPARATOR = Comparators.nullsFirst();
    static final Comparator NULL_MAX_COMPARATOR = Comparators.nullsLast();
    static final Comparator NATURAL_ORDER = Comparators.naturalOrder();
    static final Map<Class<?>, Object> CLASS_EMPTY_ARRAY = new ConcurrentHashMap();
    static final Map<Class<?>, Integer> CLASS_TYPE_ENUM;
    private static final Map<Class<? extends Enum<?>>, List<? extends Enum<?>>> enumListPool;
    private static final Map<Class<? extends Enum<?>>, Set<? extends Enum<?>>> enumSetPool;
    private static final Map<Class<? extends Enum<?>>, BiMap<? extends Enum<?>, String>> enumMapPool;
    private static final Map<String, Type<?>> nameTypePool;
    private static final Map<Class<?>, Type<?>> clsTypePool;
    static final Field listElementDataField;
    static final Field listSizeField;
    static volatile boolean isListElementDataFieldGettable;
    static volatile boolean isListElementDataFieldSettable;
    static final String[] charStringCache;
    static final int intStringCacheLow = -1001;
    static final int intStringCacheHigh = 10001;
    static final String[] intStringCache;
    static final Map<String, Integer> stringIntCache;
    private static final int MIN_SIZE_FOR_COPY_ALL = 9;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final int MAX_HASH_LENGTH = 0x6666665E;
    private static final Set<Class<?>> notKryoCompatible;
    private static final ByteArrayInputStream EMPTY_INPUT_STREAM;

    CommonUtil() {
    }

    public static <T> Type<T> typeOf(String typeName) {
        if (typeName == null) {
            return null;
        }
        Type<Object> type = nameTypePool.get(typeName);
        if (type == null) {
            type = TypeFactory.getType(typeName);
            nameTypePool.put(typeName, type);
        }
        return type;
    }

    public static <T> Type<T> typeOf(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        Type<Object> type = clsTypePool.get(cls);
        if (type == null) {
            type = TypeFactory.getType(cls);
            clsTypePool.put(cls, type);
        }
        return type;
    }

    public static <T> T valueOf(Class<? extends T> targetClass, String str) {
        return str == null ? CommonUtil.defaultValueOf(targetClass) : CommonUtil.typeOf(targetClass).valueOf(str);
    }

    public static <T> T defaultValueOf(Class<T> cls) {
        return CommonUtil.typeOf(cls).defaultValue();
    }

    public static boolean defaultIfNull(Boolean b) {
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean defaultIfNull(Boolean b, boolean defaultForNull) {
        if (b == null) {
            return defaultForNull;
        }
        return b;
    }

    public static char defaultIfNull(Character c) {
        if (c == null) {
            return '\u0000';
        }
        return c.charValue();
    }

    public static char defaultIfNull(Character c, char defaultForNull) {
        if (c == null) {
            return defaultForNull;
        }
        return c.charValue();
    }

    public static byte defaultIfNull(Byte b) {
        if (b == null) {
            return 0;
        }
        return b;
    }

    public static byte defaultIfNull(Byte b, byte defaultForNull) {
        if (b == null) {
            return defaultForNull;
        }
        return b;
    }

    public static short defaultIfNull(Short b) {
        if (b == null) {
            return 0;
        }
        return b;
    }

    public static short defaultIfNull(Short b, short defaultForNull) {
        if (b == null) {
            return defaultForNull;
        }
        return b;
    }

    public static int defaultIfNull(Integer b) {
        if (b == null) {
            return 0;
        }
        return b;
    }

    public static int defaultIfNull(Integer b, int defaultForNull) {
        if (b == null) {
            return defaultForNull;
        }
        return b;
    }

    public static long defaultIfNull(Long b) {
        if (b == null) {
            return 0L;
        }
        return b;
    }

    public static long defaultIfNull(Long b, long defaultForNull) {
        if (b == null) {
            return defaultForNull;
        }
        return b;
    }

    public static float defaultIfNull(Float b) {
        if (b == null) {
            return 0.0f;
        }
        return b.floatValue();
    }

    public static float defaultIfNull(Float b, float defaultForNull) {
        if (b == null) {
            return defaultForNull;
        }
        return b.floatValue();
    }

    public static double defaultIfNull(Double b) {
        if (b == null) {
            return 0.0;
        }
        return b;
    }

    public static double defaultIfNull(Double b, double defaultForNull) {
        if (b == null) {
            return defaultForNull;
        }
        return b;
    }

    public static <T> T defaultIfNull(T obj, T defaultForNull) {
        return obj == null ? defaultForNull : obj;
    }

    public static String stringOf(boolean val) {
        return String.valueOf(val);
    }

    public static String stringOf(char val) {
        if (val < '\u0080') {
            return charStringCache[val];
        }
        return String.valueOf(val);
    }

    public static String stringOf(byte val) {
        if (val > -1001 && val < 10001) {
            return intStringCache[val - -1001];
        }
        return String.valueOf(val);
    }

    public static String stringOf(short val) {
        if (val > -1001 && val < 10001) {
            return intStringCache[val - -1001];
        }
        return String.valueOf(val);
    }

    public static String stringOf(int val) {
        if (val > -1001 && val < 10001) {
            return intStringCache[val - -1001];
        }
        return String.valueOf(val);
    }

    public static String stringOf(long val) {
        if (val > -1001L && val < 10001L) {
            return intStringCache[(int)(val - -1001L)];
        }
        return String.valueOf(val);
    }

    public static String stringOf(float val) {
        return String.valueOf(val);
    }

    public static String stringOf(double val) {
        return String.valueOf(val);
    }

    public static String stringOf(Object obj) {
        return obj == null ? null : CommonUtil.typeOf(obj.getClass()).stringOf(obj);
    }

    public static <E extends Enum<E>> List<E> enumListOf(Class<E> enumClass) {
        List<? extends Enum<?>> enumList = enumListPool.get(enumClass);
        if (enumList == null) {
            enumList = ImmutableList.of(CommonUtil.asList(enumClass.getEnumConstants()));
            enumListPool.put(enumClass, enumList);
        }
        return enumList;
    }

    public static <E extends Enum<E>> Set<E> enumSetOf(Class<E> enumClass) {
        Set<? extends Enum<?>> enumSet = enumSetPool.get(enumClass);
        if (enumSet == null) {
            enumSet = ImmutableSet.of(EnumSet.allOf(enumClass));
            enumSetPool.put(enumClass, enumSet);
        }
        return enumSet;
    }

    public static <E extends Enum<E>> BiMap<E, String> enumMapOf(Class<E> enumClass) {
        BiMap<Enum, String> enumMap = enumMapPool.get(enumClass);
        if (enumMap == null) {
            EnumMap<E, String> keyMap = new EnumMap<E, String>(enumClass);
            HashMap<String, Enum> valueMap = new HashMap<String, Enum>();
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                keyMap.put(e, e.name());
                valueMap.put(e.name(), e);
            }
            enumMap = new BiMap(ImmutableMap.of(keyMap), ImmutableMap.of(valueMap));
            enumMapPool.put(enumClass, enumMap);
        }
        return enumMap;
    }

    public static <T> T newInstance(Class<T> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            if (cls.equals(Map.class)) {
                return (T)new HashMap();
            }
            if (cls.equals(List.class)) {
                return (T)new ArrayList();
            }
            if (cls.equals(Set.class)) {
                return (T)CommonUtil.newHashSet();
            }
            if (cls.equals(Queue.class)) {
                return (T)new LinkedList();
            }
            if (cls.equals(Deque.class)) {
                return (T)new LinkedList();
            }
            if (cls.equals(SortedSet.class) || cls.equals(NavigableSet.class)) {
                return (T)new TreeSet();
            }
            if (cls.equals(SortedMap.class) || cls.equals(NavigableMap.class)) {
                return (T)new TreeMap();
            }
        }
        try {
            if (!Modifier.isStatic(cls.getModifiers()) && (cls.isAnonymousClass() || cls.isMemberClass())) {
                ArrayList toInstantiate = new ArrayList();
                Class<?> parent = cls.getEnclosingClass();
                do {
                    toInstantiate.add(parent);
                } while ((parent = parent.getEnclosingClass()) != null && !Modifier.isStatic(parent.getModifiers()) && (parent.isAnonymousClass() || parent.isMemberClass()));
                if (parent != null) {
                    toInstantiate.add(parent);
                }
                CommonUtil.reverse(toInstantiate);
                Object instance = null;
                for (Class clazz : toInstantiate) {
                    instance = instance == null ? CommonUtil.invoke(ClassUtil.getDeclaredConstructor(clazz, new Class[0]), new Object[0]) : CommonUtil.invoke(ClassUtil.getDeclaredConstructor(clazz, instance.getClass()), instance);
                }
                return CommonUtil.invoke(ClassUtil.getDeclaredConstructor(cls, instance.getClass()), instance);
            }
            Constructor<T> constructor = ClassUtil.getDeclaredConstructor(cls, new Class[0]);
            if (constructor == null) {
                throw new IllegalArgumentException("No default constructor found in class: " + ClassUtil.getCanonicalClassName(cls));
            }
            return CommonUtil.invoke(constructor, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw N.toRuntimeException(e);
        }
    }

    private static <T> T invoke(Constructor<T> c, Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!c.isAccessible()) {
            c.setAccessible(true);
        }
        return c.newInstance(args);
    }

    public static <T> T newProxyInstance(Class<T> interfaceClass, InvocationHandler h) {
        return CommonUtil.newProxyInstance(CommonUtil.asArray(interfaceClass), h);
    }

    public static <T> T newProxyInstance(Class<?>[] interfaceClasses, InvocationHandler h) {
        return (T)Proxy.newProxyInstance(CommonUtil.class.getClassLoader(), interfaceClasses, h);
    }

    public static <T> T newArray(Class<?> componentType, int length) {
        return Array.newInstance(componentType, length);
    }

    public static <T> T newEntity(Class<T> cls) {
        return CommonUtil.newEntity(cls, null);
    }

    public static <T> T newEntity(Class<T> cls, String entityName) {
        if (MapEntity.class.isAssignableFrom(cls)) {
            return (T)new MapEntity(entityName);
        }
        Class<?> enclosingClass = ClassUtil.getEnclosingClass(cls);
        if (enclosingClass == null || Modifier.isStatic(cls.getModifiers())) {
            return CommonUtil.newInstance(cls);
        }
        return ClassUtil.invokeConstructor(ClassUtil.getDeclaredConstructor(cls, enclosingClass), CommonUtil.newInstance(enclosingClass));
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    public static int initHashCapacity(int size) {
        CommonUtil.checkArgNotNegative(size, "size");
        if (size == 0) {
            return 0;
        }
        int res = size < 0x6666665E ? (int)((double)size * 1.25) + 1 : 0x7FFFFFF7;
        switch (res / 64) {
            case 0: 
            case 1: {
                return res;
            }
            case 2: 
            case 3: 
            case 4: {
                return 128;
            }
        }
        return 256;
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <T> ArrayList<T> newArrayList(Collection<? extends T> c) {
        return CommonUtil.isNullOrEmpty(c) ? new ArrayList() : new ArrayList<T>(c);
    }

    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    public static <T> LinkedList<T> newLinkedList(Collection<? extends T> c) {
        return CommonUtil.isNullOrEmpty(c) ? new LinkedList() : new LinkedList<T>(c);
    }

    public static <T> Set<T> newHashSet() {
        return new HashSet();
    }

    public static <T> Set<T> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <T> Set<T> newHashSet(Collection<? extends T> c) {
        return CommonUtil.isNullOrEmpty(c) ? new HashSet() : new HashSet<T>(c);
    }

    public static <T> Set<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> newLinkedHashSet(int initialCapacity) {
        return new LinkedHashSet(initialCapacity);
    }

    public static <T> Set<T> newLinkedHashSet(Collection<? extends T> c) {
        return CommonUtil.isNullOrEmpty(c) ? new LinkedHashSet() : new LinkedHashSet<T>(c);
    }

    public static <T extends Comparable> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    public static <T extends Comparable> TreeSet<T> newTreeSet(Collection<? extends T> c) {
        return CommonUtil.isNullOrEmpty(c) ? new TreeSet() : new TreeSet<T>(c);
    }

    public static <T> TreeSet<T> newTreeSet(SortedSet<T> c) {
        return CommonUtil.isNullOrEmpty(c) ? new TreeSet() : new TreeSet<T>(c);
    }

    public static <T> Multiset<T> newMultiset() {
        return new Multiset();
    }

    public static <T> Multiset<T> newMultiset(int initialCapacity) {
        return new Multiset(initialCapacity);
    }

    public static <T> Multiset<T> newMultiset(Class<? extends Map> valueMapType) {
        return new Multiset(valueMapType);
    }

    public static <T> Multiset<T> newMultiset(Supplier<? extends Map<T, ?>> mapSupplier) {
        return new Multiset(mapSupplier);
    }

    public static <T> Multiset<T> newMultiset(Collection<? extends T> c) {
        return new Multiset<T>(c);
    }

    public static <T> ArrayDeque<T> newArrayDeque() {
        return new ArrayDeque();
    }

    public static <T> ArrayDeque<T> newArrayDeque(int numElements) {
        return new ArrayDeque(numElements);
    }

    public static <E> ArrayDeque<E> newArrayDeque(Collection<? extends E> c) {
        return new ArrayDeque<E>(c);
    }

    public static <K, V> Map.Entry<K, V> newEntry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> ImmutableEntry<K, V> newImmutableEntry(K key, V value) {
        return new ImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap(Map<? extends K, ? extends V> m) {
        return CommonUtil.isNullOrEmpty(m) ? new HashMap() : new HashMap<K, V>(m);
    }

    public static <K, V, E extends Exception> Map<K, V> newHashMap(Collection<? extends V> c, Try.Function<? super V, ? extends K, E> keyMapper) throws E {
        CommonUtil.checkArgNotNull(keyMapper);
        if (CommonUtil.isNullOrEmpty(c)) {
            return new HashMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(CommonUtil.initHashCapacity(c.size()));
        for (V v : c) {
            result.put(keyMapper.apply(v), v);
        }
        return result;
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Map<? extends K, ? extends V> m) {
        return CommonUtil.isNullOrEmpty(m) ? new LinkedHashMap() : new LinkedHashMap<K, V>(m);
    }

    public static <K, V, E extends Exception> Map<K, V> newLinkedHashMap(Collection<? extends V> c, Try.Function<? super V, ? extends K, E> keyMapper) throws E {
        CommonUtil.checkArgNotNull(keyMapper);
        if (CommonUtil.isNullOrEmpty(c)) {
            return new LinkedHashMap();
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(CommonUtil.initHashCapacity(c.size()));
        for (V v : c) {
            result.put(keyMapper.apply(v), v);
        }
        return result;
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(Comparator<C> comparator) {
        return new TreeMap(comparator);
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(Map<? extends K, ? extends V> m) {
        return CommonUtil.isNullOrEmpty(m) ? new TreeMap() : new TreeMap<K, V>(m);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, ? extends V> m) {
        return CommonUtil.isNullOrEmpty(m) ? new TreeMap() : new TreeMap<K, V>(m);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(int initialCapacity) {
        return new IdentityHashMap(initialCapacity);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(Map<? extends K, ? extends V> m) {
        return CommonUtil.isNullOrEmpty(m) ? new IdentityHashMap() : new IdentityHashMap<K, V>(m);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> m) {
        return CommonUtil.isNullOrEmpty(m) ? new ConcurrentHashMap() : new ConcurrentHashMap<K, V>(m);
    }

    public static <K, V> BiMap<K, V> newBiMap() {
        return new BiMap();
    }

    public static <K, V> BiMap<K, V> newBiMap(int initialCapacity) {
        return new BiMap(initialCapacity);
    }

    public static <K, V> BiMap<K, V> newBiMap(int initialCapacity, float loadFactor) {
        return new BiMap(initialCapacity, loadFactor);
    }

    public static <K, V> BiMap<K, V> newBiMap(Class<? extends Map> keyMapType, Class<? extends Map> valueMapType) {
        return new BiMap(keyMapType, valueMapType);
    }

    public static <K, V> BiMap<K, V> newBiMap(Supplier<? extends Map<K, V>> keyMapSupplier, Supplier<? extends Map<V, K>> valueMapSupplier) {
        return new BiMap(keyMapSupplier, valueMapSupplier);
    }

    public static <K, E, V extends Collection<E>> Multimap<K, E, V> newMultimap(Supplier<? extends Map<K, V>> mapSupplier, Supplier<? extends V> valueSupplier) {
        return new Multimap(mapSupplier, valueSupplier);
    }

    public static <K, E> ListMultimap<K, E> newListMultimap() {
        return new ListMultimap();
    }

    public static <K, E> ListMultimap<K, E> newListMultimap(int initialCapacity) {
        return new ListMultimap(initialCapacity);
    }

    public static <K, E> ListMultimap<K, E> newListMultimap(Map<? extends K, ? extends E> m) {
        ListMultimap<? extends K, ? extends E> multiMap = CommonUtil.newListMultimap();
        multiMap.putAll(m);
        return multiMap;
    }

    public static <K, E> ListMultimap<K, E> newListLinkedMultimap() {
        return new ListMultimap((Class<? extends Map>)((Class<Map>)LinkedHashMap.class), (Class<? extends List>)((Class<List>)ArrayList.class));
    }

    public static <K, E> ListMultimap<K, E> newListLinkedMultimap(int initialCapacity) {
        return new ListMultimap(new LinkedHashMap(initialCapacity), ArrayList.class);
    }

    public static <K, E> ListMultimap<K, E> newListLinkedMultimap(Map<? extends K, ? extends E> m) {
        ListMultimap<? extends K, ? extends E> multiMap = new ListMultimap<K, E>(new LinkedHashMap(), ArrayList.class);
        multiMap.putAll(m);
        return multiMap;
    }

    public static <K extends Comparable<K>, E> ListMultimap<K, E> newListSortedMultimap() {
        return new ListMultimap(new TreeMap(), ArrayList.class);
    }

    public static <K extends Comparable<K>, E> ListMultimap<K, E> newListSortedMultimap(Map<? extends K, ? extends E> m) {
        ListMultimap<? extends K, ? extends E> multiMap = new ListMultimap<K, E>(new TreeMap(), ArrayList.class);
        multiMap.putAll(m);
        return multiMap;
    }

    public static <K, E> ListMultimap<K, E> newListMultimap(Class<? extends Map> mapType) {
        return new ListMultimap((Class<? extends Map>)((Class<Map>)mapType), (Class<? extends List>)((Class<List>)ArrayList.class));
    }

    public static <K, E> ListMultimap<K, E> newListMultimap(Class<? extends Map> mapType, Class<? extends List> valueType) {
        return new ListMultimap((Class<? extends Map>)((Class<Map>)mapType), (Class<? extends List>)((Class<List>)valueType));
    }

    public static <K, E> ListMultimap<K, E> newListMultimap(Supplier<? extends Map<K, List<E>>> mapSupplier, Supplier<? extends List<E>> valueSupplier) {
        return new ListMultimap(mapSupplier, valueSupplier);
    }

    public static <K, E> SetMultimap<K, E> newSetMultimap() {
        return new SetMultimap();
    }

    public static <K, E> SetMultimap<K, E> newSetMultimap(int initialCapacity) {
        return new SetMultimap(initialCapacity);
    }

    public static <K, E> SetMultimap<K, E> newSetMultimap(Map<? extends K, ? extends E> m) {
        SetMultimap<? extends K, ? extends E> multiMap = CommonUtil.newSetMultimap();
        multiMap.putAll(m);
        return multiMap;
    }

    public static <K, E> SetMultimap<K, E> newSetLinkedMultimap() {
        return new SetMultimap((Class<? extends Map>)((Class<Map>)LinkedHashMap.class), (Class<? extends Set>)((Class<Set>)HashSet.class));
    }

    public static <K, E> SetMultimap<K, E> newSetLinkedMultimap(int initialCapacity) {
        return new SetMultimap(new LinkedHashMap(initialCapacity), HashSet.class);
    }

    public static <K, E> SetMultimap<K, E> newSetLinkedMultimap(Map<? extends K, ? extends E> m) {
        SetMultimap<? extends K, ? extends E> multiMap = new SetMultimap<K, E>(new LinkedHashMap(), HashSet.class);
        multiMap.putAll(m);
        return multiMap;
    }

    public static <K extends Comparable<K>, E> SetMultimap<K, E> newSetSortedMultimap() {
        return new SetMultimap(new TreeMap(), HashSet.class);
    }

    public static <K extends Comparable<K>, E> SetMultimap<K, E> newSetSortedMultimap(Map<? extends K, ? extends E> m) {
        SetMultimap<? extends K, ? extends E> multiMap = new SetMultimap<K, E>(new TreeMap(), HashSet.class);
        multiMap.putAll(m);
        return multiMap;
    }

    public static <K, E> SetMultimap<K, E> newSetMultimap(Class<? extends Map> mapType) {
        return new SetMultimap((Class<? extends Map>)((Class<Map>)mapType), (Class<? extends Set>)((Class<Set>)HashSet.class));
    }

    public static <K, E> SetMultimap<K, E> newSetMultimap(Class<? extends Map> mapType, Class<? extends Set> valueType) {
        return new SetMultimap((Class<? extends Map>)((Class<Map>)mapType), (Class<? extends Set>)((Class<Set>)valueType));
    }

    public static <K, E> SetMultimap<K, E> newSetMultimap(Supplier<? extends Map<K, Set<E>>> mapSupplier, Supplier<? extends Set<E>> valueSupplier) {
        return new SetMultimap(mapSupplier, valueSupplier);
    }

    public static DataSet newEmptyDataSet() {
        return new RowDataSet(new ArrayList<String>(), new ArrayList<List<Object>>());
    }

    public static DataSet newEmptyDataSet(Collection<String> columnNames) {
        if (CommonUtil.isNullOrEmpty(columnNames)) {
            return CommonUtil.newEmptyDataSet();
        }
        ArrayList<List<Object>> columnList = new ArrayList<List<Object>>(columnNames.size());
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            columnList.add(new ArrayList(0));
        }
        return new RowDataSet(new ArrayList<String>(columnNames), columnList);
    }

    public static DataSet newDataSet(String keyColumnName, String valueColumnName, Map<?, ?> m) {
        ArrayList keyColumn = new ArrayList(m.size());
        ArrayList valueColumn = new ArrayList(m.size());
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            keyColumn.add(entry.getKey());
            valueColumn.add(entry.getValue());
        }
        List<String> columnNameList = CommonUtil.asList(keyColumnName, valueColumnName);
        List columnList = CommonUtil.asList(keyColumn, valueColumn);
        return CommonUtil.newDataSet(columnNameList, columnList);
    }

    public static <T> DataSet newDataSet(Collection<T> rows) {
        return CommonUtil.newDataSet(null, rows);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> DataSet newDataSet(Collection<String> columnNames, Collection<T> rowList) {
        if (CommonUtil.isNullOrEmpty(columnNames) && CommonUtil.isNullOrEmpty(rowList)) {
            return CommonUtil.newEmptyDataSet();
        }
        if (CommonUtil.isNullOrEmpty(rowList)) {
            return CommonUtil.newEmptyDataSet(columnNames);
        }
        int rowSize = rowList.size();
        if (CommonUtil.isNullOrEmpty(columnNames)) {
            Set<T> columnNameSet = CommonUtil.newLinkedHashSet();
            Set<T> clsSet = null;
            HashMap clsSignedPropNameSetMap = new HashMap();
            Class<?> cls = null;
            Type<T> type = null;
            for (T t : rowList) {
                if (t == null) continue;
                cls = t.getClass();
                type = CommonUtil.typeOf(cls);
                if (type.isMap()) {
                    columnNameSet.addAll(((Map)t).keySet());
                    continue;
                }
                if (type.isEntity()) {
                    if (t instanceof DirtyMarker) {
                        Set<T> clsSignedPropNameSet = (Set<T>)clsSignedPropNameSetMap.get(cls);
                        if (clsSignedPropNameSet == null) {
                            clsSignedPropNameSet = CommonUtil.newHashSet();
                            clsSignedPropNameSetMap.put(cls, clsSignedPropNameSet);
                        }
                        Method method = null;
                        for (String signedPropName : DirtyMarkerUtil.signedPropNames((DirtyMarker)t)) {
                            if (!clsSignedPropNameSet.add(signedPropName) || (method = ClassUtil.getPropGetMethod(cls, signedPropName)) == null) continue;
                            columnNameSet.add(ClassUtil.getPropNameByMethod(method));
                        }
                        continue;
                    }
                    if (clsSet == null) {
                        clsSet = CommonUtil.newHashSet();
                    }
                    if (clsSet.contains(cls)) continue;
                    columnNameSet.addAll(ClassUtil.checkPropGetMethodList(cls).keySet());
                    clsSet.add(cls);
                    continue;
                }
                throw new IllegalArgumentException("'columnNameList' is required if the sepcified row type is not Entity or Map");
            }
            for (Map.Entry entry : clsSignedPropNameSetMap.entrySet()) {
                List<String> intersecion = N.intersection(ClassUtil.getPropGetMethodList((Class)entry.getKey()).keySet(), columnNameSet);
                columnNameSet.removeAll(intersecion);
                columnNameSet.addAll(intersecion);
            }
            columnNames = new ArrayList<T>(columnNameSet);
            if (CommonUtil.isNullOrEmpty(columnNames)) {
                throw new IllegalArgumentException("Column name list can not be obtained from row list because it's empty or null");
            }
        }
        int columnCount = columnNames.size();
        ArrayList<String> columnNameList = new ArrayList<String>(columnNames);
        ArrayList<List<Object>> columnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnList.add(new ArrayList(rowSize));
        }
        Type<T> type = null;
        for (T e : rowList) {
            if (e == null) {
                void var9_16;
                boolean bl = false;
                while (var9_16 < columnCount) {
                    ((List)columnList.get((int)var9_16)).add(null);
                    ++var9_16;
                }
                continue;
            }
            type = CommonUtil.typeOf(e.getClass());
            if (type.isMap()) {
                Map map = (Map)e;
                for (int i = 0; i < columnCount; ++i) {
                    ((List)columnList.get(i)).add(map.get(columnNameList.get(i)));
                }
                continue;
            }
            if (type.isEntity()) {
                Class<?> clazz = e.getClass();
                Method method = null;
                for (int i = 0; i < columnCount; ++i) {
                    method = ClassUtil.getPropGetMethod(clazz, (String)columnNameList.get(i));
                    if (method == null) {
                        ((List)columnList.get(i)).add(null);
                        continue;
                    }
                    ((List)columnList.get(i)).add(ClassUtil.getPropValue(e, method));
                }
                continue;
            }
            if (type.isArray()) {
                if (type.isPrimitiveArray()) {
                    void var9_20;
                    boolean bl = false;
                    while (var9_20 < columnCount) {
                        ((List)columnList.get((int)var9_20)).add(Array.get(e, (int)var9_20));
                        ++var9_20;
                    }
                    continue;
                }
                Object[] objectArray = (Object[])e;
                for (int i = 0; i < columnCount; ++i) {
                    ((List)columnList.get(i)).add(objectArray[i]);
                }
                continue;
            }
            if (type.isCollection()) {
                Iterator iterator = ((Collection)e).iterator();
                for (int i = 0; i < columnCount; ++i) {
                    ((List)columnList.get(i)).add(iterator.next());
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported row type: " + ClassUtil.getCanonicalClassName(e.getClass()) + ". Only array, collection, map and entity are supported");
        }
        return new RowDataSet(columnNameList, columnList);
    }

    public static <C extends Collection<?>> DataSet newDataSet(Map<String, C> map) {
        if (CommonUtil.isNullOrEmpty(map)) {
            return CommonUtil.newEmptyDataSet();
        }
        int maxColumnLen = 0;
        for (Collection v : map.values()) {
            maxColumnLen = N.max(maxColumnLen, CommonUtil.size(v));
        }
        ArrayList<String> columnNameList = new ArrayList<String>(map.keySet());
        ArrayList<List<Object>> columnList = new ArrayList<List<Object>>(columnNameList.size());
        ArrayList column = null;
        for (Collection v : map.values()) {
            column = new ArrayList(maxColumnLen);
            if (CommonUtil.notNullOrEmpty(v)) {
                column.addAll(v);
            }
            if (column.size() < maxColumnLen) {
                CommonUtil.fill(column, column.size(), maxColumnLen, null);
            }
            columnList.add(column);
        }
        return new RowDataSet(columnNameList, columnList);
    }

    public static Object[] toArray(Collection<?> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return EMPTY_OBJECT_ARRAY;
        }
        return c.toArray(new Object[c.size()]);
    }

    public static Object[] toArray(Collection<?> c, int fromIndex, int toIndex) {
        int idx;
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (CommonUtil.isNullOrEmpty(c)) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (fromIndex == 0 || toIndex == c.size()) {
            return c.toArray(new Object[c.size()]);
        }
        if (c instanceof List) {
            return ((List)c).subList(fromIndex, toIndex).toArray(new Object[toIndex - fromIndex]);
        }
        Object[] res = new Object[toIndex - fromIndex];
        Iterator<?> iter = c.iterator();
        for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
            iter.next();
        }
        while (idx < toIndex && iter.hasNext()) {
            res[idx - fromIndex] = iter.next();
            ++idx;
        }
        return res;
    }

    public static <A, T extends A> A[] toArray(Collection<T> c, A[] a) {
        CommonUtil.checkArgNotNull(a);
        if (CommonUtil.isNullOrEmpty(c)) {
            return a;
        }
        return c.toArray(a);
    }

    public static <A, T extends A> A[] toArray(Collection<T> c, int fromIndex, int toIndex, A[] a) {
        int idx;
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        CommonUtil.checkArgNotNull(a);
        if (CommonUtil.isNullOrEmpty(c)) {
            return a;
        }
        if (fromIndex == 0 || toIndex == c.size()) {
            return c.toArray(a);
        }
        if (c instanceof List) {
            return ((List)c).subList(fromIndex, toIndex).toArray(a);
        }
        A[] res = a.length >= toIndex - fromIndex ? a : (Object[])CommonUtil.newArray(a.getClass().getComponentType(), toIndex - fromIndex);
        Iterator<T> iter = c.iterator();
        for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
            iter.next();
        }
        while (idx < toIndex && iter.hasNext()) {
            res[idx - fromIndex] = iter.next();
            ++idx;
        }
        return res;
    }

    public static <A, T extends A> A[] toArray(Collection<T> c, IntFunction<A[]> arraySupplier) {
        CommonUtil.checkArgNotNull(arraySupplier);
        if (CommonUtil.isNullOrEmpty(c)) {
            return arraySupplier.apply(0);
        }
        return CommonUtil.toArray(c, arraySupplier);
    }

    public static <A, T extends A> A[] toArray(Collection<T> c, int fromIndex, int toIndex, IntFunction<A[]> arraySupplier) {
        int idx;
        CommonUtil.checkArgNotNull(arraySupplier);
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (CommonUtil.isNullOrEmpty(c)) {
            return arraySupplier.apply(0);
        }
        if (fromIndex == 0 || toIndex == c.size()) {
            return c.toArray(arraySupplier.apply(c.size()));
        }
        if (c instanceof List) {
            return ((List)c).subList(fromIndex, toIndex).toArray(arraySupplier.apply(toIndex - fromIndex));
        }
        A[] res = arraySupplier.apply(toIndex - fromIndex);
        Iterator<T> iter = c.iterator();
        for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
            iter.next();
        }
        while (idx < toIndex && iter.hasNext()) {
            res[idx - fromIndex] = iter.next();
            ++idx;
        }
        return res;
    }

    public static <A, T extends A> A[] toArray(Class<A[]> targetClass, Collection<T> c) {
        CommonUtil.checkArgNotNull(targetClass);
        if (CommonUtil.isNullOrEmpty(c)) {
            return (Object[])CommonUtil.newArray(targetClass.getComponentType(), 0);
        }
        return c.toArray((Object[])CommonUtil.newArray(targetClass.getComponentType(), c.size()));
    }

    public static <A, T extends A> A[] toArray(Class<A[]> targetClass, Collection<T> c, int fromIndex, int toIndex) {
        int idx;
        CommonUtil.checkArgNotNull(targetClass);
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        Object[] res = (Object[])CommonUtil.newArray(targetClass.getComponentType(), toIndex - fromIndex);
        if (CommonUtil.isNullOrEmpty(c)) {
            return res;
        }
        if (fromIndex == 0 || toIndex == c.size()) {
            return c.toArray(res);
        }
        if (c instanceof List) {
            return ((List)c).subList(fromIndex, toIndex).toArray(res);
        }
        Iterator<T> iter = c.iterator();
        for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
            iter.next();
        }
        while (idx < toIndex && iter.hasNext()) {
            res[idx - fromIndex] = iter.next();
            ++idx;
        }
        return res;
    }

    public static boolean[] toBooleanArray(Collection<Boolean> c) {
        return CommonUtil.toBooleanArray(c, false);
    }

    public static boolean[] toBooleanArray(Collection<Boolean> c, int fromIndex, int toIndex) {
        return CommonUtil.toBooleanArray(c, fromIndex, toIndex, false);
    }

    public static boolean[] toBooleanArray(Collection<Boolean> c, boolean defaultForNull) {
        return CommonUtil.toBooleanArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static boolean[] toBooleanArray(Collection<Boolean> c, int fromIndex, int toIndex, boolean defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        int len = toIndex - fromIndex;
        boolean[] result = new boolean[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Boolean val = null;
            for (int i = 0; i < len; ++i) {
                val = (Boolean)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val;
            }
        } else {
            Iterator<Boolean> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Boolean val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val;
            }
        }
        return result;
    }

    public static char[] toCharArray(Collection<Character> c) {
        return CommonUtil.toCharArray(c, '\u0000');
    }

    public static char[] toCharArray(Collection<Character> c, int fromIndex, int toIndex) {
        return CommonUtil.toCharArray(c, fromIndex, toIndex, '\u0000');
    }

    public static char[] toCharArray(Collection<Character> c, char defaultForNull) {
        return CommonUtil.toCharArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static char[] toCharArray(Collection<Character> c, int fromIndex, int toIndex, char defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_CHAR_ARRAY;
        }
        int len = toIndex - fromIndex;
        char[] result = new char[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Character val = null;
            for (int i = 0; i < len; ++i) {
                val = (Character)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val.charValue();
            }
        } else {
            Iterator<Character> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Character val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val.charValue();
            }
        }
        return result;
    }

    public static byte[] toByteArray(Collection<? extends Number> c) {
        return CommonUtil.toByteArray(c, (byte)0);
    }

    public static byte[] toByteArray(Collection<? extends Number> c, int fromIndex, int toIndex) {
        return CommonUtil.toByteArray(c, fromIndex, toIndex, (byte)0);
    }

    public static byte[] toByteArray(Collection<? extends Number> c, byte defaultForNull) {
        return CommonUtil.toByteArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static byte[] toByteArray(Collection<? extends Number> c, int fromIndex, int toIndex, byte defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_BYTE_ARRAY;
        }
        int len = toIndex - fromIndex;
        byte[] result = new byte[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = (Number)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val.byteValue();
            }
        } else {
            Iterator<? extends Number> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val.byteValue();
            }
        }
        return result;
    }

    public static short[] toShortArray(Collection<? extends Number> c) {
        return CommonUtil.toShortArray(c, (short)0);
    }

    public static short[] toShortArray(Collection<? extends Number> c, int fromIndex, int toIndex) {
        return CommonUtil.toShortArray(c, fromIndex, toIndex, (short)0);
    }

    public static short[] toShortArray(Collection<? extends Number> c, short defaultForNull) {
        return CommonUtil.toShortArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static short[] toShortArray(Collection<? extends Number> c, int fromIndex, int toIndex, short defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_SHORT_ARRAY;
        }
        int len = toIndex - fromIndex;
        short[] result = new short[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = (Number)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val.shortValue();
            }
        } else {
            Iterator<? extends Number> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val.shortValue();
            }
        }
        return result;
    }

    public static int[] toIntArray(Collection<? extends Number> c) {
        return CommonUtil.toIntArray(c, 0);
    }

    public static int[] toIntArray(Collection<? extends Number> c, int fromIndex, int toIndex) {
        return CommonUtil.toIntArray(c, fromIndex, toIndex, 0);
    }

    public static int[] toIntArray(Collection<? extends Number> c, int defaultForNull) {
        return CommonUtil.toIntArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static int[] toIntArray(Collection<? extends Number> c, int fromIndex, int toIndex, int defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_INT_ARRAY;
        }
        int len = toIndex - fromIndex;
        int[] result = new int[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = (Number)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val.intValue();
            }
        } else {
            Iterator<? extends Number> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val.intValue();
            }
        }
        return result;
    }

    public static long[] toLongArray(Collection<? extends Number> c) {
        return CommonUtil.toLongArray(c, 0L);
    }

    public static long[] toLongArray(Collection<? extends Number> c, int fromIndex, int toIndex) {
        return CommonUtil.toLongArray(c, fromIndex, toIndex, 0L);
    }

    public static long[] toLongArray(Collection<? extends Number> c, long defaultForNull) {
        return CommonUtil.toLongArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static long[] toLongArray(Collection<? extends Number> c, int fromIndex, int toIndex, long defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_LONG_ARRAY;
        }
        int len = toIndex - fromIndex;
        long[] result = new long[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = (Number)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val.longValue();
            }
        } else {
            Iterator<? extends Number> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val.longValue();
            }
        }
        return result;
    }

    public static float[] toFloatArray(Collection<? extends Number> c) {
        return CommonUtil.toFloatArray(c, 0.0f);
    }

    public static float[] toFloatArray(Collection<? extends Number> c, int fromIndex, int toIndex) {
        return CommonUtil.toFloatArray(c, fromIndex, toIndex, 0.0f);
    }

    public static float[] toFloatArray(Collection<? extends Number> c, float defaultForNull) {
        return CommonUtil.toFloatArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static float[] toFloatArray(Collection<? extends Number> c, int fromIndex, int toIndex, float defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_FLOAT_ARRAY;
        }
        int len = toIndex - fromIndex;
        float[] result = new float[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = (Number)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val.floatValue();
            }
        } else {
            Iterator<? extends Number> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val.floatValue();
            }
        }
        return result;
    }

    public static double[] toDoubleArray(Collection<? extends Number> c) {
        return CommonUtil.toDoubleArray(c, 0.0);
    }

    public static double[] toDoubleArray(Collection<? extends Number> c, int fromIndex, int toIndex) {
        return CommonUtil.toDoubleArray(c, fromIndex, toIndex, 0.0);
    }

    public static double[] toDoubleArray(Collection<? extends Number> c, double defaultForNull) {
        return CommonUtil.toDoubleArray(c, 0, CommonUtil.size(c), defaultForNull);
    }

    public static double[] toDoubleArray(Collection<? extends Number> c, int fromIndex, int toIndex, double defaultForNull) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(c));
        if (fromIndex == toIndex) {
            return EMPTY_DOUBLE_ARRAY;
        }
        int len = toIndex - fromIndex;
        double[] result = new double[len];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = (Number)list.get(i + fromIndex);
                result[i] = val == null ? defaultForNull : val.doubleValue();
            }
        } else {
            Iterator<? extends Number> iter = c.iterator();
            if (fromIndex > 0) {
                int offset = 0;
                while (offset++ < fromIndex) {
                    iter.next();
                }
            }
            Number val = null;
            for (int i = 0; i < len; ++i) {
                val = iter.next();
                result[i] = val == null ? defaultForNull : val.doubleValue();
            }
        }
        return result;
    }

    public static List<Boolean> toList(boolean[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Boolean> toList(boolean[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static List<Character> toList(char[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Character> toList(char[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> result = new ArrayList<Character>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(Character.valueOf(a[i]));
        }
        return result;
    }

    public static List<Byte> toList(byte[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Byte> toList(byte[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Byte>();
        }
        ArrayList<Byte> result = new ArrayList<Byte>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static List<Short> toList(short[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Short> toList(short[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> result = new ArrayList<Short>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static List<Integer> toList(int[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Integer> toList(int[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static List<Long> toList(long[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Long> toList(long[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> result = new ArrayList<Long>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static List<Float> toList(float[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Float> toList(float[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> result = new ArrayList<Float>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(Float.valueOf(a[i]));
        }
        return result;
    }

    public static List<Double> toList(double[] a) {
        return CommonUtil.toList(a, 0, CommonUtil.len(a));
    }

    public static List<Double> toList(double[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> result = new ArrayList<Double>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static <T> List<T> toList(T[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return CommonUtil.asList(a);
    }

    public static <T> List<T> toList(T[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return new ArrayList();
        }
        if (fromIndex == 0 && toIndex == a.length) {
            return CommonUtil.asList(a);
        }
        ArrayList<T> result = new ArrayList<T>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static Set<Boolean> toSet(boolean[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Boolean> toSet(boolean[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Boolean> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static Set<Character> toSet(char[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Character> toSet(char[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Character> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(Character.valueOf(a[i]));
        }
        return result;
    }

    public static Set<Byte> toSet(byte[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Byte> toSet(byte[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Byte> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static Set<Short> toSet(short[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Short> toSet(short[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Short> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static Set<Integer> toSet(int[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Integer> toSet(int[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Integer> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static Set<Long> toSet(long[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Long> toSet(long[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Long> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static Set<Float> toSet(float[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Float> toSet(float[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Float> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(Float.valueOf(a[i]));
        }
        return result;
    }

    public static Set<Double> toSet(double[] a) {
        return CommonUtil.toSet(a, 0, CommonUtil.len(a));
    }

    public static Set<Double> toSet(double[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<Double> result = CommonUtil.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static <T> Set<T> toSet(T[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.newHashSet();
        }
        return CommonUtil.asSet(a);
    }

    public static <T> Set<T> toSet(T[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return CommonUtil.newHashSet();
        }
        Set<T> result = CommonUtil.newHashSet(CommonUtil.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static <C extends Collection<Boolean>> C toCollection(boolean[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Boolean>> C toCollection(boolean[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return (C)result;
    }

    public static <C extends Collection<Character>> C toCollection(char[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Character>> C toCollection(char[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(Character.valueOf(a[i]));
        }
        return (C)result;
    }

    public static <C extends Collection<Byte>> C toCollection(byte[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Byte>> C toCollection(byte[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return (C)result;
    }

    public static <C extends Collection<Short>> C toCollection(short[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Short>> C toCollection(short[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return (C)result;
    }

    public static <C extends Collection<Integer>> C toCollection(int[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Integer>> C toCollection(int[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return (C)result;
    }

    public static <C extends Collection<Long>> C toCollection(long[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Long>> C toCollection(long[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return (C)result;
    }

    public static <C extends Collection<Float>> C toCollection(float[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Float>> C toCollection(float[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(Float.valueOf(a[i]));
        }
        return (C)result;
    }

    public static <C extends Collection<Double>> C toCollection(double[] a, IntFunction<? extends C> supplier) {
        return CommonUtil.toCollection(a, 0, CommonUtil.len(a), supplier);
    }

    public static <C extends Collection<Double>> C toCollection(double[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return (C)result;
    }

    public static <T, C extends Collection<T>> C toCollection(T[] a, IntFunction<? extends C> supplier) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        return CommonUtil.toCollection(a, 0, a.length, supplier);
    }

    public static <T, C extends Collection<T>> C toCollection(T[] a, int fromIndex, int toIndex, IntFunction<? extends C> supplier) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        if (fromIndex == 0 && toIndex == a.length && a.length >= 9) {
            Collection result = (Collection)supplier.apply(a.length);
            result.addAll(Arrays.asList(a));
            return (C)result;
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(a[i]);
        }
        return (C)result;
    }

    @SafeVarargs
    public static <T> T[] asArray(T ... a) {
        return a;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <K, V, T extends Map<K, V>> T newMap(T m, Object ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return m;
        }
        if (a.length == 1) {
            if (a[0] instanceof Map) {
                m.putAll((Map)a[0]);
                return m;
            } else {
                if (!ClassUtil.isEntity(a[0].getClass())) throw new IllegalArgumentException("The parameters must be the pairs of property name and value, or Map, or an entity class with getter/setter methods.");
                Maps.entity2Map(m, a[0]);
            }
            return m;
        } else {
            if (0 != a.length % 2) {
                throw new IllegalArgumentException("The parameters must be the pairs of property name and value, or Map, or an entity class with getter/setter methods.");
            }
            for (int i = 0; i < a.length; ++i) {
                m.put((Object)a[i], (Object)a[++i]);
            }
        }
        return m;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asMap(k k1, v v1) {
        HashMap<k, v> map = new HashMap<k, v>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asMap(k k1, v v1, k k2, v v2) {
        HashMap<k, v> map = new HashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asMap(k k1, v v1, k k2, v v2, k k3, v v3) {
        HashMap<k, v> map = new HashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4) {
        HashMap<k, v> map = new HashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5) {
        HashMap<k, v> map = new HashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6) {
        HashMap<k, v> map = new HashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6, k k7, v v7) {
        HashMap<k, v> map = new HashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    @SafeVarargs
    @NullSafe
    public static <K, V> Map<K, V> asMap(Object ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new HashMap();
        }
        return CommonUtil.newMap(new HashMap(CommonUtil.initHashCapacity(a.length / 2)), a);
    }

    @SafeVarargs
    public static Map<String, Object> asProps(Object ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new LinkedHashMap<String, Object>();
        }
        return CommonUtil.newMap(new LinkedHashMap(CommonUtil.initHashCapacity(a.length / 2)), a);
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asLinkedHashMap(k k1, v v1) {
        LinkedHashMap<k, v> map = new LinkedHashMap<k, v>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asLinkedHashMap(k k1, v v1, k k2, v v2) {
        LinkedHashMap<k, v> map = new LinkedHashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asLinkedHashMap(k k1, v v1, k k2, v v2, k k3, v v3) {
        LinkedHashMap<k, v> map = new LinkedHashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asLinkedHashMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4) {
        LinkedHashMap<k, v> map = new LinkedHashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asLinkedHashMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5) {
        LinkedHashMap<k, v> map = new LinkedHashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asLinkedHashMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6) {
        LinkedHashMap<k, v> map = new LinkedHashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V, k extends K, v extends V> Map<K, V> asLinkedHashMap(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6, k k7, v v7) {
        LinkedHashMap<k, v> map = new LinkedHashMap<k, v>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> asLinkedHashMap(Object ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new LinkedHashMap();
        }
        return CommonUtil.newMap(new LinkedHashMap(CommonUtil.initHashCapacity(a.length / 2)), a);
    }

    public static <T> List<T> asList(T e) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(e);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2) {
        ArrayList<T> list = new ArrayList<T>(2);
        list.add(e1);
        list.add(e2);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2, T e3) {
        ArrayList<T> list = new ArrayList<T>(3);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2, T e3, T e4) {
        ArrayList<T> list = new ArrayList<T>(4);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2, T e3, T e4, T e5) {
        ArrayList<T> list = new ArrayList<T>(5);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2, T e3, T e4, T e5, T e6) {
        ArrayList<T> list = new ArrayList<T>(6);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2, T e3, T e4, T e5, T e6, T e7) {
        ArrayList<T> list = new ArrayList<T>(7);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        list.add(e7);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2, T e3, T e4, T e5, T e6, T e7, T e8) {
        ArrayList<T> list = new ArrayList<T>(8);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        list.add(e7);
        list.add(e8);
        return list;
    }

    public static <T> List<T> asList(T e1, T e2, T e3, T e4, T e5, T e6, T e7, T e8, T e9) {
        ArrayList<T> list = new ArrayList<T>(9);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        list.add(e7);
        list.add(e8);
        list.add(e9);
        return list;
    }

    @SafeVarargs
    @NullSafe
    public static <T> List<T> asList(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>(a.length);
        if (a.length < 9) {
            for (T e : a) {
                list.add(e);
            }
        } else {
            list.addAll(Arrays.asList(a));
        }
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(T e) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(e);
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(T e1, T e2) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(e1);
        list.add(e2);
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(T e1, T e2, T e3) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(e1);
        list.add(e2);
        list.add(e3);
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(T e1, T e2, T e3, T e4) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(T e1, T e2, T e3, T e4, T e5) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(T e1, T e2, T e3, T e4, T e5, T e6) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(T e1, T e2, T e3, T e4, T e5, T e6, T e7) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        list.add(e7);
        return list;
    }

    @SafeVarargs
    @NullSafe
    public static <T> LinkedList<T> asLinkedList(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new LinkedList();
        }
        LinkedList<T> list = new LinkedList<T>();
        for (T e : a) {
            list.add(e);
        }
        return list;
    }

    public static <T> Set<T> asSet(T e) {
        Set<T> set = CommonUtil.newHashSet(1);
        set.add(e);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2) {
        Set<T> set = CommonUtil.newHashSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2, T e3) {
        Set<T> set = CommonUtil.newHashSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2, T e3, T e4) {
        Set<T> set = CommonUtil.newHashSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2, T e3, T e4, T e5) {
        Set<T> set = CommonUtil.newHashSet(5);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2, T e3, T e4, T e5, T e6) {
        Set<T> set = CommonUtil.newHashSet(6);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        set.add(e6);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2, T e3, T e4, T e5, T e6, T e7) {
        Set<T> set = CommonUtil.newHashSet(7);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        set.add(e6);
        set.add(e7);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2, T e3, T e4, T e5, T e6, T e7, T e8) {
        Set<T> set = CommonUtil.newHashSet(8);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        set.add(e6);
        set.add(e7);
        set.add(e8);
        return set;
    }

    public static <T> Set<T> asSet(T e1, T e2, T e3, T e4, T e5, T e6, T e7, T e8, T e9) {
        Set<T> set = CommonUtil.newHashSet(9);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        set.add(e6);
        set.add(e7);
        set.add(e8);
        set.add(e9);
        return set;
    }

    @SafeVarargs
    @NullSafe
    public static <T> Set<T> asSet(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.newHashSet();
        }
        Set<T> set = CommonUtil.newHashSet(CommonUtil.initHashCapacity(a.length));
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    public static <T> Set<T> asLinkedHashSet(T e) {
        Set<T> set = CommonUtil.newLinkedHashSet(1);
        set.add(e);
        return set;
    }

    public static <T> Set<T> asLinkedHashSet(T e1, T e2) {
        Set<T> set = CommonUtil.newLinkedHashSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    public static <T> Set<T> asLinkedHashSet(T e1, T e2, T e3) {
        Set<T> set = CommonUtil.newLinkedHashSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    public static <T> Set<T> asLinkedHashSet(T e1, T e2, T e3, T e4) {
        Set<T> set = CommonUtil.newLinkedHashSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    public static <T> Set<T> asLinkedHashSet(T e1, T e2, T e3, T e4, T e5) {
        Set<T> set = CommonUtil.newLinkedHashSet(5);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        return set;
    }

    public static <T> Set<T> asLinkedHashSet(T e1, T e2, T e3, T e4, T e5, T e6) {
        Set<T> set = CommonUtil.newLinkedHashSet(6);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        set.add(e6);
        return set;
    }

    public static <T> Set<T> asLinkedHashSet(T e1, T e2, T e3, T e4, T e5, T e6, T e7) {
        Set<T> set = CommonUtil.newLinkedHashSet(7);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        set.add(e6);
        set.add(e7);
        return set;
    }

    @SafeVarargs
    @NullSafe
    public static <T> Set<T> asLinkedHashSet(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.newLinkedHashSet();
        }
        Set<T> set = CommonUtil.newLinkedHashSet(CommonUtil.initHashCapacity(a.length));
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    @NullSafe
    public static <T> SortedSet<T> asSortedSet(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new TreeSet();
        }
        TreeSet<T> set = new TreeSet<T>();
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    public static <T> NavigableSet<T> asNavigableSet(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new TreeSet();
        }
        TreeSet<T> set = new TreeSet<T>();
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    @SafeVarargs
    public static <T> Queue<T> asQueue(T ... a) {
        return CommonUtil.asArrayDeque(a);
    }

    @SafeVarargs
    public static <T> ArrayBlockingQueue<T> asArrayBlockingQueue(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new ArrayBlockingQueue(0);
        }
        ArrayBlockingQueue<T> queue = new ArrayBlockingQueue<T>(a.length);
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    @SafeVarargs
    public static <T> LinkedBlockingQueue<T> asLinkedBlockingQueue(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new LinkedBlockingQueue();
        }
        LinkedBlockingQueue<T> queue = new LinkedBlockingQueue<T>(a.length);
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    @SafeVarargs
    public static <T> ConcurrentLinkedQueue<T> asConcurrentLinkedQueue(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new ConcurrentLinkedQueue();
        }
        ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>();
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    @SafeVarargs
    public static <T extends Delayed> DelayQueue<T> asDelayQueue(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new DelayQueue();
        }
        DelayQueue<T> queue = new DelayQueue<T>();
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    @SafeVarargs
    public static <T> PriorityQueue<T> asPriorityQueue(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new PriorityQueue();
        }
        PriorityQueue<T> queue = new PriorityQueue<T>(a.length);
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    @SafeVarargs
    public static <T> Deque<T> asDeque(T ... a) {
        return CommonUtil.asArrayDeque(a);
    }

    @SafeVarargs
    public static <T> ArrayDeque<T> asArrayDeque(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new ArrayDeque();
        }
        ArrayDeque<T> arrayDeque = new ArrayDeque<T>(a.length);
        for (T e : a) {
            arrayDeque.add(e);
        }
        return arrayDeque;
    }

    @SafeVarargs
    public static <T> LinkedBlockingDeque<T> asLinkedBlockingDeque(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new LinkedBlockingDeque();
        }
        LinkedBlockingDeque<T> deque = new LinkedBlockingDeque<T>(a.length);
        for (T e : a) {
            deque.add(e);
        }
        return deque;
    }

    @SafeVarargs
    public static <T> ConcurrentLinkedDeque<T> asConcurrentLinkedDeque(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new ConcurrentLinkedDeque();
        }
        ConcurrentLinkedDeque<T> deque = new ConcurrentLinkedDeque<T>();
        for (T e : a) {
            deque.add(e);
        }
        return deque;
    }

    @SafeVarargs
    public static <T> Multiset<T> asMultiset(T ... a) {
        return Multiset.of(a);
    }

    public static <T> List<T> asSingletonList(T o) {
        return Collections.singletonList(o);
    }

    public static <T> Set<T> asSingletonSet(T o) {
        return Collections.singleton(o);
    }

    public static <K, V> Map<K, V> asSingletonMap(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <T> T convert(Object obj, Class<? extends T> targetClass) {
        if (obj == null) {
            return CommonUtil.defaultValueOf(targetClass);
        }
        Type<T> type = CommonUtil.typeOf(targetClass);
        return CommonUtil.convert(obj, type);
    }

    public static <T> T convert(Object obj, Type<? extends T> targetType) {
        if (obj == null) {
            return targetType.defaultValue();
        }
        Class<?> srcPropClass = obj.getClass();
        if (targetType.clazz().isAssignableFrom(srcPropClass)) {
            return (T)obj;
        }
        Type<T> srcPropType = CommonUtil.typeOf(srcPropClass);
        if (targetType.isBoolean() && srcPropType.isNumber()) {
            return (T)Boolean.valueOf(((Number)obj).longValue() > 0L);
        }
        if (targetType.isEntity() && srcPropType.isEntity()) {
            if (srcPropType.isEntity()) {
                return CommonUtil.copy(targetType.clazz(), obj);
            }
            if (srcPropType.isMap()) {
                return Maps.map2Entity(targetType.clazz(), (Map)obj);
            }
        }
        if (targetType.isMap()) {
            if (srcPropType.isEntity() && targetType.getParameterTypes()[0].clazz().isAssignableFrom(String.class) && Object.class.equals(targetType.getParameterTypes()[1].clazz())) {
                try {
                    return (T)Maps.entity2Map((Map)CommonUtil.newInstance(targetType.clazz()), obj);
                }
                catch (Exception exception) {
                }
            } else if (srcPropType.isMap() && Object.class.equals(targetType.getParameterTypes()[0].clazz()) && Object.class.equals(targetType.getParameterTypes()[1].clazz())) {
                Map result = (Map)CommonUtil.newInstance(targetType.clazz());
                result.putAll((Map)obj);
                return (T)result;
            }
        }
        if (targetType.isCollection() && srcPropType.isCollection() && Object.class.equals(targetType.getParameterTypes()[0].clazz())) {
            Collection result = (Collection)CommonUtil.newInstance(targetType.clazz());
            result.addAll((Collection)obj);
            return (T)result;
        }
        if (targetType.isNumber() && srcPropType.isNumber() && CLASS_TYPE_ENUM.containsKey(targetType.clazz())) {
            switch (CLASS_TYPE_ENUM.get(targetType.clazz())) {
                case 3: 
                case 23: {
                    return (T)Byte.valueOf(((Number)obj).byteValue());
                }
                case 4: 
                case 24: {
                    return (T)Short.valueOf(((Number)obj).shortValue());
                }
                case 5: 
                case 25: {
                    return (T)Integer.valueOf(((Number)obj).intValue());
                }
                case 6: 
                case 26: {
                    return (T)Long.valueOf(((Number)obj).longValue());
                }
                case 7: 
                case 27: {
                    return (T)Float.valueOf(((Number)obj).floatValue());
                }
                case 8: 
                case 28: {
                    return (T)Double.valueOf(((Number)obj).doubleValue());
                }
            }
        } else {
            if ((targetType.clazz().equals(Integer.TYPE) || targetType.clazz().equals(Integer.class)) && srcPropType.clazz().equals(Character.class)) {
                return (T)Integer.valueOf(((Character)obj).charValue());
            }
            if ((targetType.clazz().equals(Character.TYPE) || targetType.clazz().equals(Character.class)) && srcPropType.clazz().equals(Integer.class)) {
                return (T)Character.valueOf((char)((Integer)obj).intValue());
            }
        }
        return targetType.valueOf(obj);
    }

    public static boolean parseBoolean(String str) {
        return CommonUtil.isNullOrEmpty(str) ? false : Boolean.valueOf(str);
    }

    public static char parseChar(String str) {
        return CommonUtil.isNullOrEmpty(str) ? (char)'\u0000' : (str.length() == 1 ? str.charAt(0) : (char)Integer.parseInt(str));
    }

    public static byte parseByte(String str) {
        Integer result;
        if (CommonUtil.isNullOrEmpty(str)) {
            return 0;
        }
        if (str.length() < 5 && (result = stringIntCache.get(str)) != null) {
            if (result < -128 || result > 127) {
                throw new NumberFormatException("Value out of range. Value:\"" + str + "\" Radix: 10");
            }
            return result.byteValue();
        }
        return Byte.parseByte(str);
    }

    public static short parseShort(String str) {
        Integer result;
        if (CommonUtil.isNullOrEmpty(str)) {
            return 0;
        }
        if (str.length() < 5 && (result = stringIntCache.get(str)) != null) {
            return result.shortValue();
        }
        return Short.parseShort(str);
    }

    public static int parseInt(String str) {
        Integer result;
        if (CommonUtil.isNullOrEmpty(str)) {
            return 0;
        }
        if (str.length() < 5 && (result = stringIntCache.get(str)) != null) {
            return result;
        }
        return Integer.decode(str);
    }

    public static long parseLong(String str) {
        Integer result;
        if (CommonUtil.isNullOrEmpty(str)) {
            return 0L;
        }
        if (str.length() < 5 && (result = stringIntCache.get(str)) != null) {
            return result.intValue();
        }
        return Long.decode(str);
    }

    public static float parseFloat(String str) {
        if (CommonUtil.isNullOrEmpty(str)) {
            return 0.0f;
        }
        return Float.parseFloat(str);
    }

    public static double parseDouble(String str) {
        return CommonUtil.isNullOrEmpty(str) ? 0.0 : Double.parseDouble(str);
    }

    public static String base64Encode(byte[] binaryData) {
        if (CommonUtil.isNullOrEmpty(binaryData)) {
            return EMPTY_STRING;
        }
        return Base64.encodeBase64String(binaryData);
    }

    public static String base64EncodeChunked(byte[] binaryData) {
        if (CommonUtil.isNullOrEmpty(binaryData)) {
            return EMPTY_STRING;
        }
        return new String(Base64.encodeBase64Chunked(binaryData), Charsets.US_ASCII);
    }

    public static byte[] base64Decode(String base64String) {
        if (CommonUtil.isNullOrEmpty(base64String)) {
            return EMPTY_BYTE_ARRAY;
        }
        return Base64.decodeBase64(base64String);
    }

    public static String base64DecodeToString(String base64String) {
        if (CommonUtil.isNullOrEmpty(base64String)) {
            return EMPTY_STRING;
        }
        return new String(CommonUtil.base64Decode(base64String));
    }

    public static String base64UrlEncode(byte[] binaryData) {
        if (CommonUtil.isNullOrEmpty(binaryData)) {
            return EMPTY_STRING;
        }
        return Base64.encodeBase64URLSafeString(binaryData);
    }

    public static byte[] base64UrlDecode(String base64String) {
        if (CommonUtil.isNullOrEmpty(base64String)) {
            return EMPTY_BYTE_ARRAY;
        }
        return Base64.decodeBase64URL(base64String);
    }

    public static String base64UrlDecodeToString(String base64String) {
        if (CommonUtil.isNullOrEmpty(base64String)) {
            return EMPTY_STRING;
        }
        return new String(Base64.decodeBase64URL(base64String));
    }

    public static String urlEncode(Object parameters) {
        if (parameters == null) {
            return EMPTY_STRING;
        }
        return URLEncodedUtil.encode(parameters);
    }

    public static String urlEncode(Object parameters, Charset charset) {
        if (parameters == null) {
            return EMPTY_STRING;
        }
        return URLEncodedUtil.encode(parameters, charset);
    }

    public static Map<String, String> urlDecode(String urlQuery) {
        if (CommonUtil.isNullOrEmpty(urlQuery)) {
            return new LinkedHashMap<String, String>();
        }
        return URLEncodedUtil.decode(urlQuery);
    }

    public static Map<String, String> urlDecode(String urlQuery, Charset charset) {
        if (CommonUtil.isNullErrorMsg(urlQuery)) {
            return new LinkedHashMap<String, String>();
        }
        return URLEncodedUtil.decode(urlQuery, charset);
    }

    public static <T> T urlDecode(Class<? extends T> targetClass, String urlQuery) {
        if (CommonUtil.isNullErrorMsg(urlQuery)) {
            return CommonUtil.newInstance(targetClass);
        }
        return URLEncodedUtil.decode(targetClass, urlQuery);
    }

    public static <T> T urlDecode(Class<? extends T> targetClass, String urlQuery, Charset charset) {
        if (CommonUtil.isNullOrEmpty(urlQuery)) {
            return CommonUtil.newInstance(targetClass);
        }
        return URLEncodedUtil.decode(targetClass, urlQuery, charset);
    }

    public static String guid() {
        return CommonUtil.uuid().replace("-", "");
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    @Deprecated
    public static boolean isEntity(Class<?> cls) {
        return ClassUtil.isEntity(cls);
    }

    @Deprecated
    public static boolean isDirtyMarker(Class<?> cls) {
        return DirtyMarkerUtil.isDirtyMarker(cls);
    }

    public static <T> T copy(T entity) {
        return (T)CommonUtil.copy(entity.getClass(), entity);
    }

    public static <T> T copy(T entity, Collection<String> selectPropNames) {
        return (T)CommonUtil.copy(entity.getClass(), entity, selectPropNames);
    }

    public static <T> T copy(Class<? extends T> targetClass, Object entity) {
        return CommonUtil.copy(targetClass, entity, null);
    }

    public static <T> T copy(Class<? extends T> targetClass, Object entity, Collection<String> selectPropNames) {
        Class<?> srcCls = entity.getClass();
        Object copy = null;
        if (selectPropNames == null && Utils.kryoParser != null && targetClass.equals(srcCls) && !notKryoCompatible.contains(srcCls)) {
            try {
                copy = Utils.kryoParser.copy(entity);
            }
            catch (Exception e) {
                notKryoCompatible.add(srcCls);
            }
        }
        if (copy != null) {
            return (T)copy;
        }
        copy = CommonUtil.newInstance(targetClass);
        CommonUtil.merge(entity, copy, selectPropNames);
        DirtyMarkerUtil.setDirtyMarker(entity, copy);
        return (T)copy;
    }

    public static <T> T copy(Class<? extends T> targetClass, Object entity, boolean ignoreUnknownProperty, Set<String> ignorePropNames) {
        Class<?> srcCls = entity.getClass();
        Object copy = null;
        if (ignorePropNames == null && Utils.kryoParser != null && targetClass.equals(srcCls) && !notKryoCompatible.contains(srcCls)) {
            try {
                copy = Utils.kryoParser.copy(entity);
            }
            catch (Exception e) {
                notKryoCompatible.add(srcCls);
            }
        }
        if (copy != null) {
            return (T)copy;
        }
        copy = CommonUtil.newInstance(targetClass);
        CommonUtil.merge(entity, copy, ignoreUnknownProperty, ignorePropNames);
        DirtyMarkerUtil.setDirtyMarker(entity, copy);
        return (T)copy;
    }

    public static void merge(Object sourceEntity, Object targetEntity) {
        CommonUtil.merge(sourceEntity, targetEntity, null);
    }

    public static void merge(Object sourceEntity, Object targetEntity, Collection<String> selectPropNames) {
        boolean ignoreUnknownProperty;
        Class<?> srcCls = sourceEntity.getClass();
        boolean bl = ignoreUnknownProperty = selectPropNames == null;
        if (selectPropNames == null) {
            if (sourceEntity instanceof DirtyMarker) {
                Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)sourceEntity);
                if (signedPropNames.size() != 0) {
                    Method srcPropGetMethod = null;
                    try {
                        for (String propName : signedPropNames) {
                            srcPropGetMethod = ClassUtil.getPropGetMethod(srcCls, propName);
                            ClassUtil.setPropValue(targetEntity, propName, srcPropGetMethod.invoke(sourceEntity, new Object[0]), ignoreUnknownProperty);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw N.toRuntimeException(e);
                    }
                }
            } else {
                Map<String, Method> srcGetterMethodList = ClassUtil.checkPropGetMethodList(srcCls);
                try {
                    for (Map.Entry<String, Method> entry : srcGetterMethodList.entrySet()) {
                        ClassUtil.setPropValue(targetEntity, entry.getKey(), entry.getValue().invoke(sourceEntity, new Object[0]), ignoreUnknownProperty);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw N.toRuntimeException(e);
                }
            }
        } else {
            Method srcPropGetMethod = null;
            try {
                for (String propName : selectPropNames) {
                    srcPropGetMethod = ClassUtil.getPropGetMethod(srcCls, propName);
                    ClassUtil.setPropValue(targetEntity, propName, srcPropGetMethod.invoke(sourceEntity, new Object[0]), ignoreUnknownProperty);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw N.toRuntimeException(e);
            }
        }
    }

    public static void merge(Object sourceEntity, Object targetEntity, boolean ignoreUnknownProperty, Set<String> ignorePropNames) {
        Class<?> srcCls = sourceEntity.getClass();
        if (sourceEntity instanceof DirtyMarker) {
            Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)sourceEntity);
            if (signedPropNames.size() != 0) {
                try {
                    Method srcPropGetMethod = null;
                    for (String propName : signedPropNames) {
                        if (ignorePropNames != null && ignorePropNames.contains(propName)) continue;
                        srcPropGetMethod = ClassUtil.getPropGetMethod(srcCls, propName);
                        ClassUtil.setPropValue(targetEntity, propName, srcPropGetMethod.invoke(sourceEntity, new Object[0]), ignoreUnknownProperty);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw N.toRuntimeException(e);
                }
            }
        } else {
            Map<String, Method> srcGetterMethodList = ClassUtil.checkPropGetMethodList(srcCls);
            try {
                for (Map.Entry<String, Method> entry : srcGetterMethodList.entrySet()) {
                    if (ignorePropNames != null && ignorePropNames.contains(entry.getKey())) continue;
                    ClassUtil.setPropValue(targetEntity, entry.getKey(), entry.getValue().invoke(sourceEntity, new Object[0]), ignoreUnknownProperty);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw N.toRuntimeException(e);
            }
        }
    }

    @SafeVarargs
    public static void erase(Object entity, String ... propNames) {
        if (entity == null || CommonUtil.isNullOrEmpty(propNames) || entity instanceof DirtyMarker && DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() == 0) {
            return;
        }
        for (String propName : propNames) {
            ClassUtil.setPropValue(entity, propName, null);
        }
        if (entity instanceof DirtyMarker) {
            DirtyMarker dirtyMarkerEntity = (DirtyMarker)entity;
            for (String propName : propNames) {
                DirtyMarkerUtil.signedPropNames(dirtyMarkerEntity).remove(propName);
                DirtyMarkerUtil.dirtyPropNames(dirtyMarkerEntity).remove(propName);
            }
        }
    }

    public static void erase(Object entity, Collection<String> propNames) {
        if (entity == null || CommonUtil.isNullOrEmpty(propNames) || entity instanceof DirtyMarker && DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() == 0) {
            return;
        }
        for (String propName : propNames) {
            ClassUtil.setPropValue(entity, propName, null);
        }
        if (entity instanceof DirtyMarker) {
            DirtyMarker dirtyMarkerEntity = (DirtyMarker)entity;
            DirtyMarkerUtil.signedPropNames(dirtyMarkerEntity).removeAll(propNames);
            DirtyMarkerUtil.dirtyPropNames(dirtyMarkerEntity).removeAll(propNames);
        }
    }

    public static void eraseAll(Object entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof DirtyMarker) {
            DirtyMarker dirtyMarkerEntity = (DirtyMarker)entity;
            Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames(dirtyMarkerEntity);
            if (signedPropNames.size() == 0) {
                return;
            }
            for (String propName : signedPropNames) {
                ClassUtil.setPropValue(entity, propName, null);
            }
            DirtyMarkerUtil.signedPropNames(dirtyMarkerEntity).clear();
            DirtyMarkerUtil.dirtyPropNames(dirtyMarkerEntity).clear();
        } else {
            Class<?> cls = entity.getClass();
            Map<String, Method> setterMethodList = ClassUtil.getPropSetMethodList(cls);
            if (setterMethodList.size() == 0) {
                throw new IllegalArgumentException("No property getter/setter method found in the specified entity: " + ClassUtil.getCanonicalClassName(cls));
            }
            for (Method propSetMethod : setterMethodList.values()) {
                ClassUtil.setPropValue(entity, propSetMethod, null);
            }
        }
    }

    public static <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static InputStream emptyInputStream() {
        return EMPTY_INPUT_STREAM;
    }

    public static <T> boolean anyNull(T a, T b) {
        return a == null || b == null;
    }

    public static <T> boolean anyNull(T a, T b, T c) {
        return a == null || b == null || c == null;
    }

    @SafeVarargs
    public static <T> boolean anyNull(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return false;
        }
        for (T e : a) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyNull(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return false;
        }
        for (T e : c) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean allNull(T a, T b) {
        return a == null && b == null;
    }

    public static <T> boolean allNull(T a, T b, T c) {
        return a == null && b == null && c == null;
    }

    @SafeVarargs
    public static <T> boolean allNull(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return true;
        }
        for (T e : a) {
            if (e == null) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean allNull(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return true;
        }
        for (T e : c) {
            if (e == null) continue;
            return false;
        }
        return true;
    }

    public static boolean anyNullOrEmpty(CharSequence cs1, CharSequence cs2, CharSequence cs3) {
        return CommonUtil.isNullOrEmpty(cs1) || CommonUtil.isNullOrEmpty(cs2) || CommonUtil.isNullOrEmpty(cs3);
    }

    @SafeVarargs
    public static boolean anyNullOrEmpty(CharSequence ... css) {
        if (CommonUtil.isNullOrEmpty(css)) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!CommonUtil.isNullOrEmpty(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyNullOrEmpty(Collection<? extends CharSequence> css) {
        if (CommonUtil.isNullOrEmpty(css)) {
            return false;
        }
        for (CharSequence charSequence : css) {
            if (!CommonUtil.isNullOrEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean allNullOrEmpty(CharSequence cs1, CharSequence cs2, CharSequence cs3) {
        return CommonUtil.isNullOrEmpty(cs1) && CommonUtil.isNullOrEmpty(cs2) && CommonUtil.isNullOrEmpty(cs3);
    }

    @SafeVarargs
    public static boolean allNullOrEmpty(CharSequence ... css) {
        if (CommonUtil.isNullOrEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (CommonUtil.isNullOrEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean allNullOrEmpty(Collection<? extends CharSequence> css) {
        if (CommonUtil.isNullOrEmpty(css)) {
            return true;
        }
        for (CharSequence charSequence : css) {
            if (CommonUtil.isNullOrEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static <T> u.Nullable<T> first(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return u.Nullable.empty();
        }
        if (c instanceof List && c instanceof RandomAccess) {
            return u.Nullable.of(((List)c).get(0));
        }
        return u.Nullable.of(c.iterator().next());
    }

    public static <T> u.Nullable<T> last(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return u.Nullable.empty();
        }
        if (c instanceof List) {
            List list = (List)c;
            if (c instanceof RandomAccess) {
                return u.Nullable.of(list.get(c.size() - 1));
            }
            return u.Nullable.of(list.listIterator(list.size()).previous());
        }
        if (c instanceof Deque) {
            return u.Nullable.of(((Deque)c).descendingIterator().next());
        }
        return Iterators.last(c.iterator());
    }

    public static <T> u.Optional<T> firstNonNull(T a, T b) {
        return a != null ? u.Optional.of(a) : (b != null ? u.Optional.of(b) : u.Optional.empty());
    }

    public static <T> u.Optional<T> firstNonNull(T a, T b, T c) {
        return a != null ? u.Optional.of(a) : (b != null ? u.Optional.of(b) : (c != null ? u.Optional.of(c) : u.Optional.empty()));
    }

    @SafeVarargs
    public static <T> u.Optional<T> firstNonNull(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return u.Optional.empty();
        }
        for (T e : a) {
            if (e == null) continue;
            return u.Optional.of(e);
        }
        return u.Optional.empty();
    }

    public static <T> u.Optional<T> firstNonNull(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return u.Optional.empty();
        }
        for (T e : c) {
            if (e == null) continue;
            return u.Optional.of(e);
        }
        return u.Optional.empty();
    }

    public static <T> u.Optional<T> lastNonNull(T a, T b) {
        return b != null ? u.Optional.of(b) : (a != null ? u.Optional.of(a) : u.Optional.empty());
    }

    public static <T> u.Optional<T> lastNonNull(T a, T b, T c) {
        return c != null ? u.Optional.of(c) : (b != null ? u.Optional.of(b) : (a != null ? u.Optional.of(a) : u.Optional.empty()));
    }

    @SafeVarargs
    public static <T> u.Optional<T> lastNonNull(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return u.Optional.empty();
        }
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] == null) continue;
            return u.Optional.of(a[i]);
        }
        return u.Optional.empty();
    }

    public static <T> u.Optional<T> lastNonNull(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return u.Optional.empty();
        }
        if (c instanceof List) {
            List list = (List)c;
            if (c instanceof RandomAccess) {
                for (int i = c.size() - 1; i >= 0; --i) {
                    if (list.get(i) == null) continue;
                    return u.Optional.of(list.get(i));
                }
            } else {
                ListIterator iter = list.listIterator(list.size());
                Object pre = null;
                while (iter.hasPrevious()) {
                    Object e = iter.previous();
                    pre = e;
                    if (e == null) continue;
                    return u.Optional.of(pre);
                }
            }
        } else if (c instanceof Deque) {
            Iterator iter = ((Deque)c).descendingIterator();
            Object next = null;
            while (iter.hasNext()) {
                Object e = iter.next();
                next = e;
                if (e == null) continue;
                return u.Optional.of(next);
            }
        } else {
            Iterators.lastNonNull(c.iterator());
        }
        return u.Optional.empty();
    }

    public static <K, V> u.Optional<Map.Entry<K, V>> firstEntry(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return u.Optional.empty();
        }
        return u.Optional.of(map.entrySet().iterator().next());
    }

    public static <K, V> u.Optional<Map.Entry<K, V>> lastEntry(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return u.Optional.empty();
        }
        return Iterators.lastNonNull(map.entrySet().iterator());
    }

    public static <T> T firstOrNullIfEmpty(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return null;
        }
        if (c instanceof List && c instanceof RandomAccess) {
            return (T)((List)c).get(0);
        }
        return c.iterator().next();
    }

    public static <T> T lastOrNullIfEmpty(Collection<T> c) {
        if (CommonUtil.isNullOrEmpty(c)) {
            return null;
        }
        if (c instanceof List) {
            List list = (List)c;
            if (c instanceof RandomAccess) {
                return (T)list.get(c.size() - 1);
            }
            return (T)list.listIterator(list.size()).previous();
        }
        if (c instanceof Deque) {
            return (T)((Deque)c).descendingIterator().next();
        }
        Iterator<T> iter = c.iterator();
        T e = null;
        while (iter.hasNext()) {
            e = iter.next();
        }
        return e;
    }

    public static int len(CharSequence s) {
        return s == null ? 0 : s.length();
    }

    public static int len(boolean[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(char[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(byte[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(short[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(int[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(long[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(float[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(double[] a) {
        return a == null ? 0 : a.length;
    }

    public static int len(Object[] a) {
        return a == null ? 0 : a.length;
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static int size(Map<?, ?> m) {
        return m == null ? 0 : m.size();
    }

    public static <T> List<T> nullToEmpty(List<T> list) {
        return list == null ? CommonUtil.emptyList() : list;
    }

    public static <T> Set<T> nullToEmpty(Set<T> set) {
        return set == null ? CommonUtil.emptySet() : set;
    }

    public static <K, V> Map<K, V> nullToEmpty(Map<K, V> map) {
        return map == null ? CommonUtil.emptyMap() : map;
    }

    public static <T> Iterator<T> nullToEmpty(Iterator<T> iter) {
        return iter == null ? CommonUtil.emptyIterator() : iter;
    }

    public static <T> ListIterator<T> nullToEmpty(ListIterator<T> iter) {
        return iter == null ? CommonUtil.emptyListIterator() : iter;
    }

    public static String nullToEmpty(String str) {
        return str == null ? EMPTY_STRING : str;
    }

    public static boolean[] nullToEmpty(boolean[] a) {
        return a == null ? EMPTY_BOOLEAN_ARRAY : a;
    }

    public static char[] nullToEmpty(char[] a) {
        return a == null ? EMPTY_CHAR_ARRAY : a;
    }

    public static byte[] nullToEmpty(byte[] a) {
        return a == null ? EMPTY_BYTE_ARRAY : a;
    }

    public static short[] nullToEmpty(short[] a) {
        return a == null ? EMPTY_SHORT_ARRAY : a;
    }

    public static int[] nullToEmpty(int[] a) {
        return a == null ? EMPTY_INT_ARRAY : a;
    }

    public static long[] nullToEmpty(long[] a) {
        return a == null ? EMPTY_LONG_ARRAY : a;
    }

    public static float[] nullToEmpty(float[] a) {
        return a == null ? EMPTY_FLOAT_ARRAY : a;
    }

    public static double[] nullToEmpty(double[] a) {
        return a == null ? EMPTY_DOUBLE_ARRAY : a;
    }

    public static String[] nullToEmpty(String[] a) {
        return a == null ? EMPTY_STRING_ARRAY : a;
    }

    @Deprecated
    public static Object[] nullToEmpty(Object[] a) {
        return a == null ? EMPTY_OBJECT_ARRAY : a;
    }

    public static <T> T[] nullToEmpty(Class<T[]> arrayType, T[] a) {
        return a == null ? (Object[])CommonUtil.newArray(arrayType.getComponentType(), 0) : a;
    }

    public static boolean isNullOrEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNullOrEmpty(boolean[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(char[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(byte[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(short[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(int[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(long[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(float[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(double[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(Object[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNullOrEmpty(Multiset<?> s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNullOrEmpty(Multimap<?, ?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNullOrEmpty(DataSet rs) {
        return rs == null || rs.isEmpty();
    }

    public static boolean isNullOrEmptyOrBlank(CharSequence s) {
        if (CommonUtil.isNullOrEmpty(s)) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean notNullOrEmpty(CharSequence s) {
        return s != null && s.length() > 0;
    }

    public static boolean notNullOrEmpty(boolean[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(char[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(byte[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(short[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(int[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(long[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(float[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(double[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(Object[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(Collection<?> c) {
        return c != null && c.size() > 0;
    }

    public static boolean notNullOrEmpty(Map<?, ?> m) {
        return m != null && m.size() > 0;
    }

    public static boolean notNullOrEmpty(Multiset<?> s) {
        return s != null && s.size() > 0;
    }

    public static boolean notNullOrEmpty(Multimap<?, ?, ?> m) {
        return m != null && m.size() > 0;
    }

    public static boolean notNullOrEmpty(DataSet rs) {
        return rs != null && rs.size() > 0;
    }

    public static boolean notNullOrEmptyOrBlank(CharSequence s) {
        return !CommonUtil.isNullOrEmptyOrBlank(s);
    }

    private static boolean isNullErrorMsg(String msg) {
        return msg.length() > 9 && msg.indexOf(32) > 0;
    }

    public static void checkIndex(int index, int length) throws IndexOutOfBoundsException {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index " + index + " is out-of-bounds for length " + length);
        }
    }

    public static void checkFromToIndex(int fromIndex, int toIndex, int length) throws IndexOutOfBoundsException {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw new IndexOutOfBoundsException("Index range [" + fromIndex + ", " + toIndex + "] is out-of-bounds for length " + length);
        }
    }

    public static void checkFromIndexSize(int fromIndex, int size, int length) throws IndexOutOfBoundsException {
        if (fromIndex < 0 || size < 0 || length < 0 || size > length - fromIndex) {
            throw new IndexOutOfBoundsException("Start Index " + fromIndex + " with size " + size + " is out-of-bounds for length " + length);
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, boolean p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, boolean p1, boolean p2) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, boolean p1, boolean p2, boolean p3) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2, (Object)p3));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, char p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)Character.valueOf(p)));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, byte p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, short p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, int p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, int p1, int p2, int p3) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2, (Object)p3));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, long p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, long p1, long p2) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, long p1, long p2, long p3) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2, (Object)p3));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, float p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)Float.valueOf(p)));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, float p1, float p2) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)Float.valueOf(p1), (Object)Float.valueOf(p2)));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, float p1, float p2, float p3) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)Float.valueOf(p1), (Object)Float.valueOf(p2), (Object)Float.valueOf(p3)));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, double p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, double p1, double p2) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, double p1, double p2, double p3) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2, (Object)p3));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, Object p) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, p));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, Object p2) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, Object p2, Object p3) {
        if (!b) {
            throw new IllegalArgumentException(CommonUtil.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static <E extends Exception> void checkArgument(boolean b, Try.Supplier<String, E> errorMessageSupplier) throws E {
        if (!b) {
            throw new IllegalArgumentException(errorMessageSupplier.get());
        }
    }

    public static <T> T checkArgNotNull(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        return obj;
    }

    public static <T> T checkArgNotNull(T obj, String errorMessage) {
        if (obj == null) {
            if (CommonUtil.isNullErrorMsg(errorMessage)) {
                throw new IllegalArgumentException(errorMessage);
            }
            throw new IllegalArgumentException("'" + errorMessage + "' can not be null");
        }
        return obj;
    }

    public static <T extends CharSequence> T checkArgNotNullOrEmpty(T arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static boolean[] checkArgNotNullOrEmpty(boolean[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static char[] checkArgNotNullOrEmpty(char[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static byte[] checkArgNotNullOrEmpty(byte[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static short[] checkArgNotNullOrEmpty(short[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static int[] checkArgNotNullOrEmpty(int[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static long[] checkArgNotNullOrEmpty(long[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static float[] checkArgNotNullOrEmpty(float[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static double[] checkArgNotNullOrEmpty(double[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static <T> T[] checkArgNotNullOrEmpty(T[] arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static <T extends Collection<?>> T checkArgNotNullOrEmpty(T arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static <T extends Map<?, ?>> T checkArgNotNullOrEmpty(T arg, String argNameOrErrorMsg) {
        if (CommonUtil.isNullOrEmpty(arg)) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be null or empty");
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static <T extends CharSequence> T checkArgNotNullOrEmptyOrBlank(T arg, String msg) {
        if (CommonUtil.isNullOrEmptyOrBlank(arg)) {
            if (CommonUtil.isNullErrorMsg(msg)) {
                throw new IllegalArgumentException(msg);
            }
            throw new IllegalArgumentException("'" + msg + "' can not be null or empty or blank");
        }
        return arg;
    }

    public static int checkArgNotNegative(int arg, String argNameOrErrorMsg) {
        if (arg < 0) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be negative: " + arg);
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static long checkArgNotNegative(long arg, String argNameOrErrorMsg) {
        if (arg < 0L) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be negative: " + arg);
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static double checkArgNotNegative(double arg, String argNameOrErrorMsg) {
        if (arg < 0.0) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be negative: " + arg);
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static int checkArgPositive(int arg, String argNameOrErrorMsg) {
        if (arg <= 0) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be zero or negative: " + arg);
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static long checkArgPositive(long arg, String argNameOrErrorMsg) {
        if (arg <= 0L) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be zero or negative: " + arg);
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static double checkArgPositive(double arg, String argNameOrErrorMsg) {
        if (arg <= 0.0) {
            if (argNameOrErrorMsg.indexOf(32) == -1) {
                throw new IllegalArgumentException("'" + argNameOrErrorMsg + "' can not be zero or negative: " + arg);
            }
            throw new IllegalArgumentException(argNameOrErrorMsg);
        }
        return arg;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, int p) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, int p1, int p2, int p3) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2, (Object)p3));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, long p) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, long p1, long p2) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, long p1, long p2, long p3) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2, (Object)p3));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, float p) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)Float.valueOf(p)));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, float p1, float p2) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)Float.valueOf(p1), (Object)Float.valueOf(p2)));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, float p1, float p2, float p3) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)Float.valueOf(p1), (Object)Float.valueOf(p2), (Object)Float.valueOf(p3)));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, double p) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, double p1, double p2) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, double p1, double p2, double p3) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, (Object)p1, (Object)p2, (Object)p3));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, Object p) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, p));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, Object p1, Object p2) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b, String errorMessageTemplate, Object p1, Object p2, Object p3) {
        if (!b) {
            throw new IllegalStateException(CommonUtil.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static <E extends Exception> void checkState(boolean b, Try.Supplier<String, E> errorMessageSupplier) throws E {
        if (!b) {
            throw new IllegalStateException(errorMessageSupplier.get());
        }
    }

    static String format(String template, Object arg) {
        template = String.valueOf(template);
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 16);
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        if (placeholderStart >= 0) {
            sb.append(template, 0, placeholderStart);
            sb.append(CommonUtil.toString(arg));
            sb.append(template, placeholderStart + 2, template.length());
        } else {
            sb.append(" [");
            sb.append(CommonUtil.toString(arg));
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    static String format(String template, Object arg1, Object arg2) {
        template = String.valueOf(template);
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 32);
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        int templateStart = 0;
        int cnt = 0;
        if (placeholderStart >= 0) {
            ++cnt;
            sb.append(template, templateStart, placeholderStart);
            sb.append(CommonUtil.toString(arg1));
            templateStart = placeholderStart + 2;
            placeholderStart = template.indexOf(placeholder, templateStart);
            if (placeholderStart >= 0) {
                ++cnt;
                sb.append(template, templateStart, placeholderStart);
                sb.append(CommonUtil.toString(arg2));
                templateStart = placeholderStart + 2;
            }
            sb.append(template, templateStart, template.length());
        }
        if (cnt == 0) {
            sb.append(" [");
            sb.append(CommonUtil.toString(arg1));
            sb.append(", ");
            sb.append(CommonUtil.toString(arg2));
            sb.append(']');
        } else if (cnt == 1) {
            sb.append(" [");
            sb.append(CommonUtil.toString(arg2));
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    static String format(String template, Object arg1, Object arg2, Object arg3) {
        template = String.valueOf(template);
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 48);
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        int templateStart = 0;
        int cnt = 0;
        if (placeholderStart >= 0) {
            ++cnt;
            sb.append(template, templateStart, placeholderStart);
            sb.append(CommonUtil.toString(arg1));
            templateStart = placeholderStart + 2;
            placeholderStart = template.indexOf(placeholder, templateStart);
            if (placeholderStart >= 0) {
                ++cnt;
                sb.append(template, templateStart, placeholderStart);
                sb.append(CommonUtil.toString(arg2));
                templateStart = placeholderStart + 2;
                placeholderStart = template.indexOf(placeholder, templateStart);
                if (placeholderStart >= 0) {
                    ++cnt;
                    sb.append(template, templateStart, placeholderStart);
                    sb.append(CommonUtil.toString(arg3));
                    templateStart = placeholderStart + 2;
                }
            }
            sb.append(template, templateStart, template.length());
        }
        if (cnt == 0) {
            sb.append(" [");
            sb.append(CommonUtil.toString(arg1));
            sb.append(", ");
            sb.append(CommonUtil.toString(arg2));
            sb.append(", ");
            sb.append(CommonUtil.toString(arg3));
            sb.append(']');
        } else if (cnt == 1) {
            sb.append(" [");
            sb.append(CommonUtil.toString(arg2));
            sb.append(", ");
            sb.append(CommonUtil.toString(arg3));
            sb.append(']');
        } else if (cnt == 2) {
            sb.append(" [");
            sb.append(CommonUtil.toString(arg3));
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    static String format(String template, Object ... args) {
        template = String.valueOf(template);
        if (CommonUtil.isNullOrEmpty(args)) {
            return template;
        }
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        while (placeholderStart >= 0 && i < args.length) {
            sb.append(template, templateStart, placeholderStart);
            sb.append(CommonUtil.toString(args[i++]));
            templateStart = placeholderStart + 2;
            placeholderStart = template.indexOf(placeholder, templateStart);
        }
        sb.append(template, templateStart, template.length());
        if (i < args.length) {
            sb.append(" [");
            sb.append(CommonUtil.toString(args[i++]));
            while (i < args.length) {
                sb.append(", ");
                sb.append(CommonUtil.toString(args[i++]));
            }
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    public static int compare(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    public static int compare(byte a, byte b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public static int compare(short a, short b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public static int compare(int a, int b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public static int compare(long a, long b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public static int compare(float a, float b) {
        return Float.compare(a, b);
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static <T extends Comparable<? super T>> int compare(T a, T b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareTo(b));
    }

    public static <T> int compare(T a, T b, Comparator<? super T> cmp) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : (cmp == null ? NATURAL_ORDER : cmp).compare(a, b));
    }

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>> int compare(T1 a1, T1 b1, T2 a2, T2 b2) {
        int res = CommonUtil.compare(a1, b1);
        return res == 0 ? CommonUtil.compare(a2, b2) : res;
    }

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>, T3 extends Comparable<T3>> int compare(T1 a1, T1 b1, T2 a2, T2 b2, T3 a3, T3 b3) {
        int res = 0;
        res = CommonUtil.compare(a1, b1);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a2, b2);
        if (res != 0) {
            return res;
        }
        return CommonUtil.compare(a3, b3);
    }

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>, T3 extends Comparable<T3>, T4 extends Comparable<T4>> int compare(T1 a1, T1 b1, T2 a2, T2 b2, T3 a3, T3 b3, T4 a4, T4 b4) {
        int res = 0;
        res = CommonUtil.compare(a1, b1);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a2, b2);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a3, b3);
        if (res != 0) {
            return res;
        }
        return CommonUtil.compare(a4, b4);
    }

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>, T3 extends Comparable<T3>, T4 extends Comparable<T4>, T5 extends Comparable<T5>> int compare(T1 a1, T1 b1, T2 a2, T2 b2, T3 a3, T3 b3, T4 a4, T4 b4, T5 a5, T5 b5) {
        int res = 0;
        res = CommonUtil.compare(a1, b1);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a2, b2);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a3, b3);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a4, b4);
        if (res != 0) {
            return res;
        }
        return CommonUtil.compare(a5, b5);
    }

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>, T3 extends Comparable<T3>, T4 extends Comparable<T4>, T5 extends Comparable<T5>, T6 extends Comparable<T6>> int compare(T1 a1, T1 b1, T2 a2, T2 b2, T3 a3, T3 b3, T4 a4, T4 b4, T5 a5, T5 b5, T6 a6, T6 b6) {
        int res = 0;
        res = CommonUtil.compare(a1, b1);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a2, b2);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a3, b3);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a4, b4);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a5, b5);
        if (res != 0) {
            return res;
        }
        return CommonUtil.compare(a6, b6);
    }

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>, T3 extends Comparable<T3>, T4 extends Comparable<T4>, T5 extends Comparable<T5>, T6 extends Comparable<T6>, T7 extends Comparable<T7>> int compare(T1 a1, T1 b1, T2 a2, T2 b2, T3 a3, T3 b3, T4 a4, T4 b4, T5 a5, T5 b5, T6 a6, T6 b6, T7 a7, T7 b7) {
        int res = 0;
        res = CommonUtil.compare(a1, b1);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a2, b2);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a3, b3);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a4, b4);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a5, b5);
        if (res != 0) {
            return res;
        }
        res = CommonUtil.compare(a6, b6);
        if (res != 0) {
            return res;
        }
        return CommonUtil.compare(a7, b7);
    }

    public static int compare(boolean[] a, boolean[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] ? 1 : -1;
        }
        return a.length - b.length;
    }

    public static int compare(boolean[] a, int fromIndexA, boolean[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return a[i] ? 1 : -1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static int compare(char[] a, char[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] > b[i] ? 1 : -1;
        }
        return a.length - b.length;
    }

    public static int compare(char[] a, int fromIndexA, char[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return a[i] > b[i] ? 1 : -1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static int compare(byte[] a, byte[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] > b[i] ? 1 : -1;
        }
        return a.length - b.length;
    }

    public static int compare(byte[] a, int fromIndexA, byte[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return a[i] > b[i] ? 1 : -1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static int compare(short[] a, short[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] > b[i] ? 1 : -1;
        }
        return a.length - b.length;
    }

    public static int compare(short[] a, int fromIndexA, short[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return a[i] > b[i] ? 1 : -1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static int compare(int[] a, int[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] > b[i] ? 1 : -1;
        }
        return a.length - b.length;
    }

    public static int compare(int[] a, int fromIndexA, int[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return a[i] > b[i] ? 1 : -1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static int compare(long[] a, long[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] > b[i] ? 1 : -1;
        }
        return a.length - b.length;
    }

    public static int compare(long[] a, int fromIndexA, long[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return a[i] > b[i] ? 1 : -1;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static int compare(float[] a, float[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int value = 0;
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            value = Float.compare(a[i], b[i]);
            if (value == 0) continue;
            return value;
        }
        return a.length - b.length;
    }

    public static int compare(float[] a, int fromIndexA, float[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int value = 0;
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            value = Float.compare(a[i], b[j]);
            if (value != 0) {
                return value;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static int compare(double[] a, double[] b) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        int value = 0;
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            value = Double.compare(a[i], b[i]);
            if (value == 0) continue;
            return value;
        }
        return a.length - b.length;
    }

    public static int compare(double[] a, int fromIndexA, double[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        int value = 0;
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            value = Double.compare(a[i], b[j]);
            if (value != 0) {
                return value;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compare(T[] a, T[] b) {
        Comparator cmp = NATURAL_ORDER;
        return CommonUtil.compare(a, b, cmp);
    }

    public static <T extends Comparable<? super T>> int compare(T[] a, int fromIndexA, T[] b, int fromIndexB, int len) {
        Comparator cmp = NATURAL_ORDER;
        return CommonUtil.compare(a, fromIndexA, b, fromIndexB, len, cmp);
    }

    public static <T> int compare(T[] a, T[] b, Comparator<? super T> cmp) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int value = 0;
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            value = cmp.compare(a[i], b[i]);
            if (value == 0) continue;
            return value;
        }
        return a.length - b.length;
    }

    public static <T> int compare(T[] a, int fromIndexA, T[] b, int fromIndexB, int len, Comparator<? super T> cmp) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int value = 0;
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            value = cmp.compare(a[i], b[j]);
            if (value != 0) {
                return value;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compare(Collection<T> a, Collection<T> b) {
        Comparator cmp = NATURAL_ORDER;
        return CommonUtil.compare(a, b, cmp);
    }

    public static <T> int compare(Collection<T> a, Collection<T> b, Comparator<? super T> cmp) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return CommonUtil.isNullOrEmpty(b) ? 0 : -1;
        }
        if (CommonUtil.isNullOrEmpty(b)) {
            return 1;
        }
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        Iterator<T> iterA = a.iterator();
        Iterator<T> iterB = b.iterator();
        int value = 0;
        int minLen = N.min(a.size(), b.size());
        for (int i = 0; i < minLen; ++i) {
            value = cmp.compare(iterA.next(), iterB.next());
            if (value == 0) continue;
            return value;
        }
        return a.size() - b.size();
    }

    public static <T> int compare(Collection<T> a, int fromIndexA, Collection<T> b, int fromIndexB, int len, Comparator<? super T> cmp) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.size(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.size(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return 0;
        }
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        Iterator<T> iterA = a.iterator();
        Iterator<T> iterB = b.iterator();
        while (fromIndexA-- > 0) {
            iterA.next();
        }
        while (fromIndexB-- > 0) {
            iterB.next();
        }
        int value = 0;
        for (int i = 0; i < len; ++i) {
            value = cmp.compare(iterA.next(), iterB.next());
            if (value == 0) continue;
            return value;
        }
        return 0;
    }

    public static int compareIgnoreCase(String a, String b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareToIgnoreCase(b));
    }

    public static boolean equals(boolean a, boolean b) {
        return a == b;
    }

    public static boolean equals(char a, char b) {
        return a == b;
    }

    public static boolean equals(byte a, byte b) {
        return a == b;
    }

    public static boolean equals(short a, short b) {
        return a == b;
    }

    public static boolean equals(int a, int b) {
        return a == b;
    }

    public static boolean equals(long a, long b) {
        return a == b;
    }

    public static boolean equals(float a, float b) {
        return Float.compare(a, b) == 0;
    }

    public static boolean equals(double a, double b) {
        return Double.compare(a, b) == 0;
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : (b == null ? false : a.length() == b.length() && a.equals(b));
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        return a == null ? b == null : (b == null ? false : a.equalsIgnoreCase(b));
    }

    public static boolean equals(Object a, Object b) {
        if (a == null ? b == null : b != null && a.equals(b)) {
            return true;
        }
        if (a != null && b != null) {
            Type<Object> typeA = CommonUtil.typeOf(a.getClass());
            if (typeA.isPrimitiveArray()) {
                Type typeB = CommonUtil.typeOf(b.getClass());
                return typeA.clazz().equals(typeB.clazz()) && typeA.equals(a, b);
            }
            if (typeA.isObjectArray()) {
                Type typeB = CommonUtil.typeOf(b.getClass());
                return typeB.isObjectArray() && typeA.equals(a, b);
            }
        }
        return false;
    }

    public static boolean deepEquals(Object a, Object b) {
        if (a == null ? b == null : b != null && a.equals(b)) {
            return true;
        }
        if (a != null && b != null && a.getClass().isArray() && a.getClass().equals(b.getClass())) {
            return CommonUtil.typeOf(a.getClass()).deepEquals(a, b);
        }
        return false;
    }

    public static boolean equals(boolean[] a, boolean[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(boolean[] a, int fromIndexA, boolean[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(char[] a, char[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(char[] a, int fromIndexA, char[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(byte[] a, byte[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(byte[] a, int fromIndexA, byte[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(short[] a, short[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(short[] a, int fromIndexA, short[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(int[] a, int[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(int[] a, int fromIndexA, int[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(long[] a, long[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(long[] a, int fromIndexA, long[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (a[i] != b[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(float[] a, float[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(float[] a, int fromIndexA, float[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (Float.compare(a[i], b[j]) != 0) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(double[] a, double[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(double[] a, int fromIndexA, double[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (Double.compare(a[i], b[j]) != 0) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.equals(a, 0, b, 0, a.length);
    }

    public static boolean equals(Object[] a, int fromIndexA, Object[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (!CommonUtil.equals(a[i], b[j])) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean deepEquals(Object[] a, Object[] b) {
        return a == b || a != null && b != null && a.length == b.length && CommonUtil.deepEquals(a, 0, b, 0, a.length);
    }

    public static boolean deepEquals(Object[] a, int fromIndexA, Object[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (!CommonUtil.deepEquals(a[i], b[j])) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String[] a, String[] b) {
        return a == null || b == null ? a == b : a.length == b.length && CommonUtil.equalsIgnoreCase(a, 0, b, 0, a.length);
    }

    public static boolean equalsIgnoreCase(String[] a, int fromIndexA, String[] b, int fromIndexB, int len) {
        CommonUtil.checkArgNotNegative(len, "len");
        CommonUtil.checkFromIndexSize(fromIndexA, len, CommonUtil.len(a));
        CommonUtil.checkFromIndexSize(fromIndexB, len, CommonUtil.len(b));
        if (fromIndexA == fromIndexB && a == b || len == 0) {
            return true;
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        int i = fromIndexA;
        int j = fromIndexB;
        for (int k = 0; k < len; ++k) {
            if (!(a[i] == null || b[j] == null ? a == b : a[i].equalsIgnoreCase(b[j]))) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int hashCode(char value) {
        return value;
    }

    public static int hashCode(byte value) {
        return value;
    }

    public static int hashCode(short value) {
        return value;
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public static int hashCode(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            return CommonUtil.typeOf(obj.getClass()).hashCode(obj);
        }
        return obj.hashCode();
    }

    public static int deepHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            return CommonUtil.typeOf(obj.getClass()).deepHashCode(obj);
        }
        return obj.hashCode();
    }

    public static int hashCode(boolean[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(boolean[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + (a[i] ? 1231 : 1237);
        }
        return result;
    }

    public static int hashCode(char[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(char[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    public static int hashCode(byte[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(byte[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    public static int hashCode(short[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(short[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    public static int hashCode(int[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(int[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    public static int hashCode(long[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(long[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + (int)(a[i] ^ a[i] >>> 32);
        }
        return result;
    }

    public static int hashCode(float[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(float[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + Float.floatToIntBits(a[i]);
        }
        return result;
    }

    public static int hashCode(double[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(double[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            long bits = Double.doubleToLongBits(a[i]);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public static int hashCode(Object[] a) {
        return a == null ? 0 : CommonUtil.hashCode(a, 0, a.length);
    }

    public static int hashCode(Object[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + (a[i] == null ? 0 : a[i].hashCode());
        }
        return result;
    }

    public static int deepHashCode(Object[] a) {
        return a == null ? 0 : CommonUtil.deepHashCode(a, 0, a.length);
    }

    public static int deepHashCode(Object[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            result = 31 * result + (a[i] == null ? 0 : CommonUtil.deepHashCode(a[i]));
        }
        return result;
    }

    public static String toString(boolean value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(char value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(byte value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(short value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(int value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(long value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(float value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(double value) {
        return CommonUtil.stringOf(value);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        if (obj.getClass().isArray()) {
            return CommonUtil.typeOf(obj.getClass()).toString(obj);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            Joiner joiner = Joiner.with(", ", "[", "]").reuseCachedBuffer(true);
            while (iter.hasNext()) {
                joiner.append(CommonUtil.toString(iter.next()));
            }
            return joiner.toString();
        }
        Integer typeIdx = CLASS_TYPE_ENUM.get(obj.getClass());
        if (typeIdx == null) {
            return obj.toString();
        }
        switch (typeIdx) {
            case 21: {
                return CommonUtil.toString((Boolean)obj);
            }
            case 22: {
                return CommonUtil.toString(((Character)obj).charValue());
            }
            case 23: {
                return CommonUtil.toString((Byte)obj);
            }
            case 24: {
                return CommonUtil.toString((Short)obj);
            }
            case 25: {
                return CommonUtil.toString((Integer)obj);
            }
            case 26: {
                return CommonUtil.toString((Long)obj);
            }
            case 27: {
                return CommonUtil.toString(((Float)obj).floatValue());
            }
            case 28: {
                return CommonUtil.toString((Double)obj);
            }
        }
        return obj.toString();
    }

    public static String deepToString(Object obj) {
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj.getClass().isArray()) {
            return CommonUtil.typeOf(obj.getClass()).deepToString(obj);
        }
        return obj.toString();
    }

    public static String toString(boolean[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(boolean[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, boolean[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, boolean[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(char[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(char[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, char[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, char[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(byte[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, byte[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, byte[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(short[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(short[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, short[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, short[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(int[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(int[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, int[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, int[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(long[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(long[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, long[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, long[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(float[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(float[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, float[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, float[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(double[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(double[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, double[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, double[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append(']');
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.toString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            CommonUtil.toString(sb, a, from, to);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    static void toString(StringBuilder sb, Object[] a) {
        if (a == null) {
            sb.append(NULL_STRING);
        } else if (a.length == 0) {
            sb.append("[]");
        } else {
            CommonUtil.toString(sb, a, 0, a.length);
        }
    }

    static void toString(StringBuilder sb, Object[] a, int from, int to) {
        sb.append('[');
        for (int i = from; i < to; ++i) {
            if (i > from) {
                sb.append(", ");
            }
            sb.append(CommonUtil.toString(a[i]));
        }
        sb.append(']');
    }

    public static String toString(Object a, String defaultIfNull) {
        return a == null ? defaultIfNull : CommonUtil.toString(a);
    }

    public static String deepToString(Object[] a) {
        if (a == null) {
            return NULL_STRING;
        }
        if (a.length == 0) {
            return "[]";
        }
        return CommonUtil.deepToString(a, 0, a.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deepToString(Object[] a, int from, int to) {
        StringBuilder sb = Objectory.createStringBuilder();
        Set<Object[]> set = Objectory.createSet();
        try {
            CommonUtil.deepToString(sb, a, from, to, set);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(set);
            Objectory.recycle(sb);
        }
    }

    static void deepToString(StringBuilder sb, Object[] a, Set<Object[]> processedElements) {
        CommonUtil.deepToString(sb, a, 0, a.length, processedElements);
    }

    static void deepToString(StringBuilder sb, Object[] a, int from, int to, Set<Object[]> processedElements) {
        processedElements.add(a);
        sb.append('[');
        Object element = null;
        Class<?> eClass = null;
        for (int i = from; i < to; ++i) {
            element = a[i];
            if (i > from) {
                sb.append(", ");
            }
            if (element == null) {
                sb.append(NULL_CHAR_ARRAY);
                continue;
            }
            eClass = element.getClass();
            if (eClass.isArray()) {
                Integer enumInt = CLASS_TYPE_ENUM.get(eClass);
                int num = enumInt == null ? 0 : enumInt;
                switch (num) {
                    case 11: {
                        CommonUtil.toString(sb, (boolean[])element);
                        break;
                    }
                    case 12: {
                        CommonUtil.toString(sb, (char[])element);
                        break;
                    }
                    case 13: {
                        CommonUtil.toString(sb, (byte[])element);
                        break;
                    }
                    case 14: {
                        CommonUtil.toString(sb, (short[])element);
                        break;
                    }
                    case 15: {
                        CommonUtil.toString(sb, (int[])element);
                        break;
                    }
                    case 16: {
                        CommonUtil.toString(sb, (long[])element);
                        break;
                    }
                    case 17: {
                        CommonUtil.toString(sb, (float[])element);
                        break;
                    }
                    case 18: {
                        CommonUtil.toString(sb, (double[])element);
                        break;
                    }
                    case 19: {
                        CommonUtil.toString(sb, (String[])element);
                        break;
                    }
                    default: {
                        if (processedElements.contains(element)) {
                            sb.append("[...]");
                            break;
                        }
                        CommonUtil.deepToString(sb, (Object[])element, processedElements);
                        break;
                    }
                }
                continue;
            }
            sb.append(element.toString());
        }
        sb.append(']');
        processedElements.remove(a);
    }

    public static String deepToString(Object[] a, String defaultIfNull) {
        return a == null ? defaultIfNull : CommonUtil.deepToString(a);
    }

    public static void reverse(boolean[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(boolean[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        boolean tmp = false;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(char[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(char[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        char tmp = '\u0000';
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(byte[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(byte[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        byte tmp = 0;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(short[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(short[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        short tmp = 0;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(int[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(int[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        int tmp = 0;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(long[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(long[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        long tmp = 0L;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(float[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(float[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        float tmp = 0.0f;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(double[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(double[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        double tmp = 0.0;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(Object[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return;
        }
        CommonUtil.reverse(a, 0, a.length);
    }

    public static void reverse(Object[] a, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.len(a));
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        Object tmp = null;
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(List<?> list) {
        if (CommonUtil.isNullOrEmpty(list)) {
            return;
        }
        CommonUtil.reverse(list, 0, list.size());
    }

    public static void reverse(List<?> list, int fromIndex, int toIndex) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, CommonUtil.size(list));
        if (CommonUtil.isNullOrEmpty(list) || list.size() == 1) {
            return;
        }
        List<?> l = list;
        if (toIndex - fromIndex < 18 || list instanceof RandomAccess) {
            int i = fromIndex;
            for (int j = toIndex - 1; i < j; ++i, --j) {
                l.set(i, l.set(j, l.get(i)));
            }
        } else {
            ListIterator<?> fwd = l.listIterator(fromIndex);
            ListIterator<?> rev = l.listIterator(toIndex);
            int mid = (toIndex - fromIndex) / 2;
            for (int i = 0; i < mid; ++i) {
                Object tmp = fwd.next();
                fwd.set(rev.previous());
                rev.set(tmp);
            }
        }
    }

    public static void reverse(Collection<?> c) {
        if (CommonUtil.isNullOrEmpty(c) || c.size() < 2) {
            return;
        }
        if (c instanceof List) {
            CommonUtil.reverse((List)c);
        } else {
            Object[] tmp = c.toArray();
            CommonUtil.reverse(tmp);
            c.clear();
            c.addAll(Arrays.asList(tmp));
        }
    }

    public static void rotate(boolean[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            boolean tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(char[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            char tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(byte[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            byte tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(short[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            short tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(int[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            int tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(long[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            long tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(float[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            float tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(double[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            double tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(Object[] a, int distance) {
        if (a == null || a.length <= 1 || distance % a.length == 0) {
            return;
        }
        int len = a.length;
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        int i = 0;
        int count = 0;
        while (count < len) {
            int next;
            Object tmp = a[i];
            int curr = i;
            int n = next = curr < distance ? curr - distance + len : curr - distance;
            while (next != i) {
                a[curr] = a[next];
                curr = next;
                next = curr < distance ? curr - distance + len : curr - distance;
                ++count;
            }
            a[curr] = tmp;
            ++count;
            ++i;
        }
    }

    public static void rotate(List<?> list, int distance) {
        if (list == null || list.size() <= 1 || distance % list.size() == 0) {
            return;
        }
        Collections.rotate(list, distance);
    }

    public static void rotate(Collection<?> c, int distance) {
        if (CommonUtil.isNullOrEmpty(c) || c.size() < 2) {
            return;
        }
        if (c instanceof List) {
            CommonUtil.rotate((List)c, distance);
        } else {
            Object[] tmp = c.toArray();
            CommonUtil.rotate(tmp, distance);
            c.clear();
            c.addAll(Arrays.asList(tmp));
        }
    }

    public static void shuffle(boolean[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(boolean[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(char[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(char[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(byte[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(byte[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(short[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(short[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(int[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(int[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(long[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(long[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(float[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(float[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(double[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static void shuffle(double[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static <T> void shuffle(T[] a) {
        CommonUtil.shuffle(a, RAND);
    }

    public static <T> void shuffle(T[] a, Random rnd) {
        if (CommonUtil.isNullOrEmpty(a) || a.length == 1) {
            return;
        }
        for (int i = a.length; i > 1; --i) {
            CommonUtil.swap(a, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(List<?> list) {
        CommonUtil.shuffle(list, RAND);
    }

    public static void shuffle(List<?> list, Random rnd) {
        if (CommonUtil.isNullOrEmpty(list) || list.size() == 1) {
            return;
        }
        Collections.shuffle(list, rnd);
    }

    public static void shuffle(Collection<?> c) {
        if (CommonUtil.isNullOrEmpty(c) || c.size() < 2) {
            return;
        }
        if (c instanceof List) {
            CommonUtil.shuffle((List)c);
        } else {
            Object[] tmp = c.toArray();
            CommonUtil.shuffle(tmp);
            c.clear();
            c.addAll(Arrays.asList(tmp));
        }
    }

    public static void shuffle(Collection<?> c, Random rnd) {
        if (CommonUtil.isNullOrEmpty(c) || c.size() < 2) {
            return;
        }
        if (c instanceof List) {
            CommonUtil.shuffle((List)c, rnd);
        } else {
            Object[] tmp = c.toArray();
            CommonUtil.shuffle(tmp, rnd);
            c.clear();
            c.addAll(Arrays.asList(tmp));
        }
    }

    public static void swap(boolean[] a, int i, int j) {
        boolean tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(char[] a, int i, int j) {
        char tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(byte[] a, int i, int j) {
        byte tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(short[] a, int i, int j) {
        short tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(int[] a, int i, int j) {
        int tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(long[] a, int i, int j) {
        long tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(float[] a, int i, int j) {
        float tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(double[] a, int i, int j) {
        double tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(Object[] a, int i, int j) {
        Object tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static void swap(List<?> list, int i, int j) {
        Collections.swap(list, i, j);
    }

    public static <T> void swap(Pair<T, T> pair) {
        pair.set(pair.right, pair.left);
    }

    public static <T, E extends Exception> boolean swapIf(Pair<T, T> pair, Try.Predicate<? super Pair<T, T>, E> predicate) throws E {
        if (predicate.test(pair)) {
            pair.set(pair.right, pair.left);
            return true;
        }
        return false;
    }

    public static <T, M> void swap(Triple<T, M, T> triple) {
        Object left = triple.left;
        triple.setLeft(triple.right);
        triple.setRight(left);
    }

    public static <T, M, E extends Exception> boolean swapIf(Triple<T, M, T> triple, Try.Predicate<? super Triple<T, M, T>, E> predicate) throws E {
        if (predicate.test(triple)) {
            Object left = triple.left;
            triple.setLeft(triple.right);
            triple.setRight(left);
            return true;
        }
        return false;
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        Arrays.fill(a, fromIndex, toIndex, val);
    }

    public static <T> void fill(List<? super T> list, T val) {
        CommonUtil.fill(list, 0, list.size(), val);
    }

    public static <T> void fill(List<? super T> list, int fromIndex, int toIndex, T val) {
        CommonUtil.checkFromToIndex(fromIndex, toIndex, Integer.MAX_VALUE);
        int size = list.size();
        if (size < toIndex) {
            int i;
            if (fromIndex < size) {
                for (i = fromIndex; i < size; ++i) {
                    list.set(i, val);
                }
            } else {
                for (i = size; i < fromIndex; ++i) {
                    list.add(null);
                }
            }
            int len = toIndex - list.size();
            for (i = 0; i < len; ++i) {
                list.add(val);
            }
        } else if (toIndex - fromIndex < 25 || list instanceof RandomAccess) {
            for (int i = fromIndex; i < toIndex; ++i) {
                list.set(i, val);
            }
        } else {
            ListIterator<T> itr = list.listIterator(fromIndex);
            for (int i = fromIndex; i < toIndex; ++i) {
                itr.next();
                itr.set(val);
            }
        }
    }

    public static <T> List<T> repeat(T value, int n) {
        CommonUtil.checkArgNotNegative(n, "n");
        ArrayList res = new ArrayList(n);
        CommonUtil.fill(res, 0, n, value);
        return res;
    }

    public static <T> List<T> repeatEach(Collection<T> c, int n) {
        CommonUtil.checkArgNotNegative(n, "n");
        if (n == 0 || CommonUtil.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(c.size() * n);
        for (T e : c) {
            for (int i = 0; i < n; ++i) {
                result.add(e);
            }
        }
        return result;
    }

    public static <T> List<T> repeatAll(Collection<T> c, int n) {
        CommonUtil.checkArgNotNegative(n, "n");
        if (n == 0 || CommonUtil.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(c.size() * n);
        for (int i = 0; i < n; ++i) {
            result.addAll(c);
        }
        return result;
    }

    public static <T> List<T> repeatEachToSize(Collection<T> c, int size) {
        CommonUtil.checkArgNotNegative(size, "size");
        CommonUtil.checkArgument(size == 0 || CommonUtil.notNullOrEmpty(c), "Collection can not be empty or null when size > 0");
        if (size == 0 || CommonUtil.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        int n = size / c.size();
        int mod = size % c.size();
        ArrayList<T> result = new ArrayList<T>(size);
        for (T e : c) {
            int len;
            int n2 = len = mod-- > 0 ? n + 1 : n;
            for (int i = 0; i < len; ++i) {
                result.add(e);
            }
            if (result.size() != size) continue;
            break;
        }
        return result;
    }

    public static <T> List<T> repeatAllToSize(Collection<T> c, int size) {
        CommonUtil.checkArgNotNegative(size, "size");
        CommonUtil.checkArgument(size == 0 || CommonUtil.notNullOrEmpty(c), "Collection can not be empty or null when size > 0");
        if (size == 0 || CommonUtil.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(size);
        while (result.size() < size) {
            if (c.size() <= size - result.size()) {
                result.addAll(c);
                continue;
            }
            Iterator<T> iter = c.iterator();
            int len = size - result.size();
            for (int i = 0; i < len; ++i) {
                result.add(iter.next());
            }
        }
        return result;
    }

    public static <T> void copy(List<? extends T> src, List<? super T> dest) {
        if (src.size() > dest.size()) {
            throw new IllegalArgumentException("Source does not fit in dest");
        }
        Collections.copy(dest, src);
    }

    public static <T> void copy(List<? extends T> src, int srcPos, List<? super T> dest, int destPos, int length) {
        if (src.size() < srcPos + length) {
            throw new IllegalArgumentException("The size of src list less than " + (srcPos + length));
        }
        if (dest.size() < destPos + length) {
            throw new IllegalArgumentException("The size of dest list less than " + (destPos + length));
        }
        if (src instanceof RandomAccess && dest instanceof RandomAccess) {
            for (int i = 0; i < length; ++i) {
                dest.set(destPos + i, src.get(srcPos + i));
            }
        } else {
            int idx;
            ListIterator<T> srcIterator = src.listIterator();
            ListIterator<T> destIterator = dest.listIterator();
            for (idx = 0; idx < srcPos; ++idx) {
                srcIterator.next();
            }
            for (idx = 0; idx < destPos; ++idx) {
                destIterator.next();
            }
            for (int i = 0; i < length; ++i) {
                destIterator.next();
                destIterator.set(srcIterator.next());
            }
        }
    }

    public static void copy(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(short[] src, int srcPos, short[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(int[] src, int srcPos, int[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(long[] src, int srcPos, long[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(float[] src, int srcPos, float[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(double[] src, int srcPos, double[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        if (src.length < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (dest.length < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        if (length < 9) {
            if (destPos > srcPos) {
                for (int i = length - 1; i >= 0; --i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public static void copy(Object src, int srcPos, Object dest, int destPos, int length) {
        if (Array.getLength(src) < srcPos + length) {
            throw new IllegalArgumentException("The size of src array less than " + (srcPos + length));
        }
        if (Array.getLength(dest) < destPos + length) {
            throw new IllegalArgumentException("The size of dest array less than " + (destPos + length));
        }
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        if (newLength == original.length) {
            return (boolean[])original.clone();
        }
        boolean[] copy = new boolean[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static char[] copyOf(char[] original, int newLength) {
        if (newLength == original.length) {
            return (char[])original.clone();
        }
        char[] copy = new char[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        if (newLength == original.length) {
            return (byte[])original.clone();
        }
        byte[] copy = new byte[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static short[] copyOf(short[] original, int newLength) {
        if (newLength == original.length) {
            return (short[])original.clone();
        }
        short[] copy = new short[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        if (newLength == original.length) {
            return (int[])original.clone();
        }
        int[] copy = new int[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static long[] copyOf(long[] original, int newLength) {
        if (newLength == original.length) {
            return (long[])original.clone();
        }
        long[] copy = new long[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static float[] copyOf(float[] original, int newLength) {
        if (newLength == original.length) {
            return (float[])original.clone();
        }
        float[] copy = new float[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static double[] copyOf(double[] original, int newLength) {
        if (newLength == original.length) {
            return (double[])original.clone();
        }
        double[] copy = new double[newLength];
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        if (newLength == original.length) {
            return (Object[])original.clone();
        }
        return CommonUtil.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy;
        Object[] objectArray = copy = Object[].class.equals(newType) ? new Object[newLength] : (Object[])CommonUtil.newArray(newType.getComponentType(), newLength);
        if (CommonUtil.notNullOrEmpty(original)) {
            CommonUtil.copy(original, 0, copy, 0, Math.min(original.length, newLength));
        }
        return copy;
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (boolean[])original.clone();
        }
        int newLength = to - from;
        boolean[] copy = new boolean[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        boolean[] copy = new boolean[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (char[])original.clone();
        }
        int newLength = to - from;
        char[] copy = new char[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static char[] copyOfRange(char[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_CHAR_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        char[] copy = new char[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (byte[])original.clone();
        }
        int newLength = to - from;
        byte[] copy = new byte[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        byte[] copy = new byte[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static short[] copyOfRange(short[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (short[])original.clone();
        }
        int newLength = to - from;
        short[] copy = new short[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static short[] copyOfRange(short[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_SHORT_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        short[] copy = new short[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (int[])original.clone();
        }
        int newLength = to - from;
        int[] copy = new int[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static int[] copyOfRange(int[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_INT_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        int[] copy = new int[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (long[])original.clone();
        }
        int newLength = to - from;
        long[] copy = new long[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static long[] copyOfRange(long[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_LONG_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        long[] copy = new long[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static float[] copyOfRange(float[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (float[])original.clone();
        }
        int newLength = to - from;
        float[] copy = new float[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static float[] copyOfRange(float[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        float[] copy = new float[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static double[] copyOfRange(double[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (double[])original.clone();
        }
        int newLength = to - from;
        double[] copy = new double[newLength];
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static double[] copyOfRange(double[] original, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        double[] copy = new double[len];
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        if (from == 0 && to == original.length) {
            return (Object[])original.clone();
        }
        return CommonUtil.copyOfRange(original, from, to, original.getClass());
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to, int step) {
        return CommonUtil.copyOfRange(original, from, to, step, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        Object[] copy = Object[].class.equals(newType) ? new Object[newLength] : (Object[])CommonUtil.newArray(newType.getComponentType(), newLength);
        CommonUtil.copy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to, int step, Class<? extends T[]> newType) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, original.length);
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return Object[].class.equals(newType) ? new Object[]{} : (Object[])CommonUtil.newArray(newType.getComponentType(), 0);
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(original, from, to);
        }
        from = from > to ? N.min(original.length - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        Object[] copy = Object[].class.equals(newType) ? new Object[len] : (Object[])CommonUtil.newArray(newType.getComponentType(), len);
        int i = 0;
        int j = from;
        while (i < len) {
            copy[i] = original[j];
            ++i;
            j += step;
        }
        return copy;
    }

    public static <T> List<T> copyOfRange(List<T> c, int from, int to) {
        CommonUtil.checkFromToIndex(from, to, c.size());
        ArrayList<T> result = new ArrayList<T>(to - from);
        result.addAll(c.subList(from, to));
        return result;
    }

    public static <T> List<T> copyOfRange(List<T> c, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, c.size());
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return new ArrayList();
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(c, from, to);
        }
        from = from > to ? N.min(c.size() - 1, from) : from;
        int len = (to - from) / step + ((to - from) % step == 0 ? 0 : 1);
        List<Object> result = null;
        if (c instanceof RandomAccess) {
            result = new ArrayList<T>(len);
            int i = 0;
            int j = from;
            while (i < len) {
                result.add(c.get(j));
                ++i;
                j += step;
            }
        } else {
            Object[] a = c.subList(from, to).toArray();
            result = CommonUtil.createList(CommonUtil.copyOfRange(a, 0, a.length, step));
        }
        return result;
    }

    @SafeVarargs
    static <T> List<T> createList(T ... a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        if (isListElementDataFieldSettable && listElementDataField != null && listSizeField != null) {
            ArrayList list = new ArrayList();
            try {
                listElementDataField.set(list, a);
                listSizeField.set(list, a.length);
                return list;
            }
            catch (Throwable e) {
                isListElementDataFieldSettable = false;
            }
        }
        return CommonUtil.asList(a);
    }

    public static String copyOfRange(String str, int from, int to) {
        return str.substring(from, to);
    }

    public static String copyOfRange(String str, int from, int to, int step) {
        CommonUtil.checkFromToIndex(from < to ? from : (to == -1 ? 0 : to), from < to ? to : from, str.length());
        if (step == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can not be zero");
        }
        if (from == to || from < to != step > 0) {
            return EMPTY_STRING;
        }
        if (step == 1) {
            return CommonUtil.copyOfRange(str, from, to);
        }
        return StringUtil.newString(CommonUtil.copyOfRange(StringUtil.getCharsForReadOnly(str), from, to, step), true);
    }

    public static boolean[] clone(boolean[] original) {
        if (original == null) {
            return null;
        }
        return (boolean[])original.clone();
    }

    public static char[] clone(char[] original) {
        if (original == null) {
            return null;
        }
        return (char[])original.clone();
    }

    public static byte[] clone(byte[] original) {
        if (original == null) {
            return null;
        }
        return (byte[])original.clone();
    }

    public static short[] clone(short[] original) {
        if (original == null) {
            return null;
        }
        return (short[])original.clone();
    }

    public static int[] clone(int[] original) {
        if (original == null) {
            return null;
        }
        return (int[])original.clone();
    }

    public static long[] clone(long[] original) {
        if (original == null) {
            return null;
        }
        return (long[])original.clone();
    }

    public static float[] clone(float[] original) {
        if (original == null) {
            return null;
        }
        return (float[])original.clone();
    }

    public static double[] clone(double[] original) {
        if (original == null) {
            return null;
        }
        return (double[])original.clone();
    }

    public static <T> T[] clone(T[] original) {
        if (original == null) {
            return null;
        }
        return (Object[])original.clone();
    }

    public static boolean[][] clone(boolean[][] original) {
        if (original == null) {
            return null;
        }
        boolean[][] cp = (boolean[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static char[][] clone(char[][] original) {
        if (original == null) {
            return null;
        }
        char[][] cp = (char[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static byte[][] clone(byte[][] original) {
        if (original == null) {
            return null;
        }
        byte[][] cp = (byte[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static short[][] clone(short[][] original) {
        if (original == null) {
            return null;
        }
        short[][] cp = (short[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static int[][] clone(int[][] original) {
        if (original == null) {
            return null;
        }
        int[][] cp = (int[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static long[][] clone(long[][] original) {
        if (original == null) {
            return null;
        }
        long[][] cp = (long[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static float[][] clone(float[][] original) {
        if (original == null) {
            return null;
        }
        float[][] cp = (float[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static double[][] clone(double[][] original) {
        if (original == null) {
            return null;
        }
        double[][] cp = (double[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static <T> T[][] clone(T[][] original) {
        if (original == null) {
            return null;
        }
        Object[][] cp = (Object[][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static boolean[][][] clone(boolean[][][] original) {
        if (original == null) {
            return null;
        }
        boolean[][][] cp = (boolean[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static char[][][] clone(char[][][] original) {
        if (original == null) {
            return null;
        }
        char[][][] cp = (char[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static byte[][][] clone(byte[][][] original) {
        if (original == null) {
            return null;
        }
        byte[][][] cp = (byte[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static short[][][] clone(short[][][] original) {
        if (original == null) {
            return null;
        }
        short[][][] cp = (short[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static int[][][] clone(int[][][] original) {
        if (original == null) {
            return null;
        }
        int[][][] cp = (int[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static long[][][] clone(long[][][] original) {
        if (original == null) {
            return null;
        }
        long[][][] cp = (long[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static float[][][] clone(float[][][] original) {
        if (original == null) {
            return null;
        }
        float[][][] cp = (float[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static double[][][] clone(double[][][] original) {
        if (original == null) {
            return null;
        }
        double[][][] cp = (double[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static <T> T[][][] clone(T[][][] original) {
        if (original == null) {
            return null;
        }
        Object[][][] cp = (Object[][][])original.clone();
        int len = cp.length;
        for (int i = 0; i < len; ++i) {
            cp[i] = CommonUtil.clone(original[i]);
        }
        return cp;
    }

    public static <T> T[] copy(Class<T[]> newType, Object[] a) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return (Object[])CommonUtil.newArray(newType.getComponentType(), 0);
        }
        return CommonUtil.copyOf(a, a.length, newType);
    }

    public static <T> T[][] copy(Class<T[][]> newType, Object[][] a) {
        Class<T[]> componentType = newType.getComponentType();
        if (CommonUtil.isNullOrEmpty((Object[])a)) {
            return (Object[][])CommonUtil.newArray(componentType, 0);
        }
        int len = CommonUtil.len((Object[])a);
        Object[][] result = (Object[][])CommonUtil.newArray(componentType, len);
        for (int i = 0; i < len; ++i) {
            result[i] = CommonUtil.copy(componentType, a[i]);
        }
        return result;
    }

    public static <T> T[][][] copy(Class<T[][][]> newType, Object[][][] a) {
        Class<T[][]> componentType = newType.getComponentType();
        if (CommonUtil.isNullOrEmpty((Object[])a)) {
            return (Object[][][])CommonUtil.newArray(componentType, 0);
        }
        int len = CommonUtil.len((Object[])a);
        Object[][][] result = (Object[][][])CommonUtil.newArray(componentType, len);
        for (int i = 0; i < len; ++i) {
            result[i] = CommonUtil.copy(componentType, a[i]);
        }
        return result;
    }

    public static void sort(boolean[] a) {
        Array.sort(a);
    }

    public static void sort(char[] a) {
        Array.sort(a);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static void sort(byte[] a) {
        Array.sort(a);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static void sort(short[] a) {
        Array.sort(a);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static void sort(int[] a) {
        Array.sort(a);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static void sort(long[] a) {
        Array.sort(a);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static void sort(float[] a) {
        Array.sort(a);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static void sort(double[] a) {
        Array.sort(a);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static void sort(Object[] a) {
        Array.sort(a);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
    }

    public static <T> void sort(T[] a, Comparator<? super T> cmp) {
        Array.sort(a, cmp);
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) {
        Array.sort(a, fromIndex, toIndex, cmp);
    }

    public static <T extends Comparable<? super T>> void sort(List<? extends T> c) {
        Array.sort(c);
    }

    public static <T extends Comparable<? super T>> void sort(List<? extends T> c, int fromIndex, int toIndex) {
        Array.sort(c, fromIndex, toIndex);
    }

    public static <T> void sort(List<? extends T> c, Comparator<? super T> cmp) {
        Array.sort(c, cmp);
    }

    public static <T> void sort(List<? extends T> c, int fromIndex, int toIndex, Comparator<? super T> cmp) {
        Array.sort(c, fromIndex, toIndex, cmp);
    }

    public static <T, U extends Comparable> void sortBy(T[] a, Function<? super T, ? extends U> keyMapper) {
        CommonUtil.sort(a, Comparators.comparingBy(keyMapper));
    }

    public static <T, U extends Comparable> void sortBy(List<? extends T> c, Function<? super T, ? extends U> keyMapper) {
        CommonUtil.sort(c, Comparators.comparingBy(keyMapper));
    }

    public static <T> void sortByInt(T[] a, ToIntFunction<? super T> keyMapper) {
        CommonUtil.sort(a, Comparators.comparingInt(keyMapper));
    }

    public static <T> void sortByInt(List<? extends T> c, ToIntFunction<? super T> keyMapper) {
        CommonUtil.sort(c, Comparators.comparingInt(keyMapper));
    }

    public static <T> void sortByLong(T[] a, ToLongFunction<? super T> keyMapper) {
        CommonUtil.sort(a, Comparators.comparingLong(keyMapper));
    }

    public static <T> void sortByLong(List<? extends T> c, ToLongFunction<? super T> keyMapper) {
        CommonUtil.sort(c, Comparators.comparingLong(keyMapper));
    }

    public static <T> void sortByDouble(T[] a, ToDoubleFunction<? super T> keyMapper) {
        CommonUtil.sort(a, Comparators.comparingDouble(keyMapper));
    }

    public static <T> void sortByDouble(List<? extends T> c, ToDoubleFunction<? super T> keyMapper) {
        CommonUtil.sort(c, Comparators.comparingDouble(keyMapper));
    }

    public static void reverseSort(boolean[] a) {
        Array.reverseSort(a);
    }

    public static void reverseSort(char[] a) {
        Array.sort(a);
        CommonUtil.reverse(a);
    }

    public static void reverseSort(char[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
        CommonUtil.reverse(a, fromIndex, toIndex);
    }

    public static void reverseSort(byte[] a) {
        Array.sort(a);
        CommonUtil.reverse(a);
    }

    public static void reverseSort(byte[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
        CommonUtil.reverse(a, fromIndex, toIndex);
    }

    public static void reverseSort(short[] a) {
        Array.sort(a);
        CommonUtil.reverse(a);
    }

    public static void reverseSort(short[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
        CommonUtil.reverse(a, fromIndex, toIndex);
    }

    public static void reverseSort(int[] a) {
        Array.sort(a);
        CommonUtil.reverse(a);
    }

    public static void reverseSort(int[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
        CommonUtil.reverse(a, fromIndex, toIndex);
    }

    public static void reverseSort(long[] a) {
        Array.sort(a);
        CommonUtil.reverse(a);
    }

    public static void reverseSort(long[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
        CommonUtil.reverse(a, fromIndex, toIndex);
    }

    public static void reverseSort(float[] a) {
        Array.sort(a);
        CommonUtil.reverse(a);
    }

    public static void reverseSort(float[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
        CommonUtil.reverse(a, fromIndex, toIndex);
    }

    public static void reverseSort(double[] a) {
        Array.sort(a);
        CommonUtil.reverse(a);
    }

    public static void reverseSort(double[] a, int fromIndex, int toIndex) {
        Array.sort(a, fromIndex, toIndex);
        CommonUtil.reverse(a, fromIndex, toIndex);
    }

    public static void reverseSort(Object[] a) {
        CommonUtil.sort(a, Fn.reversedOrder());
    }

    public static void reverseSort(Object[] a, int fromIndex, int toIndex) {
        CommonUtil.sort(a, fromIndex, toIndex, Fn.reversedOrder());
    }

    public static <T extends Comparable<? super T>> void reverseSort(List<? extends T> c) {
        CommonUtil.sort(c, Fn.reversedOrder());
    }

    public static <T extends Comparable<? super T>> void reverseSort(List<? extends T> c, int fromIndex, int toIndex) {
        CommonUtil.sort(c, fromIndex, toIndex, Fn.reversedOrder());
    }

    public static <T, U extends Comparable> void reverseSortBy(T[] a, Function<? super T, ? extends U> keyMapper) {
        CommonUtil.sort(a, Comparators.reversedComparingBy(keyMapper));
    }

    public static <T, U extends Comparable> void reverseSortBy(List<? extends T> c, Function<? super T, ? extends U> keyMapper) {
        CommonUtil.sort(c, Comparators.reversedComparingBy(keyMapper));
    }

    static int binarySearch(boolean[] a, boolean key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(char[] a, char key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(char[] a, int fromIndex, int toIndex, char key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static int binarySearch(byte[] a, byte key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(byte[] a, int fromIndex, int toIndex, byte key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static int binarySearch(short[] a, short key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(short[] a, int fromIndex, int toIndex, short key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static int binarySearch(int[] a, int key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static int binarySearch(long[] a, long key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(long[] a, int fromIndex, int toIndex, long key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static int binarySearch(float[] a, float key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(float[] a, int fromIndex, int toIndex, float key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static int binarySearch(double[] a, double key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(double[] a, int fromIndex, int toIndex, double key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static int binarySearch(Object[] a, Object key) {
        return Array.binarySearch(a, key);
    }

    public static int binarySearch(Object[] a, int fromIndex, int toIndex, Object key) {
        return Array.binarySearch(a, fromIndex, toIndex, key);
    }

    public static <T> int binarySearch(T[] a, T key, Comparator<? super T> cmp) {
        return Array.binarySearch(a, key, cmp);
    }

    public static <T> int binarySearch(T[] a, int fromIndex, int toIndex, T key, Comparator<? super T> cmp) {
        return Array.binarySearch(a, fromIndex, toIndex, key, cmp);
    }

    public static <T extends Comparable<? super T>> int binarySearch(List<? extends T> c, T key) {
        return Array.binarySearch(c, key);
    }

    public static <T extends Comparable<? super T>> int binarySearch(List<? extends T> c, int fromIndex, int toIndex, T key) {
        return Array.binarySearch(c, fromIndex, toIndex, key);
    }

    public static <T> int binarySearch(List<? extends T> c, T key, Comparator<? super T> cmp) {
        return Array.binarySearch(c, key, cmp);
    }

    public static <T> int binarySearch(List<? extends T> c, int fromIndex, int toIndex, T key, Comparator<? super T> cmp) {
        return Array.binarySearch(c, fromIndex, toIndex, key, cmp);
    }

    public static <T, U extends Comparable> int binarySearchBy(T[] a, T key, Function<? super T, ? extends U> keyMapper) {
        return CommonUtil.binarySearch(a, key, Comparators.comparingBy(keyMapper));
    }

    public static <T, U extends Comparable> int binarySearchBy(List<? extends T> c, T key, Function<? super T, ? extends U> keyMapper) {
        return CommonUtil.binarySearch(c, key, Comparators.comparingBy(keyMapper));
    }

    public static int indexOf(boolean[] a, boolean e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(boolean[] a, int fromIndex, boolean e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] a, char e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(char[] a, int fromIndex, char e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] a, byte e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(byte[] a, int fromIndex, byte e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] a, short e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(short[] a, int fromIndex, short e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(int[] a, int fromIndex, int e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] a, long e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(long[] a, int fromIndex, long e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] a, float e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(float[] a, int fromIndex, float e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (Float.compare(a[i], e) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] a, double e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(double[] a, int fromIndex, double e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (Double.compare(a[i], e) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] a, Object e) {
        return CommonUtil.indexOf(a, 0, e);
    }

    public static int indexOf(Object[] a, int fromIndex, Object e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        int len = a.length;
        for (int i = fromIndex; i < len; ++i) {
            if (!CommonUtil.equals(a[i], e)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(List<?> list, Object e) {
        return CommonUtil.indexOf(list, 0, e);
    }

    public static int indexOf(List<?> list, int fromIndex, Object e) {
        if (CommonUtil.isNullOrEmpty(list)) {
            return -1;
        }
        int len = list.size();
        for (int i = fromIndex; i < len; ++i) {
            if (!CommonUtil.equals(list.get(i), e)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfSubList(List<?> sourceList, List<?> targetSubList) {
        if (CommonUtil.isNullOrEmpty(sourceList) || CommonUtil.isNullOrEmpty(targetSubList)) {
            return -1;
        }
        return Collections.indexOfSubList(sourceList, targetSubList);
    }

    public static int lastIndexOf(boolean[] a, boolean e) {
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(boolean[] a, int fromIndex, boolean e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] a, char e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(char[] a, int fromIndex, char e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] a, byte e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(byte[] a, int fromIndex, byte e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] a, short e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(short[] a, int fromIndex, short e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] a, int e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(int[] a, int fromIndex, int e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] a, long e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(long[] a, int fromIndex, long e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] a, float e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(float[] a, int fromIndex, float e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (Float.compare(a[i], e) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] a, double e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(double[] a, int fromIndex, double e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (Double.compare(a[i], e) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] a, Object e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(a, a.length - 1, e);
    }

    public static int lastIndexOf(Object[] a, int fromIndex, Object e) {
        if (CommonUtil.isNullOrEmpty(a)) {
            return -1;
        }
        for (int i = N.min(fromIndex, a.length - 1); i >= 0; --i) {
            if (!CommonUtil.equals(a[i], e)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(List<?> list, Object e) {
        if (CommonUtil.isNullOrEmpty(list)) {
            return -1;
        }
        return CommonUtil.lastIndexOf(list, list.size() - 1, e);
    }

    public static int lastIndexOf(List<?> list, int fromIndex, Object e) {
        if (CommonUtil.isNullOrEmpty(list)) {
            return -1;
        }
        for (int i = N.min(fromIndex, list.size() - 1); i >= 0; --i) {
            if (!CommonUtil.equals(list.get(i), e)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> sourceList, List<?> targetSubList) {
        if (CommonUtil.isNullOrEmpty(sourceList) || CommonUtil.isNullOrEmpty(targetSubList)) {
            return -1;
        }
        return Collections.lastIndexOfSubList(sourceList, targetSubList);
    }

    static <T> T createMask(Class<T> interfaceClass) {
        InvocationHandler h = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new UnsupportedOperationException("It's a mask");
            }
        };
        return CommonUtil.newProxyInstance(interfaceClass, h);
    }

    static {
        CLASS_EMPTY_ARRAY.put(Boolean.TYPE, EMPTY_BOOLEAN_ARRAY);
        CLASS_EMPTY_ARRAY.put(Boolean.class, EMPTY_BOOLEAN_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Character.TYPE, EMPTY_CHAR_ARRAY);
        CLASS_EMPTY_ARRAY.put(Character.class, EMPTY_CHARACTER_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Byte.TYPE, EMPTY_BYTE_ARRAY);
        CLASS_EMPTY_ARRAY.put(Byte.class, EMPTY_BYTE_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Short.TYPE, EMPTY_SHORT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Short.class, EMPTY_SHORT_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Integer.TYPE, EMPTY_INT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Integer.class, EMPTY_INTEGER_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Long.TYPE, EMPTY_LONG_ARRAY);
        CLASS_EMPTY_ARRAY.put(Long.class, EMPTY_LONG_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Float.TYPE, EMPTY_FLOAT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Float.class, EMPTY_FLOAT_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(Double.TYPE, EMPTY_DOUBLE_ARRAY);
        CLASS_EMPTY_ARRAY.put(Double.class, EMPTY_DOUBLE_OBJECT_ARRAY);
        CLASS_EMPTY_ARRAY.put(String.class, EMPTY_STRING_ARRAY);
        CLASS_EMPTY_ARRAY.put(Object.class, EMPTY_OBJECT_ARRAY);
        CLASS_TYPE_ENUM = new HashMap();
        CLASS_TYPE_ENUM.put(Boolean.TYPE, 1);
        CLASS_TYPE_ENUM.put(Character.TYPE, 2);
        CLASS_TYPE_ENUM.put(Byte.TYPE, 3);
        CLASS_TYPE_ENUM.put(Short.TYPE, 4);
        CLASS_TYPE_ENUM.put(Integer.TYPE, 5);
        CLASS_TYPE_ENUM.put(Long.TYPE, 6);
        CLASS_TYPE_ENUM.put(Float.TYPE, 7);
        CLASS_TYPE_ENUM.put(Double.TYPE, 8);
        CLASS_TYPE_ENUM.put(String.class, 9);
        CLASS_TYPE_ENUM.put(boolean[].class, 11);
        CLASS_TYPE_ENUM.put(char[].class, 12);
        CLASS_TYPE_ENUM.put(byte[].class, 13);
        CLASS_TYPE_ENUM.put(short[].class, 14);
        CLASS_TYPE_ENUM.put(int[].class, 15);
        CLASS_TYPE_ENUM.put(long[].class, 16);
        CLASS_TYPE_ENUM.put(float[].class, 17);
        CLASS_TYPE_ENUM.put(double[].class, 18);
        CLASS_TYPE_ENUM.put(String[].class, 19);
        CLASS_TYPE_ENUM.put(Boolean.class, 21);
        CLASS_TYPE_ENUM.put(Character.class, 22);
        CLASS_TYPE_ENUM.put(Byte.class, 23);
        CLASS_TYPE_ENUM.put(Short.class, 24);
        CLASS_TYPE_ENUM.put(Integer.class, 25);
        CLASS_TYPE_ENUM.put(Long.class, 26);
        CLASS_TYPE_ENUM.put(Float.class, 27);
        CLASS_TYPE_ENUM.put(Double.class, 28);
        enumListPool = new ObjectPool(POOL_SIZE);
        enumSetPool = new ObjectPool(POOL_SIZE);
        enumMapPool = new ObjectPool(POOL_SIZE);
        nameTypePool = new ObjectPool(POOL_SIZE);
        clsTypePool = new ObjectPool(POOL_SIZE);
        isListElementDataFieldGettable = true;
        isListElementDataFieldSettable = true;
        Field tmp = null;
        try {
            tmp = String.class.getDeclaredField("offset");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tmp == null) {
            try {
                tmp = String.class.getDeclaredField("count");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (tmp == null) {
            try {
                tmp = String.class.getDeclaredField("value");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        tmp = null;
        try {
            tmp = ArrayList.class.getDeclaredField("elementData");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Field field = listElementDataField = tmp != null && tmp.getType().equals(Object[].class) ? tmp : null;
        if (listElementDataField != null) {
            listElementDataField.setAccessible(true);
        }
        tmp = null;
        try {
            tmp = ArrayList.class.getDeclaredField("size");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Field field2 = listSizeField = tmp != null && tmp.getType().equals(Integer.TYPE) ? tmp : null;
        if (listSizeField != null) {
            listSizeField.setAccessible(true);
        }
        charStringCache = new String[128];
        intStringCache = new String[11002];
        stringIntCache = new HashMap<String, Integer>((int)((double)intStringCache.length * 1.5));
        int i = 0;
        int j = -1001;
        int len = intStringCache.length;
        while (i < len) {
            CommonUtil.intStringCache[i] = Integer.valueOf(j).toString();
            stringIntCache.put(intStringCache[i], j);
            ++i;
            ++j;
        }
        for (i = 0; i < charStringCache.length; ++i) {
            CommonUtil.charStringCache[i] = String.valueOf((char)i);
        }
        notKryoCompatible = CommonUtil.newHashSet();
        EMPTY_INPUT_STREAM = new ByteArrayInputStream(EMPTY_BYTE_ARRAY);
    }

    static class NullMask
    implements Serializable {
        private static final long serialVersionUID = 5887875956120266479L;

        private NullMask() {
        }

        public String toString() {
            return "NULL";
        }

        private Object readResolve() {
            return NULL_MASK;
        }
    }
}

