/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.ToDoubleFunction;
import com.landawn.abacus.util.function.ToIntFunction;
import com.landawn.abacus.util.function.ToLongFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public abstract class Comparators {
    static final Comparator NULL_FIRST_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable a, Comparable b) {
            return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareTo(b));
        }
    };
    static final Comparator NULL_LAST_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable a, Comparable b) {
            return a == null ? (b == null ? 0 : 1) : (b == null ? -1 : a.compareTo(b));
        }
    };
    static final Comparator NATURAL_ORDER = NULL_FIRST_COMPARATOR;
    static final Comparator REVERSED_ORDER = Collections.reverseOrder(NATURAL_ORDER);
    static final Comparator<String> COMPARING_IGNORE_CASE = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return N.compareIgnoreCase(a, b);
        }
    };
    static final Comparator<CharSequence> COMPARING_BY_LENGTH = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence a, CharSequence b) {
            return (a == null ? 0 : a.length()) - (b == null ? 0 : b.length());
        }
    };
    static final Comparator<Collection> COMPARING_BY_SIZE = new Comparator<Collection>(){

        @Override
        public int compare(Collection a, Collection b) {
            return (a == null ? 0 : a.size()) - (b == null ? 0 : b.size());
        }
    };
    static final Comparator<Map> COMPARING_BY_SIZEE = new Comparator<Map>(){

        @Override
        public int compare(Map a, Map b) {
            return (a == null ? 0 : a.size()) - (b == null ? 0 : b.size());
        }
    };

    Comparators() {
    }

    public static <T> Comparator<T> naturalOrder() {
        return NATURAL_ORDER;
    }

    public static <T> Comparator<T> reversedOrder() {
        return REVERSED_ORDER;
    }

    public static <T> Comparator<T> reversedOrder(Comparator<T> cmp) {
        if (cmp == null || cmp == NATURAL_ORDER) {
            return REVERSED_ORDER;
        }
        if (cmp == REVERSED_ORDER) {
            return NATURAL_ORDER;
        }
        return Collections.reverseOrder(cmp);
    }

    public static <T> Comparator<T> nullsFirst() {
        return NULL_FIRST_COMPARATOR;
    }

    public static <T> Comparator<T> nullsFirst(final Comparator<T> cmp) {
        if (cmp == null || cmp == NULL_FIRST_COMPARATOR) {
            return NULL_FIRST_COMPARATOR;
        }
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : cmp.compare(a, b));
            }
        };
    }

    public static <T> Comparator<T> nullsLast() {
        return NULL_LAST_COMPARATOR;
    }

    public static <T> Comparator<T> nullsLast(final Comparator<T> cmp) {
        if (cmp == null || cmp == NULL_LAST_COMPARATOR) {
            return NULL_LAST_COMPARATOR;
        }
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a == null ? (b == null ? 0 : 1) : (b == null ? -1 : cmp.compare(a, b));
            }
        };
    }

    public static <T, U extends Comparable> Comparator<T> comparingBy(final Function<? super T, ? extends U> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return N.compare((Comparable)keyMapper.apply(a), (Comparable)keyMapper.apply(b));
            }
        };
    }

    public static <T, U extends Comparable> Comparator<T> reversedComparingBy(final Function<? super T, ? extends U> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return N.compare((Comparable)keyMapper.apply(b), (Comparable)keyMapper.apply(a));
            }
        };
    }

    public static <T, U> Comparator<T> comparingBy(final Function<? super T, ? extends U> keyMapper, final Comparator<? super U> keyComparator) {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(keyComparator);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return keyComparator.compare(keyMapper.apply(a), keyMapper.apply(b));
            }
        };
    }

    public static <T> Comparator<T> comparingInt(final ToIntFunction<? super T> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Integer.compare(keyMapper.applyAsInt(a), keyMapper.applyAsInt(b));
            }
        };
    }

    public static <T> Comparator<T> comparingLong(final ToLongFunction<? super T> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Long.compare(keyMapper.applyAsLong(a), keyMapper.applyAsLong(b));
            }
        };
    }

    public static <T> Comparator<T> comparingDouble(final ToDoubleFunction<? super T> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Double.compare(keyMapper.applyAsDouble(a), keyMapper.applyAsDouble(b));
            }
        };
    }

    public static Comparator<String> comparingIgnoreCase() {
        return COMPARING_IGNORE_CASE;
    }

    public static <T> Comparator<T> comparingIgnoreCase(final Function<? super T, String> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return N.compareIgnoreCase((String)keyMapper.apply(a), (String)keyMapper.apply(b));
            }
        };
    }

    public static <K extends Comparable, V> Comparator<Map.Entry<K, V>> comparingByKey() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)a.getKey(), (Comparable)b.getKey());
            }
        };
    }

    public static <K extends Comparable, V> Comparator<Map.Entry<K, V>> reversedComparingByKey() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)b.getKey(), (Comparable)a.getKey());
            }
        };
    }

    public static <K, V extends Comparable> Comparator<Map.Entry<K, V>> comparingByValue() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)a.getValue(), (Comparable)b.getValue());
            }
        };
    }

    public static <K, V extends Comparable> Comparator<Map.Entry<K, V>> reversedComparingByValue() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)b.getValue(), (Comparable)a.getValue());
            }
        };
    }

    public static <K, V> Comparator<Map.Entry<K, V>> comparingByKey(final Comparator<? super K> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(a.getKey(), b.getKey());
            }
        };
    }

    public static <K, V> Comparator<Map.Entry<K, V>> comparingByValue(final Comparator<? super V> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(a.getValue(), b.getValue());
            }
        };
    }

    @Deprecated
    public static <K, V> Comparator<Map.Entry<K, V>> reversedComparingByKey(final Comparator<? super K> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(b.getKey(), a.getKey());
            }
        };
    }

    @Deprecated
    public static <K, V> Comparator<Map.Entry<K, V>> reversedComparingByValue(final Comparator<? super V> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(b.getValue(), a.getValue());
            }
        };
    }

    public static <T extends CharSequence> Comparator<T> comparingByLength() {
        return COMPARING_BY_LENGTH;
    }

    public static <T extends Collection> Comparator<T> comparingBySize() {
        return COMPARING_BY_SIZE;
    }

    static <T extends Map> Comparator<T> comparingBySizee() {
        return COMPARING_BY_SIZEE;
    }
}

