/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.CalendarUnit;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ISO8601Util;
import com.landawn.abacus.util.Internals;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class DateUtil {
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final TimeZone LOCAL_TIME_ZONE = TimeZone.getDefault();
    public static final String LOCAL_YEAR_FORMAT = "yyyy";
    public static final String LOCAL_MONTH_DAY_FORMAT = "MM-dd";
    static final String LOCAL_MONTH_DAY_FORMAT_SLASH = "MM/dd";
    public static final String LOCAL_DATE_FORMAT = "yyyy-MM-dd";
    static final String LOCAL_DATE_FORMAT_SLASH = "yyyy/MM/dd";
    public static final String LOCAL_TIME_FORMAT = "HH:mm:ss";
    public static final String LOCAL_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final String LOCAL_DATETIME_FORMAT_SLASH = "yyyy/MM/dd HH:mm:ss";
    public static final String LOCAL_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    static final String LOCAL_TIMESTAMP_FORMAT_SLASH = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String ISO_8601_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final String ISO_8601_DATETIME_FORMAT_SLASH = "yyyy/MM/dd'T'HH:mm:ss'Z'";
    public static final String ISO_8601_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    static final String ISO_8601_TIMESTAMP_FORMAT_SLASH = "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'";
    public static final String RFC1123_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    private static final Map<String, Queue<DateFormat>> dfPool = new ObjectPool<String, Queue<DateFormat>>(64);
    private static final Map<TimeZone, Queue<Calendar>> calendarPool = new ObjectPool<TimeZone, Queue<Calendar>>(64);
    private static final Queue<DateFormat> utcTimestampDFPool = new ArrayBlockingQueue<DateFormat>(Internals.POOL_SIZE);
    private static final Queue<DateFormat> utcDateTimeDFPool = new ArrayBlockingQueue<DateFormat>(Internals.POOL_SIZE);
    private static final Queue<Calendar> utcCalendarPool = new ArrayBlockingQueue<Calendar>(Internals.POOL_SIZE);
    private static final Queue<char[]> utcTimestampFormatCharsPool = new ArrayBlockingQueue<char[]>(Internals.POOL_SIZE);
    private static final DatatypeFactory dataTypeFactory;
    private static final char[][][] cbufOfSTDInt;

    public static Time currentTime() {
        return new Time(System.currentTimeMillis());
    }

    public static Date currentDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static java.util.Date currentJUDate() {
        return new java.util.Date();
    }

    public static Calendar currentCalendar() {
        return Calendar.getInstance();
    }

    public static GregorianCalendar currentGregorianCalendar() {
        return new GregorianCalendar();
    }

    public static XMLGregorianCalendar currentXMLGregorianCalendar() {
        return dataTypeFactory.newXMLGregorianCalendar(DateUtil.currentGregorianCalendar());
    }

    DateUtil() {
    }

    public static java.util.Date createJUDate(Calendar calendar) {
        return calendar == null ? null : DateUtil.createJUDate(calendar.getTimeInMillis());
    }

    public static java.util.Date createJUDate(java.util.Date date) {
        return date == null ? null : DateUtil.createJUDate(date.getTime());
    }

    public static java.util.Date createJUDate(long timeInMillis) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        return timeInMillis == 0L ? null : new java.util.Date(timeInMillis);
    }

    public static Date createDate(Calendar calendar) {
        return calendar == null ? null : DateUtil.createDate(calendar.getTimeInMillis());
    }

    public static Date createDate(java.util.Date date) {
        return date == null ? null : DateUtil.createDate(date.getTime());
    }

    public static Date createDate(long timeInMillis) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        return timeInMillis == 0L ? null : new Date(timeInMillis);
    }

    public static Time createTime(Calendar calendar) {
        return calendar == null ? null : DateUtil.createTime(calendar.getTimeInMillis());
    }

    public static Time createTime(java.util.Date date) {
        return date == null ? null : DateUtil.createTime(date.getTime());
    }

    public static Time createTime(long timeInMillis) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        return timeInMillis == 0L ? null : new Time(timeInMillis);
    }

    public static Timestamp createTimestamp(Calendar calendar) {
        return calendar == null ? null : DateUtil.createTimestamp(calendar.getTimeInMillis());
    }

    public static Timestamp createTimestamp(java.util.Date date) {
        return date == null ? null : DateUtil.createTimestamp(date.getTime());
    }

    public static Timestamp createTimestamp(long timeInMillis) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        return timeInMillis == 0L ? null : new Timestamp(timeInMillis);
    }

    public static Calendar createCalendar(Calendar calendar) {
        return calendar == null ? null : DateUtil.createCalendar(calendar.getTimeInMillis());
    }

    public static Calendar createCalendar(java.util.Date date) {
        return date == null ? null : DateUtil.createCalendar(date.getTime());
    }

    public static Calendar createCalendar(long timeInMillis) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        if (timeInMillis == 0L) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeInMillis);
        return c;
    }

    public static Calendar createCalendar(long timeInMillis, TimeZone tz) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        if (timeInMillis == 0L) {
            return null;
        }
        Calendar c = Calendar.getInstance(tz);
        c.setTimeInMillis(timeInMillis);
        return c;
    }

    public static GregorianCalendar createGregorianCalendar(Calendar calendar) {
        return calendar == null ? null : DateUtil.createGregorianCalendar(calendar.getTimeInMillis());
    }

    public static GregorianCalendar createGregorianCalendar(java.util.Date date) {
        return date == null ? null : DateUtil.createGregorianCalendar(date.getTime());
    }

    public static GregorianCalendar createGregorianCalendar(long timeInMillis) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        if (timeInMillis == 0L) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(timeInMillis);
        return c;
    }

    public static GregorianCalendar createGregorianCalendar(long timeInMillis, TimeZone tz) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        if (timeInMillis == 0L) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTimeInMillis(timeInMillis);
        return c;
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(Calendar calendar) {
        return calendar == null ? null : DateUtil.createXMLGregorianCalendar(calendar.getTimeInMillis());
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(java.util.Date date) {
        return date == null ? null : DateUtil.createXMLGregorianCalendar(date.getTime());
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(long timeInMillis) {
        N.checkArgPositive(timeInMillis, "timeInMillis");
        if (timeInMillis == 0L) {
            return null;
        }
        return dataTypeFactory.newXMLGregorianCalendar(DateUtil.createGregorianCalendar(timeInMillis));
    }

    public static java.util.Date parseJUDate(String date) {
        return DateUtil.parseJUDate(date, null);
    }

    public static java.util.Date parseJUDate(String date, String format) {
        return DateUtil.parseJUDate(date, format, null);
    }

    public static java.util.Date parseJUDate(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date) || date.length() == 4 && "null".equalsIgnoreCase(date)) {
            return null;
        }
        return DateUtil.createJUDate(DateUtil.parse(date, format, timeZone));
    }

    public static Date parseDate(String date) {
        return DateUtil.parseDate(date, null);
    }

    public static Date parseDate(String date, String format) {
        return DateUtil.parseDate(date, format, null);
    }

    public static Date parseDate(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date) || date.length() == 4 && "null".equalsIgnoreCase(date)) {
            return null;
        }
        return DateUtil.createDate(DateUtil.parse(date, format, timeZone));
    }

    public static Time parseTime(String date) {
        return DateUtil.parseTime(date, null);
    }

    public static Time parseTime(String date, String format) {
        return DateUtil.parseTime(date, format, null);
    }

    public static Time parseTime(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date) || date.length() == 4 && "null".equalsIgnoreCase(date)) {
            return null;
        }
        return DateUtil.createTime(DateUtil.parse(date, format, timeZone));
    }

    public static Timestamp parseTimestamp(String date) {
        return DateUtil.parseTimestamp(date, null);
    }

    public static Timestamp parseTimestamp(String date, String format) {
        return DateUtil.parseTimestamp(date, format, null);
    }

    public static Timestamp parseTimestamp(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date) || date.length() == 4 && "null".equalsIgnoreCase(date)) {
            return null;
        }
        return DateUtil.createTimestamp(DateUtil.parse(date, format, timeZone));
    }

    public static Calendar parseCalendar(String calendar) {
        return DateUtil.parseCalendar(calendar, null);
    }

    public static Calendar parseCalendar(String calendar, String format) {
        return DateUtil.parseCalendar(calendar, format, null);
    }

    public static Calendar parseCalendar(String calendar, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(calendar) || calendar.length() == 4 && "null".equalsIgnoreCase(calendar)) {
            return null;
        }
        return DateUtil.createCalendar(DateUtil.parse(calendar, format, timeZone));
    }

    public static GregorianCalendar parseGregorianCalendar(String calendar) {
        return DateUtil.parseGregorianCalendar(calendar, null);
    }

    public static GregorianCalendar parseGregorianCalendar(String calendar, String format) {
        return DateUtil.parseGregorianCalendar(calendar, format, null);
    }

    public static GregorianCalendar parseGregorianCalendar(String calendar, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(calendar) || calendar.length() == 4 && "null".equalsIgnoreCase(calendar)) {
            return null;
        }
        return DateUtil.createGregorianCalendar(DateUtil.parse(calendar, format, timeZone));
    }

    public static XMLGregorianCalendar parseXMLGregorianCalendar(String calendar) {
        return DateUtil.parseXMLGregorianCalendar(calendar, null);
    }

    public static XMLGregorianCalendar parseXMLGregorianCalendar(String calendar, String format) {
        return DateUtil.parseXMLGregorianCalendar(calendar, format, null);
    }

    public static XMLGregorianCalendar parseXMLGregorianCalendar(String calendar, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(calendar) || calendar.length() == 4 && "null".equalsIgnoreCase(calendar)) {
            return null;
        }
        return DateUtil.createXMLGregorianCalendar(DateUtil.parse(calendar, format, timeZone));
    }

    private static long parse(String date, String format, TimeZone timeZone) {
        if (format == null && date.length() > 4 && date.charAt(2) >= '0' && date.charAt(2) <= '9' && date.charAt(4) >= '0' && date.charAt(4) <= '9') {
            try {
                return Long.parseLong(date);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (N.isNullOrEmpty(format = DateUtil.checkDateFormat(date, format))) {
            if (timeZone == null) {
                return ISO8601Util.parse(date).getTime();
            }
            throw new RuntimeException("Unsupported date format: " + format + " with time zone: " + timeZone);
        }
        long timeInMillis = DateUtil.fastDateParse(date, format, timeZone = DateUtil.checkTimeZone(format, timeZone));
        if (timeInMillis > 0L) {
            return timeInMillis;
        }
        DateFormat sdf = DateUtil.getSDF(format, timeZone);
        try {
            long l = sdf.parse(date).getTime();
            return l;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            DateUtil.recycleSDF(format, timeZone, sdf);
        }
    }

    public static String format(java.util.Date date) {
        return DateUtil.format(date, null, null);
    }

    public static String format(java.util.Date date, String format) {
        return DateUtil.format(date, format, null);
    }

    public static String format(java.util.Date date, String format, TimeZone timeZone) {
        return DateUtil.formatDate(null, date, format, timeZone);
    }

    public static void format(Writer writer, java.util.Date date) {
        DateUtil.format(writer, date, null, null);
    }

    public static void format(Writer writer, java.util.Date date, String format) {
        DateUtil.formatDate(writer, date, format, null);
    }

    public static void format(Writer writer, java.util.Date date, String format, TimeZone timeZone) {
        DateUtil.formatDate(writer, date, format, timeZone);
    }

    public static String format(Calendar c) {
        return DateUtil.format(c, null, null);
    }

    public static String format(Calendar c, String format) {
        return DateUtil.format(c, format, null);
    }

    public static String format(Calendar c, String format, TimeZone timeZone) {
        if (format == null && timeZone == null) {
            BufferedWriter cbuff = Objectory.createBufferedWriter();
            DateUtil.fastDateFormat(cbuff, c.getTimeInMillis(), false);
            String str = cbuff.toString();
            Objectory.recycle(cbuff);
            return str;
        }
        return DateUtil.format(DateUtil.createJUDate(c), format, timeZone);
    }

    public static void format(Writer writer, Calendar c) {
        DateUtil.format(writer, c, null, null);
    }

    public static void format(Writer writer, Calendar c, String format) {
        DateUtil.format(writer, c, format, null);
    }

    public static void format(Writer writer, Calendar c, String format, TimeZone timeZone) {
        if (format == null && timeZone == null) {
            DateUtil.fastDateFormat(writer, c.getTimeInMillis(), false);
        } else {
            DateUtil.format(writer, DateUtil.createJUDate(c), format, timeZone);
        }
    }

    public static String format(XMLGregorianCalendar c) {
        return DateUtil.format(c, null, null);
    }

    public static String format(XMLGregorianCalendar c, String format) {
        return DateUtil.format(c, format, null);
    }

    public static String format(XMLGregorianCalendar c, String format, TimeZone timeZone) {
        if (format == null && timeZone == null) {
            BufferedWriter cbuff = Objectory.createBufferedWriter();
            DateUtil.fastDateFormat(cbuff, c.toGregorianCalendar().getTimeInMillis(), false);
            String str = cbuff.toString();
            Objectory.recycle(cbuff);
            return str;
        }
        return DateUtil.format(DateUtil.createJUDate(c.toGregorianCalendar()), format, timeZone);
    }

    public static void format(Writer writer, XMLGregorianCalendar c) {
        DateUtil.format(writer, c, null, null);
    }

    public static void format(Writer writer, XMLGregorianCalendar c, String format) {
        DateUtil.format(writer, c, format, null);
    }

    public static void format(Writer writer, XMLGregorianCalendar c, String format, TimeZone timeZone) {
        if (format == null && timeZone == null) {
            DateUtil.fastDateFormat(writer, c.toGregorianCalendar().getTimeInMillis(), false);
        } else {
            DateUtil.format(writer, DateUtil.createJUDate(c.toGregorianCalendar()), format, timeZone);
        }
    }

    public static <T extends java.util.Date> T setYears(T date, int amount) {
        return DateUtil.set(date, 1, amount);
    }

    public static <T extends java.util.Date> T setMonths(T date, int amount) {
        return DateUtil.set(date, 2, amount);
    }

    public static <T extends java.util.Date> T setDays(T date, int amount) {
        return DateUtil.set(date, 5, amount);
    }

    public static <T extends java.util.Date> T setHours(T date, int amount) {
        return DateUtil.set(date, 11, amount);
    }

    public static <T extends java.util.Date> T setMinutes(T date, int amount) {
        return DateUtil.set(date, 12, amount);
    }

    public static <T extends java.util.Date> T setSeconds(T date, int amount) {
        return DateUtil.set(date, 13, amount);
    }

    public static <T extends java.util.Date> T setMilliseconds(T date, int amount) {
        return DateUtil.set(date, 14, amount);
    }

    private static <T extends java.util.Date> T set(T date, int calendarField, int amount) {
        N.checkArgNotNull(date, "date");
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        c.set(calendarField, amount);
        return DateUtil.createDate(date.getClass(), c.getTimeInMillis());
    }

    @Deprecated
    public static <T extends java.util.Date> T roll(T date, long amount, TimeUnit unit) {
        N.checkArgNotNull(date, "date");
        return DateUtil.createDate(date.getClass(), date.getTime() + unit.toMillis(amount));
    }

    @Deprecated
    public static <T extends java.util.Date> T roll(T date, long amount, CalendarUnit unit) {
        N.checkArgNotNull(date, "date");
        if (amount > Integer.MAX_VALUE || amount < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The amount :" + amount + " is too big for unit: " + (Object)((Object)unit));
        }
        switch (unit) {
            case MONTH: 
            case YEAR: {
                Calendar c = DateUtil.createCalendar(date);
                c.add(unit.intValue(), (int)amount);
                return DateUtil.createDate(date.getClass(), c.getTimeInMillis());
            }
        }
        return DateUtil.createDate(date.getClass(), date.getTime() + unit.toMillis(amount));
    }

    @Deprecated
    public static <T extends Calendar> T roll(T calendar, long amount, TimeUnit unit) {
        N.checkArgNotNull(calendar, "calendar");
        return DateUtil.createCalendar(calendar, calendar.getTimeInMillis() + unit.toMillis(amount));
    }

    @Deprecated
    public static <T extends Calendar> T roll(T calendar, long amount, CalendarUnit unit) {
        N.checkArgNotNull(calendar, "calendar");
        if (amount > Integer.MAX_VALUE || amount < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The amount :" + amount + " is too big for unit: " + (Object)((Object)unit));
        }
        T result = DateUtil.createCalendar(calendar, calendar.getTimeInMillis());
        result.add(unit.intValue(), (int)amount);
        return result;
    }

    public static <T extends java.util.Date> T addYears(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.YEAR);
    }

    public static <T extends java.util.Date> T addMonths(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.MONTH);
    }

    public static <T extends java.util.Date> T addWeeks(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.WEEK);
    }

    public static <T extends java.util.Date> T addDays(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.DAY);
    }

    public static <T extends java.util.Date> T addHours(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.HOUR);
    }

    public static <T extends java.util.Date> T addMinutes(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.MINUTE);
    }

    public static <T extends java.util.Date> T addSeconds(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.SECOND);
    }

    public static <T extends java.util.Date> T addMilliseconds(T date, int amount) {
        return DateUtil.roll(date, (long)amount, CalendarUnit.MILLISECOND);
    }

    public static <T extends Calendar> T addYears(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.YEAR);
    }

    public static <T extends Calendar> T addMonths(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.MONTH);
    }

    public static <T extends Calendar> T addWeeks(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.WEEK);
    }

    public static <T extends Calendar> T addDays(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.DAY);
    }

    public static <T extends Calendar> T addHours(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.HOUR);
    }

    public static <T extends Calendar> T addMinutes(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.MINUTE);
    }

    public static <T extends Calendar> T addSeconds(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.SECOND);
    }

    public static <T extends Calendar> T addMilliseconds(T calendar, int amount) {
        return DateUtil.roll(calendar, (long)amount, CalendarUnit.MILLISECOND);
    }

    public static <T extends java.util.Date> T round(T date, int field) {
        N.checkArgNotNull(date, "date");
        Calendar gval = Calendar.getInstance();
        gval.setTime(date);
        DateUtil.modify(gval, field, ModifyType.ROUND);
        return DateUtil.createDate(date.getClass(), gval.getTimeInMillis());
    }

    public static <T extends Calendar> T round(T calendar, int field) {
        N.checkArgNotNull(calendar, "calendar");
        Calendar rounded = (Calendar)calendar.clone();
        DateUtil.modify(rounded, field, ModifyType.ROUND);
        if (rounded.getClass().equals(calendar.getClass())) {
            return (T)rounded;
        }
        return DateUtil.createCalendar(calendar, rounded.getTimeInMillis());
    }

    public static <T extends java.util.Date> T truncate(T date, int field) {
        N.checkArgNotNull(date, "date");
        Calendar gval = Calendar.getInstance();
        gval.setTime(date);
        DateUtil.modify(gval, field, ModifyType.TRUNCATE);
        return DateUtil.createDate(date.getClass(), gval.getTimeInMillis());
    }

    public static <T extends Calendar> T truncate(T calendar, int field) {
        N.checkArgNotNull(calendar, "calendar");
        Calendar truncated = (Calendar)calendar.clone();
        DateUtil.modify(truncated, field, ModifyType.TRUNCATE);
        if (truncated.getClass().equals(calendar.getClass())) {
            return (T)truncated;
        }
        return DateUtil.createCalendar(calendar, truncated.getTimeInMillis());
    }

    public static <T extends java.util.Date> T ceiling(T date, int field) {
        N.checkArgNotNull(date, "date");
        Calendar gval = Calendar.getInstance();
        gval.setTime(date);
        DateUtil.modify(gval, field, ModifyType.CEILING);
        return DateUtil.createDate(date.getClass(), gval.getTimeInMillis());
    }

    public static <T extends Calendar> T ceiling(T calendar, int field) {
        N.checkArgNotNull(calendar, "calendar");
        Calendar ceiled = (Calendar)calendar.clone();
        DateUtil.modify(ceiled, field, ModifyType.CEILING);
        if (ceiled.getClass().equals(calendar.getClass())) {
            return (T)ceiled;
        }
        return DateUtil.createCalendar(calendar, ceiled.getTimeInMillis());
    }

    private static void modify(Calendar val, int field, ModifyType modType) {
        if (val.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (field == 14) {
            return;
        }
        java.util.Date date = val.getTime();
        long time = date.getTime();
        boolean done = false;
        int millisecs = val.get(14);
        if (ModifyType.TRUNCATE == modType || millisecs < 500) {
            time -= (long)millisecs;
        }
        if (field == 13) {
            done = true;
        }
        int seconds = val.get(13);
        if (!(done || ModifyType.TRUNCATE != modType && seconds >= 30)) {
            time -= (long)seconds * 1000L;
        }
        if (field == 12) {
            done = true;
        }
        int minutes = val.get(12);
        if (!(done || ModifyType.TRUNCATE != modType && minutes >= 30)) {
            time -= (long)minutes * 60000L;
        }
        if (date.getTime() != time) {
            date.setTime(time);
            val.setTime(date);
        }
        boolean roundUp = false;
        int[][] nArray = fields;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] aField;
            for (int element : aField = nArray[i]) {
                if (element != field) continue;
                if (modType == ModifyType.CEILING || modType == ModifyType.ROUND && roundUp) {
                    if (field == 1001) {
                        if (val.get(5) == 1) {
                            val.add(5, 15);
                        } else {
                            val.add(5, -15);
                            val.add(2, 1);
                        }
                    } else if (field == 9) {
                        if (val.get(11) == 0) {
                            val.add(11, 12);
                        } else {
                            val.add(11, -12);
                            val.add(5, 1);
                        }
                    } else {
                        val.add(aField[0], 1);
                    }
                }
                return;
            }
            int offset = 0;
            boolean offsetSet = false;
            switch (field) {
                case 1001: {
                    if (aField[0] != 5) break;
                    offset = val.get(5) - 1;
                    if (offset >= 15) {
                        offset -= 15;
                    }
                    roundUp = offset > 7;
                    offsetSet = true;
                    break;
                }
                case 9: {
                    if (aField[0] != 11) break;
                    offset = val.get(11);
                    if (offset >= 12) {
                        offset -= 12;
                    }
                    roundUp = offset >= 6;
                    offsetSet = true;
                    break;
                }
            }
            if (!offsetSet) {
                int min = val.getActualMinimum(aField[0]);
                int max = val.getActualMaximum(aField[0]);
                offset = val.get(aField[0]) - min;
                boolean bl = roundUp = offset > (max - min) / 2;
            }
            if (offset == 0) continue;
            val.set(aField[0], val.get(aField[0]) - offset);
        }
        throw new IllegalArgumentException("The field " + field + " is not supported");
    }

    public static boolean truncatedEquals(Calendar cal1, Calendar cal2, int field) {
        return DateUtil.truncatedCompareTo(cal1, cal2, field) == 0;
    }

    public static boolean truncatedEquals(java.util.Date date1, java.util.Date date2, int field) {
        return DateUtil.truncatedCompareTo(date1, date2, field) == 0;
    }

    public static int truncatedCompareTo(Calendar cal1, Calendar cal2, int field) {
        return DateUtil.truncate(cal1, field).compareTo(DateUtil.truncate(cal2, field));
    }

    public static int truncatedCompareTo(java.util.Date date1, java.util.Date date2, int field) {
        return DateUtil.truncate(date1, field).compareTo(DateUtil.truncate(date2, field));
    }

    private static DateFormat getSDF(String format, TimeZone timeZone) {
        Queue<DateFormat> queue;
        DateFormat sdf = null;
        if (timeZone == UTC_TIME_ZONE) {
            if (format.length() == 28 && format == ISO_8601_TIMESTAMP_FORMAT) {
                sdf = utcTimestampDFPool.poll();
                if (sdf == null) {
                    sdf = new SimpleDateFormat(format);
                    sdf.setTimeZone(timeZone);
                }
                return sdf;
            }
            if (format.length() == 24 && format == ISO_8601_DATETIME_FORMAT) {
                sdf = utcDateTimeDFPool.poll();
                if (sdf == null) {
                    sdf = new SimpleDateFormat(format);
                    sdf.setTimeZone(timeZone);
                }
                return sdf;
            }
        }
        if ((queue = dfPool.get(format)) == null) {
            queue = new ArrayBlockingQueue<DateFormat>(Internals.POOL_SIZE);
            dfPool.put(format, queue);
        }
        if ((sdf = queue.poll()) == null) {
            sdf = new SimpleDateFormat(format);
        }
        sdf.setTimeZone(timeZone);
        return sdf;
    }

    private static void recycleSDF(String format, TimeZone timeZone, DateFormat sdf) {
        if (timeZone == UTC_TIME_ZONE) {
            if (format.length() == 28 && format == ISO_8601_TIMESTAMP_FORMAT) {
                utcTimestampDFPool.add(sdf);
            } else if (format.length() == 24 && format == ISO_8601_DATETIME_FORMAT) {
                utcDateTimeDFPool.add(sdf);
            } else {
                dfPool.get(format).add(sdf);
            }
        } else {
            dfPool.get(format).add(sdf);
        }
    }

    private static String checkDateFormat(String str, String format) {
        if (N.isNullOrEmpty(format)) {
            int len = str.length();
            switch (len) {
                case 4: {
                    return LOCAL_YEAR_FORMAT;
                }
                case 5: {
                    if (str.charAt(2) == '/') {
                        return LOCAL_MONTH_DAY_FORMAT_SLASH;
                    }
                    return LOCAL_MONTH_DAY_FORMAT;
                }
                case 8: {
                    return LOCAL_TIME_FORMAT;
                }
                case 10: {
                    if (str.charAt(4) == '/') {
                        return LOCAL_DATE_FORMAT_SLASH;
                    }
                    return LOCAL_DATE_FORMAT;
                }
                case 19: {
                    if (str.charAt(4) == '/') {
                        return LOCAL_DATETIME_FORMAT_SLASH;
                    }
                    return LOCAL_DATETIME_FORMAT;
                }
                case 23: {
                    if (str.charAt(4) == '/') {
                        return LOCAL_TIMESTAMP_FORMAT_SLASH;
                    }
                    return LOCAL_TIMESTAMP_FORMAT;
                }
                case 24: {
                    if (str.charAt(4) == '/') {
                        return ISO_8601_DATETIME_FORMAT_SLASH;
                    }
                    return ISO_8601_DATETIME_FORMAT;
                }
                case 28: {
                    if (str.charAt(4) == '/') {
                        return ISO_8601_TIMESTAMP_FORMAT_SLASH;
                    }
                    return ISO_8601_TIMESTAMP_FORMAT;
                }
                case 29: {
                    if (str.charAt(3) != ',') break;
                    return RFC1123_DATE_FORMAT;
                }
            }
            return null;
        }
        return format;
    }

    private static TimeZone checkTimeZone(String format, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = format.endsWith("'Z'") ? UTC_TIME_ZONE : LOCAL_TIME_ZONE;
        }
        return timeZone;
    }

    private static long fastDateParse(String str, String format, TimeZone timeZone) {
        if (str.length() != 24 && str.length() != 20 && str.length() != 19 && str.length() != 23) {
            return 0L;
        }
        if (!(format.equals(ISO_8601_TIMESTAMP_FORMAT) || format.equals(ISO_8601_DATETIME_FORMAT) || format.equals(LOCAL_DATETIME_FORMAT) || format.equals(LOCAL_TIMESTAMP_FORMAT))) {
            return 0L;
        }
        int year = DateUtil.parseInt(str, 0, 4);
        int month = DateUtil.parseInt(str, 5, 7) - 1;
        int date = DateUtil.parseInt(str, 8, 10);
        int hourOfDay = DateUtil.parseInt(str, 11, 13);
        int minute = DateUtil.parseInt(str, 14, 16);
        int second = DateUtil.parseInt(str, 17, 19);
        int milliSecond = str.length() == 24 || str.length() == 23 ? DateUtil.parseInt(str, 20, 23) : 0;
        Calendar c = null;
        Queue<Calendar> timeZoneCalendarQueue = null;
        if (timeZone == UTC_TIME_ZONE) {
            c = utcCalendarPool.poll();
        } else {
            timeZoneCalendarQueue = calendarPool.get(timeZone);
            if (timeZoneCalendarQueue == null) {
                timeZoneCalendarQueue = new ArrayBlockingQueue<Calendar>(Internals.POOL_SIZE);
                calendarPool.put(timeZone, timeZoneCalendarQueue);
            } else {
                c = timeZoneCalendarQueue.poll();
            }
        }
        if (c == null) {
            c = Calendar.getInstance(timeZone);
        }
        c.set(year, month, date, hourOfDay, minute, second);
        c.set(14, milliSecond);
        long timeInMillis = c.getTimeInMillis();
        if (timeZone == UTC_TIME_ZONE) {
            utcCalendarPool.add(c);
        } else {
            timeZoneCalendarQueue.add(c);
        }
        return timeInMillis;
    }

    private static int parseInt(String str, int from, int to) {
        int result = 0;
        while (from < to) {
            result = result * 10 + (str.charAt(from++) - 48);
        }
        return result;
    }

    private static <T extends java.util.Date> T createDate(Class<? extends java.util.Date> cls, long millis) {
        java.util.Date result = null;
        result = cls.equals(java.util.Date.class) ? new java.util.Date(millis) : (cls.equals(Date.class) ? new Date(millis) : (cls.equals(Time.class) ? new Time(millis) : (cls.equals(Timestamp.class) ? new Timestamp(millis) : ClassUtil.invokeConstructor(ClassUtil.getDeclaredConstructor(cls, Long.TYPE), millis))));
        return (T)result;
    }

    private static <T extends Calendar> T createCalendar(T c, long millis) {
        Class<?> cls = c.getClass();
        Calendar result = null;
        result = cls.equals(Calendar.class) ? Calendar.getInstance() : (cls.equals(GregorianCalendar.class) ? GregorianCalendar.getInstance() : (Calendar)ClassUtil.invokeConstructor(ClassUtil.getDeclaredConstructor(cls, Long.TYPE), millis));
        result.setTimeInMillis(millis);
        if (!N.equals(c.getTimeZone(), result.getTimeZone())) {
            result.setTimeZone(c.getTimeZone());
        }
        return (T)result;
    }

    private static String formatDate(Writer writer, java.util.Date date, String format, TimeZone timeZone) {
        boolean isTimestamp = date instanceof Timestamp;
        if (format == null && timeZone == null) {
            if (writer == null) {
                BufferedWriter bw = Objectory.createBufferedWriter();
                DateUtil.fastDateFormat(bw, date.getTime(), isTimestamp);
                String str = bw.toString();
                Objectory.recycle(bw);
                return str;
            }
            DateUtil.fastDateFormat(writer, date.getTime(), isTimestamp);
            return null;
        }
        if (format == null) {
            format = isTimestamp ? ISO_8601_TIMESTAMP_FORMAT : ISO_8601_DATETIME_FORMAT;
        }
        timeZone = DateUtil.checkTimeZone(format, timeZone);
        DateFormat sdf = DateUtil.getSDF(format, timeZone);
        String str = sdf.format(date);
        if (writer != null) {
            try {
                writer.write(str);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        DateUtil.recycleSDF(format, timeZone, sdf);
        return str;
    }

    private static void fastDateFormat(Writer writer, long timeInMillis, boolean isTimestamp) {
        Calendar c = utcCalendarPool.poll();
        if (c == null) {
            c = Calendar.getInstance(UTC_TIME_ZONE);
        }
        c.setTimeInMillis(timeInMillis);
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        char[] utcTimestamp = utcTimestampFormatCharsPool.poll();
        if (utcTimestamp == null) {
            utcTimestamp = new char[24];
            utcTimestamp[4] = 45;
            utcTimestamp[7] = 45;
            utcTimestamp[10] = 84;
            utcTimestamp[13] = 58;
            utcTimestamp[16] = 58;
            utcTimestamp[19] = 46;
            utcTimestamp[23] = 90;
        }
        utcTimestamp[0] = cbufOfSTDInt[4][year][0];
        utcTimestamp[1] = cbufOfSTDInt[4][year][1];
        utcTimestamp[2] = cbufOfSTDInt[4][year][2];
        utcTimestamp[3] = cbufOfSTDInt[4][year][3];
        utcTimestamp[5] = cbufOfSTDInt[2][month][0];
        utcTimestamp[6] = cbufOfSTDInt[2][month][1];
        utcTimestamp[8] = cbufOfSTDInt[2][day][0];
        utcTimestamp[9] = cbufOfSTDInt[2][day][1];
        utcTimestamp[11] = cbufOfSTDInt[2][hour][0];
        utcTimestamp[12] = cbufOfSTDInt[2][hour][1];
        utcTimestamp[14] = cbufOfSTDInt[2][minute][0];
        utcTimestamp[15] = cbufOfSTDInt[2][minute][1];
        utcTimestamp[17] = cbufOfSTDInt[2][second][0];
        utcTimestamp[18] = cbufOfSTDInt[2][second][1];
        if (isTimestamp) {
            utcTimestamp[19] = 46;
            int milliSecond = c.get(14);
            utcTimestamp[20] = cbufOfSTDInt[3][milliSecond][0];
            utcTimestamp[21] = cbufOfSTDInt[3][milliSecond][1];
            utcTimestamp[22] = cbufOfSTDInt[3][milliSecond][2];
        } else {
            utcTimestamp[19] = 90;
        }
        try {
            if (isTimestamp) {
                writer.write(utcTimestamp);
            } else {
                writer.write(utcTimestamp, 0, 20);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            utcCalendarPool.add(c);
            utcTimestampFormatCharsPool.add(utcTimestamp);
        }
    }

    static {
        DatatypeFactory temp = null;
        try {
            temp = DatatypeFactory.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataTypeFactory = temp;
        cbufOfSTDInt = new char[5][][];
        int i = 0;
        int j = 1;
        while (i < 5) {
            DateUtil.cbufOfSTDInt[i] = new char[j][];
            for (int k = 0; k < j; ++k) {
                if (i == 1) {
                    DateUtil.cbufOfSTDInt[i][k] = String.valueOf(k).toCharArray();
                    continue;
                }
                if (i == 2) {
                    if (k < 10) {
                        DateUtil.cbufOfSTDInt[i][k] = ("0" + String.valueOf(k)).toCharArray();
                        continue;
                    }
                    DateUtil.cbufOfSTDInt[i][k] = String.valueOf(k).toCharArray();
                    continue;
                }
                if (i == 3) {
                    if (k < 10) {
                        DateUtil.cbufOfSTDInt[i][k] = ("00" + String.valueOf(k)).toCharArray();
                        continue;
                    }
                    if (k < 100) {
                        DateUtil.cbufOfSTDInt[i][k] = ("0" + String.valueOf(k)).toCharArray();
                        continue;
                    }
                    DateUtil.cbufOfSTDInt[i][k] = String.valueOf(k).toCharArray();
                    continue;
                }
                if (i != 4) continue;
                DateUtil.cbufOfSTDInt[i][k] = k < 10 ? ("000" + String.valueOf(k)).toCharArray() : (k < 100 ? ("00" + String.valueOf(k)).toCharArray() : (k < 1000 ? ("0" + String.valueOf(k)).toCharArray() : String.valueOf(k).toCharArray()));
            }
            ++i;
            j *= 10;
        }
    }

    public static class DateTimeUtil
    extends DateUtil {
        private DateTimeUtil() {
        }
    }

    private static enum ModifyType {
        TRUNCATE,
        ROUND,
        CEILING;

    }
}

