/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.Hex;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestUtil {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    private static byte[] digest(MessageDigest digest, InputStream data) throws IOException {
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return digest.digest();
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MessageDigest getMd2Digest() {
        return DigestUtil.getDigest("MD2");
    }

    public static MessageDigest getMd5Digest() {
        return DigestUtil.getDigest("MD5");
    }

    public static MessageDigest getSha1Digest() {
        return DigestUtil.getDigest("SHA-1");
    }

    public static MessageDigest getSha256Digest() {
        return DigestUtil.getDigest("SHA-256");
    }

    public static MessageDigest getSha384Digest() {
        return DigestUtil.getDigest("SHA-384");
    }

    public static MessageDigest getSha512Digest() {
        return DigestUtil.getDigest("SHA-512");
    }

    public static byte[] md2(byte[] data) {
        return DigestUtil.getMd2Digest().digest(data);
    }

    public static byte[] md2(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getMd2Digest(), data);
    }

    public static byte[] md2(String data) {
        return DigestUtil.md2(DigestUtil.getBytes(data));
    }

    public static String md2Hex(byte[] data) {
        return Hex.encodeToString(DigestUtil.md2(data));
    }

    public static String md2Hex(InputStream data) throws IOException {
        return Hex.encodeToString(DigestUtil.md2(data));
    }

    public static String md2Hex(String data) {
        return Hex.encodeToString(DigestUtil.md2(data));
    }

    public static String md2Base64(byte[] data) {
        return N.base64Encode(DigestUtil.md2(data));
    }

    public static String md2Base64(InputStream data) throws IOException {
        return N.base64Encode(DigestUtil.md2(data));
    }

    public static String md2Base64(String data) {
        return N.base64Encode(DigestUtil.md2(data));
    }

    public static byte[] md5(byte[] data) {
        return DigestUtil.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getMd5Digest(), data);
    }

    public static byte[] md5(String data) {
        return DigestUtil.md5(DigestUtil.getBytes(data));
    }

    public static String md5Hex(byte[] data) {
        return Hex.encodeToString(DigestUtil.md5(data));
    }

    public static String md5Hex(InputStream data) throws IOException {
        return Hex.encodeToString(DigestUtil.md5(data));
    }

    public static String md5Hex(String data) {
        return Hex.encodeToString(DigestUtil.md5(data));
    }

    public static String md5Base64(byte[] data) {
        return N.base64Encode(DigestUtil.md5(data));
    }

    public static String md5Base64(InputStream data) throws IOException {
        return N.base64Encode(DigestUtil.md5(data));
    }

    public static String md5Base64(String data) {
        return N.base64Encode(DigestUtil.md5(data));
    }

    public static byte[] sha1(byte[] data) {
        return DigestUtil.getSha1Digest().digest(data);
    }

    public static byte[] sha1(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha1Digest(), data);
    }

    public static byte[] sha1(String data) {
        return DigestUtil.sha1(DigestUtil.getBytes(data));
    }

    public static String sha1Hex(byte[] data) {
        return Hex.encodeToString(DigestUtil.sha1(data));
    }

    public static String sha1Hex(InputStream data) throws IOException {
        return Hex.encodeToString(DigestUtil.sha1(data));
    }

    public static String sha1Hex(String data) {
        return Hex.encodeToString(DigestUtil.sha1(data));
    }

    public static String sha1Base64(byte[] data) {
        return N.base64Encode(DigestUtil.sha1(data));
    }

    public static String sha1Base64(InputStream data) throws IOException {
        return N.base64Encode(DigestUtil.sha1(data));
    }

    public static String sha1Base64(String data) {
        return N.base64Encode(DigestUtil.sha1(data));
    }

    public static byte[] sha256(byte[] data) {
        return DigestUtil.getSha256Digest().digest(data);
    }

    public static byte[] sha256(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha256Digest(), data);
    }

    public static byte[] sha256(String data) {
        return DigestUtil.sha256(DigestUtil.getBytes(data));
    }

    public static String sha256Hex(byte[] data) {
        return Hex.encodeToString(DigestUtil.sha256(data));
    }

    public static String sha256Hex(InputStream data) throws IOException {
        return Hex.encodeToString(DigestUtil.sha256(data));
    }

    public static String sha256Hex(String data) {
        return Hex.encodeToString(DigestUtil.sha256(data));
    }

    public static String sha256Base64(byte[] data) {
        return N.base64Encode(DigestUtil.sha256(data));
    }

    public static String sha256Base64(InputStream data) throws IOException {
        return N.base64Encode(DigestUtil.sha256(data));
    }

    public static String sha256Base64(String data) {
        return N.base64Encode(DigestUtil.sha256(data));
    }

    public static byte[] sha384(byte[] data) {
        return DigestUtil.getSha384Digest().digest(data);
    }

    public static byte[] sha384(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha384Digest(), data);
    }

    public static byte[] sha384(String data) {
        return DigestUtil.sha384(DigestUtil.getBytes(data));
    }

    public static String sha384Hex(byte[] data) {
        return Hex.encodeToString(DigestUtil.sha384(data));
    }

    public static String sha384Hex(InputStream data) throws IOException {
        return Hex.encodeToString(DigestUtil.sha384(data));
    }

    public static String sha384Hex(String data) {
        return Hex.encodeToString(DigestUtil.sha384(data));
    }

    public static String sha384Base64(byte[] data) {
        return N.base64Encode(DigestUtil.sha384(data));
    }

    public static String sha384Base64(InputStream data) throws IOException {
        return N.base64Encode(DigestUtil.sha384(data));
    }

    public static String sha384Base64(String data) {
        return N.base64Encode(DigestUtil.sha384(data));
    }

    public static byte[] sha512(byte[] data) {
        return DigestUtil.getSha512Digest().digest(data);
    }

    public static byte[] sha512(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha512Digest(), data);
    }

    public static byte[] sha512(String data) {
        return DigestUtil.sha512(DigestUtil.getBytes(data));
    }

    public static String sha512Hex(byte[] data) {
        return Hex.encodeToString(DigestUtil.sha512(data));
    }

    public static String sha512Hex(InputStream data) throws IOException {
        return Hex.encodeToString(DigestUtil.sha512(data));
    }

    public static String sha512Hex(String data) {
        return Hex.encodeToString(DigestUtil.sha512(data));
    }

    public static String sha512Base64(byte[] data) {
        return N.base64Encode(DigestUtil.sha512(data));
    }

    public static String sha512Base64(InputStream data) throws IOException {
        return N.base64Encode(DigestUtil.sha512(data));
    }

    public static String sha512Base64(String data) {
        return N.base64Encode(DigestUtil.sha512(data));
    }

    private static byte[] getBytes(String data) {
        return data.getBytes(Charsets.UTF_8);
    }

    static class MessageDigestAlgorithms {
        public static final String MD2 = "MD2";
        public static final String MD5 = "MD5";
        public static final String SHA_1 = "SHA-1";
        public static final String SHA_256 = "SHA-256";
        public static final String SHA_384 = "SHA-384";
        public static final String SHA_512 = "SHA-512";

        private MessageDigestAlgorithms() {
        }
    }
}

