/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Matth;
import com.landawn.abacus.util.Objectory;

public final class Duration
implements Comparable<Duration> {
    public static final Duration ZERO = new Duration(0L);
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private final long milliseconds;

    Duration(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    private static Duration create(long milliseconds) {
        if (milliseconds == 0L) {
            return ZERO;
        }
        return new Duration(milliseconds);
    }

    public static Duration ofDays(long days) {
        return Duration.create(Matth.multiplyExact(days, 86400000L));
    }

    public static Duration ofHours(long hours) {
        return Duration.create(Matth.multiplyExact(hours, 3600000L));
    }

    public static Duration ofMinutes(long minutes) {
        return Duration.create(Matth.multiplyExact(minutes, 60000L));
    }

    public static Duration ofSeconds(long seconds) {
        return Duration.create(Matth.multiplyExact(seconds, 1000L));
    }

    public static Duration ofMillis(long millis) {
        return Duration.create(millis);
    }

    public boolean isZero() {
        return this.milliseconds == 0L;
    }

    public boolean isNegative() {
        return this.milliseconds < 0L;
    }

    public Duration plus(Duration duration) {
        return this.plusMillis(duration.milliseconds);
    }

    public Duration plusDays(long daysToAdd) {
        return this.plusMillis(Matth.multiplyExact(daysToAdd, 86400000L));
    }

    public Duration plusHours(long hoursToAdd) {
        return this.plusMillis(Matth.multiplyExact(hoursToAdd, 3600000L));
    }

    public Duration plusMinutes(long minutesToAdd) {
        return this.plusMillis(Matth.multiplyExact(minutesToAdd, 60000L));
    }

    public Duration plusSeconds(long secondsToAdd) {
        return this.plusMillis(Matth.multiplyExact(secondsToAdd, 1000L));
    }

    public Duration plusMillis(long millisToAdd) {
        if (millisToAdd == 0L) {
            return this;
        }
        return Duration.create(Matth.addExact(this.milliseconds, millisToAdd));
    }

    public Duration minus(Duration duration) {
        return this.minusMillis(duration.milliseconds);
    }

    public Duration minusDays(long daysToSubtract) {
        return this.minusMillis(Matth.multiplyExact(daysToSubtract, 86400000L));
    }

    public Duration minusHours(long hoursToSubtract) {
        return this.minusMillis(Matth.multiplyExact(hoursToSubtract, 3600000L));
    }

    public Duration minusMinutes(long minutesToSubtract) {
        return this.minusMillis(Matth.multiplyExact(minutesToSubtract, 60000L));
    }

    public Duration minusSeconds(long secondsToSubtract) {
        return this.minusMillis(Matth.multiplyExact(secondsToSubtract, 1000L));
    }

    public Duration minusMillis(long millisToSubtract) {
        if (millisToSubtract == 0L) {
            return this;
        }
        return Duration.create(Matth.subtractExact(this.milliseconds, millisToSubtract));
    }

    public Duration multipliedBy(long multiplicand) {
        if (multiplicand == 0L) {
            return ZERO;
        }
        if (multiplicand == 1L) {
            return this;
        }
        return Duration.create(Matth.multiplyExact(this.milliseconds, multiplicand));
    }

    public Duration dividedBy(long divisor) {
        if (divisor == 0L) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (divisor == 1L) {
            return this;
        }
        return Duration.create(this.milliseconds / divisor);
    }

    public Duration negated() {
        return this.multipliedBy(-1L);
    }

    public Duration abs() {
        return this.isNegative() ? this.negated() : this;
    }

    public long toDays() {
        return this.milliseconds / 86400000L;
    }

    public long toHours() {
        return this.milliseconds / 3600000L;
    }

    public long toMinutes() {
        return this.milliseconds / 60000L;
    }

    public long toSeconds() {
        return this.milliseconds / 1000L;
    }

    public long toMillis() {
        return this.milliseconds;
    }

    @Override
    public int compareTo(Duration other) {
        return this.milliseconds > other.milliseconds ? 1 : (this.milliseconds == other.milliseconds ? 0 : -1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Duration && ((Duration)obj).milliseconds == this.milliseconds;
    }

    public int hashCode() {
        return (int)(this.milliseconds ^ this.milliseconds >>> 32);
    }

    public String toString() {
        if (this == ZERO) {
            return "PT0S";
        }
        long hours = this.milliseconds / 3600000L;
        int minutes = (int)(this.milliseconds % 3600000L / 60000L);
        int seconds = (int)(this.milliseconds % 60000L / 1000L);
        int millis = (int)(this.milliseconds % 1000L);
        StringBuilder sb = Objectory.createStringBuilder(24);
        sb.append("PT");
        if (hours != 0L) {
            sb.append(hours).append('H');
        }
        if (minutes != 0) {
            sb.append(minutes).append('M');
        }
        if (seconds == 0 && millis == 0 && sb.length() > 2) {
            return sb.toString();
        }
        if (seconds == 0 && millis < 0) {
            sb.append("-0");
        } else {
            sb.append(seconds);
        }
        millis = Math.abs(millis);
        if (millis > 0) {
            sb.append('.');
            sb.append(millis);
        }
        sb.append('S');
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }
}

