/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.UncheckedException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.exception.UncheckedSQLException;
import com.landawn.abacus.util.function.Function;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public final class ExceptionUtil {
    private static final Map<Class<? extends Throwable>, Function<Throwable, RuntimeException>> toRuntimeExceptionFuncMap = new HashMap<Class<? extends Throwable>, Function<Throwable, RuntimeException>>();

    private ExceptionUtil() {
    }

    public static RuntimeException toRuntimeException(Throwable e) {
        Function<Throwable, RuntimeException> func = toRuntimeExceptionFuncMap.get(e.getClass());
        if (func == null) {
            return e instanceof RuntimeException ? (RuntimeException)e : new UncheckedException(e);
        }
        return func.apply(e);
    }

    public static String getMessage(Throwable e) {
        if (e instanceof SQLException) {
            return e.getClass().getSimpleName() + "|" + ((SQLException)e).getErrorCode() + "|" + (e.getMessage() == null ? e.getCause() : e.getMessage());
        }
        return e.getClass().getSimpleName() + "|" + (e.getMessage() == null ? e.getCause() : e.getMessage());
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static boolean hasCause(Throwable chain, Class<? extends Throwable> type) {
        if (chain instanceof UndeclaredThrowableException) {
            chain = chain.getCause();
        }
        return type.isInstance(chain);
    }

    static {
        toRuntimeExceptionFuncMap.put(RuntimeException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return (RuntimeException)e;
            }
        });
        toRuntimeExceptionFuncMap.put(IOException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return new UncheckedIOException((IOException)e);
            }
        });
        toRuntimeExceptionFuncMap.put(SQLException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return new UncheckedSQLException((SQLException)e);
            }
        });
        toRuntimeExceptionFuncMap.put(ExecutionException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return e.getCause() == null ? new UncheckedException(e) : ExceptionUtil.toRuntimeException(e.getCause());
            }
        });
        toRuntimeExceptionFuncMap.put(InvocationTargetException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return e.getCause() == null ? new UncheckedException(e) : ExceptionUtil.toRuntimeException(e.getCause());
            }
        });
        toRuntimeExceptionFuncMap.put(UndeclaredThrowableException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return e.getCause() == null ? new UncheckedException(e) : ExceptionUtil.toRuntimeException(e.getCause());
            }
        });
    }
}

