/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.annotation.SequentialOnly;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.Duration;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Indexed;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.Keyed;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.MutableBoolean;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.MutableLong;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NoCachingNoUpdating;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.SetMultimap;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Triple;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.Wrapper;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.BiPredicate;
import com.landawn.abacus.util.function.BinaryOperator;
import com.landawn.abacus.util.function.BooleanSupplier;
import com.landawn.abacus.util.function.ByteBiPredicate;
import com.landawn.abacus.util.function.ByteConsumer;
import com.landawn.abacus.util.function.ByteFunction;
import com.landawn.abacus.util.function.BytePredicate;
import com.landawn.abacus.util.function.Callable;
import com.landawn.abacus.util.function.CharBiPredicate;
import com.landawn.abacus.util.function.CharConsumer;
import com.landawn.abacus.util.function.CharFunction;
import com.landawn.abacus.util.function.CharPredicate;
import com.landawn.abacus.util.function.Consumer;
import com.landawn.abacus.util.function.DoubleBiPredicate;
import com.landawn.abacus.util.function.DoubleConsumer;
import com.landawn.abacus.util.function.DoubleFunction;
import com.landawn.abacus.util.function.DoublePredicate;
import com.landawn.abacus.util.function.FloatBiPredicate;
import com.landawn.abacus.util.function.FloatConsumer;
import com.landawn.abacus.util.function.FloatFunction;
import com.landawn.abacus.util.function.FloatPredicate;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.IndexedBiConsumer;
import com.landawn.abacus.util.function.IndexedBiFunction;
import com.landawn.abacus.util.function.IndexedBiPredicate;
import com.landawn.abacus.util.function.IndexedConsumer;
import com.landawn.abacus.util.function.IndexedFunction;
import com.landawn.abacus.util.function.IndexedPredicate;
import com.landawn.abacus.util.function.IntBiPredicate;
import com.landawn.abacus.util.function.IntConsumer;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.IntPredicate;
import com.landawn.abacus.util.function.LongBiPredicate;
import com.landawn.abacus.util.function.LongConsumer;
import com.landawn.abacus.util.function.LongFunction;
import com.landawn.abacus.util.function.LongPredicate;
import com.landawn.abacus.util.function.Predicate;
import com.landawn.abacus.util.function.QuadFunction;
import com.landawn.abacus.util.function.Runnable;
import com.landawn.abacus.util.function.ShortBiPredicate;
import com.landawn.abacus.util.function.ShortConsumer;
import com.landawn.abacus.util.function.ShortFunction;
import com.landawn.abacus.util.function.ShortPredicate;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.function.ToDoubleFunction;
import com.landawn.abacus.util.function.ToIntFunction;
import com.landawn.abacus.util.function.ToLongFunction;
import com.landawn.abacus.util.function.TriConsumer;
import com.landawn.abacus.util.function.TriFunction;
import com.landawn.abacus.util.function.TriPredicate;
import com.landawn.abacus.util.function.UnaryOperator;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public abstract class Fn
extends Comparators {
    private static final Object NONE = new Object();
    private static final Timer timer = new Timer();
    public static final IntFunction<Map<String, Object>> FACTORY_OF_MAP = Factory.access$000();
    public static final IntFunction<LinkedHashMap<String, Object>> FACTORY_OF_LINKED_HASH_MAP = Factory.access$100();
    public static final Supplier<Map<String, Object>> SUPPLIER_OF_MAP = Suppliers.access$200();
    public static final Supplier<LinkedHashMap<String, Object>> SUPPLIER_OF_LINKED_HASH_MAP = Suppliers.access$300();
    private static final Runnable EMPTY_ACTION = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final Consumer DO_NOTHING = new Consumer(){

        @Override
        public void accept(Object value) {
        }
    };
    private static final Consumer<AutoCloseable> CLOSE = new Consumer<AutoCloseable>(){

        @Override
        public void accept(AutoCloseable value) {
            IOUtil.close(value);
        }
    };
    private static final Consumer<AutoCloseable> CLOSE_QUIETLY = new Consumer<AutoCloseable>(){

        @Override
        public void accept(AutoCloseable value) {
            IOUtil.closeQuietly(value);
        }
    };
    private static final BiConsumer PRINTLN_EQUAL = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), "=", N.toString(value)));
        }
    };
    private static final BiConsumer PRINTLN_HYPHEN = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), "-", N.toString(value)));
        }
    };
    private static final BiConsumer PRINTLN_UNDERSCORE = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), "_", N.toString(value)));
        }
    };
    private static final BiConsumer PRINTLN_COLON = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), ":", N.toString(value)));
        }
    };
    private static final BiConsumer PRINTLN_COLON_SPACE = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), ": ", N.toString(value)));
        }
    };
    private static final BiConsumer PRINTLN_COMMA = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), ",", N.toString(value)));
        }
    };
    private static final BiConsumer PRINTLN_COMMA_SPACE = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), ", ", N.toString(value)));
        }
    };
    private static final BiConsumer PRINTLN_EMPTY = new BiConsumer(){

        @Override
        public void accept(Object key, Object value) {
            N.println(StringUtil.concat(N.toString(key), N.toString(value)));
        }
    };
    private static final Consumer PRINTLN = new Consumer(){

        @Override
        public void accept(Object value) {
            N.println(value);
        }
    };
    private static final Function TO_STRING = new Function(){

        @Override
        public Object apply(Object t) {
            return N.toString(t);
        }
    };
    private static final Function<String, String> TO_CAMEL_CASE = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return StringUtil.toCamelCase(t);
        }
    };
    private static final Function<String, String> TO_LOWER_CASE = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return StringUtil.toLowerCase(t);
        }
    };
    private static final Function<String, String> TO_LOWER_CASE_WITH_UNDERSCORE = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return StringUtil.toLowerCaseWithUnderscore(t);
        }
    };
    private static final Function<String, String> TO_UPPER_CASE = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return StringUtil.toUpperCase(t);
        }
    };
    private static final Function<String, String> TO_UPPER_CASE_WITH_UNDERSCORE = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return StringUtil.toUpperCaseWithUnderscore(t);
        }
    };
    private static final BiFunction COMPARE = new BiFunction<Comparable, Comparable, Integer>(){

        @Override
        public Integer apply(Comparable a, Comparable b) {
            return N.compare(a, b);
        }
    };
    private static final Function IDENTITY = new Function(){

        @Override
        public Object apply(Object t) {
            return t;
        }
    };
    private static final Function<String, String> TRIM = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return t == null ? null : t.trim();
        }
    };
    private static final Function<String, String> TRIM_TO_EMPTY = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return t == null ? "" : t.trim();
        }
    };
    private static final Function<String, String> TRIM_TO_NULL = new Function<String, String>(){

        @Override
        public String apply(String t) {
            if (t == null || (t = t.trim()).length() == 0) {
                return null;
            }
            return t;
        }
    };
    private static final Function<String, String> NULL_TO_EMPTY = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return t == null ? N.EMPTY_STRING : t;
        }
    };
    private static final Function<List, List> NULL_TO_EMPTY_LIST = new Function<List, List>(){

        @Override
        public List apply(List t) {
            return t == null ? N.emptyList() : t;
        }
    };
    private static final Function<Set, Set> NULL_TO_EMPTY_SET = new Function<Set, Set>(){

        @Override
        public Set apply(Set t) {
            return t == null ? N.emptySet() : t;
        }
    };
    private static final Function<Map, Map> NULL_TO_EMPTY_MAP = new Function<Map, Map>(){

        @Override
        public Map apply(Map t) {
            return t == null ? N.emptyMap() : t;
        }
    };
    private static final Function<CharSequence, Integer> LENGTH = new Function<CharSequence, Integer>(){

        @Override
        public Integer apply(CharSequence t) {
            return t == null ? 0 : t.length();
        }
    };
    private static final Function<Object[], Integer> LEN = new Function<Object[], Integer>(){

        @Override
        public Integer apply(Object[] t) {
            return t == null ? 0 : t.length;
        }
    };
    private static final Function<Collection, Integer> SIZE = new Function<Collection, Integer>(){

        @Override
        public Integer apply(Collection t) {
            return t == null ? 0 : t.size();
        }
    };
    private static final Function<Map, Integer> SIZE_MAP = new Function<Map, Integer>(){

        @Override
        public Integer apply(Map t) {
            return t == null ? 0 : t.size();
        }
    };
    private static final Function<Map.Entry<Object, Object>, Object> KEY = new Function<Map.Entry<Object, Object>, Object>(){

        @Override
        public Object apply(Map.Entry<Object, Object> t) {
            return t.getKey();
        }
    };
    private static final Function<Map.Entry<Object, Object>, Object> VALUE = new Function<Map.Entry<Object, Object>, Object>(){

        @Override
        public Object apply(Map.Entry<Object, Object> t) {
            return t.getValue();
        }
    };
    private static final Function<Map.Entry<Object, Object>, Map.Entry<Object, Object>> INVERSE = new Function<Map.Entry<Object, Object>, Map.Entry<Object, Object>>(){

        @Override
        public Map.Entry<Object, Object> apply(Map.Entry<Object, Object> t) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(t.getValue(), t.getKey());
        }
    };
    private static final BiFunction<Object, Object, Map.Entry<Object, Object>> ENTRY = new BiFunction<Object, Object, Map.Entry<Object, Object>>(){

        @Override
        public Map.Entry<Object, Object> apply(Object key, Object value) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
        }
    };
    private static final BiFunction<Object, Object, Pair<Object, Object>> PAIR = new BiFunction<Object, Object, Pair<Object, Object>>(){

        @Override
        public Pair<Object, Object> apply(Object key, Object value) {
            return Pair.of(key, value);
        }
    };
    private static final TriFunction<Object, Object, Object, Triple<Object, Object, Object>> TRIPLE = new TriFunction<Object, Object, Object, Triple<Object, Object, Object>>(){

        @Override
        public Triple<Object, Object, Object> apply(Object a, Object b, Object c) {
            return Triple.of(a, b, c);
        }
    };
    private static final Function<Object, Tuple.Tuple1<Object>> TUPLE_1 = new Function<Object, Tuple.Tuple1<Object>>(){

        @Override
        public Tuple.Tuple1<Object> apply(Object t) {
            return Tuple.of(t);
        }
    };
    private static final BiFunction<Object, Object, Tuple.Tuple2<Object, Object>> TUPLE_2 = new BiFunction<Object, Object, Tuple.Tuple2<Object, Object>>(){

        @Override
        public Tuple.Tuple2<Object, Object> apply(Object t, Object u2) {
            return Tuple.of(t, u2);
        }
    };
    private static final TriFunction<Object, Object, Object, Tuple.Tuple3<Object, Object, Object>> TUPLE_3 = new TriFunction<Object, Object, Object, Tuple.Tuple3<Object, Object, Object>>(){

        @Override
        public Tuple.Tuple3<Object, Object, Object> apply(Object a, Object b, Object c) {
            return Tuple.of(a, b, c);
        }
    };
    private static final QuadFunction<Object, Object, Object, Object, Tuple.Tuple4<Object, Object, Object, Object>> TUPLE_4 = new QuadFunction<Object, Object, Object, Object, Tuple.Tuple4<Object, Object, Object, Object>>(){

        @Override
        public Tuple.Tuple4<Object, Object, Object, Object> apply(Object a, Object b, Object c, Object d) {
            return Tuple.of(a, b, c, d);
        }
    };
    private static final Predicate ALWAYS_TRUE = new Predicate(){

        @Override
        public boolean test(Object value) {
            return true;
        }
    };
    private static final Predicate ALWAYS_FALSE = new Predicate(){

        @Override
        public boolean test(Object value) {
            return false;
        }
    };
    private static final Predicate IS_NULL = new Predicate(){

        @Override
        public boolean test(Object value) {
            return value == null;
        }
    };
    private static final Predicate<CharSequence> IS_NULL_OR_EMPTY = new Predicate<CharSequence>(){

        @Override
        public boolean test(CharSequence value) {
            return value == null || value.length() == 0;
        }
    };
    private static final Predicate<CharSequence> IS_NULL_OR_EMPTY_OR_BLANK = new Predicate<CharSequence>(){

        @Override
        public boolean test(CharSequence value) {
            return N.isNullOrEmptyOrBlank(value);
        }
    };
    private static final Predicate NOT_NULL = new Predicate(){

        @Override
        public boolean test(Object value) {
            return value != null;
        }
    };
    private static final Predicate<CharSequence> NOT_NULL_OR_EMPTY = new Predicate<CharSequence>(){

        @Override
        public boolean test(CharSequence value) {
            return value != null && value.length() > 0;
        }
    };
    private static final Predicate<CharSequence> NOT_NULL_OR_EMPTY_OR_BLANK = new Predicate<CharSequence>(){

        @Override
        public boolean test(CharSequence value) {
            return N.notNullOrEmptyOrBlank(value);
        }
    };
    private static final Predicate<File> IS_FILE = new Predicate<File>(){

        @Override
        public boolean test(File value) {
            return value.isFile();
        }
    };
    private static final Predicate<File> IS_DIRECTORY = new Predicate<File>(){

        @Override
        public boolean test(File value) {
            return value.isDirectory();
        }
    };
    private static final Function<Keyed<?, Object>, Object> VAL = new Function<Keyed<?, Object>, Object>(){

        @Override
        public Object apply(Keyed<?, Object> t) {
            return t.val();
        }
    };
    private static final Function<Map.Entry<Keyed<Object, Object>, Object>, Object> KK = new Function<Map.Entry<Keyed<Object, Object>, Object>, Object>(){

        @Override
        public Object apply(Map.Entry<Keyed<Object, Object>, Object> t) {
            return t.getKey().val();
        }
    };
    private static final Function<Object, Wrapper<Object>> WRAP = new Function<Object, Wrapper<Object>>(){

        @Override
        public Wrapper<Object> apply(Object t) {
            return Wrapper.of(t);
        }
    };
    private static final Function<Wrapper<Object>, Object> UNWRAP = new Function<Wrapper<Object>, Object>(){

        @Override
        public Object apply(Wrapper<Object> t) {
            return t.value();
        }
    };
    private static Function<String, Byte> PARSE_BYTE_FUNC = new Function<String, Byte>(){

        @Override
        public Byte apply(String t) {
            return N.parseByte(t);
        }
    };
    private static Function<String, Short> PARSE_SHORT_FUNC = new Function<String, Short>(){

        @Override
        public Short apply(String t) {
            return N.parseShort(t);
        }
    };
    private static Function<String, Integer> PARSE_INT_FUNC = new Function<String, Integer>(){

        @Override
        public Integer apply(String t) {
            return N.parseInt(t);
        }
    };
    private static Function<String, Long> PARSE_LONG_FUNC = new Function<String, Long>(){

        @Override
        public Long apply(String t) {
            return N.parseLong(t);
        }
    };
    private static Function<String, Float> PARSE_FLOAT_FUNC = new Function<String, Float>(){

        @Override
        public Float apply(String t) {
            return Float.valueOf(N.parseFloat(t));
        }
    };
    private static Function<String, Double> PARSE_DOUBLE_FUNC = new Function<String, Double>(){

        @Override
        public Double apply(String t) {
            return N.parseDouble(t);
        }
    };
    private static Function<String, Number> CREATE_NUMBER_FUNC = new Function<String, Number>(){

        @Override
        public Number apply(final String t) {
            return N.isNullOrEmpty(t) ? (Number)null : (Number)StringUtil.createNumber(t).orElseThrow(new Supplier<NumberFormatException>(){

                @Override
                public NumberFormatException get() {
                    return new NumberFormatException("Invalid number: " + t);
                }
            });
        }
    };

    protected Fn() {
    }

    public static <T> T get(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> Supplier<T> memoize(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private volatile boolean initialized = false;
            private T instance = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (!this.initialized) {
                    53 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.initialized) {
                            this.instance = supplier.get();
                        }
                    }
                }
                return this.instance;
            }
        };
    }

    public static <T, R> Function<T, R> memoize(final Function<? super T, ? extends R> func) {
        return new Function<T, R>(){
            private volatile R resultForNull = Fn.access$400();
            private volatile Map<T, R> resultMap = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R apply(T t) {
                Object result = null;
                if (t == null) {
                    result = this.resultForNull;
                    if (result == NONE) {
                        54 var3_3 = this;
                        synchronized (var3_3) {
                            if (this.resultForNull == NONE) {
                                this.resultForNull = func.apply(t);
                            }
                            result = this.resultForNull;
                        }
                    }
                } else {
                    54 var3_4 = this;
                    synchronized (var3_4) {
                        if (this.resultMap == null) {
                            this.resultMap = new HashMap();
                        }
                        if ((result = (Object)this.resultMap.get(t)) == null && !this.resultMap.containsKey(t)) {
                            result = func.apply(t);
                            this.resultMap.put(t, result);
                        }
                    }
                }
                return result;
            }
        };
    }

    @Deprecated
    @Beta
    @SequentialOnly
    public static <T, C extends Collection<T>> Supplier<? extends C> reuse(final Supplier<? extends C> supplier) {
        return new Supplier<C>(){
            private C c;

            @Override
            public C get() {
                if (this.c == null) {
                    this.c = (Collection)supplier.get();
                } else if (this.c.size() > 0) {
                    this.c.clear();
                }
                return this.c;
            }
        };
    }

    @Deprecated
    @Beta
    @SequentialOnly
    public static <T, C extends Collection<T>> IntFunction<? extends C> reuse(final IntFunction<? extends C> supplier) {
        return new IntFunction<C>(){
            private C c;

            @Override
            public C apply(int size) {
                if (this.c == null) {
                    this.c = (Collection)supplier.apply(size);
                } else if (this.c.size() > 0) {
                    this.c.clear();
                }
                return this.c;
            }
        };
    }

    public static Runnable close(final AutoCloseable closeable) {
        return new Runnable(){
            private volatile boolean isClosed = false;

            @Override
            public void run() {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                IOUtil.close(closeable);
            }
        };
    }

    @SafeVarargs
    public static Runnable closeAll(final AutoCloseable ... a) {
        return new Runnable(){
            private volatile boolean isClosed = false;

            @Override
            public void run() {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                IOUtil.closeAll(a);
            }
        };
    }

    public static Runnable closeAll(final Collection<? extends AutoCloseable> c) {
        return new Runnable(){
            private volatile boolean isClosed = false;

            @Override
            public void run() {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                IOUtil.closeAll(c);
            }
        };
    }

    public static Runnable closeQuietly(final AutoCloseable closeable) {
        return new Runnable(){
            private volatile boolean isClosed = false;

            @Override
            public void run() {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                IOUtil.closeQuietly(closeable);
            }
        };
    }

    @SafeVarargs
    public static Runnable closeAllQuietly(final AutoCloseable ... a) {
        return new Runnable(){
            private volatile boolean isClosed = false;

            @Override
            public void run() {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                IOUtil.closeAllQuietly(a);
            }
        };
    }

    public static Runnable closeAllQuietly(final Collection<? extends AutoCloseable> c) {
        return new Runnable(){
            private volatile boolean isClosed = false;

            @Override
            public void run() {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                IOUtil.closeAllQuietly(c);
            }
        };
    }

    public static Runnable emptyAction() {
        return EMPTY_ACTION;
    }

    public static <T> Consumer<T> doNothing() {
        return DO_NOTHING;
    }

    public static <T extends AutoCloseable> Consumer<T> close() {
        return CLOSE;
    }

    public static <T extends AutoCloseable> Consumer<T> closeQuietly() {
        return CLOSE_QUIETLY;
    }

    public static <T> Consumer<T> sleep(final long millis) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                N.sleep(millis);
            }
        };
    }

    public static <T> Consumer<T> sleepUninterruptibly(final long millis) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                N.sleepUninterruptibly(millis);
            }
        };
    }

    public static <T> Consumer<T> println() {
        return PRINTLN;
    }

    public static <T, U> BiConsumer<T, U> println(final String separator) {
        N.checkArgNotNull(separator);
        switch (separator) {
            case "=": {
                return PRINTLN_EQUAL;
            }
            case ":": {
                return PRINTLN_COLON;
            }
            case ": ": {
                return PRINTLN_COLON_SPACE;
            }
            case "-": {
                return PRINTLN_HYPHEN;
            }
            case "_": {
                return PRINTLN_UNDERSCORE;
            }
            case ",": {
                return PRINTLN_COMMA;
            }
            case ", ": {
                return PRINTLN_COMMA_SPACE;
            }
            case "": {
                return PRINTLN_EMPTY;
            }
        }
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T t, U u2) {
                N.println(t + separator + u2);
            }
        };
    }

    public static <T> Function<T, String> toStr() {
        return TO_STRING;
    }

    public static Function<String, String> toCamelCase() {
        return TO_CAMEL_CASE;
    }

    public static Function<String, String> toLowerCase() {
        return TO_LOWER_CASE;
    }

    public static Function<String, String> toLowerCaseWithUnderscore() {
        return TO_LOWER_CASE_WITH_UNDERSCORE;
    }

    public static Function<String, String> toUpperCase() {
        return TO_UPPER_CASE;
    }

    public static Function<String, String> toUpperCaseWithUnderscore() {
        return TO_UPPER_CASE_WITH_UNDERSCORE;
    }

    public static <T> Function<T, T> identity() {
        return IDENTITY;
    }

    public static <K, T> Function<T, Keyed<K, T>> keyed(final Function<? super T, K> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Function<T, Keyed<K, T>>(){

            @Override
            public Keyed<K, T> apply(T t) {
                return Keyed.of(keyMapper.apply(t), t);
            }
        };
    }

    public static <K, T> Function<Keyed<K, T>, T> val() {
        return VAL;
    }

    public static <T, K, V> Function<Map.Entry<Keyed<K, T>, V>, T> kk() {
        return KK;
    }

    public static <T> Function<T, Wrapper<T>> wrap() {
        return WRAP;
    }

    public static <T> Function<T, Wrapper<T>> wrap(final ToIntFunction<? super T> hashFunction, final BiPredicate<? super T, ? super T> equalsFunction) {
        N.checkArgNotNull(hashFunction);
        N.checkArgNotNull(equalsFunction);
        return new Function<T, Wrapper<T>>(){

            @Override
            public Wrapper<T> apply(T t) {
                return Wrapper.of(t, hashFunction, equalsFunction);
            }
        };
    }

    public static <K, T> Function<Wrapper<T>, T> unwrap() {
        return UNWRAP;
    }

    public static <K, V> Function<Map.Entry<K, V>, K> key() {
        return KEY;
    }

    public static <K, V> Function<Map.Entry<K, V>, V> value() {
        return VALUE;
    }

    public static <K, V> Function<Map.Entry<K, V>, Map.Entry<V, K>> inverse() {
        return INVERSE;
    }

    public static <K, V> BiFunction<K, V, Map.Entry<K, V>> entry() {
        return ENTRY;
    }

    public static <K, T> Function<T, Map.Entry<K, T>> entry(final K key) {
        return new Function<T, Map.Entry<K, T>>(){

            @Override
            public Map.Entry<K, T> apply(T t) {
                return new AbstractMap.SimpleImmutableEntry(key, t);
            }
        };
    }

    public static <K, T> Function<T, Map.Entry<K, T>> entry(final Function<? super T, K> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Function<T, Map.Entry<K, T>>(){

            @Override
            public Map.Entry<K, T> apply(T t) {
                return new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t), t);
            }
        };
    }

    public static <L, R> BiFunction<L, R, Pair<L, R>> pair() {
        return PAIR;
    }

    public static <L, M, R> TriFunction<L, M, R, Triple<L, M, R>> triple() {
        return TRIPLE;
    }

    public static <T> Function<T, Tuple.Tuple1<T>> tuple1() {
        return TUPLE_1;
    }

    public static <T, U> BiFunction<T, U, Tuple.Tuple2<T, U>> tuple2() {
        return TUPLE_2;
    }

    public static <A, B, C> TriFunction<A, B, C, Tuple.Tuple3<A, B, C>> tuple3() {
        return TUPLE_3;
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, Tuple.Tuple4<A, B, C, D>> tuple4() {
        return TUPLE_4;
    }

    public static Function<String, String> trim() {
        return TRIM;
    }

    public static Function<String, String> trimToEmpty() {
        return TRIM_TO_EMPTY;
    }

    public static Function<String, String> trimToNull() {
        return TRIM_TO_NULL;
    }

    public static Function<String, String> nullToEmpty() {
        return NULL_TO_EMPTY;
    }

    @Deprecated
    public static <T> Function<List<T>, List<T>> nullToEmptyL() {
        return NULL_TO_EMPTY_LIST;
    }

    public static <T> Function<List<T>, List<T>> nullToEmptyList() {
        return NULL_TO_EMPTY_LIST;
    }

    @Deprecated
    public static <T> Function<Set<T>, Set<T>> nullToEmptyS() {
        return NULL_TO_EMPTY_SET;
    }

    public static <T> Function<Set<T>, Set<T>> nullToEmptySet() {
        return NULL_TO_EMPTY_SET;
    }

    @Deprecated
    public static <K, V> Function<Map<K, V>, Map<K, V>> nullToEmptyM() {
        return NULL_TO_EMPTY_MAP;
    }

    public static <K, V> Function<Map<K, V>, Map<K, V>> nullToEmptyMap() {
        return NULL_TO_EMPTY_MAP;
    }

    public static <T extends CharSequence> Function<T, Integer> length() {
        return LENGTH;
    }

    public static <T> Function<T[], Integer> len() {
        return LEN;
    }

    public static <T extends Collection> Function<T, Integer> size() {
        return SIZE;
    }

    public static <T extends Map> Function<T, Integer> sizeM() {
        return SIZE_MAP;
    }

    public static <T, U> Function<T, U> cast(Class<U> clazz) {
        N.checkArgNotNull(clazz);
        return new Function<T, U>(){

            @Override
            public U apply(T t) {
                return t;
            }
        };
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <T> Predicate<T> isNull() {
        return IS_NULL;
    }

    public static <T extends CharSequence> Predicate<T> isNullOrEmpty() {
        return IS_NULL_OR_EMPTY;
    }

    public static <T extends CharSequence> Predicate<T> isNullOrEmptyOrBlank() {
        return IS_NULL_OR_EMPTY_OR_BLANK;
    }

    public static <T> Predicate<T> notNull() {
        return NOT_NULL;
    }

    public static <T extends CharSequence> Predicate<T> notNullOrEmpty() {
        return NOT_NULL_OR_EMPTY;
    }

    public static <T extends CharSequence> Predicate<T> notNullOrEmptyOrBlank() {
        return NOT_NULL_OR_EMPTY_OR_BLANK;
    }

    public static Predicate<File> isFile() {
        return IS_FILE;
    }

    public static Predicate<File> isDirectory() {
        return IS_DIRECTORY;
    }

    public static <T> Predicate<T> equal(final Object target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return N.equals(value, target);
            }
        };
    }

    public static <T> Predicate<T> notEqual(final Object target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return !N.equals(value, target);
            }
        };
    }

    public static <T extends Comparable> Predicate<T> greaterThan(final T target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return N.compare(value, target) > 0;
            }
        };
    }

    public static <T extends Comparable> Predicate<T> greaterEqual(final T target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return N.compare(value, target) >= 0;
            }
        };
    }

    public static <T extends Comparable> Predicate<T> lessThan(final T target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return N.compare(value, target) < 0;
            }
        };
    }

    public static <T extends Comparable> Predicate<T> lessEqual(final T target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return N.compare(value, target) <= 0;
            }
        };
    }

    public static <T extends Comparable> Predicate<T> between(final T minValue, final T maxValue) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return N.compare(value, minValue) > 0 && N.compare(value, maxValue) < 0;
            }
        };
    }

    public static <T> Predicate<T> in(final Collection<?> c) {
        N.checkArgNotNull(c);
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return c != null && c.size() > 0 && c.contains(value);
            }
        };
    }

    public static <T> Predicate<T> notIn(final Collection<?> c) {
        N.checkArgNotNull(c);
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return c == null || c.size() == 0 || !c.contains(value);
            }
        };
    }

    public static <T> Predicate<T> instanceOf(final Class<?> clazz) {
        N.checkArgNotNull(clazz);
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return value != null && clazz.isInstance(value);
            }
        };
    }

    public static Predicate<Class> subtypeOf(final Class<?> clazz) {
        N.checkArgNotNull(clazz);
        return new Predicate<Class>(){

            @Override
            public boolean test(Class value) {
                return clazz.isAssignableFrom(value);
            }
        };
    }

    public static Predicate<String> startsWith(final String prefix) {
        N.checkArgNotNull(prefix);
        return new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return value != null && value.startsWith(prefix);
            }
        };
    }

    public static Predicate<String> endsWith(final String suffix) {
        N.checkArgNotNull(suffix);
        return new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return value != null && value.endsWith(suffix);
            }
        };
    }

    public static Predicate<String> contains(final String str) {
        N.checkArgNotNull(str);
        return new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return value != null && value.contains(str);
            }
        };
    }

    public static Predicate<String> notStartsWith(final String prefix) {
        N.checkArgNotNull(prefix);
        return new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return value == null || !value.startsWith(prefix);
            }
        };
    }

    public static Predicate<String> notEndsWith(final String suffix) {
        N.checkArgNotNull(suffix);
        return new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return value == null || !value.endsWith(suffix);
            }
        };
    }

    public static Predicate<String> notContains(final String str) {
        N.checkArgNotNull(str);
        return new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return value == null || !value.contains(str);
            }
        };
    }

    public static Predicate<CharSequence> matches(final Pattern pattern) {
        N.checkArgNotNull(pattern);
        return new Predicate<CharSequence>(){

            @Override
            public boolean test(CharSequence value) {
                return pattern.matcher(value).find();
            }
        };
    }

    public static <T, U> BiPredicate<T, U> equal() {
        return BiPredicates.EQUAL;
    }

    public static <T, U> BiPredicate<T, U> notEqual() {
        return BiPredicates.NOT_EQUAL;
    }

    public static <T extends Comparable> BiPredicate<T, T> greaterThan() {
        return BiPredicates.GREATER_THAN;
    }

    public static <T extends Comparable> BiPredicate<T, T> greaterEqual() {
        return BiPredicates.GREATER_EQUAL;
    }

    public static <T extends Comparable> BiPredicate<T, T> lessThan() {
        return BiPredicates.LESS_THAN;
    }

    public static <T extends Comparable> BiPredicate<T, T> lessEqual() {
        return BiPredicates.LESS_EQUAL;
    }

    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        N.checkArgNotNull(predicate);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !predicate.test(t);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> not(final BiPredicate<T, U> biPredicate) {
        N.checkArgNotNull(biPredicate);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                return !biPredicate.test(t, u2);
            }
        };
    }

    public static <A, B, C> TriPredicate<A, B, C> not(final TriPredicate<A, B, C> triPredicate) {
        N.checkArgNotNull(triPredicate);
        return new TriPredicate<A, B, C>(){

            @Override
            public boolean test(A a, B b, C c) {
                return !triPredicate.test(a, b, c);
            }
        };
    }

    public static BooleanSupplier and(final BooleanSupplier first, final BooleanSupplier second) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return first.getAsBoolean() && second.getAsBoolean();
            }
        };
    }

    public static BooleanSupplier and(final BooleanSupplier first, final BooleanSupplier second, final BooleanSupplier third) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        N.checkArgNotNull(third);
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return first.getAsBoolean() && second.getAsBoolean() && third.getAsBoolean();
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> first, final Predicate<? super T> second) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) && second.test(t);
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> first, final Predicate<? super T> second, final Predicate<? super T> third) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        N.checkArgNotNull(third);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) && second.test(t) && third.test(t);
            }
        };
    }

    public static <T> Predicate<T> and(final Collection<Predicate<? super T>> c) {
        N.checkArgNotNullOrEmpty(c, "c");
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate p : c) {
                    if (p.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T, U> BiPredicate<T, U> and(final BiPredicate<? super T, ? super U> first, final BiPredicate<? super T, ? super U> second) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                return first.test(t, u2) && second.test(t, u2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> and(final BiPredicate<? super T, ? super U> first, final BiPredicate<? super T, ? super U> second, final BiPredicate<? super T, ? super U> third) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        N.checkArgNotNull(third);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                return first.test(t, u2) && second.test(t, u2) && third.test(t, u2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> and(final List<BiPredicate<? super T, ? super U>> c) {
        N.checkArgNotNullOrEmpty(c, "c");
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                for (BiPredicate p : c) {
                    if (p.test(t, u2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static BooleanSupplier or(final BooleanSupplier first, final BooleanSupplier second) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return first.getAsBoolean() || second.getAsBoolean();
            }
        };
    }

    public static BooleanSupplier or(final BooleanSupplier first, final BooleanSupplier second, final BooleanSupplier third) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        N.checkArgNotNull(third);
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return first.getAsBoolean() || second.getAsBoolean() || third.getAsBoolean();
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> first, final Predicate<? super T> second) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) || second.test(t);
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> first, final Predicate<? super T> second, final Predicate<? super T> third) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        N.checkArgNotNull(third);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) || second.test(t) || third.test(t);
            }
        };
    }

    public static <T> Predicate<T> or(final Collection<Predicate<? super T>> c) {
        N.checkArgNotNullOrEmpty(c, "c");
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate p : c) {
                    if (!p.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T, U> BiPredicate<T, U> or(final BiPredicate<? super T, ? super U> first, final BiPredicate<? super T, ? super U> second) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                return first.test(t, u2) || second.test(t, u2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> or(final BiPredicate<? super T, ? super U> first, final BiPredicate<? super T, ? super U> second, final BiPredicate<? super T, ? super U> third) {
        N.checkArgNotNull(first);
        N.checkArgNotNull(second);
        N.checkArgNotNull(third);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                return first.test(t, u2) || second.test(t, u2) || third.test(t, u2);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> or(final List<BiPredicate<? super T, ? super U>> c) {
        N.checkArgNotNullOrEmpty(c, "c");
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                for (BiPredicate p : c) {
                    if (!p.test(t, u2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <K, V> Predicate<Map.Entry<K, V>> testByKey(final Predicate<? super K> predicate) {
        N.checkArgNotNull(predicate);
        return new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean test(Map.Entry<K, V> entry) {
                return predicate.test(entry.getKey());
            }
        };
    }

    public static <K, V> Predicate<Map.Entry<K, V>> testByValue(final Predicate<? super V> predicate) {
        N.checkArgNotNull(predicate);
        return new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean test(Map.Entry<K, V> entry) {
                return predicate.test(entry.getValue());
            }
        };
    }

    @Deprecated
    static <T> Predicate<T> test(Predicate<T> predicate) {
        return predicate;
    }

    @Deprecated
    static <T, U> BiPredicate<T, U> test(BiPredicate<T, U> predicate) {
        return predicate;
    }

    @Deprecated
    static <A, B, C> TriPredicate<A, B, C> test(TriPredicate<A, B, C> predicate) {
        return predicate;
    }

    public static <K, V> Consumer<Map.Entry<K, V>> acceptByKey(final Consumer<? super K> consumer) {
        N.checkArgNotNull(consumer);
        return new Consumer<Map.Entry<K, V>>(){

            @Override
            public void accept(Map.Entry<K, V> entry) {
                consumer.accept(entry.getKey());
            }
        };
    }

    public static <K, V> Consumer<Map.Entry<K, V>> acceptByValue(final Consumer<? super V> consumer) {
        N.checkArgNotNull(consumer);
        return new Consumer<Map.Entry<K, V>>(){

            @Override
            public void accept(Map.Entry<K, V> entry) {
                consumer.accept(entry.getValue());
            }
        };
    }

    public static <K, V, R> Function<Map.Entry<K, V>, R> applyByKey(final Function<? super K, R> func) {
        N.checkArgNotNull(func);
        return new Function<Map.Entry<K, V>, R>(){

            @Override
            public R apply(Map.Entry<K, V> entry) {
                return func.apply(entry.getKey());
            }
        };
    }

    public static <K, V, R> Function<Map.Entry<K, V>, R> applyByValue(final Function<? super V, R> func) {
        N.checkArgNotNull(func);
        return new Function<Map.Entry<K, V>, R>(){

            @Override
            public R apply(Map.Entry<K, V> entry) {
                return func.apply(entry.getValue());
            }
        };
    }

    public static <A, B, R> Function<A, R> applyIfNotNullOrDefault(final Function<A, B> mapperA, final Function<B, R> mapperB, final R defaultValue) {
        N.checkArgNotNull(mapperA);
        N.checkArgNotNull(mapperB);
        return new Function<A, R>(){

            @Override
            public R apply(A a) {
                if (a == null) {
                    return defaultValue;
                }
                Object b = mapperA.apply(a);
                if (b == null) {
                    return defaultValue;
                }
                return mapperB.apply(b);
            }
        };
    }

    public static <A, B, C, R> Function<A, R> applyIfNotNullOrDefault(final Function<A, B> mapperA, final Function<B, C> mapperB, final Function<C, R> mapperC, final R defaultValue) {
        N.checkArgNotNull(mapperA);
        N.checkArgNotNull(mapperB);
        N.checkArgNotNull(mapperC);
        return new Function<A, R>(){

            @Override
            public R apply(A a) {
                if (a == null) {
                    return defaultValue;
                }
                Object b = mapperA.apply(a);
                if (b == null) {
                    return defaultValue;
                }
                Object c = mapperB.apply(b);
                if (c == null) {
                    return defaultValue;
                }
                return mapperC.apply(c);
            }
        };
    }

    public static <A, B, C, D, R> Function<A, R> applyIfNotNullOrDefault(final Function<A, B> mapperA, final Function<B, C> mapperB, final Function<C, D> mapperC, final Function<D, R> mapperD, final R defaultValue) {
        N.checkArgNotNull(mapperA);
        N.checkArgNotNull(mapperB);
        N.checkArgNotNull(mapperC);
        N.checkArgNotNull(mapperD);
        return new Function<A, R>(){

            @Override
            public R apply(A a) {
                if (a == null) {
                    return defaultValue;
                }
                Object b = mapperA.apply(a);
                if (b == null) {
                    return defaultValue;
                }
                Object c = mapperB.apply(b);
                if (c == null) {
                    return defaultValue;
                }
                Object d = mapperC.apply(c);
                if (d == null) {
                    return defaultValue;
                }
                return mapperD.apply(d);
            }
        };
    }

    public static <A, B, R> Function<A, R> applyIfNotNullOrGet(final Function<A, B> mapperA, final Function<B, R> mapperB, final Supplier<R> supplier) {
        N.checkArgNotNull(mapperA);
        N.checkArgNotNull(mapperB);
        return new Function<A, R>(){

            @Override
            public R apply(A a) {
                if (a == null) {
                    return supplier.get();
                }
                Object b = mapperA.apply(a);
                if (b == null) {
                    return supplier.get();
                }
                return mapperB.apply(b);
            }
        };
    }

    public static <A, B, C, R> Function<A, R> applyIfNotNullOrGet(final Function<A, B> mapperA, final Function<B, C> mapperB, final Function<C, R> mapperC, final Supplier<R> supplier) {
        N.checkArgNotNull(mapperA);
        N.checkArgNotNull(mapperB);
        N.checkArgNotNull(mapperC);
        return new Function<A, R>(){

            @Override
            public R apply(A a) {
                if (a == null) {
                    return supplier.get();
                }
                Object b = mapperA.apply(a);
                if (b == null) {
                    return supplier.get();
                }
                Object c = mapperB.apply(b);
                if (c == null) {
                    return supplier.get();
                }
                return mapperC.apply(c);
            }
        };
    }

    public static <A, B, C, D, R> Function<A, R> applyIfNotNullOrGet(final Function<A, B> mapperA, final Function<B, C> mapperB, final Function<C, D> mapperC, final Function<D, R> mapperD, final Supplier<R> supplier) {
        N.checkArgNotNull(mapperA);
        N.checkArgNotNull(mapperB);
        N.checkArgNotNull(mapperC);
        N.checkArgNotNull(mapperD);
        return new Function<A, R>(){

            @Override
            public R apply(A a) {
                if (a == null) {
                    return supplier.get();
                }
                Object b = mapperA.apply(a);
                if (b == null) {
                    return supplier.get();
                }
                Object c = mapperB.apply(b);
                if (c == null) {
                    return supplier.get();
                }
                Object d = mapperC.apply(c);
                if (d == null) {
                    return supplier.get();
                }
                return mapperD.apply(d);
            }
        };
    }

    public static <K, V, KK> Function<Map.Entry<K, V>, Map.Entry<KK, V>> mapKey(final Function<? super K, ? extends KK> func) {
        N.checkArgNotNull(func);
        return new Function<Map.Entry<K, V>, Map.Entry<KK, V>>(){

            @Override
            public Map.Entry<KK, V> apply(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleImmutableEntry(func.apply(entry.getKey()), entry.getValue());
            }
        };
    }

    public static <K, V, VV> Function<Map.Entry<K, V>, Map.Entry<K, VV>> mapValue(final Function<? super V, ? extends VV> func) {
        N.checkArgNotNull(func);
        return new Function<Map.Entry<K, V>, Map.Entry<K, VV>>(){

            @Override
            public Map.Entry<K, VV> apply(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleImmutableEntry(entry.getKey(), func.apply(entry.getValue()));
            }
        };
    }

    public static <K, V> Predicate<Map.Entry<K, V>> testKeyVal(final BiPredicate<? super K, ? super V> predicate) {
        N.checkArgNotNull(predicate);
        return new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean test(Map.Entry<K, V> entry) {
                return predicate.test(entry.getKey(), entry.getValue());
            }
        };
    }

    public static <K, V> Consumer<Map.Entry<K, V>> acceptKeyVal(final BiConsumer<? super K, ? super V> consumer) {
        N.checkArgNotNull(consumer);
        return new Consumer<Map.Entry<K, V>>(){

            @Override
            public void accept(Map.Entry<K, V> entry) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        };
    }

    public static <K, V, R> Function<Map.Entry<K, V>, R> applyKeyVal(final BiFunction<? super K, ? super V, R> func) {
        N.checkArgNotNull(func);
        return new Function<Map.Entry<K, V>, R>(){

            @Override
            public R apply(Map.Entry<K, V> entry) {
                return func.apply(entry.getKey(), entry.getValue());
            }
        };
    }

    public static Function<String, Byte> parseByte() {
        return PARSE_BYTE_FUNC;
    }

    public static Function<String, Short> parseShort() {
        return PARSE_SHORT_FUNC;
    }

    public static Function<String, Integer> parseInt() {
        return PARSE_INT_FUNC;
    }

    public static Function<String, Long> parseLong() {
        return PARSE_LONG_FUNC;
    }

    public static Function<String, Float> parseFloat() {
        return PARSE_FLOAT_FUNC;
    }

    public static Function<String, Double> parseDouble() {
        return PARSE_DOUBLE_FUNC;
    }

    public static Function<String, Number> createNumber() {
        return CREATE_NUMBER_FUNC;
    }

    public static <T extends Number> ToIntFunction<T> numToInt() {
        return ToIntFunction.FROM_NUM;
    }

    public static <T extends Number> ToLongFunction<T> numToLong() {
        return ToLongFunction.FROM_NUM;
    }

    public static <T extends Number> ToDoubleFunction<T> numToDouble() {
        return ToDoubleFunction.FROM_NUM;
    }

    @Beta
    public static <T> Predicate<T> limitThenFilter(final int limit, final Predicate<T> predicate) {
        N.checkArgNotNull(predicate);
        return new Predicate<T>(){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger(limit);
            }

            @Override
            public boolean test(T t) {
                return this.counter.getAndDecrement() > 0 && predicate.test(t);
            }
        };
    }

    @Beta
    public static <T, U> BiPredicate<T, U> limitThenFilter(final int limit, final BiPredicate<T, U> predicate) {
        N.checkArgNotNull(predicate);
        return new BiPredicate<T, U>(){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger(limit);
            }

            @Override
            public boolean test(T t, U u2) {
                return this.counter.getAndDecrement() > 0 && predicate.test(t, u2);
            }
        };
    }

    @Beta
    public static <T> Predicate<T> filterThenLimit(final Predicate<T> predicate, final int limit) {
        N.checkArgNotNull(predicate);
        return new Predicate<T>(){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger(limit);
            }

            @Override
            public boolean test(T t) {
                return predicate.test(t) && this.counter.getAndDecrement() > 0;
            }
        };
    }

    @Beta
    public static <T, U> BiPredicate<T, U> filterThenLimit(final BiPredicate<T, U> predicate, final int limit) {
        N.checkArgNotNull(predicate);
        return new BiPredicate<T, U>(){
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger(limit);
            }

            @Override
            public boolean test(T t, U u2) {
                return predicate.test(t, u2) && this.counter.getAndDecrement() > 0;
            }
        };
    }

    @Beta
    public static <T> Predicate<T> timeLimit(long timeInMillis) {
        N.checkArgNotNegative(timeInMillis, "timeInMillis");
        if (timeInMillis == 0L) {
            return Fn.alwaysFalse();
        }
        final MutableBoolean ongoing = MutableBoolean.of(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ongoing.setFalse();
            }
        };
        timer.schedule(task, timeInMillis);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return ongoing.value();
            }
        };
    }

    @Beta
    public static <T> Predicate<T> timeLimit(Duration duration) {
        N.checkArgNotNull(duration, "duration");
        return Fn.timeLimit(duration.toMillis());
    }

    @Beta
    @SequentialOnly
    public static <T> Function<T, Indexed<T>> indexed() {
        return new Function<T, Indexed<T>>(){
            private final MutableLong idx = new MutableLong(0L);

            @Override
            public Indexed<T> apply(T t) {
                return Indexed.of(t, this.idx.getAndIncrement());
            }
        };
    }

    @Beta
    @SequentialOnly
    public static <T> Predicate<T> indexed(IndexedPredicate<T> predicate) {
        return Predicates.indexed(predicate);
    }

    public static <T extends Comparable> Function<T, Integer> compareTo(final T target) {
        return new Function<T, Integer>(){

            @Override
            public Integer apply(T t) {
                return N.compare(t, target);
            }
        };
    }

    public static <T> Function<T, Integer> compareTo(final T target, final Comparator<? super T> cmp) {
        if (cmp == null || cmp == Comparators.naturalOrder()) {
            return Fn.compareTo((Comparable)target);
        }
        return new Function<T, Integer>(){

            @Override
            public Integer apply(T t) {
                return N.compare(t, target, cmp);
            }
        };
    }

    public static <T extends Comparable> BiFunction<T, T, Integer> compare() {
        return COMPARE;
    }

    public static <T> BiFunction<T, T, Integer> compare(final Comparator<? super T> cmp) {
        if (cmp == null || cmp == Comparators.naturalOrder()) {
            return COMPARE;
        }
        return new BiFunction<T, T, Integer>(){

            @Override
            public Integer apply(T a, T b) {
                return N.compare(a, b, cmp);
            }
        };
    }

    @Beta
    public static <T> Predicate<T> p(Predicate<T> predicate) {
        return predicate;
    }

    @Beta
    public static <A, T> Predicate<T> p(final A a, final BiPredicate<A, T> biPredicate) {
        N.checkArgNotNull(biPredicate);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return biPredicate.test(a, t);
            }
        };
    }

    @Beta
    public static <A, B, T> Predicate<T> p(final A a, final B b, final TriPredicate<A, B, T> triPredicate) {
        N.checkArgNotNull(triPredicate);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return triPredicate.test(a, b, t);
            }
        };
    }

    @Beta
    public static <T, U> BiPredicate<T, U> p(BiPredicate<T, U> biPredicate) {
        return biPredicate;
    }

    @Beta
    public static <A, T, U> BiPredicate<T, U> p(final A a, final TriPredicate<A, T, U> triPredicate) {
        N.checkArgNotNull(triPredicate);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                return triPredicate.test(a, t, u2);
            }
        };
    }

    @Beta
    public static <A, B, C> TriPredicate<A, B, C> p(TriPredicate<A, B, C> triPredicate) {
        return triPredicate;
    }

    @Beta
    public static <T> Consumer<T> c(Consumer<T> predicate) {
        return predicate;
    }

    @Beta
    public static <A, T> Consumer<T> c(final A a, final BiConsumer<A, T> biConsumer) {
        N.checkArgNotNull(biConsumer);
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                biConsumer.accept(a, t);
            }
        };
    }

    @Beta
    public static <A, B, T> Consumer<T> c(final A a, final B b, final TriConsumer<A, B, T> triConsumer) {
        N.checkArgNotNull(triConsumer);
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                triConsumer.accept(a, b, t);
            }
        };
    }

    @Beta
    public static <T, U> BiConsumer<T, U> c(BiConsumer<T, U> biConsumer) {
        return biConsumer;
    }

    @Beta
    public static <A, T, U> BiConsumer<T, U> c(final A a, final TriConsumer<A, T, U> triConsumer) {
        N.checkArgNotNull(triConsumer);
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T t, U u2) {
                triConsumer.accept(a, t, u2);
            }
        };
    }

    @Beta
    public static <A, B, C> TriConsumer<A, B, C> c(TriConsumer<A, B, C> triConsumer) {
        return triConsumer;
    }

    @Beta
    public static <T, R> Function<T, R> f(Function<T, R> predicate) {
        return predicate;
    }

    @Beta
    public static <A, T, R> Function<T, R> f(final A a, final BiFunction<A, T, R> biFunction) {
        N.checkArgNotNull(biFunction);
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                return biFunction.apply(a, t);
            }
        };
    }

    @Beta
    public static <A, B, T, R> Function<T, R> f(final A a, final B b, final TriFunction<A, B, T, R> triFunction) {
        N.checkArgNotNull(triFunction);
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                return triFunction.apply(a, b, t);
            }
        };
    }

    @Beta
    public static <T, U, R> BiFunction<T, U, R> f(BiFunction<T, U, R> biFunction) {
        return biFunction;
    }

    @Beta
    public static <A, T, U, R> BiFunction<T, U, R> f(final A a, final TriFunction<A, T, U, R> triFunction) {
        N.checkArgNotNull(triFunction);
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u2) {
                return triFunction.apply(a, t, u2);
            }
        };
    }

    @Beta
    public static <A, B, C, R> TriFunction<A, B, C, R> f(TriFunction<A, B, C, R> triFunction) {
        return triFunction;
    }

    @Beta
    public static <T, E extends Exception> Predicate<T> pp(final Try.Predicate<T, E> predicate) {
        N.checkArgNotNull(predicate);
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                try {
                    return predicate.test(value);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, T, E extends Exception> Predicate<T> pp(final A a, final Try.BiPredicate<A, T, E> biPredicate) {
        N.checkArgNotNull(biPredicate);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return biPredicate.test(a, t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, B, T, E extends Exception> Predicate<T> pp(final A a, final B b, final Try.TriPredicate<A, B, T, E> triPredicate) {
        N.checkArgNotNull(triPredicate);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return triPredicate.test(a, b, t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <T, U, E extends Exception> BiPredicate<T, U> pp(final Try.BiPredicate<T, U, E> biPredicate) {
        N.checkArgNotNull(biPredicate);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                try {
                    return biPredicate.test(t, u2);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, T, U, E extends Exception> BiPredicate<T, U> pp(final A a, final Try.TriPredicate<A, T, U, E> triPredicate) {
        N.checkArgNotNull(triPredicate);
        return new BiPredicate<T, U>(){

            @Override
            public boolean test(T t, U u2) {
                try {
                    return triPredicate.test(a, t, u2);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, B, C, E extends Exception> TriPredicate<A, B, C> pp(final Try.TriPredicate<A, B, C, E> triPredicate) {
        N.checkArgNotNull(triPredicate);
        return new TriPredicate<A, B, C>(){

            @Override
            public boolean test(A a, B b, C c) {
                try {
                    return triPredicate.test(a, b, c);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <T, E extends Exception> Consumer<T> cc(final Try.Consumer<T, E> consumer) {
        N.checkArgNotNull(consumer);
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    consumer.accept(t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, T, E extends Exception> Consumer<T> cc(final A a, final Try.BiConsumer<A, T, E> biConsumer) {
        N.checkArgNotNull(biConsumer);
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    biConsumer.accept(a, t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, B, T, E extends Exception> Consumer<T> cc(final A a, final B b, final Try.TriConsumer<A, B, T, E> triConsumer) {
        N.checkArgNotNull(triConsumer);
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    triConsumer.accept(a, b, t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <T, U, E extends Exception> BiConsumer<T, U> cc(final Try.BiConsumer<T, U, E> biConsumer) {
        N.checkArgNotNull(biConsumer);
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T t, U u2) {
                try {
                    biConsumer.accept(t, u2);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, T, U, E extends Exception> BiConsumer<T, U> cc(final A a, final Try.TriConsumer<A, T, U, E> triConsumer) {
        N.checkArgNotNull(triConsumer);
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T t, U u2) {
                try {
                    triConsumer.accept(a, t, u2);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, B, C, E extends Exception> TriConsumer<A, B, C> cc(final Try.TriConsumer<A, B, C, E> triConsumer) {
        N.checkArgNotNull(triConsumer);
        return new TriConsumer<A, B, C>(){

            @Override
            public void accept(A a, B b, C c) {
                try {
                    triConsumer.accept(a, b, c);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <T, R, E extends Exception> Function<T, R> ff(final Try.Function<T, R, E> function) {
        N.checkArgNotNull(function);
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return function.apply(t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, T, R, E extends Exception> Function<T, R> ff(final A a, final Try.BiFunction<A, T, R, E> biFunction) {
        N.checkArgNotNull(biFunction);
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return biFunction.apply(a, t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, B, T, R, E extends Exception> Function<T, R> ff(final A a, final B b, final Try.TriFunction<A, B, T, R, E> triFunction) {
        N.checkArgNotNull(triFunction);
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return triFunction.apply(a, b, t);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <T, U, R, E extends Exception> BiFunction<T, U, R> ff(final Try.BiFunction<T, U, R, E> biFunction) {
        N.checkArgNotNull(biFunction);
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u2) {
                try {
                    return biFunction.apply(t, u2);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, T, U, R, E extends Exception> BiFunction<T, U, R> ff(final A a, final Try.TriFunction<A, T, U, R, E> triFunction) {
        N.checkArgNotNull(triFunction);
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u2) {
                try {
                    return triFunction.apply(a, t, u2);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <A, B, C, R, E extends Exception> TriFunction<A, B, C, R> ff(final Try.TriFunction<A, B, C, R, E> triFunction) {
        N.checkArgNotNull(triFunction);
        return new TriFunction<A, B, C, R>(){

            @Override
            public R apply(A a, B b, C c) {
                try {
                    return triFunction.apply(a, b, c);
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        };
    }

    @Beta
    public static <T> Predicate<T> sp(final Object mutex, final Predicate<T> predicate) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(predicate, "predicate");
        return new Predicate<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean test(T t) {
                Object object = mutex;
                synchronized (object) {
                    return predicate.test(t);
                }
            }
        };
    }

    @Beta
    public static <A, T> Predicate<T> sp(final Object mutex, final A a, final BiPredicate<A, T> biPredicate) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(biPredicate, "biPredicate");
        return new Predicate<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean test(T t) {
                Object object = mutex;
                synchronized (object) {
                    return biPredicate.test(a, t);
                }
            }
        };
    }

    @Beta
    public static <A, B, T> Predicate<T> sp(final Object mutex, final A a, final B b, final TriPredicate<A, B, T> triPredicate) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(triPredicate, "triPredicate");
        return new Predicate<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean test(T t) {
                Object object = mutex;
                synchronized (object) {
                    return triPredicate.test(a, b, t);
                }
            }
        };
    }

    @Beta
    public static <T, U> BiPredicate<T, U> sp(final Object mutex, final BiPredicate<T, U> biPredicate) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(biPredicate, "biPredicate");
        return new BiPredicate<T, U>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean test(T t, U u2) {
                Object object = mutex;
                synchronized (object) {
                    return biPredicate.test(t, u2);
                }
            }
        };
    }

    @Beta
    public static <T> Consumer<T> sc(final Object mutex, final Consumer<T> consumer) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(consumer, "consumer");
        return new Consumer<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(T t) {
                Object object = mutex;
                synchronized (object) {
                    consumer.accept(t);
                }
            }
        };
    }

    @Beta
    public static <A, T> Consumer<T> sc(final Object mutex, final A a, final BiConsumer<A, T> biConsumer) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(biConsumer, "biConsumer");
        return new Consumer<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(T t) {
                Object object = mutex;
                synchronized (object) {
                    biConsumer.accept(a, t);
                }
            }
        };
    }

    @Beta
    public static <T, U> BiConsumer<T, U> sc(final Object mutex, final BiConsumer<T, U> biConsumer) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(biConsumer, "biConsumer");
        return new BiConsumer<T, U>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(T t, U u2) {
                Object object = mutex;
                synchronized (object) {
                    biConsumer.accept(t, u2);
                }
            }
        };
    }

    @Beta
    public static <T, R> Function<T, R> sf(final Object mutex, final Function<T, R> function) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(function, "function");
        return new Function<T, R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R apply(T t) {
                Object object = mutex;
                synchronized (object) {
                    return function.apply(t);
                }
            }
        };
    }

    @Beta
    public static <A, T, R> Function<T, R> sf(final Object mutex, final A a, final BiFunction<A, T, R> biFunction) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(biFunction, "biFunction");
        return new Function<T, R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R apply(T t) {
                Object object = mutex;
                synchronized (object) {
                    return biFunction.apply(a, t);
                }
            }
        };
    }

    @Beta
    public static <T, U, R> BiFunction<T, U, R> sf(final Object mutex, final BiFunction<T, U, R> biFunction) {
        N.checkArgNotNull(mutex, "mutex");
        N.checkArgNotNull(biFunction, "biFunction");
        return new BiFunction<T, U, R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R apply(T t, U u2) {
                Object object = mutex;
                synchronized (object) {
                    return biFunction.apply(t, u2);
                }
            }
        };
    }

    public static <R> Callable<R> callable(Callable<R> callable) {
        N.checkArgNotNull(callable);
        return callable;
    }

    public static Runnable runnable(Runnable runnable) {
        N.checkArgNotNull(runnable);
        return runnable;
    }

    public static Callable<Void> toCallable(final Runnable runnable) {
        N.checkArgNotNull(runnable);
        return new Callable<Void>(){

            @Override
            public Void call() {
                runnable.run();
                return null;
            }
        };
    }

    public static <R> Runnable toRunnable(final Callable<R> callable) {
        N.checkArgNotNull(callable);
        return new Runnable(){

            @Override
            public void run() {
                callable.call();
            }
        };
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return BinaryOperators.THROWING_MERGER;
    }

    public static <T> BinaryOperator<T> ignoringMerger() {
        return BinaryOperators.IGNORING_MERGER;
    }

    public static <T> BinaryOperator<T> replacingMerger() {
        return BinaryOperators.REPLACING_MERGER;
    }

    @Deprecated
    static <T, C extends Collection<T>> BiConsumer<C, C> addAll() {
        return BiConsumers.ofAddAll();
    }

    @Deprecated
    static <K, V, M extends Map<K, V>> BiConsumer<M, M> putAll() {
        return BiConsumers.ofPutAll();
    }

    public static abstract class Fnn {
        protected Fnn() {
        }

        public static <T, E extends Exception> Try.Function<T, T, E> identity() {
            return IDENTITY;
        }

        public static <E extends Exception> Try.Runnable<E> emptyAction() {
            return EMPTY_ACTION;
        }

        public static <T, E extends Exception> Try.Consumer<T, E> doNothing() {
            return DO_NOTHING;
        }

        public static <T, E extends Exception> Try.Consumer<T, E> sleep(final long millis) {
            return new Try.Consumer<T, E>(){

                @Override
                public void accept(T t) {
                    N.sleep(millis);
                }
            };
        }

        public static <T, E extends Exception> Try.Consumer<T, E> sleepUninterruptibly(final long millis) {
            return new Try.Consumer<T, E>(){

                @Override
                public void accept(T t) throws Exception {
                    N.sleepUninterruptibly(millis);
                }
            };
        }

        public static <T extends AutoCloseable, E extends Exception> Try.Consumer<T, E> closeQuietly() {
            return CLOSE_QUIETLY;
        }

        public static <T, E extends Exception> Try.Consumer<T, E> println() {
            return PRINTLN;
        }

        public static <T, U, E extends Exception> Try.BiConsumer<T, U, E> println(String separator) {
            return Fnn.cc(Fn.println(separator));
        }

        @Beta
        public static <T, E extends Exception> Try.Predicate<T, E> p(Try.Predicate<T, E> predicate) {
            return predicate;
        }

        @Beta
        public static <A, T, E extends Exception> Try.Predicate<T, E> p(final A a, final Try.BiPredicate<A, T, E> biPredicate) {
            N.checkArgNotNull(biPredicate);
            return new Try.Predicate<T, E>(){

                @Override
                public boolean test(T t) throws Exception {
                    return biPredicate.test(a, t);
                }
            };
        }

        @Beta
        public static <A, B, T, E extends Exception> Try.Predicate<T, E> p(final A a, final B b, final Try.TriPredicate<A, B, T, E> triPredicate) {
            N.checkArgNotNull(triPredicate);
            return new Try.Predicate<T, E>(){

                @Override
                public boolean test(T t) throws Exception {
                    return triPredicate.test(a, b, t);
                }
            };
        }

        @Beta
        public static <T, U, E extends Exception> Try.BiPredicate<T, U, E> p(Try.BiPredicate<T, U, E> biPredicate) {
            return biPredicate;
        }

        @Beta
        public static <A, T, U, E extends Exception> Try.BiPredicate<T, U, E> p(final A a, final Try.TriPredicate<A, T, U, E> triPredicate) {
            N.checkArgNotNull(triPredicate);
            return new Try.BiPredicate<T, U, E>(){

                @Override
                public boolean test(T t, U u2) throws Exception {
                    return triPredicate.test(a, t, u2);
                }
            };
        }

        @Beta
        public static <A, B, C, E extends Exception> Try.TriPredicate<A, B, C, E> p(Try.TriPredicate<A, B, C, E> triPredicate) {
            return triPredicate;
        }

        @Beta
        public static <T, E extends Exception> Try.Consumer<T, E> c(Try.Consumer<T, E> predicate) {
            return predicate;
        }

        @Beta
        public static <A, T, E extends Exception> Try.Consumer<T, E> c(final A a, final Try.BiConsumer<A, T, E> biConsumer) {
            N.checkArgNotNull(biConsumer);
            return new Try.Consumer<T, E>(){

                @Override
                public void accept(T t) throws Exception {
                    biConsumer.accept(a, t);
                }
            };
        }

        @Beta
        public static <A, B, T, E extends Exception> Try.Consumer<T, E> c(final A a, final B b, final Try.TriConsumer<A, B, T, E> triConsumer) {
            N.checkArgNotNull(triConsumer);
            return new Try.Consumer<T, E>(){

                @Override
                public void accept(T t) throws Exception {
                    triConsumer.accept(a, b, t);
                }
            };
        }

        @Beta
        public static <T, U, E extends Exception> Try.BiConsumer<T, U, E> c(Try.BiConsumer<T, U, E> biConsumer) {
            return biConsumer;
        }

        @Beta
        public static <A, T, U, E extends Exception> Try.BiConsumer<T, U, E> c(final A a, final Try.TriConsumer<A, T, U, E> triConsumer) {
            N.checkArgNotNull(triConsumer);
            return new Try.BiConsumer<T, U, E>(){

                @Override
                public void accept(T t, U u2) throws Exception {
                    triConsumer.accept(a, t, u2);
                }
            };
        }

        @Beta
        public static <A, B, C, E extends Exception> Try.TriConsumer<A, B, C, E> c(Try.TriConsumer<A, B, C, E> triConsumer) {
            return triConsumer;
        }

        @Beta
        public static <T, R, E extends Exception> Try.Function<T, R, E> f(Try.Function<T, R, E> predicate) {
            return predicate;
        }

        @Beta
        public static <A, T, R, E extends Exception> Try.Function<T, R, E> f(final A a, final Try.BiFunction<A, T, R, E> biFunction) {
            N.checkArgNotNull(biFunction);
            return new Try.Function<T, R, E>(){

                @Override
                public R apply(T t) throws Exception {
                    return biFunction.apply(a, t);
                }
            };
        }

        @Beta
        public static <A, B, T, R, E extends Exception> Try.Function<T, R, E> f(final A a, final B b, final Try.TriFunction<A, B, T, R, E> triFunction) {
            N.checkArgNotNull(triFunction);
            return new Try.Function<T, R, E>(){

                @Override
                public R apply(T t) throws Exception {
                    return triFunction.apply(a, b, t);
                }
            };
        }

        @Beta
        public static <T, U, R, E extends Exception> Try.BiFunction<T, U, R, E> f(Try.BiFunction<T, U, R, E> biFunction) {
            return biFunction;
        }

        @Beta
        public static <A, T, U, R, E extends Exception> Try.BiFunction<T, U, R, E> f(final A a, final Try.TriFunction<A, T, U, R, E> triFunction) {
            N.checkArgNotNull(triFunction);
            return new Try.BiFunction<T, U, R, E>(){

                @Override
                public R apply(T t, U u2) throws Exception {
                    return triFunction.apply(a, t, u2);
                }
            };
        }

        @Beta
        public static <A, B, C, R, E extends Exception> Try.TriFunction<A, B, C, R, E> f(Try.TriFunction<A, B, C, R, E> triFunction) {
            return triFunction;
        }

        @Beta
        public static <T, E extends Exception> Try.Predicate<T, E> pp(Predicate<T> predicate) {
            N.checkArgNotNull(predicate);
            return predicate;
        }

        @Beta
        public static <A, T, E extends Exception> Try.Predicate<T, E> pp(final A a, final BiPredicate<A, T> biPredicate) {
            N.checkArgNotNull(biPredicate);
            return new Try.Predicate<T, E>(){

                @Override
                public boolean test(T t) {
                    return biPredicate.test(a, t);
                }
            };
        }

        @Beta
        public static <A, B, T, E extends Exception> Try.Predicate<T, E> pp(final A a, final B b, final TriPredicate<A, B, T> triPredicate) {
            N.checkArgNotNull(triPredicate);
            return new Try.Predicate<T, E>(){

                @Override
                public boolean test(T t) {
                    return triPredicate.test(a, b, t);
                }
            };
        }

        @Beta
        public static <T, U, E extends Exception> Try.BiPredicate<T, U, E> pp(BiPredicate<T, U> biPredicate) {
            N.checkArgNotNull(biPredicate);
            return biPredicate;
        }

        @Beta
        public static <A, T, U, E extends Exception> Try.BiPredicate<T, U, E> pp(final A a, final TriPredicate<A, T, U> triPredicate) {
            N.checkArgNotNull(triPredicate);
            return new Try.BiPredicate<T, U, E>(){

                @Override
                public boolean test(T t, U u2) {
                    return triPredicate.test(a, t, u2);
                }
            };
        }

        @Beta
        public static <A, B, C, E extends Exception> Try.TriPredicate<A, B, C, E> pp(TriPredicate<A, B, C> triPredicate) {
            N.checkArgNotNull(triPredicate);
            return triPredicate;
        }

        @Beta
        public static <T, E extends Exception> Try.Consumer<T, E> cc(Consumer<T> consumer) {
            N.checkArgNotNull(consumer);
            return consumer;
        }

        @Beta
        public static <A, T, E extends Exception> Try.Consumer<T, E> cc(final A a, final BiConsumer<A, T> biConsumer) {
            N.checkArgNotNull(biConsumer);
            return new Try.Consumer<T, E>(){

                @Override
                public void accept(T t) {
                    biConsumer.accept(a, t);
                }
            };
        }

        @Beta
        public static <A, B, T, E extends Exception> Try.Consumer<T, E> cc(final A a, final B b, final TriConsumer<A, B, T> triConsumer) {
            N.checkArgNotNull(triConsumer);
            return new Try.Consumer<T, E>(){

                @Override
                public void accept(T t) {
                    triConsumer.accept(a, b, t);
                }
            };
        }

        @Beta
        public static <T, U, E extends Exception> Try.BiConsumer<T, U, E> cc(BiConsumer<T, U> biConsumer) {
            N.checkArgNotNull(biConsumer);
            return biConsumer;
        }

        @Beta
        public static <A, T, U, E extends Exception> Try.BiConsumer<T, U, E> cc(final A a, final TriConsumer<A, T, U> triConsumer) {
            N.checkArgNotNull(triConsumer);
            return new Try.BiConsumer<T, U, E>(){

                @Override
                public void accept(T t, U u2) {
                    triConsumer.accept(a, t, u2);
                }
            };
        }

        @Beta
        public static <A, B, C, E extends Exception> Try.TriConsumer<A, B, C, E> cc(TriConsumer<A, B, C> triConsumer) {
            N.checkArgNotNull(triConsumer);
            return triConsumer;
        }

        @Beta
        public static <T, R, E extends Exception> Try.Function<T, R, E> ff(Function<T, R> function) {
            N.checkArgNotNull(function);
            return function;
        }

        @Beta
        public static <A, T, R, E extends Exception> Try.Function<T, R, E> ff(final A a, final BiFunction<A, T, R> biFunction) {
            N.checkArgNotNull(biFunction);
            return new Try.Function<T, R, E>(){

                @Override
                public R apply(T t) {
                    return biFunction.apply(a, t);
                }
            };
        }

        @Beta
        public static <A, B, T, R, E extends Exception> Try.Function<T, R, E> ff(final A a, final B b, final TriFunction<A, B, T, R> triFunction) {
            N.checkArgNotNull(triFunction);
            return new Try.Function<T, R, E>(){

                @Override
                public R apply(T t) {
                    return triFunction.apply(a, b, t);
                }
            };
        }

        @Beta
        public static <T, U, R, E extends Exception> Try.BiFunction<T, U, R, E> ff(BiFunction<T, U, R> biFunction) {
            N.checkArgNotNull(biFunction);
            return biFunction;
        }

        @Beta
        public static <A, T, U, R, E extends Exception> Try.BiFunction<T, U, R, E> ff(final A a, final TriFunction<A, T, U, R> triFunction) {
            N.checkArgNotNull(triFunction);
            return new Try.BiFunction<T, U, R, E>(){

                @Override
                public R apply(T t, U u2) {
                    return triFunction.apply(a, t, u2);
                }
            };
        }

        @Beta
        public static <A, B, C, R, E extends Exception> Try.TriFunction<A, B, C, R, E> ff(TriFunction<A, B, C, R> triFunction) {
            N.checkArgNotNull(triFunction);
            return triFunction;
        }

        @Beta
        public static <T, E extends Exception> Try.Predicate<T, E> sp(final Object mutex, final Try.Predicate<T, E> predicate) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(predicate, "predicate");
            return new Try.Predicate<T, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean test(T t) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        return predicate.test(t);
                    }
                }
            };
        }

        @Beta
        public static <A, T, E extends Exception> Try.Predicate<T, E> sp(final Object mutex, final A a, final Try.BiPredicate<A, T, E> biPredicate) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(biPredicate, "biPredicate");
            return new Try.Predicate<T, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean test(T t) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        return biPredicate.test(a, t);
                    }
                }
            };
        }

        @Beta
        public static <A, B, T, E extends Exception> Try.Predicate<T, E> sp(final Object mutex, final A a, final B b, final Try.TriPredicate<A, B, T, E> triPredicate) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(triPredicate, "triPredicate");
            return new Try.Predicate<T, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean test(T t) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        return triPredicate.test(a, b, t);
                    }
                }
            };
        }

        @Beta
        public static <T, U, E extends Exception> Try.BiPredicate<T, U, E> sp(final Object mutex, final Try.BiPredicate<T, U, E> biPredicate) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(biPredicate, "biPredicate");
            return new Try.BiPredicate<T, U, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean test(T t, U u2) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        return biPredicate.test(t, u2);
                    }
                }
            };
        }

        @Beta
        public static <T, E extends Exception> Try.Consumer<T, E> sc(final Object mutex, final Try.Consumer<T, E> consumer) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(consumer, "consumer");
            return new Try.Consumer<T, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(T t) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        consumer.accept(t);
                    }
                }
            };
        }

        @Beta
        public static <A, T, E extends Exception> Try.Consumer<T, E> sc(final Object mutex, final A a, final Try.BiConsumer<A, T, E> biConsumer) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(biConsumer, "biConsumer");
            return new Try.Consumer<T, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(T t) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        biConsumer.accept(a, t);
                    }
                }
            };
        }

        @Beta
        public static <T, U, E extends Exception> Try.BiConsumer<T, U, E> sc(final Object mutex, final Try.BiConsumer<T, U, E> biConsumer) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(biConsumer, "biConsumer");
            return new Try.BiConsumer<T, U, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(T t, U u2) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        biConsumer.accept(t, u2);
                    }
                }
            };
        }

        @Beta
        public static <T, R, E extends Exception> Try.Function<T, R, E> sf(final Object mutex, final Try.Function<T, R, E> function) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(function, "function");
            return new Try.Function<T, R, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public R apply(T t) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        return function.apply(t);
                    }
                }
            };
        }

        @Beta
        public static <A, T, R, E extends Exception> Try.Function<T, R, E> sf(final Object mutex, final A a, final Try.BiFunction<A, T, R, E> biFunction) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(biFunction, "biFunction");
            return new Try.Function<T, R, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public R apply(T t) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        return biFunction.apply(a, t);
                    }
                }
            };
        }

        @Beta
        public static <T, U, R, E extends Exception> Try.BiFunction<T, U, R, E> sf(final Object mutex, final Try.BiFunction<T, U, R, E> biFunction) {
            N.checkArgNotNull(mutex, "mutex");
            N.checkArgNotNull(biFunction, "biFunction");
            return new Try.BiFunction<T, U, R, E>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public R apply(T t, U u2) throws Exception {
                    Object object = mutex;
                    synchronized (object) {
                        return biFunction.apply(t, u2);
                    }
                }
            };
        }

        public static <T, E extends Exception> Try.BinaryOperator<T, E> throwingMerger() {
            return BinaryOperators.THROWING_MERGER;
        }

        public static <T, E extends Exception> Try.BinaryOperator<T, E> ignoringMerger() {
            return BinaryOperators.IGNORING_MERGER;
        }

        public static <T, E extends Exception> Try.BinaryOperator<T, E> replacingMerger() {
            return BinaryOperators.REPLACING_MERGER;
        }

        public static <R, E extends Exception> Try.Callable<R, E> callable(Try.Callable<R, E> callable) {
            N.checkArgNotNull(callable);
            return callable;
        }

        public static <E extends Exception> Try.Runnable<E> runnable(Try.Runnable<E> runnable) {
            N.checkArgNotNull(runnable);
            return runnable;
        }

        public static <E extends Exception> Try.Callable<Void, E> toCallable(final Try.Runnable<E> runnable) {
            N.checkArgNotNull(runnable);
            return new Try.Callable<Void, E>(){

                @Override
                public Void call() throws Exception {
                    runnable.run();
                    return null;
                }
            };
        }

        public static <R, E extends Exception> Try.Runnable<E> toRunnable(final Try.Callable<R, E> callable) {
            N.checkArgNotNull(callable);
            return new Try.Runnable<E>(){

                @Override
                public void run() throws Exception {
                    callable.call();
                }
            };
        }
    }

    public static abstract class FnD {
        private static final DoublePredicate POSITIVE = new DoublePredicate(){

            @Override
            public boolean test(double t) {
                return t > 0.0;
            }
        };
        private static final DoublePredicate NOT_NEGATIVE = new DoublePredicate(){

            @Override
            public boolean test(double t) {
                return t >= 0.0;
            }
        };
        private static final DoubleBiPredicate EQUAL = new DoubleBiPredicate(){

            @Override
            public boolean test(double t, double u2) {
                return N.equals(t, u2);
            }
        };
        private static final DoubleBiPredicate NOT_EQUAL = new DoubleBiPredicate(){

            @Override
            public boolean test(double t, double u2) {
                return N.compare(t, u2) != 0;
            }
        };
        private static final DoubleBiPredicate GREATER_THAN = new DoubleBiPredicate(){

            @Override
            public boolean test(double t, double u2) {
                return N.compare(t, u2) > 0;
            }
        };
        private static final DoubleBiPredicate GREATER_EQUAL = new DoubleBiPredicate(){

            @Override
            public boolean test(double t, double u2) {
                return N.compare(t, u2) >= 0;
            }
        };
        private static final DoubleBiPredicate LESS_THAN = new DoubleBiPredicate(){

            @Override
            public boolean test(double t, double u2) {
                return N.compare(t, u2) < 0;
            }
        };
        private static final DoubleBiPredicate LESS_EQUAL = new DoubleBiPredicate(){

            @Override
            public boolean test(double t, double u2) {
                return N.compare(t, u2) <= 0;
            }
        };

        protected FnD() {
        }

        public static DoublePredicate positve() {
            return POSITIVE;
        }

        public static DoublePredicate notNegative() {
            return NOT_NEGATIVE;
        }

        public static DoubleBiPredicate equal() {
            return EQUAL;
        }

        public static DoubleBiPredicate notEqual() {
            return NOT_EQUAL;
        }

        public static DoubleBiPredicate greaterThan() {
            return GREATER_THAN;
        }

        public static DoubleBiPredicate greaterEqual() {
            return GREATER_EQUAL;
        }

        public static DoubleBiPredicate lessThan() {
            return LESS_THAN;
        }

        public static DoubleBiPredicate lessEqual() {
            return LESS_EQUAL;
        }

        public static ToDoubleFunction<Double> unbox() {
            return ToDoubleFunction.UNBOX;
        }

        public static DoublePredicate p(DoublePredicate p) {
            N.checkArgNotNull(p);
            return p;
        }

        public static <R> DoubleFunction<R> f(DoubleFunction<R> f) {
            N.checkArgNotNull(f);
            return f;
        }

        public static DoubleConsumer c(DoubleConsumer c) {
            N.checkArgNotNull(c);
            return c;
        }
    }

    public static abstract class FnF {
        private static final FloatPredicate POSITIVE = new FloatPredicate(){

            @Override
            public boolean test(float t) {
                return t > 0.0f;
            }
        };
        private static final FloatPredicate NOT_NEGATIVE = new FloatPredicate(){

            @Override
            public boolean test(float t) {
                return t >= 0.0f;
            }
        };
        private static final FloatBiPredicate EQUAL = new FloatBiPredicate(){

            @Override
            public boolean test(float t, float u2) {
                return t == u2;
            }
        };
        private static final FloatBiPredicate NOT_EQUAL = new FloatBiPredicate(){

            @Override
            public boolean test(float t, float u2) {
                return t != u2;
            }
        };
        private static final FloatBiPredicate GREATER_THAN = new FloatBiPredicate(){

            @Override
            public boolean test(float t, float u2) {
                return t > u2;
            }
        };
        private static final FloatBiPredicate GREATER_EQUAL = new FloatBiPredicate(){

            @Override
            public boolean test(float t, float u2) {
                return t >= u2;
            }
        };
        private static final FloatBiPredicate LESS_THAN = new FloatBiPredicate(){

            @Override
            public boolean test(float t, float u2) {
                return t < u2;
            }
        };
        private static final FloatBiPredicate LESS_EQUAL = new FloatBiPredicate(){

            @Override
            public boolean test(float t, float u2) {
                return t <= u2;
            }
        };

        protected FnF() {
        }

        public static FloatPredicate positve() {
            return POSITIVE;
        }

        public static FloatPredicate notNegative() {
            return NOT_NEGATIVE;
        }

        public static FloatBiPredicate equal() {
            return EQUAL;
        }

        public static FloatBiPredicate notEqual() {
            return NOT_EQUAL;
        }

        public static FloatBiPredicate greaterThan() {
            return GREATER_THAN;
        }

        public static FloatBiPredicate greaterEqual() {
            return GREATER_EQUAL;
        }

        public static FloatBiPredicate lessThan() {
            return LESS_THAN;
        }

        public static FloatBiPredicate lessEqual() {
            return LESS_EQUAL;
        }

        public static FloatPredicate p(FloatPredicate p) {
            N.checkArgNotNull(p);
            return p;
        }

        public static <R> FloatFunction<R> f(FloatFunction<R> f) {
            N.checkArgNotNull(f);
            return f;
        }

        public static FloatConsumer c(FloatConsumer c) {
            N.checkArgNotNull(c);
            return c;
        }
    }

    public static abstract class FnL {
        private static final LongPredicate POSITIVE = new LongPredicate(){

            @Override
            public boolean test(long t) {
                return t > 0L;
            }
        };
        private static final LongPredicate NOT_NEGATIVE = new LongPredicate(){

            @Override
            public boolean test(long t) {
                return t >= 0L;
            }
        };
        private static final LongBiPredicate EQUAL = new LongBiPredicate(){

            @Override
            public boolean test(long t, long u2) {
                return t == u2;
            }
        };
        private static final LongBiPredicate NOT_EQUAL = new LongBiPredicate(){

            @Override
            public boolean test(long t, long u2) {
                return t != u2;
            }
        };
        private static final LongBiPredicate GREATER_THAN = new LongBiPredicate(){

            @Override
            public boolean test(long t, long u2) {
                return t > u2;
            }
        };
        private static final LongBiPredicate GREATER_EQUAL = new LongBiPredicate(){

            @Override
            public boolean test(long t, long u2) {
                return t >= u2;
            }
        };
        private static final LongBiPredicate LESS_THAN = new LongBiPredicate(){

            @Override
            public boolean test(long t, long u2) {
                return t < u2;
            }
        };
        private static final LongBiPredicate LESS_EQUAL = new LongBiPredicate(){

            @Override
            public boolean test(long t, long u2) {
                return t <= u2;
            }
        };

        protected FnL() {
        }

        public static LongPredicate positve() {
            return POSITIVE;
        }

        public static LongPredicate notNegative() {
            return NOT_NEGATIVE;
        }

        public static LongBiPredicate equal() {
            return EQUAL;
        }

        public static LongBiPredicate notEqual() {
            return NOT_EQUAL;
        }

        public static LongBiPredicate greaterThan() {
            return GREATER_THAN;
        }

        public static LongBiPredicate greaterEqual() {
            return GREATER_EQUAL;
        }

        public static LongBiPredicate lessThan() {
            return LESS_THAN;
        }

        public static LongBiPredicate lessEqual() {
            return LESS_EQUAL;
        }

        public static ToLongFunction<Long> unbox() {
            return ToLongFunction.UNBOX;
        }

        public static LongPredicate p(LongPredicate p) {
            N.checkArgNotNull(p);
            return p;
        }

        public static <R> LongFunction<R> f(LongFunction<R> f) {
            N.checkArgNotNull(f);
            return f;
        }

        public static LongConsumer c(LongConsumer c) {
            N.checkArgNotNull(c);
            return c;
        }
    }

    public static abstract class FnI {
        private static final IntPredicate POSITIVE = new IntPredicate(){

            @Override
            public boolean test(int t) {
                return t > 0;
            }
        };
        private static final IntPredicate NOT_NEGATIVE = new IntPredicate(){

            @Override
            public boolean test(int t) {
                return t >= 0;
            }
        };
        private static final IntBiPredicate EQUAL = new IntBiPredicate(){

            @Override
            public boolean test(int t, int u2) {
                return t == u2;
            }
        };
        private static final IntBiPredicate NOT_EQUAL = new IntBiPredicate(){

            @Override
            public boolean test(int t, int u2) {
                return t != u2;
            }
        };
        private static final IntBiPredicate GREATER_THAN = new IntBiPredicate(){

            @Override
            public boolean test(int t, int u2) {
                return t > u2;
            }
        };
        private static final IntBiPredicate GREATER_EQUAL = new IntBiPredicate(){

            @Override
            public boolean test(int t, int u2) {
                return t >= u2;
            }
        };
        private static final IntBiPredicate LESS_THAN = new IntBiPredicate(){

            @Override
            public boolean test(int t, int u2) {
                return t < u2;
            }
        };
        private static final IntBiPredicate LESS_EQUAL = new IntBiPredicate(){

            @Override
            public boolean test(int t, int u2) {
                return t <= u2;
            }
        };

        protected FnI() {
        }

        public static IntPredicate positve() {
            return POSITIVE;
        }

        public static IntPredicate notNegative() {
            return NOT_NEGATIVE;
        }

        public static IntBiPredicate equal() {
            return EQUAL;
        }

        public static IntBiPredicate notEqual() {
            return NOT_EQUAL;
        }

        public static IntBiPredicate greaterThan() {
            return GREATER_THAN;
        }

        public static IntBiPredicate greaterEqual() {
            return GREATER_EQUAL;
        }

        public static IntBiPredicate lessThan() {
            return LESS_THAN;
        }

        public static IntBiPredicate lessEqual() {
            return LESS_EQUAL;
        }

        public static ToIntFunction<Integer> unbox() {
            return ToIntFunction.UNBOX;
        }

        public static IntPredicate p(IntPredicate p) {
            N.checkArgNotNull(p);
            return p;
        }

        public static <R> IntFunction<R> f(IntFunction<R> f) {
            N.checkArgNotNull(f);
            return f;
        }

        public static IntConsumer c(IntConsumer c) {
            N.checkArgNotNull(c);
            return c;
        }
    }

    public static abstract class FnS {
        private static final ShortPredicate POSITIVE = new ShortPredicate(){

            @Override
            public boolean test(short t) {
                return t > 0;
            }
        };
        private static final ShortPredicate NOT_NEGATIVE = new ShortPredicate(){

            @Override
            public boolean test(short t) {
                return t >= 0;
            }
        };
        private static final ShortBiPredicate EQUAL = new ShortBiPredicate(){

            @Override
            public boolean test(short t, short u2) {
                return t == u2;
            }
        };
        private static final ShortBiPredicate NOT_EQUAL = new ShortBiPredicate(){

            @Override
            public boolean test(short t, short u2) {
                return t != u2;
            }
        };
        private static final ShortBiPredicate GREATER_THAN = new ShortBiPredicate(){

            @Override
            public boolean test(short t, short u2) {
                return t > u2;
            }
        };
        private static final ShortBiPredicate GREATER_EQUAL = new ShortBiPredicate(){

            @Override
            public boolean test(short t, short u2) {
                return t >= u2;
            }
        };
        private static final ShortBiPredicate LESS_THAN = new ShortBiPredicate(){

            @Override
            public boolean test(short t, short u2) {
                return t < u2;
            }
        };
        private static final ShortBiPredicate LESS_EQUAL = new ShortBiPredicate(){

            @Override
            public boolean test(short t, short u2) {
                return t <= u2;
            }
        };

        protected FnS() {
        }

        public static ShortPredicate positve() {
            return POSITIVE;
        }

        public static ShortPredicate notNegative() {
            return NOT_NEGATIVE;
        }

        public static ShortBiPredicate equal() {
            return EQUAL;
        }

        public static ShortBiPredicate notEqual() {
            return NOT_EQUAL;
        }

        public static ShortBiPredicate greaterThan() {
            return GREATER_THAN;
        }

        public static ShortBiPredicate greaterEqual() {
            return GREATER_EQUAL;
        }

        public static ShortBiPredicate lessThan() {
            return LESS_THAN;
        }

        public static ShortBiPredicate lessEqual() {
            return LESS_EQUAL;
        }

        public static ShortPredicate p(ShortPredicate p) {
            N.checkArgNotNull(p);
            return p;
        }

        public static <R> ShortFunction<R> f(ShortFunction<R> f) {
            N.checkArgNotNull(f);
            return f;
        }

        public static ShortConsumer c(ShortConsumer c) {
            N.checkArgNotNull(c);
            return c;
        }
    }

    public static abstract class FnB {
        private static final BytePredicate POSITIVE = new BytePredicate(){

            @Override
            public boolean test(byte t) {
                return t > 0;
            }
        };
        private static final BytePredicate NOT_NEGATIVE = new BytePredicate(){

            @Override
            public boolean test(byte t) {
                return t >= 0;
            }
        };
        private static final ByteBiPredicate EQUAL = new ByteBiPredicate(){

            @Override
            public boolean test(byte t, byte u2) {
                return t == u2;
            }
        };
        private static final ByteBiPredicate NOT_EQUAL = new ByteBiPredicate(){

            @Override
            public boolean test(byte t, byte u2) {
                return t != u2;
            }
        };
        private static final ByteBiPredicate GREATER_THAN = new ByteBiPredicate(){

            @Override
            public boolean test(byte t, byte u2) {
                return t > u2;
            }
        };
        private static final ByteBiPredicate GREATER_EQUAL = new ByteBiPredicate(){

            @Override
            public boolean test(byte t, byte u2) {
                return t >= u2;
            }
        };
        private static final ByteBiPredicate LESS_THAN = new ByteBiPredicate(){

            @Override
            public boolean test(byte t, byte u2) {
                return t < u2;
            }
        };
        private static final ByteBiPredicate LESS_EQUAL = new ByteBiPredicate(){

            @Override
            public boolean test(byte t, byte u2) {
                return t <= u2;
            }
        };

        protected FnB() {
        }

        public static BytePredicate positve() {
            return POSITIVE;
        }

        public static BytePredicate notNegative() {
            return NOT_NEGATIVE;
        }

        public static ByteBiPredicate equal() {
            return EQUAL;
        }

        public static ByteBiPredicate notEqual() {
            return NOT_EQUAL;
        }

        public static ByteBiPredicate greaterThan() {
            return GREATER_THAN;
        }

        public static ByteBiPredicate greaterEqual() {
            return GREATER_EQUAL;
        }

        public static ByteBiPredicate lessThan() {
            return LESS_THAN;
        }

        public static ByteBiPredicate lessEqual() {
            return LESS_EQUAL;
        }

        public static BytePredicate p(BytePredicate p) {
            N.checkArgNotNull(p);
            return p;
        }

        public static <R> ByteFunction<R> f(ByteFunction<R> f) {
            N.checkArgNotNull(f);
            return f;
        }

        public static ByteConsumer c(ByteConsumer c) {
            N.checkArgNotNull(c);
            return c;
        }
    }

    public static abstract class FnC {
        private static final CharPredicate POSITIVE = new CharPredicate(){

            @Override
            public boolean test(char t) {
                return t > '\u0000';
            }
        };
        private static final CharPredicate NOT_NEGATIVE = new CharPredicate(){

            @Override
            public boolean test(char t) {
                return t >= '\u0000';
            }
        };
        private static final CharBiPredicate EQUAL = new CharBiPredicate(){

            @Override
            public boolean test(char t, char u2) {
                return t == u2;
            }
        };
        private static final CharBiPredicate NOT_EQUAL = new CharBiPredicate(){

            @Override
            public boolean test(char t, char u2) {
                return t != u2;
            }
        };
        private static final CharBiPredicate GREATER_THAN = new CharBiPredicate(){

            @Override
            public boolean test(char t, char u2) {
                return t > u2;
            }
        };
        private static final CharBiPredicate GREATER_EQUAL = new CharBiPredicate(){

            @Override
            public boolean test(char t, char u2) {
                return t >= u2;
            }
        };
        private static final CharBiPredicate LESS_THAN = new CharBiPredicate(){

            @Override
            public boolean test(char t, char u2) {
                return t < u2;
            }
        };
        private static final CharBiPredicate LESS_EQUAL = new CharBiPredicate(){

            @Override
            public boolean test(char t, char u2) {
                return t <= u2;
            }
        };

        protected FnC() {
        }

        public static CharPredicate positve() {
            return POSITIVE;
        }

        public static CharPredicate notNegative() {
            return NOT_NEGATIVE;
        }

        public static CharBiPredicate equal() {
            return EQUAL;
        }

        public static CharBiPredicate notEqual() {
            return NOT_EQUAL;
        }

        public static CharBiPredicate greaterThan() {
            return GREATER_THAN;
        }

        public static CharBiPredicate greaterEqual() {
            return GREATER_EQUAL;
        }

        public static CharBiPredicate lessThan() {
            return LESS_THAN;
        }

        public static CharBiPredicate lessEqual() {
            return LESS_EQUAL;
        }

        public static CharPredicate p(CharPredicate p) {
            N.checkArgNotNull(p);
            return p;
        }

        public static <R> CharFunction<R> f(CharFunction<R> f) {
            N.checkArgNotNull(f);
            return f;
        }

        public static CharConsumer c(CharConsumer c) {
            N.checkArgNotNull(c);
            return c;
        }
    }

    public static final class Disposables {
        private static final Function<NoCachingNoUpdating.DisposableArray, Object[]> CLONE = new Function<NoCachingNoUpdating.DisposableArray, Object[]>(){

            @Override
            public Object[] apply(NoCachingNoUpdating.DisposableArray t) {
                return t.clone();
            }
        };
        private static final Function<NoCachingNoUpdating.DisposableArray, String> TO_STRING = new Function<NoCachingNoUpdating.DisposableArray, String>(){

            @Override
            public String apply(NoCachingNoUpdating.DisposableArray t) {
                return t.toString();
            }
        };

        private Disposables() {
        }

        public static <T, A extends NoCachingNoUpdating.DisposableArray<T>> Function<A, T[]> cloneArray() {
            return CLONE;
        }

        public static <A extends NoCachingNoUpdating.DisposableArray> Function<A, String> toStr() {
            return TO_STRING;
        }

        public static <A extends NoCachingNoUpdating.DisposableArray> Function<A, String> join(final String delimiter) {
            return new Function<A, String>(){

                @Override
                public String apply(A t) {
                    return ((NoCachingNoUpdating.DisposableArray)t).join(delimiter);
                }
            };
        }
    }

    public static abstract class Triples {
        private static final Function<Triple, List> TRIPLE_TO_LIST = new Function<Triple, List>(){

            @Override
            public List apply(Triple t) {
                return N.asList(t.left, t.middle, t.right);
            }
        };
        private static final Function<Triple, Set> TRIPLE_TO_SET = new Function<Triple, Set>(){

            @Override
            public Set apply(Triple t) {
                return N.asSet(t.left, t.middle, t.right);
            }
        };

        protected Triples() {
        }

        public static <T> Function<Triple<T, T, T>, List<T>> toList() {
            return TRIPLE_TO_LIST;
        }

        public static <T> Function<Triple<T, T, T>, Set<T>> toSet() {
            return TRIPLE_TO_SET;
        }
    }

    public static abstract class Pairs {
        private static final Function<Pair, List> PAIR_TO_LIST = new Function<Pair, List>(){

            @Override
            public List apply(Pair t) {
                return N.asList(t.left, t.right);
            }
        };
        private static final Function<Pair, Set> PAIR_TO_SET = new Function<Pair, Set>(){

            @Override
            public Set apply(Pair t) {
                return N.asSet(t.left, t.right);
            }
        };

        protected Pairs() {
        }

        public static <T> Function<Pair<T, T>, List<T>> toList() {
            return PAIR_TO_LIST;
        }

        public static <T> Function<Pair<T, T>, Set<T>> toSet() {
            return PAIR_TO_SET;
        }
    }

    public static abstract class Entries {
        protected Entries() {
        }

        public static <K, V, T> Function<Map.Entry<K, V>, T> f(final BiFunction<? super K, ? super V, ? extends T> f) {
            N.checkArgNotNull(f, "BiFunction");
            return new Function<Map.Entry<K, V>, T>(){

                @Override
                public T apply(Map.Entry<K, V> e) {
                    return f.apply(e.getKey(), e.getValue());
                }
            };
        }

        public static <K, V> Predicate<Map.Entry<K, V>> p(final BiPredicate<? super K, ? super V> p) {
            N.checkArgNotNull(p, "BiPredicate");
            return new Predicate<Map.Entry<K, V>>(){

                @Override
                public boolean test(Map.Entry<K, V> e) {
                    return p.test(e.getKey(), e.getValue());
                }
            };
        }

        public static <K, V> Consumer<Map.Entry<K, V>> c(final BiConsumer<? super K, ? super V> c) {
            N.checkArgNotNull(c, "BiConsumer");
            return new Consumer<Map.Entry<K, V>>(){

                @Override
                public void accept(Map.Entry<K, V> e) {
                    c.accept(e.getKey(), e.getValue());
                }
            };
        }

        @Beta
        public static <K, V, T, E extends Exception> Try.Function<Map.Entry<K, V>, T, E> ef(final Try.BiFunction<? super K, ? super V, ? extends T, E> f) {
            N.checkArgNotNull(f, "BiFunction");
            return new Try.Function<Map.Entry<K, V>, T, E>(){

                @Override
                public T apply(Map.Entry<K, V> e) throws Exception {
                    return f.apply(e.getKey(), e.getValue());
                }
            };
        }

        @Beta
        public static <K, V, E extends Exception> Try.Predicate<Map.Entry<K, V>, E> ep(final Try.BiPredicate<? super K, ? super V, E> p) {
            N.checkArgNotNull(p, "BiPredicate");
            return new Try.Predicate<Map.Entry<K, V>, E>(){

                @Override
                public boolean test(Map.Entry<K, V> e) throws Exception {
                    return p.test(e.getKey(), e.getValue());
                }
            };
        }

        @Beta
        public static <K, V, E extends Exception> Try.Consumer<Map.Entry<K, V>, E> ec(final Try.BiConsumer<? super K, ? super V, E> c) {
            N.checkArgNotNull(c, "BiConsumer");
            return new Try.Consumer<Map.Entry<K, V>, E>(){

                @Override
                public void accept(Map.Entry<K, V> e) throws Exception {
                    c.accept(e.getKey(), e.getValue());
                }
            };
        }

        public static <K, V, T, E extends Exception> Function<Map.Entry<K, V>, T> ff(final Try.BiFunction<? super K, ? super V, ? extends T, E> f) {
            N.checkArgNotNull(f, "BiFunction");
            return new Function<Map.Entry<K, V>, T>(){

                @Override
                public T apply(Map.Entry<K, V> e) {
                    try {
                        return f.apply(e.getKey(), e.getValue());
                    }
                    catch (Exception ex) {
                        throw N.toRuntimeException(ex);
                    }
                }
            };
        }

        public static <K, V, E extends Exception> Predicate<Map.Entry<K, V>> pp(final Try.BiPredicate<? super K, ? super V, E> p) {
            N.checkArgNotNull(p, "BiPredicate");
            return new Predicate<Map.Entry<K, V>>(){

                @Override
                public boolean test(Map.Entry<K, V> e) {
                    try {
                        return p.test(e.getKey(), e.getValue());
                    }
                    catch (Exception ex) {
                        throw N.toRuntimeException(ex);
                    }
                }
            };
        }

        public static <K, V, E extends Exception> Consumer<Map.Entry<K, V>> cc(final Try.BiConsumer<? super K, ? super V, E> c) {
            N.checkArgNotNull(c, "BiConsumer");
            return new Consumer<Map.Entry<K, V>>(){

                @Override
                public void accept(Map.Entry<K, V> e) {
                    try {
                        c.accept(e.getKey(), e.getValue());
                    }
                    catch (Exception ex) {
                        throw N.toRuntimeException(ex);
                    }
                }
            };
        }
    }

    public static abstract class UnaryOperators {
        private static final UnaryOperator IDENTITY = new UnaryOperator(){

            @Override
            public Object apply(Object t) {
                return t;
            }
        };

        protected UnaryOperators() {
        }

        public static <T> UnaryOperator<T> identity() {
            return IDENTITY;
        }
    }

    public static abstract class BinaryOperators {
        private static final BinaryOperator THROWING_MERGER = new BinaryOperator(){

            @Override
            public Object apply(Object t, Object u2) {
                throw new IllegalStateException(String.format("Duplicate key (attempted merging values %s and %s)", t, u2));
            }
        };
        private static final BinaryOperator IGNORING_MERGER = new BinaryOperator(){

            @Override
            public Object apply(Object t, Object u2) {
                return t;
            }
        };
        private static final BinaryOperator REPLACING_MERGER = new BinaryOperator(){

            @Override
            public Object apply(Object t, Object u2) {
                return u2;
            }
        };
        private static final BinaryOperator<Collection<Object>> ADD_ALL_TO_FIRST = new BinaryOperator<Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<Object> t, Collection<Object> u2) {
                t.addAll(u2);
                return t;
            }
        };
        private static final BinaryOperator<Collection<Object>> ADD_ALL_TO_BIGGER = new BinaryOperator<Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<Object> t, Collection<Object> u2) {
                if (t.size() >= u2.size()) {
                    t.addAll(u2);
                    return t;
                }
                u2.addAll(t);
                return u2;
            }
        };
        private static final BinaryOperator<Collection<Object>> REMOVE_ALL_FROM_FIRST = new BinaryOperator<Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<Object> t, Collection<Object> u2) {
                t.removeAll(u2);
                return t;
            }
        };
        private static final BinaryOperator<Map<Object, Object>> PUT_ALL_TO_FIRST = new BinaryOperator<Map<Object, Object>>(){

            @Override
            public Map<Object, Object> apply(Map<Object, Object> t, Map<Object, Object> u2) {
                t.putAll(u2);
                return t;
            }
        };
        private static final BinaryOperator<Map<Object, Object>> PUT_ALL_TO_BIGGER = new BinaryOperator<Map<Object, Object>>(){

            @Override
            public Map<Object, Object> apply(Map<Object, Object> t, Map<Object, Object> u2) {
                if (t.size() >= u2.size()) {
                    t.putAll(u2);
                    return t;
                }
                u2.putAll(t);
                return u2;
            }
        };
        private static final BinaryOperator<Joiner> MERGE_TO_FIRST = new BinaryOperator<Joiner>(){

            @Override
            public Joiner apply(Joiner t, Joiner u2) {
                return t.merge(u2);
            }
        };
        private static final BinaryOperator<Joiner> MERGE_TO_BIGGER = new BinaryOperator<Joiner>(){

            @Override
            public Joiner apply(Joiner t, Joiner u2) {
                if (t.length() >= u2.length()) {
                    return t.merge(u2);
                }
                return u2.merge(t);
            }
        };
        private static final BinaryOperator<StringBuilder> APPEND_TO_FIRST = new BinaryOperator<StringBuilder>(){

            @Override
            public StringBuilder apply(StringBuilder t, StringBuilder u2) {
                return t.append((CharSequence)u2);
            }
        };
        private static final BinaryOperator<StringBuilder> APPEND_TO_BIGGER = new BinaryOperator<StringBuilder>(){

            @Override
            public StringBuilder apply(StringBuilder t, StringBuilder u2) {
                if (t.length() >= u2.length()) {
                    return t.append((CharSequence)u2);
                }
                return u2.append((CharSequence)t);
            }
        };
        private static final BinaryOperator<String> CONCAT = new BinaryOperator<String>(){

            @Override
            public String apply(String t, String u2) {
                return t + u2;
            }
        };
        private static final BinaryOperator<Integer> ADD_INTEGER = new BinaryOperator<Integer>(){

            @Override
            public Integer apply(Integer t, Integer u2) {
                return t + u2;
            }
        };
        private static final BinaryOperator<Long> ADD_LONG = new BinaryOperator<Long>(){

            @Override
            public Long apply(Long t, Long u2) {
                return t + u2;
            }
        };
        private static final BinaryOperator<Double> ADD_DOUBLE = new BinaryOperator<Double>(){

            @Override
            public Double apply(Double t, Double u2) {
                return t + u2;
            }
        };
        private static final BinaryOperator<BigInteger> ADD_BIG_INTEGER = new BinaryOperator<BigInteger>(){

            @Override
            public BigInteger apply(BigInteger t, BigInteger u2) {
                return t.add(u2);
            }
        };
        private static final BinaryOperator<BigDecimal> ADD_BIG_DECIMAL = new BinaryOperator<BigDecimal>(){

            @Override
            public BigDecimal apply(BigDecimal t, BigDecimal u2) {
                return t.add(u2);
            }
        };
        private static final BinaryOperator<Comparable> MIN = new BinaryOperator<Comparable>(){

            @Override
            public Comparable apply(Comparable t, Comparable u2) {
                return N.compare(t, u2) <= 0 ? t : u2;
            }
        };
        private static final BinaryOperator<Comparable> MAX = new BinaryOperator<Comparable>(){

            @Override
            public Comparable apply(Comparable t, Comparable u2) {
                return N.compare(t, u2) >= 0 ? t : u2;
            }
        };

        protected BinaryOperators() {
        }

        @Deprecated
        public static <T, C extends Collection<T>> BinaryOperator<C> ofAddAll() {
            return ADD_ALL_TO_FIRST;
        }

        public static <T, C extends Collection<T>> BinaryOperator<C> ofAddAllToFirst() {
            return ADD_ALL_TO_FIRST;
        }

        public static <T, C extends Collection<T>> BinaryOperator<C> ofAddAllToBigger() {
            return ADD_ALL_TO_BIGGER;
        }

        @Deprecated
        public static <T, C extends Collection<T>> BinaryOperator<C> ofRemoveAll() {
            return REMOVE_ALL_FROM_FIRST;
        }

        public static <T, C extends Collection<T>> BinaryOperator<C> ofRemoveAllFromFirst() {
            return REMOVE_ALL_FROM_FIRST;
        }

        @Deprecated
        public static <K, V, M extends Map<K, V>> BinaryOperator<M> ofPutAll() {
            return PUT_ALL_TO_FIRST;
        }

        public static <K, V, M extends Map<K, V>> BinaryOperator<M> ofPutAllToFirst() {
            return PUT_ALL_TO_FIRST;
        }

        public static <K, V, M extends Map<K, V>> BinaryOperator<M> ofPutAllToBigger() {
            return PUT_ALL_TO_BIGGER;
        }

        @Deprecated
        public static BinaryOperator<Joiner> ofMerge() {
            return MERGE_TO_FIRST;
        }

        public static BinaryOperator<Joiner> ofMergeToFirst() {
            return MERGE_TO_FIRST;
        }

        public static BinaryOperator<Joiner> ofMergeToBigger() {
            return MERGE_TO_BIGGER;
        }

        @Deprecated
        public static BinaryOperator<StringBuilder> ofAppend() {
            return APPEND_TO_FIRST;
        }

        public static BinaryOperator<StringBuilder> ofAppendToFirst() {
            return APPEND_TO_FIRST;
        }

        public static BinaryOperator<StringBuilder> ofAppendToBigger() {
            return APPEND_TO_BIGGER;
        }

        public static BinaryOperator<String> ofConcat() {
            return CONCAT;
        }

        public static BinaryOperator<Integer> ofAddInt() {
            return ADD_INTEGER;
        }

        public static BinaryOperator<Long> ofAddLong() {
            return ADD_LONG;
        }

        public static BinaryOperator<Double> ofAddDouble() {
            return ADD_DOUBLE;
        }

        public static BinaryOperator<BigInteger> ofAddBigInteger() {
            return ADD_BIG_INTEGER;
        }

        public static BinaryOperator<BigDecimal> ofAddBigDecimal() {
            return ADD_BIG_DECIMAL;
        }

        public static <T extends Comparable<? super T>> BinaryOperator<T> min() {
            return MIN;
        }

        public static <T> BinaryOperator<T> min(final Comparator<? super T> comparator) {
            N.checkArgNotNull(comparator);
            return new BinaryOperator<T>(){

                @Override
                public T apply(T t, T u2) {
                    return comparator.compare(t, u2) <= 0 ? t : u2;
                }
            };
        }

        public static <T> BinaryOperator<T> minBy(final Function<? super T, ? extends Comparable> keyMapper) {
            N.checkArgNotNull(keyMapper);
            return new BinaryOperator<T>(){

                @Override
                public T apply(T t, T u2) {
                    return N.compare((Comparable)keyMapper.apply(t), (Comparable)keyMapper.apply(u2)) <= 0 ? t : u2;
                }
            };
        }

        public static <T extends Comparable<? super T>> BinaryOperator<T> max() {
            return MAX;
        }

        public static <T> BinaryOperator<T> max(final Comparator<? super T> comparator) {
            N.checkArgNotNull(comparator);
            return new BinaryOperator<T>(){

                @Override
                public T apply(T t, T u2) {
                    return comparator.compare(t, u2) >= 0 ? t : u2;
                }
            };
        }

        public static <T> BinaryOperator<T> maxBy(final Function<? super T, ? extends Comparable> keyMapper) {
            N.checkArgNotNull(keyMapper);
            return new BinaryOperator<T>(){

                @Override
                public T apply(T t, T u2) {
                    return N.compare((Comparable)keyMapper.apply(t), (Comparable)keyMapper.apply(u2)) >= 0 ? t : u2;
                }
            };
        }
    }

    public static abstract class TriFunctions {
        protected TriFunctions() {
        }

        public static <A, B, C> TriFunction<A, B, C, Void> convert(final TriConsumer<? super A, ? super B, ? super C> action) {
            N.checkArgNotNull(action);
            return new TriFunction<A, B, C, Void>(){

                @Override
                public Void apply(A a, B b, C c) {
                    action.accept(a, b, c);
                    return null;
                }
            };
        }
    }

    public static abstract class BiFunctions {
        private static final BiFunction<Object, Object, Object> RETURN_FIRST = new BiFunction<Object, Object, Object>(){

            @Override
            public Object apply(Object t, Object u2) {
                return t;
            }
        };
        private static final BiFunction<Object, Object, Object> RETURN_SECOND = new BiFunction<Object, Object, Object>(){

            @Override
            public Object apply(Object t, Object u2) {
                return u2;
            }
        };
        private static final BiFunction<Collection<Object>, Object, Collection<Object>> ADD = new BiFunction<Collection<Object>, Object, Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<Object> t, Object u2) {
                t.add(u2);
                return t;
            }
        };
        private static final BiFunction<Collection<Object>, Collection<Object>, Collection<Object>> ADD_ALL = new BiFunction<Collection<Object>, Collection<Object>, Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<Object> t, Collection<Object> u2) {
                t.addAll(u2);
                return t;
            }
        };
        private static final BiFunction<Collection<Object>, Object, Collection<Object>> REMOVE = new BiFunction<Collection<Object>, Object, Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<Object> t, Object u2) {
                t.remove(u2);
                return t;
            }
        };
        private static final BiFunction<Collection<Object>, Collection<Object>, Collection<Object>> REMOVE_ALL = new BiFunction<Collection<Object>, Collection<Object>, Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<Object> t, Collection<Object> u2) {
                t.removeAll(u2);
                return t;
            }
        };
        private static final BiFunction<Map<Object, Object>, Map.Entry<Object, Object>, Map<Object, Object>> PUT = new BiFunction<Map<Object, Object>, Map.Entry<Object, Object>, Map<Object, Object>>(){

            @Override
            public Map<Object, Object> apply(Map<Object, Object> t, Map.Entry<Object, Object> u2) {
                t.put(u2.getKey(), u2.getValue());
                return t;
            }
        };
        private static final BiFunction<Map<Object, Object>, Map<Object, Object>, Map<Object, Object>> PUT_ALL = new BiFunction<Map<Object, Object>, Map<Object, Object>, Map<Object, Object>>(){

            @Override
            public Map<Object, Object> apply(Map<Object, Object> t, Map<Object, Object> u2) {
                t.putAll(u2);
                return t;
            }
        };
        private static final BiFunction<Map<Object, Object>, Object, Map<Object, Object>> REMOVE_BY_KEY = new BiFunction<Map<Object, Object>, Object, Map<Object, Object>>(){

            @Override
            public Map<Object, Object> apply(Map<Object, Object> t, Object u2) {
                t.remove(u2);
                return t;
            }
        };
        private static final BiFunction<Joiner, Joiner, Joiner> MERGE = new BiFunction<Joiner, Joiner, Joiner>(){

            @Override
            public Joiner apply(Joiner t, Joiner u2) {
                return t.merge(u2);
            }
        };
        private static final BiFunction<StringBuilder, Object, StringBuilder> APPEND = new BiFunction<StringBuilder, Object, StringBuilder>(){

            @Override
            public StringBuilder apply(StringBuilder t, Object u2) {
                return t.append(u2);
            }
        };

        protected BiFunctions() {
        }

        public static <T, U> BiFunction<T, U, T> returnFirst() {
            return RETURN_FIRST;
        }

        public static <T, U> BiFunction<T, U, U> returnSecond() {
            return RETURN_SECOND;
        }

        public static <T, C extends Collection<? super T>> BiFunction<C, T, C> ofAdd() {
            return ADD;
        }

        public static <T, C extends Collection<T>> BiFunction<C, C, C> ofAddAll() {
            return ADD_ALL;
        }

        public static <T, C extends Collection<? super T>> BiFunction<C, T, C> ofRemove() {
            return REMOVE;
        }

        public static <T, C extends Collection<T>> BiFunction<C, C, C> ofRemoveAll() {
            return REMOVE_ALL;
        }

        public static <K, V, M extends Map<K, V>, E extends Map.Entry<K, V>> BiFunction<M, E, M> ofPut() {
            return PUT;
        }

        public static <K, V, M extends Map<K, V>> BiFunction<M, M, M> ofPutAll() {
            return PUT_ALL;
        }

        public static <K, V, M extends Map<K, V>, U> BiFunction<M, K, M> ofRemoveByKey() {
            return REMOVE_BY_KEY;
        }

        public static BiFunction<Joiner, Joiner, Joiner> ofMerge() {
            return MERGE;
        }

        public static <T> BiFunction<StringBuilder, T, StringBuilder> ofAppend() {
            return APPEND;
        }

        public static <T, U> BiFunction<T, U, Void> convert(final BiConsumer<? super T, ? super U> action) {
            N.checkArgNotNull(action);
            return new BiFunction<T, U, Void>(){

                @Override
                public Void apply(T t, U u2) {
                    action.accept(t, u2);
                    return null;
                }
            };
        }

        @Beta
        @SequentialOnly
        public static <U, T, R> BiFunction<U, T, R> indexed(final IndexedBiFunction<U, T, R> func) {
            N.checkArgNotNull(func);
            return new BiFunction<U, T, R>(){
                private final MutableInt idx = new MutableInt(0);

                @Override
                public R apply(U u2, T t) {
                    return func.apply(u2, this.idx.getAndIncrement(), t);
                }
            };
        }
    }

    public static abstract class Functions {
        protected Functions() {
        }

        public static <T> Function<T, Void> convert(final Consumer<? super T> action) {
            N.checkArgNotNull(action);
            return new Function<T, Void>(){

                @Override
                public Void apply(T t) {
                    action.accept(t);
                    return null;
                }
            };
        }

        @Beta
        @SequentialOnly
        public static <T, R> Function<T, R> indexed(final IndexedFunction<T, R> func) {
            N.checkArgNotNull(func);
            return new Function<T, R>(){
                private final MutableInt idx = new MutableInt(0);

                @Override
                public R apply(T t) {
                    return func.apply(this.idx.getAndIncrement(), t);
                }
            };
        }
    }

    public static abstract class TriConsumers {
        protected TriConsumers() {
        }

        public static <A, B, C> TriConsumer<A, B, C> convert(final TriFunction<? super A, ? super B, ? super C, ?> func) {
            N.checkArgNotNull(func);
            return new TriConsumer<A, B, C>(){

                @Override
                public void accept(A a, B b, C c) {
                    func.apply(a, b, c);
                }
            };
        }
    }

    public static abstract class BiConsumers {
        private static final BiConsumer DO_NOTHING = new BiConsumer(){

            @Override
            public void accept(Object t, Object u2) {
            }
        };
        private static final BiConsumer<Collection<Object>, Object> ADD = new BiConsumer<Collection<Object>, Object>(){

            @Override
            public void accept(Collection<Object> t, Object u2) {
                t.add(u2);
            }
        };
        private static final BiConsumer<Collection<Object>, Collection<Object>> ADD_ALL = new BiConsumer<Collection<Object>, Collection<Object>>(){

            @Override
            public void accept(Collection<Object> t, Collection<Object> u2) {
                t.addAll(u2);
            }
        };
        private static final BiConsumer<Collection<Object>, Object> REMOVE = new BiConsumer<Collection<Object>, Object>(){

            @Override
            public void accept(Collection<Object> t, Object u2) {
                t.remove(u2);
            }
        };
        private static final BiConsumer<Collection<Object>, Collection<Object>> REMOVE_ALL = new BiConsumer<Collection<Object>, Collection<Object>>(){

            @Override
            public void accept(Collection<Object> t, Collection<Object> u2) {
                t.removeAll(u2);
            }
        };
        private static final BiConsumer<Map<Object, Object>, Map.Entry<Object, Object>> PUT = new BiConsumer<Map<Object, Object>, Map.Entry<Object, Object>>(){

            @Override
            public void accept(Map<Object, Object> t, Map.Entry<Object, Object> u2) {
                t.put(u2.getKey(), u2.getValue());
            }
        };
        private static final BiConsumer<Map<Object, Object>, Map<Object, Object>> PUT_ALL = new BiConsumer<Map<Object, Object>, Map<Object, Object>>(){

            @Override
            public void accept(Map<Object, Object> t, Map<Object, Object> u2) {
                t.putAll(u2);
            }
        };
        private static final BiConsumer<Map<Object, Object>, Object> REMOVE_BY_KEY = new BiConsumer<Map<Object, Object>, Object>(){

            @Override
            public void accept(Map<Object, Object> t, Object u2) {
                t.remove(u2);
            }
        };
        private static final BiConsumer<Joiner, Joiner> MERGE = new BiConsumer<Joiner, Joiner>(){

            @Override
            public void accept(Joiner t, Joiner u2) {
                t.merge(u2);
            }
        };
        private static final BiConsumer<StringBuilder, Object> APPEND = new BiConsumer<StringBuilder, Object>(){

            @Override
            public void accept(StringBuilder t, Object u2) {
                t.append(u2);
            }
        };

        protected BiConsumers() {
        }

        public static <T, U> BiConsumer<T, U> doNothing() {
            return DO_NOTHING;
        }

        public static <T, C extends Collection<? super T>> BiConsumer<C, T> ofAdd() {
            return ADD;
        }

        public static <T, C extends Collection<T>> BiConsumer<C, C> ofAddAll() {
            return ADD_ALL;
        }

        public static <T, C extends Collection<? super T>> BiConsumer<C, T> ofRemove() {
            return REMOVE;
        }

        public static <T, C extends Collection<T>> BiConsumer<C, C> ofRemoveAll() {
            return REMOVE_ALL;
        }

        public static <K, V, M extends Map<K, V>, E extends Map.Entry<K, V>> BiConsumer<M, E> ofPut() {
            return PUT;
        }

        public static <K, V, M extends Map<K, V>> BiConsumer<M, M> ofPutAll() {
            return PUT_ALL;
        }

        public static <K, V, M extends Map<K, V>> BiConsumer<M, K> ofRemoveByKey() {
            return REMOVE_BY_KEY;
        }

        public static BiConsumer<Joiner, Joiner> ofMerge() {
            return MERGE;
        }

        public static <T> BiConsumer<StringBuilder, T> ofAppend() {
            return APPEND;
        }

        public static <T, U> BiConsumer<T, U> convert(final BiFunction<? super T, ? super U, ?> func) {
            N.checkArgNotNull(func);
            return new BiConsumer<T, U>(){

                @Override
                public void accept(T t, U u2) {
                    func.apply(t, u2);
                }
            };
        }

        @Beta
        @SequentialOnly
        public static <U, T> BiConsumer<U, T> indexed(final IndexedBiConsumer<U, T> action) {
            N.checkArgNotNull(action);
            return new BiConsumer<U, T>(){
                private final MutableInt idx = new MutableInt(0);

                @Override
                public void accept(U u2, T t) {
                    action.accept(u2, this.idx.getAndIncrement(), t);
                }
            };
        }
    }

    public static abstract class Consumers {
        protected Consumers() {
        }

        public static <T> Consumer<T> convert(final Function<? super T, ?> func) {
            N.checkArgNotNull(func);
            return new Consumer<T>(){

                @Override
                public void accept(T t) {
                    func.apply(t);
                }
            };
        }

        @Beta
        @SequentialOnly
        public static <T> Consumer<T> indexed(final IndexedConsumer<T> action) {
            N.checkArgNotNull(action);
            return new Consumer<T>(){
                private final MutableInt idx = new MutableInt(0);

                @Override
                public void accept(T t) {
                    action.accept(this.idx.getAndIncrement(), t);
                }
            };
        }
    }

    public static abstract class TriPredicates {
        private static final TriPredicate ALWAYS_TRUE = new TriPredicate(){

            @Override
            public boolean test(Object a, Object b, Object c) {
                return true;
            }
        };
        private static final TriPredicate ALWAYS_FALSE = new TriPredicate(){

            @Override
            public boolean test(Object a, Object b, Object c) {
                return false;
            }
        };

        protected TriPredicates() {
        }

        public static <A, B, C> TriPredicate<A, B, C> alwaysTrue() {
            return ALWAYS_TRUE;
        }

        public static <A, B, C> TriPredicate<A, B, C> alwaysFalse() {
            return ALWAYS_FALSE;
        }
    }

    public static abstract class BiPredicates {
        private static final BiPredicate ALWAYS_TRUE = new BiPredicate(){

            @Override
            public boolean test(Object t, Object u2) {
                return true;
            }
        };
        private static final BiPredicate ALWAYS_FALSE = new BiPredicate(){

            @Override
            public boolean test(Object t, Object u2) {
                return false;
            }
        };
        private static final BiPredicate EQUAL = new BiPredicate(){

            @Override
            public boolean test(Object t, Object u2) {
                return N.equals(t, u2);
            }
        };
        private static final BiPredicate NOT_EQUAL = new BiPredicate(){

            @Override
            public boolean test(Object t, Object u2) {
                return !N.equals(t, u2);
            }
        };
        private static final BiPredicate<? extends Comparable, ? extends Comparable> GREATER_THAN = new BiPredicate<Comparable, Comparable>(){

            @Override
            public boolean test(Comparable t, Comparable u2) {
                return N.compare(t, u2) > 0;
            }
        };
        private static final BiPredicate<? extends Comparable, ? extends Comparable> GREATER_EQUAL = new BiPredicate<Comparable, Comparable>(){

            @Override
            public boolean test(Comparable t, Comparable u2) {
                return N.compare(t, u2) >= 0;
            }
        };
        private static final BiPredicate<? extends Comparable, ? extends Comparable> LESS_THAN = new BiPredicate<Comparable, Comparable>(){

            @Override
            public boolean test(Comparable t, Comparable u2) {
                return N.compare(t, u2) < 0;
            }
        };
        private static final BiPredicate<? extends Comparable, ? extends Comparable> LESS_EQUAL = new BiPredicate<Comparable, Comparable>(){

            @Override
            public boolean test(Comparable t, Comparable u2) {
                return N.compare(t, u2) <= 0;
            }
        };

        protected BiPredicates() {
        }

        public static <T, U> BiPredicate<T, U> alwaysTrue() {
            return ALWAYS_TRUE;
        }

        public static <T, U> BiPredicate<T, U> alwaysFalse() {
            return ALWAYS_FALSE;
        }

        @Beta
        @SequentialOnly
        public static <T, U> BiPredicate<T, U> indexed(final IndexedBiPredicate<T, U> predicate) {
            N.checkArgNotNull(predicate);
            return new BiPredicate<T, U>(){
                private final MutableInt idx = new MutableInt(0);

                @Override
                public boolean test(T t, U u2) {
                    return predicate.test(t, this.idx.getAndIncrement(), u2);
                }
            };
        }
    }

    public static abstract class Predicates {
        protected Predicates() {
        }

        @Beta
        @SequentialOnly
        public static <T> Predicate<T> indexed(final IndexedPredicate<T> predicate) {
            N.checkArgNotNull(predicate);
            return new Predicate<T>(){
                private final MutableInt idx = new MutableInt(0);

                @Override
                public boolean test(T t) {
                    return predicate.test(this.idx.getAndIncrement(), t);
                }
            };
        }

        @Beta
        @SequentialOnly
        public static <T> Predicate<T> distinct() {
            return new Predicate<T>(){
                private final Set<Object> set = N.newHashSet();

                @Override
                public boolean test(T value) {
                    return this.set.add(value);
                }
            };
        }

        @Beta
        @SequentialOnly
        public static <T> Predicate<T> distinctBy(final Function<? super T, ?> mapper) {
            return new Predicate<T>(){
                private final Set<Object> set = N.newHashSet();

                @Override
                public boolean test(T value) {
                    return this.set.add(mapper.apply(value));
                }
            };
        }

        @Beta
        public static <T> Predicate<T> concurrentDistinct() {
            return new Predicate<T>(){
                private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();

                @Override
                public boolean test(T value) {
                    return this.map.put(value, NONE) == null;
                }
            };
        }

        @Beta
        public static <T> Predicate<T> concurrentDistinctBy(final Function<? super T, ?> mapper) {
            return new Predicate<T>(){
                private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();

                @Override
                public boolean test(T value) {
                    return this.map.put(mapper.apply(value), NONE) == null;
                }
            };
        }

        @Beta
        @SequentialOnly
        public static <T> Predicate<T> skipRepeats() {
            return new Predicate<T>(){
                private T pre = Fn.access$400();

                @Override
                public boolean test(T value) {
                    boolean res = this.pre == NONE || !N.equals(value, this.pre);
                    this.pre = value;
                    return res;
                }
            };
        }
    }

    public static abstract class Suppliers {
        private static final Supplier<String> UUID = new Supplier<String>(){

            @Override
            public String get() {
                return N.uuid();
            }
        };
        private static final Supplier<String> GUID = new Supplier<String>(){

            @Override
            public String get() {
                return N.guid();
            }
        };
        private static final Supplier<boolean[]> EMPTY_BOOLEAN_ARRAY = new Supplier<boolean[]>(){

            @Override
            public boolean[] get() {
                return N.EMPTY_BOOLEAN_ARRAY;
            }
        };
        private static final Supplier<char[]> EMPTY_CHAR_ARRAY = new Supplier<char[]>(){

            @Override
            public char[] get() {
                return N.EMPTY_CHAR_ARRAY;
            }
        };
        private static final Supplier<byte[]> EMPTY_BYTE_ARRAY = new Supplier<byte[]>(){

            @Override
            public byte[] get() {
                return N.EMPTY_BYTE_ARRAY;
            }
        };
        private static final Supplier<short[]> EMPTY_SHORT_ARRAY = new Supplier<short[]>(){

            @Override
            public short[] get() {
                return N.EMPTY_SHORT_ARRAY;
            }
        };
        private static final Supplier<int[]> EMPTY_INT_ARRAY = new Supplier<int[]>(){

            @Override
            public int[] get() {
                return N.EMPTY_INT_ARRAY;
            }
        };
        private static final Supplier<long[]> EMPTY_LONG_ARRAY = new Supplier<long[]>(){

            @Override
            public long[] get() {
                return N.EMPTY_LONG_ARRAY;
            }
        };
        private static final Supplier<float[]> EMPTY_FLOAT_ARRAY = new Supplier<float[]>(){

            @Override
            public float[] get() {
                return N.EMPTY_FLOAT_ARRAY;
            }
        };
        private static final Supplier<double[]> EMPTY_DOUBLE_ARRAY = new Supplier<double[]>(){

            @Override
            public double[] get() {
                return N.EMPTY_DOUBLE_ARRAY;
            }
        };
        private static final Supplier<String[]> EMPTY_STRING_ARRAY = new Supplier<String[]>(){

            @Override
            public String[] get() {
                return N.EMPTY_STRING_ARRAY;
            }
        };
        private static final Supplier<Object[]> EMPTY_OBJECT_ARRAY = new Supplier<Object[]>(){

            @Override
            public Object[] get() {
                return N.EMPTY_OBJECT_ARRAY;
            }
        };
        private static final Supplier<? super List> LIST = new Supplier<List>(){

            @Override
            public List get() {
                return new ArrayList();
            }
        };
        private static final Supplier<? super LinkedList> LINKED_LIST = new Supplier<LinkedList>(){

            @Override
            public LinkedList get() {
                return new LinkedList();
            }
        };
        private static final Supplier<? super Set> SET = new Supplier<Set>(){

            @Override
            public Set get() {
                return N.newHashSet();
            }
        };
        private static final Supplier<? super Set> LINKED_HASH_SET = new Supplier<Set>(){

            @Override
            public Set get() {
                return N.newLinkedHashSet();
            }
        };
        private static final Supplier<? super TreeSet> TREE_SET = new Supplier<TreeSet>(){

            @Override
            public TreeSet get() {
                return new TreeSet();
            }
        };
        private static final Supplier<? super Queue> QUEUE = new Supplier<Queue>(){

            @Override
            public Queue get() {
                return new LinkedList();
            }
        };
        private static final Supplier<? super Deque> DEQUE = new Supplier<Deque>(){

            @Override
            public Deque get() {
                return new LinkedList();
            }
        };
        private static final Supplier<? super ArrayDeque> ARRAY_DEQUE = new Supplier<ArrayDeque>(){

            @Override
            public ArrayDeque get() {
                return new ArrayDeque();
            }
        };
        private static final Supplier<? super LinkedBlockingQueue> LINKED_BLOCKING_QUEUE = new Supplier<LinkedBlockingQueue>(){

            @Override
            public LinkedBlockingQueue get() {
                return new LinkedBlockingQueue();
            }
        };
        private static final Supplier<? super ConcurrentLinkedQueue> CONCURRENT_LINKED_QUEUE = new Supplier<ConcurrentLinkedQueue>(){

            @Override
            public ConcurrentLinkedQueue get() {
                return new ConcurrentLinkedQueue();
            }
        };
        private static final Supplier<? super PriorityQueue> PRIORITY_QUEUE = new Supplier<PriorityQueue>(){

            @Override
            public PriorityQueue get() {
                return new PriorityQueue();
            }
        };
        private static final Supplier<? super Map> MAP = new Supplier<Map>(){

            @Override
            public Map get() {
                return N.newHashMap();
            }
        };
        private static final Supplier<? super Map> LINKED_HASH_MAP = new Supplier<Map>(){

            @Override
            public Map get() {
                return N.newLinkedHashMap();
            }
        };
        private static final Supplier<? super IdentityHashMap> IDENTITY_HASH_MAP = new Supplier<IdentityHashMap>(){

            @Override
            public IdentityHashMap get() {
                return new IdentityHashMap();
            }
        };
        private static final Supplier<? super TreeMap> TREE_MAP = new Supplier<TreeMap>(){

            @Override
            public TreeMap get() {
                return new TreeMap();
            }
        };
        private static final Supplier<? super ConcurrentHashMap> CONCURRENT_HASH_MAP = new Supplier<ConcurrentHashMap>(){

            @Override
            public ConcurrentHashMap get() {
                return new ConcurrentHashMap();
            }
        };
        private static final Supplier<? super BiMap> BI_MAP = new Supplier<BiMap>(){

            @Override
            public BiMap get() {
                return new BiMap();
            }
        };
        private static final Supplier<? super Multiset> MULTISET = new Supplier<Multiset>(){

            @Override
            public Multiset get() {
                return new Multiset();
            }
        };
        private static final Supplier<? super ListMultimap> LIST_MULTIMAP = new Supplier<ListMultimap>(){

            @Override
            public ListMultimap get() {
                return N.newListMultimap();
            }
        };
        private static final Supplier<? super SetMultimap> SET_MULTIMAP = new Supplier<SetMultimap>(){

            @Override
            public SetMultimap get() {
                return N.newSetMultimap();
            }
        };
        private static final Supplier<StringBuilder> STRING_BUILDER = new Supplier<StringBuilder>(){

            @Override
            public StringBuilder get() {
                return new StringBuilder();
            }
        };

        protected Suppliers() {
        }

        public static <T> Supplier<T> ofInstance(final T instance) {
            return new Supplier<T>(){

                @Override
                public T get() {
                    return instance;
                }
            };
        }

        public static Supplier<String> ofUUID() {
            return UUID;
        }

        public static Supplier<String> ofGUID() {
            return GUID;
        }

        public static Supplier<boolean[]> ofEmptyBooleanArray() {
            return EMPTY_BOOLEAN_ARRAY;
        }

        public static Supplier<char[]> ofEmptyCharArray() {
            return EMPTY_CHAR_ARRAY;
        }

        public static Supplier<byte[]> ofEmptyByteArray() {
            return EMPTY_BYTE_ARRAY;
        }

        public static Supplier<short[]> ofEmptyShortArray() {
            return EMPTY_SHORT_ARRAY;
        }

        public static Supplier<int[]> ofEmptyIntArray() {
            return EMPTY_INT_ARRAY;
        }

        public static Supplier<long[]> ofEmptyLongArray() {
            return EMPTY_LONG_ARRAY;
        }

        public static Supplier<float[]> ofEmptyFloatArray() {
            return EMPTY_FLOAT_ARRAY;
        }

        public static Supplier<double[]> ofEmptyDoubleArray() {
            return EMPTY_DOUBLE_ARRAY;
        }

        public static Supplier<String[]> ofEmptyStringArray() {
            return EMPTY_STRING_ARRAY;
        }

        public static Supplier<Object[]> ofEmptyObjectArray() {
            return EMPTY_OBJECT_ARRAY;
        }

        public static <T> Supplier<List<T>> ofList() {
            return LIST;
        }

        public static <T> Supplier<LinkedList<T>> ofLinkedList() {
            return LINKED_LIST;
        }

        public static <T> Supplier<Set<T>> ofSet() {
            return SET;
        }

        public static <T> Supplier<Set<T>> ofLinkedHashSet() {
            return LINKED_HASH_SET;
        }

        public static <T> Supplier<SortedSet<T>> ofSortedSet() {
            return TREE_SET;
        }

        public static <T> Supplier<NavigableSet<T>> ofNavigableSet() {
            return TREE_SET;
        }

        public static <T> Supplier<TreeSet<T>> ofTreeSet() {
            return TREE_SET;
        }

        public static <T> Supplier<Queue<T>> ofQueue() {
            return QUEUE;
        }

        public static <T> Supplier<Deque<T>> ofDeque() {
            return DEQUE;
        }

        public static <T> Supplier<ArrayDeque<T>> ofArrayDeque() {
            return ARRAY_DEQUE;
        }

        public static <T> Supplier<LinkedBlockingQueue<T>> ofLinkedBlockingQueue() {
            return LINKED_BLOCKING_QUEUE;
        }

        public static <T> Supplier<ConcurrentLinkedQueue<T>> ofConcurrentLinkedQueue() {
            return CONCURRENT_LINKED_QUEUE;
        }

        public static <T> Supplier<PriorityQueue<T>> ofPriorityQueue() {
            return PRIORITY_QUEUE;
        }

        public static <K, V> Supplier<Map<K, V>> ofMap() {
            return MAP;
        }

        public static <K, V> Supplier<Map<K, V>> ofLinkedHashMap() {
            return LINKED_HASH_MAP;
        }

        public static <K, V> Supplier<IdentityHashMap<K, V>> ofIdentityHashMap() {
            return IDENTITY_HASH_MAP;
        }

        public static <K, V> Supplier<SortedMap<K, V>> ofSortedMap() {
            return TREE_MAP;
        }

        public static <K, V> Supplier<NavigableMap<K, V>> ofNavigableMap() {
            return TREE_MAP;
        }

        public static <K, V> Supplier<TreeMap<K, V>> ofTreeMap() {
            return TREE_MAP;
        }

        public static <K, V> Supplier<ConcurrentMap<K, V>> ofConcurrentMap() {
            return CONCURRENT_HASH_MAP;
        }

        public static <K, V> Supplier<ConcurrentHashMap<K, V>> ofConcurrentHashMap() {
            return CONCURRENT_HASH_MAP;
        }

        public static <K, V> Supplier<BiMap<K, V>> ofBiMap() {
            return BI_MAP;
        }

        public static <T> Supplier<Multiset<T>> ofMultiset() {
            return MULTISET;
        }

        public static <K, E> Supplier<ListMultimap<K, E>> ofListMultimap() {
            return LIST_MULTIMAP;
        }

        public static <K, E> Supplier<SetMultimap<K, E>> ofSetMultimap() {
            return SET_MULTIMAP;
        }

        public static Supplier<StringBuilder> ofStringBuilder() {
            return STRING_BUILDER;
        }

        @Deprecated
        public static Supplier<ImmutableList<?>> ofImmutableList() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public static Supplier<ImmutableSet<?>> ofImmutableSet() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public static Supplier<ImmutableMap<?, ?>> ofImmutableMap() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public static <T, C extends Collection<T>> Supplier<? extends C> single(final Supplier<? extends C> supplier) {
            return new Supplier<C>(){
                private C c = null;

                @Override
                public C get() {
                    if (this.c == null) {
                        this.c = (Collection)supplier.get();
                    } else {
                        this.c.clear();
                    }
                    return this.c;
                }
            };
        }

        static /* synthetic */ Supplier access$200() {
            return MAP;
        }

        static /* synthetic */ Supplier access$300() {
            return LINKED_HASH_MAP;
        }
    }

    public static abstract class IntFunctions
    extends Factory {
        protected IntFunctions() {
        }
    }

    public static abstract class Factory {
        private static final IntFunction<boolean[]> BOOLEAN_ARRAY = new IntFunction<boolean[]>(){

            @Override
            public boolean[] apply(int len) {
                return new boolean[len];
            }
        };
        private static final IntFunction<char[]> CHAR_ARRAY = new IntFunction<char[]>(){

            @Override
            public char[] apply(int len) {
                return new char[len];
            }
        };
        private static final IntFunction<byte[]> BYTE_ARRAY = new IntFunction<byte[]>(){

            @Override
            public byte[] apply(int len) {
                return new byte[len];
            }
        };
        private static final IntFunction<short[]> SHORT_ARRAY = new IntFunction<short[]>(){

            @Override
            public short[] apply(int len) {
                return new short[len];
            }
        };
        private static final IntFunction<int[]> INT_ARRAY = new IntFunction<int[]>(){

            @Override
            public int[] apply(int len) {
                return new int[len];
            }
        };
        private static final IntFunction<long[]> LONG_ARRAY = new IntFunction<long[]>(){

            @Override
            public long[] apply(int len) {
                return new long[len];
            }
        };
        private static final IntFunction<float[]> FLOAT_ARRAY = new IntFunction<float[]>(){

            @Override
            public float[] apply(int len) {
                return new float[len];
            }
        };
        private static final IntFunction<double[]> DOUBLE_ARRAY = new IntFunction<double[]>(){

            @Override
            public double[] apply(int len) {
                return new double[len];
            }
        };
        private static final IntFunction<String[]> STRING_ARRAY = new IntFunction<String[]>(){

            @Override
            public String[] apply(int len) {
                return new String[len];
            }
        };
        private static final IntFunction<Object[]> OBJECT_ARRAY = new IntFunction<Object[]>(){

            @Override
            public Object[] apply(int len) {
                return new Object[len];
            }
        };
        private static final IntFunction<? super List> LIST_FACTORY = new IntFunction<List>(){

            @Override
            public List apply(int len) {
                return new ArrayList(len);
            }
        };
        private static final IntFunction<? super LinkedList> LINKED_LIST_FACTORY = new IntFunction<LinkedList>(){

            @Override
            public LinkedList apply(int len) {
                return new LinkedList();
            }
        };
        private static final IntFunction<? super Set> SET_FACTORY = new IntFunction<Set>(){

            @Override
            public Set apply(int len) {
                return N.newHashSet(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super Set> LINKED_HASH_SET_FACTORY = new IntFunction<Set>(){

            @Override
            public Set apply(int len) {
                return N.newLinkedHashSet(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super TreeSet> TREE_SET_FACTORY = new IntFunction<TreeSet>(){

            @Override
            public TreeSet apply(int len) {
                return new TreeSet();
            }
        };
        private static final IntFunction<? super Queue> QUEUE_FACTORY = new IntFunction<Queue>(){

            @Override
            public Queue apply(int len) {
                return new LinkedList();
            }
        };
        private static final IntFunction<? super Deque> DEQUE_FACTORY = new IntFunction<Deque>(){

            @Override
            public Deque apply(int len) {
                return new LinkedList();
            }
        };
        private static final IntFunction<? super ArrayDeque> ARRAY_DEQUE_FACTORY = new IntFunction<ArrayDeque>(){

            @Override
            public ArrayDeque apply(int len) {
                return new ArrayDeque(len);
            }
        };
        private static final IntFunction<? super LinkedBlockingQueue> LINKED_BLOCKING_QUEUE_FACTORY = new IntFunction<LinkedBlockingQueue>(){

            @Override
            public LinkedBlockingQueue apply(int len) {
                return new LinkedBlockingQueue(len);
            }
        };
        private static final IntFunction<? super ConcurrentLinkedQueue> CONCURRENT_LINKED_QUEUE_FACTORY = new IntFunction<ConcurrentLinkedQueue>(){

            @Override
            public ConcurrentLinkedQueue apply(int len) {
                return new ConcurrentLinkedQueue();
            }
        };
        private static final IntFunction<? super PriorityQueue> PRIORITY_QUEUE_FACTORY = new IntFunction<PriorityQueue>(){

            @Override
            public PriorityQueue apply(int len) {
                return new PriorityQueue(len);
            }
        };
        private static final IntFunction<? super Map> MAP_FACTORY = new IntFunction<Map>(){

            @Override
            public Map apply(int len) {
                return N.newHashMap(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super Map> LINKED_HASH_MAP_FACTORY = new IntFunction<Map>(){

            @Override
            public Map apply(int len) {
                return N.newLinkedHashMap(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super IdentityHashMap> IDENTITY_HASH_MAP_FACTORY = new IntFunction<IdentityHashMap>(){

            @Override
            public IdentityHashMap apply(int len) {
                return new IdentityHashMap(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super TreeMap> TREE_MAP_FACTORY = new IntFunction<TreeMap>(){

            @Override
            public TreeMap apply(int len) {
                return new TreeMap();
            }
        };
        private static final IntFunction<? super ConcurrentHashMap> CONCURRENT_HASH_MAP_FACTORY = new IntFunction<ConcurrentHashMap>(){

            @Override
            public ConcurrentHashMap apply(int len) {
                return new ConcurrentHashMap(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super BiMap> BI_MAP_FACTORY = new IntFunction<BiMap>(){

            @Override
            public BiMap apply(int len) {
                return new BiMap(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super Multiset> MULTISET_FACTORY = new IntFunction<Multiset>(){

            @Override
            public Multiset apply(int len) {
                return new Multiset(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super ListMultimap> LIST_MULTIMAP_FACTORY = new IntFunction<ListMultimap>(){

            @Override
            public ListMultimap apply(int len) {
                return new ListMultimap(N.initHashCapacity(len));
            }
        };
        private static final IntFunction<? super SetMultimap> SET_MULTIMAP_FACTORY = new IntFunction<SetMultimap>(){

            @Override
            public SetMultimap apply(int len) {
                return new SetMultimap(N.initHashCapacity(len));
            }
        };

        protected Factory() {
        }

        public static IntFunction<boolean[]> ofBooleanArray() {
            return BOOLEAN_ARRAY;
        }

        public static IntFunction<char[]> ofCharArray() {
            return CHAR_ARRAY;
        }

        public static IntFunction<byte[]> ofByteArray() {
            return BYTE_ARRAY;
        }

        public static IntFunction<short[]> ofShortArray() {
            return SHORT_ARRAY;
        }

        public static IntFunction<int[]> ofIntArray() {
            return INT_ARRAY;
        }

        public static IntFunction<long[]> ofLongArray() {
            return LONG_ARRAY;
        }

        public static IntFunction<float[]> ofFloatArray() {
            return FLOAT_ARRAY;
        }

        public static IntFunction<double[]> ofDoubleArray() {
            return DOUBLE_ARRAY;
        }

        public static IntFunction<String[]> ofStringArray() {
            return STRING_ARRAY;
        }

        public static IntFunction<Object[]> ofObjectArray() {
            return OBJECT_ARRAY;
        }

        public static <T> IntFunction<List<T>> ofList() {
            return LIST_FACTORY;
        }

        public static <T> IntFunction<LinkedList<T>> ofLinkedList() {
            return LINKED_LIST_FACTORY;
        }

        public static <T> IntFunction<Set<T>> ofSet() {
            return SET_FACTORY;
        }

        public static <T> IntFunction<Set<T>> ofLinkedHashSet() {
            return LINKED_HASH_SET_FACTORY;
        }

        public static <T> IntFunction<SortedSet<T>> ofSortedSet() {
            return TREE_SET_FACTORY;
        }

        public static <T> IntFunction<NavigableSet<T>> ofNavigableSet() {
            return TREE_SET_FACTORY;
        }

        public static <T> IntFunction<TreeSet<T>> ofTreeSet() {
            return TREE_SET_FACTORY;
        }

        public static <T> IntFunction<Queue<T>> ofQueue() {
            return QUEUE_FACTORY;
        }

        public static <T> IntFunction<Deque<T>> ofDeque() {
            return DEQUE_FACTORY;
        }

        public static <T> IntFunction<ArrayDeque<T>> ofArrayDeque() {
            return ARRAY_DEQUE_FACTORY;
        }

        public static <T> IntFunction<LinkedBlockingQueue<T>> ofLinkedBlockingQueue() {
            return LINKED_BLOCKING_QUEUE_FACTORY;
        }

        public static <T> IntFunction<ConcurrentLinkedQueue<T>> ofConcurrentLinkedQueue() {
            return CONCURRENT_LINKED_QUEUE_FACTORY;
        }

        public static <T> IntFunction<PriorityQueue<T>> ofPriorityQueue() {
            return PRIORITY_QUEUE_FACTORY;
        }

        public static <K, V> IntFunction<Map<K, V>> ofMap() {
            return MAP_FACTORY;
        }

        public static <K, V> IntFunction<Map<K, V>> ofLinkedHashMap() {
            return LINKED_HASH_MAP_FACTORY;
        }

        public static <K, V> IntFunction<IdentityHashMap<K, V>> ofIdentityHashMap() {
            return IDENTITY_HASH_MAP_FACTORY;
        }

        public static <K, V> IntFunction<SortedMap<K, V>> ofSortedMap() {
            return TREE_MAP_FACTORY;
        }

        public static <K, V> IntFunction<NavigableMap<K, V>> ofNavigableMap() {
            return TREE_MAP_FACTORY;
        }

        public static <K, V> IntFunction<TreeMap<K, V>> ofTreeMap() {
            return TREE_MAP_FACTORY;
        }

        public static <K, V> IntFunction<ConcurrentMap<K, V>> ofConcurrentMap() {
            return CONCURRENT_HASH_MAP_FACTORY;
        }

        public static <K, V> IntFunction<ConcurrentHashMap<K, V>> ofConcurrentHashMap() {
            return CONCURRENT_HASH_MAP_FACTORY;
        }

        public static <K, V> IntFunction<BiMap<K, V>> ofBiMap() {
            return BI_MAP_FACTORY;
        }

        public static <T> IntFunction<Multiset<T>> ofMultiset() {
            return MULTISET_FACTORY;
        }

        public static <K, E> IntFunction<ListMultimap<K, E>> ofListMultimap() {
            return LIST_MULTIMAP_FACTORY;
        }

        public static <K, E> IntFunction<SetMultimap<K, E>> ofSetMultimap() {
            return SET_MULTIMAP_FACTORY;
        }

        @Deprecated
        public static IntFunction<ImmutableList<?>> ofImmutableList() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public static IntFunction<ImmutableSet<?>> ofImmutableSet() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public static IntFunction<ImmutableMap<?, ?>> ofImmutableMap() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public static <T, C extends Collection<T>> IntFunction<? extends C> single(final IntFunction<? extends C> supplier) {
            return new IntFunction<C>(){
                private C c = null;

                @Override
                public C apply(int t) {
                    if (this.c == null) {
                        this.c = (Collection)supplier.apply(t);
                    } else {
                        this.c.clear();
                    }
                    return this.c;
                }
            };
        }

        static /* synthetic */ IntFunction access$000() {
            return MAP_FACTORY;
        }

        static /* synthetic */ IntFunction access$100() {
            return LINKED_HASH_MAP_FACTORY;
        }
    }
}

