/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.ByteArrayOutputStream;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.LZ4BlockInputStream;
import com.landawn.abacus.util.LZ4BlockOutputStream;
import com.landawn.abacus.util.LineIterator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.SnappyInputStream;
import com.landawn.abacus.util.SnappyOutputStream;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.StringWriter;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.BiPredicate;
import com.landawn.abacus.util.u;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class IOUtil {
    private static final Logger logger;
    private static final Splitter pathSplitter;
    static final int DEFAULT_QUEUE_SIZE_FOR_ROW_PARSER = 1024;
    private static final String ZIP = ".zip";
    private static final String GZ = ".gz";
    private static final long FILE_COPY_BUFFER_SIZE = 0x2000000L;
    static final Method stringEncodeMethod;
    static final Method stringDecodeMethod;
    public static final String HOST_NAME;
    public static final int CPU_CORES;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static final long ONE_PB = 0x4000000000000L;
    public static final long ONE_EB = 0x1000000000000000L;
    public static final long ONE_ZB = 0L;
    public static final int MAX_MEMORY_IN_MB;
    public static final String OS_NAME;
    public static final String OS_VERSION;
    public static final String OS_ARCH;
    public static final boolean IS_OS_WINDOWS;
    public static final boolean IS_OS_MAC;
    public static final boolean IS_OS_MAC_OSX;
    public static final boolean IS_OS_LINUX;
    public static final boolean IS_PLATFORM_ANDROID;
    public static final String JAVA_HOME;
    public static final String JAVA_VERSION;
    public static final String JAVA_VENDOR;
    public static final String JAVA_CLASS_PATH;
    public static final String JAVA_CLASS_VERSION;
    public static final String JAVA_RUNTIME_NAME;
    public static final String JAVA_RUNTIME_VERSION;
    public static final String JAVA_SPECIFICATION_NAME;
    public static final String JAVA_SPECIFICATION_VENDOR;
    public static final String JAVA_SPECIFICATION_VERSION;
    public static final String JAVA_VM_INFO;
    public static final String JAVA_VM_NAME;
    public static final String JAVA_VM_SPECIFICATION_NAME;
    public static final String JAVA_VM_SPECIFICATION_VENDOR;
    public static final String JAVA_VM_SPECIFICATION_VERSION;
    public static final String JAVA_VM_VENDOR;
    public static final String JAVA_VM_VERSION;
    public static final String JAVA_IO_TMPDIR;
    static final String JAVA_VENDOR_URL;
    static final String JAVA_LIBRARY_PATH;
    static final String JAVA_COMPILER;
    static final String JAVA_ENDORSED_DIRS;
    static final String JAVA_EXT_DIRS;
    static final String JAVA_AWT_FONTS;
    static final String JAVA_AWT_GRAPHICSENV;
    static final String JAVA_AWT_HEADLESS;
    static final String JAVA_AWT_PRINTERJOB;
    static final String JAVA_UTIL_PREFS_PREFERENCES_FACTORY;
    public static final String USER_DIR;
    public static final String USER_HOME;
    public static final String USER_NAME;
    public static final String USER_TIMEZONE;
    public static final String USER_LANGUAGE;
    public static final String USER_COUNTRY;
    public static final String CURRENT_PATH;
    public static final String PATH_SEPARATOR;
    public static final String FILE_SEPARATOR;
    public static final String LINE_SEPARATOR;
    public static final int EOF = -1;
    private static final BiPredicate<File, File> all_files_filter;
    private static final BiPredicate<File, File> directories_excluded_filter;
    private static final BiPredicate<File, File> directories_only_filter;

    private IOUtil() {
    }

    public static byte[] chars2Bytes(char[] chars) {
        return IOUtil.chars2Bytes(chars, Charsets.UTF_8);
    }

    public static byte[] chars2Bytes(char[] chars, Charset charset) {
        if (N.isNullOrEmpty(chars)) {
            return N.EMPTY_BYTE_ARRAY;
        }
        return IOUtil.chars2Bytes(chars, 0, chars.length, charset);
    }

    public static byte[] chars2Bytes(char[] chars, int offset, int len, Charset charset) {
        if (len == 0 && N.len(chars) >= offset) {
            return N.EMPTY_BYTE_ARRAY;
        }
        Charset charset2 = charset = charset == null ? Charsets.UTF_8 : charset;
        if (stringEncodeMethod == null) {
            return new String(chars, offset, len).getBytes(charset);
        }
        return (byte[])ClassUtil.invokeMethod(stringEncodeMethod, charset, chars, offset, len);
    }

    public static char[] bytes2Chars(byte[] bytes) {
        return IOUtil.bytes2Chars(bytes, Charsets.UTF_8);
    }

    public static char[] bytes2Chars(byte[] bytes, Charset charset) {
        if (N.isNullOrEmpty(bytes)) {
            return N.EMPTY_CHAR_ARRAY;
        }
        return IOUtil.bytes2Chars(bytes, 0, bytes.length, charset);
    }

    public static char[] bytes2Chars(byte[] bytes, int offset, int len, Charset charset) {
        if (len == 0 && N.len(bytes) >= offset) {
            return N.EMPTY_CHAR_ARRAY;
        }
        Charset charset2 = charset = charset == null ? Charsets.UTF_8 : charset;
        if (stringDecodeMethod == null) {
            return new String(bytes, offset, len, charset).toCharArray();
        }
        return (char[])ClassUtil.invokeMethod(stringDecodeMethod, charset, bytes, offset, len);
    }

    public static InputStream string2InputStream(String str) {
        return IOUtil.string2InputStream(str, Charsets.UTF_8);
    }

    public static InputStream string2InputStream(String str, Charset charset) {
        if (str == null) {
            throw new IllegalArgumentException("The input String can't be null.");
        }
        charset = charset == null ? Charsets.UTF_8 : charset;
        return new ByteArrayInputStream(str.getBytes(charset));
    }

    public static Reader string2Reader(String str) {
        if (str == null) {
            throw new IllegalArgumentException("The input String can't be null.");
        }
        return new StringReader(str);
    }

    public static Writer stringBuilder2Writer(StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException("The input StringBuilder can't be null.");
        }
        return new StringWriter(sb);
    }

    public static byte[] readBytes(File file) throws UncheckedIOException {
        return IOUtil.readBytes(file, 0L, Integer.MAX_VALUE);
    }

    public static byte[] readBytes(File file, long offset, int maxLen) throws UncheckedIOException {
        u.Holder<ZipFile> outputZipFile = new u.Holder<ZipFile>();
        InputStream is = null;
        try {
            is = IOUtil.openFile(outputZipFile, file);
            byte[] byArray = IOUtil.readBytes(is, offset, maxLen);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtil.close(is);
            IOUtil.close((AutoCloseable)outputZipFile.value());
        }
    }

    public static byte[] readBytes(InputStream is) throws UncheckedIOException {
        return IOUtil.readBytes(is, 0L, Integer.MAX_VALUE);
    }

    public static byte[] readBytes(InputStream is, long offset, int maxLen) throws UncheckedIOException {
        byte[] byArray;
        if (maxLen == 0) {
            return N.EMPTY_BYTE_ARRAY;
        }
        if (offset > 0L && IOUtil.skip(is, offset) < offset) {
            return N.EMPTY_BYTE_ARRAY;
        }
        ByteArrayOutputStream os = null;
        byte[] buf = Objectory.createByteArrayBuffer();
        int bufLength = buf.length;
        int count = 0;
        try {
            int totalCount;
            for (totalCount = 0; totalCount < maxLen && -1 != (count = IOUtil.read(is, buf, 0, Math.min(maxLen - totalCount, bufLength))); totalCount += count) {
                if (count == bufLength && count < maxLen && os == null) {
                    os = Objectory.createByteArrayOutputStream();
                }
                if (os == null) continue;
                os.write(buf, 0, count);
            }
            byArray = os == null ? (totalCount <= 0 ? N.EMPTY_BYTE_ARRAY : N.copyOfRange(buf, 0, totalCount)) : os.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                Objectory.recycle(buf);
                Objectory.recycle(os);
                throw throwable;
            }
        }
        Objectory.recycle(buf);
        Objectory.recycle(os);
        return byArray;
    }

    public static char[] readChars(File file) throws UncheckedIOException {
        return IOUtil.readChars(file, 0L, Integer.MAX_VALUE);
    }

    public static char[] readChars(File file, Charset encoding) throws UncheckedIOException {
        return IOUtil.readChars(file, 0L, Integer.MAX_VALUE, encoding);
    }

    public static char[] readChars(File file, long offset, int maxLen) throws UncheckedIOException {
        return IOUtil.readChars(file, 0L, maxLen, Charsets.UTF_8);
    }

    public static char[] readChars(File file, long offset, int maxLen, Charset encoding) throws UncheckedIOException {
        u.Holder<ZipFile> outputZipFile = new u.Holder<ZipFile>();
        InputStream is = null;
        try {
            is = IOUtil.openFile(outputZipFile, file);
            char[] cArray = IOUtil.readChars(is, offset, maxLen, encoding);
            return cArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtil.close(is);
            IOUtil.close((AutoCloseable)outputZipFile.value());
        }
    }

    public static char[] readChars(InputStream is) throws UncheckedIOException {
        return IOUtil.readChars(is, 0L, Integer.MAX_VALUE);
    }

    public static char[] readChars(InputStream is, Charset encoding) throws UncheckedIOException {
        return IOUtil.readChars(is, 0L, Integer.MAX_VALUE, encoding);
    }

    public static char[] readChars(InputStream is, long offset, int maxLen) throws UncheckedIOException {
        return IOUtil.readChars(is, 0L, maxLen, Charsets.UTF_8);
    }

    public static char[] readChars(InputStream is, long offset, int maxLen, Charset encoding) throws UncheckedIOException {
        encoding = encoding == null ? Charsets.UTF_8 : encoding;
        InputStreamReader reader = null;
        reader = IOUtil.createReader(is, encoding);
        return IOUtil.readChars(reader, offset, maxLen);
    }

    public static char[] readChars(Reader reader) throws UncheckedIOException {
        return IOUtil.readChars(reader, 0L, Integer.MAX_VALUE);
    }

    public static char[] readChars(Reader reader, long offset, int maxLen) throws UncheckedIOException {
        char[] cArray;
        if (maxLen == 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        if (offset > 0L && IOUtil.skip(reader, offset) < offset) {
            return N.EMPTY_CHAR_ARRAY;
        }
        StringBuilder sb = null;
        char[] buf = Objectory.createCharArrayBuffer();
        int bufLength = buf.length;
        int count = 0;
        try {
            int totalCount;
            for (totalCount = 0; totalCount < maxLen && -1 != (count = IOUtil.read(reader, buf, 0, Math.min(maxLen - totalCount, bufLength))); totalCount += count) {
                if (count == bufLength && count < maxLen && sb == null) {
                    sb = Objectory.createStringBuilder();
                }
                if (sb == null) continue;
                sb.append(buf, 0, count);
            }
            if (sb == null) {
                char[] cArray2 = totalCount <= 0 ? N.EMPTY_CHAR_ARRAY : N.copyOfRange(buf, 0, totalCount);
                return cArray2;
            }
            char[] a = new char[totalCount];
            sb.getChars(0, totalCount, a, 0);
            cArray = a;
            Objectory.recycle(buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
            Objectory.recycle(sb);
        }
        Objectory.recycle(sb);
        return cArray;
    }

    public static String readString(File file) throws UncheckedIOException {
        return IOUtil.readString(file, 0L, Integer.MAX_VALUE);
    }

    public static String readString(File file, Charset encoding) throws UncheckedIOException {
        return IOUtil.readString(file, 0L, Integer.MAX_VALUE, encoding);
    }

    public static String readString(File file, long offset, int maxLen) throws UncheckedIOException {
        return IOUtil.readString(file, offset, maxLen, Charsets.UTF_8);
    }

    public static String readString(File file, long offset, int maxLen, Charset encoding) throws UncheckedIOException {
        char[] chs = IOUtil.readChars(file, offset, maxLen, encoding);
        return N.isNullOrEmpty(chs) ? N.EMPTY_STRING : StringUtil.newString(chs, true);
    }

    public static String readString(InputStream is) throws UncheckedIOException {
        return IOUtil.readString(is, 0L, Integer.MAX_VALUE);
    }

    public static String readString(InputStream is, Charset encoding) throws UncheckedIOException {
        return IOUtil.readString(is, 0L, Integer.MAX_VALUE, encoding);
    }

    public static String readString(InputStream is, long offset, int maxLen) throws UncheckedIOException {
        return IOUtil.readString(is, offset, maxLen, Charsets.UTF_8);
    }

    public static String readString(InputStream is, long offset, int maxLen, Charset encoding) throws UncheckedIOException {
        char[] chs = IOUtil.readChars(is, offset, maxLen, encoding);
        return N.isNullOrEmpty(chs) ? N.EMPTY_STRING : StringUtil.newString(chs, true);
    }

    public static String readString(Reader reader) throws UncheckedIOException {
        return IOUtil.readString(reader, 0L, Integer.MAX_VALUE);
    }

    public static String readString(Reader reader, long offset, int maxLen) throws UncheckedIOException {
        char[] chs = IOUtil.readChars(reader, offset, maxLen);
        return N.isNullOrEmpty(chs) ? N.EMPTY_STRING : StringUtil.newString(chs, true);
    }

    public static String readLine(File file) throws UncheckedIOException {
        return IOUtil.readLine(file, 0);
    }

    public static String readLine(File file, int lineIndex) throws UncheckedIOException {
        return IOUtil.readLine(file, lineIndex, Charsets.UTF_8);
    }

    public static String readLine(File file, int lineIndex, Charset encoding) throws UncheckedIOException {
        u.Holder<ZipFile> outputZipFile = new u.Holder<ZipFile>();
        InputStream is = null;
        try {
            is = IOUtil.openFile(outputZipFile, file);
            String string = IOUtil.readLine(is, lineIndex, encoding);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtil.close(is);
            IOUtil.close((AutoCloseable)outputZipFile.value());
        }
    }

    public static String readLine(InputStream is) throws UncheckedIOException {
        return IOUtil.readLine(is, 0);
    }

    public static String readLine(InputStream is, int lineIndex) throws UncheckedIOException {
        return IOUtil.readLine(is, lineIndex, Charsets.UTF_8);
    }

    public static String readLine(InputStream is, int lineIndex, Charset encoding) throws UncheckedIOException {
        return IOUtil.readLine(IOUtil.createReader(is, encoding), lineIndex);
    }

    public static String readLine(Reader reader) throws UncheckedIOException {
        return IOUtil.readLine(reader, 0);
    }

    public static String readLine(Reader reader, int lineIndex) throws UncheckedIOException {
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : Objectory.createBufferedReader(reader);
        try {
            if (lineIndex == 0) {
                String string = br.readLine();
                return string;
            }
            while (lineIndex-- > 0 && br.readLine() != null) {
            }
            String string = br.readLine();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (br != reader) {
                Objectory.recycle(br);
            }
        }
    }

    public static List<String> readLines(File file) throws UncheckedIOException {
        return IOUtil.readLines(file, 0, Integer.MAX_VALUE);
    }

    public static List<String> readLines(File file, Charset encoding) throws UncheckedIOException {
        return IOUtil.readLines(file, 0, Integer.MAX_VALUE, encoding);
    }

    public static List<String> readLines(File file, int offset, int count) throws UncheckedIOException {
        return IOUtil.readLines(file, offset, count, Charsets.UTF_8);
    }

    public static List<String> readLines(File file, int offset, int count, Charset encoding) throws UncheckedIOException {
        u.Holder<ZipFile> outputZipFile = new u.Holder<ZipFile>();
        InputStream is = null;
        try {
            is = IOUtil.openFile(outputZipFile, file);
            List<String> list = IOUtil.readLines(is, offset, count, encoding);
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtil.close(is);
            IOUtil.close((AutoCloseable)outputZipFile.value());
        }
    }

    public static List<String> readLines(InputStream is) throws UncheckedIOException {
        return IOUtil.readLines(is, 0, Integer.MAX_VALUE);
    }

    public static List<String> readLines(InputStream is, Charset encoding) throws UncheckedIOException {
        return IOUtil.readLines(is, 0, Integer.MAX_VALUE, encoding);
    }

    public static List<String> readLines(InputStream is, int offset, int count) throws UncheckedIOException {
        return IOUtil.readLines(is, offset, count, Charsets.UTF_8);
    }

    public static List<String> readLines(InputStream is, int offset, int count, Charset encoding) throws UncheckedIOException {
        return IOUtil.readLines(IOUtil.createReader(is, encoding), offset, count);
    }

    private static InputStreamReader createReader(InputStream is, Charset encoding) throws UncheckedIOException {
        return encoding == null ? new InputStreamReader(is, Charsets.UTF_8) : new InputStreamReader(is, encoding);
    }

    public static List<String> readLines(Reader reader) throws UncheckedIOException {
        return IOUtil.readLines(reader, 0, Integer.MAX_VALUE);
    }

    public static List<String> readLines(Reader reader, int offset, int count) throws UncheckedIOException {
        ArrayList<String> res = new ArrayList<String>();
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : Objectory.createBufferedReader(reader);
        try {
            while (offset-- > 0 && br.readLine() != null) {
            }
            String line = null;
            while (count-- > 0 && (line = br.readLine()) != null) {
                res.add(line);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (br != reader) {
                Objectory.recycle(br);
            }
        }
        return res;
    }

    public static LineIterator iterate(File file) throws UncheckedIOException {
        return IOUtil.iterate(file, Charsets.UTF_8);
    }

    public static LineIterator iterate(File file, Charset encoding) throws UncheckedIOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            return IOUtil.iterate(in, encoding);
        }
        catch (IOException ex) {
            IOUtil.closeQuietly(in);
            throw new UncheckedIOException(ex);
        }
        catch (RuntimeException ex) {
            IOUtil.closeQuietly(in);
            throw ex;
        }
    }

    public static LineIterator iterate(InputStream input) throws UncheckedIOException {
        return IOUtil.iterate(input, null);
    }

    public static LineIterator iterate(InputStream input, Charset encoding) throws UncheckedIOException {
        return new LineIterator(IOUtil.createReader(input, encoding));
    }

    public static LineIterator iterate(Reader reader) throws UncheckedIOException {
        return new LineIterator(reader);
    }

    public static int read(File file, byte[] buf) throws UncheckedIOException {
        return IOUtil.read(file, buf, 0, buf.length);
    }

    public static int read(File file, byte[] buf, int off, int len) throws UncheckedIOException {
        int n;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            n = IOUtil.read(is, buf, off, len);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(is);
        return n;
    }

    public static int read(InputStream is, byte[] buf) throws IOException {
        return IOUtil.read(is, buf, 0, buf.length);
    }

    public static int read(InputStream is, byte[] buf, int off, int len) throws IOException {
        int n1;
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = is.read(buf, off, len);
        if (n < 0 || n == len) {
            return n;
        }
        while (n < len && (n1 = is.read(buf, off + n, len - n)) >= 0) {
            n += n1;
        }
        return n;
    }

    public static int read(File file, char[] buf) throws UncheckedIOException {
        return IOUtil.read(file, buf, 0, buf.length);
    }

    public static int read(File file, char[] buf, Charset charset) throws UncheckedIOException {
        return IOUtil.read(file, buf, 0, buf.length, charset);
    }

    public static int read(File file, char[] buf, int off, int len) throws UncheckedIOException {
        return IOUtil.read(file, buf, off, len, Charsets.UTF_8);
    }

    public static int read(File file, char[] buf, int off, int len, Charset charset) throws UncheckedIOException {
        int n;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), charset == null ? Charsets.UTF_8 : charset);
            n = IOUtil.read(reader, buf, off, len);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(reader);
        return n;
    }

    public static int read(Reader reader, char[] buf) throws IOException {
        return IOUtil.read(reader, buf, 0, buf.length);
    }

    public static int read(Reader reader, char[] buf, int off, int len) throws IOException {
        int n1;
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = reader.read(buf, off, len);
        if (n < 0 || n == len) {
            return n;
        }
        while (n < len && (n1 = reader.read(buf, off + n, len - n)) >= 0) {
            n += n1;
        }
        return n;
    }

    public static void writeLine(File file, Object obj) throws UncheckedIOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            IOUtil.writeLine(writer, obj);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    public static void writeLine(OutputStream os, Object obj) throws UncheckedIOException {
        IOUtil.writeLine(os, obj, false);
    }

    public static void writeLine(OutputStream os, Object obj, boolean flush) throws UncheckedIOException {
        IOUtil.writeLine(new OutputStreamWriter(os), obj, flush);
    }

    public static void writeLine(Writer writer, Object obj) throws UncheckedIOException {
        IOUtil.writeLine(writer, obj, false);
    }

    public static void writeLine(Writer writer, Object obj, boolean flush) throws UncheckedIOException {
        try {
            if (obj == null) {
                writer.write(N.NULL_CHAR_ARRAY);
            } else {
                writer.write(N.toString(obj));
            }
            writer.write(LINE_SEPARATOR);
            if (flush) {
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeLines(File file, Object[] lines) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(file, lines, 0, lines.length);
    }

    public static void writeLines(File file, Object[] lines, int offset, int count) throws UncheckedIOException {
        if (count == 0 && N.len(lines) >= offset) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            IOUtil.writeLines((Writer)writer, lines, offset, count);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    public static void writeLines(OutputStream os, Object[] lines) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(os, lines, false);
    }

    public static void writeLines(OutputStream os, Object[] lines, boolean flush) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(os, lines, 0, lines.length, flush);
    }

    public static void writeLines(OutputStream os, Object[] lines, int offset, int count) throws UncheckedIOException {
        if (count == 0 && N.len(lines) >= offset) {
            return;
        }
        IOUtil.writeLines(os, lines, offset, count, false);
    }

    public static void writeLines(OutputStream os, Object[] lines, int offset, int count, boolean flush) throws UncheckedIOException {
        if (count == 0 && N.len(lines) >= offset) {
            return;
        }
        IOUtil.writeLines((Writer)new OutputStreamWriter(os), lines, offset, count, flush);
    }

    public static void writeLines(Writer writer, Object[] lines) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(writer, lines, false);
    }

    public static void writeLines(Writer writer, Object[] lines, boolean flush) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(writer, lines, 0, lines.length, flush);
    }

    public static void writeLines(Writer writer, Object[] lines, int offset, int count) throws UncheckedIOException {
        if (count == 0 && N.len(lines) >= offset) {
            return;
        }
        IOUtil.writeLines(writer, lines, offset, count, false);
    }

    public static void writeLines(Writer writer, Object[] lines, int offset, int count, boolean flush) throws UncheckedIOException {
        if (count == 0 && N.len(lines) >= offset) {
            return;
        }
        boolean isBufferedWriter = writer instanceof BufferedWriter || writer instanceof java.io.BufferedWriter;
        Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
        try {
            int lineNum = 0;
            for (Object line : lines) {
                if (lineNum++ >= offset) {
                    if (line == null) {
                        writer.write(N.NULL_CHAR_ARRAY);
                    } else {
                        writer.write(N.toString(line));
                    }
                    writer.write(LINE_SEPARATOR);
                    --count;
                }
                if (count <= 0) break;
            }
            if (flush || !isBufferedWriter) {
                bw.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle((BufferedWriter)bw);
            }
        }
    }

    public static void writeLines(File file, Collection<?> lines) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(file, lines, 0, lines.size());
    }

    public static void writeLines(File file, Collection<?> lines, int offset, int count) throws UncheckedIOException {
        if (count == 0 && N.size(lines) >= offset) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            IOUtil.writeLines((Writer)writer, lines, offset, count);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    public static void writeLines(OutputStream os, Collection<?> lines) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(os, lines, false);
    }

    public static void writeLines(OutputStream os, Collection<?> lines, boolean flush) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(os, lines, 0, lines.size(), flush);
    }

    public static void writeLines(OutputStream os, Collection<?> lines, int offset, int count) throws UncheckedIOException {
        if (count == 0 && N.size(lines) >= offset) {
            return;
        }
        IOUtil.writeLines(os, lines, offset, count, false);
    }

    public static void writeLines(OutputStream os, Collection<?> lines, int offset, int count, boolean flush) throws UncheckedIOException {
        if (count == 0 && N.size(lines) >= offset) {
            return;
        }
        IOUtil.writeLines((Writer)new OutputStreamWriter(os), lines, offset, count, flush);
    }

    public static void writeLines(Writer writer, Collection<?> lines) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(writer, lines, false);
    }

    public static void writeLines(Writer writer, Collection<?> lines, boolean flush) throws UncheckedIOException {
        if (N.isNullOrEmpty(lines)) {
            return;
        }
        IOUtil.writeLines(writer, lines, 0, lines.size(), flush);
    }

    public static void writeLines(Writer writer, Collection<?> lines, int offset, int count) throws UncheckedIOException {
        if (count == 0 && N.size(lines) >= offset) {
            return;
        }
        IOUtil.writeLines(writer, lines, offset, count, false);
    }

    public static void writeLines(Writer writer, Collection<?> lines, int offset, int count, boolean flush) throws UncheckedIOException {
        if (count == 0 && N.size(lines) >= offset) {
            return;
        }
        boolean isBufferedWriter = writer instanceof BufferedWriter || writer instanceof java.io.BufferedWriter;
        Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
        try {
            int lineNum = 0;
            for (Object line : lines) {
                if (lineNum++ >= offset) {
                    if (line == null) {
                        writer.write(N.NULL_CHAR_ARRAY);
                    } else {
                        writer.write(N.toString(line));
                    }
                    writer.write(LINE_SEPARATOR);
                    --count;
                }
                if (count > 0) continue;
                break;
            }
            if (flush || !isBufferedWriter) {
                bw.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle((BufferedWriter)bw);
            }
        }
    }

    public static void write(Writer writer, boolean b) throws IOException {
        IOUtil.write(writer, b, false);
    }

    public static void write(Writer writer, boolean b, boolean flush) throws IOException {
        writer.write(N.stringOf(b));
        if (flush) {
            writer.flush();
        }
    }

    public static void write(Writer writer, char c) throws IOException {
        IOUtil.write(writer, c, false);
    }

    public static void write(Writer writer, char c, boolean flush) throws IOException {
        writer.write(c);
        if (flush) {
            writer.flush();
        }
    }

    public static void write(Writer writer, byte b) throws IOException {
        IOUtil.write(writer, b, false);
    }

    public static void write(Writer writer, byte b, boolean flush) throws IOException {
        writer.write(N.stringOf(b));
        if (flush) {
            writer.flush();
        }
    }

    public static void write(Writer writer, short s) throws IOException {
        IOUtil.write(writer, s, false);
    }

    public static void write(Writer writer, short s, boolean flush) throws IOException {
        writer.write(N.stringOf(s));
        if (flush) {
            writer.flush();
        }
    }

    public static void write(Writer writer, int i) throws IOException {
        IOUtil.write(writer, i, false);
    }

    public static void write(Writer writer, int i, boolean flush) throws IOException {
        writer.write(N.stringOf(i));
        if (flush) {
            writer.flush();
        }
    }

    public static void write(Writer writer, long lng) throws IOException {
        IOUtil.write(writer, lng, false);
    }

    public static void write(Writer writer, long lng, boolean flush) throws IOException {
        writer.write(N.stringOf(lng));
        if (flush) {
            writer.flush();
        }
    }

    public static void write(Writer writer, float f) throws IOException {
        IOUtil.write(writer, f, false);
    }

    public static void write(Writer writer, float f, boolean flush) throws IOException {
        writer.write(N.stringOf(f));
        if (flush) {
            writer.flush();
        }
    }

    public static void write(Writer writer, double d) throws IOException {
        IOUtil.write(writer, d, false);
    }

    public static void write(Writer writer, double d, boolean flush) throws IOException {
        writer.write(N.stringOf(d));
        if (flush) {
            writer.flush();
        }
    }

    public static void write(File out, CharSequence str) throws UncheckedIOException {
        IOUtil.write(out, str, Charsets.UTF_8);
    }

    public static void write(File out, CharSequence str, Charset charset) throws UncheckedIOException {
        charset = charset == null ? Charsets.UTF_8 : charset;
        IOUtil.write(out, IOUtil.chars2Bytes(IOUtil.toCharArray(str), charset));
    }

    public static void write(OutputStream out, CharSequence str) throws UncheckedIOException {
        IOUtil.write(out, str, false);
    }

    public static void write(OutputStream out, CharSequence str, Charset charset) throws UncheckedIOException {
        IOUtil.write(out, str, charset, false);
    }

    public static void write(OutputStream out, CharSequence str, boolean flush) throws UncheckedIOException {
        IOUtil.write(out, str, Charsets.UTF_8, flush);
    }

    public static void write(OutputStream out, CharSequence str, Charset charset, boolean flush) throws UncheckedIOException {
        charset = charset == null ? Charsets.UTF_8 : charset;
        try {
            out.write(IOUtil.chars2Bytes(IOUtil.toCharArray(str), charset));
            if (flush) {
                out.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(Writer out, CharSequence str) throws UncheckedIOException {
        IOUtil.write(out, str, false);
    }

    public static void write(Writer out, CharSequence str, boolean flush) throws UncheckedIOException {
        IOUtil.write(out, IOUtil.toCharArray(str), flush);
    }

    public static void write(File out, char[] chars) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.write(out, chars, 0, chars.length);
    }

    public static void write(File out, char[] chars, Charset charset) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.write(out, chars, 0, chars.length, charset);
    }

    public static void write(File out, char[] chars, int offset, int len) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.write(out, chars, offset, len, Charsets.UTF_8);
    }

    public static void write(File out, char[] chars, int offset, int len, Charset charset) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.write(out, IOUtil.chars2Bytes(chars, offset, len, charset));
    }

    public static void write(OutputStream out, char[] chars) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.write(out, chars, 0, chars.length);
    }

    public static void write(OutputStream out, char[] chars, Charset charset) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.write(out, chars, 0, chars.length, charset);
    }

    public static void write(OutputStream out, char[] chars, int offset, int len) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.write(out, chars, offset, len, Charsets.UTF_8);
    }

    public static void write(OutputStream out, char[] chars, int offset, int len, Charset charset) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.write(out, chars, offset, len, charset, false);
    }

    public static void write(OutputStream out, char[] chars, boolean flush) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.write(out, chars, 0, chars.length, flush);
    }

    public static void write(OutputStream out, char[] chars, int offset, int len, boolean flush) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.write(out, chars, offset, len, Charsets.UTF_8, flush);
    }

    public static void write(OutputStream out, char[] chars, int offset, int len, Charset charset, boolean flush) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.write(out, IOUtil.chars2Bytes(chars, offset, len, charset), flush);
    }

    public static void write(Writer out, char[] chars) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.write(out, chars, 0, chars.length);
    }

    public static void write(Writer out, char[] chars, int offset, int len) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.write(out, chars, offset, len, false);
    }

    public static void write(Writer out, char[] chars, boolean flush) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.write(out, chars, 0, chars.length, flush);
    }

    public static void write(Writer out, char[] chars, int offset, int len, boolean flush) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        try {
            out.write(chars, offset, len);
            if (flush) {
                out.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(File out, byte[] bytes) throws UncheckedIOException {
        if (N.isNullOrEmpty(bytes)) {
            return;
        }
        IOUtil.write(out, bytes, 0, bytes.length);
    }

    public static void write(File out, byte[] bytes, int offset, int len) throws UncheckedIOException {
        if (len == 0 && N.len(bytes) >= offset) {
            return;
        }
        FileOutputStream os = null;
        try {
            if (!out.exists()) {
                out.createNewFile();
            }
            os = new FileOutputStream(out);
            IOUtil.write((OutputStream)os, bytes, offset, len);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    public static void write(OutputStream out, byte[] bytes) throws UncheckedIOException {
        if (N.isNullOrEmpty(bytes)) {
            return;
        }
        IOUtil.write(out, bytes, 0, bytes.length);
    }

    public static void write(OutputStream out, byte[] bytes, int offset, int len) throws UncheckedIOException {
        if (len == 0 && N.len(bytes) >= offset) {
            return;
        }
        IOUtil.write(out, bytes, offset, len, false);
    }

    public static void write(OutputStream out, byte[] bytes, boolean flush) throws UncheckedIOException {
        if (N.isNullOrEmpty(bytes)) {
            return;
        }
        IOUtil.write(out, bytes, 0, bytes.length, flush);
    }

    public static void write(OutputStream out, byte[] bytes, int offset, int len, boolean flush) throws UncheckedIOException {
        if (len == 0 && N.len(bytes) >= offset) {
            return;
        }
        try {
            out.write(bytes, offset, len);
            if (flush) {
                out.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long write(File output, InputStream input) throws UncheckedIOException {
        return IOUtil.write(output, input, 0L, Long.MAX_VALUE);
    }

    public static long write(File output, InputStream input, long offset, long len) throws UncheckedIOException {
        long l;
        FileOutputStream os = null;
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            os = new FileOutputStream(output);
            long result = IOUtil.write((OutputStream)os, input, offset, len);
            os.flush();
            l = result;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
        return l;
    }

    public static long write(OutputStream output, InputStream input) throws UncheckedIOException {
        return IOUtil.write(output, input, false);
    }

    public static long write(OutputStream output, InputStream input, long offset, long len) throws UncheckedIOException {
        return IOUtil.write(output, input, offset, len, false);
    }

    public static long write(OutputStream output, InputStream input, boolean flush) throws UncheckedIOException {
        return IOUtil.write(output, input, 0L, Long.MAX_VALUE, flush);
    }

    public static long write(OutputStream output, InputStream input, long offset, long len, boolean flush) throws UncheckedIOException {
        byte[] buf = Objectory.createByteArrayBuffer();
        try {
            long totalCount;
            if (offset > 0L) {
                IOUtil.skipFully(input, offset);
            }
            if (len == 0L) {
                long l = 0L;
                return l;
            }
            int bufLength = buf.length;
            int count = 0;
            for (totalCount = 0L; totalCount < len && -1 != (count = IOUtil.read(input, buf, 0, (int)Math.min(len - totalCount, (long)bufLength))); totalCount += (long)count) {
                output.write(buf, 0, count);
            }
            if (flush) {
                output.flush();
            }
            long l = totalCount;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
        }
    }

    public static long write(File output, Reader input) throws UncheckedIOException {
        return IOUtil.write(output, input, Charsets.UTF_8);
    }

    public static long write(File output, Reader input, Charset charset) throws UncheckedIOException {
        return IOUtil.write(output, input, 0L, Long.MAX_VALUE, charset);
    }

    public static long write(File output, Reader input, long offset, long len) throws UncheckedIOException {
        return IOUtil.write(output, input, offset, len, Charsets.UTF_8);
    }

    public static long write(File output, Reader input, long offset, long len, Charset charset) throws UncheckedIOException {
        long l;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), charset == null ? Charsets.UTF_8 : charset);
            long result = IOUtil.write((Writer)writer, input, offset, len);
            ((Writer)writer).flush();
            l = result;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
        return l;
    }

    public static long write(Writer output, Reader input) throws UncheckedIOException {
        return IOUtil.write(output, input, false);
    }

    public static long write(Writer output, Reader input, long offset, long len) throws UncheckedIOException {
        return IOUtil.write(output, input, offset, len, false);
    }

    public static long write(Writer output, Reader input, boolean flush) throws UncheckedIOException {
        return IOUtil.write(output, input, 0L, Long.MAX_VALUE, flush);
    }

    public static long write(Writer output, Reader input, long offset, long len, boolean flush) throws UncheckedIOException {
        char[] buf = Objectory.createCharArrayBuffer();
        try {
            long totalCount;
            if (offset > 0L) {
                IOUtil.skipFully(input, offset);
            }
            if (len == 0L) {
                long l = 0L;
                return l;
            }
            int bufLength = buf.length;
            int count = 0;
            for (totalCount = 0L; totalCount < len && -1 != (count = IOUtil.read(input, buf, 0, (int)Math.min(len - totalCount, (long)bufLength))); totalCount += (long)count) {
                output.write(buf, 0, count);
            }
            if (flush) {
                output.flush();
            }
            long l = totalCount;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
        }
    }

    public static long write(File output, File input) throws UncheckedIOException {
        return IOUtil.write(output, input, 0L, Long.MAX_VALUE);
    }

    public static long write(File output, File input, long offset, long len) throws UncheckedIOException {
        long l;
        FileOutputStream os = null;
        FileInputStream is = null;
        try {
            os = new FileOutputStream(output);
            is = new FileInputStream(input);
            l = IOUtil.write((OutputStream)os, is, offset, len, true);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(os);
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(os);
        IOUtil.closeQuietly(is);
        return l;
    }

    public static long write(OutputStream output, File input) throws UncheckedIOException {
        return IOUtil.write(output, input, false);
    }

    public static long write(OutputStream output, File input, long offset, long len) throws UncheckedIOException {
        return IOUtil.write(output, input, offset, len, false);
    }

    public static long write(OutputStream output, File input, boolean flush) throws UncheckedIOException {
        return IOUtil.write(output, input, 0L, Long.MAX_VALUE, flush);
    }

    public static long write(OutputStream output, File input, long offset, long len, boolean flush) throws UncheckedIOException {
        long l;
        FileInputStream is = null;
        try {
            is = new FileInputStream(input);
            l = IOUtil.write(output, is, offset, len, flush);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(is);
        return l;
    }

    public static long write(Writer output, File input) throws UncheckedIOException {
        return IOUtil.write(output, input, false);
    }

    public static long write(Writer output, File input, long offset, long len) throws UncheckedIOException {
        return IOUtil.write(output, input, offset, len, false);
    }

    public static long write(Writer output, File input, boolean flush) throws UncheckedIOException {
        return IOUtil.write(output, input, 0L, Long.MAX_VALUE, flush);
    }

    public static long write(Writer output, File input, long offset, long len, boolean flush) throws UncheckedIOException {
        long l;
        FileReader reader = null;
        try {
            reader = new FileReader(input);
            l = IOUtil.write(output, (Reader)reader, offset, len, flush);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(reader);
        return l;
    }

    public static void append(File out, byte[] bytes) throws UncheckedIOException {
        if (N.isNullOrEmpty(bytes)) {
            return;
        }
        IOUtil.append(out, bytes, 0, bytes.length);
    }

    public static void append(File out, byte[] bytes, int offset, int len) throws UncheckedIOException {
        if (len == 0 && N.len(bytes) >= offset) {
            return;
        }
        FileOutputStream os = null;
        try {
            if (!out.exists()) {
                out.createNewFile();
            }
            os = new FileOutputStream(out, true);
            IOUtil.write((OutputStream)os, bytes, offset, len);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    public static void append(File out, char[] chars) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.append(out, chars, 0, chars.length);
    }

    public static void append(File out, char[] chars, Charset charset) throws UncheckedIOException {
        if (N.isNullOrEmpty(chars)) {
            return;
        }
        IOUtil.append(out, chars, 0, chars.length, charset);
    }

    public static void append(File out, char[] chars, int offset, int len) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.append(out, chars, offset, len, Charsets.UTF_8);
    }

    public static void append(File out, char[] chars, int offset, int len, Charset charset) throws UncheckedIOException {
        if (len == 0 && N.len(chars) >= offset) {
            return;
        }
        IOUtil.append(out, IOUtil.chars2Bytes(chars, offset, len, charset));
    }

    public static void append(File output, CharSequence str) throws UncheckedIOException {
        IOUtil.append(output, str, Charsets.UTF_8);
    }

    public static void append(File output, CharSequence str, Charset charset) throws UncheckedIOException {
        char[] chs = IOUtil.toCharArray(str);
        IOUtil.append(output, chs, 0, chs.length, charset);
    }

    public static long append(File output, InputStream input) throws UncheckedIOException {
        return IOUtil.append(output, input, 0L, Long.MAX_VALUE);
    }

    public static long append(File output, InputStream input, long offset, long len) throws UncheckedIOException {
        long l;
        FileOutputStream os = null;
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            os = new FileOutputStream(output, true);
            long result = IOUtil.write((OutputStream)os, input, offset, len);
            os.flush();
            l = result;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
        return l;
    }

    public static long append(File output, Reader input) throws UncheckedIOException {
        return IOUtil.append(output, input, Charsets.UTF_8);
    }

    public static long append(File output, Reader input, Charset charset) throws UncheckedIOException {
        return IOUtil.append(output, input, 0L, Long.MAX_VALUE, charset);
    }

    public static long append(File output, Reader input, long offset, long len) throws UncheckedIOException {
        return IOUtil.append(output, input, offset, len, Charsets.UTF_8);
    }

    public static long append(File output, Reader input, long offset, long len, Charset charset) throws UncheckedIOException {
        long l;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output, true), charset == null ? Charsets.UTF_8 : charset);
            long result = IOUtil.write((Writer)writer, input, offset, len);
            ((Writer)writer).flush();
            l = result;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
        return l;
    }

    public static long append(File output, File input) throws UncheckedIOException {
        return IOUtil.append(output, input, 0L, Long.MAX_VALUE);
    }

    public static long append(File output, File input, long offset, long len) throws UncheckedIOException {
        long l;
        FileOutputStream os = null;
        FileInputStream is = null;
        try {
            os = new FileOutputStream(output, true);
            is = new FileInputStream(input);
            l = IOUtil.write((OutputStream)os, is, offset, len, true);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(os);
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(os);
        IOUtil.closeQuietly(is);
        return l;
    }

    public static void appendLine(File output, CharSequence str) throws UncheckedIOException {
        IOUtil.appendLine(output, str, Charsets.UTF_8);
    }

    public static void appendLine(File output, CharSequence str, Charset charset) throws UncheckedIOException {
        char[] chs = IOUtil.toCharArray(str + LINE_SEPARATOR);
        IOUtil.append(output, chs, 0, chs.length, charset);
    }

    public static long skip(InputStream input, long toSkip) throws UncheckedIOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (toSkip == 0L) {
            return 0L;
        }
        byte[] buf = Objectory.createByteArrayBuffer();
        try {
            long remain;
            long n;
            for (remain = toSkip; remain > 0L && (n = (long)IOUtil.read(input, buf, 0, (int)Math.min(remain, (long)buf.length))) >= 0L; remain -= n) {
            }
            n = toSkip - remain;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
        }
    }

    public static long skip(Reader input, long toSkip) throws UncheckedIOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (toSkip == 0L) {
            return 0L;
        }
        char[] buf = Objectory.createCharArrayBuffer();
        try {
            long remain;
            long n;
            for (remain = toSkip; remain > 0L && (n = (long)IOUtil.read(input, buf, 0, (int)Math.min(remain, (long)buf.length))) >= 0L; remain -= n) {
            }
            n = toSkip - remain;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
        }
    }

    public static void skipFully(InputStream input, long toSkip) throws UncheckedIOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtil.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new UncheckedIOException(new IOException("Bytes to skip: " + toSkip + " actual: " + skipped));
        }
    }

    public static void skipFully(Reader input, long toSkip) throws UncheckedIOException {
        long skipped = IOUtil.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new RuntimeException(new IOException("Chars to skip: " + toSkip + " actual: " + skipped));
        }
    }

    public static MappedByteBuffer map(File file) {
        N.checkArgNotNull(file);
        return IOUtil.map(file, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mode) throws UncheckedIOException {
        N.checkArgNotNull(file);
        N.checkArgNotNull(mode);
        if (!file.exists()) {
            throw new IllegalArgumentException(file.toString() + " is not found");
        }
        return IOUtil.map(file, mode, 0L, file.length());
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mode, long offset, long len) throws UncheckedIOException {
        MappedByteBuffer mappedByteBuffer;
        N.checkArgNotNull(file);
        N.checkArgNotNull(mode);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, mode == FileChannel.MapMode.READ_ONLY ? "r" : "rw");
            mappedByteBuffer = raf.getChannel().map(mode, offset, len);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(raf);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(raf);
        return mappedByteBuffer;
    }

    public static String simplifyPath(String pathname) {
        if (N.isNullOrEmpty(pathname)) {
            return ".";
        }
        pathname = pathname.replace('\\', '/');
        String[] components = pathSplitter.splitToArray(pathname);
        ArrayList<String> path = new ArrayList<String>();
        for (String component : components) {
            if (component.length() == 0 || component.equals(".")) continue;
            if (component.equals("..")) {
                if (path.size() > 0 && !((String)path.get(path.size() - 1)).equals("..")) {
                    path.remove(path.size() - 1);
                    continue;
                }
                path.add("..");
                continue;
            }
            path.add(component);
        }
        String result = StringUtil.join(path, '/');
        if (pathname.charAt(0) == '/') {
            result = "/" + result;
        }
        while (result.startsWith("/../")) {
            result = result.substring(3);
        }
        if (result.equals("/..")) {
            result = "/";
        } else if ("".equals(result)) {
            result = ".";
        }
        return result;
    }

    public static String getFileExtension(String fullName) {
        N.checkArgNotNull(fullName);
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String getNameWithoutExtension(String file) {
        N.checkArgNotNull(file);
        String fileName = new File(file).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    static java.io.BufferedReader newBufferedReader(String filePath) throws UncheckedIOException {
        return IOUtil.newBufferedReader(new File(filePath));
    }

    public static java.io.BufferedReader newBufferedReader(File file) throws UncheckedIOException {
        try {
            return new java.io.BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static java.io.BufferedReader newBufferedReader(File file, Charset charset) throws UncheckedIOException {
        try {
            return new java.io.BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset == null ? Charsets.UTF_8 : charset));
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static java.io.BufferedReader newBufferedReader(Path path) throws UncheckedIOException {
        try {
            return Files.newBufferedReader(path, Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static java.io.BufferedReader newBufferedReader(Path path, Charset charset) throws UncheckedIOException {
        try {
            return Files.newBufferedReader(path, charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static java.io.BufferedReader newBufferedReader(InputStream is) throws UncheckedIOException {
        return new java.io.BufferedReader(new InputStreamReader(is));
    }

    public static java.io.BufferedReader newBufferedReader(InputStream is, Charset charset) throws UncheckedIOException {
        return new java.io.BufferedReader(new InputStreamReader(is, charset == null ? Charsets.UTF_8 : charset));
    }

    static java.io.BufferedWriter newBufferedWriter(String filePath) throws UncheckedIOException {
        return IOUtil.newBufferedWriter(new File(filePath));
    }

    public static java.io.BufferedWriter newBufferedWriter(File file) throws UncheckedIOException {
        try {
            return new java.io.BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static java.io.BufferedWriter newBufferedWriter(File file, Charset charset) throws UncheckedIOException {
        try {
            return new java.io.BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset == null ? Charsets.UTF_8 : charset));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static java.io.BufferedWriter newBufferedWriter(OutputStream os) throws UncheckedIOException {
        return new java.io.BufferedWriter(new OutputStreamWriter(os));
    }

    public static java.io.BufferedWriter newBufferedWriter(OutputStream os, Charset charset) throws UncheckedIOException {
        return new java.io.BufferedWriter(new OutputStreamWriter(os, charset == null ? Charsets.UTF_8 : charset));
    }

    public static LZ4BlockInputStream newLZ4BlockInputStream(InputStream is) throws UncheckedIOException {
        try {
            return new LZ4BlockInputStream(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static LZ4BlockOutputStream newLZ4BlockOutputStream(OutputStream os) throws UncheckedIOException {
        try {
            return new LZ4BlockOutputStream(os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static LZ4BlockOutputStream newLZ4BlockOutputStream(OutputStream os, int blockSize) throws UncheckedIOException {
        try {
            return new LZ4BlockOutputStream(os, blockSize);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SnappyInputStream newSnappyInputStream(InputStream is) throws UncheckedIOException {
        try {
            return new SnappyInputStream(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SnappyOutputStream newSnappyOutputStream(OutputStream os) throws UncheckedIOException {
        try {
            return new SnappyOutputStream(os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SnappyOutputStream newSnappyOutputStream(OutputStream os, int bufferSize) throws UncheckedIOException {
        try {
            return new SnappyOutputStream(os, bufferSize);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static GZIPInputStream newGZIPInputStream(InputStream is) throws UncheckedIOException {
        try {
            return new GZIPInputStream(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static GZIPInputStream newGZIPInputStream(InputStream is, int bufferSize) throws UncheckedIOException {
        try {
            return new GZIPInputStream(is, bufferSize);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static GZIPOutputStream newGZIPOutputStream(OutputStream os) throws UncheckedIOException {
        try {
            return new GZIPOutputStream(os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static GZIPOutputStream newGZIPOutputStream(OutputStream os, int bufferSize) throws UncheckedIOException {
        try {
            return new GZIPOutputStream(os, bufferSize);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw N.toRuntimeException(e);
            }
        }
    }

    @SafeVarargs
    public static void closeAll(AutoCloseable ... a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        IOUtil.closeAll(Arrays.asList(a));
    }

    public static void closeAll(Collection<? extends AutoCloseable> c) {
        if (N.isNullOrEmpty(c)) {
            return;
        }
        Exception ex = null;
        for (AutoCloseable autoCloseable : c) {
            try {
                IOUtil.close(autoCloseable);
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw N.toRuntimeException(ex);
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.error("Failed to close", (Throwable)e);
            }
        }
    }

    @SafeVarargs
    public static void closeAllQuietly(AutoCloseable ... a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        IOUtil.closeAllQuietly(Arrays.asList(a));
    }

    public static void closeAllQuietly(Collection<? extends AutoCloseable> c) {
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (AutoCloseable autoCloseable : c) {
            IOUtil.closeQuietly(autoCloseable);
        }
    }

    public static void copy(File srcFile, File destDir) {
        IOUtil.copy(srcFile, destDir, true);
    }

    public static void copy(File srcFile, File destDir, boolean preserveFileDate) {
        IOUtil.copy(srcFile, destDir, preserveFileDate, Fn.BiPredicates.alwaysTrue());
    }

    public static <E extends Exception> void copy(File srcFile, File destDir, boolean preserveFileDate, Try.BiPredicate<? super File, ? super File, E> filter) throws UncheckedIOException, E {
        if (!srcFile.exists()) {
            throw new IllegalArgumentException("The source file doesn't exist: " + srcFile.getAbsolutePath());
        }
        if (destDir.exists()) {
            if (destDir.isFile()) {
                throw new IllegalArgumentException("The destination file must be directory: " + destDir.getAbsolutePath());
            }
        } else if (!destDir.mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create destination directory: " + destDir.getAbsolutePath()));
        }
        if (!destDir.canWrite()) {
            throw new UncheckedIOException(new IOException("Destination '" + destDir + "' cannot be written to"));
        }
        String destCanonicalPath = null;
        String srcCanonicalPath = null;
        try {
            srcFile = srcFile.getCanonicalFile();
            destDir = destDir.getCanonicalFile();
            destCanonicalPath = destDir.getCanonicalPath();
            srcCanonicalPath = srcFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (srcFile.isDirectory()) {
            if (destCanonicalPath.startsWith(srcCanonicalPath) && (destCanonicalPath.length() == srcCanonicalPath.length() || destCanonicalPath.charAt(srcCanonicalPath.length()) == '/' || destCanonicalPath.charAt(srcCanonicalPath.length()) == '\\')) {
                throw new IllegalArgumentException("Failed to copy due to the target directory: " + destCanonicalPath + " is in or same as the source directory: " + srcCanonicalPath);
            }
            try {
                IOUtil.doCopyDirectory(srcFile, destDir, preserveFileDate, filter);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        File destFile = null;
        try {
            destFile = destDir.getCanonicalPath().equals(srcFile.getParentFile().getCanonicalPath()) ? new File(destDir, "Copy of " + srcFile.getName()) : new File(destDir, srcFile.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        IOUtil.doCopyFile(srcFile, destFile, preserveFileDate);
    }

    private static <E extends Exception> void doCopyDirectory(File srcDir, File destDir, boolean preserveFileDate, Try.BiPredicate<? super File, ? super File, E> filter) throws IOException, E {
        Object[] subFiles;
        if (destDir.exists()) {
            if (destDir.isFile()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (N.isNullOrEmpty(subFiles = srcDir.listFiles())) {
            return;
        }
        for (Object subFile : subFiles) {
            File dest;
            if (subFile == null) continue;
            if (filter == null || filter.test(srcDir, (File)subFile)) {
                dest = new File(destDir, ((File)subFile).getName());
                if (((File)subFile).isDirectory()) {
                    IOUtil.doCopyDirectory((File)subFile, dest, preserveFileDate, Fn.BiPredicates.alwaysTrue());
                    continue;
                }
                IOUtil.doCopyFile((File)subFile, dest, preserveFileDate);
                continue;
            }
            if (!((File)subFile).isDirectory()) continue;
            dest = new File(destDir, ((File)subFile).getName());
            IOUtil.doCopyDirectory((File)subFile, dest, preserveFileDate, filter);
        }
        if (preserveFileDate) {
            destDir.setLastModified(srcDir.lastModified());
        }
    }

    private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) {
        if (destFile.exists()) {
            throw new IllegalArgumentException("The destination file already existed: " + destFile.getAbsolutePath());
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > 0x2000000L ? 0x2000000L : size - pos;
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(output);
                IOUtil.close(fos);
                IOUtil.close(input);
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close(output);
        IOUtil.close(fos);
        IOUtil.close(input);
        IOUtil.close(fis);
        if (srcFile.length() != destFile.length()) {
            IOUtil.deleteAllIfExists(destFile);
            throw new UncheckedIOException(new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'"));
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    @SafeVarargs
    public static Path copy(Path source, Path target, CopyOption ... options) throws UncheckedIOException {
        try {
            return Files.copy(source, target, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SafeVarargs
    public static long copy(InputStream in, Path target, CopyOption ... options) throws UncheckedIOException {
        try {
            return Files.copy(in, target, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long copy(Path source, OutputStream out) throws UncheckedIOException {
        try {
            return Files.copy(source, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyURLToFile(URL source, File destination) throws UncheckedIOException {
        InputStream is = null;
        try {
            is = source.openStream();
            IOUtil.write(destination, is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtil.close(is);
        }
    }

    public static void copyURLToFile(URL source, File destination, int connectionTimeout, int readTimeout) throws UncheckedIOException {
        InputStream is = null;
        try {
            URLConnection connection = source.openConnection();
            connection.setConnectTimeout(connectionTimeout);
            connection.setReadTimeout(readTimeout);
            is = connection.getInputStream();
            IOUtil.write(destination, is);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
    }

    public static void move(File srcFile, File destDir) throws UncheckedIOException {
        File destFile;
        if (!srcFile.exists()) {
            throw new IllegalArgumentException("The source file doesn't exist: " + srcFile.getAbsolutePath());
        }
        if (destDir.exists()) {
            if (destDir.isFile()) {
                throw new IllegalArgumentException("The destination file must be directory: " + destDir.getAbsolutePath());
            }
        } else if (!destDir.mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create destination directory: " + destDir.getAbsolutePath()));
        }
        if (!srcFile.renameTo(destFile = new File(destDir, srcFile.getName()))) {
            throw new UncheckedIOException(new IOException("Failed to move file from: " + srcFile.getAbsolutePath() + " to: " + destDir.getAbsolutePath()));
        }
    }

    public static boolean renameTo(File srcFile, String newFileName) {
        return srcFile.renameTo(new File(srcFile.getParent() + FILE_SEPARATOR + newFileName));
    }

    public static boolean deleteIfExists(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        return file.delete();
    }

    public static boolean deleteAllIfExists(File file) {
        Object[] files;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory() && N.notNullOrEmpty(files = file.listFiles())) {
            for (Object subFile : files) {
                if (subFile == null || !(((File)subFile).isFile() ? !((File)subFile).delete() : !IOUtil.deleteAllIfExists((File)subFile))) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean deleteFiles(File dir) {
        return IOUtil.deleteFiles(dir, Fn.BiPredicates.alwaysTrue());
    }

    public static <E extends Exception> boolean deleteFiles(File dir, Try.BiPredicate<? super File, ? super File, E> filter) throws E {
        if (dir == null || !dir.exists()) {
            return false;
        }
        if (dir.isDirectory()) {
            Object[] files = dir.listFiles();
            if (N.isNullOrEmpty(files)) {
                return true;
            }
            for (Object subFile : files) {
                if (subFile == null || !(filter == null || filter.test(dir, (File)subFile) ? (((File)subFile).isFile() ? !((File)subFile).delete() : !IOUtil.deleteAllIfExists((File)subFile)) : ((File)subFile).isDirectory() && !IOUtil.deleteFiles((File)subFile, filter))) continue;
                return false;
            }
        } else if (filter == null || filter.test(dir.getParentFile(), dir)) {
            return dir.delete();
        }
        return true;
    }

    public static boolean createIfNotExists(File file) throws UncheckedIOException {
        try {
            return file.exists() ? false : file.createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void zip(File sourceFile, File targetFile) throws UncheckedIOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(targetFile));
            IOUtil.zipFile(sourceFile, zos, targetFile);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(zos);
                throw throwable;
            }
        }
        IOUtil.close(zos);
    }

    public static void zip(Collection<File> sourceFiles, File targetFile) throws UncheckedIOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(targetFile));
            for (File sourceFile : sourceFiles) {
                IOUtil.zipFile(sourceFile, zos, targetFile);
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(zos);
                throw throwable;
            }
        }
        IOUtil.close(zos);
    }

    private static void zipFile(File sourceFile, ZipOutputStream zos, File targetFile) throws IOException, FileNotFoundException {
        if (sourceFile.isFile()) {
            IOUtil.zipFile(sourceFile, null, zos, targetFile);
        } else {
            List<File> subFileList = IOUtil.listFiles(sourceFile, true, true);
            for (File subFile : subFileList) {
                IOUtil.zipFile(subFile, sourceFile, zos, targetFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File file, File sourceDir, ZipOutputStream zos, File targetFile) throws IOException, FileNotFoundException {
        if (file.equals(targetFile)) {
            return;
        }
        ZipEntry ze = null;
        String relativeFileName = null;
        relativeFileName = sourceDir == null ? file.getName() : IOUtil.getRelativePath(sourceDir, file);
        ze = new ZipEntry(relativeFileName);
        ze.setSize(file.length());
        ze.setTime(file.lastModified());
        zos.putNextEntry(ze);
        FileInputStream is = new FileInputStream(file);
        byte[] buf = Objectory.createByteArrayBuffer();
        try {
            int count = 0;
            while (-1 != (count = IOUtil.read(is, buf, 0, buf.length))) {
                zos.write(buf, 0, count);
            }
        }
        finally {
            Objectory.recycle(buf);
            IOUtil.closeQuietly(is);
        }
    }

    public static void unzip(File srcZipFile, File targetDir) {
        ZipFile zip = null;
        ZipEntry ze = null;
        FileOutputStream os = null;
        InputStream is = null;
        byte[] buf = Objectory.createByteArrayBuffer();
        int bufLength = buf.length;
        try {
            zip = new ZipFile(srcZipFile);
            Enumeration<? extends ZipEntry> entryEnum = zip.entries();
            while (entryEnum.hasMoreElements()) {
                ze = entryEnum.nextElement();
                if (ze.isDirectory()) continue;
                os = new FileOutputStream(IOUtil.getAbsolutePath(targetDir, ze.getName()));
                is = zip.getInputStream(ze);
                int count = 0;
                while (-1 != (count = IOUtil.read(is, buf, 0, bufLength))) {
                    ((OutputStream)os).write(buf, 0, count);
                }
                os.flush();
                IOUtil.closeQuietly(is);
                is = null;
                IOUtil.close(os);
                os = null;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
            IOUtil.closeQuietly(zip);
            IOUtil.closeQuietly(is);
            IOUtil.close(os);
        }
    }

    public static void split(File file, int countOfParts) throws UncheckedIOException {
        IOUtil.split(file, countOfParts, file.getParentFile());
    }

    public static void split(File file, int countOfParts, File destDir) throws UncheckedIOException {
        long sizeOfPart = file.length() % (long)countOfParts == 0L ? file.length() / (long)countOfParts : file.length() / (long)countOfParts + 1L;
        IOUtil.splitBySize(file, sizeOfPart, destDir);
    }

    public static void splitBySize(File file, long sizeOfPart) throws UncheckedIOException {
        IOUtil.splitBySize(file, sizeOfPart, file.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitBySize(File file, long sizeOfPart, File destDir) throws UncheckedIOException {
        int numOfParts = (int)(file.length() % sizeOfPart == 0L ? file.length() / sizeOfPart : file.length() / sizeOfPart + 1L);
        String fileName = file.getName();
        long fileLength = file.length();
        int fileSerNum = 1;
        byte[] buf = Objectory.createByteArrayBuffer();
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(file);
            for (int i = 0; i < numOfParts; ++i) {
                String subFileNmae = destDir.getAbsolutePath() + FILE_SEPARATOR + fileName + "_" + StringUtil.padStart(N.stringOf(fileSerNum++), 4, '0');
                output = new FileOutputStream(new File(subFileNmae));
                long partLength = sizeOfPart;
                if (i == numOfParts - 1) {
                    partLength += fileLength % (long)numOfParts;
                }
                int count = 0;
                try {
                    while (partLength > 0L && -1 != (count = IOUtil.read(input, buf, 0, (int)Math.min((long)buf.length, partLength)))) {
                        ((OutputStream)output).write(buf, 0, count);
                        partLength -= (long)count;
                    }
                    output.flush();
                    continue;
                }
                finally {
                    IOUtil.close(output);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
            IOUtil.closeQuietly(input);
        }
    }

    static void splitByLine(File file, int numOfParts) throws UncheckedIOException {
        IOUtil.splitByLine(file, numOfParts, file.getParentFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void splitByLine(File file, int numOfParts, File destDir) throws UncheckedIOException {
        BufferedReader br;
        InputStream is;
        u.Holder<ZipFile> outputZipFile;
        block8: {
            long lineNumOfPart = IOUtil.estimateLineCount(file, 10000) / (long)numOfParts;
            int index = file.getName().lastIndexOf(46);
            String prefix = file.getName().substring(0, index);
            String postfix = index > 0 ? file.getName().substring(index) : "";
            outputZipFile = new u.Holder<ZipFile>();
            is = null;
            br = null;
            BufferedWriter bw = null;
            int fileSerNum = 1;
            try {
                is = IOUtil.openFile(outputZipFile, file);
                br = Objectory.createBufferedReader(is);
                String subFileNmae = destDir.getAbsolutePath() + FILE_SEPARATOR + prefix + "_" + StringUtil.padStart(N.stringOf(fileSerNum++), 4, '0') + postfix;
                bw = Objectory.createBufferedWriter(new FileWriter(new File(subFileNmae)));
                int lineCounter = 0;
                String line = null;
                while ((line = br.readLine()) != null) {
                    bw.write(line);
                    bw.write(LINE_SEPARATOR);
                    if ((long)(++lineCounter) % lineNumOfPart != 0L) continue;
                    if (bw != null) {
                        IOUtil.close(bw);
                        Objectory.recycle(bw);
                        bw = null;
                    }
                    subFileNmae = destDir.getAbsolutePath() + FILE_SEPARATOR + prefix + "_" + StringUtil.padStart(N.stringOf(fileSerNum++), 4, '0') + postfix;
                    bw = Objectory.createBufferedWriter(new FileWriter(new File(subFileNmae)));
                }
                if (bw != null) {
                    IOUtil.close(bw);
                    Objectory.recycle(bw);
                    bw = null;
                }
                if (bw == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException(e);
                }
                catch (Throwable throwable) {
                    if (bw != null) {
                        IOUtil.close(bw);
                        Objectory.recycle(bw);
                    }
                    IOUtil.closeQuietly(is);
                    IOUtil.close((AutoCloseable)outputZipFile.value());
                    Objectory.recycle(br);
                    throw throwable;
                }
            }
            IOUtil.close(bw);
            Objectory.recycle(bw);
        }
        IOUtil.closeQuietly(is);
        IOUtil.close((AutoCloseable)outputZipFile.value());
        Objectory.recycle(br);
    }

    private static long estimateLineCount(File file, int byReadingLineNum) throws UncheckedIOException {
        u.Holder<ZipFile> outputZipFile = new u.Holder<ZipFile>();
        InputStream is = null;
        BufferedReader br = null;
        try {
            int cnt;
            is = IOUtil.openFile(outputZipFile, file);
            br = Objectory.createBufferedReader(is);
            String line = null;
            long bytes = 0L;
            for (cnt = 0; cnt < byReadingLineNum && (line = br.readLine()) != null; ++cnt) {
                bytes += (long)line.getBytes().length;
            }
            long l = cnt == 0 ? 0L : file.length() / (bytes / (long)cnt == 0L ? 1L : bytes / (long)cnt);
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtil.closeQuietly(is);
            IOUtil.closeQuietly((AutoCloseable)outputZipFile.value());
            Objectory.recycle(br);
        }
    }

    public static long merge(File[] sourceFiles, File destFile) throws UncheckedIOException {
        return IOUtil.merge(N.asList(sourceFiles), destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long merge(Collection<File> sourceFiles, File destFile) throws UncheckedIOException {
        byte[] buf = Objectory.createByteArrayBuffer();
        long totalCount = 0L;
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(destFile);
            FileInputStream input = null;
            for (File file : sourceFiles) {
                try {
                    input = new FileInputStream(file);
                    int count = 0;
                    while (-1 != (count = IOUtil.read(input, buf, 0, buf.length))) {
                        ((OutputStream)output).write(buf, 0, count);
                        totalCount += (long)count;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(input);
                    throw throwable;
                }
                IOUtil.close(input);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(buf);
            IOUtil.close(output);
        }
        return totalCount;
    }

    private static String getAbsolutePath(File parentDir, String relativeFilePath) throws IOException {
        String newRelativePath = "";
        for (int i = 0; i < relativeFilePath.length(); ++i) {
            char c = relativeFilePath.charAt(i);
            newRelativePath = c == '\\' || c == '/' ? newRelativePath + File.separator : newRelativePath + c;
        }
        relativeFilePath = newRelativePath;
        String path = parentDir.getAbsolutePath() + File.separator + relativeFilePath;
        File dir = new File(path.substring(0, path.lastIndexOf(File.separator)));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    private static String getRelativePath(File parentDir, File file) {
        if (file.equals(parentDir)) {
            return file.getName();
        }
        return file.getAbsolutePath().substring(parentDir.getAbsolutePath().length() + 1);
    }

    public static List<String> list(File parentPath) {
        return IOUtil.list(parentPath, false, false);
    }

    public static List<String> list(File parentPath, boolean recursively, boolean excludeDirectory) {
        return IOUtil.list(parentPath, recursively, excludeDirectory ? directories_excluded_filter : all_files_filter);
    }

    public static <E extends Exception> List<String> list(File parentPath, boolean recursively, Try.BiPredicate<? super File, ? super File, E> filter) throws E {
        ArrayList<String> files = new ArrayList<String>();
        if (!parentPath.exists()) {
            return files;
        }
        Object[] subFiles = (parentPath = new File(parentPath.getAbsolutePath().replace(".\\", "\\").replace("./", "/"))).listFiles();
        if (N.isNullOrEmpty(subFiles)) {
            return files;
        }
        for (Object file : subFiles) {
            if (filter.test(parentPath, (File)file)) {
                files.add(((File)file).getAbsolutePath());
            }
            if (!recursively || !((File)file).isDirectory()) continue;
            files.addAll(IOUtil.list((File)file, recursively, filter));
        }
        return files;
    }

    public static List<File> listFiles(File parentPath) {
        return IOUtil.listFiles(parentPath, false, false);
    }

    public static List<File> listFiles(File parentPath, boolean recursively, boolean excludeDirectory) {
        return IOUtil.listFiles(parentPath, recursively, excludeDirectory ? directories_excluded_filter : all_files_filter);
    }

    public static <E extends Exception> List<File> listFiles(File parentPath, boolean recursively, Try.BiPredicate<? super File, ? super File, E> filter) throws E {
        ArrayList<File> files = new ArrayList<File>();
        if (!parentPath.exists()) {
            return files;
        }
        Object[] subFiles = parentPath.listFiles();
        if (N.isNullOrEmpty(subFiles)) {
            return files;
        }
        for (Object file : subFiles) {
            if (filter.test(parentPath, (File)file)) {
                files.add((File)file);
            }
            if (!recursively || !((File)file).isDirectory()) continue;
            files.addAll(IOUtil.listFiles((File)file, recursively, filter));
        }
        return files;
    }

    public static List<File> listDirectories(File parentPath) {
        return IOUtil.listDirectories(parentPath, false);
    }

    public static List<File> listDirectories(File parentPath, boolean recursively) {
        return IOUtil.listFiles(parentPath, recursively, directories_only_filter);
    }

    public static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("URL could not be converted to a File: " + url);
        }
        return new File(IOUtil.decodeUrl(url.getFile().replace('/', File.separatorChar)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String decodeUrl(String url) {
        String decoded = url;
        if (url != null && url.indexOf(37) >= 0) {
            int n = url.length();
            StringBuffer buffer = new StringBuffer();
            ByteBuffer bytes = ByteBuffer.allocate(n);
            int i = 0;
            while (i < n) {
                if (url.charAt(i) == '%') {
                    try {
                        do {
                            byte octet = (byte)Integer.parseInt(url.substring(i + 1, i + 3), 16);
                            bytes.put(octet);
                        } while ((i += 3) < n && url.charAt(i) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (bytes.position() <= 0) continue;
                        bytes.flip();
                        buffer.append(Charsets.UTF_8.decode(bytes).toString());
                        bytes.clear();
                        continue;
                    }
                }
                buffer.append(url.charAt(i++));
            }
            decoded = buffer.toString();
        }
        return decoded;
    }

    public static File[] toFiles(URL[] urls) throws UncheckedIOException {
        if (N.isNullOrEmpty(urls)) {
            return new File[0];
        }
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = IOUtil.toFile(urls[i]);
        }
        return files;
    }

    public static List<File> toFiles(Collection<URL> urls) throws UncheckedIOException {
        if (N.isNullOrEmpty(urls)) {
            return new ArrayList<File>();
        }
        ArrayList<File> files = new ArrayList<File>(urls.size());
        for (URL url : urls) {
            files.add(IOUtil.toFile(url));
        }
        return files;
    }

    public static URL toURL(File file) throws UncheckedIOException {
        try {
            return file.toURI().toURL();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL[] toURLs(File[] files) throws UncheckedIOException {
        if (N.isNullOrEmpty(files)) {
            return new URL[0];
        }
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return urls;
    }

    public static List<URL> toURLs(Collection<File> files) {
        if (N.isNullOrEmpty(files)) {
            return new ArrayList<URL>();
        }
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        try {
            for (File file : files) {
                urls.add(file.toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return urls;
    }

    public static boolean touch(File file) {
        return file.exists() && file.setLastModified(System.currentTimeMillis());
    }

    private static InputStream openFile(u.Holder<ZipFile> outputZipFile, File file) throws IOException {
        InputStream is = null;
        if (file.getName().endsWith(GZ)) {
            is = new GZIPInputStream(new FileInputStream(file));
        } else if (file.getName().endsWith(ZIP)) {
            ZipFile zf = new ZipFile(file);
            ZipEntry ze = zf.entries().nextElement();
            is = zf.getInputStream(ze);
            outputZipFile.setValue((Object)zf);
        } else {
            is = new FileInputStream(file);
        }
        return is;
    }

    private static char[] toCharArray(CharSequence str) {
        return str == null ? N.NULL_CHAR_ARRAY : StringUtil.getCharsForReadOnly(str instanceof String ? (String)str : str.toString());
    }

    static {
        boolean IS_PLATFORM_ANDROID;
        logger = LoggerFactory.getLogger(IOUtil.class);
        pathSplitter = Splitter.with('/').trim(true);
        Method encodeMethod = null;
        Method decodeMethod = null;
        try {
            Class cls = ClassUtil.forClass("java.lang.StringCoding");
            Method enMethod = ClassUtil.getDeclaredMethod(cls, "encode", Charset.class, char[].class, Integer.TYPE, Integer.TYPE);
            Method deMethod = ClassUtil.getDeclaredMethod(cls, "decode", Charset.class, byte[].class, Integer.TYPE, Integer.TYPE);
            if (enMethod != null && deMethod != null) {
                enMethod.setAccessible(true);
                deMethod.setAccessible(true);
                char[] chars = "abc".toCharArray();
                byte[] bytes = (byte[])ClassUtil.invokeMethod(enMethod, Charsets.UTF_8, chars, 1, 1);
                char[] chars2 = (char[])ClassUtil.invokeMethod(deMethod, Charsets.UTF_8, bytes, 0, bytes.length);
                if (chars2.length == 1 && chars2[0] == 'b') {
                    encodeMethod = enMethod;
                    decodeMethod = deMethod;
                }
            }
        }
        catch (Exception cls) {
            // empty catch block
        }
        stringEncodeMethod = encodeMethod;
        stringDecodeMethod = decodeMethod;
        String hostName = null;
        boolean bl = IS_PLATFORM_ANDROID = System.getProperty("java.vendor").toUpperCase().contains("ANDROID") || System.getProperty("java.vm.vendor").toUpperCase().contains("ANDROID");
        if (IS_PLATFORM_ANDROID) {
            try {
                hostName = Executors.newSingleThreadExecutor().submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return InetAddress.getLocalHost().getHostName();
                    }
                }).get();
            }
            catch (Exception e) {
                logger.error("Failed to get host name");
            }
        } else {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                logger.error("Failed to get host name");
            }
        }
        HOST_NAME = hostName;
        CPU_CORES = Runtime.getRuntime().availableProcessors();
        MAX_MEMORY_IN_MB = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        OS_NAME = System.getProperty("os.name");
        OS_VERSION = System.getProperty("os.version");
        OS_ARCH = System.getProperty("os.arch");
        IS_OS_WINDOWS = OS_NAME.toUpperCase().contains("WINDOWS");
        IS_OS_MAC = OS_NAME.toUpperCase().contains("MAC");
        IS_OS_MAC_OSX = OS_NAME.toUpperCase().contains("MAC OS X");
        IS_OS_LINUX = OS_NAME.toUpperCase().contains("LINUX");
        IOUtil.IS_PLATFORM_ANDROID = System.getProperty("java.vendor").toUpperCase().contains("ANDROID") || System.getProperty("java.vm.vendor").toUpperCase().contains("ANDROID");
        JAVA_HOME = System.getProperty("java.home");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_CLASS_PATH = System.getProperty("java.class.path");
        JAVA_CLASS_VERSION = System.getProperty("java.class.version");
        JAVA_RUNTIME_NAME = System.getProperty("java.runtime.name");
        JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
        JAVA_SPECIFICATION_NAME = System.getProperty("java.specification.name");
        JAVA_SPECIFICATION_VENDOR = System.getProperty("java.specification.vendor");
        JAVA_SPECIFICATION_VERSION = System.getProperty("java.specification.version");
        JAVA_VM_INFO = System.getProperty("java.vm.info");
        JAVA_VM_NAME = System.getProperty("java.vm.name");
        JAVA_VM_SPECIFICATION_NAME = System.getProperty("java.vm.specification.name");
        JAVA_VM_SPECIFICATION_VENDOR = System.getProperty("java.vm.specification.vendor");
        JAVA_VM_SPECIFICATION_VERSION = System.getProperty("java.vm.specification.version");
        JAVA_VM_VENDOR = System.getProperty("java.vm.vendor");
        JAVA_VM_VERSION = System.getProperty("java.vm.version");
        JAVA_IO_TMPDIR = System.getProperty("java.io.tmpdir");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_LIBRARY_PATH = System.getProperty("java.library.path");
        JAVA_COMPILER = System.getProperty("java.compiler");
        JAVA_ENDORSED_DIRS = System.getProperty("java.endorsed.dirs");
        JAVA_EXT_DIRS = System.getProperty("java.ext.dirs");
        JAVA_AWT_FONTS = System.getProperty("java.awt.fonts");
        JAVA_AWT_GRAPHICSENV = System.getProperty("java.awt.graphicsenv");
        JAVA_AWT_HEADLESS = System.getProperty("java.awt.headless");
        JAVA_AWT_PRINTERJOB = System.getProperty("java.awt.printerjob");
        JAVA_UTIL_PREFS_PREFERENCES_FACTORY = System.getProperty("java.util.prefs.PreferencesFactory");
        USER_DIR = System.getProperty("user.dir");
        USER_HOME = System.getProperty("user.home");
        USER_NAME = System.getProperty("user.name");
        USER_TIMEZONE = System.getProperty("user.timezone");
        USER_LANGUAGE = System.getProperty("user.language");
        USER_COUNTRY = System.getProperty("user.country") == null ? System.getProperty("user.region") : System.getProperty("user.country");
        String path = new File("./").getAbsolutePath();
        CURRENT_PATH = path.charAt(path.length() - 1) == '.' ? path.substring(0, path.length() - 1) : path;
        PATH_SEPARATOR = System.getProperty("path.separator");
        FILE_SEPARATOR = System.getProperty("file.separator");
        LINE_SEPARATOR = System.getProperty("line.separator");
        all_files_filter = new BiPredicate<File, File>(){

            @Override
            public boolean test(File parentDir, File file) {
                return true;
            }
        };
        directories_excluded_filter = new BiPredicate<File, File>(){

            @Override
            public boolean test(File parentDir, File file) {
                return !file.isDirectory();
            }
        };
        directories_only_filter = new BiPredicate<File, File>(){

            @Override
            public boolean test(File parentDir, File file) {
                return file.isDirectory();
            }
        };
    }
}

