/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class IdentityHashSet<T>
extends AbstractSet<T> {
    private static final Object VAL = new Object();
    private final IdentityHashMap<T, Object> map;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(int initialCapacity) {
        this.map = new IdentityHashMap(initialCapacity);
    }

    public IdentityHashSet(Collection<? extends T> c) {
        this.map = new IdentityHashMap(N.size(c));
        this.addAll(c);
    }

    @Override
    public boolean add(T e) {
        return this.map.put(e, VAL) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            return true;
        }
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                if (!this.add(e)) continue;
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        if (N.notNullOrEmpty(c)) {
            for (Object e : c) {
                if (!this.remove(e)) continue;
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            if (this.map.size() > 0) {
                this.map.clear();
                return true;
            }
        } else {
            IdentityHashSet kept = new IdentityHashSet(N.min(c.size(), this.size()));
            for (Object e : c) {
                if (!this.contains(e)) continue;
                kept.add((T)e);
            }
            if (kept.size() < this.size()) {
                this.clear();
                this.addAll(kept);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

