/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.N;
import java.util.Map;

public final class ImmutableBiMap<K, V>
extends ImmutableMap<K, V> {
    private static final ImmutableBiMap EMPTY = new ImmutableBiMap(new BiMap());
    private final BiMap<K, V> biMap;

    ImmutableBiMap(BiMap<? extends K, ? extends V> map) {
        super(map);
        this.biMap = map;
    }

    public static <K, V> ImmutableBiMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V, k extends K, v extends V> ImmutableBiMap<K, V> of(k k1, v v1) {
        BiMap biMap = BiMap.of(k1, v1);
        return new ImmutableBiMap(biMap);
    }

    public static <K, V, k extends K, v extends V> ImmutableBiMap<K, V> of(k k1, v v1, k k2, v v2) {
        BiMap biMap = BiMap.of(k1, v1, k2, v2);
        return new ImmutableBiMap(biMap);
    }

    public static <K, V, k extends K, v extends V> ImmutableBiMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3) {
        BiMap biMap = BiMap.of(k1, v1, k2, v2, k3, v3);
        return new ImmutableBiMap(biMap);
    }

    public static <K, V, k extends K, v extends V> ImmutableBiMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4) {
        BiMap biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
        return new ImmutableBiMap(biMap);
    }

    public static <K, V, k extends K, v extends V> ImmutableBiMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5) {
        BiMap biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        return new ImmutableBiMap(biMap);
    }

    public static <K, V, k extends K, v extends V> ImmutableBiMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6) {
        BiMap biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        return new ImmutableBiMap(biMap);
    }

    public static <K, V, k extends K, v extends V> ImmutableBiMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6, k k7, v v7) {
        BiMap biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        return new ImmutableBiMap(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(BiMap<? extends K, ? extends V> map) {
        if (map == null) {
            return ImmutableBiMap.empty();
        }
        return new ImmutableBiMap<K, V>(map);
    }

    public static <K, V> ImmutableBiMap<K, V> copyOf(BiMap<? extends K, ? extends V> map) {
        if (N.isNullOrEmpty(map)) {
            return ImmutableBiMap.empty();
        }
        return new ImmutableBiMap<K, V>(map.copy());
    }

    @Deprecated
    public static <K, V> ImmutableMap<K, V> of(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    public K getByValue(Object value) {
        return this.biMap.getByValue(value);
    }
}

