/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class ImmutableMap<K, V>
implements Map<K, V> {
    private static final ImmutableMap EMPTY = new ImmutableMap(Collections.EMPTY_MAP);
    private final Map<K, V> map;

    ImmutableMap(Map<? extends K, ? extends V> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public static <K, V> ImmutableMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V, k extends K, v extends V> ImmutableMap<K, V> of(k k1, v v1) {
        return new ImmutableMap<k, v>(Collections.singletonMap(k1, v1));
    }

    public static <K, V, k extends K, v extends V> ImmutableMap<K, V> of(k k1, v v1, k k2, v v2) {
        Map map = N.asLinkedHashMap(k1, v1, k2, v2);
        return new ImmutableMap(map);
    }

    public static <K, V, k extends K, v extends V> ImmutableMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3) {
        Map map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3);
        return new ImmutableMap(map);
    }

    public static <K, V, k extends K, v extends V> ImmutableMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4) {
        Map map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4);
        return new ImmutableMap(map);
    }

    public static <K, V, k extends K, v extends V> ImmutableMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5) {
        Map map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        return new ImmutableMap(map);
    }

    public static <K, V, k extends K, v extends V> ImmutableMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6) {
        Map map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        return new ImmutableMap(map);
    }

    public static <K, V, k extends K, v extends V> ImmutableMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6, k k7, v v7) {
        Map map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        return new ImmutableMap(map);
    }

    public static <K, V> ImmutableMap<K, V> of(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return ImmutableMap.empty();
        }
        if (map instanceof ImmutableMap) {
            return (ImmutableMap)map;
        }
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        if (N.isNullOrEmpty(map)) {
            return ImmutableMap.empty();
        }
        AbstractMap tmp = map instanceof IdentityHashMap ? new IdentityHashMap<K, V>(map) : (map instanceof LinkedHashMap || map instanceof SortedMap ? new LinkedHashMap<K, V>(map) : new HashMap<K, V>(map));
        return new ImmutableMap<K, V>(tmp);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V val = this.get(key);
        return val == null && !this.containsKey(key) ? defaultValue : val;
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ImmutableMap && ((ImmutableMap)obj).map.equals(this.map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

