/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableSortedSet;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ImmutableNavigableSet<E>
extends ImmutableSortedSet<E>
implements NavigableSet<E> {
    private static final ImmutableNavigableSet EMPTY = new ImmutableNavigableSet(new TreeSet());
    private final NavigableSet<E> navigableSet;

    ImmutableNavigableSet(NavigableSet<? extends E> navigableSet) {
        super(navigableSet);
        this.navigableSet = navigableSet;
    }

    public static <E> ImmutableNavigableSet<E> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static <E extends Comparable<? super E>> ImmutableNavigableSet<E> of(E ... a) {
        if (N.isNullOrEmpty(a)) {
            return ImmutableNavigableSet.empty();
        }
        return new ImmutableNavigableSet<E>(new TreeSet<E>(Arrays.asList(a)));
    }

    public static <E> ImmutableNavigableSet<E> of(NavigableSet<? extends E> navigableSet) {
        if (navigableSet == null) {
            return ImmutableNavigableSet.empty();
        }
        if (navigableSet instanceof ImmutableNavigableSet) {
            return (ImmutableNavigableSet)navigableSet;
        }
        return new ImmutableNavigableSet<E>(navigableSet);
    }

    public static <E> ImmutableNavigableSet<E> copyOf(SortedSet<? extends E> sortedSet) {
        if (N.isNullOrEmpty(sortedSet)) {
            return ImmutableNavigableSet.empty();
        }
        return new ImmutableNavigableSet<E>(new TreeSet<E>(sortedSet));
    }

    @Deprecated
    public static <E> ImmutableSortedSet<E> of(SortedSet<? extends E> sortedSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E lower(E e) {
        return this.navigableSet.lower(e);
    }

    @Override
    public E floor(E e) {
        return this.navigableSet.floor(e);
    }

    @Override
    public E ceiling(E e) {
        return this.navigableSet.ceiling(e);
    }

    @Override
    public E higher(E e) {
        return this.navigableSet.higher(e);
    }

    @Override
    public E pollFirst() {
        return this.navigableSet.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.navigableSet.pollLast();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return ImmutableNavigableSet.of(this.navigableSet.descendingSet());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return ObjIterator.of(this.navigableSet.descendingIterator());
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return ImmutableNavigableSet.of(this.navigableSet.subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return ImmutableNavigableSet.of(this.navigableSet.headSet(toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return ImmutableNavigableSet.of(this.navigableSet.tailSet(fromElement, inclusive));
    }
}

