/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.N;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ImmutableSortedMap<K, V>
extends ImmutableMap<K, V>
implements SortedMap<K, V> {
    private static final ImmutableSortedMap EMPTY = new ImmutableSortedMap(new TreeMap());
    private final SortedMap<K, V> sortedMap;

    ImmutableSortedMap(SortedMap<? extends K, ? extends V> sortedMap) {
        super(sortedMap);
        this.sortedMap = sortedMap;
    }

    public static <K, V> ImmutableSortedMap<K, V> empty() {
        return EMPTY;
    }

    public static <K extends Comparable<? super K>, V, k extends K, v extends V> ImmutableSortedMap<K, V> of(k k1, v v1) {
        TreeMap<k, v> map = N.newTreeMap();
        map.put(k1, v1);
        return new ImmutableSortedMap(map);
    }

    public static <K extends Comparable<? super K>, V, k extends K, v extends V> ImmutableSortedMap<K, V> of(k k1, v v1, k k2, v v2) {
        TreeMap<k, v> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        return new ImmutableSortedMap(map);
    }

    public static <K extends Comparable<? super K>, V, k extends K, v extends V> ImmutableSortedMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3) {
        TreeMap<k, v> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return new ImmutableSortedMap(map);
    }

    public static <K extends Comparable<? super K>, V, k extends K, v extends V> ImmutableSortedMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4) {
        TreeMap<k, v> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return new ImmutableSortedMap(map);
    }

    public static <K extends Comparable<? super K>, V, k extends K, v extends V> ImmutableSortedMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5) {
        TreeMap<k, v> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return new ImmutableSortedMap(map);
    }

    public static <K extends Comparable<? super K>, V, k extends K, v extends V> ImmutableSortedMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6) {
        TreeMap<k, v> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return new ImmutableSortedMap(map);
    }

    public static <K extends Comparable<? super K>, V, k extends K, v extends V> ImmutableSortedMap<K, V> of(k k1, v v1, k k2, v v2, k k3, v v3, k k4, v v4, k k5, v v5, k k6, v v6, k k7, v v7) {
        TreeMap<k, v> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return new ImmutableSortedMap(map);
    }

    public static <K, V> ImmutableSortedMap<K, V> of(SortedMap<? extends K, ? extends V> sortedMap) {
        if (sortedMap == null) {
            return ImmutableSortedMap.empty();
        }
        if (sortedMap instanceof ImmutableSortedMap) {
            return (ImmutableSortedMap)sortedMap;
        }
        return new ImmutableSortedMap<K, V>(sortedMap);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(SortedMap<? extends K, ? extends V> sortedMap) {
        if (N.isNullOrEmpty(sortedMap)) {
            return ImmutableSortedMap.empty();
        }
        return new ImmutableSortedMap<K, V>(new TreeMap<K, V>(sortedMap));
    }

    @Deprecated
    public static <K, V> ImmutableMap<K, V> of(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.sortedMap.comparator();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return ImmutableSortedMap.of(this.sortedMap.subMap(fromKey, toKey));
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return ImmutableSortedMap.of(this.sortedMap.headMap(toKey));
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return ImmutableSortedMap.of(this.sortedMap.tailMap(fromKey));
    }

    @Override
    public K firstKey() {
        return this.sortedMap.firstKey();
    }

    @Override
    public K lastKey() {
        return this.sortedMap.lastKey();
    }
}

