/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.N;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ImmutableSortedSet<E>
extends ImmutableSet<E>
implements SortedSet<E> {
    private static final ImmutableSortedSet EMPTY = new ImmutableSortedSet(new TreeSet());
    private final SortedSet<E> sortedSet;

    ImmutableSortedSet(SortedSet<? extends E> sortedSet) {
        super(sortedSet);
        this.sortedSet = sortedSet;
    }

    public static <E> ImmutableSortedSet<E> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E ... a) {
        if (N.isNullOrEmpty(a)) {
            return ImmutableSortedSet.empty();
        }
        return new ImmutableSortedSet<E>(new TreeSet<E>(Arrays.asList(a)));
    }

    public static <E> ImmutableSortedSet<E> of(SortedSet<? extends E> sortedSet) {
        if (sortedSet == null) {
            return ImmutableSortedSet.empty();
        }
        if (sortedSet instanceof ImmutableSortedSet) {
            return (ImmutableSortedSet)sortedSet;
        }
        return new ImmutableSortedSet<E>(sortedSet);
    }

    public static <E> ImmutableSortedSet<E> copyOf(SortedSet<? extends E> sortedSet) {
        if (N.isNullOrEmpty(sortedSet)) {
            return ImmutableSortedSet.empty();
        }
        return new ImmutableSortedSet<E>(new TreeSet<E>(sortedSet));
    }

    @Deprecated
    public static <E> ImmutableSet<E> of(Set<? extends E> set) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.sortedSet.comparator();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return ImmutableSortedSet.of(this.sortedSet.subSet(fromElement, toElement));
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return ImmutableSortedSet.of(this.sortedSet.headSet(toElement));
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return ImmutableSortedSet.of(this.sortedSet.tailSet(fromElement));
    }

    @Override
    public E first() {
        return this.sortedSet.first();
    }

    @Override
    public E last() {
        return this.sortedSet.last();
    }
}

