/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.AbstractIndexed;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import java.util.Iterator;

public final class Indexed<T>
extends AbstractIndexed {
    private final T value;

    Indexed(long index, T value) {
        super(index);
        this.value = value;
    }

    public static <T> Indexed<T> of(T value, int index) {
        N.checkArgNotNegative(index, "index");
        return new Indexed<T>(index, value);
    }

    public static <T> Indexed<T> of(T value, long index) {
        N.checkArgNotNegative(index, "index");
        return new Indexed<T>(index, value);
    }

    public static <T> ObjIterator<Indexed<T>> iterate(Iterator<? extends T> iter) {
        return Indexed.iterate(iter, 0);
    }

    public static <T> ObjIterator<Indexed<T>> iterate(Iterator<? extends T> iter, int startIndex) {
        N.checkArgNotNegative(startIndex, "startIndex");
        return Indexed.iterate(iter, (long)startIndex);
    }

    public static <T> ObjIterator<Indexed<T>> iterate(final Iterator<? extends T> iter, final long startIndex) {
        N.checkArgNotNegative(startIndex, "startIndex");
        return new ObjIterator<Indexed<T>>(){
            private long idx;
            {
                this.idx = startIndex;
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Indexed<T> next() {
                return Indexed.of(iter.next(), this.idx++);
            }
        };
    }

    public T value() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.index * 31L + (long)(this.value == null ? 0 : this.value.hashCode()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Indexed) {
            Indexed other = (Indexed)obj;
            return this.index == other.index && N.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return "[" + this.index + "]=" + N.toString(this.value);
    }
}

