/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Iterators;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.u;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public final class Iterables {
    private Iterables() {
    }

    public static <T> Set<T> differentSet(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a)) {
            return N.newHashSet();
        }
        if (N.isNullOrEmpty(b)) {
            return N.newHashSet(a);
        }
        Set<? extends T> result = N.newHashSet(a);
        Iterables.removeAll(a, b);
        return result;
    }

    public static <T> Set<T> symmetricDifferentSet(Collection<? extends T> a, Collection<? extends T> b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? N.newHashSet() : N.newHashSet(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? N.newHashSet() : N.newHashSet(a);
        }
        Set<T> commonSet = Iterables.commonSet(a, b);
        Set<T> result = N.newHashSet(a);
        for (T e : a) {
            if (commonSet.contains(e)) continue;
            result.add(e);
        }
        for (T e : b) {
            if (commonSet.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> Set<T> commonSet(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return N.newHashSet();
        }
        return Iterables.commonSet(N.asList(a, b));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Set<T> commonSet(Collection<? extends Collection<? extends T>> c) {
        void var3_6;
        if (N.isNullOrEmpty(c)) {
            return N.newHashSet();
        }
        if (c.size() == 1) {
            return N.newHashSet(c.iterator().next());
        }
        Collection<T> smallest = null;
        for (Collection<T> collection : c) {
            if (N.isNullOrEmpty(collection)) {
                return N.newHashSet();
            }
            if (smallest != null && collection.size() >= smallest.size()) continue;
            smallest = collection;
        }
        HashMap map = new HashMap();
        for (Object e3 : smallest) {
            map.put(e3, new MutableInt(1));
        }
        boolean bl = true;
        MutableInt val = null;
        for (Collection<T> ec : c) {
            if (ec == smallest) continue;
            for (T e4 : ec) {
                val = (MutableInt)map.get(e4);
                if (val == null || val.intValue() < var3_6 || val.intValue() != var3_6) continue;
                val.increment();
            }
            ++var3_6;
        }
        Set result = N.newHashSet(map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (((MutableInt)entry.getValue()).intValue() != var3_6) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public static boolean removeAll(Collection<?> c, Collection<?> objsToRemove) {
        if (N.isNullOrEmpty(c) || N.isNullOrEmpty(objsToRemove)) {
            return false;
        }
        if (c instanceof HashSet && !(objsToRemove instanceof Set)) {
            boolean result = false;
            for (Object e : objsToRemove) {
                result |= c.remove(e);
                if (c.size() != 0) continue;
                break;
            }
            return result;
        }
        return c.removeAll(objsToRemove);
    }

    public static boolean retainAll(Collection<?> c, Collection<?> objsToKeep) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        if (N.isNullOrEmpty(objsToKeep)) {
            c.clear();
            return true;
        }
        if (c instanceof HashSet && !(objsToKeep instanceof Set) && (c.size() > 9 || objsToKeep.size() > 9)) {
            return c.retainAll(N.newHashSet(objsToKeep));
        }
        return c.retainAll(objsToKeep);
    }

    public static <T> u.Nullable<T> getOnlyElement(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return u.Nullable.empty();
        }
        return Iterators.getOnlyElement(iterable.iterator());
    }

    public static u.OptionalInt indexOf(Collection<?> c, Object objToFind) {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalInt.empty();
        }
        int idx = 0;
        for (Object e : c) {
            if (N.equals(e, objToFind)) {
                return u.OptionalInt.of(idx);
            }
            ++idx;
        }
        return u.OptionalInt.empty();
    }

    public static u.OptionalInt lastIndexOf(Collection<?> c, Object objToFind) {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalInt.empty();
        }
        int size = c.size();
        if (c instanceof List) {
            List list = (List)c;
            if (c instanceof RandomAccess) {
                for (int i = size - 1; i >= 0; --i) {
                    if (!N.equals(list.get(i), objToFind)) continue;
                    return u.OptionalInt.of(i);
                }
            } else {
                ListIterator iter = list.listIterator(list.size());
                int i = size - 1;
                while (iter.hasPrevious()) {
                    if (N.equals(iter.previous(), objToFind)) {
                        return u.OptionalInt.of(i);
                    }
                    --i;
                }
            }
            return u.OptionalInt.empty();
        }
        if (c instanceof Deque) {
            Iterator iter = ((Deque)c).descendingIterator();
            int i = size - 1;
            while (iter.hasNext()) {
                if (N.equals(iter.next(), objToFind)) {
                    return u.OptionalInt.of(i);
                }
                --i;
            }
            return u.OptionalInt.empty();
        }
        Object[] a = c.toArray();
        for (int i = a.length - 1; i >= 0; --i) {
            if (!N.equals(a[i], objToFind)) continue;
            return u.OptionalInt.of(i);
        }
        return u.OptionalInt.empty();
    }

    public static <T, E extends Exception> u.OptionalInt findFirstIndex(T[] a, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalInt.empty();
        }
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(a[i])) continue;
            return u.OptionalInt.of(i);
        }
        return u.OptionalInt.empty();
    }

    public static <T, E extends Exception> u.OptionalInt findFirstIndex(Collection<? extends T> c, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalInt.empty();
        }
        int idx = 0;
        for (T e : c) {
            if (predicate.test(e)) {
                return u.OptionalInt.of(idx);
            }
            ++idx;
        }
        return u.OptionalInt.empty();
    }

    public static <T, E extends Exception> u.OptionalInt findLastIndex(T[] a, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalInt.empty();
        }
        int len = a.length;
        for (int i = len - 1; i >= 0; --i) {
            if (!predicate.test(a[i])) continue;
            return u.OptionalInt.of(i);
        }
        return u.OptionalInt.empty();
    }

    public static <T, E extends Exception> u.OptionalInt findLastIndex(Collection<? extends T> c, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalInt.empty();
        }
        int size = c.size();
        if (c instanceof List) {
            List list = (List)c;
            if (c instanceof RandomAccess) {
                for (int i = size - 1; i >= 0; --i) {
                    if (!predicate.test(list.get(i))) continue;
                    return u.OptionalInt.of(i);
                }
            } else {
                ListIterator iter = list.listIterator(list.size());
                int i = size - 1;
                while (iter.hasPrevious()) {
                    if (predicate.test(iter.previous())) {
                        return u.OptionalInt.of(i);
                    }
                    --i;
                }
            }
            return u.OptionalInt.empty();
        }
        if (c instanceof Deque) {
            Iterator iter = ((Deque)c).descendingIterator();
            int i = size - 1;
            while (iter.hasNext()) {
                if (predicate.test(iter.next())) {
                    return u.OptionalInt.of(i);
                }
                --i;
            }
            return u.OptionalInt.empty();
        }
        Object[] a = c.toArray();
        for (int i = a.length - 1; i >= 0; --i) {
            if (!predicate.test(a[i])) continue;
            return u.OptionalInt.of(i);
        }
        return u.OptionalInt.empty();
    }

    public static <T, E extends Exception> u.Nullable<T> findFirst(T[] a, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.Nullable.empty();
        }
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(a[i])) continue;
            return u.Nullable.of(a[i]);
        }
        return u.Nullable.empty();
    }

    public static <T, E extends Exception> u.Nullable<T> findFirst(Collection<T> c, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.Nullable.empty();
        }
        for (T e : c) {
            if (!predicate.test(e)) continue;
            return u.Nullable.of(e);
        }
        return u.Nullable.empty();
    }

    public static <T, E extends Exception> u.Nullable<T> findLast(T[] a, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.Nullable.empty();
        }
        int len = a.length;
        for (int i = len - 1; i >= 0; --i) {
            if (!predicate.test(a[i])) continue;
            return u.Nullable.of(a[i]);
        }
        return u.Nullable.empty();
    }

    public static <T, E extends Exception> u.Nullable<T> findLast(Collection<T> c, Try.Predicate<? super T, E> predicate) throws E {
        return (u.Nullable)Iterables.findLast(c, predicate, false);
    }

    public static <T, E extends Exception> u.Optional<T> findFirstNonNull(T[] a, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.Optional.empty();
        }
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == null || !predicate.test(a[i])) continue;
            return u.Optional.of(a[i]);
        }
        return u.Optional.empty();
    }

    public static <T, E extends Exception> u.Optional<T> findFirstNonNull(Collection<T> c, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.Optional.empty();
        }
        for (T e : c) {
            if (e == null || !predicate.test(e)) continue;
            return u.Optional.of(e);
        }
        return u.Optional.empty();
    }

    public static <T, E extends Exception> u.Optional<T> findLastNonNull(T[] a, Try.Predicate<? super T, E> predicate) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.Optional.empty();
        }
        int len = a.length;
        for (int i = len - 1; i >= 0; --i) {
            if (a[i] == null || !predicate.test(a[i])) continue;
            return u.Optional.of(a[i]);
        }
        return u.Optional.empty();
    }

    public static <T, E extends Exception> u.Optional<T> findLastNonNull(Collection<T> c, Try.Predicate<? super T, E> predicate) throws E {
        return (u.Optional)Iterables.findLast(c, predicate, true);
    }

    private static <T, R, E extends Exception> R findLast(Collection<T> c, Try.Predicate<? super T, E> predicate, boolean isForNonNull) throws E {
        if (N.isNullOrEmpty(c)) {
            return (R)(isForNonNull ? u.Optional.empty() : u.Nullable.empty());
        }
        Object e = null;
        if (c instanceof List) {
            List list = (List)c;
            if (c instanceof RandomAccess) {
                for (int i = c.size() - 1; i >= 0; --i) {
                    e = list.get(i);
                    if (isForNonNull && e == null || !predicate.test(e)) continue;
                    return (R)(isForNonNull ? u.Optional.of(e) : u.Nullable.of(e));
                }
            } else {
                ListIterator iter = list.listIterator(list.size());
                while (iter.hasPrevious()) {
                    e = iter.previous();
                    if (isForNonNull && e == null || !predicate.test(e)) continue;
                    return (R)(isForNonNull ? u.Optional.of(e) : u.Nullable.of(e));
                }
            }
            return (R)(isForNonNull ? u.Optional.empty() : u.Nullable.empty());
        }
        if (c instanceof Deque) {
            Iterator iter = ((Deque)c).descendingIterator();
            while (iter.hasNext()) {
                e = iter.next();
                if (isForNonNull && e == null || !predicate.test(e)) continue;
                return (R)(isForNonNull ? u.Optional.of(e) : u.Nullable.of(e));
            }
            return (R)(isForNonNull ? u.Optional.empty() : u.Nullable.empty());
        }
        Object[] a = c.toArray();
        for (int i = a.length - 1; i >= 0; --i) {
            if (isForNonNull && a[i] == null || !predicate.test(a[i])) continue;
            return (R)(isForNonNull ? u.Optional.of(a[i]) : u.Nullable.of(a[i]));
        }
        return (R)(isForNonNull ? u.Optional.empty() : u.Nullable.empty());
    }
}

