/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.DuplicatedResultException;
import com.landawn.abacus.util.BiIterator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Nth;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.BiPredicate;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.Predicate;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.function.TriFunction;
import com.landawn.abacus.util.u;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Iterators {
    private Iterators() {
    }

    public static boolean contains(Iterator<?> iter, Object objToFind) {
        if (iter == null) {
            return false;
        }
        while (iter.hasNext()) {
            if (!N.equals(iter.next(), objToFind)) continue;
            return true;
        }
        return false;
    }

    public static long indexOf(Iterator<?> iter, Object objToFind) {
        if (iter == null) {
            return -1L;
        }
        long index = 0L;
        while (iter.hasNext()) {
            if (N.equals(iter.next(), objToFind)) {
                return index;
            }
            ++index;
        }
        return -1L;
    }

    public static long occurrencesOf(Iterator<?> iter, Object objToFind) {
        if (iter == null) {
            return 0L;
        }
        long occurrences = 0L;
        while (iter.hasNext()) {
            if (!N.equals(iter.next(), objToFind)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static long count(Iterator<?> iter) {
        if (iter == null) {
            return 0L;
        }
        long res = 0L;
        while (iter.hasNext()) {
            iter.next();
            ++res;
        }
        return res;
    }

    public static <T> long count(Iterator<T> iter, Predicate<? super T> filter) {
        N.checkArgNotNull(filter);
        if (iter == null) {
            return 0L;
        }
        long res = 0L;
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            ++res;
        }
        return res;
    }

    public static <T> List<T> toList(Iterator<? extends T> iter) {
        if (iter == null) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static <T> Set<T> toSet(Iterator<? extends T> iter) {
        if (iter == null) {
            return N.newHashSet();
        }
        Set result = N.newHashSet();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static <T, C extends Collection<T>> C toCollection(Iterator<? extends T> iter, Supplier<? extends C> collectionFactory) {
        Collection c = (Collection)collectionFactory.get();
        if (iter == null) {
            return (C)c;
        }
        while (iter.hasNext()) {
            c.add(iter.next());
        }
        return (C)c;
    }

    public static <T, K, E extends Exception> Map<K, T> toMap(Iterator<? extends T> iter, Try.Function<? super T, K, E> keyMapper) throws E {
        N.checkArgNotNull(keyMapper);
        if (iter == null) {
            return new HashMap();
        }
        HashMap<K, Object> result = new HashMap<K, Object>();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            result.put(keyMapper.apply(e), e);
        }
        return result;
    }

    public static <T, K, V, E extends Exception, E2 extends Exception> Map<K, V> toMap(Iterator<? extends T> iter, Try.Function<? super T, K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueExtractor) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (iter == null) {
            return new HashMap();
        }
        HashMap<K, V> result = new HashMap<K, V>();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return result;
    }

    public static <T, K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception> M toMap(Iterator<? extends T> iter, Try.Function<? super T, K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueExtractor, Supplier<? extends M> mapSupplier) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (iter == null) {
            return (M)((Map)mapSupplier.get());
        }
        Map result = (Map)mapSupplier.get();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return (M)result;
    }

    public static <T, E extends Exception> void forEach(Iterator<T> iter, Try.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            action.accept(iter.next());
        }
    }

    public static <T, E extends Exception> void forEach(Iterator<T> iter, Try.IndexedConsumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        int idx = 0;
        while (iter.hasNext()) {
            action.accept(idx++, iter.next());
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEach(Iterator<T> iter, Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            Collection<U> c2 = flatMapper.apply(e);
            if (!N.notNullOrEmpty(c2)) continue;
            for (U u2 : c2) {
                action.accept(e, u2);
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEach(Iterator<T> iter, Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            Collection<T2> c2 = flatMapper.apply(e);
            if (!N.notNullOrEmpty(c2)) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3 = flatMapper2.apply(t2);
                if (!N.notNullOrEmpty(c3)) continue;
                for (T3 t3 : c3) {
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <A, B, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, Try.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        if (a == null || b == null) {
            return;
        }
        while (a.hasNext() && b.hasNext()) {
            action.accept(a.next(), b.next());
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, Iterator<C> c, Try.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        if (a == null || b == null || c == null) {
            return;
        }
        while (a.hasNext() && b.hasNext() && c.hasNext()) {
            action.accept(a.next(), b.next(), c.next());
        }
    }

    public static <A, B, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, A valueForNoneA, B valueForNoneB, Try.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a;
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b;
        Object nextA = null;
        Object nextB = null;
        while (iterA.hasNext() || iterB.hasNext()) {
            nextA = iterA.hasNext() ? iterA.next() : valueForNoneA;
            nextB = iterB.hasNext() ? iterB.next() : valueForNoneB;
            action.accept(nextA, nextB);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, Iterator<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Try.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a;
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b;
        Iterator<Object> iterC = b == null ? ObjIterator.empty() : c;
        Object nextA = null;
        Object nextB = null;
        Object nextC = null;
        while (iterA.hasNext() || iterB.hasNext() || iterC.hasNext()) {
            nextA = iterA.hasNext() ? iterA.next() : valueForNoneA;
            nextB = iterB.hasNext() ? iterB.next() : valueForNoneB;
            nextC = iterC.hasNext() ? iterC.next() : valueForNoneC;
            action.accept(nextA, nextB, nextC);
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEachNonNull(Iterator<T> iter, Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object e = null;
        while (iter.hasNext()) {
            Collection<U> c2;
            e = iter.next();
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (U u2 : c2) {
                if (u2 == null) continue;
                action.accept(e, u2);
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEachNonNull(Iterator<T> iter, Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object e = null;
        while (iter.hasNext()) {
            Collection<T2> c2;
            e = iter.next();
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3;
                if (t2 == null || !N.notNullOrEmpty(c3 = flatMapper2.apply(t2))) continue;
                for (T3 t3 : c3) {
                    if (t3 == null) continue;
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <T, E extends Exception> void forEachPair(Iterator<T> iter, Try.BiConsumer<? super T, ? super T, E> action) throws E {
        Iterators.forEachPair(iter, action, 1);
    }

    public static <T, E extends Exception> void forEachPair(Iterator<T> iter, Try.BiConsumer<? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 2;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 2, increment);
        if (iter == null) {
            return;
        }
        boolean isFirst = true;
        Object prev = null;
        while (iter.hasNext()) {
            if (increment > 2 && !isFirst) {
                int skipNum = increment - 2;
                while (skipNum-- > 0 && iter.hasNext()) {
                    iter.next();
                }
                if (!iter.hasNext()) break;
            }
            if (increment == 1) {
                Object u2 = isFirst ? (Object)iter.next() : prev;
                prev = iter.hasNext() ? (Object)iter.next() : null;
                action.accept(u2, prev);
            } else {
                action.accept(iter.next(), iter.hasNext() ? (Object)iter.next() : null);
            }
            isFirst = false;
        }
    }

    public static <T, E extends Exception> void forEachTriple(Iterator<T> iter, Try.TriConsumer<? super T, ? super T, ? super T, E> action) throws E {
        Iterators.forEachTriple(iter, action, 1);
    }

    public static <T, E extends Exception> void forEachTriple(Iterator<T> iter, Try.TriConsumer<? super T, ? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 3;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 3, increment);
        if (iter == null) {
            return;
        }
        boolean isFirst = true;
        Object prev = null;
        Object prev2 = null;
        while (iter.hasNext()) {
            if (increment > 3 && !isFirst) {
                int skipNum = increment - 3;
                while (skipNum-- > 0 && iter.hasNext()) {
                    iter.next();
                }
                if (!iter.hasNext()) break;
            }
            if (increment == 1) {
                Object c = isFirst ? (Object)iter.next() : prev2;
                prev2 = isFirst ? (iter.hasNext() ? (Object)iter.next() : null) : prev;
                prev = iter.hasNext() ? (Object)iter.next() : null;
                action.accept(c, prev2, prev);
            } else if (increment == 2) {
                Object c = isFirst ? (Object)iter.next() : prev;
                prev = iter.hasNext() ? (Object)iter.next() : null;
                action.accept(c, iter.hasNext() ? (Object)iter.next() : null, prev);
            } else {
                action.accept(iter.next(), iter.hasNext() ? (Object)iter.next() : null, iter.hasNext() ? (Object)iter.next() : null);
            }
            isFirst = false;
        }
    }

    public static <T> ObjIterator<T> repeat(final T e, final int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: %s", n);
        if (n == 0) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private int cnt;
            {
                this.cnt = n;
            }

            @Override
            public boolean hasNext() {
                return this.cnt > 0;
            }

            @Override
            public T next() {
                if (this.cnt <= 0) {
                    throw new NoSuchElementException();
                }
                --this.cnt;
                return e;
            }
        };
    }

    public static <T> ObjIterator<T> repeatEach(final Collection<T> c, final int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: %s", n);
        if (n == 0 || N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private Iterator<T> iter = null;
            private T next = null;
            private int cnt = n;

            @Override
            public boolean hasNext() {
                return this.cnt > 0 || this.iter != null && this.iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.iter == null) {
                    this.iter = c.iterator();
                    this.next = this.iter.next();
                } else if (this.cnt <= 0) {
                    this.next = this.iter.next();
                    this.cnt = n;
                }
                --this.cnt;
                return this.next;
            }
        };
    }

    public static <T> ObjIterator<T> repeatAll(final Collection<T> c, final int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: %s", n);
        if (n == 0 || N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private Iterator<T> iter = null;
            private int cnt = n;

            @Override
            public boolean hasNext() {
                return this.cnt > 0 || this.iter != null && this.iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.iter == null || !this.iter.hasNext()) {
                    this.iter = c.iterator();
                    --this.cnt;
                }
                return this.iter.next();
            }
        };
    }

    public static <T> ObjIterator<T> repeatEachToSize(final Collection<T> c, final int size) {
        N.checkArgument(size >= 0, "'size' can't be negative: %s", size);
        N.checkArgument(size == 0 || N.notNullOrEmpty(c), "Collection can't be empty or null when size > 0");
        if (N.isNullOrEmpty(c) || size == 0) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final int n;
            private int mod;
            private Iterator<T> iter;
            private T next;
            private int cnt;
            {
                this.n = size / c.size();
                this.mod = size % c.size();
                this.iter = null;
                this.next = null;
                this.cnt = this.mod-- > 0 ? this.n + 1 : this.n;
            }

            @Override
            public boolean hasNext() {
                return this.cnt > 0 || (this.n > 0 || this.mod > 0) && this.iter != null && this.iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.iter == null) {
                    this.iter = c.iterator();
                    this.next = this.iter.next();
                } else if (this.cnt <= 0) {
                    this.next = this.iter.next();
                    this.cnt = this.mod-- > 0 ? this.n + 1 : this.n;
                }
                --this.cnt;
                return this.next;
            }
        };
    }

    public static <T> ObjIterator<T> repeatAllToSize(final Collection<T> c, final int size) {
        N.checkArgument(size >= 0, "'size' can't be negative: %s", size);
        N.checkArgument(size == 0 || N.notNullOrEmpty(c), "Collection can't be empty or null when size > 0");
        if (N.isNullOrEmpty(c) || size == 0) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private Iterator<T> iter = null;
            private int cnt = size;

            @Override
            public boolean hasNext() {
                return this.cnt > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.iter == null || !this.iter.hasNext()) {
                    this.iter = c.iterator();
                }
                --this.cnt;
                return this.iter.next();
            }
        };
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(T[] ... a) {
        if (N.isNullOrEmpty(a)) {
            return ObjIterator.empty();
        }
        ArrayList<ObjIterator<Object>> list = new ArrayList<ObjIterator<Object>>(a.length);
        for (Object[] objectArray : a) {
            if (!N.notNullOrEmpty(objectArray)) continue;
            list.add(ObjIterator.of(objectArray));
        }
        return Iterators.concat(list);
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(Collection<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return ObjIterator.empty();
        }
        ArrayList<Iterator<? extends T>> list = new ArrayList<Iterator<? extends T>>(a.length);
        for (Collection<T> collection : a) {
            if (!N.notNullOrEmpty(collection)) continue;
            list.add(collection.iterator());
        }
        return Iterators.concat(list);
    }

    public static <T> ObjIterator<T> concatt(final Collection<? extends Collection<? extends T>> c) {
        if (N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final Iterator<? extends Collection<? extends T>> iter;
            private Iterator<? extends T> cur;
            {
                this.iter = c.iterator();
            }

            @Override
            public boolean hasNext() {
                while ((this.cur == null || !this.cur.hasNext()) && this.iter.hasNext()) {
                    Collection c2 = this.iter.next();
                    this.cur = N.isNullOrEmpty(c2) ? null : c2.iterator();
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public T next() {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }
        };
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(Iterator<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return ObjIterator.empty();
        }
        return Iterators.concat(N.asList(a));
    }

    public static <T> ObjIterator<T> concat(final Collection<? extends Iterator<? extends T>> c) {
        if (N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final Iterator<? extends Iterator<? extends T>> iter;
            private Iterator<? extends T> cur;
            {
                this.iter = c.iterator();
            }

            @Override
            public boolean hasNext() {
                while ((this.cur == null || !this.cur.hasNext()) && this.iter.hasNext()) {
                    this.cur = this.iter.next();
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public T next() {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }
        };
    }

    @SafeVarargs
    public static <A, B> BiIterator<A, B> concat(final BiIterator<A, B> ... a) {
        if (N.isNullOrEmpty(a)) {
            return BiIterator.empty();
        }
        return new BiIterator<A, B>(){
            private final Iterator<BiIterator<A, B>> iter;
            private BiIterator<A, B> cur;
            {
                this.iter = Arrays.asList(a).iterator();
            }

            @Override
            public boolean hasNext() {
                while ((this.cur == null || !this.cur.hasNext()) && this.iter.hasNext()) {
                    this.cur = this.iter.next();
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public Pair<A, B> next() {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return (Pair)this.cur.next();
            }

            @Override
            public <E extends Exception> void forEachRemaining(Try.BiConsumer<? super A, ? super B, E> action) throws E {
                while (this.hasNext()) {
                    this.cur.forEachRemaining(action);
                }
            }

            @Override
            public <R> ObjIterator<R> map(final BiFunction<? super A, ? super B, R> mapper) {
                N.checkArgNotNull(mapper);
                return new ObjIterator<R>(){
                    private ObjIterator<R> mappedIter = null;

                    @Override
                    public boolean hasNext() {
                        if (this.mappedIter == null || !this.mappedIter.hasNext()) {
                            while ((cur == null || !cur.hasNext()) && iter.hasNext()) {
                                cur = (BiIterator)iter.next();
                            }
                            if (cur != null) {
                                this.mappedIter = cur.map(mapper);
                            }
                        }
                        return this.mappedIter != null && this.mappedIter.hasNext();
                    }

                    @Override
                    public R next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.mappedIter.next();
                    }
                };
            }
        };
    }

    public static <T> ObjIterator<T> merge(Collection<? extends T> a, Collection<? extends T> b, BiFunction<? super T, ? super T, Nth> nextSelector) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        return Iterators.merge(iterA, iterB, nextSelector);
    }

    public static <T> ObjIterator<T> merge(final Iterator<? extends T> a, final Iterator<? extends T> b, final BiFunction<? super T, ? super T, Nth> nextSelector) {
        N.checkArgNotNull(nextSelector);
        return new ObjIterator<T>(){
            private final Iterator<? extends T> iterA;
            private final Iterator<? extends T> iterB;
            private T nextA;
            private T nextB;
            private boolean hasNextA;
            private boolean hasNextB;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
                this.nextA = null;
                this.nextB = null;
                this.hasNextA = false;
                this.hasNextB = false;
            }

            @Override
            public boolean hasNext() {
                return this.hasNextA || this.hasNextB || this.iterA.hasNext() || this.iterB.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNextA) {
                    if (this.iterB.hasNext()) {
                        this.nextB = this.iterB.next();
                        if (nextSelector.apply(this.nextA, this.nextB) == Nth.FIRST) {
                            this.hasNextA = false;
                            this.hasNextB = true;
                            return this.nextA;
                        }
                        return this.nextB;
                    }
                    this.hasNextA = false;
                    return this.nextA;
                }
                if (this.hasNextB) {
                    if (this.iterA.hasNext()) {
                        this.nextA = this.iterA.next();
                        if (nextSelector.apply(this.nextA, this.nextB) == Nth.FIRST) {
                            return this.nextA;
                        }
                        this.hasNextA = true;
                        this.hasNextB = false;
                        return this.nextB;
                    }
                    this.hasNextB = false;
                    return this.nextB;
                }
                if (this.iterA.hasNext()) {
                    if (this.iterB.hasNext()) {
                        this.nextA = this.iterA.next();
                        if (nextSelector.apply(this.nextA, this.nextB = this.iterB.next()) == Nth.FIRST) {
                            this.hasNextB = true;
                            return this.nextA;
                        }
                        this.hasNextA = true;
                        return this.nextB;
                    }
                    return this.iterA.next();
                }
                return this.iterB.next();
            }
        };
    }

    public static <A, B, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, BiFunction<? super A, ? super B, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        return Iterators.zip(iterA, iterB, zipFunction);
    }

    public static <A, B, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final BiFunction<? super A, ? super B, R> zipFunction) {
        N.checkArgNotNull(zipFunction);
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() && this.iterB.hasNext();
            }

            @Override
            public R next() {
                return zipFunction.apply(this.iterA.next(), this.iterB.next());
            }
        };
    }

    public static <A, B, C, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = N.isNullOrEmpty(c) ? ObjIterator.empty() : c.iterator();
        return Iterators.zip(iterA, iterB, iterC, zipFunction);
    }

    public static <A, B, C, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final Iterator<C> c, final TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        N.checkArgNotNull(zipFunction);
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            private final Iterator<C> iterC;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
                this.iterC = c == null ? ObjIterator.empty() : c;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() && this.iterB.hasNext() && this.iterC.hasNext();
            }

            @Override
            public R next() {
                return zipFunction.apply(this.iterA.next(), this.iterB.next(), this.iterC.next());
            }
        };
    }

    public static <A, B, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, A valueForNoneA, B valueForNoneB, BiFunction<? super A, ? super B, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        return Iterators.zip(iterA, iterB, valueForNoneA, valueForNoneB, zipFunction);
    }

    public static <A, B, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final A valueForNoneA, final B valueForNoneB, final BiFunction<? super A, ? super B, R> zipFunction) {
        N.checkArgNotNull(zipFunction);
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() || this.iterB.hasNext();
            }

            @Override
            public R next() {
                return zipFunction.apply(this.iterA.hasNext() ? this.iterA.next() : valueForNoneA, this.iterB.hasNext() ? this.iterB.next() : valueForNoneB);
            }
        };
    }

    public static <A, B, C, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = N.isNullOrEmpty(c) ? ObjIterator.empty() : c.iterator();
        return Iterators.zip(iterA, iterB, iterC, valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
    }

    public static <A, B, C, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final Iterator<C> c, final A valueForNoneA, final B valueForNoneB, final C valueForNoneC, final TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            private final Iterator<C> iterC;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
                this.iterC = c == null ? ObjIterator.empty() : c;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() || this.iterB.hasNext() || this.iterC.hasNext();
            }

            @Override
            public R next() {
                return zipFunction.apply(this.iterA.hasNext() ? this.iterA.next() : valueForNoneA, this.iterB.hasNext() ? this.iterB.next() : valueForNoneB, this.iterC.hasNext() ? this.iterC.next() : valueForNoneC);
            }
        };
    }

    public static <T, L, R> BiIterator<L, R> unzip(Iterator<? extends T> iter, BiConsumer<? super T, Pair<L, R>> unzip) {
        return BiIterator.unzip(iter, unzip);
    }

    public static <T> ObjIterator<List<T>> split(final Iterator<? extends T> iter, final int chunkSize) {
        N.checkArgument(chunkSize > 0, "'chunkSize' must be greater than 0, can't be: %s", chunkSize);
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<List<T>>(){
            private final Iterator<? extends T> iterator;
            {
                this.iterator = iter;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public List<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList next = new ArrayList(chunkSize);
                for (int i = 0; i < chunkSize && this.iterator.hasNext(); ++i) {
                    next.add(this.iterator.next());
                }
                return next;
            }
        };
    }

    public static <T> u.Nullable<T> get(Iterator<T> iter, int index) {
        N.checkArgNotNegative(index, "index");
        if (iter == null) {
            return u.Nullable.empty();
        }
        while (iter.hasNext()) {
            if (index-- == 0) {
                return u.Nullable.of(iter.next());
            }
            iter.next();
        }
        return u.Nullable.empty();
    }

    public static <T> u.Nullable<T> first(Iterator<T> iter) {
        return iter != null && iter.hasNext() ? u.Nullable.of(iter.next()) : u.Nullable.empty();
    }

    public static <T> u.Optional<T> firstNonNull(Iterator<T> iter) {
        if (iter == null) {
            return u.Optional.empty();
        }
        Object e = null;
        while (iter.hasNext()) {
            T t = iter.next();
            e = t;
            if (t == null) continue;
            return u.Optional.of(e);
        }
        return u.Optional.empty();
    }

    public static <T> u.Nullable<T> last(Iterator<T> iter) {
        if (iter == null || !iter.hasNext()) {
            return u.Nullable.empty();
        }
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
        }
        return u.Nullable.of(e);
    }

    public static <T> u.Optional<T> lastNonNull(Iterator<T> iter) {
        if (iter == null) {
            return u.Optional.empty();
        }
        Object e = null;
        Object lastNonNull = null;
        while (iter.hasNext()) {
            T t = iter.next();
            e = t;
            if (t == null) continue;
            lastNonNull = e;
        }
        return u.Optional.ofNullable(lastNonNull);
    }

    public static long advance(Iterator<?> iterator, long numberToAdvance) {
        long i;
        N.checkArgNotNegative(numberToAdvance, "numberToAdvance");
        for (i = 0L; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return i;
    }

    public static <T> ObjIterator<T> skip(final Iterator<T> iter, final long n) {
        N.checkArgNotNegative(n, "n");
        if (iter == null || n == 0L) {
            return ObjIterator.of(iter);
        }
        return new ObjIterator<T>(){
            private boolean skipped = false;

            @Override
            public boolean hasNext() {
                if (!this.skipped) {
                    this.skip();
                }
                return iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return iter.next();
            }

            private void skip() {
                long idx = 0L;
                while (idx++ < n && iter.hasNext()) {
                    iter.next();
                }
                this.skipped = true;
            }
        };
    }

    public static <T> ObjIterator<T> limit(final Iterator<T> iter, final long count) {
        N.checkArgNotNegative(count, "count");
        if (iter == null || count == 0L) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private long cnt;
            {
                this.cnt = count;
            }

            @Override
            public boolean hasNext() {
                return this.cnt > 0L && iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                --this.cnt;
                return iter.next();
            }
        };
    }

    public static <T> ObjIterator<T> limit(final Iterator<T> iter, final long offset, final long count) {
        N.checkArgNotNegative(count, "offset");
        N.checkArgNotNegative(count, "count");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private long cnt;
            private boolean skipped;
            {
                this.cnt = count;
                this.skipped = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.skipped) {
                    this.skip();
                }
                return this.cnt > 0L && iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                --this.cnt;
                return iter.next();
            }

            private void skip() {
                long idx = 0L;
                while (idx++ < offset && iter.hasNext()) {
                    iter.next();
                }
                this.skipped = true;
            }
        };
    }

    public static <T> ObjIterator<T> skipNull(final Iterator<T> iter) {
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final Iterator<T> iterator;
            private T next;
            {
                this.iterator = iter;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null && this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (this.next == null) {
                        while (this.iterator.hasNext()) {
                            this.next = this.iterator.next();
                            if (this.next == null) continue;
                        }
                    }
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    public static <T> u.Nullable<T> getOnlyElement(Iterator<? extends T> iter) throws DuplicatedResultException {
        if (iter == null) {
            return u.Nullable.empty();
        }
        T first = iter.next();
        if (iter.hasNext()) {
            throw new DuplicatedResultException("Expected at most one element but was: [" + StringUtil.concat(first, (Object)", ", iter.next(), (Object)"...]"));
        }
        return u.Nullable.of(first);
    }

    public static <T> ObjIterator<T> filter(final Iterator<T> iter, final Predicate<? super T> filter) {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private T tmp = null;

            @Override
            public boolean hasNext() {
                if (this.next == this.NONE) {
                    while (iter.hasNext()) {
                        this.tmp = iter.next();
                        if (!filter.test(this.tmp)) continue;
                        this.next = this.tmp;
                        break;
                    }
                }
                return this.next != this.NONE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.tmp = this.next;
                this.next = this.NONE;
                return this.tmp;
            }
        };
    }

    public static <T, U> ObjIterator<U> map(final Iterator<T> iter, final Function<? super T, U> mapper) {
        N.checkArgNotNull(mapper, "mapper");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<U>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(iter.next());
            }
        };
    }

    public static <T, U> ObjIterator<U> flatMap(final Iterator<T> iter, final Function<? super T, ? extends Collection<? extends U>> mapper) {
        N.checkArgNotNull(mapper, "mapper");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<U>(){
            private Collection<? extends U> c = null;
            private Iterator<? extends U> cur = null;

            @Override
            public boolean hasNext() {
                if (this.cur == null || !this.cur.hasNext()) {
                    while (iter.hasNext()) {
                        this.c = (Collection)mapper.apply(iter.next());
                        Iterator<Object> iterator = this.cur = this.c == null || this.c.size() == 0 ? null : this.c.iterator();
                        if (this.cur == null || !this.cur.hasNext()) continue;
                    }
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public U next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }
        };
    }

    public static <T, U> ObjIterator<T> generate(final U init, final Predicate<? super U> hasNext, final Function<? super U, T> supplier) {
        N.checkArgNotNull(hasNext);
        N.checkArgNotNull(supplier);
        return new ObjIterator<T>(){

            @Override
            public boolean hasNext() {
                return hasNext.test(init);
            }

            @Override
            public T next() {
                return supplier.apply(init);
            }
        };
    }

    public static <T, U> ObjIterator<T> generate(final U init, final BiPredicate<? super U, T> hasNext, final BiFunction<? super U, T, T> supplier) {
        N.checkArgNotNull(hasNext);
        N.checkArgNotNull(supplier);
        return new ObjIterator<T>(){
            private T prev = null;

            @Override
            public boolean hasNext() {
                return hasNext.test(init, this.prev);
            }

            @Override
            public T next() {
                this.prev = supplier.apply(init, this.prev);
                return this.prev;
            }
        };
    }
}

