/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.u;
import java.util.Collection;
import java.util.Map;

public class Joiner
implements AutoCloseable {
    public static final String DEFAULT_DELIMITER = N.ELEMENT_SEPARATOR;
    public static final String DEFAULT_KEY_VALUE_DELIMITER = "=";
    private final String prefix;
    private final String delimiter;
    private final String keyValueDelimiter;
    private final String suffix;
    private final boolean isEmptyDelimiter;
    private final boolean isEmptyKeyValueDelimiter;
    private boolean trim = false;
    private boolean skipNull = false;
    private boolean useCachedBuffer = false;
    private String nullText = N.NULL_STRING;
    private StringBuilder buffer;
    private String emptyValue;

    Joiner(CharSequence delimiter) {
        this(delimiter, DEFAULT_KEY_VALUE_DELIMITER);
    }

    Joiner(CharSequence delimiter, CharSequence keyValueDelimiter) {
        this(delimiter, keyValueDelimiter, "", "");
    }

    Joiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this(delimiter, DEFAULT_KEY_VALUE_DELIMITER, prefix, suffix);
    }

    Joiner(CharSequence delimiter, CharSequence keyValueDelimiter, CharSequence prefix, CharSequence suffix) {
        N.checkArgNotNull(prefix, "The prefix must not be null");
        N.checkArgNotNull(delimiter, "The delimiter must not be null");
        N.checkArgNotNull(keyValueDelimiter, "The keyValueDelimiter must not be null");
        N.checkArgNotNull(suffix, "The suffix must not be null");
        this.prefix = prefix.toString();
        this.delimiter = delimiter.toString();
        this.keyValueDelimiter = keyValueDelimiter.toString();
        this.suffix = suffix.toString();
        this.emptyValue = this.prefix + this.suffix;
        this.isEmptyDelimiter = N.isNullOrEmpty(delimiter);
        this.isEmptyKeyValueDelimiter = N.isNullOrEmpty(keyValueDelimiter);
    }

    public static Joiner defauLt() {
        return Joiner.with(DEFAULT_DELIMITER, DEFAULT_KEY_VALUE_DELIMITER);
    }

    public static Joiner with(CharSequence delimiter) {
        return new Joiner(delimiter);
    }

    public static Joiner with(CharSequence delimiter, CharSequence keyValueDelimiter) {
        return new Joiner(delimiter, keyValueDelimiter);
    }

    public static Joiner with(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new Joiner(delimiter, prefix, suffix);
    }

    public static Joiner with(CharSequence delimiter, CharSequence keyValueDelimiter, CharSequence prefix, CharSequence suffix) {
        return new Joiner(delimiter, keyValueDelimiter, prefix, suffix);
    }

    public Joiner setEmptyValue(CharSequence emptyValue) {
        this.emptyValue = N.checkArgNotNull(emptyValue, "The empty value must not be null").toString();
        return this;
    }

    public Joiner trim(boolean trim) {
        this.trim = trim;
        return this;
    }

    public Joiner skipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public Joiner useForNull(String nullText) {
        this.nullText = nullText == null ? N.NULL_STRING : nullText;
        return this;
    }

    public Joiner reuseCachedBuffer(boolean useCachedBuffer) {
        if (this.buffer != null) {
            throw new IllegalStateException("Can't reset because the buffer has been created");
        }
        this.useCachedBuffer = useCachedBuffer;
        return this;
    }

    public Joiner append(boolean element) {
        this.prepareBuilder().append(element);
        return this;
    }

    public Joiner append(char element) {
        this.prepareBuilder().append(element);
        return this;
    }

    public Joiner append(int element) {
        this.prepareBuilder().append(element);
        return this;
    }

    public Joiner append(long element) {
        this.prepareBuilder().append(element);
        return this;
    }

    public Joiner append(float element) {
        this.prepareBuilder().append(element);
        return this;
    }

    public Joiner append(double element) {
        this.prepareBuilder().append(element);
        return this;
    }

    public Joiner append(String element) {
        if (element != null || !this.skipNull) {
            this.prepareBuilder().append(element == null ? this.nullText : (this.trim ? element.trim() : element));
        }
        return this;
    }

    public Joiner append(CharSequence element) {
        if (element != null || !this.skipNull) {
            this.prepareBuilder().append(element == null ? this.nullText : (this.trim ? element.toString().trim() : element));
        }
        return this;
    }

    public Joiner append(CharSequence element, int start, int end) {
        if (element != null || !this.skipNull) {
            if (element == null) {
                this.prepareBuilder().append(this.nullText);
            } else if (this.trim) {
                this.prepareBuilder().append(element.subSequence(start, end).toString().trim());
            } else {
                this.prepareBuilder().append(element, start, end);
            }
        }
        return this;
    }

    public Joiner append(StringBuffer element) {
        if (element != null || !this.skipNull) {
            if (element == null) {
                this.prepareBuilder().append(this.nullText);
            } else {
                this.prepareBuilder().append(element);
            }
        }
        return this;
    }

    public Joiner append(char[] element) {
        if (element != null || !this.skipNull) {
            if (element == null) {
                this.prepareBuilder().append(this.nullText);
            } else {
                this.prepareBuilder().append(element);
            }
        }
        return this;
    }

    public Joiner append(char[] element, int offset, int len) {
        if (element != null || !this.skipNull) {
            if (element == null) {
                this.prepareBuilder().append(this.nullText);
            } else {
                this.prepareBuilder().append(element, offset, len);
            }
        }
        return this;
    }

    public Joiner append(Object element) {
        if (element != null || !this.skipNull) {
            this.prepareBuilder().append(this.toString(element));
        }
        return this;
    }

    public Joiner appendIfNotNull(Object element) {
        if (element != null) {
            this.prepareBuilder().append(this.toString(element));
        }
        return this;
    }

    public Joiner appendIf(boolean b, Supplier<?> supplier) {
        if (b) {
            this.append(supplier.get());
        }
        return this;
    }

    public Joiner appendAll(boolean[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(boolean[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(char[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(char[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(byte[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(byte[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(short[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(short[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(int[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(int[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(long[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(long[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(float[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(float[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(double[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(double[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (sb == null) {
                sb = this.prepareBuilder().append(a[i]);
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(a[i]);
                continue;
            }
            sb.append(this.delimiter).append(a[i]);
        }
        return this;
    }

    public Joiner appendAll(Object[] a) {
        if (N.notNullOrEmpty(a)) {
            return this.appendAll(a, 0, a.length);
        }
        return this;
    }

    public Joiner appendAll(Object[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return this;
        }
        StringBuilder sb = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (a[i] == null && this.skipNull) continue;
            if (sb == null) {
                sb = this.prepareBuilder().append(this.toString(a[i]));
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(this.toString(a[i]));
                continue;
            }
            sb.append(this.delimiter).append(this.toString(a[i]));
        }
        return this;
    }

    public Joiner appendAll(Collection<?> c) {
        if (N.notNullOrEmpty(c)) {
            return this.appendAll(c, 0, c.size());
        }
        return this;
    }

    public Joiner appendAll(Collection<?> c, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, c == null ? 0 : c.size());
        if (N.isNullOrEmpty(c) || fromIndex == toIndex && fromIndex < c.size()) {
            return this;
        }
        StringBuilder sb = null;
        int i = 0;
        for (Object e : c) {
            if (i++ < fromIndex) continue;
            if (e != null || !this.skipNull) {
                if (sb == null) {
                    sb = this.prepareBuilder().append(this.toString(e));
                } else if (this.isEmptyDelimiter) {
                    sb.append(this.toString(e));
                } else {
                    sb.append(this.delimiter).append(this.toString(e));
                }
            }
            if (i < toIndex) continue;
            break;
        }
        return this;
    }

    public Joiner appendEntry(String key, boolean value) {
        if (this.isEmptyKeyValueDelimiter) {
            this.prepareBuilder().append(key).append(value);
        } else {
            this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
        }
        return this;
    }

    public Joiner appendEntry(String key, char value) {
        if (this.isEmptyKeyValueDelimiter) {
            this.prepareBuilder().append(key).append(value);
        } else {
            this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
        }
        return this;
    }

    public Joiner appendEntry(String key, int value) {
        if (this.isEmptyKeyValueDelimiter) {
            this.prepareBuilder().append(key).append(value);
        } else {
            this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
        }
        return this;
    }

    public Joiner appendEntry(String key, long value) {
        if (this.isEmptyKeyValueDelimiter) {
            this.prepareBuilder().append(key).append(value);
        } else {
            this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
        }
        return this;
    }

    public Joiner appendEntry(String key, float value) {
        if (this.isEmptyKeyValueDelimiter) {
            this.prepareBuilder().append(key).append(value);
        } else {
            this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
        }
        return this;
    }

    public Joiner appendEntry(String key, double value) {
        if (this.isEmptyKeyValueDelimiter) {
            this.prepareBuilder().append(key).append(value);
        } else {
            this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
        }
        return this;
    }

    public Joiner appendEntry(String key, String value) {
        if (value != null || !this.skipNull) {
            if (this.isEmptyKeyValueDelimiter) {
                this.prepareBuilder().append(key).append(value == null ? this.nullText : (this.trim ? value.trim() : value));
            } else {
                this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value == null ? this.nullText : (this.trim ? value.trim() : value));
            }
        }
        return this;
    }

    public Joiner appendEntry(String key, CharSequence value) {
        if (value != null || !this.skipNull) {
            if (this.isEmptyKeyValueDelimiter) {
                this.prepareBuilder().append(key).append(value == null ? this.nullText : (this.trim ? value.toString().trim() : value));
            } else {
                this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value == null ? this.nullText : (this.trim ? value.toString().trim() : value));
            }
        }
        return this;
    }

    public Joiner appendEntry(String key, StringBuffer value) {
        if (value != null || !this.skipNull) {
            if (value == null) {
                if (this.isEmptyKeyValueDelimiter) {
                    this.prepareBuilder().append(key).append(this.nullText);
                } else {
                    this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(this.nullText);
                }
            } else if (this.isEmptyKeyValueDelimiter) {
                this.prepareBuilder().append(key).append(value);
            } else {
                this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
            }
        }
        return this;
    }

    public Joiner appendEntry(String key, char[] value) {
        if (value != null || !this.skipNull) {
            if (value == null) {
                if (this.isEmptyKeyValueDelimiter) {
                    this.prepareBuilder().append(key).append(this.nullText);
                } else {
                    this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(this.nullText);
                }
            } else if (this.isEmptyKeyValueDelimiter) {
                this.prepareBuilder().append(key).append(value);
            } else {
                this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(value);
            }
        }
        return this;
    }

    public Joiner appendEntry(String key, Object value) {
        if (value != null || !this.skipNull) {
            if (this.isEmptyKeyValueDelimiter) {
                this.prepareBuilder().append(key).append(this.toString(value));
            } else {
                this.prepareBuilder().append(key).append(this.keyValueDelimiter).append(this.toString(value));
            }
        }
        return this;
    }

    public Joiner appendEntry(Map.Entry<?, ?> entry) {
        if (!this.skipNull || entry != null && entry.getValue() != null) {
            if (entry == null) {
                this.append(this.nullText);
            } else {
                this.appendEntry(this.toString(entry.getKey()), this.toString(entry.getValue()));
            }
        }
        return this;
    }

    public Joiner appendEntries(Map<?, ?> m) {
        if (N.notNullOrEmpty(m)) {
            return this.appendEntries(m, 0, m.size());
        }
        return this;
    }

    public Joiner appendEntries(Map<?, ?> m, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, m == null ? 0 : m.size());
        if (N.isNullOrEmpty(m) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex && fromIndex < m.size()) {
            return this;
        }
        StringBuilder sb = null;
        int i = 0;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            if (i++ < fromIndex) continue;
            if (entry.getValue() != null || !this.skipNull) {
                if (sb == null) {
                    sb = this.prepareBuilder().append(this.toString(entry.getKey())).append(this.keyValueDelimiter).append(this.toString(entry.getValue()));
                } else {
                    if (this.isEmptyDelimiter) {
                        sb.append(this.toString(entry.getKey()));
                    } else {
                        sb.append(this.delimiter).append(this.toString(entry.getKey()));
                    }
                    if (this.isEmptyKeyValueDelimiter) {
                        sb.append(this.toString(entry.getValue()));
                    } else {
                        sb.append(this.keyValueDelimiter).append(this.toString(entry.getValue()));
                    }
                }
            }
            if (i < toIndex) continue;
            break;
        }
        return this;
    }

    public Joiner appendEntries(Object entity) {
        if (entity == null) {
            return this;
        }
        if (entity instanceof Map) {
            return this.appendEntries((Map)entity);
        }
        N.checkArgument(ClassUtil.isEntity(entity.getClass()), "'entity' must be entity class with getter/setter methods");
        StringBuilder sb = null;
        Object propValue = null;
        for (String propName : ClassUtil.getPropGetMethodList(entity.getClass()).keySet()) {
            propValue = ClassUtil.getPropValue(entity, propName);
            if (propValue == null && this.skipNull) continue;
            if (sb == null) {
                sb = this.prepareBuilder().append(propName).append(this.keyValueDelimiter).append(this.toString(propValue));
                continue;
            }
            if (this.isEmptyDelimiter) {
                sb.append(propName);
            } else {
                sb.append(this.delimiter).append(propName);
            }
            if (this.isEmptyKeyValueDelimiter) {
                sb.append(this.toString(propValue));
                continue;
            }
            sb.append(this.keyValueDelimiter).append(this.toString(propValue));
        }
        return this;
    }

    public Joiner repeat(String str, int n) {
        N.checkArgNotNegative(n, "n");
        String newString = this.toString(str);
        if (n < 10) {
            for (int i = 0; i < n; ++i) {
                this.append(newString);
            }
        } else {
            this.append(StringUtil.repeat(newString, n, this.delimiter));
        }
        return this;
    }

    public Joiner repeat(Object obj, int n) {
        return this.repeat(this.toString(obj), n);
    }

    public Joiner merge(Joiner other) {
        N.checkArgNotNull(other);
        if (other.buffer != null) {
            int length = other.buffer.length();
            StringBuilder builder = this.prepareBuilder();
            builder.append(other.buffer, other.prefix.length(), length);
        }
        return this;
    }

    private StringBuilder prepareBuilder() {
        if (this.buffer != null) {
            if (!this.isEmptyDelimiter) {
                this.buffer.append(this.delimiter);
            }
        } else {
            this.buffer = (this.useCachedBuffer ? Objectory.createStringBuilder() : new StringBuilder()).append(this.prefix);
        }
        return this.buffer;
    }

    private String toString(Object obj) {
        return obj == null ? this.nullText : (this.trim ? N.toString(obj).trim() : N.toString(obj));
    }

    public int length() {
        return this.buffer != null ? this.buffer.length() + this.suffix.length() : this.emptyValue.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.buffer == null) {
            return this.emptyValue;
        }
        try {
            if (this.suffix.equals("")) {
                String string = this.buffer.toString();
                return string;
            }
            int initialLength = this.buffer.length();
            String result = this.buffer.append(this.suffix).toString();
            this.buffer.setLength(initialLength);
            String string = result;
            return string;
        }
        finally {
            if (this.useCachedBuffer) {
                Objectory.recycle(this.buffer);
                this.buffer = null;
            }
        }
    }

    public <T, E extends Exception> T map(Try.Function<? super String, T, E> mapper) throws E {
        return mapper.apply(this.toString());
    }

    public <T, E extends Exception> u.Nullable<T> mapIfNotEmpty(Try.Function<? super String, T, E> mapper) throws E {
        N.checkArgNotNull(mapper);
        return this.buffer == null ? u.Nullable.empty() : u.Nullable.of(mapper.apply(this.toString()));
    }

    @Override
    public void close() {
        if (this.buffer != null && this.useCachedBuffer) {
            Objectory.recycle(this.buffer);
            this.buffer = null;
        }
    }
}

