/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.u;

public class KahanSummation {
    private long count;
    private double correction;
    private double sum;
    private double simpleSum;

    public static KahanSummation of(double ... a) {
        KahanSummation summation = new KahanSummation();
        for (double e : a) {
            summation.add(e);
        }
        return summation;
    }

    public void add(double value) {
        ++this.count;
        this.simpleSum += value;
        this.kahanSum(value);
    }

    public void addAll(double[] values) {
        for (double value : values) {
            this.add(value);
        }
    }

    public void combine(long countA, double sumA) {
        this.count += countA;
        this.simpleSum += sumA;
        this.kahanSum(sumA);
    }

    public void combine(KahanSummation other) {
        this.count += other.count;
        this.simpleSum += other.simpleSum;
        this.kahanSum(other.sum);
        this.kahanSum(other.correction);
    }

    public long count() {
        return this.count;
    }

    public double sum() {
        double tmp = this.sum + this.correction;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSum)) {
            return this.simpleSum;
        }
        return tmp;
    }

    public u.OptionalDouble average() {
        return this.count == 0L ? u.OptionalDouble.empty() : u.OptionalDouble.of(this.sum() / (double)this.count());
    }

    public String toString() {
        return String.format("{count=%d, sum=%f, average=%f}", this.count(), this.sum(), this.average().orZero());
    }

    private void kahanSum(double value) {
        double y = value - this.correction;
        double t = this.sum + y;
        this.correction = t - this.sum - y;
        this.sum = t;
    }
}

