/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.u;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Maps {
    private Maps() {
    }

    public static <T, K, E extends Exception> Map<K, T> newMap(Collection<? extends T> c, Try.Function<? super T, ? extends K, E> keyMapper) throws E {
        N.checkArgNotNull(keyMapper);
        if (N.isNullOrEmpty(c)) {
            return new HashMap();
        }
        HashMap<K, T> result = new HashMap<K, T>(N.initHashCapacity(c.size()));
        for (T e : c) {
            result.put(keyMapper.apply(e), e);
        }
        return result;
    }

    public static <T, K, E extends Exception> Map<K, T> newLinkedHashMap(Collection<? extends T> c, Try.Function<? super T, ? extends K, E> keyMapper) throws E {
        N.checkArgNotNull(keyMapper);
        if (N.isNullOrEmpty(c)) {
            return new LinkedHashMap();
        }
        LinkedHashMap<K, T> result = new LinkedHashMap<K, T>(N.initHashCapacity(c.size()));
        for (T e : c) {
            result.put(keyMapper.apply(e), e);
        }
        return result;
    }

    public static <T, K, V, E extends Exception, E2 extends Exception> Map<K, V> newMap(Collection<? extends T> c, Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueExtractor) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (N.isNullOrEmpty(c)) {
            return new HashMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(N.initHashCapacity(c.size()));
        for (T e : c) {
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return result;
    }

    public static <T, K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception> M newMap(Collection<? extends T> c, Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueExtractor, IntFunction<? extends M> mapSupplier) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (N.isNullOrEmpty(c)) {
            return (M)((Map)mapSupplier.apply(0));
        }
        Map result = (Map)mapSupplier.apply(c.size());
        for (T e : c) {
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return (M)result;
    }

    static Map newTargetMap(Map<?, ?> m) {
        return Maps.newTargetMap(m, m == null ? 0 : m.size());
    }

    static Map newTargetMap(Map<?, ?> m, int size) {
        if (m == null) {
            return new HashMap();
        }
        Map res = null;
        if (HashMap.class.equals(m.getClass())) {
            res = new HashMap(N.initHashCapacity(size));
        } else if (m instanceof SortedMap) {
            res = new TreeMap(((SortedMap)m).comparator());
        } else if (m instanceof IdentityHashMap) {
            res = new IdentityHashMap(N.initHashCapacity(size));
        } else if (m instanceof LinkedHashMap) {
            res = new LinkedHashMap(N.initHashCapacity(size));
        } else if (m instanceof ImmutableMap) {
            res = new LinkedHashMap(N.initHashCapacity(size));
        } else {
            try {
                res = (Map)N.newInstance(m.getClass());
            }
            catch (Exception e) {
                res = new LinkedHashMap(N.initHashCapacity(size));
            }
        }
        return res;
    }

    static Map newOrderingMap(Map<?, ?> m) {
        if (m == null) {
            return new HashMap();
        }
        Map res = null;
        if (HashMap.class.equals(m.getClass())) {
            res = new HashMap(N.initHashCapacity(m.size()));
        } else if (m instanceof SortedMap) {
            res = new LinkedHashMap(N.initHashCapacity(m.size()));
        } else if (m instanceof IdentityHashMap) {
            res = new IdentityHashMap(N.initHashCapacity(m.size()));
        } else if (m instanceof LinkedHashMap) {
            res = new LinkedHashMap(N.initHashCapacity(m.size()));
        } else if (m instanceof ImmutableMap) {
            res = new LinkedHashMap(N.initHashCapacity(m.size()));
        } else {
            try {
                res = (Map)N.newInstance(m.getClass());
            }
            catch (Exception e) {
                res = new LinkedHashMap(N.initHashCapacity(m.size()));
            }
        }
        return res;
    }

    public static <K, V> u.Nullable<V> get(Map<K, V> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return u.Nullable.empty();
        }
        V val = map.get(key);
        if (val != null || map.containsKey(key)) {
            return u.Nullable.of(val);
        }
        return u.Nullable.empty();
    }

    public static <K, V> List<V> getIfPresentForEach(Map<K, V> map, Collection<?> keys) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(keys)) {
            return new ArrayList(0);
        }
        ArrayList<Object> result = new ArrayList<Object>(keys.size());
        Object val = null;
        for (Object key : keys) {
            val = map.get(key);
            if (val == null && !map.containsKey(key)) continue;
            result.add(val);
        }
        return result;
    }

    public static <K, V> V getOrDefault(Map<K, V> map, Object key, V defaultValue) {
        if (N.isNullOrEmpty(map)) {
            return defaultValue;
        }
        V val = map.get(key);
        if (val != null || map.containsKey(key)) {
            return val;
        }
        return defaultValue;
    }

    public static <K, E, V extends List<E>> List<E> getOrEmptyList(Map<K, V> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return N.emptyList();
        }
        List val = (List)map.get(key);
        if (val != null || map.containsKey(key)) {
            return val;
        }
        return N.emptyList();
    }

    public static <K, E, V extends Set<E>> Set<E> getOrEmptySet(Map<K, V> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return N.emptySet();
        }
        Set val = (Set)map.get(key);
        if (val != null || map.containsKey(key)) {
            return val;
        }
        return N.emptySet();
    }

    public static <K, V> List<V> getOrDefaultForEach(Map<K, V> map, Collection<?> keys, V defaultValue) {
        if (N.isNullOrEmpty(keys)) {
            return new ArrayList(0);
        }
        if (N.isNullOrEmpty(map)) {
            return new ArrayList<V>(Arrays.asList(Array.repeat(defaultValue, keys.size())));
        }
        ArrayList<V> result = new ArrayList<V>(keys.size());
        Object val = null;
        for (Object key : keys) {
            val = map.get(key);
            if (val != null || map.containsKey(key)) {
                result.add(val);
                continue;
            }
            result.add(defaultValue);
        }
        return result;
    }

    public static <K, E> List<E> getAndPutListIfAbsent(Map<K, List<E>> map, K key) {
        List<E> v = map.get(key);
        if (v == null) {
            v = new ArrayList();
            v = map.put(key, v);
        }
        return v;
    }

    public static <K, E> Set<E> getAndPutSetIfAbsent(Map<K, Set<E>> map, K key) {
        Set<Object> v = map.get(key);
        if (v == null) {
            v = N.newHashSet();
            v = map.put(key, v);
        }
        return v;
    }

    public static <K, E> Set<E> getAndPutLinkedHashSetIfAbsent(Map<K, Set<E>> map, K key) {
        Set<Object> v = map.get(key);
        if (v == null) {
            v = N.newLinkedHashSet();
            v = map.put(key, v);
        }
        return v;
    }

    public static <K, KK, VV> Map<KK, VV> getAndPutMapIfAbsent(Map<K, Map<KK, VV>> map, K key) {
        Map<KK, VV> v = map.get(key);
        if (v == null) {
            v = new HashMap<KK, VV>();
            v = map.put(key, v);
        }
        return v;
    }

    public static boolean contains(Map<?, ?> map, Map.Entry<?, ?> entry) {
        return Maps.contains(map, entry.getKey(), entry.getValue());
    }

    public static boolean contains(Map<?, ?> map, Object key, Object value) {
        if (N.isNullOrEmpty(map)) {
            return false;
        }
        Object val = map.get(key);
        return val == null ? value == null && map.containsKey(key) : N.equals(val, value);
    }

    public static <K, V> Map<K, V> intersection(Map<K, V> map, Map<? extends K, ? extends V> map2) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(map2)) {
            return new LinkedHashMap();
        }
        AbstractMap result = map instanceof IdentityHashMap ? new IdentityHashMap() : new LinkedHashMap();
        Object val = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            val = map2.get(entry.getKey());
            if ((val == null || !N.equals(val, entry.getValue())) && (entry.getValue() != null || !map.containsKey(entry.getKey()))) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> Map<K, Pair<V, u.Nullable<V>>> difference(Map<K, V> map, Map<K, V> map2) {
        AbstractMap result;
        if (N.isNullOrEmpty(map)) {
            return new LinkedHashMap();
        }
        AbstractMap abstractMap = result = map instanceof IdentityHashMap ? new IdentityHashMap() : new LinkedHashMap();
        if (N.isNullOrEmpty(map2)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                result.put(entry.getKey(), Pair.of(entry.getValue(), u.Nullable.empty()));
            }
        } else {
            Object val = null;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                val = map2.get(entry.getKey());
                if (val == null && !map2.containsKey(entry.getKey())) {
                    result.put(entry.getKey(), Pair.of(entry.getValue(), u.Nullable.empty()));
                    continue;
                }
                if (N.equals(val, entry.getValue())) continue;
                result.put(entry.getKey(), Pair.of(entry.getValue(), u.Nullable.of(val)));
            }
        }
        return result;
    }

    public static <K, V> Map<K, Pair<u.Nullable<V>, u.Nullable<V>>> symmetricDifference(Map<K, V> map, Map<K, V> map2) {
        AbstractMap result;
        block10: {
            boolean isIdentityHashMap = N.notNullOrEmpty(map) && map instanceof IdentityHashMap || N.notNullOrEmpty(map2) && map2 instanceof IdentityHashMap;
            AbstractMap abstractMap = result = isIdentityHashMap ? new IdentityHashMap() : new LinkedHashMap();
            if (N.notNullOrEmpty(map)) {
                if (N.isNullOrEmpty(map2)) {
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        result.put(entry.getKey(), Pair.of(u.Nullable.of(entry.getValue()), u.Nullable.empty()));
                    }
                } else {
                    Object key = null;
                    Object val2 = null;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        key = entry.getKey();
                        val2 = map2.get(key);
                        if (val2 == null && !map2.containsKey(key)) {
                            result.put(key, Pair.of(u.Nullable.of(entry.getValue()), u.Nullable.empty()));
                            continue;
                        }
                        if (N.equals(val2, entry.getValue())) continue;
                        result.put(key, Pair.of(u.Nullable.of(entry.getValue()), u.Nullable.of(val2)));
                    }
                }
            }
            if (!N.notNullOrEmpty(map2)) break block10;
            if (N.isNullOrEmpty(map)) {
                for (Map.Entry<K, V> entry : map2.entrySet()) {
                    result.put(entry.getKey(), Pair.of(u.Nullable.empty(), u.Nullable.of(entry.getValue())));
                }
            } else {
                for (Map.Entry<K, V> entry : map2.entrySet()) {
                    if (map.containsKey(entry.getKey())) continue;
                    result.put(entry.getKey(), Pair.of(u.Nullable.empty(), u.Nullable.of(entry.getValue())));
                }
            }
        }
        return result;
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        V v = map.get(key);
        if (v == null) {
            v = map.put(key, value);
        }
        return v;
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K key, Supplier<V> supplier) {
        V v = map.get(key);
        if (v == null) {
            v = map.put(key, supplier.get());
        }
        return v;
    }

    public static <K, V> boolean remove(Map<K, V> map, Map.Entry<?, ?> entry) {
        return Maps.remove(map, entry.getKey(), entry.getValue());
    }

    public static <K, V> boolean remove(Map<K, V> map, Object key, Object value) {
        if (N.isNullOrEmpty(map)) {
            return false;
        }
        V curValue = map.get(key);
        if (!N.equals(curValue, value) || curValue == null && !map.containsKey(key)) {
            return false;
        }
        map.remove(key);
        return true;
    }

    public static boolean removeKeys(Map<?, ?> map, Collection<?> keysToRemove) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(keysToRemove)) {
            return false;
        }
        int originalSize = map.size();
        for (Object key : keysToRemove) {
            map.remove(key);
        }
        return map.size() < originalSize;
    }

    public static boolean removeEntries(Map<?, ?> map, Map<?, ?> entriesToRemove) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(entriesToRemove)) {
            return false;
        }
        int originalSize = map.size();
        for (Map.Entry<?, ?> entry : entriesToRemove.entrySet()) {
            if (!N.equals(map.get(entry.getKey()), entry.getValue())) continue;
            map.remove(entry.getKey());
        }
        return map.size() < originalSize;
    }

    public static <K, V, E extends Exception> boolean removeIf(Map<K, V> map, Try.Predicate<? super Map.Entry<K, V>, E> filter) throws E {
        ArrayList<K> keysToRemove = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.test(entry)) continue;
            if (keysToRemove == null) {
                keysToRemove = new ArrayList<K>(7);
            }
            keysToRemove.add(entry.getKey());
        }
        if (N.notNullOrEmpty(keysToRemove)) {
            for (Map.Entry<K, V> key : keysToRemove) {
                map.remove(key);
            }
            return true;
        }
        return false;
    }

    public static <K, V, E extends Exception> boolean removeIfKey(Map<K, V> map, Try.Predicate<? super K, E> filter) throws E {
        ArrayList<K> keysToRemove = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            if (keysToRemove == null) {
                keysToRemove = new ArrayList<K>(7);
            }
            keysToRemove.add(entry.getKey());
        }
        if (N.notNullOrEmpty(keysToRemove)) {
            for (Map.Entry<K, V> key : keysToRemove) {
                map.remove(key);
            }
            return true;
        }
        return false;
    }

    public static <K, V, E extends Exception> boolean removeIfValue(Map<K, V> map, Try.Predicate<? super V, E> filter) throws E {
        ArrayList<K> keysToRemove = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.test(entry.getValue())) continue;
            if (keysToRemove == null) {
                keysToRemove = new ArrayList<K>(7);
            }
            keysToRemove.add(entry.getKey());
        }
        if (N.notNullOrEmpty(keysToRemove)) {
            for (Map.Entry<K, V> key : keysToRemove) {
                map.remove(key);
            }
            return true;
        }
        return false;
    }

    public static <K, V> boolean replace(Map<K, V> map, K key, V oldValue, V newValue) {
        if (N.isNullOrEmpty(map)) {
            return false;
        }
        V curValue = map.get(key);
        if (!N.equals(curValue, oldValue) || curValue == null && !map.containsKey(key)) {
            return false;
        }
        map.put(key, newValue);
        return true;
    }

    public static <K, V> V replace(Map<K, V> map, K key, V newValue) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        V curValue = null;
        V v = map.get(key);
        curValue = v;
        if (v != null || map.containsKey(key)) {
            curValue = map.put(key, newValue);
        }
        return curValue;
    }

    public static <K, V, E extends Exception> void replaceAll(Map<K, V> map, Try.BiFunction<? super K, ? super V, ? extends V, E> function) throws E {
        N.checkArgNotNull(function);
        if (N.isNullOrEmpty(map)) {
            return;
        }
        Object k = null;
        Object v = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            v = function.apply(k, v);
            try {
                entry.setValue(v);
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
        }
    }

    public static <K, V, E extends Exception> void forEach(Map<K, V> map, Try.BiConsumer<? super K, ? super V, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(map)) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public static <K, V, E extends Exception> Map<K, V> filter(Map<K, V> map, Try.BiPredicate<? super K, ? super V, E> predicate) throws E {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newTargetMap(map, 0);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V, E extends Exception> Map<K, V> filterByKey(Map<K, V> map, Try.Predicate<? super K, E> predicate) throws E {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newTargetMap(map, 0);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V, E extends Exception> Map<K, V> filterByValue(Map<K, V> map, Try.Predicate<? super V, E> predicate) throws E {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newTargetMap(map, 0);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> Map<V, K> invert(Map<K, V> map) {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newOrderingMap(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V, E extends Exception> Map<V, K> invert(Map<K, V> map, Try.BinaryOperator<K, E> mergeOp) throws E {
        N.checkArgNotNull(mergeOp, "mergeOp");
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newOrderingMap(map);
        Object oldVal = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            oldVal = result.get(entry.getValue());
            if (oldVal != null || result.containsKey(entry.getValue())) {
                result.put(entry.getValue(), mergeOp.apply(oldVal, entry.getKey()));
                continue;
            }
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> Map<V, List<K>> flatInvert(Map<K, ? extends Collection<? extends V>> map) {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newOrderingMap(map);
        for (Map.Entry<K, Collection<V>> entry : map.entrySet()) {
            Collection<V> c = entry.getValue();
            if (!N.notNullOrEmpty(c)) continue;
            for (V v : c) {
                ArrayList<K> list = (ArrayList<K>)result.get(v);
                if (list == null) {
                    list = new ArrayList<K>();
                    result.put(v, list);
                }
                list.add(entry.getKey());
            }
        }
        return result;
    }

    public static <T> T map2Entity(Class<T> targetClass, Map<String, Object> m) {
        return Maps.map2Entity(targetClass, m, false, true);
    }

    public static <T> T map2Entity(Class<T> targetClass, Map<String, Object> m, boolean ignoreNullProperty, boolean ignoreUnknownProperty) {
        Maps.checkEntityClass(targetClass);
        T entity = N.newInstance(targetClass);
        String propName = null;
        Object propValue = null;
        Method propSetMethod = null;
        Class<?> paramClass = null;
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            propName = entry.getKey();
            propValue = entry.getValue();
            if (ignoreNullProperty && propValue == null) continue;
            propSetMethod = ClassUtil.getPropSetMethod(targetClass, propName);
            if (propSetMethod == null) {
                ClassUtil.setPropValue(entity, propName, propValue, ignoreUnknownProperty);
                continue;
            }
            paramClass = propSetMethod.getParameterTypes()[0];
            if (propValue != null && N.typeOf(propValue.getClass()).isMap() && ClassUtil.isEntity(paramClass)) {
                ClassUtil.setPropValue(entity, propSetMethod, Maps.map2Entity(paramClass, (Map)propValue, ignoreNullProperty, ignoreUnknownProperty));
                continue;
            }
            ClassUtil.setPropValue(entity, propSetMethod, propValue);
        }
        return entity;
    }

    public static <T> T map2Entity(Class<T> targetClass, Map<String, Object> m, Collection<String> selectPropNames) {
        Maps.checkEntityClass(targetClass);
        T entity = N.newInstance(targetClass);
        Object propValue = null;
        Method propSetMethod = null;
        Class<?> paramClass = null;
        for (String propName : selectPropNames) {
            propValue = m.get(propName);
            if (propValue == null && !m.containsKey(propName)) {
                throw new IllegalArgumentException("Property name: " + propName + " is not found in map with key set: " + m.keySet());
            }
            propSetMethod = ClassUtil.getPropSetMethod(targetClass, propName);
            if (propSetMethod == null) {
                ClassUtil.setPropValue(entity, propName, propValue, false);
                continue;
            }
            paramClass = propSetMethod.getParameterTypes()[0];
            if (propValue != null && N.typeOf(propValue.getClass()).isMap() && ClassUtil.isEntity(paramClass)) {
                ClassUtil.setPropValue(entity, propSetMethod, Maps.map2Entity(paramClass, (Map)propValue));
                continue;
            }
            ClassUtil.setPropValue(entity, propSetMethod, propValue);
        }
        return entity;
    }

    public static <T> List<T> map2Entity(Class<T> targetClass, Collection<Map<String, Object>> mList) {
        return Maps.map2Entity(targetClass, mList, false, true);
    }

    public static <T> List<T> map2Entity(Class<T> targetClass, Collection<Map<String, Object>> mList, boolean igoreNullProperty, boolean ignoreUnknownProperty) {
        Maps.checkEntityClass(targetClass);
        ArrayList<T> entityList = new ArrayList<T>(mList.size());
        for (Map<String, Object> m : mList) {
            entityList.add(Maps.map2Entity(targetClass, m, igoreNullProperty, ignoreUnknownProperty));
        }
        return entityList;
    }

    public static <T> List<T> map2Entity(Class<T> targetClass, Collection<Map<String, Object>> mList, Collection<String> selectPropNames) {
        Maps.checkEntityClass(targetClass);
        ArrayList<T> entityList = new ArrayList<T>(mList.size());
        for (Map<String, Object> m : mList) {
            entityList.add(Maps.map2Entity(targetClass, m, selectPropNames));
        }
        return entityList;
    }

    private static <T> void checkEntityClass(Class<T> cls) {
        if (!ClassUtil.isEntity(cls)) {
            throw new IllegalArgumentException("No property getter/setter method is found in the specified class: " + ClassUtil.getCanonicalClassName(cls));
        }
    }

    public static Map<String, Object> entity2Map(Object entity) {
        return Maps.entity2Map(entity, false);
    }

    public static Map<String, Object> entity2Map(Object entity, boolean ignoreNullProperty) {
        return Maps.entity2Map(entity, ignoreNullProperty, null);
    }

    public static Map<String, Object> entity2Map(Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entity, false, ignoredPropNames);
    }

    public static Map<String, Object> entity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static Map<String, Object> entity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        int initCapacity = entity instanceof DirtyMarker ? DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() : N.initHashCapacity(ClassUtil.getPropGetMethodList(entity.getClass()).size());
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(initCapacity);
        Maps.entity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy);
        return resultMap;
    }

    public static <M extends Map<String, Object>> M entity2Map(Object entity, Supplier<? extends M> mapSupplier) {
        return (M)Maps.entity2Map((Map)mapSupplier.get(), entity);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity) {
        return Maps.entity2Map(resultMap, entity, false);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, boolean ignoreNullProperty) {
        return Maps.entity2Map(resultMap, entity, ignoreNullProperty, null);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(resultMap, entity, false, ignoredPropNames);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        keyNamingPolicy = keyNamingPolicy == null ? NamingPolicy.LOWER_CAMEL_CASE : keyNamingPolicy;
        boolean hasIgnoredPropNames = N.notNullOrEmpty(ignoredPropNames);
        Set<String> signedPropNames = null;
        if (entity instanceof DirtyMarker) {
            Class<?> entityClass = entity.getClass();
            signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)entity);
            if (signedPropNames.size() == 0) {
                return resultMap;
            }
            Set tmp = N.newHashSet(N.initHashCapacity(signedPropNames.size()));
            for (String string : signedPropNames) {
                tmp.add(ClassUtil.getPropNameByMethod(ClassUtil.getPropGetMethod(entityClass, string)));
            }
            signedPropNames = tmp;
        }
        Map<String, Method> getterMethodList = ClassUtil.checkPropGetMethodList(entity.getClass());
        String propName = null;
        Object propValue = null;
        try {
            switch (keyNamingPolicy) {
                case LOWER_CAMEL_CASE: {
                    for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                        propName = entry.getKey();
                        if (signedPropNames != null && !signedPropNames.contains(propName) || hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                        propValue = entry.getValue().invoke(entity, new Object[0]);
                        if (ignoreNullProperty && propValue == null) continue;
                        resultMap.put((String)propName, (Object)propValue);
                    }
                    break;
                }
                case LOWER_CASE_WITH_UNDERSCORE: {
                    for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                        propName = entry.getKey();
                        if (signedPropNames != null && !signedPropNames.contains(propName) || hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                        propValue = entry.getValue().invoke(entity, new Object[0]);
                        if (ignoreNullProperty && propValue == null) continue;
                        resultMap.put((String)ClassUtil.toLowerCaseWithUnderscore(propName), (Object)propValue);
                    }
                    break;
                }
                case UPPER_CASE_WITH_UNDERSCORE: {
                    for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                        propName = entry.getKey();
                        if (signedPropNames != null && !signedPropNames.contains(propName) || hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                        propValue = entry.getValue().invoke(entity, new Object[0]);
                        if (ignoreNullProperty && propValue == null) continue;
                        resultMap.put((String)ClassUtil.toUpperCaseWithUnderscore(propName), (Object)propValue);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported NamingPolicy: " + (Object)((Object)keyNamingPolicy));
                }
            }
        }
        catch (Exception exception) {
            throw N.toRuntimeException(exception);
        }
        return resultMap;
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList) {
        return Maps.entity2Map(entityList, false);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, boolean ignoreNullProperty) {
        return Maps.entity2Map(entityList, ignoreNullProperty, null);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entityList, false, ignoredPropNames);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entityList, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(entityList.size());
        for (Object entity : entityList) {
            resultList.add(Maps.entity2Map(entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy));
        }
        return resultList;
    }

    public static Map<String, Object> deepEntity2Map(Object entity) {
        return Maps.deepEntity2Map(entity, false);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, boolean ignoreNullProperty) {
        return Maps.deepEntity2Map(entity, ignoreNullProperty, null);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(entity, false, ignoredPropNames);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        int initCapacity = entity instanceof DirtyMarker ? DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() : N.initHashCapacity(ClassUtil.getPropGetMethodList(entity.getClass()).size());
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(initCapacity);
        Maps.deepEntity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy);
        return resultMap;
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(Object entity, Supplier<? extends M> mapSupplier) {
        return (M)Maps.deepEntity2Map((Map)mapSupplier.get(), entity);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity) {
        return Maps.deepEntity2Map(resultMap, entity, false);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, boolean ignoreNullProperty) {
        return Maps.deepEntity2Map(resultMap, entity, ignoreNullProperty, null);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(resultMap, entity, false, ignoredPropNames);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        keyNamingPolicy = keyNamingPolicy == null ? NamingPolicy.LOWER_CAMEL_CASE : keyNamingPolicy;
        boolean hasIgnoredPropNames = N.notNullOrEmpty(ignoredPropNames);
        Set<String> signedPropNames = null;
        if (entity instanceof DirtyMarker) {
            Class<?> entityClass = entity.getClass();
            signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)entity);
            if (signedPropNames.size() == 0) {
                return resultMap;
            }
            Set tmp = N.newHashSet(N.initHashCapacity(signedPropNames.size()));
            for (String string : signedPropNames) {
                tmp.add(ClassUtil.getPropNameByMethod(ClassUtil.getPropGetMethod(entityClass, string)));
            }
            signedPropNames = tmp;
        }
        Map<String, Method> getterMethodList = ClassUtil.checkPropGetMethodList(entity.getClass());
        String propName = null;
        Object propValue = null;
        try {
            switch (keyNamingPolicy) {
                case LOWER_CAMEL_CASE: {
                    for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                        propName = entry.getKey();
                        if (signedPropNames != null && !signedPropNames.contains(propName) || hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                        propValue = entry.getValue().invoke(entity, new Object[0]);
                        if (ignoreNullProperty && propValue == null) continue;
                        if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                            resultMap.put((String)propName, (Object)propValue);
                            continue;
                        }
                        resultMap.put((String)propName, Maps.deepEntity2Map(propValue, ignoreNullProperty, null, keyNamingPolicy));
                    }
                    break;
                }
                case LOWER_CASE_WITH_UNDERSCORE: {
                    for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                        propName = entry.getKey();
                        if (signedPropNames != null && !signedPropNames.contains(propName) || hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                        propValue = entry.getValue().invoke(entity, new Object[0]);
                        if (ignoreNullProperty && propValue == null) continue;
                        if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                            resultMap.put((String)ClassUtil.toLowerCaseWithUnderscore(propName), (Object)propValue);
                            continue;
                        }
                        resultMap.put((String)ClassUtil.toLowerCaseWithUnderscore(propName), Maps.deepEntity2Map(propValue, ignoreNullProperty, null, keyNamingPolicy));
                    }
                    break;
                }
                case UPPER_CASE_WITH_UNDERSCORE: {
                    for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                        propName = entry.getKey();
                        if (signedPropNames != null && !signedPropNames.contains(propName) || hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                        propValue = entry.getValue().invoke(entity, new Object[0]);
                        if (ignoreNullProperty && propValue == null) continue;
                        if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                            resultMap.put((String)ClassUtil.toUpperCaseWithUnderscore(propName), (Object)propValue);
                            continue;
                        }
                        resultMap.put((String)ClassUtil.toUpperCaseWithUnderscore(propName), Maps.deepEntity2Map(propValue, ignoreNullProperty, null, keyNamingPolicy));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported NamingPolicy: " + (Object)((Object)keyNamingPolicy));
                }
            }
        }
        catch (Exception exception) {
            throw N.toRuntimeException(exception);
        }
        return resultMap;
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList) {
        return Maps.deepEntity2Map(entityList, false);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, boolean ignoreNullProperty) {
        return Maps.deepEntity2Map(entityList, ignoreNullProperty, null);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, Collection<String> ignoredPropNames) {
        boolean ignoreNullProperty = N.isNullOrEmpty(entityList) ? true : !((entityList instanceof ArrayList ? ((ArrayList)entityList).get(0) : entityList.iterator().next()) instanceof DirtyMarker);
        return Maps.deepEntity2Map(entityList, ignoreNullProperty, ignoredPropNames);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(entityList, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(entityList.size());
        for (Object entity : entityList) {
            resultList.add(Maps.deepEntity2Map(entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy));
        }
        return resultList;
    }

    public static Map<String, Object> entity2FlatMap(Object entity) {
        return Maps.entity2FlatMap(entity, false);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, boolean ignoreNullProperty) {
        return Maps.entity2FlatMap(entity, ignoreNullProperty, null);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entity, false, ignoredPropNames);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        int initCapacity = entity instanceof DirtyMarker ? DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() : N.initHashCapacity(ClassUtil.getPropGetMethodList(entity.getClass()).size());
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(initCapacity);
        Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy);
        return resultMap;
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(Object entity, Supplier<? extends M> mapSupplier) {
        return (M)Maps.entity2FlatMap((Map)mapSupplier.get(), entity);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity) {
        return Maps.entity2FlatMap(resultMap, entity, false);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, boolean ignoreNullProperty) {
        return Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, null);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(resultMap, entity, false, ignoredPropNames);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        return Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy, null);
    }

    static <T extends Map<String, Object>> T entity2FlatMap(T resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy, String parentPropName) {
        boolean isNullParentPropName;
        boolean hasIgnoredPropNames = N.notNullOrEmpty(ignoredPropNames);
        boolean bl = isNullParentPropName = parentPropName == null;
        if (entity instanceof DirtyMarker) {
            Class<?> entityClass = entity.getClass();
            Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)entity);
            if (signedPropNames.size() != 0) {
                Method propGetMethod = null;
                Object propValue = null;
                try {
                    switch (keyNamingPolicy) {
                        case LOWER_CAMEL_CASE: {
                            for (String propName : signedPropNames) {
                                propGetMethod = ClassUtil.getPropGetMethod(entityClass, propName);
                                propName = ClassUtil.getPropNameByMethod(propGetMethod);
                                if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                                propValue = propGetMethod.invoke(entity, new Object[0]);
                                if (ignoreNullProperty && propValue == null) continue;
                                if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                                    if (isNullParentPropName) {
                                        resultMap.put((String)propName, (Object)propValue);
                                        continue;
                                    }
                                    resultMap.put((String)(parentPropName + "." + propName), (Object)propValue);
                                    continue;
                                }
                                if (isNullParentPropName) {
                                    Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, propName);
                                    continue;
                                }
                                Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, parentPropName + "." + propName);
                            }
                        }
                        case LOWER_CASE_WITH_UNDERSCORE: {
                            for (String propName : signedPropNames) {
                                propGetMethod = ClassUtil.getPropGetMethod(entityClass, propName);
                                propName = ClassUtil.getPropNameByMethod(propGetMethod);
                                if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                                propName = ClassUtil.toLowerCaseWithUnderscore(propName);
                                propValue = propGetMethod.invoke(entity, new Object[0]);
                                if (ignoreNullProperty && propValue == null) continue;
                                if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                                    if (isNullParentPropName) {
                                        resultMap.put((String)propName, (Object)propValue);
                                        continue;
                                    }
                                    resultMap.put((String)(parentPropName + "." + propName), (Object)propValue);
                                    continue;
                                }
                                if (isNullParentPropName) {
                                    Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, propName);
                                    continue;
                                }
                                Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, parentPropName + "." + propName);
                            }
                        }
                        case UPPER_CASE_WITH_UNDERSCORE: {
                            for (String propName : signedPropNames) {
                                propGetMethod = ClassUtil.getPropGetMethod(entityClass, propName);
                                propName = ClassUtil.getPropNameByMethod(propGetMethod);
                                if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                                propName = ClassUtil.toUpperCaseWithUnderscore(propName);
                                propValue = propGetMethod.invoke(entity, new Object[0]);
                                if (ignoreNullProperty && propValue == null) continue;
                                if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                                    if (isNullParentPropName) {
                                        resultMap.put((String)propName, (Object)propValue);
                                        continue;
                                    }
                                    resultMap.put((String)(parentPropName + "." + propName), (Object)propValue);
                                    continue;
                                }
                                if (isNullParentPropName) {
                                    Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, propName);
                                    continue;
                                }
                                Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, parentPropName + "." + propName);
                            }
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported NamingPolicy: " + (Object)((Object)keyNamingPolicy));
                        }
                    }
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        } else {
            Map<String, Method> getterMethodList = ClassUtil.checkPropGetMethodList(entity.getClass());
            String propName = null;
            Object propValue = null;
            try {
                switch (keyNamingPolicy) {
                    case LOWER_CAMEL_CASE: {
                        for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                            propName = entry.getKey();
                            if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                            propValue = entry.getValue().invoke(entity, new Object[0]);
                            if (ignoreNullProperty && propValue == null) continue;
                            if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                                if (isNullParentPropName) {
                                    resultMap.put((String)propName, (Object)propValue);
                                    continue;
                                }
                                resultMap.put((String)(parentPropName + "." + propName), (Object)propValue);
                                continue;
                            }
                            if (isNullParentPropName) {
                                Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, propName);
                                continue;
                            }
                            Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, parentPropName + "." + propName);
                        }
                        break;
                    }
                    case LOWER_CASE_WITH_UNDERSCORE: {
                        for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                            propName = entry.getKey();
                            if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                            propName = ClassUtil.toLowerCaseWithUnderscore(propName);
                            propValue = entry.getValue().invoke(entity, new Object[0]);
                            if (ignoreNullProperty && propValue == null) continue;
                            if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                                if (isNullParentPropName) {
                                    resultMap.put((String)propName, (Object)propValue);
                                    continue;
                                }
                                resultMap.put((String)(parentPropName + "." + propName), (Object)propValue);
                                continue;
                            }
                            if (isNullParentPropName) {
                                Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, propName);
                                continue;
                            }
                            Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, parentPropName + "." + propName);
                        }
                        break;
                    }
                    case UPPER_CASE_WITH_UNDERSCORE: {
                        for (Map.Entry<String, Method> entry : getterMethodList.entrySet()) {
                            propName = entry.getKey();
                            if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                            propName = ClassUtil.toUpperCaseWithUnderscore(propName);
                            propValue = entry.getValue().invoke(entity, new Object[0]);
                            if (ignoreNullProperty && propValue == null) continue;
                            if (propValue == null || !ClassUtil.isEntity(propValue.getClass())) {
                                if (isNullParentPropName) {
                                    resultMap.put((String)propName, (Object)propValue);
                                    continue;
                                }
                                resultMap.put((String)(parentPropName + "." + propName), (Object)propValue);
                                continue;
                            }
                            if (isNullParentPropName) {
                                Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, propName);
                                continue;
                            }
                            Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, parentPropName + "." + propName);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported NamingPolicy: " + (Object)((Object)keyNamingPolicy));
                    }
                }
            }
            catch (Exception e) {
                throw N.toRuntimeException(e);
            }
        }
        return resultMap;
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList) {
        return Maps.entity2FlatMap(entityList, false);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, boolean ignoreNullProperty) {
        return Maps.entity2FlatMap(entityList, ignoreNullProperty, null);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entityList, false, ignoredPropNames);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entityList, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(entityList.size());
        for (Object entity : entityList) {
            resultList.add(Maps.entity2FlatMap(entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy));
        }
        return resultList;
    }

    public static Map<String, Object> flatten(Map<String, Object> map) {
        return Maps.flatten(map, Fn.Suppliers.ofMap());
    }

    public static <M extends Map<String, Object>> M flatten(Map<String, Object> map, Supplier<? extends M> mapSupplier) {
        return Maps.flatten(map, ".", mapSupplier);
    }

    public static <M extends Map<String, Object>> M flatten(Map<String, Object> map, String delimiter, Supplier<? extends M> mapSupplier) {
        Map result = (Map)mapSupplier.get();
        Maps.flatten(map, null, delimiter, result);
        return (M)result;
    }

    private static void flatten(Map<String, Object> map, String prefix, String delimiter, Map<String, Object> output) {
        if (N.isNullOrEmpty(map)) {
            return;
        }
        if (N.isNullOrEmpty(prefix)) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    Maps.flatten((Map)entry.getValue(), entry.getKey(), delimiter, output);
                    continue;
                }
                output.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    Maps.flatten((Map)entry.getValue(), prefix + delimiter + entry.getKey(), delimiter, output);
                    continue;
                }
                output.put(prefix + delimiter + entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, Object> unflatten(Map<String, Object> map) {
        return Maps.unflatten(map, Fn.Suppliers.ofMap());
    }

    public static <M extends Map<String, Object>> M unflatten(Map<String, Object> map, Supplier<? extends M> mapSupplier) {
        return Maps.unflatten(map, ".", mapSupplier);
    }

    public static <M extends Map<String, Object>> M unflatten(Map<String, Object> map, String delimiter, Supplier<? extends M> mapSupplier) {
        Map result = (Map)mapSupplier.get();
        Splitter keySplitter = Splitter.with(delimiter);
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getKey().indexOf(delimiter) >= 0) {
                    String[] keys = keySplitter.splitToArray(entry.getKey());
                    Map lastMap = result;
                    int to = keys.length - 1;
                    for (int i = 0; i < to; ++i) {
                        Map tmp = (Map)lastMap.get(keys[i]);
                        if (tmp == null) {
                            tmp = (Map)mapSupplier.get();
                            lastMap.put(keys[i], tmp);
                        }
                        lastMap = tmp;
                    }
                    lastMap.put(keys[keys.length - 1], entry.getValue());
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return (M)result;
    }

    static Supplier mapType2Supplier(final Class<? extends Map> mapType) {
        if (HashMap.class.equals(mapType)) {
            return Fn.Suppliers.ofMap();
        }
        if (SortedMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofTreeMap();
        }
        if (IdentityHashMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofIdentityHashMap();
        }
        if (LinkedHashMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofLinkedHashMap();
        }
        if (ImmutableMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofLinkedHashMap();
        }
        return new Supplier<Map>(){

            @Override
            public Map get() {
                try {
                    return (Map)N.newInstance(mapType);
                }
                catch (Exception e) {
                    return new LinkedHashMap();
                }
            }
        };
    }

    static <K, V> void replaceAll(Map<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        N.checkArgNotNull(function);
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                entry.setValue(function.apply(entry.getKey(), entry.getValue()));
            }
        }
        catch (IllegalStateException ise) {
            throw new ConcurrentModificationException(ise);
        }
    }

    static <K, V, E extends Exception> void merge(Map<K, V> map, K key, V value, Try.BiFunction<? super V, ? super V, ? extends V, E> remappingFunction) throws E {
        V oldValue = map.get(key);
        if (oldValue == null && !map.containsKey(key)) {
            map.put(key, value);
        } else {
            map.put(key, remappingFunction.apply(oldValue, value));
        }
    }
}

