/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public abstract class Matth {
    private static final long ONE_BITS = Double.doubleToRawLongBits(1.0);
    static final int INT_MAX_POWER_OF_SQRT2_UNSIGNED = -1257966797;
    static final long MAX_POWER_OF_SQRT2_UNSIGNED = -5402926248376769404L;
    static final long MAX_SIGNED_POWER_OF_TWO = 0x4000000000000000L;
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    static final int FLOOR_SQRT_MAX_INT = 46340;
    static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    static final int SIGNIFICAND_BITS = 52;
    static final long EXPONENT_MASK = 0x7FF0000000000000L;
    static final long SIGN_MASK = Long.MIN_VALUE;
    static final int EXPONENT_BIAS = 1023;
    static final long IMPLICIT_BIT = 0x10000000000000L;
    private static final double MIN_INT_AS_DOUBLE = -2.147483648E9;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;
    static final byte[] int_maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    static final int[] int_powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] int_factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    static int[] int_biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};
    static final int[] int_halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    static final byte[] maxLog10ForLeadingZeros = new byte[]{19, 18, 18, 18, 18, 17, 17, 17, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0};
    static final long[] powersOf10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    static final long[] halfPowersOf10 = new long[]{3L, 31L, 316L, 3162L, 31622L, 316227L, 3162277L, 31622776L, 316227766L, 3162277660L, 31622776601L, 316227766016L, 3162277660168L, 31622776601683L, 316227766016837L, 3162277660168379L, 31622776601683793L, 316227766016837933L, 3162277660168379331L};
    static final long[] long_factorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 3810779, 121977, 16175, 4337, 1733, 887, 534, 361, 265, 206, 169, 143, 125, 111, 101, 94, 88, 83, 79, 76, 74, 72, 70, 69, 68, 67, 67, 66, 66, 66, 66};
    static final int[] biggestSimpleBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2642246, 86251, 11724, 3218, 1313, 684, 419, 287, 214, 169, 139, 119, 105, 95, 87, 81, 76, 73, 70, 68, 66, 64, 63, 62, 62, 61, 61, 61};
    private static final int SIEVE_30 = -545925251;
    private static final long[][] millerRabinBaseSets = new long[][]{{291830L, 126401071349994536L}, {885594168L, 725270293939359937L, 3569819667048198375L}, {273919523040L, 15L, 7363882082L, 992620450144556L}, {47636622961200L, 2L, 2570940L, 211991001L, 3749873356L}, {7999252175582850L, 2L, 4130806001517L, 149795463772692060L, 186635894390467037L, 3967304179347715805L}, {585226005592931976L, 2L, 123635709730000L, 9233062284813009L, 43835965440333360L, 761179012939631437L, 1263739024124850375L}, {Long.MAX_VALUE, 2L, 325L, 9375L, 28178L, 450775L, 9780504L, 1795265022L}};
    static final double F_1_3 = 0.3333333333333333;
    static final double F_1_5 = 0.2;
    static final double F_1_7 = 0.14285714285714285;
    static final double F_1_9 = 0.1111111111111111;
    static final double F_1_11 = 0.09090909090909091;
    static final double F_1_13 = 0.07692307692307693;
    static final double F_1_15 = 0.06666666666666667;
    static final double F_1_17 = 0.058823529411764705;
    static final double F_3_4 = 0.75;
    static final double F_15_16 = 0.9375;
    static final double F_13_14 = 0.9285714285714286;
    static final double F_11_12 = 0.9166666666666666;
    static final double F_9_10 = 0.9;
    static final double F_7_8 = 0.875;
    static final double F_5_6 = 0.8333333333333334;
    static final double F_1_2 = 0.5;
    static final double F_1_4 = 0.25;
    static final int SQRT2_PRECOMPUTE_THRESHOLD = 256;
    static final BigInteger SQRT2_PRECOMPUTED_BITS = new BigInteger("16a09e667f3bcc908b2fb1366ea957d3e3adec17512775099da2f590b0667322a", 16);
    private static final double LN_10 = Math.log(10.0);
    private static final double LN_2 = Math.log(2.0);
    static final int MAX_FACTORIAL = 170;
    static final double[] everySixteenthFactorial = new double[]{1.0, 2.0922789888E13, 2.631308369336935E35, 1.2413915592536073E61, 1.2688693218588417E89, 7.156945704626381E118, 9.916779348709496E149, 1.974506857221074E182, 3.856204823625804E215, 5.5502938327393044E249, 4.7147236359920616E284};

    private Matth() {
    }

    public static boolean isPrime(long n) {
        if (n < 2L) {
            Matth.checkNonNegative("n", n);
            return false;
        }
        if (n < 14L && (n == 2L || n == 3L || n == 5L || n == 7L || n == 11L || n == 13L)) {
            return true;
        }
        if ((0xDF75D77D & 1 << (int)(n % 30L)) != 0) {
            return false;
        }
        if (n % 7L == 0L || n % 11L == 0L || n % 13L == 0L) {
            return false;
        }
        if (n < 289L) {
            return true;
        }
        for (long[] baseSet : millerRabinBaseSets) {
            if (n > baseSet[0]) continue;
            for (int i = 1; i < baseSet.length; ++i) {
                if (MillerRabinTester.test(baseSet[i], n)) continue;
                return false;
            }
            return true;
        }
        throw new AssertionError();
    }

    public static boolean isPerfectSquare(int n) {
        if (n < 0) {
            return false;
        }
        switch (n & 0xF) {
            case 0: 
            case 1: 
            case 4: 
            case 9: {
                long tst = (long)Math.sqrt(n);
                return tst * tst == (long)n;
            }
        }
        return false;
    }

    public static boolean isPerfectSquare(long n) {
        if (n < 0L) {
            return false;
        }
        switch ((int)(n & 0xFL)) {
            case 0: 
            case 1: 
            case 4: 
            case 9: {
                long tst = (long)Math.sqrt(n);
                return tst * tst == n;
            }
        }
        return false;
    }

    public static boolean isPowerOfTwo(int x) {
        return x > 0 & (x & x - 1) == 0;
    }

    public static boolean isPowerOfTwo(long x) {
        return x > 0L & (x & x - 1L) == 0L;
    }

    public static boolean isPowerOfTwo(double x) {
        return x > 0.0 && Matth.isFinite(x) && Matth.isPowerOfTwo(Matth.getSignificand(x));
    }

    public static boolean isPowerOfTwo(BigInteger x) {
        N.checkArgNotNull(x);
        return x.signum() > 0 && x.getLowestSetBit() == x.bitLength() - 1;
    }

    public static double log(double a) {
        return Math.log(a);
    }

    public static int log2(int x, RoundingMode mode) {
        Matth.checkPositive("x", x);
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(Matth.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(x - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Integer.numberOfLeadingZeros(x);
                int cmp = -1257966797 >>> leadingZeros;
                int logFloor = 31 - leadingZeros;
                return logFloor + Matth.lessThanBranchFree(cmp, x);
            }
        }
        throw new AssertionError();
    }

    public static int log2(long x, RoundingMode mode) {
        Matth.checkPositive("x", x);
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(Matth.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 63 - Long.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 64 - Long.numberOfLeadingZeros(x - 1L);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Long.numberOfLeadingZeros(x);
                long cmp = -5402926248376769404L >>> leadingZeros;
                int logFloor = 63 - leadingZeros;
                return logFloor + Matth.lessThanBranchFree(cmp, x);
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    public static double log2(double x) {
        return Math.log(x) / LN_2;
    }

    public static int log2(double x, RoundingMode mode) {
        boolean increment;
        N.checkArgument(x > 0.0 && Matth.isFinite(x), "x must be positive and finite");
        int exponent = Math.getExponent(x);
        if (!Matth.isNormal(x)) {
            return Matth.log2(x * 4.503599627370496E15, mode) - 52;
        }
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(Matth.isPowerOfTwo(x));
            }
            case FLOOR: {
                increment = false;
                break;
            }
            case CEILING: {
                increment = !Matth.isPowerOfTwo(x);
                break;
            }
            case DOWN: {
                increment = exponent < 0 & !Matth.isPowerOfTwo(x);
                break;
            }
            case UP: {
                increment = exponent >= 0 & !Matth.isPowerOfTwo(x);
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                double xScaled = Matth.scaleNormalize(x);
                increment = xScaled * xScaled > 2.0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? exponent + 1 : exponent;
    }

    public static int log2(BigInteger x, RoundingMode mode) {
        Matth.checkPositive("x", N.checkArgNotNull(x));
        int logFloor = x.bitLength() - 1;
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(Matth.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return Matth.isPowerOfTwo(x) ? logFloor : logFloor + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                if (logFloor < 256) {
                    BigInteger halfPower = SQRT2_PRECOMPUTED_BITS.shiftRight(256 - logFloor);
                    if (x.compareTo(halfPower) <= 0) {
                        return logFloor;
                    }
                    return logFloor + 1;
                }
                BigInteger x2 = x.pow(2);
                int logX2Floor = x2.bitLength() - 1;
                return logX2Floor < 2 * logFloor + 1 ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError();
    }

    public static int log10(int x, RoundingMode mode) {
        Matth.checkPositive("x", x);
        int logFloor = Matth.log10Floor(x);
        int floorPow = int_powersOf10[logFloor];
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(x == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return logFloor + Matth.lessThanBranchFree(floorPow, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return logFloor + Matth.lessThanBranchFree(int_halfPowersOf10[logFloor], x);
            }
        }
        throw new AssertionError();
    }

    private static int log10Floor(int x) {
        byte y = int_maxLog10ForLeadingZeros[Integer.numberOfLeadingZeros(x)];
        return y - Matth.lessThanBranchFree(x, int_powersOf10[y]);
    }

    public static int log10(long x, RoundingMode mode) {
        Matth.checkPositive("x", x);
        int logFloor = Matth.log10Floor(x);
        long floorPow = powersOf10[logFloor];
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(x == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return logFloor + Matth.lessThanBranchFree(floorPow, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return logFloor + Matth.lessThanBranchFree(halfPowersOf10[logFloor], x);
            }
        }
        throw new AssertionError();
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static int log10(BigInteger x, RoundingMode mode) {
        Matth.checkPositive("x", x);
        if (Matth.fitsInLong(x)) {
            return Matth.log10(x.longValue(), mode);
        }
        int approxLog10 = (int)((double)Matth.log2(x, RoundingMode.FLOOR) * LN_2 / LN_10);
        BigInteger approxPow = BigInteger.TEN.pow(approxLog10);
        int approxCmp = approxPow.compareTo(x);
        if (approxCmp > 0) {
            do {
                --approxLog10;
            } while ((approxCmp = (approxPow = approxPow.divide(BigInteger.TEN)).compareTo(x)) > 0);
        } else {
            BigInteger nextPow = BigInteger.TEN.multiply(approxPow);
            int nextCmp = nextPow.compareTo(x);
            while (nextCmp <= 0) {
                ++approxLog10;
                approxPow = nextPow;
                approxCmp = nextCmp;
                nextPow = BigInteger.TEN.multiply(approxPow);
                nextCmp = nextPow.compareTo(x);
            }
        }
        int floorLog = approxLog10;
        BigInteger floorPow = approxPow;
        int floorCmp = approxCmp;
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(floorCmp == 0);
            }
            case DOWN: 
            case FLOOR: {
                return floorLog;
            }
            case UP: 
            case CEILING: {
                return floorPow.equals(x) ? floorLog : floorLog + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                BigInteger x2 = x.pow(2);
                BigInteger halfPowerSquared = floorPow.pow(2).multiply(BigInteger.TEN);
                return x2.compareTo(halfPowerSquared) <= 0 ? floorLog : floorLog + 1;
            }
        }
        throw new AssertionError();
    }

    static boolean fitsInLong(BigInteger x) {
        return x.bitLength() <= 63;
    }

    public static int pow(int b, int k) {
        Matth.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                return k == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k & 1) == 0 ? 1 : -1;
            }
            case 2: {
                return k < 32 ? 1 << k : 0;
            }
            case -2: {
                if (k < 32) {
                    return (k & 1) == 0 ? 1 << k : -(1 << k);
                }
                return 0;
            }
        }
        int accum = 1;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return b * accum;
                }
            }
            accum *= (k & 1) == 0 ? 1 : b;
            b *= b;
            k >>= 1;
        }
    }

    public static long pow(long b, int k) {
        Matth.checkNonNegative("exponent", k);
        if (-2L <= b && b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    return k < 64 ? 1L << k : 0L;
                }
                case -2: {
                    if (k < 64) {
                        return (k & 1) == 0 ? 1L << k : -(1L << k);
                    }
                    return 0L;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return accum * b;
                }
            }
            accum *= (k & 1) == 0 ? 1L : b;
            b *= b;
            k >>= 1;
        }
    }

    public static long ceilingPowerOfTwo(long x) {
        Matth.checkPositive("x", x);
        if (x > 0x4000000000000000L) {
            throw new ArithmeticException("ceilingPowerOfTwo(" + x + ") is not representable as a long");
        }
        return 1L << -Long.numberOfLeadingZeros(x - 1L);
    }

    public static BigInteger ceilingPowerOfTwo(BigInteger x) {
        return BigInteger.ZERO.setBit(Matth.log2(x, RoundingMode.CEILING));
    }

    public static long floorPowerOfTwo(long x) {
        Matth.checkPositive("x", x);
        return 1L << 63 - Long.numberOfLeadingZeros(x);
    }

    public static BigInteger floorPowerOfTwo(BigInteger x) {
        return BigInteger.ZERO.setBit(Matth.log2(x, RoundingMode.FLOOR));
    }

    public static int sqrt(int x, RoundingMode mode) {
        Matth.checkNonNegative("x", x);
        int sqrtFloor = Matth.sqrtFloor(x);
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(sqrtFloor * sqrtFloor == x);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                return sqrtFloor + Matth.lessThanBranchFree(sqrtFloor * sqrtFloor, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return sqrtFloor + Matth.lessThanBranchFree(halfSquare, x);
            }
        }
        throw new AssertionError();
    }

    private static int sqrtFloor(int x) {
        return (int)Math.sqrt(x);
    }

    public static long sqrt(long x, RoundingMode mode) {
        Matth.checkNonNegative("x", x);
        if (Matth.fitsInInt(x)) {
            return Matth.sqrt((int)x, mode);
        }
        long guess = (long)Math.sqrt(x);
        long guessSquared = guess * guess;
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(guessSquared == x);
                return guess;
            }
            case DOWN: 
            case FLOOR: {
                if (x < guessSquared) {
                    return guess - 1L;
                }
                return guess;
            }
            case UP: 
            case CEILING: {
                if (x > guessSquared) {
                    return guess + 1L;
                }
                return guess;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long sqrtFloor = guess - (long)(x < guessSquared ? 1 : 0);
                long halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return sqrtFloor + (long)Matth.lessThanBranchFree(halfSquare, x);
            }
        }
        throw new AssertionError();
    }

    public static BigInteger sqrt(BigInteger x, RoundingMode mode) {
        Matth.checkNonNegative("x", x);
        if (Matth.fitsInLong(x)) {
            return BigInteger.valueOf(Matth.sqrt(x.longValue(), mode));
        }
        BigInteger sqrtFloor = Matth.sqrtFloor(x);
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(sqrtFloor.pow(2).equals(x));
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                int sqrtFloorInt = sqrtFloor.intValue();
                boolean sqrtFloorIsExact = sqrtFloorInt * sqrtFloorInt == x.intValue() && sqrtFloor.pow(2).equals(x);
                return sqrtFloorIsExact ? sqrtFloor : sqrtFloor.add(BigInteger.ONE);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                BigInteger halfSquare = sqrtFloor.pow(2).add(sqrtFloor);
                return halfSquare.compareTo(x) >= 0 ? sqrtFloor : sqrtFloor.add(BigInteger.ONE);
            }
        }
        throw new AssertionError();
    }

    private static BigInteger sqrtFloor(BigInteger x) {
        BigInteger sqrt0;
        int log2 = Matth.log2(x, RoundingMode.FLOOR);
        if (log2 < 1023) {
            sqrt0 = Matth.sqrtApproxWithDoubles(x);
        } else {
            int shift = log2 - 52 & 0xFFFFFFFE;
            sqrt0 = Matth.sqrtApproxWithDoubles(x.shiftRight(shift)).shiftLeft(shift >> 1);
        }
        BigInteger sqrt1 = sqrt0.add(x.divide(sqrt0)).shiftRight(1);
        if (sqrt0.equals(sqrt1)) {
            return sqrt0;
        }
        while ((sqrt1 = (sqrt0 = sqrt1).add(x.divide(sqrt0)).shiftRight(1)).compareTo(sqrt0) < 0) {
        }
        return sqrt0;
    }

    private static BigInteger sqrtApproxWithDoubles(BigInteger x) {
        return Matth.roundToBigInteger(Math.sqrt(Matth.bigToDouble(x)), RoundingMode.HALF_EVEN);
    }

    public static int divide(int p, int q, RoundingMode mode) {
        boolean increment;
        N.checkArgNotNull(mode);
        if (q == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int div = p / q;
        int rem = p - q * div;
        if (rem == 0) {
            return div;
        }
        int signum = 1 | (p ^ q) >> 31;
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(rem == 0);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int absRem = Math.abs(rem);
                int cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0) {
                    increment = mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_EVEN & (div & 1) != 0;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + signum : div;
    }

    public static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        N.checkArgNotNull(mode);
        long div = p / q;
        long rem = p - q * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(rem == 0L);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP | mode == RoundingMode.HALF_EVEN & (div & 1L) != 0L;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    public static BigInteger divide(BigInteger p, BigInteger q, RoundingMode mode) {
        BigDecimal pDec = new BigDecimal(p);
        BigDecimal qDec = new BigDecimal(q);
        return pDec.divide(qDec, 0, mode).toBigIntegerExact();
    }

    public static int mod(int x, int m) {
        if (m <= 0) {
            throw new ArithmeticException("Modulus " + m + " must be > 0");
        }
        int result = x % m;
        return result >= 0 ? result : result + m;
    }

    public static int mod(long x, int m) {
        return (int)Matth.mod(x, (long)m);
    }

    public static long mod(long x, long m) {
        if (m <= 0L) {
            throw new ArithmeticException("Modulus must be positive");
        }
        long result = x % m;
        return result >= 0L ? result : result + m;
    }

    public static int gcd(int a, int b) {
        Matth.checkNonNegative("a", a);
        Matth.checkNonNegative("b", b);
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            int delta = a - b;
            int minDeltaOrZero = delta & delta >> 31;
            a = delta - minDeltaOrZero - minDeltaOrZero;
            b += minDeltaOrZero;
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << Math.min(aTwos, bTwos);
    }

    public static long gcd(long a, long b) {
        Matth.checkNonNegative("a", a);
        Matth.checkNonNegative("b", b);
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        int aTwos = Long.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Long.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            long delta = a - b;
            long minDeltaOrZero = delta & delta >> 63;
            a = delta - minDeltaOrZero - minDeltaOrZero;
            b += minDeltaOrZero;
            a >>= Long.numberOfTrailingZeros(a);
        }
        return a << Math.min(aTwos, bTwos);
    }

    public static int lcm(int a, int b) throws ArithmeticException {
        if (a == 0 || b == 0) {
            return 0;
        }
        int lcm = Math.abs(Matth.addExact(a / Matth.gcd(a, b), b));
        if (lcm == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return lcm;
    }

    public static long lcm(long a, long b) throws ArithmeticException {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long lcm = Math.abs(Matth.addExact(a / Matth.gcd(a, b), b));
        if (lcm == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return lcm;
    }

    public static int addExact(int a, int b) {
        long result = (long)a + (long)b;
        Matth.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static long addExact(long a, long b) {
        long result = a + b;
        Matth.checkNoOverflow((a ^ b) < 0L | (a ^ result) >= 0L);
        return result;
    }

    public static int subtractExact(int a, int b) {
        long result = (long)a - (long)b;
        Matth.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static long subtractExact(long a, long b) {
        long result = a - b;
        Matth.checkNoOverflow((a ^ b) >= 0L | (a ^ result) >= 0L);
        return result;
    }

    public static int multiplyExact(int a, int b) {
        long result = (long)a * (long)b;
        Matth.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static long multiplyExact(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        Matth.checkNoOverflow(leadingZeros >= 64);
        Matth.checkNoOverflow(a >= 0L | b != Long.MIN_VALUE);
        long result = a * b;
        Matth.checkNoOverflow(a == 0L || result / a == b);
        return result;
    }

    public static int powExact(int b, int k) {
        Matth.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                return k == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k & 1) == 0 ? 1 : -1;
            }
            case 2: {
                Matth.checkNoOverflow(k < 31);
                return 1 << k;
            }
            case -2: {
                Matth.checkNoOverflow(k < 32);
                return (k & 1) == 0 ? 1 << k : -1 << k;
            }
        }
        int accum = 1;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Matth.multiplyExact(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Matth.multiplyExact(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            Matth.checkNoOverflow(-46340 <= b & b <= 46340);
            b *= b;
        }
    }

    public static long powExact(long b, int k) {
        Matth.checkNonNegative("exponent", k);
        if (b >= -2L & b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    Matth.checkNoOverflow(k < 63);
                    return 1L << k;
                }
                case -2: {
                    Matth.checkNoOverflow(k < 64);
                    return (k & 1) == 0 ? 1L << k : -1L << k;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Matth.multiplyExact(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Matth.multiplyExact(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            Matth.checkNoOverflow(-3037000499L <= b && b <= 3037000499L);
            b *= b;
        }
    }

    public static int castExact(long value) {
        int result = (int)value;
        if ((long)result != value) {
            throw new IllegalArgumentException("Out of range: " + value);
        }
        return result;
    }

    public static int saturatedAdd(int a, int b) {
        return Matth.saturatedCast((long)a + (long)b);
    }

    public static long saturatedAdd(long a, long b) {
        long naiveSum;
        if ((a ^ b) < 0L | (a ^ (naiveSum = a + b)) >= 0L) {
            return naiveSum;
        }
        return Long.MAX_VALUE + (naiveSum >>> 63 ^ 1L);
    }

    public static int saturatedSubtract(int a, int b) {
        return Matth.saturatedCast((long)a - (long)b);
    }

    public static long saturatedSubtract(long a, long b) {
        long naiveDifference;
        if ((a ^ b) >= 0L | (a ^ (naiveDifference = a - b)) >= 0L) {
            return naiveDifference;
        }
        return Long.MAX_VALUE + (naiveDifference >>> 63 ^ 1L);
    }

    public static int saturatedMultiply(int a, int b) {
        return Matth.saturatedCast((long)a * (long)b);
    }

    public static long saturatedMultiply(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        long limit = Long.MAX_VALUE + ((a ^ b) >>> 63);
        if (leadingZeros < 64 | a < 0L & b == Long.MIN_VALUE) {
            return limit;
        }
        long result = a * b;
        if (a == 0L || result / a == b) {
            return result;
        }
        return limit;
    }

    public static int saturatedPow(int b, int k) {
        Matth.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                return k == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k & 1) == 0 ? 1 : -1;
            }
            case 2: {
                if (k >= 31) {
                    return Integer.MAX_VALUE;
                }
                return 1 << k;
            }
            case -2: {
                if (k >= 32) {
                    return Integer.MAX_VALUE + (k & 1);
                }
                return (k & 1) == 0 ? 1 << k : -1 << k;
            }
        }
        int accum = 1;
        int limit = Integer.MAX_VALUE + (b >>> 31 & (k & 1));
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Matth.saturatedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Matth.saturatedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            if (-46340 > b | b > 46340) {
                return limit;
            }
            b *= b;
        }
    }

    public static long saturatedPow(long b, int k) {
        Matth.checkNonNegative("exponent", k);
        if (b >= -2L & b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    if (k >= 63) {
                        return Long.MAX_VALUE;
                    }
                    return 1L << k;
                }
                case -2: {
                    if (k >= 64) {
                        return Long.MAX_VALUE + (long)(k & 1);
                    }
                    return (k & 1) == 0 ? 1L << k : -1L << k;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        long limit = Long.MAX_VALUE + (b >>> 63 & (long)(k & 1));
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Matth.saturatedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Matth.saturatedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            if (-3037000499L > b | b > 3037000499L) {
                return limit;
            }
            b *= b;
        }
    }

    public static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static int factorial(int n) {
        Matth.checkNonNegative("n", n);
        return n < int_factorials.length ? int_factorials[n] : Integer.MAX_VALUE;
    }

    public static long factoriall(int n) {
        Matth.checkNonNegative("n", n);
        return n < long_factorials.length ? long_factorials[n] : Long.MAX_VALUE;
    }

    public static double factorialll(int n) {
        Matth.checkNonNegative("n", n);
        if (n > 170) {
            return Double.POSITIVE_INFINITY;
        }
        double accum = 1.0;
        for (int i = 1 + (n & 0xFFFFFFF0); i <= n; ++i) {
            accum *= (double)i;
        }
        return accum * everySixteenthFactorial[n >> 4];
    }

    public static BigInteger facttorial(int n) {
        Matth.checkNonNegative("n", n);
        if (n < long_factorials.length) {
            return BigInteger.valueOf(long_factorials[n]);
        }
        int approxSize = Matth.divide(n * Matth.log2(n, RoundingMode.CEILING), 64, RoundingMode.CEILING);
        ArrayList<BigInteger> bignums = new ArrayList<BigInteger>(approxSize);
        int startingNumber = long_factorials.length;
        long product = long_factorials[startingNumber - 1];
        int shift = Long.numberOfTrailingZeros(product);
        int productBits = Matth.log2(product >>= shift, RoundingMode.FLOOR) + 1;
        int bits = Matth.log2(startingNumber, RoundingMode.FLOOR) + 1;
        int nextPowerOfTwo = 1 << bits - 1;
        for (long num = (long)startingNumber; num <= (long)n; ++num) {
            if ((num & (long)nextPowerOfTwo) != 0L) {
                nextPowerOfTwo <<= 1;
                ++bits;
            }
            int tz = Long.numberOfTrailingZeros(num);
            long normalizedNum = num >> tz;
            shift += tz;
            int normalizedBits = bits - tz;
            if (normalizedBits + productBits >= 64) {
                bignums.add(BigInteger.valueOf(product));
                product = 1L;
                productBits = 0;
            }
            productBits = Matth.log2(product *= normalizedNum, RoundingMode.FLOOR) + 1;
        }
        if (product > 1L) {
            bignums.add(BigInteger.valueOf(product));
        }
        return Matth.listProduct(bignums).shiftLeft(shift);
    }

    static BigInteger listProduct(List<BigInteger> nums) {
        return Matth.listProduct(nums, 0, nums.size());
    }

    static BigInteger listProduct(List<BigInteger> nums, int start, int end) {
        switch (end - start) {
            case 0: {
                return BigInteger.ONE;
            }
            case 1: {
                return nums.get(start);
            }
            case 2: {
                return nums.get(start).multiply(nums.get(start + 1));
            }
            case 3: {
                return nums.get(start).multiply(nums.get(start + 1)).multiply(nums.get(start + 2));
            }
        }
        int m = end + start >>> 1;
        return Matth.listProduct(nums, start, m).multiply(Matth.listProduct(nums, m, end));
    }

    public static int binomial(int n, int k) {
        Matth.checkNonNegative("n", n);
        Matth.checkNonNegative("k", k);
        N.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        if (k >= int_biggestBinomials.length || n > int_biggestBinomials[k]) {
            return Integer.MAX_VALUE;
        }
        switch (k) {
            case 0: {
                return 1;
            }
            case 1: {
                return n;
            }
        }
        long result = 1L;
        for (int i = 0; i < k; ++i) {
            result *= (long)(n - i);
            result /= (long)(i + 1);
        }
        return (int)result;
    }

    public static long binomiall(int n, int k) {
        Matth.checkNonNegative("n", n);
        Matth.checkNonNegative("k", k);
        N.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        switch (k) {
            case 0: {
                return 1L;
            }
            case 1: {
                return n;
            }
        }
        if (n < long_factorials.length) {
            return long_factorials[n] / (long_factorials[k] * long_factorials[n - k]);
        }
        if (k >= biggestBinomials.length || n > biggestBinomials[k]) {
            return Long.MAX_VALUE;
        }
        if (k < biggestSimpleBinomials.length && n <= biggestSimpleBinomials[k]) {
            long result = n--;
            for (int i = 2; i <= k; ++i) {
                result *= (long)n;
                result /= (long)i;
                --n;
            }
            return result;
        }
        int nBits = Matth.log2(n, RoundingMode.CEILING);
        long result = 1L;
        long numerator = n--;
        long denominator = 1L;
        int numeratorBits = nBits;
        int i = 2;
        while (i <= k) {
            if (numeratorBits + nBits < 63) {
                numerator *= (long)n;
                denominator *= (long)i;
                numeratorBits += nBits;
            } else {
                result = Matth.multiplyFraction(result, numerator, denominator);
                numerator = n;
                denominator = i;
                numeratorBits = nBits;
            }
            ++i;
            --n;
        }
        return Matth.multiplyFraction(result, numerator, denominator);
    }

    public static BigInteger binnomial(int n, int k) {
        int bits;
        Matth.checkNonNegative("n", n);
        Matth.checkNonNegative("k", k);
        N.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        if (k < biggestBinomials.length && n <= biggestBinomials[k]) {
            return BigInteger.valueOf(Matth.binomial(n, k));
        }
        BigInteger accum = BigInteger.ONE;
        long numeratorAccum = n;
        long denominatorAccum = 1L;
        int numeratorBits = bits = Matth.log2(n, RoundingMode.CEILING);
        for (int i = 1; i < k; ++i) {
            int p = n - i;
            int q = i + 1;
            if (numeratorBits + bits >= 63) {
                accum = accum.multiply(BigInteger.valueOf(numeratorAccum)).divide(BigInteger.valueOf(denominatorAccum));
                numeratorAccum = p;
                denominatorAccum = q;
                numeratorBits = bits;
                continue;
            }
            numeratorAccum *= (long)p;
            denominatorAccum *= (long)q;
            numeratorBits += bits;
        }
        return accum.multiply(BigInteger.valueOf(numeratorAccum)).divide(BigInteger.valueOf(denominatorAccum));
    }

    public static int mean(int x, int y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    public static long mean(long x, long y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    public static double mean(double x, double y) {
        return Matth.checkFinite(x) + (Matth.checkFinite(x) - x) / 2.0;
    }

    @SafeVarargs
    public static double mean(int ... values) {
        N.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long sum = 0L;
        for (int index = 0; index < values.length; ++index) {
            sum += (long)values[index];
        }
        return (double)sum / (double)values.length;
    }

    @SafeVarargs
    public static double mean(long ... values) {
        N.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long count = 1L;
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            mean += ((double)values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    @SafeVarargs
    public static double mean(double ... values) {
        N.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long count = 1L;
        double mean = Matth.checkFinite(values[0]);
        for (int index = 1; index < values.length; ++index) {
            Matth.checkFinite(values[index]);
            mean += (values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    private static double checkFinite(double argument) {
        N.checkArgument(Matth.isFinite(argument));
        return argument;
    }

    static double roundIntermediate(double x, RoundingMode mode) {
        if (!Matth.isFinite(x)) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        switch (mode) {
            case UNNECESSARY: {
                Matth.checkRoundingUnnecessary(Matth.isMathematicalInteger(x));
                return x;
            }
            case FLOOR: {
                if (x >= 0.0 || Matth.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x - 1L;
            }
            case CEILING: {
                if (x <= 0.0 || Matth.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + 1L;
            }
            case DOWN: {
                return x;
            }
            case UP: {
                if (Matth.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + (long)(x > 0.0 ? 1 : -1);
            }
            case HALF_EVEN: {
                return Math.rint(x);
            }
            case HALF_UP: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x + Math.copySign(0.5, x);
                }
                return z;
            }
            case HALF_DOWN: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x;
                }
                return z;
            }
        }
        throw new AssertionError();
    }

    public static int roundToInt(double x, RoundingMode mode) {
        double z = Matth.roundIntermediate(x, mode);
        Matth.checkInRange(z > -2.147483649E9 & z < 2.147483648E9);
        return (int)z;
    }

    public static long roundToLong(double x, RoundingMode mode) {
        double z = Matth.roundIntermediate(x, mode);
        Matth.checkInRange(-9.223372036854776E18 - z < 1.0 & z < 9.223372036854776E18);
        return (long)z;
    }

    public static BigInteger roundToBigInteger(double x, RoundingMode mode) {
        if (-9.223372036854776E18 - (x = Matth.roundIntermediate(x, mode)) < 1.0 & x < 9.223372036854776E18) {
            return BigInteger.valueOf((long)x);
        }
        int exponent = Math.getExponent(x);
        long significand = Matth.getSignificand(x);
        BigInteger result = BigInteger.valueOf(significand).shiftLeft(exponent - 52);
        return x < 0.0 ? result.negate() : result;
    }

    public static boolean fuzzyEquals(double a, double b, double tolerance) {
        Matth.checkNonNegative("tolerance", tolerance);
        return Math.copySign(a - b, 1.0) <= tolerance || a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static int fuzzyCompare(double a, double b, double tolerance) {
        if (Matth.fuzzyEquals(a, b, tolerance)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return Boolean.compare(Double.isNaN(a), Double.isNaN(b));
    }

    public static boolean isMathematicalInteger(double x) {
        return Matth.isFinite(x) && (x == 0.0 || 52 - Long.numberOfTrailingZeros(Matth.getSignificand(x)) <= Math.getExponent(x));
    }

    static int lessThanBranchFree(long x, long y) {
        return (int)((x - y ^ 0xFFFFFFFFFFFFFFFFL ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
    }

    static int log10Floor(long x) {
        byte y = maxLog10ForLeadingZeros[Long.numberOfLeadingZeros(x)];
        return y - Matth.lessThanBranchFree(x, powersOf10[y]);
    }

    static long multiplyFraction(long x, long numerator, long denominator) {
        if (x == 1L) {
            return numerator / denominator;
        }
        long commonDivisor = Matth.gcd(x, denominator);
        return (x /= commonDivisor) * (numerator / (denominator /= commonDivisor));
    }

    static double nextDown(double d) {
        return -Math.nextUp(-d);
    }

    static long getSignificand(double d) {
        N.checkArgument(Matth.isFinite(d), "not a normal value");
        int exponent = Math.getExponent(d);
        long bits = Double.doubleToRawLongBits(d);
        return exponent == -1023 ? bits << 1 : (bits &= 0xFFFFFFFFFFFFFL) | 0x10000000000000L;
    }

    static boolean isFinite(double d) {
        return Math.getExponent(d) <= 1023;
    }

    static boolean isNormal(double d) {
        return Math.getExponent(d) >= -1022;
    }

    static double scaleNormalize(double x) {
        long significand = Double.doubleToRawLongBits(x) & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(significand | ONE_BITS);
    }

    static double bigToDouble(BigInteger x) {
        BigInteger absX = x.abs();
        int exponent = absX.bitLength() - 1;
        if (exponent < 63) {
            return x.longValue();
        }
        if (exponent > 1023) {
            return (double)x.signum() * Double.POSITIVE_INFINITY;
        }
        int shift = exponent - 52 - 1;
        long twiceSignifFloor = absX.shiftRight(shift).longValue();
        long signifFloor = twiceSignifFloor >> 1;
        boolean increment = (twiceSignifFloor & 1L) != 0L && (((signifFloor &= 0xFFFFFFFFFFFFFL) & 1L) != 0L || absX.getLowestSetBit() < shift);
        long signifRounded = increment ? signifFloor + 1L : signifFloor;
        long bits = (long)(exponent + 1023) << 52;
        bits += signifRounded;
        return Double.longBitsToDouble(bits |= (long)x.signum() & Long.MIN_VALUE);
    }

    static double ensureNonNegative(double value) {
        N.checkArgument(!Double.isNaN(value));
        if (value > 0.0) {
            return value;
        }
        return 0.0;
    }

    static int lessThanBranchFree(int x, int y) {
        return ~(~(x - y)) >>> 31;
    }

    static boolean fitsInInt(long x) {
        return (long)((int)x) == x;
    }

    static int checkPositive(String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be > 0");
        }
        return x;
    }

    static long checkPositive(String role, long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException(role + " (" + x + ") must be > 0");
        }
        return x;
    }

    static BigInteger checkPositive(String role, BigInteger x) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be > 0");
        }
        return x;
    }

    static int checkNonNegative(String role, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static long checkNonNegative(String role, long x) {
        if (x < 0L) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static BigInteger checkNonNegative(String role, BigInteger x) {
        if (x.signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static double checkNonNegative(String role, double x) {
        if (!(x >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRange(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("not in range");
        }
    }

    static void checkNoOverflow(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("overflow");
        }
    }

    public static double asinh(double a) {
        double absAsinh;
        boolean negative = false;
        if (a < 0.0) {
            negative = true;
            a = -a;
        }
        if (a > 0.167) {
            absAsinh = Math.log(Math.sqrt(a * a + 1.0) + a);
        } else {
            double a2 = a * a;
            absAsinh = a > 0.097 ? a * (1.0 - a2 * (0.3333333333333333 - a2 * (0.2 - a2 * (0.14285714285714285 - a2 * (0.1111111111111111 - a2 * (0.09090909090909091 - a2 * (0.07692307692307693 - a2 * (0.06666666666666667 - a2 * 0.058823529411764705 * 0.9375) * 0.9285714285714286) * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (a > 0.036 ? a * (1.0 - a2 * (0.3333333333333333 - a2 * (0.2 - a2 * (0.14285714285714285 - a2 * (0.1111111111111111 - a2 * (0.09090909090909091 - a2 * 0.07692307692307693 * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (a > 0.0036 ? a * (1.0 - a2 * (0.3333333333333333 - a2 * (0.2 - a2 * (0.14285714285714285 - a2 * 0.1111111111111111 * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : a * (1.0 - a2 * (0.3333333333333333 - a2 * 0.2 * 0.75) * 0.5)));
        }
        return negative ? -absAsinh : absAsinh;
    }

    public static double acosh(double a) {
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static double atanh(double a) {
        double absAtanh;
        boolean negative = false;
        if (a < 0.0) {
            negative = true;
            a = -a;
        }
        if (a > 0.15) {
            absAtanh = 0.5 * Math.log((1.0 + a) / (1.0 - a));
        } else {
            double a2 = a * a;
            absAtanh = a > 0.087 ? a * (1.0 + a2 * (0.3333333333333333 + a2 * (0.2 + a2 * (0.14285714285714285 + a2 * (0.1111111111111111 + a2 * (0.09090909090909091 + a2 * (0.07692307692307693 + a2 * (0.06666666666666667 + a2 * 0.058823529411764705)))))))) : (a > 0.031 ? a * (1.0 + a2 * (0.3333333333333333 + a2 * (0.2 + a2 * (0.14285714285714285 + a2 * (0.1111111111111111 + a2 * (0.09090909090909091 + a2 * 0.07692307692307693)))))) : (a > 0.003 ? a * (1.0 + a2 * (0.3333333333333333 + a2 * (0.2 + a2 * (0.14285714285714285 + a2 * 0.1111111111111111)))) : a * (1.0 + a2 * (0.3333333333333333 + a2 * 0.2))));
        }
        return negative ? -absAtanh : absAtanh;
    }

    public static abstract class Mathh
    extends Matth {
        private Mathh() {
        }
    }

    private static enum MillerRabinTester {
        SMALL{

            @Override
            long mulMod(long a, long b, long m) {
                return a * b % m;
            }

            @Override
            long squareMod(long a, long m) {
                return a * a % m;
            }
        }
        ,
        LARGE{

            private long plusMod(long a, long b, long m) {
                return a >= m - b ? a + b - m : a + b;
            }

            private long times2ToThe32Mod(long a, long m) {
                int shift;
                int remainingPowersOf2 = 32;
                do {
                    shift = Math.min(remainingPowersOf2, Long.numberOfLeadingZeros(a));
                    a = UnsignedLongs.remainder(a << shift, m);
                } while ((remainingPowersOf2 -= shift) > 0);
                return a;
            }

            @Override
            long mulMod(long a, long b, long m) {
                long aHi = a >>> 32;
                long bHi = b >>> 32;
                long aLo = a & 0xFFFFFFFFL;
                long bLo = b & 0xFFFFFFFFL;
                long result = this.times2ToThe32Mod(aHi * bHi, m);
                if ((result += aHi * bLo) < 0L) {
                    result = UnsignedLongs.remainder(result, m);
                }
                result += aLo * bHi;
                result = this.times2ToThe32Mod(result, m);
                return this.plusMod(result, UnsignedLongs.remainder(aLo * bLo, m), m);
            }

            @Override
            long squareMod(long a, long m) {
                long aHi = a >>> 32;
                long aLo = a & 0xFFFFFFFFL;
                long result = this.times2ToThe32Mod(aHi * aHi, m);
                long hiLo = aHi * aLo * 2L;
                if (hiLo < 0L) {
                    hiLo = UnsignedLongs.remainder(hiLo, m);
                }
                result += hiLo;
                result = this.times2ToThe32Mod(result, m);
                return this.plusMod(result, UnsignedLongs.remainder(aLo * aLo, m), m);
            }
        };


        static boolean test(long base, long n) {
            return (n <= 3037000499L ? SMALL : LARGE).testWitness(base, n);
        }

        abstract long mulMod(long var1, long var3, long var5);

        abstract long squareMod(long var1, long var3);

        private long powMod(long a, long p, long m) {
            long res = 1L;
            while (p != 0L) {
                if ((p & 1L) != 0L) {
                    res = this.mulMod(res, a, m);
                }
                a = this.squareMod(a, m);
                p >>= 1;
            }
            return res;
        }

        private boolean testWitness(long base, long n) {
            int r = Long.numberOfTrailingZeros(n - 1L);
            long d = n - 1L >> r;
            if ((base %= n) == 0L) {
                return true;
            }
            long a = this.powMod(base, d, n);
            if (a == 1L) {
                return true;
            }
            int j = 0;
            while (a != n - 1L) {
                if (++j == r) {
                    return false;
                }
                a = this.squareMod(a, n);
            }
            return true;
        }
    }

    static final class UnsignedLongs {
        public static final long MAX_VALUE = -1L;

        private UnsignedLongs() {
        }

        private static long flip(long a) {
            return a ^ Long.MIN_VALUE;
        }

        static int compare(long a, long b) {
            return Long.compare(UnsignedLongs.flip(a), UnsignedLongs.flip(b));
        }

        static long remainder(long dividend, long divisor) {
            long rem;
            if (divisor < 0L) {
                if (UnsignedLongs.compare(dividend, divisor) < 0) {
                    return dividend;
                }
                return dividend - divisor;
            }
            if (dividend >= 0L) {
                return dividend % divisor;
            }
            long quotient = (dividend >>> 1) / divisor << 1;
            return rem - (UnsignedLongs.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
        }
    }
}

