/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class Multimap<K, E, V extends Collection<E>> {
    final Supplier<? extends Map<K, V>> mapSupplier;
    final Supplier<? extends V> valueSupplier;
    final Map<K, V> valueMap;

    Multimap() {
        this(HashMap.class, ArrayList.class);
    }

    Multimap(int initialCapacity) {
        this(new HashMap(initialCapacity), Fn.Suppliers.ofList());
    }

    Multimap(Class<? extends Map> mapType, Class<? extends Collection> valueType) {
        this(Maps.mapType2Supplier(mapType), Multimap.valueType2Supplier(valueType));
    }

    Multimap(Supplier<? extends Map<K, V>> mapSupplier, Supplier<? extends V> valueSupplier) {
        this.mapSupplier = mapSupplier;
        this.valueSupplier = valueSupplier;
        this.valueMap = mapSupplier.get();
    }

    @Internal
    Multimap(Map<K, V> valueMap, Supplier<? extends V> valueSupplier) {
        this.mapSupplier = Maps.mapType2Supplier(valueMap.getClass());
        this.valueSupplier = valueSupplier;
        this.valueMap = valueMap;
    }

    static Supplier valueType2Supplier(final Class<? extends Collection> valueType) {
        if (Modifier.isAbstract(valueType.getModifiers())) {
            if (List.class.isAssignableFrom(valueType)) {
                return Fn.Suppliers.ofList();
            }
            if (Set.class.isAssignableFrom(valueType)) {
                return Fn.Suppliers.ofSet();
            }
            if (Queue.class.isAssignableFrom(valueType)) {
                return Fn.Suppliers.ofArrayDeque();
            }
            throw new IllegalArgumentException("Unsupported collection type: " + valueType.getCanonicalName());
        }
        return new Supplier<Collection>(){

            @Override
            public Collection get() {
                return (Collection)N.newInstance(valueType);
            }
        };
    }

    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M from(Map<? extends K, ? extends E> map, IntFunction<? extends M> multimapSupplier) {
        Multimap multimap = (Multimap)multimapSupplier.apply(map == null ? 0 : map.size());
        if (N.notNullOrEmpty(map)) {
            multimap.putAll(map);
        }
        return (M)multimap;
    }

    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M fromm(Map<? extends K, ? extends Collection<? extends E>> map, IntFunction<? extends M> multimapSupplier) {
        Multimap multimap = (Multimap)multimapSupplier.apply(map == null ? 0 : map.size());
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
                multimap.putAll(entry.getKey(), entry.getValue());
            }
        }
        return (M)multimap;
    }

    public static <T, K, V extends Collection<T>, M extends Multimap<K, T, V>, X extends Exception> M from(Collection<? extends T> c, Try.Function<? super T, ? extends K, X> keyMapper, IntFunction<? extends M> multimapSupplier) throws X {
        Multimap multimap = (Multimap)multimapSupplier.apply(c == null ? 0 : c.size());
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                multimap.put(keyMapper.apply(e), e);
            }
        }
        return (M)multimap;
    }

    public static <T, K, E, V extends Collection<E>, M extends Multimap<K, E, V>, X extends Exception, X2 extends Exception> M from(Collection<? extends T> c, Try.Function<? super T, ? extends K, X> keyMapper, Try.Function<? super T, ? extends E, X2> valueExtractor, IntFunction<? extends M> multimapSupplier) throws X, X2 {
        Multimap multimap = (Multimap)multimapSupplier.apply(c == null ? 0 : c.size());
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                multimap.put(keyMapper.apply(e), valueExtractor.apply(e));
            }
        }
        return (M)multimap;
    }

    public static <K, E, V extends Collection<K>, M extends Multimap<E, K, V>> M invertFrom(Map<K, E> map, IntFunction<? extends M> multimapSupplier) {
        Multimap multimap = (Multimap)multimapSupplier.apply(map == null ? 0 : map.size());
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, E> entry : map.entrySet()) {
                multimap.put(entry.getValue(), entry.getKey());
            }
        }
        return (M)multimap;
    }

    public static <K, E, V extends Collection<K>, M extends Multimap<E, K, V>> M flatInvertFrom(Map<K, ? extends Collection<? extends E>> map, IntFunction<? extends M> multimapSupplier) {
        Multimap multimap = (Multimap)multimapSupplier.apply(map == null ? 0 : map.size());
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
                Collection<E> c = entry.getValue();
                if (!N.notNullOrEmpty(c)) continue;
                for (E e : c) {
                    multimap.put(e, entry.getKey());
                }
            }
        }
        return (M)multimap;
    }

    public static <K, E, V extends Collection<E>, VV extends Collection<K>, M extends Multimap<E, K, VV>> M invertFrom(Multimap<K, E, V> multimap, IntFunction<? extends M> multimapSupplier) {
        Multimap res = (Multimap)multimapSupplier.apply(multimap == null ? 0 : multimap.size());
        if (N.notNullOrEmpty(multimap)) {
            for (Map.Entry<K, V> entry : multimap.entrySet()) {
                Collection c = (Collection)entry.getValue();
                if (!N.notNullOrEmpty(c)) continue;
                for (Object e : c) {
                    res.put(e, entry.getKey());
                }
            }
        }
        return (M)res;
    }

    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M concat(Map<? extends K, ? extends E> a, Map<? extends K, ? extends E> b, IntFunction<? extends M> multimapSupplier) {
        Multimap res = (Multimap)multimapSupplier.apply((a == null ? 0 : a.size()) + (b == null ? 0 : b.size()));
        res.putAll(a);
        res.putAll(b);
        return (M)res;
    }

    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M concat(Map<? extends K, ? extends E> a, Map<? extends K, ? extends E> b, Map<? extends K, ? extends E> c, IntFunction<? extends M> multimapSupplier) {
        Multimap res = (Multimap)multimapSupplier.apply((a == null ? 0 : a.size()) + (b == null ? 0 : b.size()) + (c == null ? 0 : c.size()));
        res.putAll(a);
        res.putAll(b);
        res.putAll(c);
        return (M)res;
    }

    public static <K, E, V extends Collection<E>> Multimap<K, E, V> wrap(Map<K, V> map, Supplier<? extends V> valueSupplier) {
        N.checkArgNotNull(map, "map");
        N.checkArgNotNull(valueSupplier, "valueSupplier");
        return new Multimap<K, E, V>(map, valueSupplier);
    }

    public V get(Object key) {
        return (V)((Collection)this.valueMap.get(key));
    }

    public V getOrDefault(Object key, V defaultValue) {
        Collection value = (Collection)this.valueMap.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (V)value;
    }

    public boolean put(K key, E e) {
        Collection val = (Collection)this.valueMap.get(key);
        if (val == null) {
            val = (Collection)this.valueSupplier.get();
            this.valueMap.put(key, val);
        }
        return val.add(e);
    }

    public boolean putIfAbsent(K key, E e) {
        Collection val = (Collection)this.valueMap.get(key);
        if (val == null) {
            val = (Collection)this.valueSupplier.get();
            this.valueMap.put(key, val);
        } else if (val.contains(e)) {
            return false;
        }
        return val.add(e);
    }

    public boolean putIfKeyAbsent(K key, E e) {
        Collection val = (Collection)this.valueMap.get(key);
        if (val == null) {
            val = (Collection)this.valueSupplier.get();
            val.add(e);
            this.valueMap.put(key, val);
            return true;
        }
        return false;
    }

    public boolean putAll(K key, Collection<? extends E> c) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        Collection val = (Collection)this.valueMap.get(key);
        if (val == null) {
            val = (Collection)this.valueSupplier.get();
            this.valueMap.put(key, val);
        }
        return val.addAll(c);
    }

    public boolean putAllIfKeyAbsent(K key, Collection<? extends E> c) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        Collection val = (Collection)this.valueMap.get(key);
        if (val == null) {
            val = (Collection)this.valueSupplier.get();
            val.addAll(c);
            this.valueMap.put(key, val);
            return true;
        }
        return false;
    }

    public boolean putAll(Map<? extends K, ? extends E> m) {
        if (N.isNullOrEmpty(m)) {
            return false;
        }
        boolean result = false;
        Object key = null;
        Collection val = null;
        for (Map.Entry<K, E> e : m.entrySet()) {
            key = e.getKey();
            val = (Collection)this.valueMap.get(key);
            if (val == null) {
                val = (Collection)this.valueSupplier.get();
                this.valueMap.put(key, val);
            }
            result |= val.add(e.getValue());
        }
        return result;
    }

    public boolean putAll(Multimap<? extends K, ? extends E, ? extends Collection<? extends E>> m) {
        if (N.isNullOrEmpty(m)) {
            return false;
        }
        boolean result = false;
        Object key = null;
        Collection val = null;
        for (Map.Entry<K, Collection<E>> e : m.entrySet()) {
            if (N.isNullOrEmpty(e.getValue())) continue;
            key = e.getKey();
            val = (Collection)this.valueMap.get(key);
            if (val == null) {
                val = (Collection)this.valueSupplier.get();
                this.valueMap.put(key, val);
            }
            result |= val.addAll(e.getValue());
        }
        return result;
    }

    public boolean remove(Object key, Object e) {
        Collection val = (Collection)this.valueMap.get(key);
        if (val != null && val.remove(e)) {
            if (val.isEmpty()) {
                this.valueMap.remove(key);
            }
            return true;
        }
        return false;
    }

    public V removeAll(Object key) {
        return (V)((Collection)this.valueMap.remove(key));
    }

    public boolean removeAll(Object key, Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        boolean result = false;
        Collection val = (Collection)this.valueMap.get(key);
        if (N.notNullOrEmpty(val)) {
            result = val.removeAll(c);
            if (val.isEmpty()) {
                this.valueMap.remove(key);
            }
        }
        return result;
    }

    public boolean removeAll(Map<? extends K, ? extends E> m) {
        if (N.isNullOrEmpty(m)) {
            return false;
        }
        boolean result = false;
        Object key = null;
        Collection val = null;
        for (Map.Entry<K, E> e : m.entrySet()) {
            key = e.getKey();
            val = (Collection)this.valueMap.get(key);
            if (!N.notNullOrEmpty(val)) continue;
            if (!result) {
                result = val.remove(e.getValue());
            } else {
                val.remove(e.getValue());
            }
            if (!val.isEmpty()) continue;
            this.valueMap.remove(key);
        }
        return result;
    }

    public boolean removeAll(Multimap<?, ?, ?> m) {
        if (N.isNullOrEmpty(m)) {
            return false;
        }
        boolean result = false;
        Object key = null;
        Collection val = null;
        for (Map.Entry<?, ?> e : m.entrySet()) {
            key = e.getKey();
            val = (Collection)this.valueMap.get(key);
            if (!N.notNullOrEmpty(val) || !N.notNullOrEmpty((Collection)e.getValue())) continue;
            if (!result) {
                result = val.removeAll((Collection)e.getValue());
            } else {
                val.removeAll((Collection)e.getValue());
            }
            if (!val.isEmpty()) continue;
            this.valueMap.remove(key);
        }
        return result;
    }

    public <X extends Exception> boolean removeIf(E value, Try.Predicate<? super K, X> predicate) throws X {
        Set<K> removingKeys = null;
        for (K key : this.valueMap.keySet()) {
            if (!predicate.test(key)) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(key);
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        boolean modified = false;
        for (Object k : removingKeys) {
            if (!this.remove(k, value)) continue;
            modified = true;
        }
        return modified;
    }

    public <X extends Exception> boolean removeIf(E value, Try.BiPredicate<? super K, ? super V, X> predicate) throws X {
        Set<K> removingKeys = null;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(entry.getKey());
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        boolean modified = false;
        for (Object k : removingKeys) {
            if (!this.remove(k, value)) continue;
            modified = true;
        }
        return modified;
    }

    public <X extends Exception> boolean removeAllIf(Collection<?> values, Try.Predicate<? super K, X> predicate) throws X {
        Set<K> removingKeys = null;
        for (K key : this.valueMap.keySet()) {
            if (!predicate.test(key)) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(key);
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        boolean modified = false;
        for (Object k : removingKeys) {
            if (!this.removeAll(k, values)) continue;
            modified = true;
        }
        return modified;
    }

    public <X extends Exception> boolean removeAllIf(Collection<?> values, Try.BiPredicate<? super K, ? super V, X> predicate) throws X {
        Set<K> removingKeys = null;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(entry.getKey());
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        boolean modified = false;
        for (Object k : removingKeys) {
            if (!this.removeAll(k, values)) continue;
            modified = true;
        }
        return modified;
    }

    public <X extends Exception> boolean removeAllIf(Try.Predicate<? super K, X> predicate) throws X {
        Set<Object> removingKeys = null;
        for (K key : this.valueMap.keySet()) {
            if (!predicate.test(key)) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(key);
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        for (Object k : removingKeys) {
            this.removeAll(k);
        }
        return true;
    }

    public <X extends Exception> boolean removeAllIf(Try.BiPredicate<? super K, ? super V, X> predicate) throws X {
        Set<Map.Entry<K, V>> removingKeys = null;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add((Map.Entry<K, V>)entry.getKey());
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        for (Map.Entry<K, V> k : removingKeys) {
            this.removeAll(k);
        }
        return true;
    }

    public boolean replace(K key, Object oldValue, E newValue) {
        Collection val = (Collection)this.valueMap.get(key);
        if (val == null) {
            return false;
        }
        return this.replace((V)val, oldValue, newValue);
    }

    private boolean replace(V val, Object oldValue, E newValue) {
        if (val instanceof List) {
            List list = (List)val;
            if (list instanceof ArrayList) {
                if (oldValue == null) {
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        if (list.get(i) != null) continue;
                        list.set(i, newValue);
                        return true;
                    }
                } else {
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        if (!oldValue.equals(list.get(i))) continue;
                        list.set(i, newValue);
                        return true;
                    }
                }
            } else {
                ListIterator<E> iter = list.listIterator();
                if (oldValue == null) {
                    while (iter.hasNext()) {
                        if (iter.next() != null) continue;
                        iter.set(newValue);
                        return true;
                    }
                } else {
                    while (iter.hasNext()) {
                        if (!oldValue.equals(iter.next())) continue;
                        iter.set(newValue);
                        return true;
                    }
                }
            }
            return false;
        }
        if (val.remove(oldValue)) {
            val.add(newValue);
            return true;
        }
        return false;
    }

    public boolean replaceAll(K key, Collection<?> oldValues, E newValue) {
        Collection val = (Collection)this.valueMap.get(key);
        if (val == null) {
            return false;
        }
        if (val.removeAll(oldValues)) {
            val.add(newValue);
            return true;
        }
        return false;
    }

    public <X extends Exception> boolean replaceIf(Try.Predicate<? super K, X> predicate, Object oldValue, E newValue) throws X {
        boolean modified = false;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            modified |= this.replace((V)((Collection)entry.getValue()), oldValue, newValue);
        }
        return modified;
    }

    public <X extends Exception> boolean replaceIf(Try.BiPredicate<? super K, ? super V, X> predicate, Object oldValue, E newValue) throws X {
        boolean modified = false;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            modified |= this.replace((V)((Collection)entry.getValue()), oldValue, newValue);
        }
        return modified;
    }

    public <X extends Exception> boolean replaceAllIf(Try.Predicate<? super K, X> predicate, Collection<?> oldValues, E newValue) throws X {
        boolean modified = false;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey()) || !((Collection)entry.getValue()).removeAll(oldValues)) continue;
            ((Collection)entry.getValue()).add(newValue);
            modified = true;
        }
        return modified;
    }

    public <X extends Exception> boolean replaceAllIf(Try.BiPredicate<? super K, ? super V, X> predicate, Collection<?> oldValues, E newValue) throws X {
        boolean modified = false;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue()) || !((Collection)entry.getValue()).removeAll(oldValues)) continue;
            ((Collection)entry.getValue()).add(newValue);
            modified = true;
        }
        return modified;
    }

    public <X extends Exception> void replaceAll(Try.BiFunction<? super K, ? super V, ? extends V, X> function) throws X {
        ArrayList<K> keyToRemove = null;
        Collection newVal = null;
        for (Map.Entry<K, Collection> entry : this.valueMap.entrySet()) {
            newVal = (Collection)function.apply(entry.getKey(), entry.getValue());
            if (N.isNullOrEmpty(newVal)) {
                if (keyToRemove == null) {
                    keyToRemove = new ArrayList<K>();
                }
                keyToRemove.add(entry.getKey());
                continue;
            }
            try {
                entry.setValue(newVal);
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
        }
        if (N.notNullOrEmpty(keyToRemove)) {
            for (Map.Entry<K, V> entry : keyToRemove) {
                this.valueMap.remove(entry);
            }
        }
    }

    public boolean contains(Object key, Object e) {
        Collection val = (Collection)this.valueMap.get(key);
        return val == null ? false : val.contains(e);
    }

    public boolean containsKey(Object key) {
        return this.valueMap.containsKey(key);
    }

    public boolean containsValue(Object e) {
        Collection<V> values = this.values();
        for (Collection val : values) {
            if (!val.contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Object key, Collection<?> c) {
        Collection val = (Collection)this.valueMap.get(key);
        return val == null ? false : (N.isNullOrEmpty(c) ? true : val.containsAll(c));
    }

    public <X extends Exception> Multimap<K, E, V> filterByKey(Try.Predicate<? super K, X> filter) throws X {
        Multimap<K, E, ? extends V> result = new Multimap<K, E, V>(this.mapSupplier, this.valueSupplier);
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            result.valueMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <X extends Exception> Multimap<K, E, V> filterByValue(Try.Predicate<? super V, X> filter) throws X {
        Multimap<K, E, ? extends V> result = new Multimap<K, E, V>(this.mapSupplier, this.valueSupplier);
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!filter.test(entry.getValue())) continue;
            result.valueMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <X extends Exception> Multimap<K, E, V> filter(Try.BiPredicate<? super K, ? super V, X> filter) throws X {
        Multimap<K, E, ? extends V> result = new Multimap<K, E, V>(this.mapSupplier, this.valueSupplier);
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            if (!filter.test(entry.getKey(), entry.getValue())) continue;
            result.valueMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <X extends Exception> void forEach(Try.BiConsumer<? super K, ? super V, X> action) throws X {
        N.checkArgNotNull(action);
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public <X extends Exception> void flatForEach(Try.BiConsumer<? super K, ? super E, X> action) throws X {
        N.checkArgNotNull(action);
        Object key = null;
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            key = entry.getKey();
            for (Object e : (Collection)entry.getValue()) {
                action.accept(key, e);
            }
        }
    }

    public <X extends Exception> void forEachKey(Try.Consumer<? super K, X> action) throws X {
        N.checkArgNotNull(action);
        for (K k : this.valueMap.keySet()) {
            action.accept(k);
        }
    }

    public <X extends Exception> void forEachValue(Try.Consumer<? super V, X> action) throws X {
        N.checkArgNotNull(action);
        for (Collection v : this.valueMap.values()) {
            action.accept(v);
        }
    }

    public <X extends Exception> void flatForEachValue(Try.Consumer<? super E, X> action) throws X {
        N.checkArgNotNull(action);
        for (Collection v : this.valueMap.values()) {
            for (Object e : v) {
                action.accept(e);
            }
        }
    }

    public <X extends Exception> V computeIfAbsent(K key, Try.Function<? super K, ? extends V, X> mappingFunction) throws X {
        N.checkArgNotNull(mappingFunction);
        V oldValue = this.get(key);
        if (N.notNullOrEmpty(oldValue)) {
            return oldValue;
        }
        Collection newValue = (Collection)mappingFunction.apply(key);
        if (N.notNullOrEmpty(newValue)) {
            this.valueMap.put(key, newValue);
        }
        return (V)newValue;
    }

    public <X extends Exception> V computeIfPresent(K key, Try.BiFunction<? super K, ? super V, ? extends V, X> remappingFunction) throws X {
        N.checkArgNotNull(remappingFunction);
        V oldValue = this.get(key);
        if (N.isNullOrEmpty(oldValue)) {
            return oldValue;
        }
        Collection newValue = (Collection)remappingFunction.apply(key, oldValue);
        if (N.notNullOrEmpty(newValue)) {
            this.valueMap.put(key, newValue);
        } else {
            this.valueMap.remove(key);
        }
        return (V)newValue;
    }

    public <X extends Exception> V compute(K key, Try.BiFunction<? super K, ? super V, ? extends V, X> remappingFunction) throws X {
        N.checkArgNotNull(remappingFunction);
        V oldValue = this.get(key);
        Collection newValue = (Collection)remappingFunction.apply(key, oldValue);
        if (N.notNullOrEmpty(newValue)) {
            this.valueMap.put(key, newValue);
        } else if (oldValue != null) {
            this.valueMap.remove(key);
        }
        return (V)newValue;
    }

    public <X extends Exception> V merge(K key, V value, Try.BiFunction<? super V, ? super V, ? extends V, X> remappingFunction) throws X {
        V newValue;
        N.checkArgNotNull(remappingFunction);
        N.checkArgNotNull(value);
        V oldValue = this.get(key);
        Object object = newValue = oldValue == null ? value : (Collection)remappingFunction.apply(oldValue, value);
        if (N.notNullOrEmpty(newValue)) {
            this.valueMap.put(key, newValue);
        } else if (oldValue != null) {
            this.valueMap.remove(key);
        }
        return newValue;
    }

    public <X extends Exception> V merge(K key, E e, Try.BiFunction<? super V, ? super E, ? extends V, X> remappingFunction) throws X {
        N.checkArgNotNull(remappingFunction);
        N.checkArgNotNull(e);
        V oldValue = this.get(key);
        if (N.isNullOrEmpty(oldValue)) {
            this.put(key, e);
            return this.get(key);
        }
        Collection newValue = (Collection)remappingFunction.apply(oldValue, e);
        if (N.notNullOrEmpty(newValue)) {
            this.valueMap.put(key, newValue);
        } else if (oldValue != null) {
            this.valueMap.remove(key);
        }
        return (V)newValue;
    }

    public Multimap<K, E, V> copy() {
        Multimap<K, E, V> copy = new Multimap<K, E, V>(this.mapSupplier, this.valueSupplier);
        copy.putAll(this);
        return copy;
    }

    public Set<K> keySet() {
        return this.valueMap.keySet();
    }

    public Collection<V> values() {
        return this.valueMap.values();
    }

    public List<E> flatValues() {
        ArrayList result = new ArrayList(this.totalCountOfValues());
        for (Collection v : this.valueMap.values()) {
            result.addAll(v);
        }
        return result;
    }

    public <R extends Collection<E>> R flatValues(IntFunction<R> supplier) {
        Collection result = (Collection)supplier.apply(this.totalCountOfValues());
        for (Collection v : this.valueMap.values()) {
            result.addAll(v);
        }
        return (R)result;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.valueMap.entrySet();
    }

    public Map<K, V> toMap() {
        Map result = Maps.newOrderingMap(this.valueMap);
        result.putAll(this.valueMap);
        return result;
    }

    public <M extends Map<K, V>> M toMap(IntFunction<? extends M> supplier) {
        Map map = (Map)supplier.apply(this.size());
        map.putAll(this.valueMap);
        return (M)map;
    }

    public Multiset<K> toMultiset() {
        Multiset<K> multiset = new Multiset<K>(this.valueMap.getClass());
        for (Map.Entry<K, V> entry : this.valueMap.entrySet()) {
            multiset.set(entry.getKey(), ((Collection)entry.getValue()).size());
        }
        return multiset;
    }

    public Map<K, V> unwrap() {
        return this.valueMap;
    }

    public void clear() {
        this.valueMap.clear();
    }

    public int size() {
        return this.valueMap.size();
    }

    public int totalCountOfValues() {
        int count = 0;
        for (Collection v : this.valueMap.values()) {
            count += v.size();
        }
        return count;
    }

    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    public <R, X extends Exception> R apply(Try.Function<? super Multimap<K, E, V>, R, X> func) throws X {
        return func.apply(this);
    }

    public <X extends Exception> void accept(Try.Consumer<? super Multimap<K, E, V>, X> action) throws X {
        action.accept(this);
    }

    public int hashCode() {
        return this.valueMap.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Multimap && this.valueMap.equals(((Multimap)obj).valueMap);
    }

    public String toString() {
        return this.valueMap.toString();
    }
}

