/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.Matth;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.u;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Multiset<T>
implements Iterable<T> {
    private static final Comparator<Map.Entry<?, MutableInt>> cmpByCount = new Comparator<Map.Entry<?, MutableInt>>(){

        @Override
        public int compare(Map.Entry<?, MutableInt> a, Map.Entry<?, MutableInt> b) {
            return N.compare(a.getValue().value(), b.getValue().value());
        }
    };
    final Supplier<Map<T, MutableInt>> mapSupplier;
    final Map<T, MutableInt> valueMap;

    public Multiset() {
        this(HashMap.class);
    }

    public Multiset(int initialCapacity) {
        this.mapSupplier = Fn.Suppliers.ofMap();
        this.valueMap = new HashMap<T, MutableInt>(initialCapacity);
    }

    public Multiset(Collection<? extends T> c) {
        this();
        this.addAll(c);
    }

    public Multiset(Class<? extends Map> valueMapType) {
        this(Maps.mapType2Supplier(valueMapType));
    }

    public Multiset(Supplier<? extends Map<T, ?>> mapSupplier) {
        this.mapSupplier = mapSupplier;
        this.valueMap = this.mapSupplier.get();
    }

    @Internal
    Multiset(Map<T, MutableInt> valueMap) {
        this.mapSupplier = Maps.mapType2Supplier(valueMap.getClass());
        this.valueMap = valueMap;
    }

    @SafeVarargs
    public static <T> Multiset<T> of(T ... a) {
        if (N.isNullOrEmpty(a)) {
            return new Multiset<T>();
        }
        Multiset multiset = new Multiset(new HashMap(N.initHashCapacity(a.length)));
        for (T e : a) {
            multiset.add(e);
        }
        return multiset;
    }

    public static <T> Multiset<T> from(Collection<? extends T> coll) {
        return new Multiset<T>(coll);
    }

    public static <T> Multiset<T> from(Map<? extends T, Integer> m) {
        if (N.isNullOrEmpty(m)) {
            return new Multiset<T>();
        }
        Multiset<? extends T> multiset = new Multiset<T>(Maps.newTargetMap(m));
        multiset.setAll(m);
        return multiset;
    }

    public int get(Object e) {
        MutableInt count = this.valueMap.get(e);
        return count == null ? 0 : count.value();
    }

    public int getOrDefault(Object e, int defaultValue) {
        MutableInt count = this.valueMap.get(e);
        return count == null ? defaultValue : count.value();
    }

    public int getAndSet(T e, int occurrences) {
        int result;
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        int n = result = count == null ? 0 : count.value();
        if (occurrences == 0) {
            if (count != null) {
                this.valueMap.remove(e);
            }
        } else if (count == null) {
            this.valueMap.put(e, MutableInt.of(occurrences));
        } else {
            count.setValue(occurrences);
        }
        return result;
    }

    public int setAndGet(T e, int occurrences) {
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        if (occurrences == 0) {
            if (count != null) {
                this.valueMap.remove(e);
            }
        } else if (count == null) {
            this.valueMap.put(e, MutableInt.of(occurrences));
        } else {
            count.setValue(occurrences);
        }
        return occurrences;
    }

    public Multiset<T> set(T e, int occurrences) {
        Multiset.checkOccurrences(occurrences);
        if (occurrences == 0) {
            this.valueMap.remove(e);
        } else {
            MutableInt count = this.valueMap.get(e);
            if (count == null) {
                this.valueMap.put(e, MutableInt.of(occurrences));
            } else {
                count.setValue(occurrences);
            }
        }
        return this;
    }

    public Multiset<T> setAll(Collection<? extends T> c, int occurrences) {
        Multiset.checkOccurrences(occurrences);
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                this.set(e, occurrences);
            }
        }
        return this;
    }

    public Multiset<T> setAll(Map<? extends T, Integer> m) throws IllegalArgumentException {
        if (N.notNullOrEmpty(m)) {
            for (Map.Entry<T, Integer> entry : m.entrySet()) {
                Multiset.checkOccurrences(entry.getValue());
            }
            for (Map.Entry<T, Integer> entry : m.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public Multiset<T> setAll(Multiset<? extends T> multiset) throws IllegalArgumentException {
        if (N.notNullOrEmpty(multiset)) {
            for (Map.Entry<T, MutableInt> entry : multiset.valueMap.entrySet()) {
                this.set(entry.getKey(), entry.getValue().value());
            }
        }
        return this;
    }

    public int occurrencesOf(Object e) {
        return this.get(e);
    }

    public u.Optional<Pair<T, Integer>> minOccurrences() {
        if (this.size() == 0) {
            return u.Optional.empty();
        }
        Iterator<Map.Entry<T, MutableInt>> it = this.valueMap.entrySet().iterator();
        Map.Entry<T, MutableInt> entry = it.next();
        T minCountElement = entry.getKey();
        int minCount = entry.getValue().value();
        while (it.hasNext()) {
            entry = it.next();
            if (entry.getValue().value() >= minCount) continue;
            minCountElement = entry.getKey();
            minCount = entry.getValue().value();
        }
        return u.Optional.of(Pair.of(minCountElement, minCount));
    }

    public u.Optional<Pair<T, Integer>> maxOccurrences() {
        if (this.size() == 0) {
            return u.Optional.empty();
        }
        Iterator<Map.Entry<T, MutableInt>> it = this.valueMap.entrySet().iterator();
        Map.Entry<T, MutableInt> entry = it.next();
        T maxCountElement = entry.getKey();
        int maxCount = entry.getValue().value();
        while (it.hasNext()) {
            entry = it.next();
            if (entry.getValue().value() <= maxCount) continue;
            maxCountElement = entry.getKey();
            maxCount = entry.getValue().value();
        }
        return u.Optional.of(Pair.of(maxCountElement, maxCount));
    }

    public u.Optional<Pair<List<T>, Integer>> allMinOccurrences() {
        if (this.size() == 0) {
            return u.Optional.empty();
        }
        int min = Integer.MAX_VALUE;
        for (MutableInt e : this.valueMap.values()) {
            if (e.value() >= min) continue;
            min = e.value();
        }
        ArrayList<T> res = new ArrayList<T>();
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            if (entry.getValue().value() != min) continue;
            res.add(entry.getKey());
        }
        return u.Optional.of(Pair.of(res, min));
    }

    public u.Optional<Pair<List<T>, Integer>> allMaxOccurrences() {
        if (this.size() == 0) {
            return u.Optional.empty();
        }
        int max = Integer.MIN_VALUE;
        for (MutableInt e : this.valueMap.values()) {
            if (e.value() <= max) continue;
            max = e.value();
        }
        ArrayList<T> res = new ArrayList<T>();
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            if (entry.getValue().value() != max) continue;
            res.add(entry.getKey());
        }
        return u.Optional.of(Pair.of(res, max));
    }

    public long sumOfOccurrences() {
        long sum = 0L;
        for (MutableInt count : this.valueMap.values()) {
            sum = Matth.addExact(sum, (long)count.value());
        }
        return sum;
    }

    public u.OptionalDouble averageOfOccurrences() {
        if (this.size() == 0) {
            return u.OptionalDouble.empty();
        }
        double sum = this.sumOfOccurrences();
        return u.OptionalDouble.of(sum / (double)this.size());
    }

    public boolean add(T e) throws IllegalArgumentException {
        return this.add(e, 1);
    }

    public boolean add(T e, int occurrences) throws IllegalArgumentException {
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        if (count != null && occurrences > Integer.MAX_VALUE - count.value()) {
            throw new IllegalArgumentException("The total count is out of the bound of int");
        }
        if (count == null) {
            if (occurrences > 0) {
                count = MutableInt.of(occurrences);
                this.valueMap.put(e, count);
            }
        } else {
            count.add(occurrences);
        }
        return occurrences > 0;
    }

    public boolean addIfAbsent(T e) throws IllegalArgumentException {
        return this.addIfAbsent(e, 1);
    }

    public boolean addIfAbsent(T e, int occurrences) throws IllegalArgumentException {
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        if (count == null && occurrences > 0) {
            count = MutableInt.of(occurrences);
            this.valueMap.put(e, count);
            return true;
        }
        return false;
    }

    public int addAndGet(T e) {
        return this.addAndGet(e, 1);
    }

    public int addAndGet(T e, int occurrences) {
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        if (count != null && occurrences > Integer.MAX_VALUE - count.value()) {
            throw new IllegalArgumentException("The total count is out of the bound of int");
        }
        if (count == null) {
            if (occurrences > 0) {
                count = MutableInt.of(occurrences);
                this.valueMap.put(e, count);
            }
        } else {
            count.add(occurrences);
        }
        return count == null ? 0 : count.value();
    }

    public int getAndAdd(T e) {
        return this.getAndAdd(e, 1);
    }

    public int getAndAdd(T e, int occurrences) {
        int result;
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        if (count != null && occurrences > Integer.MAX_VALUE - count.value()) {
            throw new IllegalArgumentException("The total count is out of the bound of int");
        }
        int n = result = count == null ? 0 : count.value();
        if (count == null) {
            if (occurrences > 0) {
                count = MutableInt.of(occurrences);
                this.valueMap.put(e, count);
            }
        } else {
            count.add(occurrences);
        }
        return result;
    }

    public boolean addAll(Collection<? extends T> c) throws IllegalArgumentException {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return this.addAll(c, 1);
    }

    public boolean addAll(Collection<? extends T> c, int occurrences) throws IllegalArgumentException {
        Multiset.checkOccurrences(occurrences);
        if (N.isNullOrEmpty(c) || occurrences == 0) {
            return false;
        }
        for (T e : c) {
            this.add(e, occurrences);
        }
        return occurrences > 0;
    }

    public boolean addAll(Map<? extends T, Integer> m) throws IllegalArgumentException {
        if (N.isNullOrEmpty(m)) {
            return false;
        }
        for (Map.Entry<T, Integer> entry : m.entrySet()) {
            Multiset.checkOccurrences(entry.getValue());
        }
        boolean result = false;
        for (Map.Entry<T, Integer> entry : m.entrySet()) {
            if (!result) {
                result = this.add(entry.getKey(), entry.getValue());
                continue;
            }
            this.add(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public boolean addAll(Multiset<? extends T> multiset) throws IllegalArgumentException {
        if (N.isNullOrEmpty(multiset)) {
            return false;
        }
        for (Map.Entry<T, MutableInt> entry : multiset.valueMap.entrySet()) {
            this.add(entry.getKey(), entry.getValue().value());
        }
        return true;
    }

    public boolean contains(Object o) {
        return this.valueMap.containsKey(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.valueMap.keySet().containsAll(c);
    }

    public boolean remove(Object e) {
        return this.remove(e, 1);
    }

    public boolean remove(Object e, int occurrences) {
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        if (count == null) {
            return false;
        }
        count.subtract(occurrences);
        if (count.value() <= 0) {
            this.valueMap.remove(e);
        }
        return occurrences > 0;
    }

    public int removeAndGet(Object e) {
        return this.removeAndGet(e, 1);
    }

    public int removeAndGet(Object e, int occurrences) {
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        if (count == null) {
            return 0;
        }
        count.subtract(occurrences);
        if (count.value() <= 0) {
            this.valueMap.remove(e);
        }
        return count.value() > 0 ? count.value() : 0;
    }

    public int getAndRemove(Object e) {
        return this.getAndRemove(e, 1);
    }

    public int getAndRemove(Object e, int occurrences) {
        int result;
        Multiset.checkOccurrences(occurrences);
        MutableInt count = this.valueMap.get(e);
        int n = result = count == null ? 0 : count.value();
        if (count != null) {
            count.subtract(occurrences);
            if (count.value() <= 0) {
                this.valueMap.remove(e);
            }
        }
        return result;
    }

    public int removeAllOccurrences(Object e) {
        MutableInt count = this.valueMap.remove(e);
        return count == null ? 0 : count.value();
    }

    public <E extends Exception> boolean removeAllOccurrencesIf(Try.Predicate<? super T, E> predicate) throws E {
        Set removingKeys = null;
        for (T key : this.valueMap.keySet()) {
            if (!predicate.test(key)) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(key);
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        this.removeAll(removingKeys);
        return true;
    }

    public <E extends Exception> boolean removeAllOccurrencesIf(Try.BiPredicate<? super T, ? super Integer, E> predicate) throws E {
        Set removingKeys = null;
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue().value())) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(entry.getKey());
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        this.removeAll(removingKeys);
        return true;
    }

    public <E extends Exception> boolean removeIf(int occurrences, Try.Predicate<? super T, E> predicate) throws E {
        Multiset.checkOccurrences(occurrences);
        Set removingKeys = null;
        for (T key : this.valueMap.keySet()) {
            if (!predicate.test(key)) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(key);
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        this.removeAll(removingKeys, occurrences);
        return true;
    }

    public <E extends Exception> boolean removeIf(int occurrences, Try.BiPredicate<? super T, ? super Integer, E> predicate) throws E {
        Multiset.checkOccurrences(occurrences);
        Set removingKeys = null;
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue().value())) continue;
            if (removingKeys == null) {
                removingKeys = N.newHashSet();
            }
            removingKeys.add(entry.getKey());
        }
        if (N.isNullOrEmpty(removingKeys)) {
            return false;
        }
        this.removeAll(removingKeys, occurrences);
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        boolean result = false;
        for (Object e : c) {
            if (!result) {
                result = this.valueMap.remove(e) != null;
                continue;
            }
            this.valueMap.remove(e);
        }
        return result;
    }

    public boolean removeAll(Collection<?> c, int occurrences) {
        Multiset.checkOccurrences(occurrences);
        if (N.isNullOrEmpty(c) || occurrences == 0) {
            return false;
        }
        boolean result = false;
        for (Object e : c) {
            if (!result) {
                result = this.remove(e, occurrences);
                continue;
            }
            this.remove(e, occurrences);
        }
        return result;
    }

    public boolean removeAll(Map<?, Integer> m) {
        if (N.isNullOrEmpty(m)) {
            return false;
        }
        for (Map.Entry<?, Integer> entry : m.entrySet()) {
            Multiset.checkOccurrences(entry.getValue());
        }
        boolean result = false;
        for (Map.Entry<?, Integer> entry : m.entrySet()) {
            if (!result) {
                result = this.remove(entry.getKey(), entry.getValue());
                continue;
            }
            this.remove(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public boolean removeAll(Multiset<?> multiset) throws IllegalArgumentException {
        if (N.isNullOrEmpty(multiset)) {
            return false;
        }
        for (Map.Entry<T, MutableInt> entry : multiset.valueMap.entrySet()) {
            this.remove(entry.getKey(), entry.getValue().value());
        }
        return true;
    }

    public <E extends Exception> boolean replaceIf(Try.Predicate<? super T, E> predicate, int newOccurrences) throws E {
        Multiset.checkOccurrences(newOccurrences);
        boolean modified = false;
        if (newOccurrences == 0) {
            ArrayList<T> keysToRemove = new ArrayList<T>();
            for (Object key : this.valueMap.keySet()) {
                if (!predicate.test(key)) continue;
                keysToRemove.add(key);
            }
            if (keysToRemove.size() > 0) {
                for (Object key : keysToRemove) {
                    this.valueMap.remove(key);
                }
                modified = true;
            }
        } else {
            for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
                if (!predicate.test(entry.getKey())) continue;
                entry.getValue().setValue(newOccurrences);
                modified = true;
            }
        }
        return modified;
    }

    public <E extends Exception> boolean replaceIf(Try.BiPredicate<? super T, ? super Integer, E> predicate, int newOccurrences) throws E {
        Multiset.checkOccurrences(newOccurrences);
        boolean modified = false;
        if (newOccurrences == 0) {
            ArrayList<T> keysToRemove = new ArrayList<T>();
            for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
                if (!predicate.test(entry.getKey(), entry.getValue().value())) continue;
                keysToRemove.add(entry.getKey());
            }
            if (keysToRemove.size() > 0) {
                for (Map.Entry<Object, MutableInt> key : keysToRemove) {
                    this.valueMap.remove(key);
                }
                modified = true;
            }
        } else {
            for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
                if (!predicate.test(entry.getKey(), entry.getValue().value())) continue;
                entry.getValue().setValue(newOccurrences);
                modified = true;
            }
        }
        return modified;
    }

    public <E extends Exception> void replaceAll(Try.BiFunction<? super T, ? super Integer, Integer, E> function) throws E {
        ArrayList<T> keyToRemove = null;
        Integer newVal = null;
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            newVal = function.apply(entry.getKey(), entry.getValue().value());
            if (newVal == null || newVal <= 0) {
                if (keyToRemove == null) {
                    keyToRemove = new ArrayList<T>();
                }
                keyToRemove.add(entry.getKey());
                continue;
            }
            entry.getValue().setValue(newVal);
        }
        if (N.notNullOrEmpty(keyToRemove)) {
            for (Map.Entry<Object, MutableInt> key : keyToRemove) {
                this.valueMap.remove(key);
            }
        }
    }

    public boolean retainAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            boolean result = this.size() > 0;
            this.clear();
            return result;
        }
        Set others = null;
        for (T e : this.valueMap.keySet()) {
            if (c.contains(e)) continue;
            if (others == null) {
                others = N.newHashSet(this.valueMap.size());
            }
            others.add(e);
        }
        return N.isNullOrEmpty(others) ? false : this.removeAll(others, Integer.MAX_VALUE);
    }

    public Multiset<T> copy() {
        Multiset<T> copy = new Multiset<T>(this.mapSupplier);
        copy.addAll(this);
        return copy;
    }

    public Set<T> elements() {
        return ImmutableSet.of(this.valueMap.keySet());
    }

    public int size() {
        return this.valueMap.size();
    }

    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    public void clear() {
        this.valueMap.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.valueMap.keySet().iterator();
    }

    public Object[] toArray() {
        return this.valueMap.keySet().toArray();
    }

    public <A> A[] toArray(A[] a) {
        return this.valueMap.keySet().toArray(a);
    }

    public Map<T, Integer> toMap() {
        Map result = Maps.newOrderingMap(this.valueMap);
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().value());
        }
        return result;
    }

    public <M extends Map<T, Integer>> M toMap(IntFunction<? extends M> supplier) {
        Map result = (Map)supplier.apply(this.size());
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().value());
        }
        return (M)result;
    }

    public Map<T, Integer> toMapSortedByOccurrences() {
        return this.toMapSortedBy(cmpByCount);
    }

    public Map<T, Integer> toMapSortedByOccurrences(final Comparator<? super Integer> cmp) {
        return this.toMapSortedBy(new Comparator<Map.Entry<T, MutableInt>>(){

            @Override
            public int compare(Map.Entry<T, MutableInt> o1, Map.Entry<T, MutableInt> o2) {
                return cmp.compare(o1.getValue().value(), o2.getValue().value());
            }
        });
    }

    public Map<T, Integer> toMapSortedByKey(final Comparator<? super T> cmp) {
        return this.toMapSortedBy(new Comparator<Map.Entry<T, MutableInt>>(){

            @Override
            public int compare(Map.Entry<T, MutableInt> o1, Map.Entry<T, MutableInt> o2) {
                return cmp.compare(o1.getKey(), o2.getKey());
            }
        });
    }

    Map<T, Integer> toMapSortedBy(Comparator<Map.Entry<T, MutableInt>> cmp) {
        if (N.isNullOrEmpty(this.valueMap)) {
            return new LinkedHashMap();
        }
        Map.Entry[] entries = this.valueMap.entrySet().toArray(new Map.Entry[this.size()]);
        Arrays.sort(entries, cmp);
        LinkedHashMap sortedValues = new LinkedHashMap(N.initHashCapacity(this.size()));
        for (Map.Entry entry : entries) {
            sortedValues.put(entry.getKey(), ((MutableInt)entry.getValue()).value());
        }
        return sortedValues;
    }

    public ImmutableMap<T, Integer> toImmutableMap() {
        return ImmutableMap.of(this.toMap());
    }

    public ImmutableMap<T, Integer> toImmutableMap(IntFunction<? extends Map<T, Integer>> mapSupplier) {
        return ImmutableMap.of(this.toMap(mapSupplier));
    }

    public List<T> flatten() {
        long totalOccurrences = this.sumOfOccurrences();
        if (totalOccurrences > Integer.MAX_VALUE) {
            throw new RuntimeException("The total occurrences(" + totalOccurrences + ") is bigger than the max value of int.");
        }
        Object[] a = new Object[(int)totalOccurrences];
        int fromIndex = 0;
        int toIndex = 0;
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            toIndex = fromIndex + entry.getValue().value();
            Arrays.fill(a, fromIndex, toIndex, entry.getKey());
            fromIndex = toIndex;
        }
        return N.asList(a);
    }

    public <E extends Exception> Multiset<T> filter(Try.Predicate<? super T, E> filter) throws E {
        Multiset<T> result = new Multiset<T>(this.mapSupplier.get());
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            result.set(entry.getKey(), entry.getValue().intValue());
        }
        return result;
    }

    public <E extends Exception> Multiset<T> filter(Try.BiPredicate<? super T, Integer, E> filter) throws E {
        Multiset<T> result = new Multiset<T>(this.mapSupplier.get());
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            if (!filter.test(entry.getKey(), entry.getValue().intValue())) continue;
            result.set(entry.getKey(), entry.getValue().intValue());
        }
        return result;
    }

    public <E extends Exception> void forEach(Try.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        for (T e : this.valueMap.keySet()) {
            action.accept(e);
        }
    }

    public <E extends Exception> void forEach(Try.ObjIntConsumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        for (Map.Entry<T, MutableInt> entry : this.valueMap.entrySet()) {
            action.accept(entry.getKey(), entry.getValue().value());
        }
    }

    public <E extends Exception> int computeIfAbsent(T e, Try.Function<? super T, Integer, E> mappingFunction) throws E {
        N.checkArgNotNull(mappingFunction);
        int oldValue = this.get(e);
        if (oldValue > 0) {
            return oldValue;
        }
        int newValue = mappingFunction.apply(e);
        if (newValue > 0) {
            this.set(e, newValue);
        }
        return newValue;
    }

    public <E extends Exception> int computeIfPresent(T e, Try.BiFunction<? super T, Integer, Integer, E> remappingFunction) throws E {
        N.checkArgNotNull(remappingFunction);
        int oldValue = this.get(e);
        if (oldValue == 0) {
            return oldValue;
        }
        int newValue = remappingFunction.apply(e, oldValue);
        if (newValue > 0) {
            this.set(e, newValue);
        } else {
            this.remove(e);
        }
        return newValue;
    }

    public <E extends Exception> int compute(T key, Try.BiFunction<? super T, Integer, Integer, E> remappingFunction) throws E {
        N.checkArgNotNull(remappingFunction);
        int oldValue = this.get(key);
        int newValue = remappingFunction.apply(key, oldValue);
        if (newValue > 0) {
            this.set(key, newValue);
        } else if (oldValue > 0) {
            this.remove(key);
        }
        return newValue;
    }

    public <E extends Exception> int merge(T key, int value, Try.BiFunction<Integer, Integer, Integer, E> remappingFunction) throws E {
        int newValue;
        N.checkArgNotNull(remappingFunction);
        N.checkArgNotNull(value);
        int oldValue = this.get(key);
        int n = newValue = oldValue == 0 ? value : remappingFunction.apply(oldValue, value);
        if (newValue > 0) {
            this.set(key, newValue);
        } else if (oldValue > 0) {
            this.remove(key);
        }
        return newValue;
    }

    public <R, E extends Exception> R apply(Try.Function<? super Multiset<T>, R, E> func) throws E {
        return func.apply(this);
    }

    public <R, E extends Exception> u.Optional<R> applyIfNotEmpty(Try.Function<? super Multiset<T>, R, E> func) throws E {
        return this.isEmpty() ? u.Optional.empty() : u.Optional.ofNullable(func.apply(this));
    }

    public <E extends Exception> void accept(Try.Consumer<? super Multiset<T>, E> action) throws E {
        action.accept(this);
    }

    public <E extends Exception> void acceptIfNotEmpty(Try.Consumer<? super Multiset<T>, E> action) throws E {
        if (this.size() > 0) {
            action.accept(this);
        }
    }

    public int hashCode() {
        return this.valueMap.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Multiset && this.valueMap.equals(((Multiset)obj).valueMap);
    }

    public String toString() {
        return this.valueMap.toString();
    }

    private static void checkOccurrences(int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("The specified 'occurrences' can not be negative");
        }
    }
}

