/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.Try;

public final class MutableChar
implements Comparable<MutableChar>,
Mutable {
    private char value;

    MutableChar() {
    }

    MutableChar(char value) {
        this.value = value;
    }

    public static MutableChar of(char value) {
        return new MutableChar(value);
    }

    public char value() {
        return this.value;
    }

    @Deprecated
    public char getValue() {
        return this.value;
    }

    public void setValue(char value) {
        this.value = value;
    }

    public char getAndSet(char value) {
        char result = this.value;
        this.value = value;
        return result;
    }

    public char setAndGet(char value) {
        this.value = value;
        return this.value;
    }

    public <E extends Exception> boolean setIf(char newValue, Try.CharPredicate<E> predicate) throws E {
        if (predicate.test(this.value)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setIf(char newValue, Try.CharBiPredicate<E> predicate) throws E {
        if (predicate.test(this.value, newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public void increment() {
        this.value = (char)(this.value + '\u0001');
    }

    public void decrement() {
        this.value = (char)(this.value - '\u0001');
    }

    public void add(char operand) {
        this.value = (char)(this.value + operand);
    }

    public void subtract(char operand) {
        this.value = (char)(this.value - operand);
    }

    public final char getAndIncrement() {
        char c = this.value;
        this.value = (char)(c + '\u0001');
        return c;
    }

    public final char getAndDecrement() {
        char c = this.value;
        this.value = (char)(c - '\u0001');
        return c;
    }

    public final char incrementAndGet() {
        this.value = (char)(this.value + '\u0001');
        return this.value;
    }

    public final char decrementAndGet() {
        this.value = (char)(this.value - '\u0001');
        return this.value;
    }

    public final char getAndAdd(char delta) {
        char prev = this.value;
        this.value = (char)(this.value + delta);
        return prev;
    }

    public final char addAndGet(char delta) {
        this.value = (char)(this.value + delta);
        return this.value;
    }

    @Override
    public int compareTo(MutableChar other) {
        return this.value > other.value ? 1 : (this.value == other.value ? 0 : -1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableChar) {
            return this.value == ((MutableChar)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

