/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.Try;

public final class MutableDouble
extends Number
implements Comparable<MutableDouble>,
Mutable {
    private static final long serialVersionUID = 1587163916L;
    private double value;

    MutableDouble() {
    }

    MutableDouble(double value) {
        this.value = value;
    }

    public static MutableDouble of(double value) {
        return new MutableDouble(value);
    }

    public double value() {
        return this.value;
    }

    @Deprecated
    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getAndSet(double value) {
        double result = this.value;
        this.value = value;
        return result;
    }

    public double setAndGet(double value) {
        this.value = value;
        return this.value;
    }

    public <E extends Exception> boolean setIf(double newValue, Try.DoublePredicate<E> predicate) throws E {
        if (predicate.test(this.value)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setIf(double newValue, Try.DoubleBiPredicate<E> predicate) throws E {
        if (predicate.test(this.value, newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public void increment() {
        this.value += 1.0;
    }

    public void decrement() {
        this.value -= 1.0;
    }

    public void add(double operand) {
        this.value += operand;
    }

    public void subtract(double operand) {
        this.value -= operand;
    }

    public final double getAndIncrement() {
        double d = this.value;
        this.value = d + 1.0;
        return d;
    }

    public final double getAndDecrement() {
        double d = this.value;
        this.value = d - 1.0;
        return d;
    }

    public final double incrementAndGet() {
        return this.value += 1.0;
    }

    public final double decrementAndGet() {
        return this.value -= 1.0;
    }

    public final double getAndAdd(double delta) {
        double prev = this.value;
        this.value += delta;
        return prev;
    }

    public final double addAndGet(double delta) {
        return this.value += delta;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(MutableDouble other) {
        return Double.compare(this.value, other.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof MutableDouble && Double.compare(((MutableDouble)obj).value, this.value) == 0;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

