/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.Try;

public final class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable {
    private static final long serialVersionUID = 62986528375L;
    private long value;

    MutableLong() {
    }

    MutableLong(long value) {
        this.value = value;
    }

    public static MutableLong of(long value) {
        return new MutableLong(value);
    }

    public long value() {
        return this.value;
    }

    @Deprecated
    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getAndSet(long value) {
        long result = this.value;
        this.value = value;
        return result;
    }

    public long setAndGet(long value) {
        this.value = value;
        return this.value;
    }

    public <E extends Exception> boolean setIf(long newValue, Try.LongPredicate<E> predicate) throws E {
        if (predicate.test(this.value)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setIf(long newValue, Try.LongBiPredicate<E> predicate) throws E {
        if (predicate.test(this.value, newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public void increment() {
        ++this.value;
    }

    public void decrement() {
        --this.value;
    }

    public void add(long operand) {
        this.value += operand;
    }

    public void subtract(long operand) {
        this.value -= operand;
    }

    public final long getAndIncrement() {
        return this.value++;
    }

    public final long getAndDecrement() {
        return this.value--;
    }

    public final long incrementAndGet() {
        return ++this.value;
    }

    public final long decrementAndGet() {
        return --this.value;
    }

    public final long getAndAdd(long delta) {
        long prev = this.value;
        this.value += delta;
        return prev;
    }

    public final long addAndGet(long delta) {
        return this.value += delta;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(MutableLong other) {
        return this.value > other.value ? 1 : (this.value == other.value ? 0 : -1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableLong) {
            return this.value == ((MutableLong)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

