/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.UncheckedException;
import com.landawn.abacus.parser.DeserializationConfig;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.parser.XMLDeserializationConfig;
import com.landawn.abacus.parser.XMLSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.CommonUtil;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.ExceptionUtil;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.Indexed;
import com.landawn.abacus.util.Iterables;
import com.landawn.abacus.util.Iterators;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.KahanSummation;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.Nth;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Percentage;
import com.landawn.abacus.util.Primitives;
import com.landawn.abacus.util.Triple;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.Utils;
import com.landawn.abacus.util.Wrapper;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.u;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class N
extends CommonUtil {
    private N() {
    }

    public static int occurrencesOf(boolean[] a, boolean objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != objectToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(char[] a, char objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != objectToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(byte[] a, byte objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != objectToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(short[] a, short objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != objectToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(int[] a, int objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != objectToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(long[] a, long objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != objectToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(float[] a, float objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Float.compare(a[i], objectToFind) != 0) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(double[] a, double objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Double.compare(a[i], objectToFind) != 0) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(Object[] a, Object objectToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        if (objectToFind == null) {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (a[i] != null) continue;
                ++occurrences;
            }
        } else {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (!objectToFind.equals(a[i])) continue;
                ++occurrences;
            }
        }
        return occurrences;
    }

    public static int occurrencesOf(Collection<?> c, Object objectToFind) {
        if (N.isNullOrEmpty(c)) {
            return 0;
        }
        return Collections.frequency(c, objectToFind);
    }

    public static boolean contains(boolean[] a, boolean objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(char[] a, char objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(byte[] a, byte objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(short[] a, short objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(int[] a, int objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(long[] a, long objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(float[] a, float objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(double[] a, double objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(Object[] a, Object objectToFind) {
        return N.indexOf(a, objectToFind) != -1;
    }

    public static boolean contains(Collection<?> c, Object e) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return c.contains(e);
    }

    public static List<boolean[]> split(boolean[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<boolean[]>();
        }
        int len = a.length;
        ArrayList<boolean[]> res = new ArrayList<boolean[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<boolean[]> split(boolean[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<boolean[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<boolean[]> res = new ArrayList<boolean[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<char[]> split(char[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<char[]>();
        }
        int len = a.length;
        ArrayList<char[]> res = new ArrayList<char[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<char[]> split(char[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<char[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<char[]> res = new ArrayList<char[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<byte[]> split(byte[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<byte[]>();
        }
        int len = a.length;
        ArrayList<byte[]> res = new ArrayList<byte[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<byte[]> split(byte[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<byte[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<byte[]> res = new ArrayList<byte[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<short[]> split(short[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<short[]>();
        }
        int len = a.length;
        ArrayList<short[]> res = new ArrayList<short[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<short[]> split(short[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<short[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<short[]> res = new ArrayList<short[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<int[]> split(int[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<int[]>();
        }
        int len = a.length;
        ArrayList<int[]> res = new ArrayList<int[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<int[]> split(int[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<int[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<int[]> res = new ArrayList<int[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<long[]> split(long[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<long[]>();
        }
        int len = a.length;
        ArrayList<long[]> res = new ArrayList<long[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<long[]> split(long[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<long[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<long[]> res = new ArrayList<long[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<float[]> split(float[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<float[]>();
        }
        int len = a.length;
        ArrayList<float[]> res = new ArrayList<float[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<float[]> split(float[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<float[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<float[]> res = new ArrayList<float[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<double[]> split(double[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<double[]>();
        }
        int len = a.length;
        ArrayList<double[]> res = new ArrayList<double[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static List<double[]> split(double[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<double[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<double[]> res = new ArrayList<double[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static <T> List<T[]> split(T[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<T[]>();
        }
        int len = a.length;
        ArrayList<T[]> res = new ArrayList<T[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int from = 0; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static <T> List<T[]> split(T[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<T[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<T[]> res = new ArrayList<T[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(N.copyOfRange(a, from, from <= toIndex - chunkSize ? from + chunkSize : toIndex));
        }
        return res;
    }

    public static <T> List<List<T>> split(Collection<? extends T> c, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(c)) {
            return new ArrayList<List<T>>();
        }
        return N.split(c, 0, c.size(), chunkSize);
    }

    public static <T> List<List<T>> split(Collection<? extends T> c, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(c)) {
            return new ArrayList<List<T>>();
        }
        int len = toIndex - fromIndex;
        ArrayList<List<T>> res = new ArrayList<List<T>>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        if (c instanceof List) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; i += chunkSize) {
                res.add(new ArrayList(list.subList(i, i <= toIndex - chunkSize ? i + chunkSize : toIndex)));
            }
        } else {
            Iterator<T> iter = c.iterator();
            for (int i = 0; i < toIndex; i += chunkSize) {
                int to;
                if (i < fromIndex) {
                    iter.next();
                    ++i;
                    continue;
                }
                ArrayList<T> subList = new ArrayList<T>(N.min(chunkSize, toIndex - i));
                int n = to = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
                for (int j = i; j < to; ++j) {
                    subList.add(iter.next());
                }
                res.add(subList);
            }
        }
        return res;
    }

    public static List<String> split(CharSequence str, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(str)) {
            return new ArrayList<String>();
        }
        return N.split(str, 0, str.length(), chunkSize);
    }

    public static List<String> split(CharSequence str, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(str));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(str)) {
            return new ArrayList<String>();
        }
        int len = toIndex - fromIndex;
        ArrayList<String> res = new ArrayList<String>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        for (int from = fromIndex; from < toIndex; from += chunkSize) {
            res.add(str.subSequence(from, from <= toIndex - chunkSize ? from + chunkSize : toIndex).toString());
        }
        return res;
    }

    public static <T> List<T> intersection(T[] a, Object[] b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        Multiset<Object> bOccurrences = Multiset.of(b);
        ArrayList<T> result = new ArrayList<T>(N.min(9, a.length, b.length));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) <= 0) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> List<T> intersection(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        Multiset<?> bOccurrences = Multiset.from(b);
        ArrayList<T> result = new ArrayList<T>(N.min(9, a.size(), b.size()));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) <= 0) continue;
            result.add(e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> intersection(Collection<? extends Collection<? extends T>> c) {
        void var2_4;
        List<T> list;
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        if (c.size() == 1) {
            return N.newArrayList(c.iterator().next());
        }
        for (Collection<T> collection : c) {
            if (!N.isNullOrEmpty(collection)) continue;
            return new ArrayList();
        }
        Iterator<Collection<T>> iter = c.iterator();
        List<T> list2 = N.intersection(iter.next(), iter.next());
        while (iter.hasNext() && (list = N.intersection(var2_4, iter.next())).size() != 0) {
        }
        return var2_4;
    }

    public static <T> List<T> difference(T[] a, Object[] b) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        if (N.isNullOrEmpty(b)) {
            return N.asList(a);
        }
        Multiset<Object> bOccurrences = Multiset.of(b);
        ArrayList<T> result = new ArrayList<T>(N.min(a.length, N.max(9, a.length - b.length)));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> List<T> difference(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        if (N.isNullOrEmpty(b)) {
            return new ArrayList<T>(a);
        }
        Multiset<?> bOccurrences = Multiset.from(b);
        ArrayList<T> result = new ArrayList<T>(N.min(a.size(), N.max(9, a.size() - b.size())));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> List<T> symmetricDifference(T[] a, T[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.asList(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.asList(a);
        }
        Multiset<T> bOccurrences = Multiset.of(b);
        ArrayList<T> result = new ArrayList<T>(N.max(9, Math.abs(a.length - b.length)));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        for (T e : b) {
            if (bOccurrences.getAndRemove(e) > 0) {
                result.add(e);
            }
            if (bOccurrences.isEmpty()) break;
        }
        return result;
    }

    public static <T> List<T> symmetricDifference(Collection<? extends T> a, Collection<? extends T> b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList() : new ArrayList<T>(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? new ArrayList() : new ArrayList<T>(a);
        }
        Multiset<T> bOccurrences = Multiset.from(b);
        ArrayList<T> result = new ArrayList<T>(N.max(9, Math.abs(a.size() - b.size())));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        for (T e : b) {
            if (bOccurrences.getAndRemove(e) > 0) {
                result.add(e);
            }
            if (!bOccurrences.isEmpty()) continue;
            break;
        }
        return result;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_BOOLEAN_ARRAY : (boolean[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_BOOLEAN_ARRAY : (boolean[])a.clone();
        }
        boolean[] c = new boolean[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static boolean[] concat(boolean[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_BOOLEAN_ARRAY : (boolean[])aa[0].clone();
        }
        int len = 0;
        for (boolean[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        boolean[] c = new boolean[len];
        int fromIndex = 0;
        for (boolean[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static char[] concat(char[] a, char[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_CHAR_ARRAY : (char[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_CHAR_ARRAY : (char[])a.clone();
        }
        char[] c = new char[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static char[] concat(char[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_CHAR_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_CHAR_ARRAY : (char[])aa[0].clone();
        }
        int len = 0;
        for (char[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        char[] c = new char[len];
        int fromIndex = 0;
        for (char[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_BYTE_ARRAY : (byte[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_BYTE_ARRAY : (byte[])a.clone();
        }
        byte[] c = new byte[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static byte[] concat(byte[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_BYTE_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_BYTE_ARRAY : (byte[])aa[0].clone();
        }
        int len = 0;
        for (byte[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        byte[] c = new byte[len];
        int fromIndex = 0;
        for (byte[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static short[] concat(short[] a, short[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_SHORT_ARRAY : (short[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_SHORT_ARRAY : (short[])a.clone();
        }
        short[] c = new short[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static short[] concat(short[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_SHORT_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_SHORT_ARRAY : (short[])aa[0].clone();
        }
        int len = 0;
        for (short[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        short[] c = new short[len];
        int fromIndex = 0;
        for (short[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static int[] concat(int[] a, int[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_INT_ARRAY : (int[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_INT_ARRAY : (int[])a.clone();
        }
        int[] c = new int[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static int[] concat(int[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_INT_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_INT_ARRAY : (int[])aa[0].clone();
        }
        int len = 0;
        for (int[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        int[] c = new int[len];
        int fromIndex = 0;
        for (int[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static long[] concat(long[] a, long[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_LONG_ARRAY : (long[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_LONG_ARRAY : (long[])a.clone();
        }
        long[] c = new long[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static long[] concat(long[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_LONG_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_LONG_ARRAY : (long[])aa[0].clone();
        }
        int len = 0;
        for (long[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        long[] c = new long[len];
        int fromIndex = 0;
        for (long[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static float[] concat(float[] a, float[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_FLOAT_ARRAY : (float[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_FLOAT_ARRAY : (float[])a.clone();
        }
        float[] c = new float[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static float[] concat(float[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_FLOAT_ARRAY : (float[])aa[0].clone();
        }
        int len = 0;
        for (float[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        float[] c = new float[len];
        int fromIndex = 0;
        for (float[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static double[] concat(double[] a, double[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_DOUBLE_ARRAY : (double[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_DOUBLE_ARRAY : (double[])a.clone();
        }
        double[] c = new double[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static double[] concat(double[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_DOUBLE_ARRAY : (double[])aa[0].clone();
        }
        int len = 0;
        for (double[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        double[] c = new double[len];
        int fromIndex = 0;
        for (double[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static <T> T[] concat(T[] a, T[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? a : (Object[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return (Object[])a.clone();
        }
        Object[] c = (Object[])N.newArray(a.getClass().getComponentType(), a.length + b.length);
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] ... aa) {
        N.checkArgNotNull(aa, "aa");
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? aa[0] : (Object[])aa[0].clone();
        }
        int len = 0;
        for (Object[] objectArray : aa) {
            if (N.isNullOrEmpty(objectArray)) continue;
            len += objectArray.length;
        }
        Object[] c = (Object[])N.newArray(aa.getClass().getComponentType().getComponentType(), len);
        int fromIndex = 0;
        for (Object[] objectArray : aa) {
            if (N.isNullOrEmpty(objectArray)) continue;
            System.arraycopy(objectArray, 0, c, fromIndex, objectArray.length);
            fromIndex += objectArray.length;
        }
        return c;
    }

    public static <T> List<T> concat(Collection<? extends T> a, Collection<? extends T> b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList(0) : new ArrayList<T>(b);
        }
        if (N.isNullOrEmpty(b)) {
            return new ArrayList<T>(a);
        }
        ArrayList<T> result = new ArrayList<T>(a.size() + b.size());
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    @SafeVarargs
    public static <T> List<T> concat(Collection<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.concat(Arrays.asList(a));
    }

    public static <T> List<T> concat(Collection<? extends Collection<? extends T>> c) {
        return N.concat(c, Fn.Factory.ofList());
    }

    public static <T, C extends Collection<T>> C concat(Collection<? extends Collection<? extends T>> c, IntFunction<? extends C> supplier) {
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        int count = 0;
        for (Collection<T> e : c) {
            if (!N.notNullOrEmpty(e)) continue;
            count += e.size();
        }
        Collection result = (Collection)supplier.apply(count);
        for (Collection<T> collection : c) {
            if (!N.notNullOrEmpty(collection)) continue;
            result.addAll(collection);
        }
        return (C)result;
    }

    public static <T> ObjIterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b) {
        return Iterators.concat(a, b);
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(Iterator<? extends T> ... a) {
        return Iterators.concat(a);
    }

    public static <T> ObjIterator<T> concatt(Collection<? extends Iterator<? extends T>> c) {
        return Iterators.concat(c);
    }

    public static int replaceAll(boolean[] a, boolean oldVal, boolean newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(char[] a, char oldVal, char newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(byte[] a, byte oldVal, byte newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(short[] a, short oldVal, short newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(int[] a, int oldVal, int newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(long[] a, long oldVal, long newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(float[] a, float oldVal, float newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Float.compare(a[i], oldVal) != 0) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(double[] a, double oldVal, double newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Double.compare(a[i], oldVal) != 0) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static <T> int replaceAll(T[] a, Object oldVal, T newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        if (oldVal == null) {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (a[i] != null) continue;
                a[i] = newVal;
                ++result;
            }
        } else {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (!N.equals(a[i], oldVal)) continue;
                a[i] = newVal;
                ++result;
            }
        }
        return result;
    }

    public static <T> int replaceAll(List<T> list, Object oldVal, T newVal) {
        if (N.isNullOrEmpty(list)) {
            return 0;
        }
        int result = 0;
        int size = list.size();
        if (size < 11 || list instanceof RandomAccess) {
            if (oldVal == null) {
                for (int i = 0; i < size; ++i) {
                    if (list.get(i) != null) continue;
                    list.set(i, newVal);
                    ++result;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (!oldVal.equals(list.get(i))) continue;
                    list.set(i, newVal);
                    ++result;
                }
            }
        } else {
            ListIterator<T> itr = list.listIterator();
            if (oldVal == null) {
                for (int i = 0; i < size; ++i) {
                    if (itr.next() != null) continue;
                    itr.set(newVal);
                    ++result;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (!oldVal.equals(itr.next())) continue;
                    itr.set(newVal);
                    ++result;
                }
            }
        }
        return result;
    }

    public static boolean[] add(boolean[] a, boolean element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        boolean[] newArray = new boolean[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static char[] add(char[] a, char element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        char[] newArray = new char[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static byte[] add(byte[] a, byte element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        byte[] newArray = new byte[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static short[] add(short[] a, short element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        short[] newArray = new short[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static int[] add(int[] a, int element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        int[] newArray = new int[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static long[] add(long[] a, long element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        long[] newArray = new long[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static float[] add(float[] a, float element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        float[] newArray = new float[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static double[] add(double[] a, double element) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(element);
        }
        double[] newArray = new double[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static String[] add(String[] a, String element) {
        if (N.isNullOrEmpty(a)) {
            return N.asArray(element);
        }
        Object[] newArray = new String[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    public static <T> T[] add(T[] a, T element) {
        N.checkArgNotNull(a, "a");
        if (N.isNullOrEmpty(a)) {
            return N.asArray(element);
        }
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + 1);
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = element;
        return newArray;
    }

    @SafeVarargs
    public static boolean[] addAll(boolean[] a, boolean ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_BOOLEAN_ARRAY : (boolean[])b.clone();
        }
        boolean[] newArray = new boolean[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static char[] addAll(char[] a, char ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_CHAR_ARRAY : (char[])b.clone();
        }
        char[] newArray = new char[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static byte[] addAll(byte[] a, byte ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_BYTE_ARRAY : (byte[])b.clone();
        }
        byte[] newArray = new byte[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static short[] addAll(short[] a, short ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_SHORT_ARRAY : (short[])b.clone();
        }
        short[] newArray = new short[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static int[] addAll(int[] a, int ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_INT_ARRAY : (int[])b.clone();
        }
        int[] newArray = new int[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static long[] addAll(long[] a, long ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_LONG_ARRAY : (long[])b.clone();
        }
        long[] newArray = new long[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static float[] addAll(float[] a, float ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_FLOAT_ARRAY : (float[])b.clone();
        }
        float[] newArray = new float[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static double[] addAll(double[] a, double ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_DOUBLE_ARRAY : (double[])b.clone();
        }
        double[] newArray = new double[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static String[] addAll(String[] a, String ... b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_STRING_ARRAY : (String[])b.clone();
        }
        Object[] newArray = new String[a.length + b.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] a, T ... b) {
        N.checkArgNotNull(a, "a");
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? b : (Object[])b.clone();
        }
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    public static boolean[] insert(boolean[] a, int index, boolean element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        boolean[] newArray = new boolean[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static char[] insert(char[] a, int index, char element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        char[] newArray = new char[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static byte[] insert(byte[] a, int index, byte element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        byte[] newArray = new byte[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static short[] insert(short[] a, int index, short element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        short[] newArray = new short[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static int[] insert(int[] a, int index, int element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        int[] newArray = new int[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static long[] insert(long[] a, int index, long element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        long[] newArray = new long[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static float[] insert(float[] a, int index, float element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        float[] newArray = new float[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static double[] insert(double[] a, int index, double element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(element);
        }
        double[] newArray = new double[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static String[] insert(String[] a, int index, String element) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return N.asArray(element);
        }
        Object[] newArray = new String[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static <T> T[] insert(T[] a, int index, T element) {
        N.checkArgNotNull(a, "a");
        Object[] newArray = (Object[])N.newArray(a.getClass().getComponentType(), a.length + 1);
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = element;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static boolean[] insertAll(boolean[] a, int index, boolean ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (boolean[])b.clone();
        }
        boolean[] newArray = new boolean[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static char[] insertAll(char[] a, int index, char ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (char[])b.clone();
        }
        char[] newArray = new char[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static byte[] insertAll(byte[] a, int index, byte ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (byte[])b.clone();
        }
        byte[] newArray = new byte[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static short[] insertAll(short[] a, int index, short ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (short[])b.clone();
        }
        short[] newArray = new short[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static int[] insertAll(int[] a, int index, int ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (int[])b.clone();
        }
        int[] newArray = new int[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static long[] insertAll(long[] a, int index, long ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (long[])b.clone();
        }
        long[] newArray = new long[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static float[] insertAll(float[] a, int index, float ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (float[])b.clone();
        }
        float[] newArray = new float[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static double[] insertAll(double[] a, int index, double ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (double[])b.clone();
        }
        double[] newArray = new double[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static String[] insertAll(String[] a, int index, String ... b) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (String[])b.clone();
        }
        Object[] newArray = new String[a.length + b.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static <T> T[] insertAll(T[] a, int index, T ... b) {
        N.checkArgNotNull(a, "a");
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(b, 0, newArray, index, b.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + b.length, a.length - index);
        }
        return newArray;
    }

    public static boolean[] delete(boolean[] a, int index) {
        boolean[] result = new boolean[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static char[] delete(char[] a, int index) {
        char[] result = new char[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static byte[] delete(byte[] a, int index) {
        byte[] result = new byte[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static short[] delete(short[] a, int index) {
        short[] result = new short[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static int[] delete(int[] a, int index) {
        int[] result = new int[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static long[] delete(long[] a, int index) {
        long[] result = new long[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static float[] delete(float[] a, int index) {
        float[] result = new float[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static double[] delete(double[] a, int index) {
        double[] result = new double[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static <T> T[] delete(T[] a, int index) {
        Object[] result = (Object[])N.newArray(a.getClass().getComponentType(), a.length - 1);
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    @SafeVarargs
    public static boolean[] deleteAll(boolean[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (boolean[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        boolean[] result = new boolean[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static char[] deleteAll(char[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (char[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        char[] result = new char[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static byte[] deleteAll(byte[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (byte[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        byte[] result = new byte[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static short[] deleteAll(short[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (short[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        short[] result = new short[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static int[] deleteAll(int[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (int[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        int[] result = new int[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static long[] deleteAll(long[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (long[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        long[] result = new long[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static float[] deleteAll(float[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (float[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        float[] result = new float[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static double[] deleteAll(double[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return (double[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        double[] result = new double[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] deleteAll(T[] a, int ... indices) {
        N.checkArgNotNull(a, "a");
        if (N.isNullOrEmpty(indices)) {
            return (Object[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        return N.deleteAllBySortedIndices(a, indices);
    }

    private static <T> T[] deleteAllBySortedIndices(T[] a, int ... indices) {
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        Object[] result = (Object[])N.newArray(a.getClass().getComponentType(), a.length - diff);
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static boolean deleteAll(List<?> list, int ... indices) {
        N.checkArgNotNull(list);
        if (N.isNullOrEmpty(indices)) {
            return false;
        }
        if (indices.length == 1) {
            list.remove(indices[0]);
            return true;
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        if (indices[0] < 0 || indices[indices.length - 1] >= list.size()) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + indices[indices.length - 1]);
        }
        if (list instanceof LinkedList) {
            Iterator<?> iterator = list.iterator();
            int idx = -1;
            int len = indices.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0 && indices[i] == indices[i - 1]) continue;
                while (idx < indices[i]) {
                    ++idx;
                    iterator.next();
                }
                iterator.remove();
            }
        } else {
            Object[] a = list.toArray();
            Object[] res = N.deleteAllBySortedIndices(a, indices);
            list.clear();
            list.addAll(Arrays.asList(res));
        }
        return true;
    }

    public static boolean[] deleteRange(boolean[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (boolean[])a.clone();
        }
        boolean[] b = new boolean[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static char[] deleteRange(char[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (char[])a.clone();
        }
        char[] b = new char[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static byte[] deleteRange(byte[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (byte[])a.clone();
        }
        byte[] b = new byte[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static short[] deleteRange(short[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (short[])a.clone();
        }
        short[] b = new short[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static int[] deleteRange(int[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (int[])a.clone();
        }
        int[] b = new int[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static long[] deleteRange(long[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (long[])a.clone();
        }
        long[] b = new long[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static float[] deleteRange(float[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (float[])a.clone();
        }
        float[] b = new float[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static double[] deleteRange(double[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (double[])a.clone();
        }
        double[] b = new double[a.length - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static <T> T[] deleteRange(T[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (fromIndex == toIndex) {
            return (Object[])a.clone();
        }
        Object[] b = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length - (toIndex - fromIndex));
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < a.length) {
            N.copy(a, toIndex, b, fromIndex, a.length - toIndex);
        }
        return b;
    }

    public static <T> boolean deleteRange(List<T> c, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, c.size());
        if (fromIndex == toIndex) {
            return false;
        }
        if (c instanceof LinkedList || toIndex - fromIndex <= 3) {
            c.subList(fromIndex, toIndex).clear();
        } else {
            if (isListElementDataFieldGettable && isListElementDataFieldSettable && listElementDataField != null && c instanceof ArrayList) {
                Object[] array = null;
                try {
                    array = (Object[])listElementDataField.get(c);
                    N.copy(array, toIndex, array, fromIndex, c.size() - toIndex);
                    listSizeField.set(c, c.size() - (toIndex - fromIndex));
                    c.add(null);
                    c.remove(c.size() - 1);
                    return true;
                }
                catch (Throwable e) {
                    isListElementDataFieldSettable = false;
                }
            }
            ArrayList<T> tmp = new ArrayList<T>(c.size() - (toIndex - fromIndex));
            if (fromIndex > 0) {
                tmp.addAll(c.subList(0, fromIndex));
            }
            if (toIndex < c.size()) {
                tmp.addAll(c.subList(toIndex, c.size()));
            }
            c.clear();
            c.addAll(tmp);
        }
        return true;
    }

    public static boolean[] remove(boolean[] a, boolean element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (boolean[])a.clone() : N.delete(a, index);
    }

    public static char[] remove(char[] a, char element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (char[])a.clone() : N.delete(a, index);
    }

    public static byte[] remove(byte[] a, byte element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (byte[])a.clone() : N.delete(a, index);
    }

    public static short[] remove(short[] a, short element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (short[])a.clone() : N.delete(a, index);
    }

    public static int[] remove(int[] a, int element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (int[])a.clone() : N.delete(a, index);
    }

    public static long[] remove(long[] a, long element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (long[])a.clone() : N.delete(a, index);
    }

    public static float[] remove(float[] a, float element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (float[])a.clone() : N.delete(a, index);
    }

    public static double[] remove(double[] a, double element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (double[])a.clone() : N.delete(a, index);
    }

    public static <T> T[] remove(T[] a, Object element) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        int index = N.indexOf(a, 0, element);
        return index == -1 ? (Object[])a.clone() : N.delete(a, index);
    }

    static boolean remove(Collection<?> c, Object element) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return c.remove(element);
    }

    public static boolean[] removeAllOccurrences(boolean[] a, boolean element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] copy = (boolean[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == element) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static char[] removeAllOccurrences(char[] a, char element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] copy = (char[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == element) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static byte[] removeAllOccurrences(byte[] a, byte element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] copy = (byte[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == element) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static short[] removeAllOccurrences(short[] a, short element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] copy = (short[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == element) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static int[] removeAllOccurrences(int[] a, int element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        int[] copy = (int[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == element) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static long[] removeAllOccurrences(long[] a, long element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        long[] copy = (long[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == element) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static float[] removeAllOccurrences(float[] a, float element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] copy = (float[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (N.equals(a[i], element)) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static double[] removeAllOccurrences(double[] a, double element) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] copy = (double[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (N.equals(a[i], element)) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static <T> T[] removeAllOccurrences(T[] a, Object element) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        Object[] copy = (Object[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (N.equals(a[i], element)) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static boolean removeAllOccurrences(Collection<?> c, Object element) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return Iterables.removeAll(c, N.asSet(element));
    }

    @SafeVarargs
    public static <T> T[] removeAll(T[] a, Object ... elements) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        if (N.isNullOrEmpty(elements)) {
            return (Object[])a.clone();
        }
        if (elements.length == 1) {
            return N.removeAllOccurrences(a, elements[0]);
        }
        Set<Object> set = N.asSet(elements);
        ArrayList<T> result = new ArrayList<T>();
        for (T e : a) {
            if (set.contains(e)) continue;
            result.add(e);
        }
        return result.toArray((Object[])N.newArray(a.getClass().getComponentType(), result.size()));
    }

    @SafeVarargs
    public static boolean removeAll(Collection<?> c, Object ... elements) {
        if (N.isNullOrEmpty(c) || N.isNullOrEmpty(elements)) {
            return false;
        }
        return Iterables.removeAll(c, N.asSet(elements));
    }

    public static boolean[] removeDuplicates(boolean[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static boolean[] removeDuplicates(boolean[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static boolean[] removeDuplicates(boolean[] a, int from, int to, boolean isSorted) {
        boolean[] blArray;
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        Boolean[] b = new Boolean[2];
        for (int i = from; i < to; ++i) {
            if (b[0] == null) {
                b[0] = a[i];
                continue;
            }
            if (b[0] == a[i]) continue;
            b[1] = a[i];
            break;
        }
        if (b[1] == null) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = b[0];
        } else {
            boolean[] blArray3 = new boolean[2];
            blArray3[0] = b[0];
            blArray = blArray3;
            blArray3[1] = b[1];
        }
        return blArray;
    }

    public static char[] removeDuplicates(char[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static char[] removeDuplicates(char[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static char[] removeDuplicates(char[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            char[] b = from == 0 && to == a.length ? (char[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(N.initHashCapacity(a.length));
        for (int i = from; i < to; ++i) {
            set.add(Character.valueOf(a[i]));
        }
        if (set.size() == to - from) {
            return from == 0 && to == a.length ? (char[])a.clone() : N.copyOfRange(a, from, to);
        }
        char[] result = new char[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            char e = ((Character)iterator.next()).charValue();
            result[i++] = e;
        }
        return result;
    }

    public static byte[] removeDuplicates(byte[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static byte[] removeDuplicates(byte[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static byte[] removeDuplicates(byte[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            byte[] b = from == 0 && to == a.length ? (byte[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(N.initHashCapacity(a.length));
        for (int i = from; i < to; ++i) {
            set.add(a[i]);
        }
        if (set.size() == to - from) {
            return from == 0 && to == a.length ? (byte[])a.clone() : N.copyOfRange(a, from, to);
        }
        byte[] result = new byte[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            byte e = (Byte)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static short[] removeDuplicates(short[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static short[] removeDuplicates(short[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static short[] removeDuplicates(short[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            short[] b = from == 0 && to == a.length ? (short[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(N.initHashCapacity(a.length));
        for (int i = from; i < to; ++i) {
            set.add(a[i]);
        }
        if (set.size() == to - from) {
            return from == 0 && to == a.length ? (short[])a.clone() : N.copyOfRange(a, from, to);
        }
        short[] result = new short[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            short e = (Short)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static int[] removeDuplicates(int[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static int[] removeDuplicates(int[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static int[] removeDuplicates(int[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            int[] b = from == 0 && to == a.length ? (int[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(N.initHashCapacity(a.length));
        for (int i = from; i < to; ++i) {
            set.add(a[i]);
        }
        if (set.size() == to - from) {
            return from == 0 && to == a.length ? (int[])a.clone() : N.copyOfRange(a, from, to);
        }
        int[] result = new int[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int e = (Integer)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static long[] removeDuplicates(long[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static long[] removeDuplicates(long[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static long[] removeDuplicates(long[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_LONG_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            long[] b = from == 0 && to == a.length ? (long[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(N.initHashCapacity(a.length));
        for (int i = from; i < to; ++i) {
            set.add(a[i]);
        }
        if (set.size() == to - from) {
            return from == 0 && to == a.length ? (long[])a.clone() : N.copyOfRange(a, from, to);
        }
        long[] result = new long[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long e = (Long)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static float[] removeDuplicates(float[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static float[] removeDuplicates(float[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static float[] removeDuplicates(float[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            float[] b = from == 0 && to == a.length ? (float[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (N.equals(b[i], b[i - 1])) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(N.initHashCapacity(a.length));
        for (int i = from; i < to; ++i) {
            set.add(Float.valueOf(a[i]));
        }
        if (set.size() == to - from) {
            return from == 0 && to == a.length ? (float[])a.clone() : N.copyOfRange(a, from, to);
        }
        float[] result = new float[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            float e = ((Float)iterator.next()).floatValue();
            result[i++] = e;
        }
        return result;
    }

    public static double[] removeDuplicates(double[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.removeDuplicates(a, false);
    }

    public static double[] removeDuplicates(double[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static double[] removeDuplicates(double[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            double[] b = from == 0 && to == a.length ? (double[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (N.equals(b[i], b[i - 1])) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(N.initHashCapacity(a.length));
        for (int i = from; i < to; ++i) {
            set.add(a[i]);
        }
        if (set.size() == to - from) {
            return from == 0 && to == a.length ? (double[])a.clone() : N.copyOfRange(a, from, to);
        }
        double[] result = new double[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            double e = (Double)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static <T> T[] removeDuplicates(T[] a) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        return N.removeDuplicates(a, false);
    }

    public static <T> T[] removeDuplicates(T[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static <T> T[] removeDuplicates(T[] a, int from, int to, boolean isSorted) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a) && from == 0 && to == 0) {
            return a;
        }
        if (to - from <= 1) {
            return N.copyOfRange(a, from, to);
        }
        if (isSorted) {
            T[] b = from == 0 && to == a.length ? (Object[])a.clone() : N.copyOfRange(a, from, to);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (N.equals(b[i], b[i - 1])) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        List<Object> list = N.distinct(a, from, to);
        return list.toArray((Object[])N.newArray(a.getClass().getComponentType(), list.size()));
    }

    public static boolean removeDuplicates(Collection<?> c) {
        if (N.isNullOrEmpty(c) || c.size() == 1) {
            return false;
        }
        return N.removeDuplicates(c, false);
    }

    public static boolean removeDuplicates(Collection<?> c, boolean isSorted) {
        boolean hasDuplicates;
        if (N.isNullOrEmpty(c) || c.size() == 1) {
            return false;
        }
        if (isSorted) {
            boolean hasDuplicates2 = false;
            Iterator<?> it = c.iterator();
            Object pre = it.next();
            Object next = null;
            while (it.hasNext()) {
                next = it.next();
                if (N.equals(next, pre)) {
                    it.remove();
                    hasDuplicates2 = true;
                    continue;
                }
                pre = next;
            }
            return hasDuplicates2;
        }
        List<?> list = N.distinct(c);
        boolean bl = hasDuplicates = list.size() != c.size();
        if (hasDuplicates) {
            c.clear();
            c.addAll(list);
        }
        return hasDuplicates;
    }

    public static boolean hasDuplicates(char[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(char[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(char[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(Character.valueOf(a[i]))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(byte[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(byte[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(byte[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(short[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(short[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(short[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(int[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(int[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(int[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(long[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(long[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(long[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(float[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(float[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(float[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return N.equals(a[fromIndex], a[fromIndex + 1]);
        }
        if (toIndex - fromIndex == 3) {
            return N.equals(a[fromIndex], a[fromIndex + 1]) || N.equals(a[fromIndex], a[fromIndex + 2]) || N.equals(a[fromIndex + 1], a[fromIndex + 2]);
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (!N.equals(a[i], a[i - 1])) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(Float.valueOf(a[i]))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(double[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(double[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(double[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return N.equals(a[fromIndex], a[fromIndex + 1]);
        }
        if (toIndex - fromIndex == 3) {
            return N.equals(a[fromIndex], a[fromIndex + 1]) || N.equals(a[fromIndex], a[fromIndex + 2]) || N.equals(a[fromIndex + 1], a[fromIndex + 2]);
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (!N.equals(a[i], a[i - 1])) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean hasDuplicates(T[] a) {
        return N.hasDuplicates(a, false);
    }

    public static <T> boolean hasDuplicates(T[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static <T> boolean hasDuplicates(T[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return N.equals(a[fromIndex], a[fromIndex + 1]);
        }
        if (toIndex - fromIndex == 3) {
            return N.equals(a[fromIndex], a[fromIndex + 1]) || N.equals(a[fromIndex], a[fromIndex + 2]) || N.equals(a[fromIndex + 1], a[fromIndex + 2]);
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (!N.equals(a[i], a[i - 1])) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(toIndex - fromIndex));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(N.hashKey(a[i]))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(Collection<?> c) {
        return N.hasDuplicates(c, false);
    }

    public static boolean hasDuplicates(Collection<?> c, boolean isSorted) {
        if (N.isNullOrEmpty(c) || c.size() == 1) {
            return false;
        }
        if (isSorted) {
            Iterator<?> it = c.iterator();
            Object pre = it.next();
            Object next = null;
            while (it.hasNext()) {
                next = it.next();
                if (N.equals(next, pre)) {
                    return true;
                }
                pre = next;
            }
            return false;
        }
        Set set = N.newHashSet(N.initHashCapacity(c.size()));
        for (Object e : c) {
            if (set.add(N.hashKey(e))) continue;
            return true;
        }
        return false;
    }

    static Object hashKey(Object obj) {
        return obj == null || !obj.getClass().isArray() ? obj : Wrapper.of(obj);
    }

    @SafeVarargs
    public static int sum(char ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(char[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        int sum = 0;
        for (int i = from; i < to; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static int sum(byte ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(byte[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        int sum = 0;
        for (int i = from; i < to; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static int sum(short ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(short[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        int sum = 0;
        for (int i = from; i < to; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static int sum(int ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(int[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        int sum = 0;
        for (int i = from; i < to; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static long sum(long ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0L;
        }
        return N.sum(a, 0, a.length);
    }

    public static long sum(long[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0L;
        }
        long sum = 0L;
        for (int i = from; i < to; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static float sum(float ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0f;
        }
        return N.sum(a, 0, a.length);
    }

    public static float sum(float[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0f;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = from; i < to; ++i) {
            summation.add(a[i]);
        }
        return (float)summation.sum();
    }

    @SafeVarargs
    public static double sum(double ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.sum(a, 0, a.length);
    }

    public static double sum(double[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = from; i < to; ++i) {
            summation.add(a[i]);
        }
        return summation.sum();
    }

    @SafeVarargs
    public static double average(char ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(char[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        if (from == to) {
            return 0.0;
        }
        return (double)N.sum(a, from, to) / (double)(to - from);
    }

    @SafeVarargs
    public static double average(byte ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(byte[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        if (from == to) {
            return 0.0;
        }
        return (double)N.sum(a, from, to) / (double)(to - from);
    }

    @SafeVarargs
    public static double average(short ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(short[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        if (from == to) {
            return 0.0;
        }
        return (double)N.sum(a, from, to) / (double)(to - from);
    }

    @SafeVarargs
    public static double average(int ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(int[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        if (from == to) {
            return 0.0;
        }
        return (double)N.sum(a, from, to) / (double)(to - from);
    }

    @SafeVarargs
    public static double average(long ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(long[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        if (from == to) {
            return 0.0;
        }
        return (double)N.sum(a, from, to) / (double)(to - from);
    }

    @SafeVarargs
    public static double average(float ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(float[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        if (from == to) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = from; i < to; ++i) {
            summation.add(a[i]);
        }
        return summation.average().orZero();
    }

    @SafeVarargs
    public static double average(double ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(double[] a, int from, int to) {
        N.checkFromToIndex(from, to, N.len(a));
        if (N.isNullOrEmpty(a)) {
            if (to > 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0.0;
        }
        if (from == to) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = from; i < to; ++i) {
            summation.add(a[i]);
        }
        return summation.average().orZero();
    }

    public static char min(char a, char b) {
        return a <= b ? a : b;
    }

    public static byte min(byte a, byte b) {
        return a <= b ? a : b;
    }

    public static short min(short a, short b) {
        return a <= b ? a : b;
    }

    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long min(long a, long b) {
        return a <= b ? a : b;
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static <T extends Comparable<? super T>> T min(T a, T b) {
        return (T)((Comparable)((Object)N.min(a, b, NULL_MAX_COMPARATOR)));
    }

    public static <T> T min(T a, T b, Comparator<? super T> cmp) {
        return (cmp == null ? NULL_MAX_COMPARATOR : cmp).compare(a, b) <= 0 ? a : b;
    }

    public static char min(char a, char b, char c) {
        char m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static byte min(byte a, byte b, byte c) {
        byte m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static short min(short a, short b, short c) {
        short m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static int min(int a, int b, int c) {
        int m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static long min(long a, long b, long c) {
        long m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static <T extends Comparable<? super T>> T min(T a, T b, T c) {
        return N.min(a, b, c, NULL_MAX_COMPARATOR);
    }

    public static <T> T min(T a, T b, T c, Comparator<? super T> cmp) {
        return (T)N.min(N.min(a, b, cmp), c, cmp);
    }

    @SafeVarargs
    public static char min(char ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        if (N.isNullOrEmpty(a)) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return N.min(a, 0, a.length);
    }

    public static char min(char[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        char min = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static byte min(byte ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static byte min(byte[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        byte min = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static short min(short ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static short min(short[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        short min = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static int min(int ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static int min(int[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        int min = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static long min(long ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static long min(long[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        long min = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static float min(float ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static float min(float[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        float min = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (!Float.isNaN(min = Math.min(min, a[i]))) continue;
            return min;
        }
        return min;
    }

    @SafeVarargs
    public static double min(double ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static double min(double[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        double min = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (!Double.isNaN(min = Math.min(min, a[i]))) continue;
            return min;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T min(T[] a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, false, a.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] a, int from, int to) {
        return (T)((Comparable)N.min(a, from, to, NULL_MAX_COMPARATOR));
    }

    public static <T> T min(T[] a, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length, cmp);
    }

    public static <T> T min(T[] a, int from, int to, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        T candidate = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (cmp.compare(a[i], candidate) < 0) {
                candidate = a[i];
            }
            if (candidate != null || cmp != NULL_MIN_COMPARATOR) continue;
            return null;
        }
        return candidate;
    }

    public static <T extends Comparable<? super T>> T min(Collection<? extends T> c) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.min(c, 0, c.size());
    }

    public static <T extends Comparable<? super T>> T min(Collection<? extends T> c, int from, int to) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return (T)((Comparable)N.min(c, from, to, NULL_MAX_COMPARATOR));
    }

    public static <T> T min(Collection<? extends T> c, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.min(c, 0, c.size(), cmp);
    }

    public static <T> T min(Collection<? extends T> c, int from, int to, Comparator<? super T> cmp) {
        N.checkFromToIndex(from, to, N.size(c));
        if (N.isNullOrEmpty(c) || to - from < 1 || from >= c.size()) {
            throw new IllegalArgumentException("The size of collection can not be null or empty");
        }
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        Object candidate = null;
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            candidate = list.get(from);
            for (int i = from + 1; i < to; ++i) {
                e = list.get(i);
                if (cmp.compare(e, candidate) < 0) {
                    candidate = e;
                }
                if (candidate != null || cmp != NULL_MIN_COMPARATOR) continue;
                return null;
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < to; ++i) {
                if (i < from) {
                    it.next();
                    continue;
                }
                if (i == from) {
                    candidate = it.next();
                    continue;
                }
                e = it.next();
                if (cmp.compare(e, candidate) < 0) {
                    candidate = e;
                }
                if (candidate != null || cmp != NULL_MIN_COMPARATOR) continue;
                return null;
            }
        }
        return candidate;
    }

    public static <T extends Comparable<T>> List<T> minAll(T[] a) {
        return N.minAll(a, NULL_MAX_COMPARATOR);
    }

    public static <T> List<T> minAll(T[] a, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        ArrayList<T> result = new ArrayList<T>();
        T candicate = a[0];
        int cp = 0;
        result.add(candicate);
        int len = a.length;
        for (int i = 1; i < len; ++i) {
            cp = cmp.compare(a[i], candicate);
            if (cp == 0) {
                result.add(a[i]);
                continue;
            }
            if (cp >= 0) continue;
            result.clear();
            result.add(a[i]);
            candicate = a[i];
        }
        return result;
    }

    public static <T extends Comparable<T>> List<T> minAll(Collection<T> c) {
        return N.minAll(c, NULL_MAX_COMPARATOR);
    }

    public static <T> List<T> minAll(Collection<T> c, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        Iterator<T> iter = c.iterator();
        ArrayList<T> result = new ArrayList<T>();
        T candicate = iter.next();
        Object next = null;
        int cp = 0;
        result.add(candicate);
        while (iter.hasNext()) {
            next = iter.next();
            cp = cmp.compare(next, candicate);
            if (cp == 0) {
                result.add(next);
                continue;
            }
            if (cp >= 0) continue;
            result.clear();
            result.add(next);
            candicate = next;
        }
        return result;
    }

    public static char max(char a, char b) {
        return a >= b ? a : b;
    }

    public static byte max(byte a, byte b) {
        return a >= b ? a : b;
    }

    public static short max(short a, short b) {
        return a >= b ? a : b;
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long max(long a, long b) {
        return a >= b ? a : b;
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static <T extends Comparable<? super T>> T max(T a, T b) {
        return (T)((Comparable)((Object)N.max(a, b, NULL_MIN_COMPARATOR)));
    }

    public static <T> T max(T a, T b, Comparator<? super T> cmp) {
        return (cmp == null ? NULL_MIN_COMPARATOR : cmp).compare(a, b) >= 0 ? a : b;
    }

    public static char max(char a, char b, char c) {
        char m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static byte max(byte a, byte b, byte c) {
        byte m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static short max(short a, short b, short c) {
        short m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static int max(int a, int b, int c) {
        int m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static long max(long a, long b, long c) {
        long m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static <T extends Comparable<? super T>> T max(T a, T b, T c) {
        return N.max(a, b, c, NULL_MIN_COMPARATOR);
    }

    public static <T> T max(T a, T b, T c, Comparator<? super T> cmp) {
        return (T)N.max(N.max(a, b, cmp), c, cmp);
    }

    @SafeVarargs
    public static char max(char ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static char max(char[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        char max = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static byte max(byte ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static byte max(byte[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        byte max = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static short max(short ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static short max(short[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        short max = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static int max(int ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static int max(int[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        int max = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static long max(long ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static long max(long[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        long max = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static float max(float ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static float max(float[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        float max = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (!Float.isNaN(max = Math.max(max, a[i]))) continue;
            return max;
        }
        return max;
    }

    @SafeVarargs
    public static double max(double ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static double max(double[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        double max = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (!Double.isNaN(max = Math.max(max, a[i]))) continue;
            return max;
        }
        return max;
    }

    public static <T extends Comparable<? super T>> T max(T[] a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, false, a.length);
    }

    public static <T extends Comparable<? super T>> T max(T[] a, int from, int to) {
        return (T)((Comparable)N.max(a, from, to, NULL_MIN_COMPARATOR));
    }

    public static <T> T max(T[] a, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length, cmp);
    }

    public static <T> T max(T[] a, int from, int to, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        T candidate = a[from];
        for (int i = from + 1; i < to; ++i) {
            if (cmp.compare(a[i], candidate) > 0) {
                candidate = a[i];
            }
            if (candidate != null || cmp != NULL_MAX_COMPARATOR) continue;
            return null;
        }
        return candidate;
    }

    public static <T extends Comparable<? super T>> T max(Collection<? extends T> c) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.max(c, 0, c.size());
    }

    public static <T extends Comparable<? super T>> T max(Collection<? extends T> c, int from, int to) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return (T)((Comparable)N.max(c, from, to, NULL_MIN_COMPARATOR));
    }

    public static <T> T max(Collection<? extends T> c, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.max(c, 0, c.size(), cmp);
    }

    public static <T> T max(Collection<? extends T> c, int from, int to, Comparator<? super T> cmp) {
        N.checkFromToIndex(from, to, N.size(c));
        if (N.isNullOrEmpty(c) || to - from < 1 || from >= c.size()) {
            throw new IllegalArgumentException("The size of collection can not be null or empty");
        }
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        Object candidate = null;
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            candidate = list.get(from);
            for (int i = from + 1; i < to; ++i) {
                e = list.get(i);
                if (cmp.compare(e, candidate) > 0) {
                    candidate = e;
                }
                if (candidate != null || cmp != NULL_MAX_COMPARATOR) continue;
                return null;
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < to; ++i) {
                if (i < from) {
                    it.next();
                    continue;
                }
                if (i == from) {
                    candidate = it.next();
                } else {
                    e = it.next();
                    if (cmp.compare(e, candidate) > 0) {
                        candidate = e;
                    }
                }
                if (candidate != null || cmp != NULL_MAX_COMPARATOR) continue;
                return null;
            }
        }
        return candidate;
    }

    public static <T extends Comparable<T>> List<T> maxAll(T[] a) {
        return N.maxAll(a, NULL_MIN_COMPARATOR);
    }

    public static <T> List<T> maxAll(T[] a, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        ArrayList<T> result = new ArrayList<T>();
        T candicate = a[0];
        int cp = 0;
        result.add(candicate);
        int len = a.length;
        for (int i = 1; i < len; ++i) {
            cp = cmp.compare(a[i], candicate);
            if (cp == 0) {
                result.add(a[i]);
                continue;
            }
            if (cp <= 0) continue;
            result.clear();
            result.add(a[i]);
            candicate = a[i];
        }
        return result;
    }

    public static <T extends Comparable<T>> List<T> maxAll(Collection<T> c) {
        return N.maxAll(c, NULL_MIN_COMPARATOR);
    }

    public static <T> List<T> maxAll(Collection<T> c, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        Iterator<T> iter = c.iterator();
        ArrayList<T> result = new ArrayList<T>();
        T candicate = iter.next();
        Object next = null;
        int cp = 0;
        result.add(candicate);
        while (iter.hasNext()) {
            next = iter.next();
            cp = cmp.compare(next, candicate);
            if (cp == 0) {
                result.add(next);
                continue;
            }
            if (cp <= 0) continue;
            result.clear();
            result.add(next);
            candicate = next;
        }
        return result;
    }

    public static char median(char a, char b, char c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static byte median(byte a, byte b, byte c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static short median(short a, short b, short c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static int median(int a, int b, int c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static long median(long a, long b, long c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static float median(float a, float b, float c) {
        int ab = Float.compare(a, b);
        int ac = Float.compare(a, c);
        int bc = 0;
        if (ab >= 0 && ac <= 0 || ac >= 0 && ab <= 0) {
            return a;
        }
        bc = Float.compare(b, c);
        if (bc <= 0 && ab <= 0 || bc >= 0 && ab >= 0) {
            return b;
        }
        return c;
    }

    public static double median(double a, double b, double c) {
        int ab = Double.compare(a, b);
        int ac = Double.compare(a, c);
        int bc = 0;
        if (ab >= 0 && ac <= 0 || ac >= 0 && ab <= 0) {
            return a;
        }
        bc = Double.compare(b, c);
        if (bc <= 0 && ab <= 0 || bc >= 0 && ab >= 0) {
            return b;
        }
        return c;
    }

    public static <T extends Comparable<? super T>> T median(T a, T b, T c) {
        return N.median(a, b, c, NATURAL_ORDER);
    }

    public static <T> T median(T a, T b, T c, Comparator<? super T> cmp) {
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int ab = cmp.compare(a, b);
        int ac = cmp.compare(a, c);
        int bc = 0;
        if (ab >= 0 && ac <= 0 || ac >= 0 && ab <= 0) {
            return a;
        }
        bc = cmp.compare(b, c);
        if (bc <= 0 && ab <= 0 || bc >= 0 && ab >= 0) {
            return b;
        }
        return c;
    }

    @SafeVarargs
    public static char median(char ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static char median(char[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        int len = to - from;
        if (len == 1) {
            return a[from];
        }
        if (len == 2) {
            return N.min(a[from], a[from + 1]);
        }
        if (len == 3) {
            return N.median(a[from], a[from + 1], a[from + 2]);
        }
        return N.kthLargest(a, from, to, len / 2 + 1);
    }

    @SafeVarargs
    public static byte median(byte ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static byte median(byte[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        int len = to - from;
        if (len == 1) {
            return a[from];
        }
        if (len == 2) {
            return N.min(a[from], a[from + 1]);
        }
        if (len == 3) {
            return N.median(a[from], a[from + 1], a[from + 2]);
        }
        return N.kthLargest(a, from, to, len / 2 + 1);
    }

    @SafeVarargs
    public static short median(short ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static short median(short[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        int len = to - from;
        if (len == 1) {
            return a[from];
        }
        if (len == 2) {
            return N.min(a[from], a[from + 1]);
        }
        if (len == 3) {
            return N.median(a[from], a[from + 1], a[from + 2]);
        }
        return N.kthLargest(a, from, to, len / 2 + 1);
    }

    @SafeVarargs
    public static int median(int ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static int median(int[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        int len = to - from;
        if (len == 1) {
            return a[from];
        }
        if (len == 2) {
            return N.min(a[from], a[from + 1]);
        }
        if (len == 3) {
            return N.median(a[from], a[from + 1], a[from + 2]);
        }
        return N.kthLargest(a, from, to, len / 2 + 1);
    }

    @SafeVarargs
    public static long median(long ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static long median(long[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        int len = to - from;
        if (len == 1) {
            return a[from];
        }
        if (len == 2) {
            return N.min(a[from], a[from + 1]);
        }
        if (len == 3) {
            return N.median(a[from], a[from + 1], a[from + 2]);
        }
        return N.kthLargest(a, from, to, len / 2 + 1);
    }

    @SafeVarargs
    public static float median(float ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static float median(float[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        int len = to - from;
        if (len == 1) {
            return a[from];
        }
        if (len == 2) {
            return N.min(a[from], a[from + 1]);
        }
        if (len == 3) {
            return N.median(a[from], a[from + 1], a[from + 2]);
        }
        return N.kthLargest(a, from, to, len / 2 + 1);
    }

    @SafeVarargs
    public static double median(double ... a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static double median(double[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        int len = to - from;
        if (len == 1) {
            return a[from];
        }
        if (len == 2) {
            return N.min(a[from], a[from + 1]);
        }
        if (len == 3) {
            return N.median(a[from], a[from + 1], a[from + 2]);
        }
        return N.kthLargest(a, from, to, len / 2 + 1);
    }

    public static <T extends Comparable<? super T>> T median(T[] a) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, false, a.length);
    }

    public static <T extends Comparable<? super T>> T median(T[] a, int from, int to) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return (T)((Comparable)N.median(a, from, to, NATURAL_ORDER));
    }

    public static <T> T median(T[] a, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length, cmp);
    }

    public static <T> T median(T[] a, int from, int to, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(from, to, a.length);
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int len = to - from;
        return N.kthLargest(a, from, to, len / 2 + 1, cmp);
    }

    public static <T extends Comparable<? super T>> T median(Collection<? extends T> c) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.median(c, 0, c.size());
    }

    public static <T extends Comparable<? super T>> T median(Collection<? extends T> c, int from, int to) {
        return (T)((Comparable)N.median(c, from, to, NATURAL_ORDER));
    }

    public static <T> T median(Collection<? extends T> c, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.median(c, 0, c.size(), cmp);
    }

    public static <T> T median(Collection<? extends T> c, int from, int to, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(c) || to - from < 1) {
            throw new IllegalArgumentException("The length of collection can not be null or empty");
        }
        N.checkFromToIndex(from, to, c.size());
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int len = to - from;
        return N.kthLargest(c, from, to, len / 2 + 1, cmp);
    }

    public static char kthLargest(char[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k);
    }

    public static char kthLargest(char[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k);
    }

    public static byte kthLargest(byte[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k);
    }

    public static byte kthLargest(byte[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k);
    }

    public static short kthLargest(short[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k);
    }

    public static short kthLargest(short[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k);
    }

    public static int kthLargest(int[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k);
    }

    public static int kthLargest(int[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k);
    }

    public static long kthLargest(long[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k);
    }

    public static long kthLargest(long[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k);
    }

    public static float kthLargest(float[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k);
    }

    public static float kthLargest(float[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k);
    }

    public static double kthLargest(double[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k);
    }

    public static double kthLargest(double[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k);
    }

    public static <T extends Comparable<T>> T kthLargest(T[] a, int k) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return (T)Array.kthLargest(a, (int)k);
    }

    public static <T extends Comparable<T>> T kthLargest(T[] a, int from, int to, int k) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return (T)Array.kthLargest(a, (int)from, (int)to, (int)k);
    }

    public static <T> T kthLargest(T[] a, int k, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return Array.kthLargest(a, k, cmp);
    }

    public static <T> T kthLargest(T[] a, int from, int to, int k, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a) || to - from < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return Array.kthLargest(a, from, to, k, cmp);
    }

    public static <T extends Comparable<T>> T kthLargest(Collection<? extends T> c, int k) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return Array.kthLargest(c, k);
    }

    public static <T extends Comparable<T>> T kthLargest(Collection<? extends T> c, int from, int to, int k) {
        if (N.isNullOrEmpty(c) || to - from < 1) {
            throw new IllegalArgumentException("The length of collection can not be null or empty");
        }
        return Array.kthLargest(c, from, to, k);
    }

    public static <T> T kthLargest(Collection<? extends T> c, int k, Comparator<? super T> cmp) {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return Array.kthLargest(c, k, cmp);
    }

    public static <T> T kthLargest(Collection<? extends T> c, int from, int to, int k, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(c) || to - from < 1) {
            throw new IllegalArgumentException("The length of collection can not be null or empty");
        }
        return Array.kthLargest(c, from, to, k, cmp);
    }

    public static Map<Percentage, Character> percentiles(char[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, Character> m = new LinkedHashMap<Percentage, Character>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, Character.valueOf(sortedArray[(int)((double)len * p.doubleValue())]));
        }
        return ImmutableMap.of(m);
    }

    public static Map<Percentage, Byte> percentiles(byte[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, Byte> m = new LinkedHashMap<Percentage, Byte>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return ImmutableMap.of(m);
    }

    public static Map<Percentage, Short> percentiles(short[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, Short> m = new LinkedHashMap<Percentage, Short>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return ImmutableMap.of(m);
    }

    public static Map<Percentage, Integer> percentiles(int[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, Integer> m = new LinkedHashMap<Percentage, Integer>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return ImmutableMap.of(m);
    }

    public static Map<Percentage, Long> percentiles(long[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, Long> m = new LinkedHashMap<Percentage, Long>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return ImmutableMap.of(m);
    }

    public static Map<Percentage, Float> percentiles(float[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, Float> m = new LinkedHashMap<Percentage, Float>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, Float.valueOf(sortedArray[(int)((double)len * p.doubleValue())]));
        }
        return ImmutableMap.of(m);
    }

    public static Map<Percentage, Double> percentiles(double[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, Double> m = new LinkedHashMap<Percentage, Double>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return ImmutableMap.of(m);
    }

    public static <T> Map<Percentage, T> percentiles(T[] sortedArray) {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        LinkedHashMap<Percentage, T> m = new LinkedHashMap<Percentage, T>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return ImmutableMap.of(m);
    }

    public static <T> Map<Percentage, T> percentiles(List<T> sortedList) {
        N.checkArgNotNullOrEmpty(sortedList, "The spcified 'sortedList' can not be null or empty");
        int size = sortedList.size();
        LinkedHashMap<Percentage, T> m = new LinkedHashMap<Percentage, T>(N.initHashCapacity(Percentage.values().length));
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedList.get((int)((double)size * p.doubleValue())));
        }
        return ImmutableMap.of(m);
    }

    public static <E extends Exception> void forEach(int startInclusive, int endExclusive, Try.IntConsumer<E> action) throws E {
        N.forEach(startInclusive, endExclusive, 1, action);
    }

    public static <E extends Exception> void forEach(int startInclusive, int endExclusive, int step, Try.IntConsumer<E> action) throws E {
        N.checkArgument(step != 0, "The input parameter 'step' can not be zero");
        if (endExclusive == startInclusive || endExclusive > startInclusive != step > 0) {
            return;
        }
        long len = ((long)endExclusive * 1L - (long)startInclusive) / (long)step + (long)(((long)endExclusive * 1L - (long)startInclusive) % (long)step == 0L ? 0 : 1);
        int start = startInclusive;
        while (len-- > 0L) {
            action.accept(start);
            start += step;
        }
    }

    public static <T, E extends Exception> void forEach(int startInclusive, int endExclusive, T a, Try.ObjIntConsumer<? super T, E> action) throws E {
        N.forEach(startInclusive, endExclusive, 1, a, action);
    }

    public static <T, E extends Exception> void forEach(int startInclusive, int endExclusive, int step, T a, Try.ObjIntConsumer<? super T, E> action) throws E {
        N.checkArgument(step != 0, "The input parameter 'step' can not be zero");
        if (endExclusive == startInclusive || endExclusive > startInclusive != step > 0) {
            return;
        }
        long len = ((long)endExclusive * 1L - (long)startInclusive) / (long)step + (long)(((long)endExclusive * 1L - (long)startInclusive) % (long)step == 0L ? 0 : 1);
        int start = startInclusive;
        while (len-- > 0L) {
            action.accept(a, start);
            start += step;
        }
    }

    public static <T, E extends Exception> void forEach(T[] a, Try.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            action.accept(e);
        }
    }

    public static <T, E extends Exception> void forEach(T[] a, int fromIndex, int toIndex, Try.Consumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.len(a));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        if (fromIndex <= toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                action.accept(a[i]);
            }
        } else {
            for (int i = N.min(a.length - 1, toIndex); i > toIndex; --i) {
                action.accept(a[i]);
            }
        }
    }

    public static <T, E extends Exception> void forEach(T[] a, Try.IndexedConsumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        N.forEach(a, 0, a.length, action);
    }

    public static <T, E extends Exception> void forEach(T[] a, int fromIndex, int toIndex, Try.IndexedConsumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.len(a));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        if (fromIndex <= toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                action.accept(i, a[i]);
            }
        } else {
            for (int i = N.min(a.length - 1, toIndex); i > toIndex; --i) {
                action.accept(i, a[i]);
            }
        }
    }

    public static <T, C extends Collection<? extends T>, E extends Exception> void forEach(C c, Try.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            action.accept(e);
        }
    }

    public static <T, C extends Collection<? extends T>, E extends Exception> void forEach(C c, int fromIndex, int toIndex, Try.Consumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.size(c));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return;
        }
        fromIndex = N.min(c.size() - 1, fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            if (fromIndex <= toIndex) {
                for (int i = fromIndex; i < toIndex; ++i) {
                    action.accept(list.get(i));
                }
            } else {
                for (int i = fromIndex; i > toIndex; --i) {
                    action.accept(list.get(i));
                }
            }
        } else {
            int idx;
            Iterator<T> iter = c.iterator();
            if (fromIndex <= toIndex) {
                for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    action.accept(iter.next());
                    if (++idx < toIndex) continue;
                    break;
                }
            } else {
                while (idx <= toIndex && iter.hasNext()) {
                    iter.next();
                    ++idx;
                }
                Object[] a = new Object[fromIndex - toIndex];
                while (iter.hasNext()) {
                    a[idx - 1 - toIndex] = iter.next();
                    if (idx++ < fromIndex) continue;
                }
                for (int i = a.length - 1; i >= 0; --i) {
                    action.accept(a[i]);
                }
            }
        }
    }

    public static <T, C extends Collection<? extends T>, E extends Exception> void forEach(C c, Try.IndexedConsumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        int idx = 0;
        for (T e : c) {
            action.accept(idx++, e);
        }
    }

    public static <T, C extends Collection<? extends T>, E extends Exception> void forEach(C c, int fromIndex, int toIndex, Try.IndexedConsumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.size(c));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return;
        }
        fromIndex = N.min(c.size() - 1, fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            if (fromIndex <= toIndex) {
                for (int i = fromIndex; i < toIndex; ++i) {
                    action.accept(i, list.get(i));
                }
            } else {
                for (int i = fromIndex; i > toIndex; --i) {
                    action.accept(i, list.get(i));
                }
            }
        } else {
            int idx;
            Iterator<T> iter = c.iterator();
            if (fromIndex < toIndex) {
                for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    action.accept(idx, iter.next());
                    if (++idx < toIndex) continue;
                    break;
                }
            } else {
                while (idx <= toIndex && iter.hasNext()) {
                    iter.next();
                    ++idx;
                }
                Object[] a = new Object[fromIndex - toIndex];
                while (iter.hasNext()) {
                    a[idx - 1 - toIndex] = iter.next();
                    if (idx++ < fromIndex) continue;
                }
                for (int i = a.length - 1; i >= 0; --i) {
                    action.accept(i + toIndex + 1, a[i]);
                }
            }
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEach(T[] a, Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            Collection<U> c2 = flatMapper.apply(e);
            if (!N.notNullOrEmpty(c2)) continue;
            for (U u2 : c2) {
                action.accept(e, u2);
            }
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEach(Collection<T> c, Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            Collection<U> c2 = flatMapper.apply(e);
            if (!N.notNullOrEmpty(c2)) continue;
            for (U u2 : c2) {
                action.accept(e, u2);
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEach(T[] a, Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            Collection<T2> c2 = flatMapper.apply(e);
            if (!N.notNullOrEmpty(c2)) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3 = flatMapper2.apply(t2);
                if (!N.notNullOrEmpty(c3)) continue;
                for (T3 t3 : c3) {
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEach(Collection<T> c, Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            Collection<T2> c2 = flatMapper.apply(e);
            if (!N.notNullOrEmpty(c2)) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3 = flatMapper2.apply(t2);
                if (!N.notNullOrEmpty(c3)) continue;
                for (T3 t3 : c3) {
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <A, B, E extends Exception> void forEach(A[] a, B[] b, Try.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            action.accept(a[i], b[i]);
        }
    }

    public static <A, B, E extends Exception> void forEach(Collection<A> a, Collection<B> b, Try.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return;
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        int minLen = N.min(a.size(), b.size());
        for (int i = 0; i < minLen; ++i) {
            action.accept(iterA.next(), iterB.next());
        }
    }

    public static <A, B, C, E extends Exception> void forEach(A[] a, B[] b, C[] c, Try.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return;
        }
        int minLen = N.min(a.length, b.length, c.length);
        for (int i = 0; i < minLen; ++i) {
            action.accept(a[i], b[i], c[i]);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Collection<A> a, Collection<B> b, Collection<C> c, Try.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return;
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        Iterator<C> iterC = c.iterator();
        int minLen = N.min(a.size(), b.size(), c.size());
        for (int i = 0; i < minLen; ++i) {
            action.accept(iterA.next(), iterB.next(), iterC.next());
        }
    }

    public static <A, B, E extends Exception> void forEach(A[] a, B[] b, A valueForNoneA, B valueForNoneB, Try.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int maxLen = N.max(lenA, lenB);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB);
        }
    }

    public static <A, B, E extends Exception> void forEach(Collection<A> a, Collection<B> b, A valueForNoneA, B valueForNoneB, Try.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int maxLen = N.max(lenA, lenB);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(A[] a, B[] b, C[] c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Try.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int lenC = N.len(c);
        int maxLen = N.max(lenA, lenB, lenC);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB, i < lenC ? c[i] : valueForNoneC);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Collection<A> a, Collection<B> b, Collection<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Try.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = c == null ? ObjIterator.empty() : c.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int lenC = N.size(c);
        int maxLen = N.max(lenA, lenB, lenC);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB, i < lenC ? iterC.next() : valueForNoneC);
        }
    }

    public static <T, E extends Exception> void forEachNonNull(T[] a, Try.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            if (e == null) continue;
            action.accept(e);
        }
    }

    public static <T, E extends Exception> void forEachNonNull(Collection<T> c, Try.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            if (e == null) continue;
            action.accept(e);
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEachNonNull(T[] a, Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            Collection<U> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (U u2 : c2) {
                if (u2 == null) continue;
                action.accept(e, u2);
            }
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEachNonNull(Collection<T> c, Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            Collection<U> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (U u2 : c2) {
                if (u2 == null) continue;
                action.accept(e, u2);
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEachNonNull(T[] a, Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            Collection<T2> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3;
                if (t2 == null || !N.notNullOrEmpty(c3 = flatMapper2.apply(t2))) continue;
                for (T3 t3 : c3) {
                    if (t3 == null) continue;
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEachNonNull(Collection<T> c, Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            Collection<T2> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3;
                if (t2 == null || !N.notNullOrEmpty(c3 = flatMapper2.apply(t2))) continue;
                for (T3 t3 : c3) {
                    if (t3 == null) continue;
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <T, E extends Exception> List<T> filter(T[] a, Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.filter(a, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(T[] a, Try.Predicate<? super T, E> filter, int max) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <T, E extends Exception> List<T> filter(T[] a, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(T[] a, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(N.min(9, max, toIndex - fromIndex));
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            result.add(a[i]);
            ++cnt;
        }
        return result;
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.filter(c, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, Try.Predicate<? super T, E> filter, int max) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.filter(c, 0, c.size(), filter, max);
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter) throws E {
        return N.filter(c, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(N.min(9, max, toIndex - fromIndex));
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Object e = null;
            int cnt = 0;
            for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
                e = list.get(i);
                if (!filter.test(e)) continue;
                result.add(e);
                ++cnt;
            }
        } else {
            int idx = 0;
            int cnt = 0;
            for (T e : c) {
                if (cnt >= max) break;
                if (idx++ < fromIndex) continue;
                if (filter.test(e)) {
                    result.add(e);
                    ++cnt;
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, Try.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(a, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, Try.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(a, 0, a.length, filter, max, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return (R)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(N.min(9, max, toIndex - fromIndex));
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            result.add(a[i]);
            ++cnt;
        }
        return (R)result;
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, Try.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(c, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, Try.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(c, 0, c.size(), filter, max, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        return N.filter(c, fromIndex, toIndex, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return (R)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(N.min(9, max, toIndex - fromIndex));
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex && fromIndex < c.size()) {
            return (R)result;
        }
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Object e = null;
            int cnt = 0;
            for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
                e = list.get(i);
                if (!filter.test(e)) continue;
                result.add(e);
                ++cnt;
            }
        } else {
            int idx = 0;
            int cnt = 0;
            for (T e : c) {
                if (cnt >= max) break;
                if (idx++ < fromIndex) continue;
                if (filter.test(e)) {
                    result.add(e);
                    ++cnt;
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return (R)result;
    }

    public static <T, R, E extends Exception> List<R> map(T[] a, Try.Function<? super T, ? extends R, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.map(a, 0, a.length, func);
    }

    public static <T, R, E extends Exception> List<R> map(T[] a, int fromIndex, int toIndex, Try.Function<? super T, ? extends R, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        ArrayList<R> result = new ArrayList<R>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(func.apply(a[i]));
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> map(Collection<? extends T> c, Try.Function<? super T, ? extends R, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.map(c, 0, c.size(), func);
    }

    public static <T, R, E extends Exception> List<R> map(Collection<? extends T> c, int fromIndex, int toIndex, Try.Function<? super T, ? extends R, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return new ArrayList();
        }
        ArrayList<R> result = new ArrayList<R>(toIndex - fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result.add(func.apply(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result.add(func.apply(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(T[] a, Try.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.map(a, 0, a.length, func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(T[] a, int fromIndex, int toIndex, Try.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(func.apply(a[i]));
        }
        return (C)result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(Collection<? extends T> c, Try.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.map(c, 0, c.size(), func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(Collection<? extends T> c, int fromIndex, int toIndex, Try.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result.add(func.apply(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result.add(func.apply(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return (C)result;
    }

    public static <T, R, E extends Exception> List<R> flatMap(T[] a, Try.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.flatMap(a, 0, a.length, func);
    }

    public static <T, R, E extends Exception> List<R> flatMap(T[] a, int fromIndex, int toIndex, Try.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        ArrayList<? extends R> result = new ArrayList<R>(toIndex - fromIndex);
        Collection<? extends R> mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(mr);
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> flatMap(Collection<? extends T> c, Try.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.flatMap(c, 0, c.size(), func);
    }

    public static <T, R, E extends Exception> List<R> flatMap(Collection<? extends T> c, int fromIndex, int toIndex, Try.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return new ArrayList();
        }
        ArrayList<Object> result = new ArrayList<Object>(toIndex - fromIndex);
        Collection<Object> mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(mr);
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(mr);
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(T[] a, Try.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flatMap(a, 0, a.length, func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(T[] a, int fromIndex, int toIndex, Try.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        Collection<? extends R> mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(mr);
        }
        return (C)result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(Collection<? extends T> c, Try.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flatMap(c, 0, c.size(), func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(Collection<? extends T> c, int fromIndex, int toIndex, Try.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        Collection<Object> mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(mr);
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(mr);
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return (C)result;
    }

    public static <T, T2, R, C extends Collection<R>, E extends Exception, E2 extends Exception> List<R> flatMap(T[] a, Try.Function<? super T, ? extends Collection<? extends T2>, E> func, Try.Function<? super T2, ? extends Collection<? extends R>, E2> func2) throws E, E2 {
        return N.flatMap(a, func, func2, Fn.Factory.ofList());
    }

    public static <T, T2, R, C extends Collection<R>, E extends Exception, E2 extends Exception> C flatMap(T[] a, Try.Function<? super T, ? extends Collection<? extends T2>, E> func, Try.Function<? super T2, ? extends Collection<? extends R>, E2> func2, IntFunction<? extends C> supplier) throws E, E2 {
        N.checkArgNotNull(func);
        N.checkArgNotNull(func2);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(a.length);
        for (T e : a) {
            Collection<T2> c1 = func.apply(e);
            if (!N.notNullOrEmpty(c1)) continue;
            for (T2 e2 : c1) {
                Collection<? extends R> c2 = func2.apply(e2);
                if (!N.notNullOrEmpty(c2)) continue;
                result.addAll(c2);
            }
        }
        return (C)result;
    }

    public static <T, T2, R, C extends Collection<R>, E extends Exception, E2 extends Exception> List<R> flatMap(Collection<? extends T> c, Try.Function<? super T, ? extends Collection<? extends T2>, E> func, Try.Function<? super T2, ? extends Collection<? extends R>, E2> func2) throws E, E2 {
        return N.flatMap(c, func, func2, Fn.Factory.ofList());
    }

    public static <T, T2, R, C extends Collection<R>, E extends Exception, E2 extends Exception> C flatMap(Collection<? extends T> c, Try.Function<? super T, ? extends Collection<? extends T2>, E> func, Try.Function<? super T2, ? extends Collection<? extends R>, E2> func2, IntFunction<? extends C> supplier) throws E, E2 {
        N.checkArgNotNull(func);
        N.checkArgNotNull(func2);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(c.size());
        for (T e : c) {
            Collection<T2> c1 = func.apply(e);
            if (!N.notNullOrEmpty(c1)) continue;
            for (T2 e2 : c1) {
                Collection<? extends R> c2 = func2.apply(e2);
                if (!N.notNullOrEmpty(c2)) continue;
                result.addAll(c2);
            }
        }
        return (C)result;
    }

    public static <T, R, E extends Exception> List<R> flattMap(T[] a, Try.Function<? super T, ? extends R[], E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.flattMap(a, 0, a.length, func);
    }

    public static <T, R, E extends Exception> List<R> flattMap(T[] a, int fromIndex, int toIndex, Try.Function<? super T, ? extends R[], E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        ArrayList<Object> result = new ArrayList<Object>(toIndex - fromIndex);
        Object[] mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(Arrays.asList(mr));
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> flattMap(Collection<? extends T> c, Try.Function<? super T, ? extends R[], E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.flattMap(c, 0, c.size(), func);
    }

    public static <T, R, E extends Exception> List<R> flattMap(Collection<? extends T> c, int fromIndex, int toIndex, Try.Function<? super T, ? extends R[], E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return new ArrayList();
        }
        ArrayList<Object> result = new ArrayList<Object>(toIndex - fromIndex);
        Object[] mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(Arrays.asList(mr));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(Arrays.asList(mr));
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(T[] a, Try.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flattMap(a, 0, a.length, func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(T[] a, int fromIndex, int toIndex, Try.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        Object[] mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(Arrays.asList(mr));
        }
        return (C)result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(Collection<? extends T> c, Try.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flattMap(c, 0, c.size(), func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(Collection<? extends T> c, int fromIndex, int toIndex, Try.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        Object[] mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(Arrays.asList(mr));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(Arrays.asList(mr));
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return (C)result;
    }

    public static <T extends Number> int sumInt(T[] a) {
        return N.sumInt(a, Fn.numToInt());
    }

    public static <T extends Number> int sumInt(T[] a, int fromIndex, int toIndex) {
        return N.sumInt(a, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> int sumInt(T[] a, Try.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sumInt(a, 0, a.length, func);
    }

    public static <T, E extends Exception> int sumInt(T[] a, int fromIndex, int toIndex, Try.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += func.applyAsInt(a[i]);
        }
        return sum;
    }

    public static <T extends Number> int sumInt(Collection<? extends T> c) {
        return N.sumInt(c, Fn.numToInt());
    }

    public static <T extends Number> int sumInt(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.sumInt(c, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> int sumInt(Collection<? extends T> c, Try.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0;
        }
        int sum = 0;
        for (T e : c) {
            sum += func.applyAsInt(e);
        }
        return sum;
    }

    public static <T, E extends Exception> int sumInt(Collection<? extends T> c, int fromIndex, int toIndex, Try.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                sum += func.applyAsInt(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                sum += func.applyAsInt(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return sum;
    }

    public static <T extends Number> long sumLong(T[] a) {
        return N.sumLong(a, Fn.numToLong());
    }

    public static <T extends Number> long sumLong(T[] a, int fromIndex, int toIndex) {
        return N.sumLong(a, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> long sumLong(T[] a, Try.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0L;
        }
        return N.sumLong(a, 0, a.length, func);
    }

    public static <T, E extends Exception> long sumLong(T[] a, int fromIndex, int toIndex, Try.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0L;
        }
        long sum = 0L;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += func.applyAsLong(a[i]);
        }
        return sum;
    }

    public static <T extends Number> long sumLong(Collection<? extends T> c) {
        return N.sumLong(c, Fn.numToLong());
    }

    public static <T extends Number> long sumLong(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.sumLong(c, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> long sumLong(Collection<? extends T> c, Try.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0L;
        }
        long sum = 0L;
        for (T e : c) {
            sum += func.applyAsLong(e);
        }
        return sum;
    }

    public static <T, E extends Exception> long sumLong(Collection<? extends T> c, int fromIndex, int toIndex, Try.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0L;
        }
        long sum = 0L;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                sum += func.applyAsLong(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                sum += func.applyAsLong(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return sum;
    }

    public static <T extends Number> double sumDouble(T[] a) {
        return N.sumDouble(a, Fn.numToDouble());
    }

    public static <T extends Number> double sumDouble(T[] a, int fromIndex, int toIndex) {
        return N.sumDouble(a, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> double sumDouble(T[] a, Try.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.sumDouble(a, 0, a.length, func);
    }

    public static <T, E extends Exception> double sumDouble(T[] a, int fromIndex, int toIndex, Try.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(func.applyAsDouble(a[i]));
        }
        return summation.sum();
    }

    public static <T extends Number> double sumDouble(Collection<? extends T> c) {
        return N.sumDouble(c, Fn.numToDouble());
    }

    public static <T extends Number> double sumDouble(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.sumDouble(c, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> double sumDouble(Collection<? extends T> c, Try.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (T e : c) {
            summation.add(func.applyAsDouble(e));
        }
        return summation.sum();
    }

    public static <T, E extends Exception> double sumDouble(Collection<? extends T> c, int fromIndex, int toIndex, Try.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                summation.add(func.applyAsDouble(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                summation.add(func.applyAsDouble(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return summation.sum();
    }

    public static <T extends Number> u.OptionalDouble averageInt(T[] a) {
        return N.averageInt(a, Fn.numToInt());
    }

    public static <T extends Number> u.OptionalDouble averageInt(T[] a, int fromIndex, int toIndex) {
        return N.averageInt(a, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(T[] a, Try.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalDouble.empty();
        }
        return N.averageInt(a, 0, a.length, func);
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(T[] a, int fromIndex, int toIndex, Try.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumInt(a, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageInt(Collection<? extends T> c) {
        return N.averageInt(c, Fn.numToInt());
    }

    public static <T extends Number> u.OptionalDouble averageInt(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.averageInt(c, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(Collection<? extends T> c, Try.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumInt(c, func) / (double)c.size());
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(Collection<? extends T> c, int fromIndex, int toIndex, Try.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumInt(c, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageLong(T[] a) {
        return N.averageLong(a, Fn.numToLong());
    }

    public static <T extends Number> u.OptionalDouble averageLong(T[] a, int fromIndex, int toIndex) {
        return N.averageLong(a, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(T[] a, Try.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalDouble.empty();
        }
        return N.averageLong(a, 0, a.length, func);
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(T[] a, int fromIndex, int toIndex, Try.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumLong(a, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageLong(Collection<? extends T> c) {
        return N.averageLong(c, Fn.numToLong());
    }

    public static <T extends Number> u.OptionalDouble averageLong(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.averageLong(c, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(Collection<? extends T> c, Try.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumLong(c, func) / (double)c.size());
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(Collection<? extends T> c, int fromIndex, int toIndex, Try.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumLong(c, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageDouble(T[] a) {
        return N.averageDouble(a, Fn.numToDouble());
    }

    public static <T extends Number> u.OptionalDouble averageDouble(T[] a, int fromIndex, int toIndex) {
        return N.averageDouble(a, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(T[] a, Try.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalDouble.empty();
        }
        return N.averageDouble(a, 0, a.length, func);
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(T[] a, int fromIndex, int toIndex, Try.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(func.applyAsDouble(a[i]));
        }
        return summation.average();
    }

    public static <T extends Number> u.OptionalDouble averageDouble(Collection<? extends T> c) {
        return N.averageDouble(c, Fn.numToDouble());
    }

    public static <T extends Number> u.OptionalDouble averageDouble(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.averageDouble(c, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(Collection<? extends T> c, Try.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalDouble.empty();
        }
        KahanSummation summation = new KahanSummation();
        for (T e : c) {
            summation.add(func.applyAsDouble(e));
        }
        return summation.average();
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(Collection<? extends T> c, int fromIndex, int toIndex, Try.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        KahanSummation summation = new KahanSummation();
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                summation.add(func.applyAsDouble(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                summation.add(func.applyAsDouble(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return summation.average();
    }

    public static <E extends Exception> int count(boolean[] a, Try.BooleanPredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(boolean[] a, int fromIndex, int toIndex, Try.BooleanPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(char[] a, Try.CharPredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(char[] a, int fromIndex, int toIndex, Try.CharPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(byte[] a, Try.BytePredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(byte[] a, int fromIndex, int toIndex, Try.BytePredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(short[] a, Try.ShortPredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(short[] a, int fromIndex, int toIndex, Try.ShortPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(int[] a, Try.IntPredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(int[] a, int fromIndex, int toIndex, Try.IntPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(long[] a, Try.LongPredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(long[] a, int fromIndex, int toIndex, Try.LongPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(float[] a, Try.FloatPredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(float[] a, int fromIndex, int toIndex, Try.FloatPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(double[] a, Try.DoublePredicate<E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(double[] a, int fromIndex, int toIndex, Try.DoublePredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <T, E extends Exception> int count(T[] a, Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <T, E extends Exception> int count(T[] a, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <T, E extends Exception> int count(Collection<? extends T> c, Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c)) {
            return 0;
        }
        return N.count(c, 0, c.size(), filter);
    }

    public static <T, E extends Exception> int count(Collection<? extends T> c, int fromIndex, int toIndex, Try.Predicate<? super T, E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(filter);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex && fromIndex < c.size()) {
            return 0;
        }
        int count = 0;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                if (!filter.test(list.get(i))) continue;
                ++count;
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                if (filter.test(e)) {
                    ++count;
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return count;
    }

    public static short[] top(short[] a, int n) {
        return N.top(a, n, null);
    }

    public static short[] top(short[] a, int n, Comparator<? super Short> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static short[] top(short[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static short[] top(short[] a, int fromIndex, int toIndex, int n, Comparator<? super Short> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Short> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Short> heap = new PriorityQueue<Short>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Short)heap.peek(), (Short)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Short)a[i]);
                continue;
            }
            heap.offer((Short)a[i]);
        }
        Iterator iter = heap.iterator();
        short[] res = new short[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Short)iter.next();
        }
        return res;
    }

    public static int[] top(int[] a, int n) {
        return N.top(a, n, null);
    }

    public static int[] top(int[] a, int n, Comparator<? super Integer> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static int[] top(int[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static int[] top(int[] a, int fromIndex, int toIndex, int n, Comparator<? super Integer> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Integer> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Integer> heap = new PriorityQueue<Integer>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Integer)heap.peek(), (Integer)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Integer)a[i]);
                continue;
            }
            heap.offer((Integer)a[i]);
        }
        Iterator iter = heap.iterator();
        int[] res = new int[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Integer)iter.next();
        }
        return res;
    }

    public static long[] top(long[] a, int n) {
        return N.top(a, n, null);
    }

    public static long[] top(long[] a, int n, Comparator<? super Long> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static long[] top(long[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static long[] top(long[] a, int fromIndex, int toIndex, int n, Comparator<? super Long> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_LONG_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Long> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Long> heap = new PriorityQueue<Long>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Long)heap.peek(), (Long)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Long)a[i]);
                continue;
            }
            heap.offer((Long)a[i]);
        }
        Iterator iter = heap.iterator();
        long[] res = new long[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Long)iter.next();
        }
        return res;
    }

    public static float[] top(float[] a, int n) {
        return N.top(a, n, null);
    }

    public static float[] top(float[] a, int n, Comparator<? super Float> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static float[] top(float[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static float[] top(float[] a, int fromIndex, int toIndex, int n, Comparator<? super Float> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Float> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Float> heap = new PriorityQueue<Float>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Float)heap.peek(), Float.valueOf(a[i])) >= 0) continue;
                heap.poll();
                heap.add(Float.valueOf(a[i]));
                continue;
            }
            heap.offer(Float.valueOf(a[i]));
        }
        Iterator iter = heap.iterator();
        float[] res = new float[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = ((Float)iter.next()).floatValue();
        }
        return res;
    }

    public static double[] top(double[] a, int n) {
        return N.top(a, n, null);
    }

    public static double[] top(double[] a, int n, Comparator<? super Double> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static double[] top(double[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static double[] top(double[] a, int fromIndex, int toIndex, int n, Comparator<? super Double> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Double> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Double> heap = new PriorityQueue<Double>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Double)heap.peek(), (Double)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Double)a[i]);
                continue;
            }
            heap.offer((Double)a[i]);
        }
        Iterator iter = heap.iterator();
        double[] res = new double[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Double)iter.next();
        }
        return res;
    }

    public static <T extends Comparable<T>> List<T> top(T[] a, int n) {
        return N.top(a, n, NATURAL_ORDER);
    }

    public static <T> List<T> top(T[] a, int n, Comparator<? super T> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static <T extends Comparable<T>> List<T> top(T[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, NATURAL_ORDER);
    }

    public static <T> List<T> top(T[] a, int fromIndex, int toIndex, int n, Comparator<? super T> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            return N.toList(a, fromIndex, toIndex);
        }
        Comparator comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<Object> heap = new PriorityQueue<Object>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare(heap.peek(), a[i]) >= 0) continue;
                heap.poll();
                heap.add(a[i]);
                continue;
            }
            heap.offer(a[i]);
        }
        return N.createList(heap.toArray(EMPTY_OBJECT_ARRAY));
    }

    public static <T extends Comparable<T>> List<T> top(Collection<? extends T> c, int n) {
        return N.top(c, n, null);
    }

    public static <T> List<T> top(Collection<? extends T> c, int n, Comparator<? super T> cmp) {
        return N.top(c, 0, N.size(c), n, cmp);
    }

    public static <T extends Comparable<T>> List<T> top(Collection<? extends T> c, int fromIndex, int toIndex, int n) {
        return N.top(c, fromIndex, toIndex, n, null);
    }

    public static <T> List<T> top(Collection<? extends T> c, int fromIndex, int toIndex, int n, Comparator<? super T> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            if (fromIndex == 0 && toIndex == c.size()) {
                return new ArrayList<T>(c);
            }
            ArrayList<Object> res = new ArrayList<Object>(toIndex - fromIndex);
            Iterator<T> iter = c.iterator();
            Object e = null;
            for (int i = 0; i < toIndex && iter.hasNext(); ++i) {
                e = iter.next();
                if (i < fromIndex) continue;
                res.add(e);
            }
            return res;
        }
        Comparator comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<Object> heap = new PriorityQueue<Object>(n, comparator);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Object e = null;
            for (int i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                if (heap.size() >= n) {
                    if (comparator.compare(heap.peek(), e) >= 0) continue;
                    heap.poll();
                    heap.add(e);
                    continue;
                }
                heap.offer(e);
            }
        } else {
            Iterator<T> iter = c.iterator();
            Object e = null;
            for (int i = 0; i < toIndex && iter.hasNext(); ++i) {
                e = iter.next();
                if (i < fromIndex) continue;
                if (heap.size() >= n) {
                    if (comparator.compare(heap.peek(), e) >= 0) continue;
                    heap.poll();
                    heap.add(e);
                    continue;
                }
                heap.offer(e);
            }
        }
        return N.createList(heap.toArray(EMPTY_OBJECT_ARRAY));
    }

    public static <T extends Comparable<T>> List<T> topp(T[] a, int n) {
        return N.topp(a, n, NATURAL_ORDER);
    }

    public static <T> List<T> topp(T[] a, int n, Comparator<? super T> cmp) {
        return N.topp(a, 0, N.len(a), n, cmp);
    }

    public static <T extends Comparable<T>> List<T> topp(T[] a, int fromIndex, int toIndex, int n) {
        return N.topp(a, fromIndex, toIndex, n, NATURAL_ORDER);
    }

    public static <T> List<T> topp(T[] a, int fromIndex, int toIndex, int n, final Comparator<? super T> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            return N.toList(a, fromIndex, toIndex);
        }
        Comparator<Indexed<Comparable>> comparator = cmp == null ? new Comparator<Indexed<Comparable>>(){

            @Override
            public int compare(Indexed<Comparable> o1, Indexed<Comparable> o2) {
                return N.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return cmp.compare(o1.value(), o2.value());
            }
        };
        PriorityQueue<Indexed<Comparable>> heap = new PriorityQueue<Indexed<Comparable>>(n, comparator);
        Indexed<T> indexed = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            indexed = Indexed.of(a[i], i);
            if (heap.size() >= n) {
                if (comparator.compare((Indexed<Comparable>)heap.peek(), (Indexed<Comparable>)indexed) >= 0) continue;
                heap.poll();
                heap.add(indexed);
                continue;
            }
            heap.offer(indexed);
        }
        Indexed[] arrayOfIndexed = heap.toArray(new Indexed[heap.size()]);
        N.sort(arrayOfIndexed, new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return o1.index() - o2.index();
            }
        });
        ArrayList res = new ArrayList(arrayOfIndexed.length);
        int len = arrayOfIndexed.length;
        for (int i = 0; i < len; ++i) {
            res.add(arrayOfIndexed[i].value());
        }
        return res;
    }

    public static <T extends Comparable<T>> List<T> topp(Collection<? extends T> c, int n) {
        return N.topp(c, n, null);
    }

    public static <T> List<T> topp(Collection<? extends T> c, int n, Comparator<? super T> cmp) {
        return N.topp(c, 0, N.size(c), n, cmp);
    }

    public static <T extends Comparable<T>> List<T> topp(Collection<? extends T> c, int fromIndex, int toIndex, int n) {
        return N.topp(c, fromIndex, toIndex, n, null);
    }

    public static <T> List<T> topp(Collection<? extends T> c, int fromIndex, int toIndex, int n, final Comparator<? super T> cmp) {
        int i;
        Object e;
        Indexed<Object> indexed;
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            if (fromIndex == 0 && toIndex == c.size()) {
                return new ArrayList<T>(c);
            }
            ArrayList<Object> res = new ArrayList<Object>(toIndex - fromIndex);
            Iterator<T> iter = c.iterator();
            Object e2 = null;
            for (int i2 = 0; i2 < toIndex && iter.hasNext(); ++i2) {
                e2 = iter.next();
                if (i2 < fromIndex) continue;
                res.add(e2);
            }
            return res;
        }
        Comparator<Indexed<Comparable>> comparator = cmp == null ? new Comparator<Indexed<Comparable>>(){

            @Override
            public int compare(Indexed<Comparable> o1, Indexed<Comparable> o2) {
                return N.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return cmp.compare(o1.value(), o2.value());
            }
        };
        PriorityQueue<Indexed<Comparable>> heap = new PriorityQueue<Indexed<Comparable>>(n, comparator);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            indexed = null;
            e = null;
            for (i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                indexed = Indexed.of(e, i);
                if (heap.size() >= n) {
                    if (comparator.compare((Indexed<Comparable>)heap.peek(), (Indexed<Comparable>)indexed) >= 0) continue;
                    heap.poll();
                    heap.add(indexed);
                    continue;
                }
                heap.offer(indexed);
            }
        } else {
            Iterator<T> iter = c.iterator();
            indexed = null;
            e = null;
            for (i = 0; i < toIndex && iter.hasNext(); ++i) {
                e = iter.next();
                if (i < fromIndex) continue;
                indexed = Indexed.of(e, i);
                if (heap.size() >= n) {
                    if (comparator.compare((Indexed<Comparable>)heap.peek(), (Indexed<Comparable>)indexed) >= 0) continue;
                    heap.poll();
                    heap.add(indexed);
                    continue;
                }
                heap.offer(indexed);
            }
        }
        Indexed[] arrayOfIndexed = heap.toArray(new Indexed[heap.size()]);
        N.sort(arrayOfIndexed, new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return o1.index() - o2.index();
            }
        });
        ArrayList res = new ArrayList(arrayOfIndexed.length);
        int len = arrayOfIndexed.length;
        for (int i3 = 0; i3 < len; ++i3) {
            res.add(arrayOfIndexed[i3].value());
        }
        return res;
    }

    public static boolean[] distinct(boolean[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static boolean[] distinct(boolean[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static char[] distinct(char[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static char[] distinct(char[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static byte[] distinct(byte[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static byte[] distinct(byte[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static short[] distinct(short[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static short[] distinct(short[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static int[] distinct(int[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static int[] distinct(int[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static long[] distinct(long[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static long[] distinct(long[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static float[] distinct(float[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static float[] distinct(float[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static double[] distinct(double[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static double[] distinct(double[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static <T> List<T> distinct(T[] a) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.distinct(a, 0, a.length);
    }

    public static <T> List<T> distinct(T[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        Set set = N.newHashSet();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!set.add(N.hashKey(a[i]))) continue;
            result.add(a[i]);
        }
        return result;
    }

    public static <T> List<T> distinct(Collection<? extends T> c) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.distinct(c, 0, c.size());
    }

    public static <T> List<T> distinct(Collection<? extends T> c, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return new ArrayList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Set set = N.newHashSet();
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                if (!set.add(N.hashKey(e))) continue;
                result.add(e);
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < toIndex && it.hasNext(); ++i) {
                e = it.next();
                if (i < fromIndex || !set.add(N.hashKey(e))) continue;
                result.add(e);
            }
        }
        return result;
    }

    public static <T, E extends Exception> List<T> distinctBy(T[] a, Try.Function<? super T, ?, E> keyMapper) throws E {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.distinctBy(a, 0, a.length, keyMapper);
    }

    public static <T, E extends Exception> List<T> distinctBy(T[] a, int fromIndex, int toIndex, Try.Function<? super T, ?, E> keyMapper) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        Set set = N.newHashSet();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!set.add(N.hashKey(keyMapper.apply(a[i])))) continue;
            result.add(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> distinctBy(Collection<? extends T> c, Try.Function<? super T, ?, E> keyMapper) throws E {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.distinctBy(c, 0, c.size(), keyMapper);
    }

    public static <T, E extends Exception> List<T> distinctBy(Collection<? extends T> c, int fromIndex, int toIndex, Try.Function<? super T, ?, E> keyMapper) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0) {
            return new ArrayList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Set set = N.newHashSet();
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                if (!set.add(N.hashKey(keyMapper.apply(e)))) continue;
                result.add(e);
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < toIndex && it.hasNext(); ++i) {
                e = it.next();
                if (i < fromIndex || !set.add(N.hashKey(keyMapper.apply(e)))) continue;
                result.add(e);
            }
        }
        return result;
    }

    public static String toJSON(Object obj) {
        return Utils.jsonParser.serialize(obj, Utils.jsc);
    }

    public static String toJSON(Object obj, boolean prettyFormat) {
        return Utils.jsonParser.serialize(obj, prettyFormat ? Utils.jscPrettyFormat : Utils.jsc);
    }

    public static String toJSON(Object obj, JSONSerializationConfig config) {
        return Utils.jsonParser.serialize(obj, config);
    }

    public static void toJSON(File file, Object obj) {
        Utils.jsonParser.serialize(file, obj);
    }

    public static void toJSON(File file, Object obj, JSONSerializationConfig config) {
        Utils.jsonParser.serialize(file, obj, config);
    }

    public static void toJSON(OutputStream os, Object obj) {
        Utils.jsonParser.serialize(os, obj);
    }

    public static void toJSON(OutputStream os, Object obj, JSONSerializationConfig config) {
        Utils.jsonParser.serialize(os, obj, config);
    }

    public static void toJSON(Writer writer, Object obj) {
        Utils.jsonParser.serialize(writer, obj);
    }

    public static void toJSON(Writer writer, Object obj, JSONSerializationConfig config) {
        Utils.jsonParser.serialize(writer, obj, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, File json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, File json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, InputStream json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, InputStream json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, Reader json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, Reader json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json, int fromIndex, int toIndex) {
        return Utils.jsonParser.deserialize(targetClass, json, fromIndex, toIndex);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json, int fromIndex, int toIndex, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, fromIndex, toIndex, config);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, File json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, File json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, InputStream json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, InputStream json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, Reader json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, Reader json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json, int fromIndex, int toIndex) {
        return N.fromJSON(targetType, json, fromIndex, toIndex, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json, int fromIndex, int toIndex, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, fromIndex, toIndex, N.setConfig(targetType, config, true));
    }

    public static String formatJSON(String json) {
        return N.formatJSON(Object.class, json);
    }

    public static String formatJSON(Class<?> type, String json) {
        return N.toJSON(N.fromJSON(type, json), Utils.jscPrettyFormat);
    }

    public static String formatJSON(Type<?> type, String json) {
        return N.toJSON(N.fromJSON(type, json), Utils.jscPrettyFormat);
    }

    public static String toXML(Object obj) {
        return Utils.xmlParser.serialize(obj);
    }

    public static String toXML(Object obj, boolean prettyFormat) {
        return Utils.xmlParser.serialize(obj, prettyFormat ? Utils.xscPrettyFormat : Utils.xsc);
    }

    public static String toXML(Object obj, XMLSerializationConfig config) {
        return Utils.xmlParser.serialize(obj, config);
    }

    public static void toXML(File file, Object obj) {
        Utils.xmlParser.serialize(file, obj);
    }

    public static void toXML(File file, Object obj, XMLSerializationConfig config) {
        Utils.xmlParser.serialize(file, obj, config);
    }

    public static void toXML(OutputStream os, Object obj) {
        Utils.xmlParser.serialize(os, obj);
    }

    public static void toXML(OutputStream os, Object obj, XMLSerializationConfig config) {
        Utils.xmlParser.serialize(os, obj, config);
    }

    public static void toXML(Writer writer, Object obj) {
        Utils.xmlParser.serialize(writer, obj);
    }

    public static void toXML(Writer writer, Object obj, XMLSerializationConfig config) {
        Utils.xmlParser.serialize(writer, obj, config);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, String xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, String xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, File xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, File xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, InputStream xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, InputStream xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, Reader xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, Reader xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Type<? extends T> targetType, String xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, String xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    public static <T> T fromXML(Type<? extends T> targetType, File xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, File xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    public static <T> T fromXML(Type<? extends T> targetType, InputStream xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, InputStream xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    public static <T> T fromXML(Type<? extends T> targetType, Reader xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, Reader xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    private static <C extends DeserializationConfig<C>> C setConfig(Type<?> targetType, C config, boolean isJSON) {
        Object res = config;
        if (targetType.isCollection()) {
            if (config == null || config.getElementType() == null) {
                res = config == null ? (isJSON ? JSONDeserializationConfig.JDC.create() : XMLDeserializationConfig.XDC.create()) : (DeserializationConfig)config.copy();
                ((DeserializationConfig)res).setElementType(targetType.getParameterTypes()[0]);
            }
        } else if (targetType.isMap() && (config == null || config.getMapKeyType() == null || config.getMapValueType() == null)) {
            Object object = config == null ? (isJSON ? JSONDeserializationConfig.JDC.create() : XMLDeserializationConfig.XDC.create()) : (res = (DeserializationConfig)config.copy());
            if (((DeserializationConfig)res).getMapKeyType() == null) {
                ((DeserializationConfig)res).setMapKeyType(targetType.getParameterTypes()[0]);
            }
            if (((DeserializationConfig)res).getMapValueType() == null) {
                ((DeserializationConfig)res).setMapValueType(targetType.getParameterTypes()[1]);
            }
        }
        return (C)res;
    }

    public static String xml2JSON(String xml) {
        return N.xml2JSON(Map.class, xml);
    }

    public static String xml2JSON(Class<?> cls, String xml) {
        return Utils.jsonParser.serialize(Utils.xmlParser.deserialize(cls, xml), Utils.jsc);
    }

    public static String json2XML(String json) {
        return N.json2XML(Map.class, json);
    }

    public static String json2XML(Class<?> cls, String json) {
        return Utils.xmlParser.serialize(Utils.jsonParser.deserialize(cls, json));
    }

    public static RuntimeException toRuntimeException(Throwable e) {
        return ExceptionUtil.toRuntimeException(e);
    }

    public static void sleep(long timeoutInMillis) {
        if (timeoutInMillis <= 0L) {
            return;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(timeoutInMillis);
        }
        catch (InterruptedException e) {
            throw new UncheckedException(e);
        }
    }

    public static void sleep(long timeout, TimeUnit unit) {
        N.checkArgNotNull(unit, "unit");
        if (timeout <= 0L) {
            return;
        }
        try {
            unit.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new UncheckedException(e);
        }
    }

    public static void sleepUninterruptibly(long timeoutInMillis) {
        if (timeoutInMillis <= 0L) {
            return;
        }
        boolean interrupted = false;
        try {
            long remainingNanos = TimeUnit.MILLISECONDS.toNanos(timeoutInMillis);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void sleepUninterruptibly(long timeout, TimeUnit unit) {
        N.checkArgNotNull(unit, "unit");
        if (timeout <= 0L) {
            return;
        }
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void runUninterruptibly(Try.Runnable<InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        while (true) {
            try {
                cmd.run();
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void runUninterruptibly(long timeoutInMillis, Try.LongConsumer<InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        try {
            long remainingMillis = timeoutInMillis;
            long sysMillis = System.currentTimeMillis();
            long end = remainingMillis >= Long.MAX_VALUE - sysMillis ? Long.MAX_VALUE : sysMillis + remainingMillis;
            while (true) {
                try {
                    cmd.accept(remainingMillis);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingMillis = end - System.currentTimeMillis();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void runUninterruptibly(long timeout, TimeUnit unit, Try.BiConsumer<Long, TimeUnit, InterruptedException> cmd) {
        N.checkArgNotNull(unit, "unit");
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                try {
                    cmd.accept(remainingNanos, TimeUnit.NANOSECONDS);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T callUninterruptibly(Try.Callable<T, InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        while (true) {
            try {
                T t = cmd.call();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T callUninterruptibly(long timeoutInMillis, Try.LongFunction<T, InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        try {
            long remainingMillis = timeoutInMillis;
            long sysMillis = System.currentTimeMillis();
            long end = remainingMillis >= Long.MAX_VALUE - sysMillis ? Long.MAX_VALUE : sysMillis + remainingMillis;
            while (true) {
                T t;
                try {
                    t = cmd.apply(remainingMillis);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingMillis = end - System.currentTimeMillis();
                    continue;
                }
                return t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T callUninterruptibly(long timeout, TimeUnit unit, Try.BiFunction<Long, TimeUnit, T, InterruptedException> cmd) {
        N.checkArgNotNull(unit, "unit");
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                T t;
                try {
                    t = cmd.apply(remainingNanos, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                return t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T println(T obj) {
        if (obj instanceof Collection) {
            System.out.println(Joiner.with(ELEMENT_SEPARATOR, "[", "]").reuseCachedBuffer(true).appendAll((Collection)obj));
        } else if (obj instanceof Map) {
            System.out.println(Joiner.with(ELEMENT_SEPARATOR, "=", "{", "}").reuseCachedBuffer(true).appendEntries((Map)obj));
        } else {
            System.out.println(N.toString(obj));
        }
        return obj;
    }

    @SafeVarargs
    public static <T> T[] fprintln(String format, T ... args) {
        System.out.printf(format, args);
        System.out.println();
        return args;
    }

    public static int toIntExact(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public static <T> u.Nullable<T> castIfAssignable(Object val, Class<T> targetType) {
        if (Primitives.isPrimitiveType(targetType)) {
            return val != null && Primitives.wrap(targetType).isAssignableFrom(val.getClass()) ? u.Nullable.of(val) : u.Nullable.empty();
        }
        return val == null || targetType.isAssignableFrom(val.getClass()) ? u.Nullable.of(val) : u.Nullable.empty();
    }

    public static <R> u.Nullable<R> tryOrEmpty(Callable<R> cmd) {
        try {
            return u.Nullable.of(cmd.call());
        }
        catch (Exception e) {
            return u.Nullable.empty();
        }
    }

    public static <T, R, E extends Exception> u.Nullable<R> tryOrEmpty(T init, Try.Function<? super T, R, E> func) {
        try {
            return u.Nullable.of(func.apply(init));
        }
        catch (Exception e) {
            return u.Nullable.empty();
        }
    }

    public static <R, E extends Exception> u.Nullable<R> ifOrEmpty(boolean b, Try.Supplier<R, E> supplier) throws E {
        if (b) {
            return u.Nullable.of(supplier.get());
        }
        return u.Nullable.empty();
    }

    public static <T, R, E extends Exception> u.Nullable<R> ifOrEmpty(boolean b, T init, Try.Function<? super T, R, E> func) throws E {
        if (b) {
            return u.Nullable.of(func.apply(init));
        }
        return u.Nullable.empty();
    }

    public static <E1 extends Exception, E2 extends Exception> void ifOrElse(boolean b, Try.Runnable<E1> actionForTrue, Try.Runnable<E2> actionForFalse) throws E1, E2 {
        if (b) {
            if (actionForTrue != null) {
                actionForTrue.run();
            }
        } else if (actionForFalse != null) {
            actionForFalse.run();
        }
    }

    public static <T, E1 extends Exception, E2 extends Exception> void ifOrElse(boolean b, T init, Try.Consumer<? super T, E1> actionForTrue, Try.Consumer<? super T, E2> actionForFalse) throws E1, E2 {
        if (b) {
            if (actionForTrue != null) {
                actionForTrue.accept(init);
            }
        } else if (actionForFalse != null) {
            actionForFalse.accept(init);
        }
    }

    @SafeVarargs
    public static <T> ObjIterator<T> iterate(T[] ... a) {
        return Iterators.concat(a);
    }

    @SafeVarargs
    public static <T> ObjIterator<T> iterate(Collection<? extends T> ... a) {
        return Iterators.concat(a);
    }

    public static <T> ObjIterator<T> iterate(Collection<? extends Collection<? extends T>> c) {
        return Iterators.concatt(c);
    }

    public static boolean disjoint(Object[] a, Object[] b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return true;
        }
        return a.length >= b.length ? N.disjoint(Arrays.asList(a), N.asSet(b)) : N.disjoint(N.asSet(a), Arrays.asList(b));
    }

    public static boolean disjoint(Collection<?> c1, Collection<?> c2) {
        if (N.isNullOrEmpty(c1) || N.isNullOrEmpty(c2)) {
            return true;
        }
        if (c1 instanceof Set || !(c2 instanceof Set) && c1.size() > c2.size()) {
            for (Object e : c2) {
                if (!c1.contains(e)) continue;
                return false;
            }
        } else {
            for (Object e : c1) {
                if (!c2.contains(e)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T, E extends Exception> List<T> merge(T[] a, T[] b, Try.BiFunction<? super T, ? super T, Nth, E> nextSelector) throws E {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList() : N.asList(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.asList(a);
        }
        ArrayList<T> result = new ArrayList<T>(a.length + b.length);
        int lenA = a.length;
        int lenB = b.length;
        int cursorA = 0;
        int cursorB = 0;
        while (cursorA < lenA || cursorB < lenB) {
            if (cursorA < lenA) {
                if (cursorB < lenB) {
                    if (nextSelector.apply(a[cursorA], b[cursorB]) == Nth.FIRST) {
                        result.add(a[cursorA++]);
                        continue;
                    }
                    result.add(b[cursorB++]);
                    continue;
                }
                result.add(a[cursorA++]);
                continue;
            }
            result.add(b[cursorB++]);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> merge(Collection<? extends T> a, Collection<? extends T> b, Try.BiFunction<? super T, ? super T, Nth, E> nextSelector) throws E {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList() : new ArrayList<T>(b);
        }
        if (N.isNullOrEmpty(b)) {
            return new ArrayList<T>(a);
        }
        ArrayList<T> result = new ArrayList<T>(a.size() + b.size());
        Iterator<T> iterA = a.iterator();
        Iterator<T> iterB = b.iterator();
        Object nextA = null;
        Object nextB = null;
        boolean hasNextA = false;
        boolean hasNextB = false;
        while (hasNextA || hasNextB || iterA.hasNext() || iterB.hasNext()) {
            if (hasNextA) {
                if (iterB.hasNext()) {
                    T t = iterB.next();
                    nextB = t;
                    if (nextSelector.apply(nextA, t) == Nth.FIRST) {
                        hasNextA = false;
                        hasNextB = true;
                        result.add(nextA);
                        continue;
                    }
                    result.add(nextB);
                    continue;
                }
                hasNextA = false;
                result.add(nextA);
                continue;
            }
            if (hasNextB) {
                if (iterA.hasNext()) {
                    T t = iterA.next();
                    nextA = t;
                    if (nextSelector.apply(t, nextB) == Nth.FIRST) {
                        result.add(nextA);
                        continue;
                    }
                    hasNextA = true;
                    hasNextB = false;
                    result.add(nextB);
                    continue;
                }
                hasNextB = false;
                result.add(nextB);
                continue;
            }
            if (iterA.hasNext()) {
                if (iterB.hasNext()) {
                    T t = iterA.next();
                    nextA = t;
                    T t2 = iterB.next();
                    nextB = t2;
                    if (nextSelector.apply(t, t2) == Nth.FIRST) {
                        hasNextB = true;
                        result.add(nextA);
                        continue;
                    }
                    hasNextA = true;
                    result.add(nextB);
                    continue;
                }
                result.add(iterA.next());
                continue;
            }
            result.add(iterB.next());
        }
        return result;
    }

    public static <A, B, R, E extends Exception> List<R> zip(A[] a, B[] b, Try.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        int minLen = N.min(a.length, b.length);
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(a[i], b[i]));
        }
        return result;
    }

    public static <A, B, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, Try.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        int minLen = N.min(a.size(), b.size());
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(iterA.next(), iterB.next()));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(A[] a, B[] b, C[] c, Try.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        int minLen = N.min(a.length, b.length, c.length);
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(a[i], b[i], c[i]));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, Try.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        Iterator<C> iterC = c.iterator();
        int minLen = N.min(a.size(), b.size(), c.size());
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(iterA.next(), iterB.next(), iterC.next()));
        }
        return result;
    }

    public static <A, B, R, E extends Exception> List<R> zip(A[] a, B[] b, A valueForNoneA, B valueForNoneB, Try.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        int lenA = N.len(a);
        int lenB = N.len(b);
        int maxLen = N.max(lenA, lenB);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB));
        }
        return result;
    }

    public static <A, B, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, A valueForNoneA, B valueForNoneB, Try.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int maxLen = N.max(lenA, lenB);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(A[] a, B[] b, C[] c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Try.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        int lenA = N.len(a);
        int lenB = N.len(b);
        int lenC = N.len(c);
        int maxLen = N.max(lenA, lenB, lenC);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB, i < lenC ? c[i] : valueForNoneC));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Try.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = c == null ? ObjIterator.empty() : c.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int lenC = N.size(c);
        int maxLen = N.max(lenA, lenB, lenC);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB, i < lenC ? iterC.next() : valueForNoneC));
        }
        return result;
    }

    public static <T, L, R, E extends Exception> Pair<List<L>, List<R>> unzip(Collection<? extends T> c, Try.BiConsumer<? super T, Pair<L, R>, E> unzip) throws E {
        int len = N.size(c);
        ArrayList l = new ArrayList(len);
        ArrayList r = new ArrayList(len);
        Pair p = new Pair();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, p);
                l.add(p.left);
                r.add(p.right);
            }
        }
        return Pair.of(l, r);
    }

    public static <T, L, R, LC extends Collection<L>, RC extends Collection<R>, E extends Exception> Pair<LC, RC> unzip(Collection<? extends T> c, Try.BiConsumer<? super T, Pair<L, R>, E> unzip, IntFunction<? extends Collection<?>> supplier) throws E {
        int len = N.size(c);
        Collection<?> l = supplier.apply(len);
        Collection<?> r = supplier.apply(len);
        Pair p = new Pair();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, p);
                l.add(p.left);
                r.add(p.right);
            }
        }
        return Pair.of(l, r);
    }

    public static <T, L, M, R, E extends Exception> Triple<List<L>, List<M>, List<R>> unzipp(Collection<? extends T> c, Try.BiConsumer<? super T, Triple<L, M, R>, E> unzip) throws E {
        int len = N.size(c);
        ArrayList l = new ArrayList(len);
        ArrayList m = new ArrayList(len);
        ArrayList r = new ArrayList(len);
        Triple t = new Triple();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, t);
                l.add(t.left);
                m.add(t.middle);
                r.add(t.right);
            }
        }
        return Triple.of(l, m, r);
    }

    public static <T, L, M, R, LC extends Collection<L>, MC extends Collection<M>, RC extends Collection<R>, E extends Exception> Triple<LC, MC, RC> unzipp(Collection<? extends T> c, Try.BiConsumer<? super T, Triple<L, M, R>, E> unzip, IntFunction<? extends Collection<?>> supplier) throws E {
        int len = N.size(c);
        Collection<?> l = supplier.apply(len);
        Collection<?> m = supplier.apply(len);
        Collection<?> r = supplier.apply(len);
        Triple t = new Triple();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, t);
                l.add(t.left);
                m.add(t.middle);
                r.add(t.right);
            }
        }
        return Triple.of(l, m, r);
    }
}

