/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.function.Function;

public enum NamingPolicy {
    LOWER_CAMEL_CASE(new Function<String, String>(){

        @Override
        public String apply(String str) {
            return StringUtil.toCamelCase(str);
        }
    }),
    LOWER_CASE_WITH_UNDERSCORE(new Function<String, String>(){

        @Override
        public String apply(String str) {
            return StringUtil.toLowerCaseWithUnderscore(str);
        }
    }),
    UPPER_CASE_WITH_UNDERSCORE(new Function<String, String>(){

        @Override
        public String apply(String str) {
            return StringUtil.toUpperCaseWithUnderscore(str);
        }
    });

    private final Function<String, String> converter;

    private NamingPolicy(Function<String, String> converter) {
        this.converter = converter;
    }

    public String convert(String str) {
        return this.converter.apply(str);
    }
}

