/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Primitives;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.function.Consumer;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.IntFunction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public interface NoCachingNoUpdating {

    public static abstract class DisposableEntry<K, V>
    implements Map.Entry<K, V>,
    NoCachingNoUpdating {
        public static <K, V> DisposableEntry<K, V> wrap(final Map.Entry<K, V> entry) {
            N.checkArgNotNull(entry, "entry");
            return new DisposableEntry<K, V>(){
                private final Map.Entry<K, V> e;
                {
                    this.e = entry;
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }
            };
        }

        @Override
        @Deprecated
        public V setValue(V value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public Map.Entry<K, V> copy() {
            return new AbstractMap.SimpleEntry(this.getKey(), this.getValue());
        }

        public <R> R apply(Function<? super Map.Entry<K, V>, R> func) {
            return func.apply(this);
        }

        public void accept(Consumer<? super Map.Entry<K, V>> action) {
            action.accept(this);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static class DisposableDeque<T>
    implements NoCachingNoUpdating {
        private final Deque<T> deque;

        protected DisposableDeque(Deque<T> deque) {
            N.checkArgNotNull(deque, "deque");
            this.deque = deque;
        }

        public static <T> DisposableDeque<T> wrap(Deque<T> deque) {
            return new DisposableDeque<T>(deque);
        }

        public int size() {
            return this.deque.size();
        }

        public T getFirst() {
            return this.deque.getFirst();
        }

        public T getLast() {
            return this.deque.getLast();
        }

        public <A> A[] toArray(A[] a) {
            return this.deque.toArray(a);
        }

        public List<T> toList() {
            return new ArrayList<T>(this.deque);
        }

        public <C extends Collection<T>> C toCollection(IntFunction<? extends C> supplier) {
            Collection result = (Collection)supplier.apply(this.size());
            result.addAll(this.deque);
            return (C)result;
        }

        public String join(String delimiter) {
            return StringUtil.join(this.deque, delimiter);
        }

        public <R> R apply(Function<? super Deque<T>, R> func) {
            return func.apply(this.deque);
        }

        public void accept(Consumer<? super Deque<T>> action) {
            action.accept(this.deque);
        }

        public String toString() {
            return N.toString(this.deque);
        }
    }

    public static class DisposableDoubleArray
    implements NoCachingNoUpdating {
        private final double[] a;

        protected DisposableDoubleArray(double[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableDoubleArray wrap(double[] a) {
            return new DisposableDoubleArray(a);
        }

        public double get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public double[] clone() {
            return N.clone(this.a);
        }

        public Double[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public double sum() {
            return N.sum(this.a);
        }

        public double average() {
            return N.average(this.a);
        }

        public double min() {
            return N.min(this.a);
        }

        public double max() {
            return N.max(this.a);
        }

        public <R> R apply(Function<? super double[], R> func) {
            return func.apply((double[])this.a);
        }

        public void accept(Consumer<? super double[]> action) {
            action.accept((double[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected double[] values() {
            return this.a;
        }
    }

    public static class DisposableFloatArray
    implements NoCachingNoUpdating {
        private final float[] a;

        protected DisposableFloatArray(float[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableFloatArray wrap(float[] a) {
            return new DisposableFloatArray(a);
        }

        public float get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public float[] clone() {
            return N.clone(this.a);
        }

        public Float[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public float sum() {
            return N.sum(this.a);
        }

        public double average() {
            return N.average(this.a);
        }

        public float min() {
            return N.min(this.a);
        }

        public float max() {
            return N.max(this.a);
        }

        public <R> R apply(Function<? super float[], R> func) {
            return func.apply((float[])this.a);
        }

        public void accept(Consumer<? super float[]> action) {
            action.accept((float[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected float[] values() {
            return this.a;
        }
    }

    public static class DisposableLongArray
    implements NoCachingNoUpdating {
        private final long[] a;

        protected DisposableLongArray(long[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableLongArray wrap(long[] a) {
            return new DisposableLongArray(a);
        }

        public long get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public long[] clone() {
            return N.clone(this.a);
        }

        public Long[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public long sum() {
            return N.sum(this.a);
        }

        public double average() {
            return N.average(this.a);
        }

        public long min() {
            return N.min(this.a);
        }

        public long max() {
            return N.max(this.a);
        }

        public <R> R apply(Function<? super long[], R> func) {
            return func.apply((long[])this.a);
        }

        public void accept(Consumer<? super long[]> action) {
            action.accept((long[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected long[] values() {
            return this.a;
        }
    }

    public static class DisposableIntArray
    implements NoCachingNoUpdating {
        private final int[] a;

        protected DisposableIntArray(int[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableIntArray wrap(int[] a) {
            return new DisposableIntArray(a);
        }

        public int get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public int[] clone() {
            return N.clone(this.a);
        }

        public Integer[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public int sum() {
            return N.sum(this.a);
        }

        public double average() {
            return N.average(this.a);
        }

        public int min() {
            return N.min(this.a);
        }

        public int max() {
            return N.max(this.a);
        }

        public <R> R apply(Function<? super int[], R> func) {
            return func.apply((int[])this.a);
        }

        public void accept(Consumer<? super int[]> action) {
            action.accept((int[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected int[] values() {
            return this.a;
        }
    }

    public static class DisposableShortArray
    implements NoCachingNoUpdating {
        private final short[] a;

        protected DisposableShortArray(short[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableShortArray wrap(short[] a) {
            return new DisposableShortArray(a);
        }

        public short get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public short[] clone() {
            return N.clone(this.a);
        }

        public Short[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public int sum() {
            return N.sum(this.a);
        }

        public double average() {
            return N.average(this.a);
        }

        public short min() {
            return N.min(this.a);
        }

        public short max() {
            return N.max(this.a);
        }

        public <R> R apply(Function<? super short[], R> func) {
            return func.apply((short[])this.a);
        }

        public void accept(Consumer<? super short[]> action) {
            action.accept((short[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected short[] values() {
            return this.a;
        }
    }

    public static class DisposableByteArray
    implements NoCachingNoUpdating {
        private final byte[] a;

        protected DisposableByteArray(byte[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableByteArray wrap(byte[] a) {
            return new DisposableByteArray(a);
        }

        public byte get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public byte[] clone() {
            return N.clone(this.a);
        }

        public Byte[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public int sum() {
            return N.sum(this.a);
        }

        public double average() {
            return N.average(this.a);
        }

        public byte min() {
            return N.min(this.a);
        }

        public byte max() {
            return N.max(this.a);
        }

        public <R> R apply(Function<? super byte[], R> func) {
            return func.apply((byte[])this.a);
        }

        public void accept(Consumer<? super byte[]> action) {
            action.accept((byte[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected byte[] values() {
            return this.a;
        }
    }

    public static class DisposableCharArray
    implements NoCachingNoUpdating {
        private final char[] a;

        protected DisposableCharArray(char[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableCharArray wrap(char[] a) {
            return new DisposableCharArray(a);
        }

        public char get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public char[] clone() {
            return N.clone(this.a);
        }

        public Character[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public int sum() {
            return N.sum(this.a);
        }

        public double average() {
            return N.average(this.a);
        }

        public char min() {
            return N.min(this.a);
        }

        public char max() {
            return N.max(this.a);
        }

        public <R> R apply(Function<? super char[], R> func) {
            return func.apply((char[])this.a);
        }

        public void accept(Consumer<? super char[]> action) {
            action.accept((char[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected char[] values() {
            return this.a;
        }
    }

    public static class DisposableBooleanArray
    implements NoCachingNoUpdating {
        private final boolean[] a;

        protected DisposableBooleanArray(boolean[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static DisposableBooleanArray wrap(boolean[] a) {
            return new DisposableBooleanArray(a);
        }

        public boolean get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public boolean[] clone() {
            return N.clone(this.a);
        }

        public Boolean[] box() {
            return Primitives.box(this.a);
        }

        public String join(String delimiter) {
            return StringUtil.join(this.a, delimiter);
        }

        public <R> R apply(Function<? super boolean[], R> func) {
            return func.apply((boolean[])this.a);
        }

        public void accept(Consumer<? super boolean[]> action) {
            action.accept((boolean[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected boolean[] values() {
            return this.a;
        }
    }

    public static class DisposableObjArray
    extends DisposableArray<Object> {
        protected DisposableObjArray(Object[] a) {
            super(a);
        }

        public static DisposableObjArray wrap(Object[] a) {
            return new DisposableObjArray(a);
        }
    }

    public static class DisposableArray<T>
    implements NoCachingNoUpdating {
        private final T[] a;

        protected DisposableArray(T[] a) {
            N.checkArgNotNull(a, "a");
            this.a = a;
        }

        public static <T> DisposableArray<T> wrap(T[] a) {
            return new DisposableArray<T>(a);
        }

        public T get(int index) {
            return this.a[index];
        }

        public int length() {
            return this.a.length;
        }

        public <A> A[] toArray(A[] target) {
            if (target.length < this.length()) {
                target = (Object[])N.newArray(target.getClass().getComponentType(), this.length());
            }
            N.copy(this.a, 0, target, 0, this.length());
            return target;
        }

        public T[] clone() {
            return N.clone(this.a);
        }

        public List<T> toList() {
            return N.toList(this.clone());
        }

        public <C extends Collection<T>> C toCollection(IntFunction<? extends C> supplier) {
            Collection result = (Collection)supplier.apply(this.length());
            result.addAll(this.toList());
            return (C)result;
        }

        public String join(String delimiter) {
            return StringUtil.join((Object[])this.a, delimiter);
        }

        public <R> R apply(Function<? super T[], R> func) {
            return func.apply(this.a);
        }

        public void accept(Consumer<? super T[]> action) {
            action.accept((T[])this.a);
        }

        public String toString() {
            return N.toString(this.a);
        }

        protected T[] values() {
            return this.a;
        }
    }
}

